<?php

/* -----------------------------------------------------------------
 * 	$Id: shopping.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Shopping {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Shopping() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Shopping.com';
        $this->v_module_homepage = 'www.shopping.com';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'shopping.csv';
        $this->v_filename = 'shopping.php';
        $this->v_keyname = 'SHOPPING';
        $this->v_linkname = 'shopping';
        $this->v_delimiter = '|';
        $this->v_enclosure = '"';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_availability'] = 'Nein';
        if ($p_products_array['products_availability'] >= date("Y-m-d H:i:s", time()))
            $p_products_array['products_availability'] = 'Ja';
        if ((int) $p_products_array['products_availability'] == 0)
            $p_products_array['products_availability'] = 'Ja';
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, ',', '');
        $p_products_array['products_description'] = trim(no_html($p_products_array['products_description']));
        $p_products_array['products_short_description'] = trim(no_html($p_products_array['products_short_description']));
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_name'] = 'Produktname';
        $t_csv_fields_array['products_description'] = 'Produktbeschreibung';
        $t_csv_fields_array['products_price'] = 'Preis';
        $t_csv_fields_array['products_old_price'] = 'Streichpreis';
        $t_csv_fields_array['products_link'] = 'Produkt-URL';
        $t_csv_fields_array['products_image_1'] = 'Bild-URL';
        $t_csv_fields_array['products_shipping_costs'] = 'Versandkosten';
        $t_csv_fields_array['products_id'] = 'Artikelnummer(SKU)';
        $t_csv_fields_array['products_categories'] = 'Kategoriename und Unterkategoriename';
        $t_csv_fields_array['products_categories_last'] = 'Unterstes Kategorielevel';
        $t_csv_fields_array['manufacturers_name'] = 'Marke/Hersteller';
        $t_csv_fields_array['products_ean'] = 'EAN';
        $t_csv_fields_array['products_model'] = 'MPN';
        $t_csv_fields_array['products_availability'] = 'Verf�gbarkeit';
        $t_csv_fields_array['products_shippingtime'] = 'Verf�gbarkeitsdetails';
        $t_csv_fields_array['products_type'] = 'Produkttyp';
        $t_csv_fields_array['products_sex'] = 'Geschlecht';
        $t_csv_fields_array['products_color'] = 'Farbe';
        $t_csv_fields_array['products_material'] = 'Material';
        $t_csv_fields_array['products_image_2'] = 'Alternative Bild-URL 2';
        $t_csv_fields_array['products_image_3'] = 'Alternative Bild-URL 3';
        $t_csv_fields_array['products_image_4'] = 'Alternative Bild-URL 4';
        $t_csv_fields_array['products_image_5'] = 'Alternative Bild-URL 5';
        $t_csv_fields_array['products_coupon'] = 'Coupon-Code';
        $t_csv_fields_array['products_coupon_description'] = 'Coupon-Code Beschreibung';
        $t_csv_fields_array['products_properties_1'] = 'Produkteigenschaften 1. Aufz�hlungspunkt';
        $t_csv_fields_array['products_properties_2'] = 'Produkteigenschaften 2. Aufz�hlungspunkt';
        $t_csv_fields_array['products_properties_3'] = 'Produkteigenschaften 3. Aufz�hlungspunkt';
        $t_csv_fields_array['products_properties_4'] = 'Produkteigenschaften 4. Aufz�hlungspunkt';
        $t_csv_fields_array['products_properties_5'] = 'Produkteigenschaften 5. Aufz�hlungspunkt';
        $t_csv_fields_array['products_mobile_phone'] = 'Mobiltelefon';
        $t_csv_fields_array['products_mobile_phone_type'] = 'Mobiltelefon Bauart';
        $t_csv_fields_array['products_contract'] = 'Vertragstyp';
        $t_csv_fields_array['products_mobile_profile'] = 'Mobilfunk-Nutzungsprofil';
        return($t_csv_fields_array);
    }

    /*
     * this is the backup of the original data
     */

    function all_old_data() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_id'] = 'Artikelnummer(SKU)';
        $t_csv_fields_array['products_model'] = 'Bestellnummer';
        $t_csv_fields_array['products_model'] = 'MPN/ISBN';
        $t_csv_fields_array['products_ean'] = 'UPC oder EAN';
        $t_csv_fields_array['manufacturers_name'] = 'Marke/Hersteller';
        $t_csv_fields_array['products_name'] = 'Produktname';
        $t_csv_fields_array['products_link'] = 'Produkt-URL';
        $t_csv_fields_array['products_price'] = 'Preis';
        $t_csv_fields_array['products_categories_id'] = 'Kategorie-ID';
        $t_csv_fields_array['products_categories'] = 'Kategoriename und Unterkategoriename';
        $t_csv_fields_array['products_description'] = 'Produktbeschreibung';
        $t_csv_fields_array['products_shippingtime'] = 'Verf�gbarkeitsdetails';
        $t_csv_fields_array['products_properties_1'] = 'Produkteigenschaften 1. Aufz�hlungspunkt';
        $t_csv_fields_array['products_properties_2'] = 'Produkteigenschaften 2. Aufz�hlungspunkt';
        $t_csv_fields_array['products_properties_3'] = 'Produkteigenschaften 3. Aufz�hlungspunkt';
        $t_csv_fields_array['products_properties_4'] = 'Produkteigenschaften 4. Aufz�hlungspunkt';
        $t_csv_fields_array['products_properties_5'] = 'Produkteigenschaften 5. Aufz�hlungspunkt';
        $t_csv_fields_array['products_image_1'] = 'Bild-URL';
        $t_csv_fields_array['products_image_2'] = 'Alternative Bild-URLS';
        $t_csv_fields_array['products_type'] = 'Produkttyp';
        $t_csv_fields_array['products_sub_type'] = 'Untertyp';
        $t_csv_fields_array['products_style'] = 'Stil';
        $t_csv_fields_array['products_condition'] = 'Zustand';
        $t_csv_fields_array['products_sex'] = 'Geschlecht';
        $t_csv_fields_array['products_area'] = 'Bereich';
        $t_csv_fields_array['products_age_class'] = 'Altersgruppe';
        $t_csv_fields_array['products_color'] = 'Farbe';
        $t_csv_fields_array['products_material'] = 'Material';
        $t_csv_fields_array['products_format'] = 'Format';
        $t_csv_fields_array['products_sport_free_time'] = 'Sport oder Freizeit';
        $t_csv_fields_array['products_team'] = 'Team';
        $t_csv_fields_array['products_league'] = 'Liga';
        $t_csv_fields_array['products_fans'] = 'Fanartikeltyp';
        $t_csv_fields_array['products_software_platform'] = 'Softwareplattform';
        $t_csv_fields_array['products_software_platform'] = 'Softwarekategorie';
        $t_csv_fields_array['products_clock_type'] = 'Uhrenanzeigetyp';
        $t_csv_fields_array['products_mobile_phone'] = 'Mobiltelefon';
        $t_csv_fields_array['products_mobile_phone_type'] = 'Mobiltelefon Bauart';
        $t_csv_fields_array['products_contract'] = 'Vertragstyp';
        $t_csv_fields_array['products_mobile_profile'] = 'Mobilfunk-Nutzungsprofil';
        $t_csv_fields_array['products_size'] = 'Gr��e';
        $t_csv_fields_array['products_size_unit'] = 'Ma�einheit Gr��e';
        $t_csv_fields_array['products_length'] = 'Produktl�nge';
        $t_csv_fields_array['products_length_unit'] = 'Ma�einheit L�nge';
        $t_csv_fields_array['products_width'] = 'Produktbreite';
        $t_csv_fields_array['products_width_unit'] = 'Ma�einheit Breite';
        $t_csv_fields_array['products_height'] = 'Produkth�he';
        $t_csv_fields_array['products_height_unit'] = 'Ma�einheit H�he';
        $t_csv_fields_array['products_weight'] = 'Produktgewicht';
        $t_csv_fields_array['products_weight_unit'] = 'Ma�einheit Gewicht';
        $t_csv_fields_array['products_availability'] = 'Verf�gbarkeit';
        $t_csv_fields_array['products_shipping_costs'] = 'Versandkosten';
        $t_csv_fields_array['products_shipping_weight'] = 'Versandgewicht';
        $t_csv_fields_array['products_shipping_date'] = 'Voraussichtliches Versanddatum';
        $t_csv_fields_array['products_price'] = 'Sale-Preis';
        $t_csv_fields_array['products_start'] = 'Aktionsbeginn';
        $t_csv_fields_array['products_end'] = 'Aktionsende';
        $t_csv_fields_array['products_coupon'] = 'Coupon-Code';
        $t_csv_fields_array['products_coupon_description'] = 'Beschreibung';
        $t_csv_fields_array['products_discount_type'] = 'Werbe- und Sonderangebote: Typ';
        $t_csv_fields_array['products_bundle'] = 'Bundle';
        return true;
    }

}

?>