<?php

/* -----------------------------------------------------------------
 * 	$Id: idealo.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Idealo {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;
    var $v_params;

    function Idealo() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Idealo.de';
        $this->v_module_homepage = 'www.idealo.de';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'idealo.csv';
        $this->v_filename = 'idealo.php';
        $this->v_keyname = 'IDEALO';
        $this->v_linkname = 'idealo';
        $this->v_delimiter = "\t";
        $this->v_enclosure = '';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;

        $this->v_params = array('order', 'cod', 'cod_value', 'cc', 'pp', 'so', 'transfer', 'invoice', 'mb', 'cb', 'giro', 'pickup');
    }

    function formAddOn() {
        // get setup for checkboxes
        $t_setup = $this->getCheckboxSetup();
        // create checkboxes with values
        $t_addOns = '<tr>
				   <td class="dataTableContent"><b>Versandkosten</b></td>
				   <td class="dataTableContent">' . xtc_draw_checkbox_field('products_shipping_costs_order', $value = 'true', $checked = (bool) $t_setup['order'], $parameters = '') . ' Vorkasse<br>' .
                xtc_draw_checkbox_field('products_shipping_costs_cod', $value = 'true', $checked = (bool) $t_setup['cod'], $parameters = '') . ' Nachnahme ' .
                xtc_draw_input_field('products_shipping_costs_cod_value', (float) $t_setup['cod_value']) . ' Nachnahmegeb�hr<br>' .
                xtc_draw_checkbox_field('products_shipping_costs_cc', $value = 'true', $checked = (bool) $t_setup['cc'], $parameters = '') . ' Kreditkarte<br>' .
                xtc_draw_checkbox_field('products_shipping_costs_pp', $value = 'true', $checked = (bool) $t_setup['pp'], $parameters = '') . ' Paypal<br>' .
                xtc_draw_checkbox_field('products_shipping_costs_so', $value = 'true', $checked = (bool) $t_setup['so'], $parameters = '') . ' Sofort�berweisung<br>' .
                xtc_draw_checkbox_field('products_shipping_costs_transfer', $value = 'true', $checked = (bool) $t_setup['transfer'], $parameters = '') . ' Bankeinzug<br>' .
                xtc_draw_checkbox_field('products_shipping_costs_invoice', $value = 'true', $checked = (bool) $t_setup['invoice'], $parameters = '') . ' Rechnung<br>' .
                xtc_draw_checkbox_field('products_shipping_costs_mb', $value = 'true', $checked = (bool) $t_setup['mb'], $parameters = '') . ' Moneybookers<br>' .
                xtc_draw_checkbox_field('products_shipping_costs_cb', $value = 'true', $checked = (bool) $t_setup['cb'], $parameters = '') . ' Click & Buy<br>' .
                xtc_draw_checkbox_field('products_shipping_costs_giro', $value = 'true', $checked = (bool) $t_setup['giro'], $parameters = '') . ' Giropay<br>' .
                xtc_draw_checkbox_field('products_shipping_costs_pickup', $value = 'true', $checked = (bool) $t_setup['pickup'], $parameters = '') . ' Abholung</td>
				   </tr>';
        // return addon setup
        return($t_addOns);
    }

    function formatResults($p_products_array) {
        // get setup for checkboxes
        $t_setup = $this->getCheckboxSetup();
        foreach ($this->v_params as $t_name) {
            if (!empty($t_setup[$t_name])) {
                $p_products_array['products_shipping_costs_' . $t_name] = number_format((double) $p_products_array['products_shipping_costs'], 2, '.', '');
                if ($t_name == 'cod') {
                    $p_products_array['products_shipping_costs_' . $t_name] = number_format((double) $t_setup['cod_value'], 2, '.', '');
                }
            }
        }
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, '.', '');
        $t_products_shipping_costs_cod = number_format((double) $p_products_array['products_shipping_costs'] + (double) $_POST['products_shipping_costs_cod_value'], 2, '.', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, '.', '');
        $p_products_array['products_description'] = str_replace("\t", "", no_html($p_products_array['products_description']));
        $p_products_array['products_short_description'] = str_replace("\t", "", no_html($p_products_array['products_short_description']));
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_id'] = 'Artikelnummer';
        $t_csv_fields_array['products_ean'] = 'EAN';
        $t_csv_fields_array['products_model'] = 'Herstellerartikelnummer';
        $t_csv_fields_array['manufacturers_name'] = 'Herstellername';
        $t_csv_fields_array['products_name'] = 'Produktname';
        $t_csv_fields_array['products_categories'] = 'Kategorie';
        $t_csv_fields_array['products_price'] = 'Preis';
        $t_csv_fields_array['products_shippingtime'] = 'Lieferzeit';
        $t_csv_fields_array['products_link'] = 'ProduktURL';
        $t_csv_fields_array['products_image_1'] = 'BildURL';
        $t_csv_fields_array['products_shipping_costs_order'] = 'Versandkosten Vorkasse';
        $t_csv_fields_array['products_shipping_costs_cod'] = 'Versandkosten Nachnahme';
        $t_csv_fields_array['products_shipping_costs_cc'] = 'Versandkosten Kreditkarte';
        $t_csv_fields_array['products_shipping_costs_pp'] = 'Versandkosten Paypal';
        $t_csv_fields_array['products_shipping_costs_so'] = 'Versandkosten Sofort�berweisung';
        $t_csv_fields_array['products_shipping_costs_transfer'] = 'Versandkosten Bankeinzug';
        $t_csv_fields_array['products_shipping_costs_invoice'] = 'Versandkosten Rechnung';
        $t_csv_fields_array['products_shipping_costs_mb'] = 'Versandkosten Moneybookers';
        $t_csv_fields_array['products_shipping_costs_cb'] = 'Versandkosten Click & Buy';
        $t_csv_fields_array['products_shipping_costs_giro'] = 'Versandkosten Giropay';
        $t_csv_fields_array['products_shipping_costs_pickup'] = 'Versandkosten Abholung';
        $t_csv_fields_array['products_shipping_costs_comment'] = 'Versandkosten Kommentar';
        $t_csv_fields_array['products_description'] = 'Beschreibung';
        return($t_csv_fields_array);
    }

    function getCheckboxSetup() {
        $t_query = "SELECT configuration_value FROM configuration WHERE configuration_key = 'CSEO_IDEALO_CHECKBOXES'";
        $t_result = xtc_db_query($t_query);
        $t_setup = xtc_db_fetch_array($t_result);
        $t_setup_array = explode(";", $t_setup['onfiguration_value']);
        $t_data_array = array();
        foreach ($t_setup_array as $t_param) {
            $t_param_array = explode(":", $t_param);
            $t_key = $t_param_array[0];
            $t_value = $t_param_array[1];
            $t_data_array[$t_key] = $t_value;
        }
        return $t_data_array;
    }

}

?>