<?php

/* -----------------------------------------------------------------
 * 	$Id: carmio.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Carmio {

    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Carmio() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Carmio.de';
        $this->v_module_homepage = 'www.carmio.de';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'carmio.csv';
        $this->v_filename = 'carmio.php';
        $this->v_keyname = 'CARMIO';
        $this->v_linkname = 'carmio';
        $this->v_delimiter = ";";
        $this->v_enclosure = '"';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_compatibility'] = $p_products_array['products_ean'];
        $p_products_array['listing_type'] = '1';
        $p_products_array['tecDoc'] = '0';
        $p_products_array['products_condition'] = '1';
        $p_products_array['products_in_change'] = '1';
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        $p_products_array['products_shipping_costs_vk'] = number_format((double) $p_products_array['products_shipping_costs'], 2, ',', '');
        $p_products_array['products_weight'] = number_format((double) $p_products_array['products_weight'], 2, ',', '');
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_id'] = 'Artikelnummer';
        $t_csv_fields_array['manufacturers_name'] = 'Hersteller';
        $t_csv_fields_array['products_model'] = 'Teilenummer';
        $t_csv_fields_array['products_ean'] = 'EAN-Nummer';
        $t_csv_fields_array['products_oe'] = 'OE-Vergleichsnummern';
        $t_csv_fields_array['products_name'] = 'Produktname';
        $t_csv_fields_array['products_compatibility'] = 'Kompatibilität';
        $t_csv_fields_array['products_price'] = 'Preis';
        $t_csv_fields_array['products_categories'] = 'Kategorie';
        $t_csv_fields_array['products_image_1'] = 'BildURL(groß)';
        $t_csv_fields_array['products_description'] = 'Produktbeschreibung';
        $t_csv_fields_array['products_link'] = 'ProduktURL';
        $t_csv_fields_array['products_condition'] = 'Zustand';
        $t_csv_fields_array['products_in_change'] = 'Im Austausch';
        $t_csv_fields_array['listing_type'] = 'Angebotsformat';
        $t_csv_fields_array['products_shipping_costs_vk'] = 'Versandkosten VK';
        $t_csv_fields_array['products_shipping_costs_nn'] = 'Versandkosten NN';
        $t_csv_fields_array['products_shipping_costs_kk'] = 'Versandkosten KK';
        $t_csv_fields_array['products_shipping_costs_pp'] = 'Versandkosten PP';
        $t_csv_fields_array['products_weight'] = 'Gewicht';
        $t_csv_fields_array['tecDoc'] = 'TecDoc Daten';
        $t_csv_fields_array['products_shippingtime'] = 'Lieferzeit';
        return($t_csv_fields_array);
    }

}

?>