<?php

/* -----------------------------------------------------------------
 * 	$Id: affilinet.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Affilinet {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Affilinet() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'affiliate';
        $this->v_module_name = 'AffiliNet';
        $this->v_module_homepage = 'www.affili.net';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'affilinet.csv';
        $this->v_filename = 'affilinet.php';
        $this->v_keyname = 'AFFILINET';
        $this->v_linkname = 'affilinet';
        $this->v_delimiter = '|';
        $this->v_enclosure = '"';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_short_description'] = str_replace("\t", "", no_html($p_products_array['products_short_description']));
        if (strlen($p_products_array['products_short_description']) > 500) {
            $p_products_array['products_short_description'] = substr($p_products_array['products_short_description'], 0, strpos($p_products_array['products_description'], ' ', 490)) . '...';
        }
        $p_products_array['products_description'] = str_replace("\t", "", no_html($p_products_array['products_description']));
        if (strlen($p_products_array['products_description']) > 4500) {
            $p_products_array['products_description'] = substr($p_products_array['products_description'], 0, strpos($p_products_array['products_description'], ' ', 4490)) . '...';
        }
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, '.', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, '.', '');
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_id'] = 'art_number';
        $t_csv_fields_array['products_categories'] = 'category';
        $t_csv_fields_array['products_name'] = 'title';
        $t_csv_fields_array['products_short_description'] = 'description_short';
        $t_csv_fields_array['products_description'] = 'description';
        $t_csv_fields_array['products_price'] = 'price';
        $t_csv_fields_array['products_old_price'] = 'price_old';
        $t_csv_fields_array['products_currency'] = 'currency';
        $t_csv_fields_array['products_image_1'] = 'img_url';
        $t_csv_fields_array['products_link'] = 'deeplink1';
        $t_csv_fields_array['manufacturers_name'] = 'manufacturer';
        $t_csv_fields_array['products_start'] = 'valid_from';
        $t_csv_fields_array['products_end'] = 'valid_to';
        $t_csv_fields_array['products_ean'] = 'ean';
        $t_csv_fields_array['products_shipping_costs'] = 'shipping';
        $t_csv_fields_array['products_contract'] = 'plan';
        $t_csv_fields_array['products_mobile_profile'] = 'phone_operator';
        return($t_csv_fields_array);
    }

}

?>