<?php

/* -----------------------------------------------------------------
 * 	$Id: class.blog.php 659 2013-10-08 16:48:08Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

defined('_VALID_XTC') or die('Direct Access to this location is not allowed.');

function blogCategories($post, $action = 'insert') {
    $language = xtc_get_languages();

    if ($action == 'insert') {
        $next_query = xtc_db_query("SELECT MAX(categories_id) AS ID FROM " . TABLE_BLOG_CATEGORIES);
        $next_id = xtc_db_fetch_array($next_query);
        $next_id = $next_id['ID'];
        if ($next_id != 0 ? $next_id+=1 : $next_id = 1)
            ;
    }

    foreach ($language AS $lang) {
        $sql_categorie_array = array('language_id' => $lang['id'],
            'titel' => xtc_db_prepare_input($_POST['titel'][$lang['id']]),
            'description' => xtc_db_prepare_input($_POST['description_' . $lang['id']]),
            'position' => xtc_db_prepare_input($_POST['position'][$lang['id']]),
            'meta_title' => xtc_db_prepare_input($_POST['meta_title'][$lang['id']]),
            'meta_desc' => xtc_db_prepare_input($_POST['meta_desc'][$lang['id']]),
            'meta_key' => xtc_db_prepare_input($_POST['meta_key'][$lang['id']]));

        if ($action == 'insert') {
            $insert_sql_data = array('categories_id' => $next_id,
                'date' => date('d.m.Y'),
                'parent_id' => xtc_db_prepare_input($_POST['parent_id'])
            );
            $sql_data_array = xtc_array_merge($sql_categorie_array, $insert_sql_data);
            xtc_db_perform(TABLE_BLOG_CATEGORIES, $sql_data_array);
        } elseif ($action == 'update') {
            $insert_sql_data = array('update_date' => date('d.m.Y'),
                'parent_id' => xtc_db_prepare_input($_POST['parent_id']),
            );
            $sql_data_array = xtc_array_merge($sql_categorie_array, $insert_sql_data);
            xtc_db_perform(TABLE_BLOG_CATEGORIES, $sql_data_array, 'update', "categories_id = '" . $post['categorie_id'] . "' and language_id = '" . $lang['id'] . "' ");
        }
    }
}

function SetFlag($post, $get) {

    $max_elements = count($post['status']);

    if ($post['set_cat_status'] == 1 || $post['set_cat_status'] == 2) {
        $update_array = array('status' => $post['set_cat_status']);
        for ($i = 0; $i < $max_elements; $i++) {
            xtc_db_perform(TABLE_BLOG_CATEGORIES, $update_array, 'update', "categories_id = '" . $post['status'][$i] . "'");
            xtc_db_perform(TABLE_BLOG_ITEMS, $update_array, 'update', "categories_id = '" . $post['status'][$i] . "'");
        }
    } elseif ($_POST['set_cat_status'] == 3) {
        for ($i = 0; $i < $max_elements; $i++) {
            xtc_db_query("DELETE FROM " . TABLE_BLOG_CATEGORIES . " WHERE categories_id = '" . $post['status'][$i] . "'");
            xtc_db_query("DELETE FROM " . TABLE_BLOG_ITEMS . " WHERE categories_id = '" . $post['status'][$i] . "'");
        }
    } elseif ($post['set_item_status'] == 1 || $post['set_item_status'] == 2) {
        $update_array = array('status' => $post['set_item_status']);
        for ($i = 0; $i < $max_elements; $i++)
            xtc_db_perform(TABLE_BLOG_ITEMS, $update_array, 'update', "item_id = '" . $post['status'][$i] . "'");
    } elseif ($_POST['set_item_status'] == 3) {
        for ($i = 0; $i < $max_elements; $i++)
            xtc_db_query("DELETE FROM " . TABLE_BLOG_ITEMS . " WHERE item_id = '" . $post['status'][$i] . "'");
    }
}

function blogItem($post, $action = 'insert') {
    $language = xtc_get_languages();

    if ($action == 'insert') {
        $next_query = xtc_db_query("SELECT MAX(item_id) AS ID FROM " . TABLE_BLOG_ITEMS);
        $next_id = xtc_db_fetch_array($next_query);
        $next_id = $next_id['ID'];
        if ($next_id != 0 ? $next_id+=1 : $next_id = 1)
            ;
    }

    foreach ($language AS $lang) {
        $sql_item_array = array('language_id' => $lang['id'],
            'categories_id' => xtc_db_prepare_input($post['categories_id']),
            'title' => xtc_db_prepare_input($post['title'][$lang['id']]),
            'name' => xtc_db_prepare_input($post['name'][$lang['id']]),
            'shortdesc' => xtc_db_prepare_input($post['shortdesc_' . $lang['id']]),
            'description' => xtc_db_prepare_input($post['description_' . $lang['id']]),
            'position' => xtc_db_prepare_input($post['position']),
            'status' => xtc_db_prepare_input($post['status']),
            'meta_title' => xtc_db_prepare_input($post['meta_title'][$lang['id']]),
            'meta_description' => xtc_db_prepare_input($post['meta_description'][$lang['id']]),
            'meta_keywords' => xtc_db_prepare_input($post['meta_keywords'][$lang['id']]),
            'lenght' => xtc_db_prepare_input($post['lenght']));

        if ($action == 'insert') {
            $insert_sql_data = array('item_id' => $next_id, 'date' => date('d.m.Y'));
            $sql_data_array = xtc_array_merge($sql_item_array, $insert_sql_data);
            xtc_db_perform(TABLE_BLOG_ITEMS, $sql_data_array, 'insert');
        } elseif ($action == 'update') {
            $insert_sql_data = array('date_update' => date('d.m.Y'));
            $sql_data_array = xtc_array_merge($sql_item_array, $insert_sql_data);
            xtc_db_perform(TABLE_BLOG_ITEMS, $sql_data_array, 'update', "item_id = '" . $post['item'] . "' and language_id = '" . $lang['id'] . "' ");
        }
    }
}

function blogStart($post, $action = 'update') {
    $language = xtc_get_languages();

    foreach ($language AS $lang) {
        $sql_item_array = array('language_id' => $lang['id'],
            'id' => '1',
            'description' => xtc_db_prepare_input($post['description_' . $lang['id']]));

        if ($action == 'update') {
            $insert_sql_data = array('date' => date('d.m.Y'));
            $sql_data_array = xtc_array_merge($sql_item_array, $insert_sql_data);
            xtc_db_perform(TABLE_BLOG_START, $sql_data_array, 'update', "id = '1' and language_id = '" . $lang['id'] . "' ");
        }
    }
}
