<?php

/* -----------------------------------------------------------------
 * 	$Id: class.sharecount.php 627 2013-09-24 15:50:27Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

// require(DIR_WS_CLASSES."class.sharecount.php");
// $obj=new shareCount(HTTP_SERVER);  //Use your website or URL
// echo "Tweets: ".$obj->get_tweets(TWITTER_URL); //to get tweets
// echo "<br>Facebook: ".$obj->get_fb(FACEBOOK_URL); //to get facebook total count (likes+shares+comments)
// echo "<br>Google+: ".$obj->get_plusones(GOOGLEPLUS_URL); //to get google plusones
// echo "<br>Pinterest: ".$obj->get_pinterest(PINTEREST_URL); //to get pinterest pins
 
class shareCount {

    private $url, $timeout;

    function __construct($url, $timeout = 10) {
        $this->url = rawurlencode($url);
        $this->timeout = $timeout;
    }

    function get_tweets($url) {
        $json_string = $this->file_get_contents_curl('http://urls.api.twitter.com/1/urls/count.json?url=' . $this->url);
        $json = json_decode($json_string, true);
        return isset($json['count']) ? intval($json['count']) : 0;
    }

    // function get_linkedin($url) {
        // $json_string = $this->file_get_contents_curl("http://www.linkedin.com/countserv/count/share?url=$this->url&format=json");
        // $json = json_decode($json_string, true);
        // return isset($json['count']) ? intval($json['count']) : 0;
    // }

    function get_fb($url) {
        $json_string = $this->file_get_contents_curl('http://api.facebook.com/restserver.php?method=links.getStats&format=json&urls=' . $this->url);
        $json = json_decode($json_string, true);
        return isset($json[0]['total_count']) ? intval($json[0]['total_count']) : 0;
    }

    function get_plusones($url) {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, "https://clients6.google.com/rpc");
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_POSTFIELDS, '[{"method":"pos.plusones.get","id":"p","params":{"nolog":true,"id":"' . rawurldecode($this->url) . '","source":"widget","userId":"@viewer","groupId":"@self"},"jsonrpc":"2.0","key":"p","apiVersion":"v1"}]');
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-type: application/json'));
        $curl_results = curl_exec($curl);
        curl_close($curl);
        $json = json_decode($curl_results, true);
        return isset($json[0]['result']['metadata']['globalCounts']['count']) ? intval($json[0]['result']['metadata']['globalCounts']['count']) : 0;
    }

    function get_pinterest($url) {
        $return_data = $this->file_get_contents_curl('http://api.pinterest.com/v1/urls/count.json?url=' . $this->url);
        $json_string = preg_replace('/^receiveCount\((.*)\)$/', "\\1", $return_data);
        $json = json_decode($json_string, true);
        return isset($json['count']) ? intval($json['count']) : 0;
    }

    private function file_get_contents_curl($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
        curl_setopt($ch, CURLOPT_FAILONERROR, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, $this->timeout);
        $cont = curl_exec($ch);
        if (curl_error($ch)) {
            die(curl_error($ch));
        }
        return $cont;
    }

}