<?php

/* -----------------------------------------------------------------
 * 	$Id: xajax.functions.php 559 2013-08-19 14:07:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */
defined("_VALID_XTC") or die("Direct access to this location isn't allowed.");

// require_once ('includes/application_top.php');
/* Staffelpreise */
$xajax->registerFunction('updateProducts');
$xajax->registerFunction('staffelAdd');
$xajax->registerFunction('staffelCancel');
$xajax->registerFunction('staffelCancelTemplate');
$xajax->registerFunction('staffelSave');
$xajax->registerFunction('firstLoad');
$xajax->registerFunction('staffelDelete');
$xajax->registerFunction('staffelEdit');
$xajax->registerFunction('staffelSaveEdit');
$xajax->registerFunction('deleteTemplate');
$xajax->registerFunction('saveTemplate');
$xajax->registerFunction('editTemplate');
$xajax->registerFunction('saveTemplateValues');
$xajax->registerFunction('editTemplateValues');
$xajax->registerFunction('loadTemplate');
$xajax->registerFunction('loadTemplateValues');

function firstLoad($pid) {
    $objResponse = new xajaxResponse();
    $objResponse = buildTemplates($objResponse, $pid);
    return update_staffel_table($pid, $objResponse);
}

function staffelCancelTemplate($StaffelId) {
    //echo $aFormValues;
    $objResponse = new xajaxResponse();
    $objResponse->assign("staffel_add_" . $StaffelId, "innerHTML", '');
    $objResponse->assign('eingabebox_' . $StaffelId, 'style.display', 'none');
    $objResponse->assign('editbox_' . $StaffelId, 'style.display', 'none');
    $objResponse->assign("fehlermeldung_" . $StaffelId, "innerHTML", '');
    $objResponse->assign("load_" . $StaffelId, "innerHTML", '');
    return $objResponse;
}

function buildTemplates($objResponse, $pid) {
    $i = 0;
    $group_query = xtc_db_query("SELECT
                           customers_status_image,
                           customers_status_id,
                           customers_status_name
                       FROM
                           " . TABLE_CUSTOMERS_STATUS . "
                       WHERE
                           language_id = '" . $_SESSION['languages_id'] . "' AND customers_status_id != '0'");
    while ($group_values = xtc_db_fetch_array($group_query)) {
        // load data into array
        $i++;
        $group_data[$i] = array('STATUS_NAME' => $group_values['customers_status_name'], 'STATUS_IMAGE' => $group_values['customers_status_image'], 'STATUS_ID' => $group_values['customers_status_id']);
    }
    for ($col = 0, $n = sizeof($group_data); $col < $n + 1; $col++) {
        if ($col != 0) {
            $tag = '';
            $tag .='<div>';
            $tag .= xtc_draw_pull_down_menu('template_drop', buildAllTemplatesDropDown(), (0 == $selectedTemplate) ? '0' : $selectedTemplate, 'id="template_drop" class="profil"');
            $tag .='&nbsp;';
            $tag .='<span class="cursor">';
            $tag .=xtc_image('images/profile_load.gif', PROFILE_WILL_LOAD, '', '', 'onclick="xajax_loadTemplate('.$group_data[$col]['STATUS_ID'].',document.getElementById(\'template_drop\').value,'.$pid.');"');
            $tag .='</span>';
            $tag .='&nbsp;';
            $tag .='<span class="cursor">';
            $tag .=xtc_image('images/profile_save.gif', PROFILE_WILL_SAVE, '', '', 'onclick="xajax_saveTemplate('.$group_data[$col]['STATUS_ID'].');"');
            $tag .='</span>';
            // $tag .='&nbsp;';
            // $tag .='<span class="cursor">';
            // $tag .=xtc_image('images/profile_edit.gif', PROFILE_WILL_RENAME, '', '', 'onclick="document.getElementById(\'templatename_edit_'.$group_data[$col]['STATUS_ID'].'\').value=\'\';xajax_editTemplate('.$group_data[$col]['STATUS_ID'].',document.getElementById(\'template_drop\').value);"');
            // $tag .='</span>';
            $tag .='&nbsp;';
            $tag .='<span class="cursor">';
            $tag .=xtc_image('images/icons/minus-circle.png', PROFILE_WILL_DELETE, '', '', 'onclick="xajax_deleteTemplate(document.getElementById(\'template_drop\').value,'.$pid.','.$group_data[$col]['STATUS_ID'].');"');
            $tag .='</span>';
            $tag .='</div>';
            $objResponse->assign("profile_" . $group_data[$col]['STATUS_ID'], "innerHTML", $tag);
        }
    }
    //echo $tag;
    //$objResponse->assign("profile","innerHTML",$tag);
    return $objResponse;
}

function saveTemplate($staffelid, $templatename = '') {
    $objResponse = new xajaxResponse();
    $objResponse->assign("staffel_add_" . $staffelid, "innerHTML", '');
    $objResponse->assign('eingabebox_' . $staffelid, 'style.display', 'inline');
    $objResponse->assign('editbox_' . $staffelid, 'style.display', 'none');
    $objResponse->assign("fehlermeldung_" . $staffelid, "innerHTML", '');
    $objResponse->assign("load_" . $staffelid, "innerHTML", '');
    return $objResponse;
}

function saveTemplateValues($staffelid, $pid, $templatename) {
    $row = xtc_db_fetch_array(xtc_db_query("SELECT COUNT(template_name) AS anzahl FROM staffel_templates WHERE template_name = '".$templatename."';"));
    $objResponse = new xajaxResponse();
    if ($row['anzahl'] == '0') {
        $data = array(
            'template_name' => $templatename
        );
        xtc_db_perform('staffel_templates', $data);
        $newTemplateId = xtc_db_insert_id();
        $staffel_query = xtc_db_query("SELECT * FROM personal_offers_by_customers_status_".$staffelid." WHERE products_id = '".$pid."' AND quantity != 1 ORDER BY quantity ASC;");
        while ($staffel_values = xtc_db_fetch_array($staffel_query)) {
            $data = array(
                'template_id' => $newTemplateId,
                'quantity' => $staffel_values['quantity'],
                'personal_offer' => $staffel_values['personal_offer'],
            );
            xtc_db_perform('staffel_to_templates', $data);
        }
        $objResponse = buildTemplates($objResponse, $pid);
        $objResponse->assign('eingabebox_' . $staffelid, 'style.display', 'none');
        $objResponse->assign('editbox_' . $staffelid, 'style.display', 'none');
        $fehlermeldung = STAFFEL_ERROR_MESSAGE_9_0 . $templatename . STAFFEL_ERROR_MESSAGE_9_1;
    } else {
        $fehlermeldung = STAFFEL_ERROR_MESSAGE_10_0 . $templatename . STAFFEL_ERROR_MESSAGE_10_1;
    }
    $objResponse->assign("fehlermeldung_" . $staffelid, "innerHTML", $fehlermeldung);
    return $objResponse;
}

function editTemplate($staffelid, $templateid) {
    $objResponse = new xajaxResponse();
    if ($templateid == '0') {
        $fehlermeldung .= STAFFEL_ERROR_MESSAGE_11;
        $objResponse->assign("fehlermeldung_" . $staffelid, "innerHTML", $fehlermeldung);
    } else {
        $objResponse->assign("fehlermeldung_" . $staffelid, "innerHTML", '');
        $objResponse->assign('editbox_' . $staffelid, 'style.display', 'inline');
        $objResponse->assign('editbox_' . $staffelid, 'value', 'yy');
    }
    $objResponse->assign('eingabebox_' . $staffelid, 'style.display', 'none');
    $objResponse->assign("load_" . $staffelid, "innerHTML", '');
    $objResponse->assign("staffel_add_" . $staffelid, "innerHTML", '');
    return $objResponse;
}

function editTemplateValues($staffelid, $pid, $templatename, $templateid) {
    $row = xtc_db_fetch_array(xtc_db_query("SELECT COUNT(template_name) AS anzahl FROM staffel_templates WHERE template_name = '".$templatename."' AND template_id != '".$templateid."';"));
    $objResponse = new xajaxResponse();
    if ($row['anzahl'] == '0') {
        $data = array(
            'template_name' => $templatename
        );
        xtc_db_perform('staffel_templates', $data, 'update', "template_id = '$templateid'");

        $objResponse = buildTemplates($objResponse, $pid);
        $objResponse->assign('eingabebox_' . $staffelid, 'style.display', 'none');
        $objResponse->assign('editbox_' . $staffelid, 'style.display', 'inline');
        $fehlermeldung = STAFFEL_ERROR_MESSAGE_12_0 . $templatename . STAFFEL_ERROR_MESSAGE_12_1;
    } else {
        $fehlermeldung = STAFFEL_ERROR_MESSAGE_10_0 . $templatename . STAFFEL_ERROR_MESSAGE_10_1;
    }
    $objResponse->assign("fehlermeldung_" . $staffelid, "innerHTML", $fehlermeldung);
    return $objResponse;
}

function loadTemplateValues($staffelid, $templateid, $pid) {
    $objResponse = new xajaxResponse();
    xtc_db_query("DELETE FROM personal_offers_by_customers_status_" . $staffelid . " WHERE  products_id = '".$pid."';");
    $res = xtc_db_query("SELECT * FROM staffel_to_templates WHERE template_id = '" . $templateid . "' ORDER BY quantity, personal_offer;");
    while ($row = xtc_db_fetch_array($res))
        $results[] = $row;
    $tag = '';
    foreach ($results as $res) {
        xtc_db_query("INSERT INTO personal_offers_by_customers_status_" . $staffelid . "
					 SET price_id       = '',
						 products_id    = '" . $pid . "',
						 quantity       = '" . $res['quantity'] . "',
						 personal_offer = '" . $res['personal_offer'] . "'");
    }
    $fehlermeldung .= STAFFEL_ERROR_MESSAGE_13;
    $objResponse->assign("fehlermeldung_" . $staffelid, "innerHTML", $fehlermeldung);
    $objResponse->assign("load_" . $staffelid, "innerHTML", '');
    $objResponse = update_staffel_table($pid, $objResponse);
    return $objResponse;
}

function loadTemplate($staffelid, $templateid, $pid) {
    $objResponse = new xajaxResponse();
    if ($templateid == '0') {
        $fehlermeldung .= PROFILE_SELECT;
        $objResponse->assign("fehlermeldung_" . $staffelid, "innerHTML", $fehlermeldung);
    } else {
        $res = xtc_db_query("SELECT * FROM staffel_to_templates WHERE template_id = '".$templateid."' ORDER BY quantity, personal_offer;");
        while ($row = xtc_db_fetch_array($res))
            $results[] = $row;
        $tag = '';
        $tag .= '<div class="tableMain">';
        $tag .= '<div class="td">' . STAFFEL_QUANTITY . '</div>';
        $tag .= '<div>' . STAFFEL_PRICE . '</div>';
        $tag .= '</div>';
        foreach ($results as $res) {
            $tag .= '<div class="column">';
            $tag .= '<div class="td">';
            $tag .= $res['quantity'];
            $tag .= '</div>';
            $tag .= '<div>';
            $tag .= $res['personal_offer'];
            $tag .= '</div>';
            $tag .= '</div>';
        }
        $fehlermeldung = STAFFEL_ERROR_MESSAGE_14;
        $fehlermeldung .= '<div>' . STAFFEL_ERROR_MESSAGE_15 . '';
        $fehlermeldung .= '<span class="cursor"><img src="images/tick.gif" alt="' . PROFILE_CONFIRM . '" title=" ' . PROFILE_CONFIRM . ' " onclick="xajax_loadTemplateValues(' . $staffelid . ',' . $templateid . ',' . $pid . ');" height="16" width="16"></span><span class="cursor"><img src="images/icons/minus-circle.png"  alt="' . STAFFEL_CANCEL . '" title=" ' . STAFFEL_CANCEL . ' " onclick="xajax_staffelCancelTemplate(' . $staffelid . ');" height="16" width="16"></span></div>';
        $objResponse->assign("fehlermeldung_" . $staffelid, "innerHTML", $fehlermeldung);
        $objResponse->assign('editbox_' . $staffelid, 'style.display', 'none');
        $objResponse->assign("load_" . $staffelid, "innerHTML", $tag);
    }
    $objResponse->assign("staffel_add_" . $staffelid, "innerHTML", '');
    return $objResponse;
}

function deleteTemplate($templateId, $pid, $staffelid) {
    $objResponse = new xajaxResponse();
    xtc_db_query("DELETE FROM staffel_templates WHERE template_id = '".$templateId."';");
    xtc_db_query("DELETE FROM staffel_to_templates WHERE template_id = '".$templateId."';");
    $fehlermeldung = STAFFEL_ERROR_MESSAGE_16;
    $objResponse->assign("fehlermeldung_" . $staffelid, "innerHTML", $fehlermeldung);
    $objResponse->assign("load_" . $staffelid, "innerHTML", '');
    $objResponse->assign('editbox_' . $staffelid, 'style.display', 'none');
    $objResponse->assign('eingabebox_' . $staffelid, 'style.display', 'none');
    $objResponse->assign("staffel_add_" . $staffelid, "innerHTML", '');
    $objResponse = buildTemplates($objResponse, $pid);
    return $objResponse;
}

function getAllTemplatesAndGroupPrices() {
    //if(0 === count($this->arrAllTemplatesAndAttributes)) {
    $results = array();
    $arrAllTemplatesAndAttributes = array();
    $res = xtc_db_query("SELECT * FROM staffel_templates st LEFT JOIN staffel_to_templates stt USING(template_id) ORDER BY st.template_id, stt.quantity, stt.personal_offer;");
    while ($row = xtc_db_fetch_array($res))
        $results[] = $row;
    $templateID = null;
    foreach ($results as $res) {
        if ($templateID != $res['template_id']) {
            $templateID = $res['template_id'];
            $arrAllTemplatesAndAttributes[$templateID]['name'] = $res['template_name'];
        }
        $arrAllTemplatesAndAttributes[$templateID][$res['options_id']][] = $res['option_values_id'];
    }
    //}
    return $arrAllTemplatesAndAttributes;
}

function buildAllTemplatesDropDown() {
    $allTemplates = getAllTemplatesAndGroupPrices();
    $returnArray = array(array('id' => '0', 'text' => '-- Profiles --'));
    foreach ($allTemplates as $templateID => $values) {
        $returnArray[] = array('id' => $templateID, 'text' => $values['name']);
    }
    return $returnArray;
}

function update_staffel_table($pid, $objResponse) {
    require_once('includes/application_top.php');
    require_once (DIR_FS_INC . 'xtc_get_tax_class_id.inc.php');
    $i = 0;
    $group_query = xtc_db_query("SELECT
                           customers_status_image,
                           customers_status_id,
                           customers_status_name
                       FROM
                           " . TABLE_CUSTOMERS_STATUS . "
                       WHERE
                           language_id = '" . $_SESSION['languages_id'] . "' AND customers_status_id != '0'");
    while ($group_values = xtc_db_fetch_array($group_query)) {
        // load data into array
        $i++;
        $group_data[$i] = array('STATUS_NAME' => $group_values['customers_status_name'], 'STATUS_IMAGE' => $group_values['customers_status_image'], 'STATUS_ID' => $group_values['customers_status_id']);
    }
    for ($col = 0, $n = sizeof($group_data); $col < $n + 1; $col++) {
        if ($col != 0) {
            $tag = '';
            $staffel_query = xtc_db_query("SELECT
		                                         products_id,
		                                         quantity,
		                                         personal_offer
		                                     FROM
		                                         personal_offers_by_customers_status_" . $group_data[$col]['STATUS_ID'] . "
		                                     WHERE
		                                         products_id = '" . $pid . "' AND quantity != 1
		                                     ORDER BY quantity ASC");
            $tag .= '<div class="titleStaffel">
							<div style="float:left;margin-right:15px">
								' . STAFFEL_TITLE . '
							</div>
							<div style="float:left">
								<span class="cursor">' . xtc_image('images/icons/plus-circle.png', STAFFEL_ADD, '', '', 'onclick="xajax_staffelAdd(' . $group_data[$col]['STATUS_ID'] . ',' . $pid . ',document.getElementById(\'products_price_' . $group_data[$col]['STATUS_ID'] . '\').value);"') . '
								</span>
							</div>
							<div>' . STAFFEL_NEW . '</div>
						</div>';
            $tag .= '<div class="tableMain">';
            $tag .= '<div class="td">' . STAFFEL_QUANTITY . '</div>';
            $tag .= '<div class="td">' . STAFFEL_PRICE . '</div>';
            $tag .= '<div align="center" class="tdSmall">' . STAFFEL_EDIT . '</div>';
            $tag .= '<div align="center">' . STAFFEL_DELETE . '</div>';
            while ($staffel_values = xtc_db_fetch_array($staffel_query)) {
                $i++;
                if (PRICE_IS_BRUTTO == 'true') {
                    $products_staffel_price = ($staffel_values['personal_offer'] * xtc_get_tax_rate(xtc_get_tax_class_id($pid)) / 100) + $staffel_values['personal_offer'];
                } else {
                    $products_staffel_price = $staffel_values['personal_offer'];
                }
                $tag .= '</div>';
                if ($i % 2)
                    $tag .= '<div class="tdWide">';
                else
                    $tag .= '<div class="tdWide yellowBG">';

                $tag .= '<div class="td">';
                $tag .= $staffel_values['quantity'];
                $tag .= '</div>';
                $tag .= '<div class="td">';
                $tag .= round($products_staffel_price, PRICE_PRECISION);
                $tag .= '</div>';
                $tag .= '<div class="tdSmall ac">
							' . xtc_image('images/icons/pencil.png', STAFFEL_EDIT, '', '', 'onclick="xajax_staffelEdit(' . $group_data[$col]['STATUS_ID'] . ',' . $pid . ',' . $staffel_values['quantity'] . ',' . round($products_staffel_price, PRICE_PRECISION) . ');"') . '
							<span id="staffel_edit_' . $group_data[$col]['STATUS_ID'] . '_' . $pid . '_' . $staffel_values['quantity'] . '" name="staffel_edit_' . $group_data[$col]['STATUS_ID'] . '_' . $pid . '_' . $staffel_values['quantity'] . '">
							</span>
							</div>
						</div>';
                $tag .='<div class="ac">
							<span class="cursor">
								' . xtc_image('images/icons/minus-circle.png', STAFFEL_DELETE, '', '', 'onclick="xajax_staffelDelete(' . $group_data[$col]['STATUS_ID'] . ',' . $pid . ',' . $staffel_values['quantity'] . ');"') . '
							</span>
						</div>';
                $tag .= '</div>';
            }
            $objResponse->assign("staffel_value_" . $group_data[$col]['STATUS_ID'], "innerHTML", $tag);
        }
    }
    return $objResponse;
}

function staffelDelete($staffelid, $pid, $quantity) {
    require_once('includes/application_top.php');
    $objResponse = new xajaxResponse();
    // ok, lets check entered data to get rid of user faults
    if ($quantity <= 1)
        $quantity = 2;
    $check_query = xtc_db_query("SELECT quantity
										                               FROM personal_offers_by_customers_status_" . $staffelid . "
										                              WHERE products_id = '" . $pid . "'
										                                AND quantity    = '" . $quantity . "'");
    if (xtc_db_num_rows($check_query) < 1) {
        $error_message = '<div class="errorMessage">' . STAFFEL_ERROR_MESSAGE_5 . '</div>';
    } else {
        $check_query = xtc_db_query("Delete FROM personal_offers_by_customers_status_" . $staffelid . "
										                              WHERE products_id = '" . $pid . "'
										                                AND quantity    = '" . $quantity . "'");
        $error_message = '<div class="errorMessage">' . STAFFEL_ERROR_MESSAGE_6 . '</div>';
        $objResponse = update_staffel_table($pid, $objResponse);
    }
    $objResponse->assign("staffel_add_" . $staffelid, "innerHTML", $error_message);
    $objResponse->assign('eingabebox_' . $staffelid, 'style.display', 'none');
    $objResponse->assign('editbox_' . $staffelid, 'style.display', 'none');
    $objResponse->assign("load_" . $staffelid, "innerHTML", '');
    $objResponse->assign("fehlermeldung_" . $StaffelId, "innerHTML", '');
    return $objResponse;
}

function staffelEdit($staffelid, $pid, $quantity, $price) {
    require_once('includes/application_top.php');
    $objResponse = new xajaxResponse();

    $objResponse->assign("staffel_add_" . $staffelid, "innerHTML", '<div class="innerHTML"><div class="innerInnerHTML"><input name="products_new_staffel_quantity" class="ajax" id="products_new_staffel_quantity" value="' . $quantity . '" size="4" type="text"></div><div class="innerInnerHTMLRight"><input name="products_new_staffel_price" class="ajax" id="products_new_staffel_price" value="' . $price . '" size="8" type="text"></div><div class="innerInnerHTMLRightRight"><span class="cursor"><img src="images/tick.gif" alt="' . STAFFEL_SAVE . '" title=" ' . STAFFEL_SAVE . ' " onclick="xajax_staffelSaveEdit(document.getElementById(\'products_new_staffel_quantity\').value,document.getElementById(\'products_new_staffel_price\').value,' . $staffelid . ',' . $pid . ',' . $quantity . ');" height="16" width="16"></span></div><div class="ac"><span class="cursor"><img src="images/icons/minus-circle.png"  alt="' . STAFFEL_CANCEL . '" title=" ' . STAFFEL_CANCEL . ' " onclick="xajax_staffelCancel(' . $staffelid . ',' . $pid . ',' . $quantity . ');" height="16" width="16"></span></div></div>');
    $objResponse->assign('eingabebox_' . $staffelid, 'style.display', 'none');
    $objResponse->assign('editbox_' . $staffelid, 'style.display', 'none');
    $objResponse->assign("load_" . $staffelid, "innerHTML", '');
    $objResponse->assign("fehlermeldung_" . $staffelid, "innerHTML", '');
    return $objResponse;
}

function staffelSaveEdit($quantity, $staffelpreis, $staffelid, $pid, $quantity_old) {
    require_once('includes/application_top.php');
    require_once (DIR_FS_INC . 'xtc_get_tax_class_id.inc.php');
    $objResponse = new xajaxResponse();
    $error_message = '';
    // Preis mit Kommata abfangen
    if (strpos($staffelpreis, ',') !== false) {
        $staffelpreis = str_replace(",", ".", $staffelpreis);
    }
    if (PRICE_IS_BRUTTO == 'true') {
        $staffelpreis = ($staffelpreis / (xtc_get_tax_rate(xtc_get_tax_class_id($pid)) + 100) * 100);
    }
    $staffelpreis = round($staffelpreis, PRICE_PRECISION);

    if ($staffelpreis != '' && $quantity != '') {
        $check_query = xtc_db_query("SELECT quantity
										                               FROM personal_offers_by_customers_status_" . $staffelid . "
										                              WHERE products_id = '" . $pid . "'
										                                AND quantity    = '" . $quantity_old . "'");
        if (xtc_db_num_rows($check_query) < 1) {
            $error_message = '<div class="errorMessage">' . STAFFEL_ERROR_MESSAGE_7 . '</div>';
        } else {
            $check_query = xtc_db_query("Delete FROM personal_offers_by_customers_status_" . $staffelid . "
											                              WHERE products_id = '" . $pid . "'
											                                AND quantity    = '" . $quantity_old . "'");
        }
        // ok, lets check entered data to get rid of user faults
        if ($quantity <= 1)
            $quantity = 2;
        $check_query = xtc_db_query("SELECT quantity
											                               FROM personal_offers_by_customers_status_" . $staffelid . "
											                              WHERE products_id = '" . $pid . "'
											                                AND quantity    = '" . $quantity . "'");
        // dont insert if same qty!
        if (xtc_db_num_rows($check_query) < 1) {
            xtc_db_query("INSERT INTO personal_offers_by_customers_status_" . $staffelid . "
														                 SET price_id       = '',
														                     products_id    = '" . $pid . "',
														                     quantity       = '" . $quantity . "',
														                     personal_offer = '" . $staffelpreis . "'");
            $error_message = '<div class="errorMessage">' . STAFFEL_ERROR_MESSAGE_8 . '</div>';
            $objResponse = update_staffel_table($pid, $objResponse);
        } else {
            $error_message = '<div class="errorMessage">' . STAFFEL_ERROR_MESSAGE_3 . '</div>';
        }
    } else {
        $error_message = '<div class="errorMessage">' . STAFFEL_ERROR_MESSAGE_4 . '</div>';
    }
    $objResponse->assign("staffel_add_" . $staffelid, "innerHTML", $error_message);
    $objResponse->assign('eingabebox_' . $staffelid, 'style.display', 'none');
    $objResponse->assign('editbox_' . $staffelid, 'style.display', 'none');
    $objResponse->assign("load_" . $staffelid, "innerHTML", '');
    $objResponse->assign("fehlermeldung_" . $staffelid, "innerHTML", '');
    return $objResponse;
}

function staffelAdd($StaffelId, $pid, $groupprice) {
    $objResponse = new xajaxResponse();
    $products_price = get_group_price($StaffelId, $pid);
    if ($groupprice != '')
        $objResponse->assign("staffel_add_" . $StaffelId, "innerHTML", '<div class="innerHTML"><div class="innerInnerHTML"><input name="products_new_staffel_quantity" class="ajax" id="products_new_staffel_quantity" value="" size="4" type="text"></div><div class="productsNewStaffelLeft"><input name="products_new_staffel_price" class="ajax" id="products_new_staffel_price" value="" size="8" type="text"></div><div class="productsNewStaffelRight"><span class="cursor"><img src="images/tick.gif" alt="' . STAFFEL_SAVE . '" title=" ' . STAFFEL_SAVE . ' " onclick="xajax_staffelSave(document.getElementById(\'products_new_staffel_quantity\').value,document.getElementById(\'products_new_staffel_price\').value,' . $StaffelId . ',' . $pid . ');" height="16" width="16"></span></div><div class="ac"><span class="cursor"><img src="images/icons/minus-circle.png" alt="' . STAFFEL_CANCEL . '" title=" ' . STAFFEL_CANCEL . ' " onclick="xajax_staffelCancel(' . $StaffelId . ');" height="16" width="16"></span></div></div>');
    else
        $objResponse->assign("staffel_add_" . $StaffelId, "innerHTML", '<div class="errorMessage">' . STAFFEL_ERROR_MESSAGE_1 . '</div>');
    $objResponse->assign('eingabebox_' . $StaffelId, 'style.display', 'none');
    $objResponse->assign('editbox_' . $StaffelId, 'style.display', 'none');
    $objResponse->assign("load_" . $StaffelId, "innerHTML", '');
    $objResponse->assign("fehlermeldung_" . $StaffelId, "innerHTML", '');
    return $objResponse;
}

function staffelCancel($StaffelId) {
    //echo $aFormValues;
    $objResponse = new xajaxResponse();
    $objResponse->assign("staffel_add_" . $StaffelId, "innerHTML", '');
    $objResponse->assign('eingabebox_' . $StaffelId, 'style.display', 'none');
    $objResponse->assign('editbox_' . $StaffelId, 'style.display', 'none');
    $objResponse->assign("load_" . $StaffelId, "innerHTML", '');
    $objResponse->assign("fehlermeldung_" . $StaffelId, "innerHTML", '');
    return $objResponse;
}

function staffelSave($quantity, $staffelpreis, $staffelid, $pid) {
    require_once('includes/application_top.php');
    require_once (DIR_FS_INC . 'xtc_get_tax_class_id.inc.php');
    $objResponse = new xajaxResponse();
    $error_message = '';
    if (strpos($staffelpreis, ',') !== false) {
        $staffelpreis = str_replace(",", ".", $staffelpreis);
    }
    if (PRICE_IS_BRUTTO == 'true') {
        $staffelpreis = ($staffelpreis / (xtc_get_tax_rate(xtc_get_tax_class_id($pid)) + 100) * 100);
    }
    $staffelpreis = round($staffelpreis, PRICE_PRECISION);

    if ($staffelpreis != '' && $quantity != '') {
        // ok, lets check entered data to get rid of user faults
        if ($quantity <= 1)
            $quantity = 2;
        $check_query = xtc_db_query("SELECT quantity
											                               FROM personal_offers_by_customers_status_" . $staffelid . "
											                              WHERE products_id = '" . $pid . "'
											                                AND quantity    = '" . $quantity . "'");
        // dont insert if same qty!
        if (xtc_db_num_rows($check_query) < 1) {
            xtc_db_query("INSERT INTO personal_offers_by_customers_status_" . $staffelid . "
														                 SET price_id       = '',
														                     products_id    = '" . $pid . "',
														                     quantity       = '" . $quantity . "',
														                     personal_offer = '" . $staffelpreis . "'");
            $error_message = '<div class="errorMessage">' . STAFFEL_ERROR_MESSAGE_2 . '</div>';
            $objResponse = update_staffel_table($pid, $objResponse);
        } else {
            $error_message = '<div class="errorMessage">' . STAFFEL_ERROR_MESSAGE_3 . '</div>';
        }
    } else {
        $error_message = '<div class="errorMessage">' . STAFFEL_ERROR_MESSAGE_4 . '</div>';
    }

    $objResponse->assign("staffel_add_" . $staffelid, "innerHTML", $error_message);
    $objResponse->assign('eingabebox_' . $staffelid, 'style.display', 'none');
    $objResponse->assign('editbox_' . $staffelid, 'style.display', 'none');
    $objResponse->assign("load_" . $staffelid, "innerHTML", '');
    $objResponse->assign("fehlermeldung_" . $staffelpreis, "innerHTML", '');
    return $objResponse;
}

/* Staffelpreise END */
