<?php

/* -----------------------------------------------------------------
 * $Id: xajax.attribut_manager.php 576 2013-08-26 06:59:58Z akausch $
 * Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * based on:
 * (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * (c) 2002-2003 osCommerce - www.oscommerce.com
 * (c) 2003     nextcommerce - www.nextcommerce.org
 * (c) 2005     xt:Commerce - www.xt-commerce.com
 * Released under the GNU General Public License
 * --------------------------------------------------------------- */
defined("_VALID_XTC") or die("Direct access to this location isn't allowed.");

require_once ('includes/functions/general.php');

require_once(DIR_FS_INC . 'xtc_get_tax_rate.inc.php');
require_once(DIR_FS_INC . 'xtc_get_tax_class_id.inc.php');

function DeleteAttrProfile($val) {
    $ajax = new xajaxResponse();

    $profile_name = $val['profile'];
    $profile_query = xtc_db_query("DELETE FROM attr_profile WHERE products_id = '" . $profile_name . "';");

    $ajax->script('$(".ui-dialog-content").dialog("close")');
    $ajax->call('xajax_message', 'Das Profil: <b>' . $profile_name . '</b> wurde gelöscht.', 'success');
    return $ajax;
}

function LoadAttrProfile($val) {
    $ajax = new xajaxResponse();
    $profile_name = $val['profile'];
    $pid = $val['pID'];

    $profile_query = xtc_db_query("DELETE FROM " . TABLE_PRODUCTS_ATTRIBUTES . " WHERE products_id = '" . $pid . "';");
    $profile_query = xtc_db_query("UPDATE attr_profile SET products_id = '" . $pid . "' WHERE products_id LIKE '" . $profile_name . "';");


    $profile_query = xtc_db_query("INSERT INTO " . TABLE_PRODUCTS_ATTRIBUTES . " 
  (products_id, options_id, options_values_id, options_values_price, price_prefix, attributes_model, attributes_ean, attributes_stock, options_values_weight, weight_prefix, sortorder, attributes_vpe_status, attributes_vpe, attributes_vpe_value)
  SELECT     
  products_id, options_id, options_values_id, options_values_price, price_prefix, attributes_model, attributes_ean, attributes_stock, options_values_weight, weight_prefix, sortorder, attributes_vpe_status, attributes_vpe, attributes_vpe_value
  FROM attr_profile WHERE products_id = '" . $pid . "'");


    $profile_query = xtc_db_query("UPDATE attr_profile SET products_id = '" . $profile_name . "' WHERE products_id = '" . $pid . "';");

    $ajax->script('$(".ui-dialog-content").dialog("close")');
    $ajax->call('xajax_message', 'Das Profil: <b>' . $profile_name . '</b> wurde geladen.', 'success');
    $ajax->call('xajax_getOverview', $pid);
    return $ajax;
}

function SaveAttrProfile($val) {
    $ajax = new xajaxResponse();
    $profile_name = $val['profile_name'];
    $pid = $val['pID'];

    $profile_query = xtc_db_query("DELETE FROM attr_profile WHERE products_id LIKE '" . $profile_name . "';");

    $profile_query = xtc_db_query("INSERT INTO attr_profile 
  (products_id, options_id, options_values_id, options_values_price, price_prefix, attributes_model, attributes_ean, attributes_stock, options_values_weight, weight_prefix, sortorder, attributes_vpe_status, attributes_vpe, attributes_vpe_value)
  SELECT     
  products_id, options_id, options_values_id, options_values_price, price_prefix, attributes_model, attributes_ean, attributes_stock, options_values_weight, weight_prefix, sortorder, attributes_vpe_status, attributes_vpe, attributes_vpe_value
  FROM " . TABLE_PRODUCTS_ATTRIBUTES . " WHERE products_id = '" . $pid . "';");

    $profile_query = xtc_db_query("UPDATE attr_profile SET products_id = '" . $profile_name . "' WHERE products_id = '" . $pid . "';");

    $ajax->script('$(".ui-dialog-content").dialog("close")');
    $ajax->call('xajax_message', 'Die neue Werte wurden als <b>' . $profile_name . '</b> gespeichert.', 'success');
    return $ajax;
}

function getValue($id) {
    $ajax = new xajaxResponse();
    $valuesq = xtc_db_query("SELECT DISTINCT
ov.products_options_values_id,
ov.products_options_values_name
FROM
" . TABLE_PRODUCTS_OPTIONS_VALUES . " ov,
" . TABLE_PRODUCTS_OPTIONS_VALUES_TO_PRODUCTS_OPTIONS . " vtpo,
" . TABLE_PRODUCTS_OPTIONS . " popt
WHERE
ov.language_id = '" . (int) $_SESSION['languages_id'] . "'
AND
vtpo.products_options_id = '" . (int) $id . "'
AND
 ov.products_options_values_id = vtpo.products_options_values_id
ORDER BY
ov.products_options_values_name ASC");

    if (xtc_db_num_rows($valuesq) > 0) {
        $val = '<select id="value" name="value" onchange="xajax_prepareForm('.$id.');">';
        $val .= '<option>-- Wert w&auml;hlen --</option>';
        while ($values = xtc_db_fetch_array($valuesq)) {
            $val .= '<option value="' . $values['products_options_values_id'] . '">' . $values['products_options_values_name'] . '</option>';
        }
    }

    $ajax->assign('attributes_value', 'innerHTML', $val);

    return $ajax;
}

function prepareForm($oid = '') {
    $ajax = new xajaxResponse();
	// $ajax->alert('aid: '."\n".$oid);
    $js = 'var nh = 550, nw = 550;
var dlg = $(".ui-dialog");
var p = dlg.position();
var l = ($(window).width()-nw)/2;
var t = ($(window).height()-nh)/2;
dlg.animate({width:nw,height:nh,left:l,top:t});
$(".ui-dialog-content").animate({height:(nh-25),width:(nw-20)});
';
// $("#price_option").fadeIn(\'fast\');';

    $ajax->script($js);

    $ajax->call('xajax_getForm', '', $oid);

    return $ajax;
}

function editEntry($aid, $pid) {
    $editoption = xtc_draw_form('attribute', 'categories.php', '', 'POST', 'id="attribute_form" onsubmit="return false;"');
    $editoption .= xtc_draw_hidden_field('pID', $pid);
    $editoption .= xtc_draw_hidden_field('aID', $aid);
    $editoption .= '<div id="attributes_form"></div></form>';

    $ajax = new xajaxResponse();
    $ajax->call('xajax_dialog', $editoption, 'Edit', 550, 550);
	$ajax->call('xajax_getForm', $aid);

    return $ajax;
}

function getForm($aid, $oid = '') {
	$ajax = new xajaxResponse();
	// $ajax->alert('aid: '."\n".$oid);
    if (!empty($aid)) {
        $attr = xtc_db_fetch_array(xtc_db_query("SELECT
                                *
                             FROM
                             " . TABLE_PRODUCTS_ATTRIBUTES . "
                             WHERE
                             products_attributes_id = '" . (int) $aid . "';"));
        $download = xtc_db_fetch_array(xtc_db_query("SELECT
                                *
                             FROM
                             " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . "
                             WHERE
                             products_attributes_id = '" . (int) $aid . "';"));

        $attribute_value_download_filename = $download['products_attributes_filename'];
        $attribute_value_download_count = $download['products_attributes_maxcount'];
        $attribute_value_download_expire = $download['products_attributes_maxdays'];
        $sort_order = $attr['sortorder'];
        $model = $attr['attributes_model'];
        $ean = $attr['attributes_ean'];
        $stock = $attr['attributes_stock'];
        $weight_prefix = $attr['weight_prefix'];
        $weight = $attr['options_values_weight'];
        $attributes_vpe_status = $attr['attributes_vpe_status'];
        $attributes_vpe = $attr['attributes_vpe'];
        $attributes_vpe_value = $attr['attributes_vpe_value'];

        require_once(DIR_FS_CATALOG . DIR_WS_CLASSES . 'class.xtcprice.php');
        $price = new xtcPrice(DEFAULT_CURRENCY, $_SESSION['customers_status']['customers_status_id']);
		if (PRICE_IS_BRUTTO == 'true') {
			$value_price = $price->xtcAddTax($attr['options_values_price'], xtc_get_tax_rate(xtc_get_tax_class_id($attr['products_id'])));
		} else {
			$value_price = $attr['options_values_price'];
		}
        $price_prefix = $attr['price_prefix'];
    }

    $prefix[] = array('id' => '+', 'text' => '+');
    $prefix[] = array('id' => '-', 'text' => '-');
    $prefix[] = array('id' => '=', 'text' => '=');

    $options = '<table>';
    $options .= '<tr>';
    $options .= '<td>' . AT_PRICE . ' - ' . (PRICE_IS_BRUTTO == 'true' ? AT_BRUTTO : AT_NETTO) . ':</td>';
    $options .= '<td>' . xtc_draw_pull_down_menu('price_prefix', $prefix, $price_prefix, 'style="width:auto" id="price_prefix"') . xtc_draw_input_field('price', $value_price, 'style="width:103px"') . '</td>';
    $options .= '</tr>';

    $options .= '<tr>';
    $options .= '<td>' . AT_SORT . ':</td>';
    $options .= '<td>' . xtc_draw_input_field('sort_order', $sort_order) . '</td>';
    $options .= '</tr>';

    $options .= '<tr>';
    $options .= '<td>' . AT_PNUM . ':</td>';
    $options .= '<td>' . xtc_draw_input_field('model', $model) . '</td>';
    $options .= '</tr>';
    $options .= '<tr>';
    $options .= '<td>' . AT_EAN . ':</td>';
    $options .= '<td>' . xtc_draw_input_field('ean', $ean) . '</td>';
    $options .= '</tr>';

    $result = xtc_db_query("SELECT * FROM " . TABLE_PRODUCTS_OPTIONS . " WHERE products_options_name = 'Downloads' AND language_id = '" . (int) $_SESSION['languages_id'] . "';");
	$oid_result = xtc_db_fetch_array($result);
	$oid_result = $oid_result['products_options_id'];
	$download_result = $download['products_attributes_id'];
    if (xtc_db_num_rows($result) > 0) {
		// $ajax->alert('OID: '."\n".$oid);
		// $ajax->alert('OIDR: '."\n".$oid_result);
        if ($download_result != '' || !empty($oid) && $oid == $oid_result) {
            $options .= '<tr>';
            $options .= '<td>' . DL_NAME . ':</td>';
            $options .= '<td>' . xtc_draw_pull_down_menu('download_file', xtc_getDownloads(), $attribute_value_download_filename, '') . '</td>';
            $options .= '</tr>';

            $options .= '<tr>';
            $options .= '<td>' . DL_COUNT . ':</td>';
            $options .= '<td>' . xtc_draw_input_field('download_count', $attribute_value_download_count) . '</td>';
            $options .= '</tr>';

            $options .= '<tr>';
            $options .= '<td>' . DL_EXPIRE . ':</td>';
            $options .= '<td>' . xtc_draw_input_field('download_expire', $attribute_value_download_expire) . '</td>';
            $options .= '</tr>';
        }
    }

	if ($download_result == '') {
		$options .= '<tr>';
		$options .= '<td>' . AT_VPE_STATUS . ':</td>';
		$options .= '<td>' . xtc_draw_selection_field('attributes_vpe_status', 'checkbox', '1', $attributes_vpe_status == 1 ? true : false) . '</td>';
		$options .= '</tr>';
		$options .= '<tr>';
		$options .= '<td>' . AT_VPE . ':</td>';

		$vpe_array = array(array('id' => '', 'text' => TEXT_NONE));
		$vpe_query = xtc_db_query("SELECT products_vpe_id, products_vpe_name FROM " . TABLE_PRODUCTS_VPE . " WHERE language_id='" . (int) $_SESSION['languages_id'] . "' ORDER BY products_vpe_name;");
		while ($vpe = xtc_db_fetch_array($vpe_query)) {
			$vpe_array[] = array('id' => $vpe['products_vpe_id'], 'text' => $vpe['products_vpe_name']);
		}

		$options .= '<td>' . xtc_draw_pull_down_menu('attributes_vpe', $vpe_array, $attributes_vpe = '' ? DEFAULT_PRODUCTS_VPE_ID : $attributes_vpe) . '</td>';
		$options .= '</tr>';
		$options .= '<tr>';

		$options .= '<td>' . AT_VPE_VALUE . ':</td>';
		$options .= '<td>' . xtc_draw_input_field('attributes_vpe_value', $attributes_vpe_value) . '</td>';
		$options .= '</tr>';
	}

    $options .= '<tr>';
    $options .= '<td>' . AT_LAGER . ':</td>';
    $options .= '<td>' . xtc_draw_input_field('stock', $stock) . '</td>';
    $options .= '</tr>';

	$options .= '<tr>';
	$options .= '<td>' . AT_WEIGHT . ':</td>';
	$options .= '<td>' . xtc_draw_pull_down_menu('weight_prefix', $prefix, $weight_prefix, 'style="width:auto"') . xtc_draw_input_field('weight', $weight, 'style="width:103px"') . '</td>';
	$options .= '</tr>';

    $options .= '<tr>
				<td colspan="2" align="center">
				<button type="button" class="button" onclick="xajax_saveValues(xajax.getFormValues(\'attribute_form\'), \'' . (empty($aid) ? 'insert' : 'update') . '\')">' . BUTTON_SAVE . '</button>
				</td>
				</tr>';

    $options .= '</table>';

	
    // $ajax->alert('aid: '."\n".$aid);

	$ajax->assign('attributes_form','innerHTML',$options);

    return $ajax;
}

function saveValues($val, $action = 'insert') {

    $ajax = new xajaxResponse();

    require_once(DIR_FS_CATALOG . DIR_WS_CLASSES . 'class.xtcprice.php');
    $price = new xtcPrice(DEFAULT_CURRENCY, $_SESSION['customers_status']['customers_status_id']);

    if (PRICE_IS_BRUTTO == 'true') {
        $value_price = $price->xtcRemoveTax(str_replace(',', '.', $val['price']), xtc_get_tax_rate(xtc_get_tax_class_id($val['pID'])));
    } else {
        $value_price = round($val['price'], PRICE_PRECISION);
    }

    $sql = array('options_values_price' => $value_price,
        'price_prefix' => $val['price_prefix'],
        'attributes_model' => $val['model'],
        'attributes_stock' => $val['stock'],
        'options_values_weight' => str_replace(',', '.', $val['weight']),
        'weight_prefix' => $val['weight_prefix'],
        'sortorder' => $val['sort_order'],
        'attributes_ean' => $val['ean'],
        'attributes_vpe_status' => $val['attributes_vpe_status'],
        'attributes_vpe' => $val['attributes_vpe'],
        'attributes_vpe_value' => $val['attributes_vpe_value']);

    if ($action == 'insert') {
        $sql_addon = array('products_id' => $val['pID'],
            'options_id' => $val['option'],
            'options_values_id' => $val['value']);

        $sql = array_merge($sql, $sql_addon);

        xtc_db_perform(TABLE_PRODUCTS_ATTRIBUTES, $sql);
		$products_attributes_id = xtc_db_insert_id();
        $result = xtc_db_query("SELECT * FROM " . TABLE_PRODUCTS_OPTIONS . " where products_options_name = 'Downloads' AND language_id = '" . (int) $_SESSION['languages_id'] . "';");

        if (xtc_db_num_rows($result) > 0) {
            $sql_download = array('products_attributes_id' => $products_attributes_id,
                'products_attributes_filename' => $val['download_file'],
                'products_attributes_maxcount' => $val['download_count'],
                'products_attributes_maxdays' => $val['download_expire']
            );
            xtc_db_perform(TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD, $sql_download);
        }
    } elseif ($action == 'update') {
        xtc_db_perform(TABLE_PRODUCTS_ATTRIBUTES, $sql, 'update', "products_attributes_id = '" . $val['aID'] . "'");

        $result = xtc_db_query("SELECT * FROM " . TABLE_PRODUCTS_OPTIONS . " where products_options_name = 'Downloads' AND language_id = '" . (int) $_SESSION['languages_id'] . "';");
        $matches = xtc_db_num_rows($result);

        if ($matches) {
            $sql_download = array('products_attributes_id' => $val['aID'],
                'products_attributes_filename' => $val['download_file'],
                'products_attributes_maxcount' => $val['download_count'],
                'products_attributes_maxdays' => $val['download_expire']
            );
            xtc_db_perform(TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD, $sql_download, 'update', "products_attributes_id = '" . $val['aID'] . "'");
        }
    }

    $ajax->script('$(".ui-dialog-content").dialog("close")');
    $ajax->call('xajax_message', 'Die neue Werte wurden gespeichert.', 'success');
    $ajax->call('xajax_getOverview', $val['pID']);

    return $ajax;
}

function getOverview($pid) {

    $ajax = new xajaxResponse();
    // $ajax->alert('val: '."\n".$pid);
    if ($pid != '') {
        $optionsq = xtc_db_query("SELECT
									po.products_options_id,
									po.products_options_name,
									pa.products_attributes_id
								FROM
									" . TABLE_PRODUCTS_OPTIONS . " AS po
								LEFT JOIN
									" . TABLE_PRODUCTS_ATTRIBUTES . " AS pa ON(pa.options_id = po.products_options_id)
								WHERE
									pa.products_id = '" . (int) $pid . "'
								AND
									po.language_id = '" . (int) $_SESSION['languages_id'] . "'
								GROUP BY
									po.products_options_id
								ORDER BY
									po.products_options_id, pa.sortorder");

        if (xtc_db_num_rows($optionsq) > 0) {

            require_once(DIR_FS_CATALOG . DIR_WS_CLASSES . 'class.xtcprice.php');
            $overview_price = new xtcPrice(DEFAULT_CURRENCY, $_SESSION['customers_status']['customers_status_id']);

            $c = '<br /><div style="text-align:right;font-size:90%;font-style:italic">alle Preise sind ' . (PRICE_IS_BRUTTO == 'true' ? 'Brutto' : 'Netto') . '</div>';

            while ($options = xtc_db_fetch_array($optionsq)) {
                $c .= '<table width="100%" class="dataTable">';
                $c .= '<tr class="dataTableHeadingRow">';
                $c .= '<th class="dataTableHeadingContent" width="20%"><nobr><u>' . $options['products_options_name'] . '</u></nobr></th>';
                $c .= '<th class="dataTableHeadingContent" width="5%">Reihung</th>';
                $c .= '<th class="dataTableHeadingContent" width="10%">Art.-Nr.</th>';
                $c .= '<th class="dataTableHeadingContent" width="10%">EAN</th>';
                $c .= '<th class="dataTableHeadingContent" width="5%">Lager</th>';
				if ($options['products_options_name'] != 'Downloads') {
					$c .= '<th class="dataTableHeadingContent" width="10%">Grundpreis</th>';
                } else {
					$c .= '<th class="dataTableHeadingContent" width="10%">Datei</th>';
				}
				if ($options['products_options_name'] != 'Downloads') {
					$c .= '<th class="dataTableHeadingContent" width="10%"><nobr>Gewicht in kg</nobr></th>';
                } else {
					$c .= '<th class="dataTableHeadingContent" width="10%"><nobr>Anz./Tage</nobr></th>';
				}
                $c .= '<th class="dataTableHeadingContent" align="right" width="10%">Attr-Preis</th>';
                $c .= '<th class="dataTableHeadingContent" align="right" width="10%">Gesamtpreis</th>';
                $c .= '<th class="dataTableHeadingContent" width="10%">&nbsp;</th>';
                $c .= '</tr>';

                $valuesq = xtc_db_query("SELECT
											*
										 FROM
											" . TABLE_PRODUCTS_ATTRIBUTES . " AS pa
										LEFT JOIN
											" . TABLE_PRODUCTS_OPTIONS_VALUES . " AS pov ON(pa.options_values_id = pov.products_options_values_id AND pov.language_id = '" . (int) $_SESSION['languages_id'] . "')
										WHERE
											pa.products_id = '" . (int) $pid . "'
										AND
											pa.options_id = '" . $options['products_options_id'] . "'
										ORDER BY
											pa.sortorder;");


                if (xtc_db_num_rows($valuesq) > 0) {
                    $i = 1;
                    while ($values = xtc_db_fetch_array($valuesq)) {
						$valuesdownload = xtc_db_fetch_array(xtc_db_query("SELECT
													*
												 FROM
													" . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " 
												WHERE
													products_attributes_id = '" . $values['products_attributes_id'] . "'
												;"));
                        $value_price = '';
                        $total = '';

                        $c .= '<tr class="' . ($i % 2 ? 'attributes-even' : 'attributes-odd') . '">';
                        $c .= '<td><nobr><strong>' . $values['products_options_values_name'] . '</strong></nobr></td>';
                        $c .= '<td>' . $values['sortorder'] . '</td>';
                        $c .= '<td>' . (!empty($values['attributes_model']) ? $values['attributes_model'] : '-') . '</td>';
                        $c .= '<td>' . ($values['attributes_ean'] > 0 ? $values['attributes_ean'] : '-') . '</td>';
                        $c .= '<td align="center">' . $values['attributes_stock'] . '</td>';
                        if ($valuesdownload['products_attributes_filename'] == '') {
							$c .= '<td>' . ($values['attributes_vpe_status'] > 0 ? $values['attributes_vpe_value'] : '-') . '</td>';
						} else {
							$c .= '<td>' . ($valuesdownload['products_attributes_filename'] !='' ? $valuesdownload['products_attributes_filename'] : '-') . '</td>';
						}
                        if ($valuesdownload['products_attributes_filename'] == '') {
							$c .= '<td>' . $values['options_values_weight'] . '</td>';
						} else {
							$c .= '<td>' . $valuesdownload['products_attributes_maxcount'] . ' / ' . $valuesdownload['products_attributes_maxdays'] . '</td>';
						}

                        if (PRICE_IS_BRUTTO == 'true') {
                            $value_price = round($values['options_values_price'] * ((100 + (xtc_get_tax_rate(xtc_get_tax_class_id($pid)))) / 100), PRICE_PRECISION);
                        } else {
                            $value_price = $values['options_values_price'];
                        }

                        $c .= '<td align="right">' . $values['price_prefix'] . $overview_price->xtcFormat($value_price, true) . '</td>';

                        $total = $overview_price->xtcGetPrice($pid, false, 1, xtc_get_tax_class_id($pid));

                        if ($values['price_prefix'] == '+') {
                            $total += $value_price;
                        } elseif ($values['price_prefix'] == '=') {
                            $total = $value_price;
                        } else {
                            $total -= $value_price;
                        }

                        $c .= '<td align="right">' . $overview_price->xtcFormat($total, true) . '</td>';

                        $c .= '<td align="right" width="1">
								<nobr>
								<button class="button" type="button" onclick="xajax_editEntry(' . $values['products_attributes_id'] . ',' . $pid . ')" style="font-size:160%;padding: 2px 7px 2px 7px;" title="' . BUTTON_EDIT . '">&#9998;</button>
								<button onclick="if(confirm(\'Wollen Sie diesen Eintrag wirklich löschen?\')){xajax_deleteEntry(' . $values['products_attributes_id'] . ',' . $pid . ')}else{return false}" type="button" class="button" style="font-size:160%;padding: 2px 7px 2px 7px;" title="' . BUTTON_DELETE . '">&#10008;</button>
								</nobr>
								</td>';

                        $c .= '</tr>';

                        $i++;
                    }
                }
                $c .= '</table><br />';
                // $ajax->alert('val: '."\n".$options);
            }
        } else {
            $c .= '<em>Es sind noch keine Attribute für dieses Produkt hinterlegt worden.</em>';
        }
    } else {
        $c .= '<em>Sie müssen das neue Produkt zuerst speichern oder auf Aktualisieren klicken, bevor Sie Attribute zuweisen können.</em>';
    }

    $ajax->assign('attributes', 'innerHTML', $c);

    return $ajax;
}

function deleteEntry($aid, $pid) {

    $ajax = new xajaxResponse();

    xtc_db_query("DELETE FROM " . TABLE_PRODUCTS_ATTRIBUTES . " WHERE products_attributes_id = '" . $aid . "'");

    $ajax->call('xajax_message', 'Der Eintrag wurde gelöscht', 'warning');
    $ajax->call('xajax_getOverview', $pid);

    return $ajax;
}

function saveNewOption($val) {

    $ajax = new xajaxResponse();

    $next_id = xtc_db_fetch_array(xtc_db_query("SELECT MAX(products_options_id)+1 AS next_id FROM " . TABLE_PRODUCTS_OPTIONS));
    $next = ($next_id['next_id'] == 0 ? 1 : $next_id['next_id']);

    $languages = get_languages();
    for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
        $option_name = $val['option_name'][$languages[$i]['id']];
        // $option_desc = $val['option_desc'][$languages[$i]['id']];
        // $new_option_to_sql = array( 'products_options_id' => $next,
        // 'products_options_name' => $option_name,
        // 'products_options_desc' => $option_desc,
        // 'products_options_image' => '',
        // 'language_id' => $languages[$i]['id']);
        $new_option_to_sql = array('products_options_id' => $next,
            'products_options_name' => $option_name,
            'language_id' => $languages[$i]['id']);

        xtc_db_perform(TABLE_PRODUCTS_OPTIONS, $new_option_to_sql);
    }

    $ajax->script('$(".ui-dialog-content").dialog("close")');
    $ajax->call('xajax_message', 'Die neue Option wurde gespeichert, legen Sie dazu nun Optionswerte an', 'success');

    return $ajax;
}

function saveNewValue($val) {

    $ajax = new xajaxResponse();

    $nid = xtc_db_fetch_array(xtc_db_query("SELECT MAX(products_options_values_id)+1 AS next_id FROM " . TABLE_PRODUCTS_OPTIONS_VALUES));

    $next = (!empty($nid['next_id']) ? $nid['next_id'] : '1');

    $languages = get_languages();
    for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
        $value_name = $val['value_name'][$languages[$i]['id']];
        $value_desc = $val['value_desc'][$languages[$i]['id']];
        // $value_hex = $val['hex_image'][$languages[$i]['id']];
        $new_attribut_sql = '';

        // $new_attribut_sql = array('products_options_values_id' => $next,
        // 'language_id' => $languages[$i]['id'],
        // 'products_options_values_name' => $value_name,
        // 'products_options_values_desc' => $value_desc,
        // 'products_options_hex_image' => $value_hex,
        // 'products_options_values_image' => '');
        $new_attribut_sql = array('products_options_values_id' => $next,
            'language_id' => $languages[$i]['id'],
            'products_options_values_name' => $value_name,
            'products_options_values_desc' => $value_desc,
            'products_options_values_image' => '');

        xtc_db_perform(TABLE_PRODUCTS_OPTIONS_VALUES, $new_attribut_sql);
    }

    $new_value_to_option_sql = array('products_options_id' => $val['option_id'],
        'products_options_values_id' => $next);

    xtc_db_perform(TABLE_PRODUCTS_OPTIONS_VALUES_TO_PRODUCTS_OPTIONS, $new_value_to_option_sql);

    $ajax->script('$(".ui-dialog-content").dialog("close")');
    $ajax->call('xajax_message', 'Der neue Optionswert wurde gespeichert und kann sofort verwendet werden', 'success');

    return $ajax;
}


$xajax->registerFunction('getValue');
$xajax->registerFunction('prepareForm');
$xajax->registerFunction('getForm');
$xajax->registerFunction('saveValues');
$xajax->registerFunction('getOverview');
$xajax->registerFunction('editEntry');
$xajax->registerFunction('deleteEntry');
$xajax->registerFunction('saveNewOption');
$xajax->registerFunction('saveNewValue');

$xajax->registerFunction('LoadAttrProfile');
$xajax->registerFunction('DeleteAttrProfile');
$xajax->registerFunction('SaveAttrProfile');
$xajax->setTimeout(6000);