<?php

/* -----------------------------------------------------------------
 * 	$Id: hashtags.php 580 2013-08-27 14:35:47Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

include ('includes/application_top.php');

$smarty = new Smarty;
$smarty->assign('tpl_path', 'templates/' . CURRENT_TEMPLATE . '/');

require (DIR_FS_CATALOG . 'templates/' . CURRENT_TEMPLATE . '/source/boxes.php');

$error = 0; // reset error flag to false
$breadcrumb->add('Hashtag', xtc_href_link('hashtags.php', '', 'SSL'));

include ('includes/header.php');

$result = true;
$_GET['hashtags'] = stripslashes(trim(urldecode($_GET['hashtags'])));
if (isset($_GET['hashtags']) && ($_GET['hashtags'] != '')) {

    $fsk_lock = '';
    if ($_SESSION['customers_status']['customers_fsk18_display'] == '0') {
        $fsk_lock = ' AND p.products_fsk18!=1';
    }

    $group_check = '';
    if (GROUP_CHECK == 'true') {
        $group_check = " AND p.group_permission_" . $_SESSION['customers_status']['customers_status_id'] . "=1 ";
    }

    $listing_sql = "SELECT *
					FROM
						" . TABLE_PRODUCTS . " AS p
					LEFT JOIN
						" . TABLE_PRODUCTS_DESCRIPTION . " AS pd ON(pd.products_id = p.products_id AND pd.language_id = '" . (int) $_SESSION['languages_id'] . "')
					WHERE
						p.products_status = '1'
					AND
						pd.products_name LIKE  '%" . $_GET['hashtags'] . "%'
					OR 
						pd.products_description LIKE  '%" . $_GET['hashtags'] . "%'
						   " . $group_check . "
						   " . $fsk_lock . "
					";

    if (isset($_GET['per_site']) && !empty($_GET['per_site']))
        $per_site = $_GET['per_site'];
    elseif (isset($_SESSION['per_site']))
        $per_site = $_SESSION['per_site'];
    elseif (!isset($_SESSION['per_site']) || !isset($_GET['per_site']))
        $per_site = MAX_DISPLAY_SEARCH_RESULTS;

    $_SESSION['per_site'] = $per_site;

    $listing_split = new splitPageResults($listing_sql, (int) $_GET['page'], (int) $_SESSION['per_site'], 'p.products_id');

    $list_name = 'tagcloud';

    if (($listing_split->number_of_rows > 0)) {
        $navigation_smarty = new Smarty;
        $page_links = $listing_split->getLinksArrayHashtag(MAX_DISPLAY_PAGE_LINKS, xtc_get_all_get_params(array('page', 'hashtags', 'info', 'x', 'y', (MODULE_COMMERCE_SEO_INDEX_STATUS == 'True' ? 'cPath' : ''), 'cat', 'per_site', 'view_as')), TEXT_DISPLAY_NUMBER_OF_PRODUCTS, '', $_GET['hashtags']);
        $navigation_smarty->assign('LINKS', $page_links);
        $navigation_smarty->assign('language', $_SESSION['language']);
        $navigation_smarty->assign('tpl_path', 'templates/' . CURRENT_TEMPLATE . '/');
        $navigation_smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
        $navigation = $navigation_smarty->fetch(cseo_get_usermod(CURRENT_TEMPLATE . '/module/product_navigation/products_page_navigation.html', USE_TEMPLATE_DEVMODE));
    } else {
        header($_SERVER["SERVER_PROTOCOL"] . ' 404 Not Found');
        header('Status: 404 Not Found');
        header('Content-type: text/html');
        $error = 'Hashtag not found';
        include (DIR_WS_MODULES . FILENAME_ERROR_HANDLER);
        $smarty->assign('error', $error);
    }
    $module_content = array();
    $listing_query = xtDBquery($listing_split->sql_query);
    $rows = 0;
    while ($tag = xtc_db_fetch_array($listing_query, true)) {
        $rows++;
        $module_content[] = $product->buildDataArray($tag, 'thumbnail', $list_name, $rows);
    }
    switch ($getCols['col']) {
        case '3' :
            $view_per_site = ($per_site == 9 ? '<b>9</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=9' . $get_param) . '">9</a>') . ' | ';
            $view_per_site .= ($per_site == 18 ? '<b>18</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=18' . $get_param) . '">18</a>') . ' | ';
            $view_per_site .= ($per_site == 27 ? '<b>27</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=27' . $get_param) . '">27</a>') . ' | ';
            $view_per_site .= ($per_site == 45 ? '<b>45</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=45' . $get_param) . '">45</a>') . ' | ';
            $view_per_site .= ($per_site == 81 ? '<b>81</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=81' . $get_param) . '">81</a>');
            break;

        case '4' :
            $view_per_site = ($per_site == 12 ? '<b>12</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=12' . $get_param) . '">12</a>') . ' | ';
            $view_per_site .= ($per_site == 24 ? '<b>24</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=24' . $get_param) . '">24</a>') . ' | ';
            $view_per_site .= ($per_site == 60 ? '<b>60</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=60' . $get_param) . '">60</a>') . ' | ';
            $view_per_site .= ($per_site == 84 ? '<b>84</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=84' . $get_param) . '">84</a>') . ' | ';
            $view_per_site .= ($per_site == 96 ? '<b>96</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=96' . $get_param) . '">96</a>');
            break;

        default :
            $view_per_site = ($per_site == 10 ? '<b>10</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=10' . $get_param) . '">10</a>') . ' | ';
            $view_per_site .= ($per_site == 20 ? '<b>20</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=20' . $get_param) . '">20</a>') . ' | ';
            $view_per_site .= ($per_site == 30 ? '<b>30</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=30' . $get_param) . '">30</a>') . ' | ';
            $view_per_site .= ($per_site == 50 ? '<b>50</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=50' . $get_param) . '">50</a>') . ' | ';
            $view_per_site .= ($per_site == 100 ? '<b>100</b>' : '<a rel="nofollow" href="' . xtc_href_link('hashtag/' . $_GET['hashtags'] . '/', xtc_get_all_get_params(array('hashtags', 'products_id', 'x', 'y', 'cat', 'per_site', 'multisort', 'filter_id', 'view_as')) . 'per_site=100' . $get_param) . '">100</a>');
            break;
    }

    $per_site_html = new Smarty;
    $per_site_html->assign('LINKS_PER_SITE', $view_per_site);
    $per_site_html->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
    $per_site_html->assign('language', $_SESSION['language']);
    $products_persite = $per_site_html->fetch(cseo_get_usermod(CURRENT_TEMPLATE . '/module/product_navigation/products_per_site.html', USE_TEMPLATE_DEVMODE));

    $smarty->assign('NAVIGATION', $navigation);

    $smarty->assign('CLASS', 'hashtag');
    $smarty->assign('PRODUCTS_PER_SITE', $products_persite);
    $smarty->assign('module_content', $module_content);
    $smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
    $smarty->assign('language', $_SESSION['language']);
    if (!CacheCheck()) {
        $smarty->caching = false;
        $main_content = $smarty->fetch(cseo_get_usermod(CURRENT_TEMPLATE . '/module/product_listing/product_listings.html', USE_TEMPLATE_DEVMODE));
    } else {
        $smarty->caching = true;
        $smarty->cache_lifetime = CACHE_LIFETIME;
        $smarty->cache_modified_check = CACHE_CHECK;
        $cache_id = $_SESSION['language'] . '_' . $_SESSION['customers_status']['customers_status_name'] . '_' . $_SESSION['currency'] . '-hashtag';
        $main_content = $smarty->fetch(cseo_get_usermod(CURRENT_TEMPLATE . '/module/product_listing/product_listings.html', USE_TEMPLATE_DEVMODE), $cache_id);
    }
    $smarty->loadFilter('output', 'note');
    $smarty->loadFilter('output', 'trimwhitespace');
    $smarty->loadFilter('output', 'note');
    $smarty->assign('main_content', $main_content);
    $smarty->display(cseo_get_usermod(CURRENT_TEMPLATE . '/index.html', USE_TEMPLATE_DEVMODE));
    include ('includes/application_bottom.php');
} else {
    header($_SERVER["SERVER_PROTOCOL"] . ' 404 Not Found');
    header('Status: 404 Not Found');
    header('Content-type: text/html');
    $error = 'Hashtag not found';
    include (DIR_WS_MODULES . FILENAME_ERROR_HANDLER);

    $smarty->assign('error', $error);
    $smarty->loadFilter('output', 'trimwhitespace');
    $smarty->assign('TITLE', 'Hashtag');
    $smarty->assign('CLASS', 'hashtag');
    $smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
    $smarty->assign('language', $_SESSION['language']);
    $smarty->caching = false;
    $main_content = $smarty->fetch(cseo_get_usermod(CURRENT_TEMPLATE . '/module/taglistings.html', USE_TEMPLATE_DEVMODE));
    $smarty->assign('main_content', $main_content);
    $smarty->display(cseo_get_usermod(CURRENT_TEMPLATE . '/index.html', USE_TEMPLATE_DEVMODE));
    include ('includes/application_bottom.php');
}
