<?php

/* -----------------------------------------------------------------
 * 	$Id: blog.php 567 2013-08-20 22:00:38Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

include ('includes/application_top.php');
$smarty = new Smarty;
require (DIR_FS_CATALOG . 'templates/' . CURRENT_TEMPLATE . '/source/boxes.php');

if ($_GET['blog_cat'] == '') {
    $blog = xtc_db_fetch_array(xtc_db_query("SELECT categories_id FROM blog_items WHERE item_id = '" . xtc_db_input($_GET['blog_item']) . "' AND language_id = '" . (int) $_SESSION['languages_id'] . "'"));
    $_GET['blog_cat'] = $blog['categories_id'];
}


if (isset($_GET['blog_cat']) && is_numeric($_GET['blog_cat'])) {
    $getCatName = xtc_db_fetch_array(xtc_db_query("SELECT
															titel
														FROM
															blog_categories
														WHERE
															categories_id = '" . xtc_db_input((int) $_GET['blog_cat']) . "'
														AND
															language_id = '" . (int) $_SESSION['languages_id'] . "' "));

    $smarty->assign('cat_name', $getCatName['titel']);
    $breadcrumb->add($getCatName['titel'], xtc_href_link(FILENAME_BLOG, 'blog_cat=' . xtc_db_input((int) $_GET['blog_cat'])));
}

$monats_name = array('01' => JAN, '02' => FEB, '03' => MRZ, '04' => APR, '05' => MAI, '06' => JUN, '07' => JUL, '08' => AUG, '09' => SEP, '10' => OKT, '11' => NOV, '12' => DEZ);

// Wird Kategorie aufgerufen?
if ((isset($_GET['blog_cat']) && is_numeric($_GET['blog_cat'])) && (!isset($_GET['blog_item'])) && !isset($_GET['blog_year'])) {

    $getCatName = xtc_db_fetch_array(xtc_db_query("SELECT
														titel
													FROM
														" . TABLE_BLOG_CATEGORIES . "
													WHERE
														categories_id = '" . xtc_db_input((int) $_GET['blog_cat']) . "'
													AND
														language_id = '" . (int) $_SESSION['languages_id'] . "' "));

    $smarty->assign('cat_name', $getCatName['titel']);

    $items = array();
    $select_items_query = xtc_db_query("SELECT
  											*
										  FROM
										  	" . TABLE_BLOG_ITEMS . "
										  WHERE
										  	status = '2' 
										  AND
										  	categories_id = '" . xtc_db_input($_GET['blog_cat']) . "'
										  AND
										  	language_id = '" . (int) $_SESSION['languages_id'] . "'
										  ORDER BY
										  	item_id
										  DESC");

    while ($select_items = xtc_db_fetch_array($select_items_query)) {

        // $kommentare = xtc_db_fetch_array(xtc_db_query("SELECT COUNT(id) AS com_count FROM blog_comment WHERE blog_id = '" . $select_items['item_id'] . "' "));
        if ($select_items['shortdesc'] != '') {
            $desc = $select_items['shortdesc'];
        } else {
            $desc = cseo_truncate($select_items['description'], $select_items['lenght']);
        }
		$desc = preg_replace('/##(\w+)/', '<a href="'.xtc_href_link('hashtag/\1').'">#\1</a>', $desc);
        list($blog_tag_list, $monat_raw, $blog_jahr_list) = explode(".", $select_items['date']);

        $blog_monat_list = $monats_name[$monat_raw];
        $items[] = array('kommentare' => $kommentare['com_count'],
            'name' => $select_items['name'],
            'description' => $desc,
            'date' => $select_items['date'],
            'tag' => $blog_tag_list,
            'monat' => $blog_monat_list,
            'jahr' => $blog_jahr_list,
            'date_update' => $select_items['date_update'],
            'laenge' => $select_items['lenght'],
            'blog_link' => xtc_href_link(FILENAME_BLOG, 'blog_cat=' . xtc_db_input((int) $_GET['blog_cat']) . '&blog_item=' . xtc_db_input($select_items['item_id'])));
    }

    $smarty->assign('blog_items', $items);
    $smarty->assign('BLOG', true);

    // Einzelner Beitrag
} elseif ((isset($_GET['blog_cat']) && is_numeric($_GET['blog_cat'])) && (isset($_GET['blog_item']) && is_numeric($_GET['blog_item']))) {

    $select_item_query = xtc_db_query("SELECT 
											*
										FROM
											" . TABLE_BLOG_ITEMS . "
										WHERE
											status = '2'
										AND
											item_id = '" . xtc_db_input((int) $_GET['blog_item']) . "'
										AND
											categories_id = '" . xtc_db_input((int) $_GET['blog_cat']) . "'
										AND
											language_id = '" . (int) $_SESSION['languages_id'] . "'");
    $select_item = xtc_db_fetch_array($select_item_query);
    // die(print_r($select_item));
    $breadcrumb->add($select_item['title'], xtc_href_link(FILENAME_BLOG, 'blog_cat=' . (int) $_GET['blog_cat'] . '&blog_item=' . (int) $select_item['item_id']));

    // Kommentare
    $comments = array();
    $select_comment_query = xtc_db_query("SELECT id, blog_id, name, text, date FROM blog_comment WHERE blog_id = '" . xtc_db_input((int) $_GET['blog_item']) . "' ORDER BY id DESC");
    if (xtc_db_num_rows($select_comment_query) > 0) {

        $i = xtc_db_num_rows($select_comment_query);
        $smarty->assign('gesamt_comments', $i);
        while ($select_comment = xtc_db_fetch_array($select_comment_query)) {

            $comments[] = array('id' => $select_comment['id'],
                'name' => $select_comment['name'],
                'nr' => $i,
                'kommentar' => $select_comment['text'],
                'date' => $select_comment['date'],
                'delete' => xtc_href_link(FILENAME_BLOG, 'blog_cat=' . xtc_db_input($_GET['blog_cat']) . '&blog_item=' . xtc_db_input($_GET['blog_item'])));
            $smarty->assign('comment_items', $comments);
            $smarty->assign('comments', true);
            $i--;
        }
    }


    if (COMMENTS == 'ja') {
        $smarty->assign('COMMENTS', true);
        if (REGISTER_USER == 'ja') { // Mit Registrierung
            if ($_SESSION['customers_status']['customers_status_id'] != 1) // ... wenn nicht Gast
                $smarty->assign('NEW_COMMENT', true);
            else  // ... wenn doch Gast
                $smarty->assign('NEW_COMMENT', false);
        }
        else
            $smarty->assign('NEW_COMMENT', true);
    }
    else
        $smarty->assign('COMMENTS', false);

    list($blog_tag, $monat_raw, $blog_jahr) = explode(".", $select_item['date']);
	$desc = $select_item['description'];
	$desc = preg_replace('/##(\w+)/', '<a href="'.xtc_href_link('hashtag/\1').'">#\1</a>', $desc);
    
	$blog_monat = $monats_name[$monat_raw];
    $smarty->assign('TAG', $blog_tag);
    $smarty->assign('MONAT', $blog_monat);
    $smarty->assign('JAHR', $blog_jahr);
    $smarty->assign('NAME', $select_item['name']);
    $smarty->assign('TITEL', $select_item['title']);
    $smarty->assign('TEXT', $desc);
    $smarty->assign('img_path', 'templates/' . CURRENT_TEMPLATE . '/img/bookmark/');

    if ($_SESSION['customers_status']['customers_status_id'] == 0)
        $smarty->assign('DELETE_COMMENT', true);

    $smarty->caching = false;
} elseif (isset($_GET['blog_year']) && isset($_GET['blog_month'])) {

    $items = array();
    $select_items_query = xtc_db_query("SELECT
  											*
										  FROM
										  	" . TABLE_BLOG_ITEMS . "
										  WHERE
										  	status = 2
										  AND
											date LIKE '%.%" . (int) $_GET['blog_month'] . "." . (int) $_GET['blog_year'] . "'
										  AND
										  	language_id = '" . (int) $_SESSION['languages_id'] . "'
										  ORDER BY
										  	item_id
										  DESC");


    while ($select_items = xtc_db_fetch_array($select_items_query)) {

        $kommentare = xtc_db_fetch_array(xtc_db_query("SELECT COUNT(id) AS com_count FROM blog_comment WHERE blog_id = '" . xtc_db_input($select_items['id']) . "' "));
        if ($select_items['shortdesc'] != '') {
            $desc = $select_items['shortdesc'];
        } else {
            $desc = cseo_truncate($select_items['description'], $select_items['lenght']);
        }
        list($blog_tag_list, $monat_raw, $blog_jahr_list) = explode(".", $select_items['date']);

        $blog_monat_list = $monats_name[$monat_raw];
        $items[] = array('kommentare' => $kommentare['com_count'],
            'name' => $select_items['name'],
            'description' => $desc,
            'date' => $select_items['date'],
            'tag' => $blog_tag_list,
            'monat' => $blog_monat_list,
            'jahr' => $blog_jahr_list,
            'date_update' => $select_items['date_update'],
            'laenge' => $select_items['lenght'],
            'blog_link' => xtc_href_link(FILENAME_BLOG, 'blog_cat=' . xtc_db_input((int) $_GET['blog_cat']) . '&blog_item=' . xtc_db_input($select_items['item_id'])));
    }
    $smarty->assign('cat_name', $monate[$_GET['blog_month']] . ' ' . $_GET['blog_year']);
    $smarty->assign('blog_items', $items);
    $smarty->assign('BLOG', true);
} elseif (!isset($_GET['blog_cat'])) {
    $startseite = xtc_db_fetch_array(xtc_db_query("SELECT description FROM blog_start WHERE id = '1' AND language_id = '" . (int) $_SESSION['languages_id'] . "'"));
    $categories_array = array();
	$categories_query = xtc_db_query("SELECT *
								    FROM 
										".TABLE_BLOG_CATEGORIES."
								    WHERE 
										status = '2'
								    AND 
										language_id = '".(int)$_SESSION['languages_id']."'
								    ORDER BY 
										position ASC");

	while($categories = xtc_db_fetch_array($categories_query)){
		$categories_array[$cats] = array('CATEGORIE_ID'     => $categories['categories_id'],
										  'CATEGORIE_TITLE'  => $categories['titel'],
										  'CATEGORIE_DESCRIPTION'  => $categories['description'],
										  'CATEGORIE_LINK'   => xtc_href_link(FILENAME_BLOG,'blog_cat='.$categories['categories_id']));
		$cats++;
	}
	$smarty->assign('language', $_SESSION['language']);
	$smarty->assign('categories', $categories_array);
	$smarty->assign('TEXT', $startseite['description']);
	$smarty->assign('START', true);
}
require_once (DIR_WS_INCLUDES . 'header.php');

$smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
$smarty->assign('language', $_SESSION['language']);
$smarty->caching = false;

$cseo_blog = cseohookfactory::create_object('BlogExtender');
$cseo_blog->proceed();
$cseo_blog->get_response();
$main_content = $smarty->fetch(cseo_get_usermod(CURRENT_TEMPLATE . '/module/blog.html', USE_TEMPLATE_DEVMODE));

$smarty->loadFilter('output', 'note');
$smarty->loadFilter('output', 'trimwhitespace');

$smarty->assign('main_content', $main_content);
$smarty->display(cseo_get_usermod(CURRENT_TEMPLATE . '/index.html', USE_TEMPLATE_DEVMODE));

include ('includes/application_bottom.php');
