<?php

/* -----------------------------------------------------------------
 * 	$Id: xajax.imageprocessing.php 559 2013-08-19 14:07:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */
defined("_VALID_XTC") or die("Direct access to this location isn't allowed.");

// require_once ('includes/application_top.php');

$xajax->registerFunction('setProductImages');
$xajax->registerFunction('renderProductImages');
$xajax->registerFunction('setCategoryImages');
$xajax->registerFunction('renderCategoryImages');

include('includes/classes/' . FILENAME_IMAGEMANIPULATOR);

function setProductImages($type, $change_name) {
    $ajax = new xajaxResponse();

    $msg = '';

    if (!is_writeable(DIR_FS_CATALOG . 'images/'))
        $msg = DIR_FS_CATALOG . '<b>images</b>/ ist nicht beschreibbar<br />';

    if (!is_writeable(DIR_FS_CATALOG . 'images/product_images/'))
        $msg .= DIR_FS_CATALOG . 'images/<b>product_images</b>/ ist nicht beschreibbar<br />';

    if (!is_writeable(DIR_FS_CATALOG . 'images/product_images/info_images/'))
        $msg .= DIR_FS_CATALOG . 'images/product_images/<b>info_images</b>/ ist nicht beschreibbar<br />';

    if (!is_writeable(DIR_FS_CATALOG . 'images/product_images/popup_images/'))
        $msg .= DIR_FS_CATALOG . 'images/product_images/<b>popup_images</b>/ ist nicht beschreibbar<br />';

    if (!is_writeable(DIR_FS_CATALOG . 'images/product_images/thumbnail_images/'))
        $msg .= DIR_FS_CATALOG . 'images/product_images/<b>thumbnail_images</b>/ ist nicht beschreibbar<br />';

    if (!is_writeable(DIR_FS_CATALOG . 'images/product_images/mini_images/'))
        $msg .= DIR_FS_CATALOG . 'images/product_images/<b>mini_images</b>/ ist nicht beschreibbar<br />';

    if (!empty($msg)) {
        $msg .= '<br />Korrigieren Sie vor dem Neu-Berechnen unbedingt die Schreibrechte dieser/s Ordner/s!';
        $ajax->assign('ajax_product_msg_td', 'innerHTML', $msg);
        $ajax->assign('ajax_product_msg_td', 'style.display', 'block');
        return $ajax;
    }
    else
        $ajax->assign('ajax_product_msg_td', 'style.display', 'none');

    $files = array();
    if ($dir = opendir(DIR_FS_CATALOG_ORIGINAL_IMAGES)) {
        while ($file = readdir($dir)) {
            if (is_file(DIR_FS_CATALOG_ORIGINAL_IMAGES . $file) && ($file != "index.html") && (strtolower($file) != "thumbs.db") && ($file != '.') && ($file != '..')) {
                $files[] = array('name' => $file);
                @chmod(DIR_FS_CATALOG_ORIGINAL_IMAGES . $file, 0777);
            }
        }
        closedir($dir);
    }

    ksort($files);

    $gesamtmenge = sizeof($files);

    for ($i = 0; $i < $gesamtmenge; $i++)
        $ajax->call('xajax_renderProductImages', $gesamtmenge, $i, $files[$i]['name'], $type, $change_name);

    return $ajax;
}

function renderProductImages($total, $i, $name, $type, $change_name) {

    @set_time_limit(0);

    $ajax = new xajaxResponse();

    $old_name = $name;
    $new_name = '';
    $check = '';

    $getData = xtc_db_fetch_array(xtc_db_query("SELECT
									p.products_id,
									pd.products_name
								FROM
									" . TABLE_PRODUCTS . " p
								LEFT JOIN
									" . TABLE_PRODUCTS_DESCRIPTION . " pd ON(pd.products_id = p.products_id AND pd.language_id = '" . (int) $_SESSION['languages_id'] . "')
								WHERE
									p.products_image = '" . $old_name . "';"));

    $getMore = xtc_db_fetch_array(xtc_db_query("SELECT
									pi.products_id,
									pi.image_nr,
									pd.products_name
								FROM
									" . TABLE_PRODUCTS_DESCRIPTION . " pd
								LEFT JOIN
									" . TABLE_PRODUCTS_IMAGES . " pi ON(pd.products_id = pi.products_id)
								WHERE
									pi.image_name = '" . $old_name . "'
								AND
									pd.language_id = '" . (int) $_SESSION['languages_id'] . "';"));

    if (!empty($getData['products_name'])) {
        $checkName = $getData['products_name'];
        $checkID = $getData['products_id'];
    } elseif (!empty($getMore['products_name'])) {
        $checkName = $getMore['products_name'];
        $checkID = $getMore['products_id'];
        $checkNr = $getMore['image_nr'];
    }

    if (empty($getData['products_name']) && empty($getMore['products_name']) && $change_name == 'p_name') {
        @unlink(DIR_FS_CATALOG_ORIGINAL_IMAGES . $old_name);
        @unlink(DIR_FS_CATALOG_THUMBNAIL_IMAGES . $old_name);
        @unlink(DIR_FS_CATALOG_MINI_IMAGES . $old_name);
        @unlink(DIR_FS_CATALOG_INFO_IMAGES . $old_name);
        @unlink(DIR_FS_CATALOG_POPUP_IMAGES . $old_name);
        $ajax->prepend('deleted_image', 'innerHTML', $old_name . '<br />');
    } else {

        $pic_name = explode('.', $old_name);
        $suffix = array_pop($pic_name);

        if ($change_name == 'p_name') {
            require(DIR_FS_INC . 'cseo_get_url_friendly_text.inc.php');

            $new_products_name = cseo_get_url_friendly_text($checkName);
            // $new_products_name = $new_products_name.'_'.$getData['products_id'];

            if (!empty($getData['products_name']))
                $new_name = $new_products_name . '_' . $getData['products_id'] . '.' . strtolower($suffix);

            elseif (!empty($getMore['products_name']))
                $new_name = $new_products_name . '_' . $getMore['products_id'] . '-' . $getMore['image_nr'] . '.' . strtolower($suffix);
        } elseif ($change_name == 'p_id') {
            if (!empty($getData['products_id']))
                $new_name = $getData['products_id'] . '.' . strtolower($suffix);
            elseif (!empty($getMore['products_name']))
                $new_name = $getMore['products_id'] . '-' . $getMore['image_nr'] . '.' . strtolower($suffix);
        }

        @rename(DIR_FS_CATALOG_ORIGINAL_IMAGES . $old_name, DIR_FS_CATALOG_ORIGINAL_IMAGES . $new_name);
        @unlink(DIR_FS_CATALOG_THUMBNAIL_IMAGES . $old_name);
        @unlink(DIR_FS_CATALOG_MINI_IMAGES . $old_name);
        @unlink(DIR_FS_CATALOG_ICON_IMAGES . $old_name);
        @unlink(DIR_FS_CATALOG_POPUP_IMAGES . $old_name);

        if (!empty($getData['products_name']))
            xtc_db_query("UPDATE " . TABLE_PRODUCTS . " SET products_image = '" . $new_name . "' WHERE products_image = '" . $old_name . "'");

        elseif (!empty($getMore['products_name']))
            xtc_db_query("UPDATE " . TABLE_PRODUCTS_IMAGES . " SET image_name = '" . $new_name . "' WHERE image_name = '" . $old_name . "'");

        $products_image_name = $new_name;

        if ($type == 'all') {
            require(DIR_WS_INCLUDES . 'product_mini_images.php');
            require(DIR_WS_INCLUDES . 'product_thumbnail_images.php');
            require(DIR_WS_INCLUDES . 'product_info_images.php');
            require(DIR_WS_INCLUDES . 'product_popup_images.php');
        } elseif ($type == 'rest') {
            if (!is_file(DIR_FS_CATALOG_ICON_IMAGES . $name))
                require(DIR_WS_INCLUDES . 'product_mini_images.php');
            if (!is_file(DIR_FS_CATALOG_THUMBNAIL_IMAGES . $name))
                require(DIR_WS_INCLUDES . 'product_thumbnail_images.php');
            if (!is_file(DIR_FS_CATALOG_MINI_IMAGES . $name))
                require(DIR_WS_INCLUDES . 'product_info_images.php');
            if (!is_file(DIR_FS_CATALOG_POPUP_IMAGES . $name))
                require(DIR_WS_INCLUDES . 'product_popup_images.php');
        }

        $percent = round(((($i + 1) * 100) / $total), 1);
        $ajax->assign('show_products_process', 'style.width', $percent . '%');
        $ajax->assign('products_precents', 'innerHTML', $percent . '%');
        $ajax->assign('products_img_nr', 'innerHTML', $i + 1);
        $ajax->assign('products_img_name_old', 'innerHTML', $old_name);
        $ajax->assign('products_img_name_new', 'innerHTML', $new_name);
    }
    return $ajax;
}

function setCategoryImages() {
    $ajax = new xajaxResponse();

    $files = array();
    if ($dir = opendir(DIR_FS_CATALOG_IMAGES . 'categories_org/')) {
        while ($file = readdir($dir))
            if (is_file(DIR_FS_CATALOG_IMAGES . 'categories_org/' . $file) && ($file != "index.html") && (strtolower($file) != "thumbs.db") && ($file != '.') && ($file != '..')) {
                $files[] = array('name' => $file);
            }
        closedir($dir);
    }

    ksort($files);

    $gesamtmenge = sizeof($files);

    for ($i = 0; $i < $gesamtmenge; $i++)
        $ajax->call('xajax_renderCategoryImages', $gesamtmenge, $i, $files[$i]['name']);

    return $ajax;
}

function renderCategoryImages($total, $i, $name) {
    $ajax = new xajaxResponse();

    $categories_image_name = $name;

    require(DIR_WS_INCLUDES . 'category_image.php');
    require(DIR_WS_INCLUDES . 'category_image_info.php');

    $percent = round(((($i + 1) * 100) / $total), 1);
    $ajax->assign('show_category_process', 'style.width', $percent . '%');
    $ajax->assign('category_precents', 'innerHTML', $percent . '%');
    $ajax->assign('category_img_nr', 'innerHTML', $i + 1);
    $ajax->assign('category_img_name', 'innerHTML', $name);

    return $ajax;
}
