<?php

/* -----------------------------------------------------------------
 * 	$Id: xajax.div.php 562 2013-08-19 21:40:33Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */
defined("_VALID_XTC") or die("Direct access to this location isn't allowed.");

// require_once ('includes/application_top.php');
$xajax->registerFunction('emptyDiv');
$xajax->registerFunction('message');
$xajax->registerFunction('dialog');

function emptyDiv($div_array, $hide_layer = false) {
    $ajax = new xajaxResponse();

    if (is_array($div_array)) {
        foreach ($div_array AS $div) {
            $ajax->assign($div, 'innerHTML', '');
            $ajax->assign($div, 'style.display', 'none');
        }
    } elseif (!empty($div_array)) { // einfacher String
        $ajax->assign($div_array, 'innerHTML', '');
        $ajax->assign($div_array, 'style.display', 'none');
    }
    if ($hide_layer)
        $ajax->assign('show_overlay', 'style.display', 'none');

    return $ajax;
}

function message($msg, $type) {
    $ajax = new xajaxResponse();

    if ($type == 'error')
        $title = 'Fehler';
    elseif ($type == 'success')
        $title = 'Erfolg';
    elseif ($type == 'warning')
        $title = 'Hinweis';

    $j .= '$.gritter.add({' . "\n";
    $j .= '		title: \'' . $title . '\',' . "\n";
    $j .= '		text: \'' . $msg . '\',' . "\n";
    $j .= '		image: \'' . DIR_WS_ICONS . 'dialog-' . $type . '.png\',' . "\n";
    $j .= '		sticky: false,' . "\n";
    $j .= '		time: 1200' . "\n";
    $j .= '});';

    return $ajax->script($j);
}

function dialog($msg, $title, $w, $h) {
    $ajax = new xajaxResponse();
    $ajax->script('	var dialog = $(\'<div class="dialog-box" style="display:none"></div>\').appendTo(\'body\');
					dialog.dialog({
						close: function(event, ui) {dialog.remove();},
						modal: true,
						title: \'' . $title . '\',
						width: ' . $w . ',
						height: ' . $h . '
					});
					dialog.html(\'' . $msg . '\');
					$(\'.ui-dialog\').css({position:\'fixed\'});
					$(\'.ui-dialog-content\').css({backgroundImage:\'none\'});');
    return $ajax;
}
