<?php
/* -----------------------------------------------------------------------------------------
   $Id: ricardo.php,v 1.0 2005/04/18 Marani Alessandro (http://www.planet-marani.com)
   $Id: ricardo.php,v 2.0 2005/12/13 Leemann Patrick (http://www.xtc-services.ch)

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(cod.php,v 1.28 2003/02/14); www.oscommerce.com
   (c) 2003	 nextcommerce (invoice.php,v 1.6 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/


define('MODULE_RICARDO_TEXT_DESCRIPTION', 'Export - Ricardo.ch (; getrennt)<br><b>Format:</b><br>Titel;?;Beschreibung;?;Kat-Code;Kat-Beschreibung;Zustand-Code;Zustand-Beschreibung;Anzahl Bilder;<br>Bild Link;?;?;Startpreis;?;Sofortkaufenpreis;?;Versandcode;Versandart;Zahlungscode;<br>Zahlungsart;Auktionsstart;?;?;?;?;?;?;?;?;?;?;?;?;?;?;?;?;?;?;?;?;?;?;?');
define('MODULE_RICARDO_TEXT_TITLE', 'Ricardo.ch - CSV');
define('MODULE_RICARDO_FILE_TITLE' , '<hr noshade>Dateiname');
define('MODULE_RICARDO_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportadatei auf dem Server gespeichert werden soll.<br>(Verzeichnis export/)');
define('MODULE_RICARDO_STATUS_DESC','Modulstatus');
define('MODULE_RICARDO_STATUS_TITLE','Status');
define('MODULE_RICARDO_CURRENCY_TITLE','WР Т‘hrung');
define('MODULE_RICARDO_CURRENCY_DESC','Welche Währung soll exportiert werden?');
define('EXPORT_YES','Nur Herunterladen');
define('EXPORT_NO','Auf dem Server Speichern');
define('CURRENCY','<hr noshade><b>Währung:</b>');
define('CURRENCY_DESC','Währung in der Exportdatei');
define('EXPORT','Bitte den Sicherungsprozess AUF KEINEN FALL unterbrechen. Dieser kann einige Minuten in Anspruch nehmen.');
define('EXPORT_TYPE','<hr noshade><b>Speicherart:</b>');
define('EXPORT_STATUS_TYPE','<hr noshade><b>Kundengruppe:</b>');
define('EXPORT_STATUS','Bitte wählen Sie die Kundengruppe, die Basis für den Exportierten Preis bildet. (Falls Sie keine Kundengruppenpreise haben, wählen Sie <i>Gast</i>):</b>');

// include needed functions


  class ricardo {
    var $code, $title, $description, $enabled;


    function ricardo() {
      global $order;

      $this->code = 'ricardo';
	  $this->img = 'images/export/ricardo.gif';
      $this->title = MODULE_RICARDO_TEXT_TITLE;
      $this->description = MODULE_RICARDO_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_RICARDO_SORT_ORDER;
      $this->enabled = ((MODULE_RICARDO_STATUS == 'True') ? true : false);

    }


    function process($file) {

        @xtc_set_time_limit(0);
        require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
        $xtPrice = new xtcPrice($_POST['currencies'],$_POST['status']);

		if ($_POST['sumaurl'] == 'directurl') {
			require_once(DIR_FS_CATALOG.'inc/commerce_seo.inc.php');
			$CommerceSeo = new CommerceSeo();
		}			
		
        $schema = '';
        $export_query =xtc_db_query("SELECT
                             p.products_id,
                             pd.products_name,
                             pd.products_description,
                             p.products_model,
                             p.products_image,
                             p.products_price,
                             p.products_status,
                             p.products_shippingtime,
                             p.products_discount_allowed,
                             p.products_tax_class_id,
                             p.products_date_added,
                             m.manufacturers_name
                         FROM
                             " . TABLE_PRODUCTS . " p LEFT JOIN
                             " . TABLE_MANUFACTURERS . " m
                           ON p.manufacturers_id = m.manufacturers_id LEFT JOIN
                             " . TABLE_PRODUCTS_DESCRIPTION . " pd
                           ON p.products_id = pd.products_id AND
                            pd.language_id = '".$_SESSION['languages_id']."' LEFT JOIN
                             " . TABLE_SPECIALS . " s
                           ON p.products_id = s.products_id
                         WHERE
                           p.products_status = 1
                         ORDER BY
                            p.products_date_added DESC,
                            pd.products_name");


        while ($products = xtc_db_fetch_array($export_query)) {

            $products_price = $xtPrice->xtcGetPrice($products['products_id'],
                                        $format=false,
                                        1,
                                        $products['products_tax_class_id'],
                                        '');


            // remove trash
            $products_description = strip_tags($products['products_description']);
//            $products_description = substr($products_description, 0, 197) . '..';
            $products_description = str_replace(";",", ",$products_description);
            $products_description = str_replace("'",", ",$products_description);
            $products_description = str_replace("\n"," ",$products_description);
            $products_description = str_replace("\r"," ",$products_description);
            $products_description = str_replace("\t"," ",$products_description);
            $products_description = str_replace("\v"," ",$products_description);
            $products_description = str_replace("&quot,"," \"",$products_description);
            $products_description = str_replace("&qout,"," \"",$products_description);

            // get product categorie
            $categorie_query=xtc_db_query("SELECT
                                            categories_id
                                            FROM ".TABLE_PRODUCTS_TO_CATEGORIES."
                                            WHERE products_id='".$products['products_id']."'");
             while ($categorie_data=xtc_db_fetch_array($categorie_query)) {
                    $categories=$categorie_data['categories_id'];
             }
             $categorie_query=xtc_db_query("SELECT
                                            categories_name
                                            FROM ".TABLE_CATEGORIES_DESCRIPTION."
                                            WHERE categories_id='".$categories."'
                                            and language_id='".$_SESSION['languages_id']."'");
             $categorie_data=xtc_db_fetch_array($categorie_query);

            //create content
//                       HTTP_CATALOG_SERVER . DIR_WS_CATALOG . 'product_info.php?products_id=' . $products['products_id'] . ';' .
//                       $categorie_data['categories_name'] . ';'.
//                       $products['manufacturers_name'] .';'.

            $schema .=
            /*Titel DE*/               '"' . $products['products_name'] . '";' .
            /*Titel FR*/               '"";' .
            /*Beschreibung DE*/        '"' . $products_description . '";' .
            /*Beschreibung FR*/        '"";' .
            /*KategorieCode*/          '"";' .
            /*KategorieBeschreibung*/  '"";' .
            /*ZustandsCode*/           '"1";' .
            /*ZustandsBeschreibung*/   '"Fabrikneu";' .
            /*Stückzahl*/              '"1";' .
            /*BildLink1*/              '"' . HTTP_CATALOG_SERVER . DIR_WS_CATALOG_THUMBNAIL_IMAGES .$products['products_image'] . '";' .
            /*Bildlink2*/              '"";' .
            /*Bildlink3*/              '"";' .
            /*Startpreis*/             '"' . number_format($products_price,2,'.',''). '";' .
            /*Erhöhungsschritt*/       '"1.00";' .
            /*Sofortkaufenpreis*/      '"' . number_format($products_price,2,'.',''). '";' .
            /*Transportkosten*/        '"";' . // TODO !!
            /*Versandcode*/            '"9";' .
            /*Versandart*/             '"Paket B-Post";'  .
            /*Zahlungscode*/           '"5";' .
            /*Zahlungsart*/            '"Vorauszahlung";' .
            /*Auktionsstart*/          '"";' .
            /*Auktionsdauer*/          '"7.0";' .
            /*Reaktivieren*/           '"0";' .
            /*Top Angebot Homepage*/   '"False";' .
            /*Top Angebot Kategorie*/  '"False";' .
            /*Farbiger Hintergrund*/   '"False";' .
            /*Fetter Text*/            '"False";' .
            /*Bildergallerie*/         '"False";' .
            /*Erinnerung*/             '"False";' .
            /*Minuten vor Ablauf*/     '"60";' .
            /*Artikelnummer*/          '"' . $products['products_model'] . '";' .
            /*Unk1*/                   '"";' .
            /*Unk2*/                   '"";' .
            /*Unk3*/                   '"";' .
            /*Garantie Infos DE*/      '"";' .
            /*Garantie Infos FR*/      '"";' .
            /*Zahlungsinfos DE*/       '"";' .
            /*Zahlungsinfos FR*/       '"";' .
            /*Lieferinfos DE*/         '"' . xtc_get_shipping_status_name($products['products_shippingtime']). '";' .
            /*Lieferinfos FR*/         '"";' .
            /*Moneybookers*/           '"False";' .
            /*Treuhand*/               '"False";' .
            /*RicardoTrans*/           '"False";' .
            /*Unk4*/                   '""' . "\n";
        }
        // create File
          $fp = fopen(DIR_FS_DOCUMENT_ROOT.'export/' . $file, "w+");
          fputs($fp, $schema);
          fclose($fp);


      switch ($_POST['export']) {
        case 'yes':
            // send File to Browser
            $extension = substr($file, -3);
            $fp = fopen(DIR_FS_DOCUMENT_ROOT.'export/' . $file,"rb");
            $buffer = fread($fp, filesize(DIR_FS_DOCUMENT_ROOT.'export/' . $file));
            fclose($fp);
            header('Content-type: application/x-octet-stream');
            header('Content-disposition: attachment; filename=' . $file);
            echo $buffer;
            exit;

        break;
        }

    }

    function display() {

    $customers_statuses_array = xtc_get_customers_statuses();

    // build Currency Select
    $curr='';
    $currencies=xtc_db_query("SELECT code FROM ".TABLE_CURRENCIES);
    while ($currencies_data=xtc_db_fetch_array($currencies)) {
     $curr.=xtc_draw_radio_field('currencies', $currencies_data['code'],true).$currencies_data['code'].'<br>';
    }

    return array('text' =>  EXPORT_STATUS_TYPE.'<br>'.
                          	EXPORT_STATUS.'<br>'.
                          	xtc_draw_pull_down_menu('status',$customers_statuses_array, '1').'<br>'.
                            CURRENCY.'<br>'.
                            CURRENCY_DESC.'<br>'.
                            $curr.
                            EXPORT_TYPE.'<br>'.
                            EXPORT.'<br>'.
                          	xtc_draw_radio_field('export', 'no',false).EXPORT_NO.'<br>'.
                            xtc_draw_radio_field('export', 'yes',true).EXPORT_YES.'<br>'.
                            '<br>' . xtc_button(BUTTON_EXPORT) .

                            xtc_button_link(BUTTON_CANCEL, xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=ricardo')));

    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_RICARDO_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_RICARDO_FILE', 'ricardo.csv',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_RICARDO_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_RICARDO_STATUS','MODULE_RICARDO_FILE');
    }

  }
?>