<?php

/* --------------------------------------------------------------
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2011 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

class SQLUpdateBuilder {

    var $v_column_info_array = array();
    var $v_not_found_array = array();

    function get_table_columns($table, $db_object) {
        $query = "
				SELECT 
					COLUMN_NAME,
					DATA_TYPE
				FROM
					information_schema.COLUMNS
				WHERE
					TABLE_NAME	 = '" . $table . "' AND
					TABLE_SCHEMA = '" . $db_object->db_database . "'
			";

        $result = $db_object->query($query);
        $columns = array();

        if (mysqli_num_rows($result) == 0) {
            trigger_error('No table scheme for table ' . $table);
        }

        while ($row = mysqli_fetch_array($result)) {
            $columns[$row['COLUMN_NAME']] = $row['DATA_TYPE'];
        }
        return $columns;
    }

    function get_sql($p_table, $p_data, $p_where, $p_db_object) {
        if (isset($this->v_column_info_array[$p_table])) {
            //get column names from cache
            $columns = $this->v_column_info_array[$p_table];
        } else {
            //get column names from target table
            $columns = $this->get_table_columns($p_table, $p_db_object);
            $this->v_column_info_array[$p_table] = $columns;
        }

        $update_data = array();
        $where_part = array();

        # look for data columns in target table
        foreach ($p_data as $item) {
            if (isset($columns[$item['NAME']])) {
                # escape name and value
                $c_name = addslashes($item['NAME']);
                $c_value = addslashes($item['VALUE']);
                # source column found in target table.  ADD KEY/VALUE-PAIR
                $update_data[] = '`' . $c_name . '`="' . $c_value . '"';
            } else {
                # source column not found in target table. DO NOTHING
                if (in_array($p_table . '.' . $item['NAME'], $this->v_not_found_array) == false) {
                      echo '<strong style="color:red">SQL-Info: source column not found in target table ['.$p_table.'.'.$item['NAME'].']</strong><br>';
                    $this->v_not_found_array[] = $p_table . '.' . $item['NAME'];
                }
            }
        }

        foreach ($columns as $column => $type) {
            if (is_array($p_where) && isset($p_where[$column])) {
                $where_part[] = '`' . $column . '`="' . $p_where[$column] . '"';
            }
        }

        $query = '';
        if (sizeof($update_data) > 0) {
            $update_data = implode(", ", $update_data);
            if (is_array($p_where)) {
                if (sizeof($where_part) != sizeof($p_where)) {
                    trigger_error('where-column missing ');
                }
                $where_part = implode(" AND ", $where_part);
            } else {
                $where_part = $p_where;
            }
            $query = "UPDATE $p_table SET $update_data WHERE $where_part";
        }
        return $query;
    }
}
