<?php
/* --------------------------------------------------------------
   CheckoutByAmazon PaymentModul V1.2.1
   checkout_amazon.php 2011-10-28

   Ruhrmedia GmbH & Co. KG
   http://www.RuhrMedia.de
   Copyright (c) 2011 Ruhrmedia GmbH & Co. KG

   alkim media
   http://www.alkim.de

   Released under the GNU General Public License
   --------------------------------------------------------------
*/
?><?php
include ('includes/application_top.php');
include_once('lang/german/modules/payment/rmamazon.php');

$breadcrumb->add('Amazon Checkout', xtc_href_link('checkout_amazon.php', '', 'SSL'));

// create smarty elements
$smarty = new Smarty;
// include boxes
require (DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/source/boxes.php');
// include needed functions

require_once (DIR_FS_INC.'xtc_address_label.inc.php');
require_once (DIR_FS_INC.'xtc_get_address_format_id.inc.php');
require_once (DIR_FS_INC.'xtc_count_shipping_modules.inc.php');
require_once (DIR_FS_INC.'xtc_create_password.inc.php');

require (DIR_WS_CLASSES.'http_client.php');

// Process the Order start
if ((isset($_POST['action'])) && ($_POST['action'] == 'process')) {
	if (!isset ($_SESSION['cart']) || $_SESSION['cart']->count_contents() < 1)
		xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));

	include_once ('CheckoutByAmazon/.config.inc.php');
	include_once ('CheckoutByAmazon/functions.php');

	// Service initialisieren
        if (MODULE_PAYMENT_RMAMAZON_MODE == 'live') {
            $config = array ('ServiceURL' => 'https://payments.amazon.de/cba/api/purchasecontract/');
        } else {
            $config = array ('ServiceURL' => 'https://payments-sandbox.amazon.de/cba/api/purchasecontract/');
        }




	$service = new CheckoutByAmazon_Service_Client(MODULE_PAYMENT_RMAMAZON_ACCESKEY,MODULE_PAYMENT_RMAMAZON_SECRETKEY, $config);

	// Adressen holen
	$request1 = new CheckoutByAmazon_Service_Model_GetPurchaseContractRequest(
                     array('PurchaseContractId' => $_POST['amazon_id']));

	$cba_address = invokeGetPurchaseContract($service, $request1);
	if (($cba_address) == false) {
		// Redirect Error
		echo "Fehler 0"; die();
	}
	$cba_address_object = $cba_address->GetPurchaseContractResult->PurchaseContract->Destinations->Destination->PhysicalDestinationAttributes->ShippingAddress;
	$names_array = explode(' ',(string)$cba_address_object->Name,2);

  // Country-Name ziehen start
  $sql = "SELECT countries_name, countries_id FROM ". TABLE_COUNTRIES ." WHERE countries_iso_code_2 = '". (string)$cba_address_object->CountryCode ."' LIMIT 1";
  $country_query = xtc_db_query($sql);
  $country_result = xtc_db_fetch_array($country_query);

  // Country-Name ziehen end

	$cba_address_array = array('name' => utf8_decode((string)$cba_address_object->Name),
							'firstname' => utf8_decode($names_array[0]),
							'lastname' => utf8_decode($names_array[1]),
							'company' => '',
							'street_address' => '',
							'suburb' => '',
							'city' => utf8_decode((string)$cba_address_object->City),
							'postcode' => (string)$cba_address_object->PostalCode,
							'state' => utf8_decode((string)$cba_address_object->StateOrProvinceCode),
							'country' => array('iso_code_2' => (string)$cba_address_object->CountryCode , 'title' => $country_result['countries_name']),
							'country_iso_2' => (string)$cba_address_object->CountryCode,
							'format_id' => '5');

	$iso_code = (string)$cba_address->GetPurchaseContractResult->PurchaseContract->Destinations->Destination->PhysicalDestinationAttributes->ShippingAddress->CountryCode;
	$_SESSION['delivery_zone'] = $iso_code;

	// Produkte übermitteln
	$request2 = new CheckoutByAmazon_Service_Model_SetPurchaseItemsRequest();
	$request2->setPurchaseContractId($_POST['amazon_id']);
	$itemList = new CheckoutByAmazon_Service_Model_ItemList();

	$products = $_SESSION['cart']->get_products();

	for ($i = 0, $n = sizeof($products); $i < $n; $i ++) {
			if (isset ($products[$i]['attributes'])) {
				while (list ($option, $value) = each($products[$i]['attributes'])) {
					$attributes = xtc_db_query("select popt.products_options_name,
											   poval.products_options_values_name,
											   pa.options_values_price,
											   pa.price_prefix,
												 pa.products_attributes_id,
											   pa.attributes_stock,
											   pa.products_attributes_id,
											   pa.attributes_model
										from ".TABLE_PRODUCTS_OPTIONS." popt,
											 ".TABLE_PRODUCTS_OPTIONS_VALUES." poval,
											 ".TABLE_PRODUCTS_ATTRIBUTES." pa
												where pa.products_id = '".$products[$i]['id']."'
												and pa.options_id = '".$option."'
												and pa.options_id = popt.products_options_id
												and pa.options_values_id = '".$value."'
												and pa.options_values_id = poval.products_options_values_id
												and popt.language_id = '".(int) $_SESSION['languages_id']."'
												and poval.language_id = '".(int) $_SESSION['languages_id']."'");
					$attributes_values = xtc_db_fetch_array($attributes);
					$products[$i][$option]['products_options_name'] = $attributes_values['products_options_name'];
					$products[$i][$option]['options_values_id'] = $value;
					$products[$i][$option]['products_options_values_name'] = $attributes_values['products_options_values_name'];
					$products[$i][$option]['options_values_price'] = $attributes_values['options_values_price'];
					$products[$i][$option]['price_prefix'] = $attributes_values['price_prefix'];
					$products[$i][$option]['weight_prefix'] = $attributes_values['weight_prefix'];
					$products[$i][$option]['options_values_weight'] = $attributes_values['options_values_weight'];
					$products[$i][$option]['attributes_stock'] = $attributes_values['attributes_stock'];
					$products[$i][$option]['products_attributes_id'] = $attributes_values['products_attributes_id'];
					$products[$i][$option]['attributes_model'] = $attributes_values['attributes_model'];
				}
			}
		}

	$products_in_cart = array ();
  $item = array();
	for ($i = 0, $n = sizeof($products); $i < $n; $i ++) {

		$attribs_string = array();
		$attribs = array();
		$attributes_exist = ((isset ($products[$i]['attributes'])) ? 1 : 0);
		if ($attributes_exist == 1) {
			reset($products[$i]['attributes']);
			while (list ($option, $value) = each($products[$i]['attributes'])) {
				$attribs_string[] = $products[$i][$option]['products_attributes_id'];
				if ($products[$i][$option]['products_options_name'] != '')
					$attribs[] = $products[$i][$option]['products_options_name'] . ': ' . $products[$i][$option]['products_options_values_name'];
			}
		}
		if (sizeof($attribs) > 0) {
			$attribs = ' (' . join(', ',$attribs) . ')';
		} else {
			$attribs = '';
		}

		if (!is_numeric($products[$i]['id'])) {
			$pieces = explode('{', $products[$i]['id']);
			if (is_numeric($pieces[0])) {
				$merchantItemId = str_replace(array('{','}'), "", $products[$i]['id']);
				$pid = $pieces[0];
			} else {
				$pid = 0;
				$merchantItemId = 0;
			}
		} else {
			$pid = $products[$i]['id'];
			$merchantItemId = $pid;
		}

		$item[$i] = new CheckoutByAmazon_Service_Model_PurchaseItem();
		$item[$i]->setMerchantId(MODULE_PAYMENT_RMAMAZON_MERCHANTID);
		//$item[$i]->setSKU($products[$i]['products_model'] != '' ? 'MODEL_' . $products[$i]['products_model'] : 'ID_' . $pid);
		$item[$i]->setSKU('ID_' . $pid . '#' . join("_",$attribs_string));
		$item[$i]->setMerchantItemId(substr($merchantItemId, 0, 14));
		$item[$i]->setTitle(substr(utf8_encode($products[$i]['name'] . $attribs), 0, 80));
		$item[$i]->setQuantity((int)$products[$i]['quantity']);
		$item[$i]->setURL(substr(HTTP_SERVER, 0, 255));
		//$item[$i]->setDescription(utf8_encode($attribs));
		$item[$i]->setProductType("PHYSICAL");
		$item[$i]->setFulfillmentNetwork("MERCHANT");
		$item[$i]->setUnitPrice(new CheckoutByAmazon_Service_Model_Price(array('CurrencyCode' => "EUR", 'Amount' => $products[$i]['price'])));
	}


	// Versandkosten  übermitteln
	$cba_shipping = explode('|',$_POST['cba_select_shipping']);
  $cba_shipping[0] = round((float)$cba_shipping[0],2);
	$cost = $cba_shipping[0];
	if ($cba_shipping[2] > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] == 1) {
		$cost = round((float)$cba_shipping[0]/(100+$cba_shipping[2])*100,2);
	}
	$_SESSION['shipping'] = array('id' => $cba_shipping[1] . '_' . $cba_shipping[1], 'title' => 'Versandauswahl per AmazonCheckout', 'cost' => $cost);
	$request3 = new CheckoutByAmazon_Service_Model_SetContractChargesRequest();
	$request3->setPurchaseContractId($_POST['amazon_id']);
	$charges = new CheckoutByAmazon_Service_Model_Charges();
  $charges->setShipping(new CheckoutByAmazon_Service_Model_Price(array('CurrencyCode' => "EUR", 'Amount' => $cba_shipping[0])));
  $allowed_ot_modules = array(
                  'ot_payment', 'ot_loworderfee','ot_gv','ot_discount','ot_coupon','ot_cod_fee'
                      );


  // Order Total starten
	require_once (DIR_FS_INC.'xtc_calculate_tax.inc.php');
	require_once (DIR_FS_INC.'xtc_address_label.inc.php');
	require_once (DIR_FS_INC.'changedatain.inc.php');


	$_SESSION['payment'] = 'rmamazon';

	$item_global_save = $item;

	// load the selected shipping module
	require_once (DIR_WS_CLASSES.'shipping.php');
	$shipping_modules = new shipping($_SESSION['shipping']);

	require_once (DIR_WS_CLASSES.'order.php');
	$order = new order();

	$item = $item_global_save;

  // product-Tax Bugfix start
  for ($i = 0, $n = sizeof($order->products); $i < $n; $i ++) {
    $temp_tax = xtc_get_tax_rate($order->products[$i]['tax_class_id'],$country_result['countries_id']);
    $order->products[$i]['tax'] = $temp_tax;
  }
  // product-Tax Bugfix end

	$order->delivery = $cba_address_array;
	$order->billing = $cba_address_array;
	$is_guest_order = 0;
  if (!isset($_SESSION['customer_id'])) {

     $is_guest_order = 1;

     $order->customer['name'] = utf8_decode((string)$cba_address_object->Name);
     $order->customer['firstname'] = utf8_decode($names_array[0]);
     $order->customer['lastname'] = utf8_decode($names_array[1]);
     $order->customer['company'] = '';
     $order->customer['street_address'] = '';
     $order->customer['suburb'] = '';
     $order->customer['telephone'] = utf8_decode((string)$cba_address_object->PhoneNumber);
     $order->customer['city'] = utf8_decode((string)$cba_address_object->City);
     $order->customer['postcode'] = (string)$cba_address_object->PostalCode;
     $order->customer['state'] = utf8_decode((string)$cba_address_object->StateOrProvinceCode);
     $order->customer['country'] = array('iso_code_2' => (string)$cba_address_object->CountryCode , 'title' => $country_result['countries_name']);
     $order->customer['country_iso_2'] = (string)$cba_address_object->CountryCode;
     $order->customer['format_id'] = '5';
  }

	$order->delivery['country']['id'] = $_SESSION['AMZ_COUNTRY_ID'];
	$order->delivery['zone_id'] = $_SESSION['AMZ_ZONE_ID'];
	require_once (DIR_WS_CLASSES.'order_total.php');
	$order_total_modules = new order_total();

	$order_totals = $order_total_modules->process();

        $b = sizeof($products);
        $a = 0;
        $promotionlist = new CheckoutByAmazon_Service_Model_PromotionList();
		$promotion_value = 0;
        for ($i = 0, $n = sizeof($order_totals); $i < $n; $i ++) {

		if (in_array($order_totals[$i]['code'], $allowed_ot_modules)) {

                    if ($order_totals[$i]['code'] == 'ot_coupon') {
                    	$promotion_value += round((float)$order_totals[$i]['value']*(-1),2);
                         $a++;
                    } elseif ($order_totals[$i]['code'] == 'ot_gv') {
                    	$promotion_value += round((float)$order_totals[$i]['value']*(-1),2);
                    	$a++;
                    } elseif ($order_totals[$i]['code'] == 'ot_discount') {
                    	$promotion_value += round((float)$order_totals[$i]['value']*(-1),2);
                    	$a++;
                    } elseif ($order_totals[$i]['code'] == 'ot_payment') {
                    	$promotion_value += round((float)$order_totals[$i]['value']*(-1),2);
                    	$a++;
                    } else {
                        // Als Produkt übermitteln
                        $item[$b] = new CheckoutByAmazon_Service_Model_PurchaseItem();
                        $item[$b]->setMerchantId(MODULE_PAYMENT_RMAMAZON_MERCHANTID);
                        $item[$b]->setSKU($order_totals[$i]['code']);
                        $item[$b]->setMerchantItemId($order_totals[$i]['code']);
                        $item[$b]->setTitle($order_totals[$i]['title']);
                        $item[$b]->setQuantity(1);
                        $item[$b]->setFulfillmentNetwork("MERCHANT");
                        $item[$b]->setUnitPrice(new CheckoutByAmazon_Service_Model_Price(array('CurrencyCode' => "EUR", 'Amount' => round((float)$order_totals[$i]['value'],2))));
                        $b++;
                    }
                }
	}
        if ($a > 0 && $promotion_value != 0) {
        	$promotion = new CheckoutByAmazon_Service_Model_Promotion();
        	$promotion->setPromotionId('xxx');
        	$promotion->setDescription('Gutschein/Rabatt/Discount');
        	$promotion->setDiscount(new CheckoutByAmazon_Service_Model_Price(array('CurrencyCode' => "EUR", 'Amount' => $promotion_value)));
          $promotionlist->setPromotion($promotion);
        }
        $charges->setPromotions($promotionlist);

        $itemList->setPurchaseItem($item);
        $request2->setPurchaseItems($itemList);

	$e = invokeSetPurchaseItems($service, $request2);
	if (($e) == false) {
		// Redirect Error
		echo "Fehler 1"; die();
	}
        // Order Total end


	$request3->setCharges($charges);
	$e = invokeSetContractCharges($service, $request3);
	if (($e) == false) {
		// Redirect Error
		echo "Fehler bei Versandkosten oder Rabattberechnung"; die();
	}

	// Bestellung komplettieren und an Amazon senden
	$request4 = new CheckoutByAmazon_Service_Model_CompletePurchaseContractRequest();
	$request4->setPurchaseContractId($_POST['amazon_id']);
	$request4->setIntegratorName("Alkim_XTC3");
	if (ENABLE_SSL == false) {
		$http_server = HTTP_SERVER;
	} else {
		$http_server = HTTPS_SERVER;
	}

  $callback_url = $http_server . DIR_WS_CATALOG . "checkout_amazon_callback.php";
  if (MODULE_PAYMENT_RMAMAZON_MODE == 'live') {
    $callback_url = str_replace('http://','https://', $callback_url);
  }


  $urls = new CheckoutByAmazon_Service_Model_InstantOrderProcessingNotificationURLs(array(
	   'MerchantURL' =>  $callback_url));
	$request4->setInstantOrderProcessingNotificationURLs($urls);

	$e = invokeCompletePurchaseContract($service, $request4);
	if (($e) == false) {
		// Redirect Error
		echo "Fehler 3"; die();
	} else {
    if (sizeof($e->CompletePurchaseContractResult->OrderIds) == 1) {
			$amazon_order_id = (string)$e->CompletePurchaseContractResult->OrderIds->OrderId;
		} elseif (sizeof($e->CompletePurchaseContractResult->OrderIds) > 1) {
			$amazon_order_id = '';
			foreach ($e->CompletePurchaseContractResult->OrderIds as $oid) {
				$amazon_order_id .= (string)$oid . '#';
      }
		} else {
        echo "Fehler 4"; die();

    }


	}

  // Kundendatensatz anlegen, falls Gast
  if (!isset ($_SESSION['customer_id'])) {

    $password = xtc_create_password(8);
    $sql_data_array = array ('customers_status' => DEFAULT_CUSTOMERS_STATUS_ID_GUEST,
                             'customers_gender' => '',
                             'customers_firstname' => $order->customer['firstname'],
                             'customers_lastname' => $order->customer['lastname'],
                             'customers_dob' => '0000-00-00 00:00:00',
                             'customers_email_address' => time().'@amz_ordermodul.de',
                             'customers_default_address_id' => 'Address Book ID',
                             'customers_telephone' => (string)$cba_address_object->PhoneNumber,
                             'customers_password' => $password,
                             'customers_newsletter' => 0,
                             'customers_newsletter_mode' => 0,
                             'member_flag' => 0,
                             'delete_user' => 1,
                             'account_type' => 1
                          );
    xtc_db_perform(TABLE_CUSTOMERS, $sql_data_array);
    $customer_insert_id = xtc_db_insert_id();

    $sql_data_array = array ('customers_id' => $customer_insert_id,
                             'entry_firstname' => $order->customer['firstname'],
                             'entry_lastname' => $order->customer['lastname'],
                             'entry_street_address' => '',
                             'entry_postcode' => $order->customer['postcode'],
                             'entry_city' => $order->customer['city'],
                             'entry_country_id' => $country_result['countries_id']);
		xtc_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array);
    $customer_address_id = xtc_db_insert_id();

    xtc_db_query("update ". TABLE_CUSTOMERS ." set customers_cid = '". $customer_insert_id ."', customers_default_address_id = '".$customer_address_id."' where customers_id = '".(int) $customer_insert_id."'");
		xtc_db_query("insert into ".TABLE_CUSTOMERS_INFO." (customers_info_id, customers_info_number_of_logons, customers_info_date_account_created) values ('".(int) $customer_insert_id."', '0', now())");
    $_SESSION['customer_id'] = $customer_insert_id;
  }

  // Order speichern
	$order->info['comments'] = 'Bestellung per AmazonCheckout. Amazon OrderID: ' . $amazon_order_id;
	if ($_POST['comments_added'] != '')
		$order->info['comments'].= "\n\n" . $_POST['comments'];

	$tmp = false;
	$tmp_status = $order->info['order_status'];
	if ($_SESSION['customers_status']['customers_status_ot_discount_flag'] == 1) {
		$discount = $_SESSION['customers_status']['customers_status_ot_discount'];
	} else {
		$discount = '0.00';
	}
	if ($_SESSION['credit_covers'] != '1') {
		$sql_data_array = array ('customers_id' => $_SESSION['customer_id'], 'customers_name' => $order->customer['firstname'].' '.$order->customer['lastname'], 'customers_firstname' => $order->customer['firstname'], 'customers_lastname' => $order->customer['lastname'], 'customers_cid' => $order->customer['csID'], 'customers_vat_id' => $_SESSION['customer_vat_id'], 'customers_company' => $order->customer['company'], 'customers_status' => $_SESSION['customers_status']['customers_status_id'], 'customers_status_name' => $_SESSION['customers_status']['customers_status_name'], 'customers_status_image' => $_SESSION['customers_status']['customers_status_image'], 'customers_status_discount' => $discount, 'customers_street_address' => $order->customer['street_address'], 'customers_suburb' => $order->customer['suburb'], 'customers_city' => $order->customer['city'], 'customers_postcode' => $order->customer['postcode'], 'customers_state' => $order->customer['state'], 'customers_country' => $order->customer['country']['title'], 'customers_telephone' => $order->customer['telephone'], 'customers_email_address' => $order->customer['email_address'], 'customers_address_format_id' => $order->customer['format_id'], 'delivery_name' => $order->delivery['firstname'].' '.$order->delivery['lastname'], 'delivery_firstname' => $order->delivery['firstname'], 'delivery_lastname' => $order->delivery['lastname'], 'delivery_company' => $order->delivery['company'], 'delivery_street_address' => $order->delivery['street_address'], 'delivery_suburb' => $order->delivery['suburb'], 'delivery_city' => $order->delivery['city'], 'delivery_postcode' => $order->delivery['postcode'], 'delivery_state' => $order->delivery['state'], 'delivery_country' => $order->delivery['country']['title'], 'delivery_country_iso_code_2' => $order->delivery['country']['iso_code_2'], 'delivery_address_format_id' => $order->delivery['format_id'], 'billing_name' => $order->billing['firstname'].' '.$order->billing['lastname'], 'billing_firstname' => $order->billing['firstname'], 'billing_lastname' => $order->billing['lastname'], 'billing_company' => $order->billing['company'], 'billing_street_address' => $order->billing['street_address'], 'billing_suburb' => $order->billing['suburb'], 'billing_city' => $order->billing['city'], 'billing_postcode' => $order->billing['postcode'], 'billing_state' => $order->billing['state'], 'billing_country' => $order->billing['country']['title'], 'billing_country_iso_code_2' => $order->billing['country']['iso_code_2'], 'billing_address_format_id' => $order->billing['format_id'], 'payment_method' => $order->info['payment_method'], 'payment_class' => $order->info['payment_class'], 'shipping_method' => $order->info['shipping_method'], 'shipping_class' => $order->info['shipping_class'], 'cc_type' => $order->info['cc_type'], 'cc_owner' => $order->info['cc_owner'], 'cc_number' => $order->info['cc_number'], 'cc_expires' => $order->info['cc_expires'], 'cc_start' => $order->info['cc_start'], 'cc_cvv' => $order->info['cc_cvv'], 'cc_issue' => $order->info['cc_issue'], 'date_purchased' => 'now()', 'orders_status' => $tmp_status, 'currency' => $order->info['currency'], 'currency_value' => $order->info['currency_value'], 'customers_ip' => $customers_ip, 'language' => $_SESSION['language'], 'comments' => $order->info['comments'], 'amazon_order_id' => $amazon_order_id, 'amazon_contract_id' => $_POST['amazon_id']);
	} else {
		// free gift , no paymentaddress
		$sql_data_array = array ('customers_id' => $_SESSION['customer_id'], 'customers_name' => $order->customer['firstname'].' '.$order->customer['lastname'], 'customers_firstname' => $order->customer['firstname'], 'customers_lastname' => $order->customer['lastname'], 'customers_cid' => $order->customer['csID'], 'customers_vat_id' => $_SESSION['customer_vat_id'], 'customers_company' => $order->customer['company'], 'customers_status' => $_SESSION['customers_status']['customers_status_id'], 'customers_status_name' => $_SESSION['customers_status']['customers_status_name'], 'customers_status_image' => $_SESSION['customers_status']['customers_status_image'], 'customers_status_discount' => $discount, 'customers_street_address' => $order->customer['street_address'], 'customers_suburb' => $order->customer['suburb'], 'customers_city' => $order->customer['city'], 'customers_postcode' => $order->customer['postcode'], 'customers_state' => $order->customer['state'], 'customers_country' => $order->customer['country']['title'], 'customers_telephone' => $order->customer['telephone'], 'customers_email_address' => $order->customer['email_address'], 'customers_address_format_id' => $order->customer['format_id'], 'delivery_name' => $order->delivery['firstname'].' '.$order->delivery['lastname'], 'delivery_firstname' => $order->delivery['firstname'], 'delivery_lastname' => $order->delivery['lastname'], 'delivery_company' => $order->delivery['company'], 'delivery_street_address' => $order->delivery['street_address'], 'delivery_suburb' => $order->delivery['suburb'], 'delivery_city' => $order->delivery['city'], 'delivery_postcode' => $order->delivery['postcode'], 'delivery_state' => $order->delivery['state'], 'delivery_country' => $order->delivery['country']['title'], 'delivery_country_iso_code_2' => $order->delivery['country']['iso_code_2'], 'delivery_address_format_id' => $order->delivery['format_id'], 'payment_method' => $order->info['payment_method'], 'payment_class' => $order->info['payment_class'], 'shipping_method' => $order->info['shipping_method'], 'shipping_class' => $order->info['shipping_class'], 'cc_type' => $order->info['cc_type'], 'cc_owner' => $order->info['cc_owner'], 'cc_number' => $order->info['cc_number'], 'cc_expires' => $order->info['cc_expires'], 'date_purchased' => 'now()', 'orders_status' => $tmp_status, 'currency' => $order->info['currency'], 'currency_value' => $order->info['currency_value'], 'customers_ip' => $customers_ip, 'comments' => $order->info['comments'], 'language' => $_SESSION['language'],  'amazon_order_id' => $amazon_order_id, 'amazon_contract_id' => $_POST['amazon_id']);
	}

	xtc_db_perform(TABLE_ORDERS, $sql_data_array);
	$insert_id = xtc_db_insert_id();
	$last_order = $insert_id;

	$_SESSION['tmp_oID'] = $insert_id;
	for ($i = 0, $n = sizeof($order_totals); $i < $n; $i ++) {
		$sql_data_array = array ('orders_id' => $insert_id, 'title' => $order_totals[$i]['title'], 'text' => $order_totals[$i]['text'], 'value' => $order_totals[$i]['value'], 'class' => $order_totals[$i]['code'], 'sort_order' => $order_totals[$i]['sort_order']);
		xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
	}

	$customer_notification = (SEND_EMAILS == 'true') ? '1' : '0';
	$sql_data_array = array ('orders_id' => $insert_id, 'orders_status_id' => $order->info['order_status'], 'date_added' => 'now()', 'customer_notified' => $customer_notification, 'comments' => $order->info['comments']);
	xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);

	for ($i = 0, $n = sizeof($order->products); $i < $n; $i ++) {
		// Stock Update - Joao Correia
		if (STOCK_LIMITED == 'true') {
			if (DOWNLOAD_ENABLED == 'true') {
				// BOF GM_MOD:
				$stock_query_raw = "SELECT p.products_quantity,
																	 pad.products_attributes_filename,
                                   pa.products_attributes_id
														FROM ".TABLE_PRODUCTS." p
														LEFT JOIN ".TABLE_PRODUCTS_ATTRIBUTES." pa
														 ON p.products_id=pa.products_id
														LEFT JOIN ".TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD." pad
														 ON pa.products_attributes_id=pad.products_attributes_id
														WHERE p.products_id = '".xtc_get_prid($order->products[$i]['id'])."'";
				// Will work with only one option for downloadable products
				// otherwise, we have to build the query dynamically with a loop
				$products_attributes = $order->products[$i]['attributes'];
				if (is_array($products_attributes)) {
					$stock_query_raw .= " AND pa.options_id = '".$products_attributes[0]['option_id']."' AND pa.options_values_id = '".$products_attributes[0]['value_id']."'";
				}
				$stock_query = xtc_db_query($stock_query_raw);
			} else {
				$stock_query = xtc_db_query("select products_quantity from ".TABLE_PRODUCTS." where products_id = '".xtc_get_prid($order->products[$i]['id'])."'");
			}
			if (xtc_db_num_rows($stock_query) > 0) {
				$stock_values = xtc_db_fetch_array($stock_query);
				// do not decrement quantities if products_attributes_filename exists
				if ((DOWNLOAD_ENABLED != 'true') || (!$stock_values['products_attributes_filename'])) {
					$stock_left = $stock_values['products_quantity'] - $order->products[$i]['qty'];
				} else {
					$stock_left = $stock_values['products_quantity'];
				}

				xtc_db_query("update ".TABLE_PRODUCTS." set products_quantity = '".$stock_left."' where products_id = '".xtc_get_prid($order->products[$i]['id'])."'");


			}
		}

		// Update products_ordered (for bestsellers list)
		// BOF GM_MOD:
		xtc_db_query("update ".TABLE_PRODUCTS." set products_ordered = products_ordered + ".(double)$order->products[$i]['qty']." where products_id = '".xtc_get_prid($order->products[$i]['id'])."'");

		$sql_data_array = array ('orders_id' => $insert_id, 'products_id' => xtc_get_prid($order->products[$i]['id']), 'products_model' => $order->products[$i]['model'], 'products_name' => $order->products[$i]['name'],'products_shipping_time'=>$order->products[$i]['shipping_time'], 'products_price' => $order->products[$i]['price'], 'final_price' => $order->products[$i]['final_price'], 'products_tax' => $order->products[$i]['tax'], 'products_discount_made' => $order->products[$i]['discount_allowed'], 'products_quantity' => $order->products[$i]['qty'], 'allow_tax' => $_SESSION['customers_status']['customers_status_show_price_tax']);

		xtc_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array);
		$order_products_id = xtc_db_insert_id();

		// Aenderung Specials Quantity Anfang
		$specials_result = xtc_db_query("SELECT products_id, specials_quantity from ".TABLE_SPECIALS." WHERE products_id = '".xtc_get_prid($order->products[$i]['id'])."' ");
		if (xtc_db_num_rows($specials_result)) {
			$spq = xtc_db_fetch_array($specials_result);

			$new_sp_quantity = ($spq['specials_quantity'] - $order->products[$i]['qty']);

			if ($new_sp_quantity >= 1) {
				xtc_db_query("update ".TABLE_SPECIALS." set specials_quantity = '".$new_sp_quantity."' where products_id = '".xtc_get_prid($order->products[$i]['id'])."' ");
			} elseif(STOCK_CHECK == 'true') { // BOF GM_MOD:
				xtc_db_query("update ".TABLE_SPECIALS." set status = '0', specials_quantity = '".$new_sp_quantity."' where products_id = '".xtc_get_prid($order->products[$i]['id'])."' ");
			}
		}
		// Aenderung Ende

		$order_total_modules->update_credit_account($i); // GV Code ICW ADDED FOR CREDIT CLASS SYSTEM
		//------insert customer choosen option to order--------
		$attributes_exist = '0';
		$products_ordered_attributes = '';
		if (isset ($order->products[$i]['attributes'])) {
			$attributes_exist = '1';
			for ($j = 0, $n2 = sizeof($order->products[$i]['attributes']); $j < $n2; $j ++) {
				if (DOWNLOAD_ENABLED == 'true') {
					$attributes_query = "select popt.products_options_name,
																   poval.products_options_values_name,
																   pa.options_values_price,
																   pa.price_prefix,
																   pad.products_attributes_maxdays,
																   pad.products_attributes_maxcount,
																   pad.products_attributes_filename
																   from ".TABLE_PRODUCTS_OPTIONS." popt, ".TABLE_PRODUCTS_OPTIONS_VALUES." poval, ".TABLE_PRODUCTS_ATTRIBUTES." pa
																   left join ".TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD." pad
																	on pa.products_attributes_id=pad.products_attributes_id
																   where pa.products_id = '".$order->products[$i]['id']."'
																	and pa.options_id = '".$order->products[$i]['attributes'][$j]['option_id']."'
																	and pa.options_id = popt.products_options_id
																	and pa.options_values_id = '".$order->products[$i]['attributes'][$j]['value_id']."'
																	and pa.options_values_id = poval.products_options_values_id
																	and popt.language_id = '".$_SESSION['languages_id']."'
																	and poval.language_id = '".$_SESSION['languages_id']."'";
					$attributes = xtc_db_query($attributes_query);
				} else {
					$attributes = xtc_db_query("select popt.products_options_name,
																				 poval.products_options_values_name,
																				 pa.options_values_price,
																				 pa.price_prefix
																				 from ".TABLE_PRODUCTS_OPTIONS." popt, ".TABLE_PRODUCTS_OPTIONS_VALUES." poval, ".TABLE_PRODUCTS_ATTRIBUTES." pa
																				 where pa.products_id = '".$order->products[$i]['id']."'
																				 and pa.options_id = '".$order->products[$i]['attributes'][$j]['option_id']."'
																				 and pa.options_id = popt.products_options_id
																				 and pa.options_values_id = '".$order->products[$i]['attributes'][$j]['value_id']."'
																				 and pa.options_values_id = poval.products_options_values_id
																				 and popt.language_id = '".$_SESSION['languages_id']."'
																				 and poval.language_id = '".$_SESSION['languages_id']."'");
				}
				// update attribute stock
				xtc_db_query("UPDATE ".TABLE_PRODUCTS_ATTRIBUTES." set
														   attributes_stock=attributes_stock - '".$order->products[$i]['qty']."'
														   where
														   products_id='".$order->products[$i]['id']."'
														   and options_values_id='".$order->products[$i]['attributes'][$j]['value_id']."'
														   and options_id='".$order->products[$i]['attributes'][$j]['option_id']."'
														   ");

				$attributes_values = xtc_db_fetch_array($attributes);

				$sql_data_array = array ('orders_id' => $insert_id, 'orders_products_id' => $order_products_id, 'products_options' => $attributes_values['products_options_name'], 'products_options_values' => $attributes_values['products_options_values_name'], 'options_values_price' => $attributes_values['options_values_price'], 'price_prefix' => $attributes_values['price_prefix'], 'products_attributes_id' => $attributes_values['products_attributes_id']);
				xtc_db_perform(TABLE_ORDERS_PRODUCTS_ATTRIBUTES, $sql_data_array);

				if ((DOWNLOAD_ENABLED == 'true') && isset ($attributes_values['products_attributes_filename']) && xtc_not_null($attributes_values['products_attributes_filename'])) {
					$sql_data_array = array ('orders_id' => $insert_id, 'orders_products_id' => $order_products_id, 'orders_products_filename' => $attributes_values['products_attributes_filename'], 'download_maxdays' => $attributes_values['products_attributes_maxdays'], 'download_count' => $attributes_values['products_attributes_maxcount']);
					xtc_db_perform(TABLE_ORDERS_PRODUCTS_DOWNLOAD, $sql_data_array);
				}



			}
		}
		//------insert customer choosen option eof ----
		$total_weight += ($order->products[$i]['qty'] * $order->products[$i]['weight']);
		$total_tax += xtc_calculate_tax($total_products_price, $products_tax) * $order->products[$i]['qty'];
		$total_cost += $total_products_price;

	}

	if (isset ($_SESSION['tracking']['refID'])) {

		xtc_db_query("update ".TABLE_ORDERS." set
										 refferers_id = '".$_SESSION['tracking']['refID']."'
										 where orders_id = '".$insert_id."'");

		// check if late or direct sale
		$customers_logon_query = "SELECT customers_info_number_of_logons
												FROM ".TABLE_CUSTOMERS_INFO."
												WHERE customers_info_id  = '".$_SESSION['customer_id']."'";
		$customers_logon_query = xtc_db_query($customers_logon_query);
		$customers_logon = xtc_db_fetch_array($customers_logon_query);

		if ($customers_logon['customers_info_number_of_logons'] == 0) {
			// direct sale
			xtc_db_query("update ".TABLE_ORDERS." set
											 conversion_type = '1'
											 where orders_id = '".$insert_id."'");
		} else {
			// late sale

			xtc_db_query("update ".TABLE_ORDERS." set
											 conversion_type = '2'
											 where orders_id = '".$insert_id."'");
		}

	} else {

		$customers_query = xtc_db_query("SELECT refferers_id as ref FROM ".TABLE_CUSTOMERS." WHERE customers_id='".$_SESSION['customer_id']."'");
		$customers_data = xtc_db_fetch_array($customers_query);
		if (xtc_db_num_rows($customers_query)) {

			xtc_db_query("update ".TABLE_ORDERS." set
											 refferers_id = '".$customers_data['ref']."'
											 where orders_id = '".$insert_id."'");
			// check if late or direct sale
			$customers_logon_query = "SELECT customers_info_number_of_logons
													FROM ".TABLE_CUSTOMERS_INFO."
													WHERE customers_info_id  = '".$_SESSION['customer_id']."'";
			$customers_logon_query = xtc_db_query($customers_logon_query);
			$customers_logon = xtc_db_fetch_array($customers_logon_query);

			if ($customers_logon['customers_info_number_of_logons'] == 0) {
				// direct sale
				xtc_db_query("update ".TABLE_ORDERS." set
												 conversion_type = '1'
												 where orders_id = '".$insert_id."'");
			} else {
				// late sale

				xtc_db_query("update ".TABLE_ORDERS." set
												 conversion_type = '2'
												 where orders_id = '".$insert_id."'");
			}
		}

	}

	// Update Orders Status
	xtc_db_query("UPDATE ". TABLE_ORDERS ." SET orders_status = '". MODULE_PAYMENT_RMAMAZON_ORDER_STATUS_NOTIFIED ."' WHERE orders_id = '". $insert_id ."' LIMIT 1");
	xtc_db_query("INSERT INTO ". TABLE_ORDERS_STATUS_HISTORY ." SET orders_id = '". $insert_id ."', orders_status_id = '". MODULE_PAYMENT_RMAMAZON_ORDER_STATUS_NOTIFIED ."', date_added = now(), 	customer_notified='0'");

	$order_totals = $order_total_modules->apply_credit();

	$_SESSION['cart']->reset(true);
	// unregister session variables used during checkout
	unset ($_SESSION['sendto']);
	unset ($_SESSION['billto']);
	unset ($_SESSION['shipping']);
	unset ($_SESSION['payment']);
	unset ($_SESSION['comments']);
	unset ($_SESSION['last_order']);
	unset ($_SESSION['tmp_oID']);
	unset ($_SESSION['cc']);
	unset ($_SESSION['nvpReqArray']);
	unset ($_SESSION['reshash']);

	//GV Code Start
	if (isset ($_SESSION['credit_covers']))
		unset ($_SESSION['credit_covers']);

	if (!isset ($_SESSION['customer_id'])) {
    $_SESSION['amazon_checkout'] = 1;
  }
	xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SUCCESS, '', 'SSL'));

	die();
}
// Process the Order end

// BOF GM_MOD
// minimum/maximum order value
if ($_SESSION['cart']->show_total() > 0 ) {
 if ($_SESSION['cart']->show_total() < $_SESSION['customers_status']['customers_status_min_order'] ) {
  $_SESSION['allow_checkout'] = 'false';
 }
 if  ($_SESSION['customers_status']['customers_status_max_order'] != 0) {
  if ($_SESSION['cart']->show_total() > $_SESSION['customers_status']['customers_status_max_order'] ) {
  $_SESSION['allow_checkout'] = 'false';
  }
 }
}
// EOF GM_MOD



// check if checkout is allowed
if ($_SESSION['allow_checkout'] == 'false')
	xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));

// if the customer is not logged on, redirect them to the login page
if (!isset ($_SESSION['customer_id'])) {
	if (MODULE_PAYMENT_RMAMAZON_ALLOW_GUESTS == 'True') {
		$guest_order = true;
	} else {
		xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
	}
}

// if there is nothing in the customers cart, redirect them to the shopping cart page
if ($_SESSION['cart']->count_contents() <= 0) {
	xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}

// Check if Amazon ID is set and Amazon is allowed
if ((isset($_SESSION['amazon_id'])) && ($_SESSION['amazon_id'] != '') && (MODULE_PAYMENT_RMAMAZON_STATUS == 'True')) {
	$amazon_id = $_SESSION['amazon_id'];
} else {
	xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}

require (DIR_WS_INCLUDES.'header.php');


//check if display conditions on checkout page is true
// BOF GM_MOD:
// if (gm_get_conf('GM_SHOW_CONDITIONS') == 1) {

	if (GROUP_CHECK == 'true') {
		$group_check = "and group_ids LIKE '%c_" . $_SESSION['customers_status']['customers_status_id'] . "_group%'";
	}

	$shop_content_query = xtc_db_query("SELECT
	                                                content_title,
	                                                content_heading,
	                                                content_text,
	                                                content_file
	                                                FROM " . TABLE_CONTENT_MANAGER . "
	                                                WHERE content_group='3' " . $group_check . "
	                                                AND languages_id='" . $_SESSION['languages_id'] . "'");
	$shop_content_data = xtc_db_fetch_array($shop_content_query);

	if ($shop_content_data['content_file'] != '') {

		$conditions = '<iframe src="' . (defined('GM_HTTP_SERVER') ? GM_HTTPS_SERVER : HTTPS_SERVER) . DIR_WS_CATALOG . 'media/content/' . $shop_content_data['content_file'] . '" width="99%" height="150">';
		$conditions .= '</iframe>';
	} else {
		// BOF GM_MOD:
		$conditions = '<textarea style="width:97%; height:150px"  name="conditions_text" readonly="readonly">' . trim(strip_tags(str_replace('<br />', "\n", $shop_content_data['content_text']))) . '</textarea>';
	}

	$smarty->assign('AGB', $conditions);
	$smarty->assign('AGB_LINK', $main->getContentLink(3, MORE_INFO));

// }

// BOF GM_MOD
// if(gm_get_conf('GM_CHECK_CONDITIONS') == 1){
	// LUUPAY ZAHLUNGSMODUL
	if (isset ($_GET['step']) && $_GET['step'] == 'step2') {
		// BOF GM_MOD:
		$smarty->assign('CHECKBOX_AGB', '<input type="checkbox" value="conditions" name="conditions" id="cba_conditions" checked="checked"  class="cba_confirm_boxes"/>');
	} else {
		unset($_SESSION['conditions']);
		$smarty->assign('CHECKBOX_AGB', '<input type="checkbox" value="conditions" name="conditions" id="cba_conditions"  class="cba_confirm_boxes"/>');
	}
	// LUUPAY END
// }
// EOF GM_MOD


// BOF GM_MOD
//check if display withdrawal on checkout page is true
// if (gm_get_conf('GM_SHOW_WITHDRAWAL') == 1) {

	if (GROUP_CHECK == 'true') {
		$group_check = "and group_ids LIKE '%c_" . $_SESSION['customers_status']['customers_status_id'] . "_group%'";
	}

	$shop_content_query = xtc_db_query("SELECT
	                                                content_title,
	                                                content_heading,
	                                                content_text,
	                                                content_file
	                                                FROM " . TABLE_CONTENT_MANAGER . "
	                                                WHERE content_group='10' " . $group_check . "
	                                                AND languages_id='" . $_SESSION['languages_id'] . "'");
	$shop_content_data = xtc_db_fetch_array($shop_content_query);

	if ($shop_content_data['content_file'] != '') {

		$withdrawal = '<iframe src="' . (defined('GM_HTTP_SERVER') ? GM_HTTPS_SERVER : HTTPS_SERVER) . DIR_WS_CATALOG . 'media/content/' . $shop_content_data['content_file'] . '" width="99%" height="150">';
		$withdrawal .= '</iframe>';
	} else {
		// BOF GM_MOD:
		$withdrawal = '<textarea  style="width:99%; height:150px" name="withdrawal_text" readonly="readonly">' . trim(strip_tags(str_replace('<br />', "\n", $shop_content_data['content_text']))) . '</textarea>';
	}

	$smarty->assign('WITHDRAWAL', $withdrawal);

// }
// EOF GM_MOD

// BOF GM_MOD
// if(gm_get_conf('GM_CHECK_WITHDRAWAL') == 1){
	unset($_SESSION['withdrawal']);
	$smarty->assign('CHECKBOX_WITHDRAWAL', '<input type="checkbox" value="withdrawal" name="withdrawal" id="cba_withdrawal" class="cba_confirm_boxes" />');
// }
// EOF GM_MOD

$smarty->assign('COMMENTS', xtc_draw_textarea_field('comments', 'soft', '60', '5', $_SESSION['comments'], 'style="width:99%"') . xtc_draw_hidden_field('comments_added', 'YES'));

$smarty->assign('AMZ_ZOLL', AMZ_ZOLL);
$smarty->assign('AMZ_NO_PAYMENT', NO_SHIPPING_TO_ADDRESS);

// BOF GM_MOD
// $smarty->assign('LIGHTBOX', gm_get_conf('GM_LIGHTBOX_CHECKOUT'));
if($_SESSION['style_edit_mode'] == 'edit') $smarty->assign('STYLE_EDIT', 1);
else $smarty->assign('STYLE_EDIT', 0);
// BOF GM_MOD

$smarty->assign('FORM_ACTION', xtc_draw_form('checkout_amazon', xtc_href_link('checkout_amazon.php', '', 'SSL')).xtc_draw_hidden_field('action', 'process') . xtc_draw_hidden_field('amazon_id',$_GET['amazon_id']));

// $smarty->assign('BUTTON_BACK', '<a href="'.FILENAME_SHOPPING_CART.'"><img src="templates/' . CURRENT_TEMPLATE . '/buttons/' . $_SESSION['language'] . '/button_back.gif" title="'.CANCEL.'" alt="'.CANCEL.'"/></a>');
$smarty->assign('BUTTON_BACK', '<a href="javascript:history.back();">'.xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK).'</a>');
// $smarty->assign('BUTTON_CONTINUE', '<img style="cursor:pointer;" onclick="cba_submit_order()" title="'.IMAGE_BUTTON_CONFIRM_ORDER.'" alt="Bestellung bestätigen" src="templates/' . CURRENT_TEMPLATE . '/buttons/' . $_SESSION['language'] . '/button_confirm_order.gif">');
$smarty->assign('BUTTON_CONTINUE', '<a href="javascript:void(0)">'.cseo_wk_image_button('button_confirm_order.gif', IMAGE_BUTTON_CONFIRM_ORDER, 'onclick="cba_submit_order()"').'</a>');
$smarty->assign('FORM_END', '</form>');

$smarty->assign('language', $_SESSION['language']);

$smarty->caching = false;
$main_content = $smarty->fetch(CURRENT_TEMPLATE.'/module/checkout_amazon.html');

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content', $main_content);
$smarty->caching = false;

$smarty->display(CURRENT_TEMPLATE.'/index.html');
include ('includes/application_bottom.php');
