<?php
/*-----------------------------------------------------------------
* 	ID:						ot_coupon.php
* 	Letzter Stand:			v2.3
* 	zuletzt geaendert von:	cseoak
* 	Datum:					2012/11/19
*
* 	Copyright (c) since 2010 commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
* 	Released under the GNU General Public License
* ---------------------------------------------------------------*/

class ot_coupon {
	var $title, $output;

	function ot_coupon() {
		global $xtPrice;

		$this->code = 'ot_coupon';
		$this->header = MODULE_ORDER_TOTAL_COUPON_HEADER;
		$this->title = MODULE_ORDER_TOTAL_COUPON_TITLE;
		$this->description = MODULE_ORDER_TOTAL_COUPON_DESCRIPTION;
		$this->user_prompt = '';
		$this->enabled = MODULE_ORDER_TOTAL_COUPON_STATUS;
		$this->sort_order = MODULE_ORDER_TOTAL_COUPON_SORT_ORDER;
		$this->include_shipping = MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING;
		$this->calculate_tax = MODULE_ORDER_TOTAL_COUPON_CALC_TAX;
		$this->credit_class = true;
		$this->output = array ();

		// MODUL DEAKTIVIEREN FALLS KUNDE KEINE PREISE SEHEN DARF
		if ($_SESSION['customers_status']['customers_status_show_price'] == 0) {
			$this->enabled = 'false';
		}
		
	}

// AUSGABE AUF CHECKOUT_CONFIRMATION
	function process() {
		global $order, $xtPrice;

		if (isset ($_SESSION['cc_id']) && $this->enabled == 'true') {
		
			// RABATT-SUMME BERECHNEN
			$order_total = $this->get_order_total();
		
			// RABATT BERECHNEN
			$this->deduction = $this->calculate_credit($order_total);

			// STEUER BERECHNEN
		   	if ($this->calculate_tax == 'true') {
				$this->tax_deduction = $this->calculate_tax_deduction($this->deduction, $order_total);
				$order->info['subtotal'] = round($order->info['subtotal'] - $this->deduction, 2);
			}

			// AUSGABE
			if ($this->deduction > 0) {
				$order->info['deduction'] = $this->deduction;
				$order->info['total'] = $order->info['total'] - round($this->deduction, 2);
				if ($order->info['total'] < 0.0049) {
					$order->info['total'] = 0.00; 
					$order->info['tax'] = 0.00; 
				}
				$this->output[] = array ('title' => $this->title . ' (' . $this->coupon_code . '):', 'text' => '<font color="#ff0000">-' . $xtPrice->xtcFormat($this->deduction, true) . '</font>', 'value' => $xtPrice->xtcFormat($this->deduction, false)); 
			}
		}
	}

// RABATT-SUMME BERECHNEN
	function get_order_total() {																
		global $order, $xtPrice;
		
		// RABATT-SUMME UND ANTEILIGE SUMMEN EINZELNER STEUERKLASSEN AUF NULL SETZEN
		$order_total = 0.00;
		reset($order->info['tax_groups']);
		while (list ($key, $value) = each($order->info['tax_groups'])) {
			$key_no_pre = str_replace(TAX_NO_TAX, "", $key);
			$key_no_pre = str_replace(TAX_ADD_TAX, "", $key_no_pre);
			$this->sum_tax["$key_no_pre"] = 0.00;
		}

		// INFOS ÜBER KUPON AUSLESEN
		$coupon_query = xtc_db_query("select restrict_to_categories, restrict_to_products from " . TABLE_COUPONS . " where coupon_id = '" . (int) $_SESSION['cc_id'] . "' limit 1");
		$coupon_result = xtc_db_fetch_array($coupon_query);

		// SCHLEIFE FÜR ALLE PRODUKTE IM KORB
		$products = $_SESSION['cart']->get_products();			
		for ($i = 0; $i < sizeof($products); $i ++) {
			
			// GRUNDFORM DER ARTIKELNUMMER
			$t_prid = xtc_get_prid($products[$i]['id']);

			// KUPONS OHNE BESCHRÜNKUNGEN : RABATT-SUMME ANHAND ALLER ARTIKEL IM KORB BERECHNEN
			if ($coupon_result['restrict_to_categories'] == '' && $coupon_result['restrict_to_products'] == '') {
				$products_price = $this->get_products_price($t_prid, $products[$i]['id']);
				$order_total += $_SESSION['cart']->contents[$products[$i]['id']]['qty'] * $products_price[0];
				$this->sum_tax["$products_price[1]"] += $_SESSION['cart']->contents[$products[$i]['id']]['qty'] * $products_price[0];

			// BESCHRÄNKUNG AUF KATEGORIEN : RABATT-SUMME ANHAND GÜLTIGER ARTIKEL BERECHNEN
			} else if ($coupon_result['restrict_to_categories'] != '') {
				$product_found = false;
				$cat_ids = split("[,]", $coupon_result['restrict_to_categories']);
				// SCHLEIFE FÜR ALLE GÜLTIGEN KATEGORIEN
				for ($ii = 0; $ii < count($cat_ids); $ii ++) {
					// IN DER AKTUELLEN KATEGORIE NACH UNTERKATEGORIEN SUCHEN
					$subcat_ids = array ();
					require_once (DIR_FS_INC . 'xtc_get_subcategories.inc.php');
					xtc_get_subcategories($subcat_ids, $cat_ids[$ii]);	
					// WENN UNTERKATEGORIEN VORHANDEN SIND, AUCH DIESE DURCHSUCHEN
					if (sizeof($subcat_ids) > 0) {
						for ($iii = 0; $iii < sizeof($subcat_ids); $iii ++) {
							$cat_query = xtc_db_query("select products_id from products_to_categories where products_id = '" . $t_prid . "' and (categories_id = '" . $cat_ids[$ii] . "' or categories_id = '" . $subcat_ids[$iii] . "')");
							if (xtc_db_num_rows($cat_query) != 0  && $product_found == false) {
								$products_price = $this->get_products_price($t_prid, $products[$i]['id']);
								$order_total += $_SESSION['cart']->contents[$products[$i]['id']]['qty'] * $products_price[0];
								$this->sum_tax["$products_price[1]"] += $_SESSION['cart']->contents[$products[$i]['id']]['qty'] * $products_price[0];
								$product_found = true;
							}
						}
					// KEINE UNTERKATEGORIEN VORHANDEN, DANN NUR HAUPTKATEGORIE DURCHSUCHEN
					} else {				
						$cat_query = xtc_db_query("select products_id from products_to_categories where products_id = '" . $t_prid . "' and categories_id = '" . $cat_ids[$ii] . "'");
						if (xtc_db_num_rows($cat_query) != 0  && $product_found == false) {
							$products_price = $this->get_products_price($t_prid, $products[$i]['id']);
							$order_total += $_SESSION['cart']->contents[$products[$i]['id']]['qty'] * $products_price[0];
							$this->sum_tax["$products_price[1]"] += $_SESSION['cart']->contents[$products[$i]['id']]['qty'] * $products_price[0];
							$product_found = true;
						}
					}
				}
		
			// BESCHRÄNKUNG AUF PRODUKTE : RABATT-SUMME ANHAND GÜLTIGER ARTIKEL BERECHNEN
			} else if ($coupon_result['restrict_to_products'] != '') {
				$pr_ids = split("[,]", $coupon_result['restrict_to_products']);
				// SCHLEIFE FÜR ALLE GÜLTIGEN PRODUKTE
				for ($ii = 0; $ii < count($pr_ids); $ii ++) {
					if ($t_prid == $pr_ids[$ii]){	
						$products_price = $this->get_products_price($t_prid, $products[$i]['id']);
						$order_total += $_SESSION['cart']->contents[$products[$i]['id']]['qty'] * $products_price[0];
						$this->sum_tax["$products_price[1]"] += $_SESSION['cart']->contents[$products[$i]['id']]['qty'] * $products_price[0];
					}
				}
			}		
		}
		
		// WENN VERSANDKOSTEN INKLUSIVE, DANN VERSANDKOSTEN ZUR RABATT-SUMME ADDIEREN
		if ($this->include_shipping == 'true') {

			// VERSANDKOSTEN ZUR RABATT-SUMME ADDIEREN
			$order_total = $order_total + $order->info['shipping_cost'];

			// VERSANDKOSTEN ANTEILIG DER STEUERKLASSE
	        $shipping_module = substr($_SESSION['shipping']['id'], 0, strpos($_SESSION['shipping']['id'], '_'));
			$shipping_tax_desc = xtc_get_tax_description($GLOBALS[$shipping_module]->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
			$this->sum_tax["$shipping_tax_desc"] += $order->info['shipping_cost'];
			
			// WENN STEUER EXKLUSIVE UND KUNDE MIT NETTO PREISEN, DANN STEUER DER VERSANDKOSTEN ZUR RABATT-SUMME ADDIEREN
			if ($this->calculate_tax == 'false' && $_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
				$shipping_tax_rate = xtc_get_tax_rate($GLOBALS[$shipping_module]->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
				$order_total = $order_total + ($order->info['shipping_cost'] * ($shipping_tax_rate / 100 +1) - $order->info['shipping_cost']);
			}
		}
	
		return $order_total;
	}

// RABATT BERECHNEN
	function calculate_credit($amount) {
		global $order;
		
		// INFOS ÜBER DEN KUPON AUSLESEN		
		$coupon_query = xtc_db_query("select coupon_type, coupon_amount, coupon_code from " . TABLE_COUPONS . " where coupon_id = '" . (int) $_SESSION['cc_id'] . "' limit 1");
		$coupon_result = xtc_db_fetch_array($coupon_query);

		// KUPON CODE UND TYP FESTLEGEN
		$this->coupon_code = $coupon_result['coupon_code'];
		$this->coupon_type = $coupon_result['coupon_type'];

		// RABATT FORMATIEREN
		if ($this->coupon_type == 'P') {
			$od_amount = $amount * $coupon_result['coupon_amount'] / 100;
		} else if ($this->coupon_type == 'F') {
			$od_amount = $coupon_result['coupon_amount'];
		} else if ($this->coupon_type == 'S') {
			$od_amount = $order->info['shipping_cost'];
			// WENN VERSANDKOSTEN NICHT INKLUSIVE UND KUNDEN MIT BRUTTO PREISEN, DANN STEUER ADDIEREN
			if ($this->include_shipping == 'false' && $_SESSION['customers_status']['customers_status_show_price_tax'] == 1) {
				$shipping_module = substr($_SESSION['shipping']['id'], 0, strpos($_SESSION['shipping']['id'], '_'));
				$shipping_tax_rate = xtc_get_tax_rate($GLOBALS[$shipping_module]->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
				$od_amount = $od_amount * ($shipping_tax_rate / 100 +1);
			}
			// WENN STEUER NICHT INKLUSIVE UND KUNDEN MIT NETTO PREISEN, DANN STEUER ADDIEREN
			if ($this->calculate_tax == 'false'&& $_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
				$shipping_module = substr($_SESSION['shipping']['id'], 0, strpos($_SESSION['shipping']['id'], '_'));
				$shipping_tax_rate = xtc_get_tax_rate($GLOBALS[$shipping_module]->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
				$od_amount = $od_amount * ($shipping_tax_rate / 100 +1);
			}
			
		}

		// RABATT ÜBERSTEIGT DEN BESTELLWERT, DANN RABATT GLEICH BESTELLWERT
		if ($od_amount > $amount) {
			$od_amount = $amount;
		}
	
		return $od_amount;
	}

// STEUER NEU BERECHNEN
	function calculate_tax_deduction($od_amount, $order_total) {
		global $order;
		$tax_deduction = 0.00;
		
		// BEI VERSANDKOSTEN-RABATT DIE STEUERKLASSE DER VERSANDART ERMITTELN
		if ($this->coupon_type == 'S') {
		    $shipping_module = substr($_SESSION['shipping']['id'], 0, strpos($_SESSION['shipping']['id'], '_'));
			$shipping_tax_rate = xtc_get_tax_rate($GLOBALS[$shipping_module]->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
			$shipping_tax_desc = xtc_get_tax_description($GLOBALS[$shipping_module]->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
			if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
				$tax_deduction = ($od_amount * ($shipping_tax_rate / 100 + 1)) - $od_amount;
				$shipping_tax_desc = TAX_NO_TAX . $shipping_tax_desc;
			} else {
				$tax_deduction = $od_amount - ($od_amount / (100 + $shipping_tax_rate) * 100);
				$shipping_tax_desc = TAX_ADD_TAX . $shipping_tax_desc;
			}
			$order->info['tax_groups']["$shipping_tax_desc"] = $order->info['tax_groups']["$shipping_tax_desc"] - $tax_deduction;
			$order->info['tax'] = $order->info['tax'] - $tax_deduction;
			
		// BEI FESTBETRAG- UND PROZENT-KUPONS, ALLE STEUERKLASSEN BEACHTEN
		} else {
			reset($order->info['tax_groups']);
			while (list ($key, $value) = each($order->info['tax_groups'])) {

				// WENN ENDSUMME FAST NULL, DANN STEUER GLEICH NULL SETZEN
				if ($order->info['total'] - $od_amount <= 0.0049) {
					$order->info['tax_groups'][$key] = 0.00;
	
				// ANSONSTEN STEUER AUS RABATT BERECHNEN
				} else {
					$key_no_pre = str_replace(TAX_NO_TAX, "", $key);
					$key_no_pre = str_replace(TAX_ADD_TAX, "", $key_no_pre);
					// PROZENTUALER ANTEIL DIESER STEUERKLASSE VON DER RABATT-SUMME BERECHNEN
					$tax_group_order_total = $this->sum_tax["$key_no_pre"] / $order_total;
					$group_od_amount = $od_amount * $tax_group_order_total;
					$tax_rate = xtc_get_tax_rate_from_desc($key_no_pre);
					if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
						$group_tax_deduction = ($group_od_amount * ($tax_rate / 100 + 1)) - $group_od_amount;
					} else {
						$group_tax_deduction = $group_od_amount - ($group_od_amount / (100 + $tax_rate) * 100);
					}

					$order->info['tax_groups'][$key] = $order->info['tax_groups'][$key] - $group_tax_deduction;
					$order->info['tax'] = $order->info['tax'] - $group_tax_deduction;
					$tax_deduction += $group_tax_deduction;
				}
			}
		}
		return $tax_deduction;
	}

// ARTIKELPREIS-BERECHNUNG
	function get_products_price($t_prid, $products_id) {
		global $xtPrice, $order;
		$products_price = array();
		
		// STEUERKLASSE DES ARTIKELS ERMITTELN
		$product_query = xtc_db_query("select products_tax_class_id from " . TABLE_PRODUCTS . " where products_id='" . $t_prid . "' limit 1");
		$product = xtc_db_fetch_array($product_query);
		
		// FALLS VORHANDEN, ATTRIBUT-PREIS ERMITTELN
		if (isset ($_SESSION['cart']->contents[$products_id]['attributes'])) {
			while (list ($option, $value) = each($_SESSION['cart']->contents[$products_id]['attributes'])) {
				$values = $xtPrice->xtcGetOptionPrice($products_id, $option, $value);
				$attributes_price = $values['price'];
			}
		}

		// 0 = ARTIKELPREIS INKLUSIVE STEUER, 1 = BESCHREIBUNG DER STEUERKLASSE DES ARTIKELS
		$products_price[0] = $xtPrice->xtcGetPrice($products_id, $format = false, 1, $product['products_tax_class_id'], '', 1) + $attributes_price;
		if ($this->calculate_tax == 'false' && $_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
			$products_tax_rate = xtc_get_tax_rate($product['products_tax_class_id'], $order->delivery['country']['id'], $order->delivery['zone_id']);
			$products_price[0] = $products_price[0] * ($products_tax_rate / 100 +1);
		}
		$products_price[1] = xtc_get_tax_description($product['products_tax_class_id'], $order->delivery['country']['id'], $order->delivery['zone_id']);

		return $products_price;
	}

// PRE_CONFIRMATION_CHECK FÜR CHECKOUT_CONFIRMATION
	function pre_confirmation_check($order_total) {
		
		if (isset($_SESSION['cc_id']) && $this->enabled == 'true') {
			$od_amount = $this->calculate_credit($order_total);
			return $od_amount;
		}
			
	}

// BEREICH FÜR "GUTHABEN VERWENDEN" ERWEITERN (WIRD VOR DER CHECKBOX EINGEFÜGT)
	function use_credit_amount() {

		$use_credit_string = '';
		return $use_credit_string;

	}

// BEREICH FÜR "GUTHABEN VERWENDEN" ERWEITERN (WIRD NACH DER CHECKBOX EINGEFÜGT)
	function credit_selection() {

		$selection_string = '';
		$selection_string .= '<tr>' . "\n";
		$selection_string .= ' <td  width="10">' . xtc_draw_separator('pixel_trans.gif', '10', '1') .'</td>';
		$selection_string .= ' <td  nowrap class="main">' . "\n";
		$selection_string .=  TEXT_ENTER_COUPON_CODE . '</td>';
		$selection_string .= ' <td  align="right">'. xtc_draw_input_field('gv_redeem_code').'</td>';
		$selection_string .= ' <td  width="10">' . xtc_draw_separator('pixel_trans.gif', '10', '1') . '</td>';
		$selection_string .= '</tr>' . "\n";

		$selection_string = '';
		return $selection_string;

	}

// KUPON IN PROTOKOLL EINTRAGEN (AM ENDE EINER BESTELLUNG)
	function apply_credit() {
		global $insert_id, $REMOTE_ADDR;

		if (!$REMOTE_ADDR) { 
			$REMOTE_ADDR = $_SERVER['REMOTE_ADDR'];
		}

		if ($this->deduction != 0) {
			xtc_db_query("insert into " . TABLE_COUPON_REDEEM_TRACK . " (coupon_id, redeem_date, redeem_ip, customer_id, order_id) values ('" . (int) $_SESSION['cc_id'] . "', now(), '" . $REMOTE_ADDR . "', '" . (int) $_SESSION['customer_id'] . "', '" . $insert_id . "')");
		}

		unset ($_SESSION['cc_id']);
	}

// GUTHABEN AKTUALISIEREN NACH DEM EINKAUF EINES GUTSCHEINS (ALTES SYSTEM)
	function update_credit_account($i) {
		return false;
	}

// KUPON NOCHMALS AUF GÜLTIGKEIT PRÜFEN (CHECKOUT_CONFIRMATION)
	function collect_posts() {
		global $xtPrice;
		
		if ($_SESSION['cc_id'] != '') {

			// INFOS ÜBER KUPON AUSLESEN
			$coupon_query = xtc_db_query("select coupon_type, coupon_start_date, coupon_expire_date, coupon_minimum_order, coupon_id, uses_per_user, uses_per_coupon from " . TABLE_COUPONS . " where coupon_id = '" . (int) $_SESSION['cc_id'] . "' and coupon_active = 'Y' limit 1");
			$coupon_result = xtc_db_fetch_array($coupon_query);
			if (CHECKOUT_AJAX_STAT=='true') {
				$checkout_destination = FILENAME_CHECKOUT;
			} else {
				$checkout_destination = FILENAME_CHECKOUT_PAYMENT;
			}
			if ($coupon_result['coupon_type'] != 'G') {
	
				// ERROR : LAUFZEIT HAT NOCH NICHT BEGONNEN
				if ($coupon_result['coupon_start_date'] > date('Y-m-d H:i:s')) {
					unset($_SESSION['cc_id']);
					xtc_redirect(xtc_href_link($checkout_destination, 'error_message=' . urlencode(ERROR_INVALID_STARTDATE_COUPON), 'SSL'));
				}

				// ERROR : LAUFZEIT BEENDET
				if ($coupon_result['coupon_expire_date'] < date('Y-m-d H:i:s')) {
					unset($_SESSION['cc_id']);
					xtc_redirect(xtc_href_link($checkout_destination, 'error_message=' . urlencode(ERROR_INVALID_FINISDATE_COUPON), 'SSL'));
				}

				// ERROR : MINDESTBESTELLWERT NICHT ERREICHT
				if ($coupon_result['coupon_minimum_order'] > $_SESSION['cart']->show_total()) {
       		    	xtc_redirect(xtc_href_link($checkout_destination, 'info_message=' . urlencode(ERROR_MINIMUM_ORDER_COUPON_1 . ' ' . $xtPrice->xtcFormat($coupon_result['coupon_minimum_order'], true) . ' ' . ERROR_MINIMUM_ORDER_COUPON_2), 'SSL'));
				}	
				
				// ERROR : GESAMTES VERWENDUNGSLIMIT ÜBERSCHRITTEN				
				$coupon_count = xtc_db_query("select coupon_id from " . TABLE_COUPON_REDEEM_TRACK . " where coupon_id = '" . $coupon_result['coupon_id'] . "'");
				if (xtc_db_num_rows($coupon_count) >= $coupon_result['uses_per_coupon'] && $coupon_result['uses_per_coupon'] > 0) {
					unset($_SESSION['cc_id']);
					xtc_redirect(xtc_href_link($checkout_destination, 'error_message=' . urlencode(ERROR_INVALID_USES_COUPON . $coupon_result['uses_per_coupon'] . TIMES), 'SSL'));
				}
				
				// ERROR : VERWENDUNGSLIMIT FÜR EINZELNEN KUNDEN ÜBERSCHRITTEN
				$coupon_count_customer = xtc_db_query("select coupon_id from " . TABLE_COUPON_REDEEM_TRACK . " where coupon_id = '" . $coupon_result['coupon_id'] . "' and customer_id = '" . (int) $_SESSION['customer_id'] . "'");
				if (xtc_db_num_rows($coupon_count_customer) >= $coupon_result['uses_per_user'] && $coupon_result['uses_per_user'] > 0) {
					unset($_SESSION['cc_id']);
					xtc_redirect(xtc_href_link($checkout_destination, 'error_message=' . urlencode(ERROR_INVALID_USES_USER_COUPON . $coupon_result['uses_per_user'] . TIMES), 'SSL'));
				}
			}
		}
	}

	function check() {
		if (!isset ($this->check)) {
			$check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_COUPON_STATUS'");
			$this->check = xtc_db_num_rows($check_query);
		}

		return $this->check;
	}

	function keys() {
		return array ('MODULE_ORDER_TOTAL_COUPON_STATUS', 'MODULE_ORDER_TOTAL_COUPON_SORT_ORDER', 'MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING', 'MODULE_ORDER_TOTAL_COUPON_CALC_TAX');
	}

	function install() {
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('', 'MODULE_ORDER_TOTAL_COUPON_STATUS', 'true', '6', '1', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('', 'MODULE_ORDER_TOTAL_COUPON_SORT_ORDER', '38', '6', '2', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function ,date_added) values ('', 'MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING', 'true', '6', '3', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function ,date_added) values ('', 'MODULE_ORDER_TOTAL_COUPON_CALC_TAX', 'true', '6', '4', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
	}

	function remove() {
		$keys = '';
		$keys_array = $this->keys();
		for ($i = 0; $i < sizeof($keys_array); $i ++) {
			$keys .= "'" . $keys_array[$i] . "',";
		}
		$keys = substr($keys, 0, -1);

		xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in (" . $keys . ")");
	}
}
?>