<?php
/*-----------------------------------------------------------------
* 	ID:						xtc_db_perform.inc.php
* 	Letzter Stand:			v2.3
* 	zuletzt geaendert von:	cseoak
* 	Datum:					2012/11/19
*
* 	Copyright (c) since 2010 commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
* 	Released under the GNU General Public License
* ---------------------------------------------------------------*/
/**
* Bereitet Daten fuer die Datenbank auf.
* 
* @param $table string: Die Ziel-Tabelle.
* @param $data mixed: Die zu verarbeitende Daten.
* @param $action string: Die auszufuehrende Aktion.
* @param $parameters string: ...
* @param $link string: Der Datenbanklink
* @return xtc_db_query($query, $link)
*/

function xtc_db_perform($table, $data, $action = 'insert', $parameters = '', $link = 'db_link') {
	reset($data);
	$action = strtolower($action);
	if ($action == 'insert') {
		$query = 'insert into ' . $table . ' (';
		while (list($columns, ) = each($data)) {
			$query .= $columns . ', ';
		}
		$query = substr($query, 0, -2) . ') values (';
		reset($data);
		while (list(, $value) = each($data)) {
			$value = (is_Float($value) & PHP4_3_10) ? sprintf("%.F",$value) : (string)($value);
			switch ($value) {
				case 'now()':
					$query .= 'now(), ';
				break;
				case 'null':
					$query .= 'null, ';
				break;
				default:
					$query .= '\'' . xtc_db_input($value) . '\', ';
				break;
			}
		}
		$query = substr($query, 0, -2) . ')';
	} elseif ($action == 'update') {
		$query = 'update ' . $table . ' set ';
		while (list($columns, $value) = each($data)) {
			$value = (is_Float($value) & PHP4_3_10) ? sprintf("%.F",$value) : (string)($value);
			switch ($value) {
				case 'now()':
					$query .= $columns . ' = now(), ';
				break;
				case 'null':
					$query .= $columns .= ' = null, ';
				break;
				default:
					$query .= $columns . ' = \'' . xtc_db_input($value) . '\', ';
				break;
			}
		}
		$query = substr($query, 0, -2) . ' where ' . $parameters;
	}

	return xtc_db_query($query, $link);
}
?>