<?php
/* --------------------------------------------------------------
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2011 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */
require('includes/init.inc.php');
?>
<!DOCTYPE html>
<html lang="de" class="no-js" dir="ltr">
    <head>
        <title>commerce:seo Import-Assistent v3</title>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link type="text/css" rel="stylesheet" href="../templates/base/css/bootstrap4.css" />
        <link type="text/css" rel="stylesheet" href="stylesheet.css" />
        <script src="//ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
    </head>
    <body>
        <div class="container" id="main_content">
            <div id="header">
				<img src="images/cseo_logo.png" alt="commerce:seo v3" />
                <h1>Import Assistent v3</h1>
            </div>
            <?php
            if (isset($_POST['go_import']) || isset($_POST['go_import_x'])) {
				$_SESSION['source_db_host'] = $_POST['dbhost'];
				$_SESSION['source_db_user'] = $_POST['dbuser'];
				$_SESSION['source_db_password'] = $_POST['dbpass'];
				$_SESSION['source_db_database'] = $_POST['dbname'];
				$_SESSION['POST_ARRAY'] = $_POST;
				$_SESSION['RANDOM_HASH'] = md5(time() . rand());
				echo '<iframe src="run_prepare.php" width="100%" height="600" frameborder="0"></iframe>';
				echo '<form>';
				echo '<input class="btn btn-default btn-sm" type="button" name="back" value="zur&uuml;ck" onclick="location.href = \'index.php\'" />';
				echo '</form>';
            } else {
                $conf = get_source_shop_conf();
                if (isset($_POST['go_config']) || isset($_POST['go_config_x'])) {
                    $target_db_host = DB_SERVER;
                    $target_db_user = DB_SERVER_USERNAME;
                    $target_db_password = DB_SERVER_PASSWORD;
                    $target_db_database = DB_DATABASE;
					
                    $target_db = new DatabaseConnection($target_db_host, $target_db_user, $target_db_password, $target_db_database);
                    
					if (valid_login_new($target_db, $_POST['email'], $_POST['password']) == false) {
                        die('<b>Fehler: Zugangsdaten ung&uuml;ltig.</b><br />');
                    }
					
                    set_target_shop_conf($conf);
                    $target_db->query('UPDATE configuration
										SET configuration_value = "' . $conf['shop_path'] . 'cache"
										WHERE configuration_key = "SESSION_WRITE_DIRECTORY"
									');

                    die();
                }
                ?>
				<div id="install_service">
                <p><br/>Der Update Import-Assistent von commerce:seo v3 ermöglicht es Ihnen, die wichtigsten Daten aus xt:Commerce, osCommerce, Gambio GX per Knopfdruck
                    in den neuen commerce:seo v3 zu übernehmen. Bitte gehen Sie exakt nach der Anleitung vor. Bei Fragen oder Problemen
                    ist unser Support gern behilflich.
                </p>

                <p><strong>commerce:seo v3 Update-Service</strong><br/>
                    Sie möchten das Update nicht selbst durchführen? Nutzen Sie unseren Update-Service!<br/>
                    <br/>
                    <a href="https://www.commerce-seo.de/shopinstallation.html" class="btn btn-danger btn-lg" target="_blank">Update Service</a>
                </p>
                </div>

                <form action="index.php" method="post" class="form-group">
                    <table class="block_head table table-striped table-bordered">
                        <tr>
                            <th colspan="2">Datenbankinformationen des Quellshops</th>
                        </tr>
                        <tr>
                            <td width="20%">Server:</td>
                            <td width="80%"><input type="text" class="form-control" name="dbhost" size="15" value="<?php echo $conf['dbhost'] ?>" /></td>
                        </tr>
                        <tr>
                            <td>User:</td>
                            <td><input type="text" class="form-control" name="dbuser" size="15" value="<?php echo $conf['dbuser'] ?>" /></td>
                        </tr>
                        <tr>
                            <td>Passwort:</td>
                            <td><input type="text" class="form-control" name="dbpass" size="15" value="<?php echo $conf['dbpass'] ?>" /></td>
                        </tr>
                        <tr>
                            <td>Datenbank:</td>
                            <td><input type="text" class="form-control" name="dbname" size="15" value="<?php echo $conf['dbname'] ?>" /></td>
                        </tr>
                    </table>
                    <br/><br/>
                    <table class="block_head table table-striped table-bordered">
                        <tr>
                            <td>Import</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" onclick="toggle(this);" /> Check all?<br /></td>
                        </tr>
                    </table>
                    <table class="block_head table table-striped table-bordered">
                        <tr>
                            <td width="5%"><input type="checkbox" name="import_customers_status" value="on" /></td>
                            <td width="95%">Kundengruppen</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_categories" value="on" /></td>
                            <td><b>Kategorien</b></td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="reset_categories_template" value="on" /></td>
                            <td><em>Kategorielisting auf Standard</em></td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="reset_listing_template" value="on" /></td>
                            <td><em>Artikellisting auf Standard</em></td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_products" value="on" /></td>
                            <td><b>Artikel</b></td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="reset_product_template" value="on" /></td>
                            <td><em>Artikelvorlage auf Standard</em></td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="reset_options_template" value="on" /></td>
                            <td><em>Optionenvorlage auf Standard</em></td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_products_options" value="on" /></td>
                            <td>Artikel-Optionen</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_specials" value="on" /></td>
                            <td>Sonderangebote</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_manufacturers" value="on" /></td>
                            <td>Hersteller</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_xsell" value="on" /></td>
                            <td>Cross-Selling</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_customers" value="on" /></td>
                            <td>Kunden</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_personal_offers" value="on" /></td>
                            <td>Kundengruppen- und Staffelpreise</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="newsletter_recipients" value="on" /></td>
                            <td>Newsletter Abos</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_orders" value="on" /></td>
                            <td>Bestellungen</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_orders_status" value="on" /></td>
                            <td>Bestellstati</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_shipping_status" value="on" /></td>
                            <td>Lieferstati</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_vpe_status" value="on" /></td>
                            <td>Grundpreis Einstellungen</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_basket" value="on" /></td>
                            <td>Warenkörbe</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_gv" value="on" /></td>
                            <td>Kupons und Gutscheine</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_content_manager" value="on" /></td>
                            <td>Content-Seiten</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_blog_content" value="on" /></td>
                            <td>Blog-Seiten</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_tagcloud" value="on" /></td>
                            <td>Tag-Cloud</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_slider" value="on" /></td>
                            <td>Slider</td>
                        </tr>
                        <tr>
                            <td><input type="checkbox" name="import_redirects" value="on" /></td>
                            <td>Umleitungen</td>
                        </tr>
                    </table>
					
                    <table class="block_head table table-striped table-bordered">
                        <tr>
                            <th colspan="2">Geben Sie Zugangsdaten für den Adminbereich des Zielshops ein.</th>
                        </tr>
                        <tr>
                            <td width="20%">E-Mail:</td>
                            <td width="80%"><input class="form-control" type="text" name="email" value="" size="25" /></td>
                        </tr>
                        <tr>
                            <td>Passwort:</td>
                            <td><input class="form-control" type="password" name="password" value="" size="25" /></td>
                        </tr>
                    </table>
                    <input class="btn btn-success btn-sm" type="submit" name="go_import" value="&Uuml;bertragung starten" />
                    <br/>
                </form>
                <br/>
                <br/>
                <br/>
<?php
}
?>
        </div>
<script>
function toggle(source) {
    var checkboxes = document.querySelectorAll('input[type="checkbox"]');
    for (var i = 0; i < checkboxes.length; i++) {
        if (checkboxes[i] != source)
            checkboxes[i].checked = source.checked;
    }
}
</script>

	</body>
</html>
