<?php
/**
 * @version rechnung by sofort 1.0.0 - $Date: 2012-04-16 09:27:13 +0200 (Mon, 16 Apr 2012) $
 * @author Payment Network AG (integration@payment-network.com)
 * @link http://www.payment-network.com/
 *
 * Copyright (c) 2011 Payment Network AG
 * $Id: confirmInvoice.php 3798 2012-04-16 07:27:13Z rotsch $
 *
 */

if (basename($_SERVER['SCRIPT_FILENAME']) == 'confirmInvoice.php') {
	exit;
}

$language = $_SESSION['language'];

if ($language != 'german') {
	$language = 'english';
}

require_once(dirname(__FILE__).'/../../lang/'.$language.'/modules/payment/sofort_sofortrechnung.php');
require_once(DIR_WS_CLASSES.'order.php');
require_once(dirname(__FILE__).'/library/sofortLib.php');
require_once(DIR_FS_CATALOG.'callback/sofort/helperFunctions.php');

$orderId = (int)$_REQUEST['oID'];
$Order = new order($orderId);	// XTCommerce Order Object

function maskSpecialChars(&$item){
	helperFunctions::htmlMaskArray($item);
}

class ConfirmInvoice {
	
	var $debug = false;
	
	var $phpVersion = 0;
	
	var $transactionId = '';
	
	var $orderId = 0;
	
	var $orderStatus = 0;
	
	var $currency = '';
	
	var $time = '';
	
	var $request = '';
	
	var $moduleConfiguration = array();
	
	var $Order = null;
	
	var $Invoice = null;
	
	var $htmlHeader = '';
	
	var $htmlBody = '';
	
	var $htmlFooter = '';
	
	
	function ConfirmInvoice($Order, $orderId) {
		//check, if payment method is SR
		$this->phpVersion = substr(phpversion(), 0, 1);
		
		if ($this->phpVersion == 4) {
			if(!strpos(strtolower($Order->info['payment_method']), 'sofortrechnung')) {
				return;
			}
		} elseif ($this->phpVersion >= 5) {
			if (!stripos(strtolower($Order->info['payment_method']), 'sofortrechnung')) {
				return;
			}
		}
		
		$this->htmlHeader = $this->__htmlHeader();
		$this->htmlFooter = $this->__htmlFooter();
		array_walk($_REQUEST, 'maskSpecialChars');
		$this->request = $_REQUEST;
		$this->Order = $Order;
		$this->orderId = $orderId;
		
		// if there's no transactionId
		$success = $this->__setOrderDetails();
		
		if (!$success) {
			return;
		}
		
		$this->Invoice = new PnagInvoice(MODULE_PAYMENT_SOFORT_MULTIPAY_APIKEY, $this->transactionId);
		
		if (!is_object($this->Invoice->transactionData) || $this->Invoice->transactionData->getPaymentMethod() != 'sr') {
			return;
		}
		
		$this->time = $this->Invoice->transactionData->getTime();
		$this->__handleHTTPRequest();
		$this->__handleInvoiceStatus();
		$this->moduleConfiguration = $this->getPaymentModuleConfiguration();
		echo $this->htmlHeader.$this->htmlBody.$this->htmlFooter;
		exit();
	}
	
	
	function __handleHTTPRequest() {
		if(isset($this->request['action'])){
			switch($this->request['action']) {
				case 'confirmInvoice':
					$this->Invoice->confirmInvoice();
					$this->Invoice->refreshTransactionData();
					$this->__printContentBox(htmlentities(MODULE_PAYMENT_SOFORT_SR_INVOICE_CONFIRMED,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')));
					break;
				case 'cancelInvoice':
					$this->Invoice->cancelInvoice();
					$this->Invoice->refreshTransactionData();
					$this->__printContentBox(htmlentities(MODULE_PAYMENT_SOFORT_SR_INVOICE_CANCELED,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')));
					break;
				case 'downloadInvoice':
					$this->Invoice->getInvoice();
					break;
				default:
					$this->__printInformationBox();
					break;
			}
		}
	}
	
	
	function __handleInvoiceStatus() {
		//$oldStatus = $this->getLocalStatusOfInvoice();
		$newStatus = $this->Invoice->getState();
		//$oldAmount = $this->getLocalAmountOfInvoice();
		$newAmount = $this->Invoice->getAmount();
		$objection = $this->Invoice->getInvoiceObjection();
		//$amountChanged = ($oldAmount != $newAmount) ? true : false;
		
		switch($newStatus) {
			case PnagInvoice::PENDING_CONFIRM_INVOICE:	// Offene Rechnung, noch nicht bestätigt
				/*
				if($amountChanged) {
					// edit_invoice.CartItemsEdited
					$cartItemsEdited = 'Der Warenkorb wurde angepasst';
					$this->setInternalComment($cartItemsEdited.' - '.$newAmount);
					return true;
				}
				*/
				$this->setPaymentStatus($this->Invoice->getStatusReason());
				$this->setStatusOfInvoice($newStatus);
				$srConfirmInvoiceString = MODULE_PAYMENT_SOFORT_SR_PENDINIG_NOT_CONFIRMED_COMMENT_ADMIN;
				$this->setExternalComment($this->Invoice->transactionId, $srConfirmInvoiceString.' '.$this->Invoice->transactionId);
				$this->setInternalComment($srConfirmInvoiceString.' '.$this->Invoice->transactionId);
				
				$this->__printConfirmAndCancelForm();
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::LOSS_CANCELED:	// Vollstorno
				$this->setPaymentStatus($this->Invoice->getStatusReason());
				$this->setStatusOfInvoice($newStatus);
				$srCanceledString = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_INVOICE_CANCELED;
				$this->setExternalComment($this->Invoice->transactionId, $srCanceledString);
				$this->setInternalComment($srCanceledString);
				
				$this->__printInformationBox();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::LOSS_CONFIRMATION_PERIOD_EXPIRED:
				$srPeriodExpiredString = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_INVOICE_CANCEL_30_DAYS;
				$this->setInternalComment($srPeriodExpiredString);
				$this->setPaymentStatus($this->paymentStatus['canceled']);
				
				$this->__printInformationBox();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::PENDING_NOT_CREDITED_YET_PENDING:	// Rechnung bestätigt, noch keine Zahlung eingegangen
				/*
				if($amountChanged) {
					$cartItemsEdited = 'Der Warenkorb wurde angepasst';
					$this->setInternalComment($cartItemsEdited.' - '.$newAmount);
					return true;
				}
				*/
				$this->setPaymentStatus($this->Invoice->getStatusReason());
				$this->setStatusOfInvoice($newStatus);
				$srNotCreditedYetString = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_INVOICE_CONFIRMED;
				$this->setExternalComment($this->Invoice->transactionId, $srNotCreditedYetString);
				$this->setInternalComment($srNotCreditedYetString);
				
				$this->__printCancelAndDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::PENDING_NOT_CREDITED_YET_REMINDER_1:
				$reminderState = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_INVOICE_REMINDER;
				$reminderState = str_replace('{{d}}', '1', $reminderState);
				$this->setExternalComment($this->Invoice->transactionId, $reminderState);
				$this->setInternalComment($reminderState);
				
				$this->__printCancelAndDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::PENDING_NOT_CREDITED_YET_REMINDER_2:
				$reminderState = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_INVOICE_REMINDER;
				$reminderState = str_replace('{{d}}', '2', $reminderState);
				$this->setExternalComment($this->Invoice->transactionId, $reminderState);
				$this->setInternalComment($reminderState);
				
				$this->__printCancelAndDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::PENDING_NOT_CREDITED_YET_REMINDER_3:
				$reminderState = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_INVOICE_REMINDER;
				$reminderState = str_replace('{{d}}', '3', $reminderState);
				$this->setExternalComment($this->Invoice->transactionId, $reminderState);
				$this->setInternalComment($reminderState);
				
				$this->__printCancelAndDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::PENDING_NOT_CREDITED_YET_DELCREDERE:
				$delcredereState = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_INVOICE_DELCREDERE;
				$this->setExternalComment($this->Invoice->transactionId, $delcredereState);
				$this->setInternalComment($delcredereState);
				
				$this->__printCancelAndDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::RECEIVED_CREDITED_PENDING:
				$srCredited = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_CREDITED_TO_SELLER_CUSTOMER_PENDING;
				$this->setInternalComment($srCredited);
				
				$this->__printCancelAndDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::RECEIVED_CREDITED_REMINDER_1:
				$reminderState = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_INVOICE_REMINDER;
				$reminderState = str_replace('{{d}}', '1', $reminderState);
				$this->setExternalComment($this->Invoice->transactionId, $reminderState);
				$this->setInternalComment($reminderState);
				
				$this->__printCancelAndDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::RECEIVED_CREDITED_REMINDER_2:
				$reminderState = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_INVOICE_REMINDER;
				$reminderState = str_replace('{{d}}', '2', $reminderState);
				$this->setExternalComment($this->Invoice->transactionId, $reminderState);
				$this->setInternalComment($reminderState);
				
				$this->__printCancelAndDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::RECEIVED_CREDITED_REMINDER_3:
				$reminderState = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_INVOICE_REMINDER;
				$reminderState = str_replace('{{d}}', '3', $reminderState);
				$this->setExternalComment($this->Invoice->transactionId, $reminderState);
				$this->setInternalComment($reminderState);
				
				$this->__printCancelAndDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::RECEIVED_CREDITED_DELCREDERE:
				$delcredereState = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_INVOICE_DELCREDERE;
				$this->setExternalComment($this->Invoice->transactionId, $delcredereState);
				$this->setInternalComment($delcredereState);
				
				$this->__printCancelAndDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::REFUNDED_REFUNDED_REFUNDED:	// gutgeschrieben
				$this->setPaymentStatus($this->Invoice->getStatusReason());
				$this->setStatusOfInvoice($newStatus);
				$srRefundedString = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_CANCELED_REFUNDED;
				$srRefundedString = str_replace('{{time}}', $this->time, $srRefundedString);
				$this->setExternalComment($this->Invoice->transactionId, $srRefundedString);
				$this->setInternalComment($srRefundedString);
				
				$this->__printDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::PENDING_NOT_CREDITED_YET_RECEIVED:	// Kunde hat gezahlt, Zahlung noch nicht ausgeschüttet
				$this->setPaymentStatus($this->Invoice->getStatusReason());
				$this->setStatusOfInvoice($newStatus);
				$srCredited = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_RECEIVED;	// Zahlungseingang
				$this->setExternalComment($this->Invoice->transactionId, $srCredited);
				$this->setInternalComment($srCredited);
				
				$this->__printCancelAndDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			case PnagInvoice::RECEIVED_CREDITED_RECEIVED:
				$srCredited = MODULE_PAYMENT_SOFORT_SR_TRANSLATE_CREDITED_TO_SELLER;
				$this->setInternalComment($srCredited);
				
				$this->__printCancelAndDownloadForm();
				
				$this->__printOrderHistory();
				
				break;
			default:
				$this->setInternalComment(htmlentities(MODULE_PAYMENT_SOFORT_SR_UNKNOWN_STATUS,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')).' ('.$newStatus.')');
				
				$this->__printInformationBox();
				
				$this->__printOrderHistory();
				
				break;
		}
	}
	
	
	function __printConfirmAndCancelForm() {
		$this->htmlBody .= $this->__printInvoiceStatus();
		$this->htmlBody .= $this->__printPnagButton(htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_CONFIRM_INVOICE,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')), 'form1', 'confirmInvoice', htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_CONFIRM_INVOICE,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')));
		$this->htmlBody .= $this->__printPnagButton(htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_CANCEL_INVOICE,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')), 'form2', 'cancelInvoice', htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_CANCEL_INVOICE,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')));
		$this->htmlBody .= $this->__printClearString();
	}
	
	
	function __printCancelAndDownloadForm() {
		$this->htmlBody .= $this->__printInvoiceStatus();
		$this->htmlBody .= $this->__printPnagButton(htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_CANCEL_INVOICE,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')), 'form2', 'cancelInvoice', htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_CANCEL_INVOICE,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')));
		$this->htmlBody .= $this->__printPnagButton(htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_DOWNLOAD_INVOICE,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')), 'form3', 'downloadInvoice', htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_DOWNLOAD_INVOICE,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')));
		$this->htmlBody .= $this->__printClearString();
	}
	
	
	function __printDownloadForm() {
		$this->htmlBody .= $this->__printInvoiceStatus();
		$this->htmlBody .= $this->__printPnagButton(htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_DOWNLOAD_INVOICE_CREDITMEMO,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')), 'form3', 'downloadInvoice', htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_DOWNLOAD_INVOICE,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')), 2);
		$this->htmlBody .= $this->__printClearString();
	}
	
	
	function __printClearString() {
		return "<span class='clear'>&nbsp;</span>\n";
	}
	
	
	function __printInvoiceStatus() {
		if ($this->debug) {
			$s  = '<p>status: '.$this->Invoice->getStatus().'</p>';
			$s .= '<p>status_reason: '.$this->Invoice->getStatusReason().'</p>';
			$s .= '<p>invoice_status: '.$this->Invoice->getStatusOfInvoice().'</p>';
			return $s;
		}
		
		return false;
	}
	
	
	function __printContentBox($content) {
		$s  = "<div class='element pnag_button wide-box'>\n";
		$s .= $content."\n";
		$s .= "</div>\n";
		$this->htmlBody .= $s;
	}
	
	
	function __printInformationBox() {
		$content  = '<h2><a href="javascript:void()" onclick="toggleElement(\'invoiceDetails\')">'.htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_INVOICE_DETAILS,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')).'</a></h2>';
		$content .= '<div id="invoiceDetails">';
		$content .= '<table class="small">';
		$content .= '<tr><td align="left">'.htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_TRANSACTION_ID,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')).': </td><td align="right">'.$this->getTransactionId().'</td></tr>';
		$content .= '<tr><td align="left">'.htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_ORDER_NUMBER,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')).': </td><td align="right">'.$this->getOrderId().'</td></tr>';
		$content .= '<tr><td align="left">'.htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_CURRENT_TOTAL,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')).': </td><td align="right">'.$this->Invoice->getAmount().' '.$this->getCurrency().'</td></tr>';
		$content .= '</table>';
		$content .= '</div>';
		$this->htmlBody .= $this->__printContentBox($content);
	}
	
	
	function __printOrderHistory() {
		
		$orderHistory = $this->getOrderHistory();
		
		$content  = '<h2><a href="javascript:void()" onclick="toggleElement(\'orderHistory\')">'.htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_ORDER_HISTORY,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')).'</a></h2>';
		$content .= '<div id="orderHistory" style="display:none;">';
		$content .= '<table style="text-align:left;" class="small">';
		foreach ($orderHistory as $oneEntry) {
			$amount = number_format($oneEntry['amount'], 2, '.','');
			$content .= '<tr><td>'.htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_DATE,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')).'</td><td style="padding-left:5px;">'.htmlentities($oneEntry['date_time'],ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')).'</td></tr>';
			$content .= '<tr><td>'.htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_COMMENT,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')).'</td><td style="padding-left:5px;">'.htmlentities($oneEntry['seller_comment'],ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')).'</td></tr>';
			$content .= '<tr><td>'.htmlentities(MODULE_PAYMENT_SOFORT_SR_TRANSLATE_AMOUNT,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')).'</td><td style="padding-left:5px;">'.htmlentities($amount.' '.$this->currency,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding')).'</td></tr>';
			$content .= '<tr><td colspan="2"><hr class="line" /></td></tr>';
		}
		$content .= '</table>';
		$content .= '</div>';
		$this->htmlBody .= $this->__printContentBox($content);
	}
	
	
	/**
	 * get the pnag-history for this order from table sofort_orders_notification
	 */
	function getOrderHistory() {
		$sql = 'SELECT sofort_orders_notification.* 
				FROM `sofort_orders_notification` 
				LEFT JOIN sofort_orders 
					ON sofort_orders_notification.sofort_orders_id = sofort_orders.id
				WHERE sofort_orders.orders_id = '.(int)$this->orderId.'
				ORDER BY sofort_orders_notification.date_time DESC';
		
		$sqlResult = xtc_db_query($sql);
		$historyDatas = array();
		while ($historyData = xtc_db_fetch_array($sqlResult)) {
			$historyDatas[] = $historyData;
		}
		
		return $historyDatas;
	}
	
	
	function getLocalAmountOfInvoice() {
		// implement if needed
		return 0.0;
	}
	
	
	function getLocalStatusOfInvoice() {
		// implement if needed
		return 0;
	}
	
	
	function setStatusOfInvoice($arg) {
		// implement if needed
		// echo 'set status to: '.$arg;
	}
	
	
	function setPaymentStatus($arg) {
		// implement if needed
		// echo 'set payment status to: '.$arg;
	}
	
	
	function setInternalComment($arg) {
		// implement if needed
		// echo 'set internal comment to: '.$arg;
	}
	
	
	function setExternalComment($arg) {
		// implement if needed
		// echo 'set external comment to: '.$arg;
	}
	
	
	/**
	 *
	 * Fetch the module's configuration
	 * @return Array $configurationArray
	 */
	function getPaymentModuleConfiguration() {
		$sql = 'SELECT configuration_key, configuration_value FROM configuration WHERE configuration_key like "%MODULE_PAYMENT_SOFORT_SR%"';
		$configurationQuery = xtc_db_query($sql);
		$configurationArray = array();
		
		while ($configurationData = xtc_db_fetch_array($configurationQuery)) {
			$configurationArray[$configurationData['configuration_key']] = $configurationData['configuration_value'];
		}
		
		return $configurationArray;
	}
	
	
	function __setOrderDetails() {
		$sql = "SELECT orders_status, currency, currency_value, orders_ident_key FROM ".TABLE_ORDERS." WHERE orders_id = '".$this->orderId."'";
		$orderQuery = xtc_db_query($sql);
		$orderDetails = xtc_db_fetch_array($orderQuery);
		
		if (empty($orderDetails['orders_ident_key'])) {
			return false;
		}
		
		$this->transactionId = $orderDetails['orders_ident_key'];
		$this->orderStatus = $orderDetails['orders_status'];
		$this->currency = $orderDetails['currency'];
		return true;
	}
	
	
	function __htmlHeader() {
		$s  = "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>\n	";
		$s .= "<html xmlns='http://www.w3.org/1999/xhtml'>\n";
		$s .= "<head>\n";
		$s .= "<meta http-equiv='Content-Type' content='text/html; charset=".HelperFunctions::getIniValue('shopEncoding')."' />\n";
		$s .= "<title>".htmlentities(MODULE_PAYMENT_SOFORT_SR_ADMIN_TITLE,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding'))."</title>\n";
		$s .= "<script type='text/javascript' src='http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js'></script>\n";
		$s .= "<style type='text/css'>\n";
		$s .= file_get_contents(dirname(__FILE__).'/ressources/style/style.css');
		$s .= "\n</style>\n";
		$s .= "<!--[if gte IE 6]>\n";
		$s .= "<style type='text/css'>\n";
		$s .= file_get_contents(dirname(__FILE__).'/ressources/style/ie6.css');
		$s .= "\n</style>\n";
		$s .= "\n<![endif]-->\n";
		// add conditionals for ie7,9,9,x
		$s .= "<script type='text/javascript'>\n";
		$script = file_get_contents(dirname(__FILE__).'/ressources/javascript/scripts.js');
		$s .= $script;
		$s .= "\n</script>\n";
		$s .= "</head>\n";
		$s .= "<body>\n";
		$s .= "<div id='page'>\n";
		$s .= "<h1>".htmlentities(MODULE_PAYMENT_SOFORT_SR_ADMIN_TITLE,ENT_QUOTES,HelperFunctions::getIniValue('shopEncoding'))."</h1>\n";
		return $s;
	}
	
	
	function __printPnagButton($title, $formName, $action, $content, $predefinedWidth = 1) {
		// halbe(174px) oder volle(384px) Breite
		$elementWidth = '';
		
		if ($predefinedWidth == 1) {
			$elementWidth = 'narrow-box';
		} elseif ($predefinedWidth == 2) {
			$elementWidth = 'wide-box';
		}
		
		$s  = "<div class='element pnag_button ".$elementWidth."'>\n";
		$s .= "<form method='post' name='".$formName."' action='".$_SERVER['PHP_SELF']."?oID=".$this->orderId."'>\n";
		$s .= "<input type='button' value='".$title."' onclick='javascript:document.".$formName.".submit()' />\n";
		$s .= "<input type='hidden' name='action' value='".$action."' />";
		$s .= "<input type='hidden' name='oID' value='".$this->orderId."' />";
		$s .= "<span class='clear'>&nbsp;</span>\n";
		$s .= "</form>\n";
		$s .= "<p class='small'>".$content."</p>\n";
		$s .= "</div>\n";
		return $s;
	}
	
	
	function __htmlFooter() {
		//$s  = "<div class='logo'>&nbsp;</div>\n";
		$s .= "</div>\n";
		$s .= "</body>\n";
		$s .= "</html>\n";
		return $s;
	}
	
	
	function getOrderId() {
		return $this->orderId;
	}
	
	
	function getTransactionId() {
		return $this->transactionId;
	}
	
	
	function getCurrency() {
		return $this->currency;
	}
	
	
	function __debug($var) {
		if(empty($var)) {
			return false;
		}
		
		$s  = '<pre>';
		$s .= print_r($var);
		$s .= '</pre>';
		return $s;
	}
	
	
	function __toString() {
		$s  = '<pre>';
		$s .= print_r($this, 1);
		$s .= '</pre>';
		return $s;
	}
}

$ConfirmInvoice = new ConfirmInvoice($Order, $orderId);
?>