<?php
/**
 * @version sofortueberweisung.de 5 - $Date: 2012-04-04 13:04:50 +0200 (Wed, 04 Apr 2012) $
 * @author Payment Network AG (integration@payment-network.com)
 * @link http://www.payment-network.com/
 *
 * @link http://www.xt-commerce.com
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 ***********************************************************************************
 * this file contains code based on:
 * (c) 2000 - 2001 The Exchange Project
 * (c) 2001 - 2003 osCommerce, Open Source E-Commerce Solutions
 * (c) 2003	 nextcommerce (account_history_info.php,v 1.17 2003/08/17); www.nextcommerce.org
 * (c) 2003 - 2006 XT-Commerce
 * Released under the GNU General Public License
 ***********************************************************************************
 *
 * $Id: sofort_lastschrift.php 3708 2012-04-04 11:04:50Z rotsch $
 *
 */
define('API_LS_VERSION', 'pn_xtc_5.1.0');

require_once(DIR_FS_CATALOG.'callback/sofort/sofort.php');
require_once(DIR_FS_CATALOG.'callback/sofort/library/sofortLib.php');

class sofort_lastschrift extends sofort{

	var $code, $title, $description, $enabled, $sofort, $paymentMethod;

	function sofort_lastschrift() {
		global $order;

		$this->checkExistingSofortConstants('ls');

		$this->code = 'sofort_lastschrift';
		$this->title = MODULE_PAYMENT_SOFORT_LS_TEXT_TITLE;
		$this->title_extern = MODULE_PAYMENT_SOFORT_LASTSCHRIFT_TEXT_TITLE;
		$this->paymentMethod = 'LS';

		if (MODULE_PAYMENT_SOFORT_LS_RECOMMENDED_PAYMENT == 'True') {
			$this->title_extern .= ' ' . MODULE_PAYMENT_SOFORT_LS_RECOMMENDED_PAYMENT_TEXT ;
		}

		$this->description = MODULE_PAYMENT_SOFORT_LS_TEXT_DESCRIPTION;
		$this->sort_order = MODULE_PAYMENT_SOFORT_LS_SORT_ORDER;
		$this->enabled = ((MODULE_PAYMENT_SOFORT_LS_STATUS == 'True') ? true : false);
		$this->tmpOrders = true;
		$this->tmpStatus = MODULE_PAYMENT_SOFORT_LS_TMP_STATUS_ID;
		if (is_object($order)) {
			$this->update_status();
		}
		$this->defaultCurrency = DEFAULT_CURRENCY;
		$this->sofort = new SofortLib_Multipay(MODULE_PAYMENT_SOFORT_MULTIPAY_APIKEY);

		$this->sofort->setVersion(API_LS_VERSION);

		$this->form_action_url = "";
	}


	function selection () {

		$title = '';

		switch (MODULE_PAYMENT_SOFORT_MULTIPAY_IMAGE) {
			case 'Logo & Text':
				$title = $this->setImageText(MODULE_PAYMENT_SOFORT_LS_LOGO, MODULE_PAYMENT_SOFORT_LS_CHECKOUT_TEXT);
				break;
			case 'Infographic':
				$title = $this->setImageText(MODULE_PAYMENT_SOFORT_LS_BANNER, '');
				break;
		}

		$cost = '';
		if(array_key_exists('ot_sofort',  $GLOBALS)) {
			$cost = $GLOBALS['ot_sofort']->get_percent($this->code, 'price');
		}

		$conditionsChecked = false;
		if($_SESSION['sofort_conditions_ls'] == 'sofort_conditions_ls') {
			$conditionsChecked = true;
		}

		$fields = array(
			array('title' => MODULE_PAYMENT_SOFORT_LS_TEXT_HOLDER,
					'field' => xtc_draw_input_field('ls_sender_holder', array_key_exists('ls_sender_holder', $_SESSION) ? $_SESSION['ls_sender_holder'] : $order->billing['firstname'] . ' ' . $order->billing['lastname'])),
			array('title' => MODULE_PAYMENT_SOFORT_LS_TEXT_ACCOUNT_NUMBER,
					'field' => xtc_draw_input_field('ls_account_number', array_key_exists('ls_account_number', $_SESSION) ? $_SESSION['ls_account_number'] : '')),
			array('title' => MODULE_PAYMENT_SOFORT_LS_TEXT_BANK_CODE,
					'field' => xtc_draw_input_field('ls_bank_code', array_key_exists('ls_bank_code', $_SESSION) ? $_SESSION['ls_bank_code'] : '')),
			array('title' => MODULE_PAYMENT_SOFORT_LS_CHECKOUT_CONDITIONS,
					'field' => xtc_draw_checkbox_field('sofort_conditions_ls', 'sofort_conditions_ls', $conditionsChecked))
			);

		return array('id' => $this->code , 'module' => $this->title_extern , 'fields' => $fields, 'description' => $title, 'module_cost' => $cost	);
	}


	function setImageText($image, $text) {
		switch ($_SESSION['language']){
			case 'german': $image = 'https://images.sofort.com/de/ls/'.$image; break;
			case 'dutch':  $image = 'https://images.sofort.com/nl/ls/'.$image; break;
			case 'polish': $image = 'https://images.sofort.com/pl/ls/'.$image; break;
			//english is fallback for unknown langs
			case 'english':
			default:	   $image = 'https://images.sofort.com/en/ls/'.$image; break;
		}

		$image = xtc_image($image, MODULE_PAYMENT_SOFORT_LS_TEXT_DESCRIPTION_CHECKOUT_PAYMENT_IMAGEALT);
		$title = MODULE_PAYMENT_SOFORT_LS_TEXT_DESCRIPTION_CHECKOUT_PAYMENT_IMAGE;
		return $title;
	}


	function pre_confirmation_check ($vars = '') {

		parent::pre_confirmation_check ($vars);

		//in CommerceSEO check is done with Ajax
		if (isset ($_POST['xajax']) && $_POST['xajax'] == 'updatePaymentModule' ) {
			$data_arr = $vars;
			if (!$data_arr['sofort_conditions_ls'] == 'sofort_conditions_ls') {
				unset($_SESSION['sofort_conditions_ls']);
			}
			$is_ajax = true;
		} else {
			array_walk($_POST, 'maskSpecialChars');
			$data_arr = $_POST;
		}

		$data_arr['ls_sender_holder'] 	= trim ($data_arr['ls_sender_holder']);
		$data_arr['ls_account_number']	= trim ($data_arr['ls_account_number']);
		$data_arr['ls_bank_code'] 		= trim ($data_arr['ls_bank_code']);

		if ($data_arr['ls_sender_holder']) {
			$_SESSION['ls_sender_holder'] = $data_arr['ls_sender_holder'];
		}
		if ($data_arr['ls_account_number']) {
			$_SESSION['ls_account_number'] = $data_arr['ls_account_number'];
		}
		if ($data_arr['ls_bank_code']) {
			$_SESSION['ls_bank_code'] = $data_arr['ls_bank_code'];
		}
		if ($data_arr['sofort_conditions_ls']) {
			$_SESSION['sofort_conditions_ls'] = $data_arr['sofort_conditions_ls'];
		}
		$errorCodes = array();
		$errorFound = false;
		$payment_ajax_error_return = '';
		if ($data_arr['sofort_conditions_ls'] != 'sofort_conditions_ls' && $_SESSION['sofort_conditions_ls'] != 'sofort_conditions_ls') {
			$payment_ajax_error_return = '&payment_error='.$this->code.'&error='.urlencode(MODULE_PAYMENT_SOFORT_MULTIPAY_XML_FAULT_10002);
			$errorCodes[] = '10002';
			$errorFound = true;
		}

		if ( (!$data_arr['ls_sender_holder'] && !$_SESSION['ls_sender_holder']) ||
			 (!$data_arr['ls_account_number'] && !$_SESSION['ls_account_number']) ||
			 (!$data_arr['ls_bank_code'] && !$_SESSION['ls_bank_code']) ) {
			$payment_ajax_error_return =
				'&payment_error='.$this->code.
				'&error='.urlencode(MODULE_PAYMENT_SOFORT_MULTIPAY_XML_FAULT_10001).
				'&ls_sender_holder='.urlencode($data_arr['ls_sender_holder']).
				'&ls_account_number='.urlencode($data_arr['ls_account_number']).
				'&ls_bank_code='.urlencode($data_arr['ls_bank_code']);
			$errorFound = true;
			$errorCodes[] = '10001';
		}

		if ($errorFound) {
			if ($is_ajax) {
				$_SESSION['checkout_payment_error'] = $payment_ajax_error_return;
			} else {
				$error_string = '&payment_error='.$this->code.'&error_codes='.implode(',', $errorCodes);
				if (CHECKOUT_AJAX_STAT=='true') {
					xtc_redirect(xtc_href_link(FILENAME_CHECKOUT, $error_string, 'SSL', true, false));
				} else {
					xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $error_string, 'SSL', true, false));
				}
			}
		}

		return false;
	}


	function install() {
		$sofortStatuses = $this->insertAndReturnSofortStatus();
		$tempStatus = 		(isset($sofortStatuses['temp']) 	&& !empty($sofortStatuses['temp']))		? $sofortStatuses['temp'] : '';
		$confirmedStatus = 	(isset($sofortStatuses['confirmed'])&& !empty($sofortStatuses['confirmed']))? $sofortStatuses['confirmed'] : '';

		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_SOFORT_LS_STATUS', 'True', '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORT_LS_SORT_ORDER', '0', '6', '20', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_SOFORT_LS_RECOMMENDED_PAYMENT', 'False', '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_SOFORT_LS_ORDER_STATUS_ID', '".helperFunctions::escapeSql($confirmedStatus)."',  '6', '10', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_SOFORT_LS_TMP_STATUS_ID', '".helperFunctions::escapeSql($tempStatus)."',  '6', '8', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORT_LASTSCHRIFT_ALLOWED', '', '6', '0', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_SOFORT_LS_ZONE', '0', '6', '2', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");

		//install shared keys, that are used by all/most multipay-modules
		parent::install();
	}


	function remove() {
		xtc_db_query("delete from " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " where configuration_key LIKE 'MODULE_PAYMENT_SOFORT_LS%'");
		xtc_db_query("delete from " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " where configuration_key LIKE 'MODULE_PAYMENT_SOFORT_LASTSCHRIFT%'");

		//if this is the last removing of a multipay-paymentmethod --> we also remove all shared keys, that are used by all/most multipay-modules
		parent::remove();
	}


	function keys() {
		return array('MODULE_PAYMENT_SOFORT_LS_STATUS',
		'MODULE_PAYMENT_SOFORT_MULTIPAY_APIKEY',
		'MODULE_PAYMENT_SOFORT_MULTIPAY_AUTH',
		'MODULE_PAYMENT_SOFORT_LS_RECOMMENDED_PAYMENT',
		'MODULE_PAYMENT_SOFORT_LASTSCHRIFT_ALLOWED' ,
		'MODULE_PAYMENT_SOFORT_LS_ZONE' ,
		'MODULE_PAYMENT_SOFORT_MULTIPAY_REASON_1',
		'MODULE_PAYMENT_SOFORT_MULTIPAY_TEXT_REASON_2',
		//'MODULE_PAYMENT_SOFORT_MULTIPAY_IMAGE',
		'MODULE_PAYMENT_SOFORT_LS_TMP_STATUS_ID',
		'MODULE_PAYMENT_SOFORT_LS_ORDER_STATUS_ID',
		'MODULE_PAYMENT_SOFORT_MULTIPAY_CANCELED_ORDER_STATUS_ID',
		'MODULE_PAYMENT_SOFORT_LS_SORT_ORDER');
	}
}
?>