<?php
/**
 * @version sofortueberweisung.de 5 - $Date: 2012-04-10 17:29:13 +0200 (Tue, 10 Apr 2012) $
 * @author Payment Network AG (integration@payment-network.com)
 * @link http://www.payment-network.com/
 *
 * @link http://www.xt-commerce.com
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 ***********************************************************************************
 * this file contains code based on:
 * (c) 2000 - 2001 The Exchange Project
 * (c) 2001 - 2003 osCommerce, Open Source E-Commerce Solutions
 * (c) 2003	 nextcommerce (account_history_info.php,v 1.17 2003/08/17); www.nextcommerce.org
 * (c) 2003 - 2006 XT-Commerce
 * Released under the GNU General Public License
 ***********************************************************************************
 *
 * $Id: sofort_ideal.php 3761 2012-04-10 15:29:13Z rotsch $
 *
 */

define('API_IDEAL_VERSION', 'pn_xtc_5.1.0');
require_once(DIR_FS_CATALOG.'callback/sofort/helperFunctions.php');
require_once(DIR_FS_CATALOG.'callback/sofort/library/sofortLib.php');
require_once(DIR_FS_CATALOG.'callback/sofort/library/sofortLib_ideal_classic.php');


class sofort_ideal {

	var $code, $title, $description, $enabled, $sofort;

	function sofort_ideal () {
		global $order;
		$this->code = 'sofort_ideal';
		$this->title = MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_TEXT_TITLE;
 		$this->title_extern = MODULE_PAYMENT_SOFORT_IDEAL_TEXT_TITLE;

		if(MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_RECOMMENDED_PAYMENT == 'True') {
			$this->title_extern .= ' ' . MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_RECOMMENDED_PAYMENT_TEXT;
		}

		$this->description = MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_TEXT_DESCRIPTION;
		$this->sort_order = MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_SORT_ORDER;
		$this->enabled = ((MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_STATUS == 'True') ? true : false);
		$this->tmpOrders = true;
		$this->tmpStatus = MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_TMP_STATUS_ID;

		if ((int) MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_ORDER_STATUS_ID > 0) {
			$this->order_status = MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_ORDER_STATUS_ID;
		}
		if (is_object($order)) {
			$this->update_status();
		}
		$this->defaultCurrency = DEFAULT_CURRENCY;
		$this->sofort = new SofortLib_iDealClassic (MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_CONFIGURATION_KEY, MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_PROJECT_PASSWORD, 'sha1');

		$this->sofort->setVersion(API_IDEAL_VERSION);

		$this->form_action_url = "";
	}


	function update_status ()
	{
		global $order;
		if (($this->enabled == true) && ((int) MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_ZONE > 0)) {
			$check_flag = false;
			$check_query = xtc_db_query("SELECT zone_id FROM " . helperFunctions::escapeSql(TABLE_ZONES_TO_GEO_ZONES) . " WHERE geo_zone_id = '" . helperFunctions::escapeSql(MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_ZONE) . "' and zone_country_id = '" . helperFunctions::escapeSql($order->billing['country']['id']) . "' ORDER BY zone_id");
			while ($check = xtc_db_fetch_array($check_query)) {
				if ($check['zone_id'] < 1) {
					$check_flag = true;
					break;
				} elseif ($check['zone_id'] == $order->billing['zone_id']) {
					$check_flag = true;
					break;
				}
			}
			if ($check_flag == false) {
				$this->enabled = false;
			}
		}
	}


	function javascript_validation () {
		return false;
	}


	/**
	 * This function outputs the payment method title/text and if required, the input fields when user has finished shopping
	 */
	function selection () {

		$title = '';

		switch (MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_IMAGE) {
			case 'Logo & Text':
				$title .= $this->setImageText('logo_155x50.png', MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_TEXT_DESCRIPTION_CHECKOUT_PAYMENT_TEXT);
				break;
			case 'Infographic':
			default:
				$title .= $this->setImageText('banner_300x100.png', '');
				break;
		}

		//get all available banks from pnag-server
		//and put them into a select-box
		$banks = $this->sofort->getRelatedBanks();
		$selectBox = '<br />
			<select name="ideal_bank_name" size="1">
				<option value="0">---</option>';
		if(!empty($banks) && is_array($banks)) {
			foreach ($banks as $value) {
				$selectBox .= '<option value="' . $value['code'] . '"';
				if( isset( $_SESSION[ 'ideal_bank_name' ] ) && $_SESSION['ideal_bank_name'] == $value['code'] )
					$selectBox .= ' selected="selected"';
				$selectBox .= '>' . $value['name'] . '</option>';
			}
		}
		$selectBox .= '</select>';

		$title = str_replace('{{selectbox}}', $selectBox, $title);

		return array('id' => $this->code , 'module' => $this->title_extern	 , 'description' => $title, 'module_cost' => $cost);
	}

	function setImageText($image, $text) {
		switch ($_SESSION['language']){
			case 'german': $image = 'https://images.sofort.com/de/ideal/'.$image; break;
			case 'dutch':  $image = 'https://images.sofort.com/nl/ideal/'.$image; break;
			case 'polish': $image = 'https://images.sofort.com/pl/ideal/'.$image; break;
			//english is fallback for unknown langs
			case 'english':
			default:	   $image = 'https://images.sofort.com/en/ideal/'.$image; break;
		}

		$image = xtc_image($image, MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_TEXT_DESCRIPTION_CHECKOUT_PAYMENT_IMAGEALT);
		$title = MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_TEXT_DESCRIPTION_CHECKOUT_PAYMENT_IMAGE;
		$title = str_replace('{{image}}', $image, $title);
		$title = str_replace('{{text}}', $text, $title);
		return $title;
	}

	function pre_confirmation_check () {
		// Fix for XTC Bug
		// We need a cartID
		if (empty($_SESSION['cart']->cartID)) {
			$_SESSION['cart']->cartID = $_SESSION['cart']->generate_cart_id();
		}

		if(isset($_REQUEST['ideal_bank_name'])){
        	$_SESSION['ideal_bank_name'] = helperFunctions::htmlMask($_REQUEST['ideal_bank_name']);
        }

	 	if (( !isset($_REQUEST['ideal_bank_name']) || !$_REQUEST['ideal_bank_name'] ) &&
	 	( !xtc_session_is_registered('ideal_bank_name') || !$_SESSION['ideal_bank_name'] )) {
	        $paymentError = 'payment_error='.$this->code.'&error_codes=10000';
			if (CHECKOUT_AJAX_STAT=='true') {
				xtc_redirect(xtc_href_link(FILENAME_CHECKOUT, $paymentError, 'SSL', true, false));
			} else {
				xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $paymentError, 'SSL', true, false));
			}
        }
		return false;
	}


	function confirmation () {
		global $order;

		/* If temporary order is still in session, check if order ID exists and delete order and all relating (session) data
		 * User might have returned to the shop for changing the order or payment method
		 */
		if (! empty($_SESSION['cart_pn_sofortueberweisung_ID'])) {
			$order_id = substr($_SESSION['cart_pn_sofortueberweisung_ID'], strpos($_SESSION['cart_pn_sofortueberweisung_ID'], '-') + 1);
			$cartID = substr($_SESSION['cart_pn_sofortueberweisung_ID'], 0, strlen($_SESSION['cart']->cartID));
			$check_query = xtc_db_query("SELECT currency, orders_status FROM " . helperFunctions::escapeSql(TABLE_ORDERS) . " WHERE orders_id = '" . (int) $order_id . "'");
			$result = xtc_db_fetch_array($check_query);
			if (($result['orders_status'] == MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_TMP_STATUS_ID) || ($result['currency'] != $order->info['currency']) || ($_SESSION['cart']->cartID != $cartID)) {
				$this->_cancel_order( (int) $order_id, 'on');
				unset($_SESSION['cart_pn_sofortueberweisung_ID']);
				unset($_SESSION['tmp_oID']);
			}
		}
		return false;
	}


	function process_button () {
		return false;
	}


	function before_process () {
		return false;
	}


	/**
	 * xtCommerce calls this function if this module was chosen for payment
	 * The corresponding order is being processed here, bought articles being credited
	 * SofortLib calls Payment Network API
	 */
	function payment_action () {
		global $order, $xtPrice, $insert_id, $shopEncoding;

		$customer_id = $_SESSION['customer_id'];
		$order_id = $insert_id;
		$_SESSION['cart_pn_sofortueberweisung_ID'] = $_SESSION['cart']->cartID . '-' . $insert_id;

		if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
			$total = $order->info['total'] + $order->info['tax'];
		} else {
			$total = $order->info['total'];
		}
		// Fix for XTC Bug
		// $order->info['total'] is in 'before_process' String without Tax, after email it is TEXT with currency
		// so it has to be set here

		$amount = round($total, $xtPrice->get_decimal_places($_SESSION['currency']));
		$amount = number_format($amount, 2, '.', '');

		$currency = $_SESSION['currency'];

		$reason_1 = str_replace('{{order_id}}', $order_id, MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_REASON_1);
		$reason_1 = str_replace('{{customer_id}}', $customer_id, $reason_1);
		$reason_1 = substr($reason_1, 0, 27);

		$reason_2 = str_replace('{{order_id}}', $order_id, MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_REASON_2);
		$reason_2 = str_replace('{{customer_id}}', $customer_id, $reason_2);
		$reason_2 = str_replace('{{order_date}}', strftime(DATE_FORMAT_SHORT), $reason_2);
		$reason_2 = str_replace('{{customer_name}}', $order->customer['firstname'] . ' ' . $order->customer['lastname'], $reason_2);
		$reason_2 = str_replace('{{customer_company}}', $order->customer['company'], $reason_2);
		$reason_2 = str_replace('{{customer_email}}', $order->customer['email_address'], $reason_2);
		$reason_2 = substr($reason_2, 0, 27);

		$user_variable_0 = $order_id;
		$user_variable_1 = $customer_id;

		$session = session_name() . '=' . session_id();

		if (ENABLE_SSL == true)
			$server = HTTPS_SERVER;
		else
			$server = HTTP_SERVER;

		$user_variable_2 = $_SESSION['cart']->cartID;

		$this->sofort->setAmount($amount, $currency);
		$this->sofort->setReason(helperFunctions::convertEncoding($reason_1,3), helperFunctions::convertEncoding($reason_2,3));
		$this->sofort->addUserVariable(helperFunctions::convertEncoding($user_variable_0,3));
		$this->sofort->addUserVariable(helperFunctions::convertEncoding($user_variable_1,3));
		$this->sofort->addUserVariable(helperFunctions::convertEncoding($user_variable_2,3));

		// success return url:
		$success_url = $server . DIR_WS_CATALOG . FILENAME_CHECKOUT_PROCESS . '?' . $session;
		$this->sofort->setSuccessUrl(helperFunctions::convertEncoding($success_url,3)); 			//will be set in -USER_VARIABLE_3-

		// cancel return url:
		if (CHECKOUT_AJAX_STAT=='true') {
			$cancel_url = $server . DIR_WS_CATALOG . FILENAME_CHECKOUT . '?payment_error='.$this->code.'&' . $session;
		} else {
			$cancel_url = $server . DIR_WS_CATALOG . FILENAME_CHECKOUT_PAYMENT . '?payment_error='.$this->code.'&' . $session;
		}

		
		$this->sofort->setAbortUrl(helperFunctions::convertEncoding($cancel_url,3));    			//will be set in -USER_VARIABLE_4-

		// notification url:
		$notification_url = $server . DIR_WS_CATALOG . 'callback/sofort/callback.php?action=ideal';
		$this->sofort->setNotificationUrl(helperFunctions::convertEncoding($notification_url,3));	//will be set in -USER_VARIABLE_5-

		$this->sofort->setSenderCountryId('NL');
		$this->sofort->setSenderBankCode($_SESSION['ideal_bank_name']);

		$url = $this->sofort->getPaymentUrl();

		$time = strftime(' %Y-%m-%d %H:%M:%S');
		$customerNotified = helperFunctions::getIniValue('sofortCustomerNotified');
		$sql_data_array = array('orders_id' => (int) $order_id, 'orders_status_id' => MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_TMP_STATUS_ID , 'date_added' => 'sqlcommand:now()' , 'customer_notified' => $customerNotified , 'comments' => MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_TMP_COMMENT.$time);
		xtc_db_query(helperFunctions::getEscapedInsertInto(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array));
		xtc_db_query("UPDATE ".helperFunctions::escapeSql(TABLE_ORDERS)." SET orders_ident_key='".helperFunctions::escapeSql($tid)."' WHERE orders_id='".helperFunctions::escapeSql($order_id)."'");
		xtc_redirect($url);
	}


	function after_process () {
		/* Clear our session data
		 * All other session data will be handled in checkout_process.php
		 */
		if (isset($_SESSION)) {
			if (isset($_SESSION['cart_pn_sofortueberweisung_ID']))
				unset($_SESSION['cart_pn_sofortueberweisung_ID']);
		}
	}


	function output_error (){
		return false;
	}


	function check () {
		if (!isset($this->_check)) {
			$check_query = xtc_db_query("SELECT configuration_value FROM " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " WHERE configuration_key = 'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_STATUS'");
			$this->_check = xtc_db_num_rows($check_query);
		}
		return $this->_check;
	}


	function get_error () {

		if (isset($_GET['payment_error']) && $_GET['payment_error'] != 'sofort_ideal') {
			return false;
		}

		$error = false;
		$errormsg = '';
		if (!empty($_GET['payment_error'])) {
			//redirect from pnag or abortion by customer or other for customer unimportant error
			//set global error-msg
			$errormsg = MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_ERROR_DEFAULT;
		}
		if(isset($_GET['xmlError'] )) { //error in our module/SofortLib
			//unknown xml-fault
			$errormsg = MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_ERROR_ALL_CODES;
		}
		if(isset($_GET['error_codes'])) { //error is important for customer (e.g. customer-errors)
			$errormsg = '';
			$errorCodes = array_unique (explode(',', helperFunctions::htmlMask($_GET['error_codes'])));
			foreach ($errorCodes as $errorCode) {
				$constant = 'MODULE_PAYMENT_SOFORT_MULTIPAY_XML_FAULT_' . $errorCode;
				if (defined ($constant) ) {
					//show specific errorinfo to customer
					$errormsg .= constant ($constant) . " ";
				} else {
					//specific errorinfo not defined - should never appear
					$errormsg = MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_ERROR_ALL_CODES ;
					break;
				}
			}
			//error exists but no defined errorcode set
			if(empty($errormsg)){
				$errormsg = MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_ERROR_ALL_CODES ;
			}
		}

		return array('title' => MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_TEXT_ERROR_HEADING,
			'error' => $errormsg);
	}


	function install () {
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values 				('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_STATUS', 'True', '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values 				('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_RECOMMENDED_PAYMENT', 'False', '6', '2', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values 								('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_CONFIGURATION_KEY', '',  '6', '3', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values 				('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_AUTH', '---',  '6', '4', 'xtc_cfg_select_option(array(),', now())");  //hide the input-field with an empty <select>
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values 								('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_PROJECT_PASSWORD', '',  '6', '4', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values 								('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_NOTIFICATION_PASSWORD', '',  '6', '5', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values 	('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_ZONE', '0', '6', '6', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values 				('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_REASON_1', 'Nr. {{order_id}} Kd-Nr. {{customer_id}}',  '6', '7', 'xtc_cfg_select_option(array(\'Nr. {{order_id}} Kd-Nr. {{customer_id}}\'), ', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values 								('MODULE_PAYMENT_SOFORT_IDEAL_ALLOWED', 'NL',  '6', '8', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values 								('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_REASON_2', '', '6', '9', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values 				('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_IMAGE', 'Infographic',  '6', '10', 'xtc_cfg_select_option(array(\'Infographic\',\'Logo & Text\'), ', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values 	('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_TMP_STATUS_ID', '0',  '6', '11', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values 	('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_ORDER_STATUS_ID', '0',  '6', '12', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values 	('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_CANCELED_ORDER_STATUS_ID', '0',  '6', '13', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
		xtc_db_query("INSERT INTO " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values 								('MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_SORT_ORDER', '0', '6', '14', now())");
	}


	function remove () {
		xtc_db_query("delete from " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " where configuration_key LIKE 'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_%'");
		xtc_db_query("delete from " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " where configuration_key LIKE 'MODULE_PAYMENT_SOFORT_IDEAL_%'");
		//if this is the last deletion of a multipay-paymentmethod --> we also delete the configurationKey and other values
		$check_query = xtc_db_query("SELECT * FROM " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " WHERE configuration_key like 'MODULE_PAYMENT_SOFORT_%_STATUS'");
		if (xtc_db_num_rows ($check_query) === 0 ) {
			xtc_db_query("delete from " . helperFunctions::escapeSql(TABLE_CONFIGURATION) . " where configuration_key LIKE 'MODULE_PAYMENT_SOFORT_%'");
		}
	}

	function keys () {
		return array(
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_STATUS',
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_RECOMMENDED_PAYMENT',
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_CONFIGURATION_KEY',
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_AUTH',
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_PROJECT_PASSWORD',
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_NOTIFICATION_PASSWORD',
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_ZONE',
			'MODULE_PAYMENT_SOFORT_IDEAL_ALLOWED', //used inside of xt:commerce (not in this module)
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_REASON_1',
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_REASON_2',
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_IMAGE' ,
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_TMP_STATUS_ID' ,
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_ORDER_STATUS_ID' ,
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_CANCELED_ORDER_STATUS_ID' ,
			'MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_SORT_ORDER'
		);
	}

	// @see xtc_remove_order() in admin/includes/functions/general.php
	// mods by Gambio
	function _cancel_order($order_id, $restock = false) {
		if ($restock == 'on') {
			// BOF GM_MOD:
			$order_query = xtc_db_query("select orders_products_id, products_id, products_quantity from ".helperFunctions::escapeSql(TABLE_ORDERS_PRODUCTS)." where orders_id = '".helperFunctions::escapeSql($order_id)."'");
			while ($order = xtc_db_fetch_array($order_query)) {
				xtc_db_query("update ".helperFunctions::escapeSql(TABLE_PRODUCTS)." set products_quantity = products_quantity + ".helperFunctions::escapeSql($order['products_quantity']).", products_ordered = products_ordered - ".helperFunctions::escapeSql($order['products_quantity'])." where products_id = '".helperFunctions::escapeSql($order['products_id'])."'");
				// BOF GM_MOD
				if(ATTRIBUTE_STOCK_CHECK == 'true'){
					$gm_get_orders_attributes = xtc_db_query("SELECT	products_options,
																		products_options_values
																FROM	orders_products_attributes
																WHERE	orders_id = '".helperFunctions::escapeSql($order_id)."'
																AND		orders_products_id = '".helperFunctions::escapeSql($order['orders_products_id'])."'");
					while($gm_orders_attributes = xtc_db_fetch_array($gm_get_orders_attributes)) {
						$gm_get_attributes_id = xtc_db_query("SELECT	pa.products_attributes_id
																FROM	products_options_values pov,
																		products_options po,
																		products_attributes pa
																WHERE	po.products_options_name = '".helperFunctions::escapeSql($gm_orders_attributes['products_options'])."'
																AND		po.products_options_id = pa.options_id
																AND		pov.products_options_values_id = pa.options_values_id
																AND		pov.products_options_values_name = '".helperFunctions::escapeSql($gm_orders_attributes['products_options_values'])."'
																AND		pa.products_id = '".helperFunctions::escapeSql($order['products_id'])."'
																LIMIT	1");
						if(xtc_db_num_rows($gm_get_attributes_id) == 1){
							$gm_attributes_id = xtc_db_fetch_array($gm_get_attributes_id);
							xtc_db_query("UPDATE products_attributes
														SET attributes_stock = attributes_stock + ".helperFunctions::escapeSql($order['products_quantity'])."
														WHERE products_attributes_id = '".helperFunctions::escapeSql($gm_attributes_id['products_attributes_id'])."'");
						}
					}
				}
				// EOF GM_MOD
			}
		}

		//update status and customer-history
		$time = strftime(' %Y-%m-%d %H:%M:%S');
		xtc_db_query('UPDATE orders SET orders_status = "'.helperFunctions::escapeSql(MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_CANCELED_ORDER_STATUS_ID).'", last_modified = now() WHERE orders_id = '.helperFunctions::escapeSql($order_id));
		$sql_data_array = array('orders_id' => (int) $order_id,
								'orders_status_id' => MODULE_PAYMENT_PNAG_IDEAL_CLASSIC_CANCELED_ORDER_STATUS_ID ,
								'date_added' => 'sqlcommand:now()',
								'customer_notified' => helperFunctions::getIniValue('sofortCustomerNotified'),
								'comments' => MODULE_PAYMENT_SOFORT_MULTIPAY_ORDER_CANCELED." ".$time);
		xtc_db_query(helperFunctions::getEscapedInsertInto(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array));
	}
}
?>