<?php
//XT:Commerce3 Foxrate Plugin

//IMPORTANT
//If you edit this file, be sure to save the filetype as utf-8.
//Otherwise the product export may fail.
//error_reporting(E_ALL);
//Plugin checks it has been installed.

include('langs.php');
include('json.php');

if(isset($_GET['lang'])){
	setcookie('foxrate_lang',$_GET['lang']);
	header('location: '.str_replace('?lang='.$_GET['lang'], '', curPageURL()));
}

$foxrate = new foxrate();

if($foxrate->fox_setup == 1){
if(isset($_GET['check'])) $foxrate->do_orders();	
}

class foxrate{
	
var $fox_setup = 0;
var $fox_user = false;
var $fox_pass =false;
var $webshop = false;
var $FoxrateURL = 'http://fb.foxrate.de/';
var $secretKey = 'Foxrate';
var $isUserExistURL = 'feedback_api/is_user_exist.php';
var $setShopmoduleUrlURL = 'feedback_api/set_shopmodule_url.php';
var $types_response = array('POST', 'JSON', 'XML');
var $types_request = array('POST', 'JSON', 'XML');
var $fox_shop_id = 0;
var $lang = 'de';
var $config_path = false;

//Initialise foxrate class.
	function foxrate(){
	global $language;
		if(isset($_COOKIE['foxrate_lang'])) $this->lang = $_COOKIE['foxrate_lang']; 
		$this->check_environment();
		$this->setShopmoduleUrlURL = $this->FoxrateURL.$this->setShopmoduleUrlURL;
		$this->isUserExistURL = $this->FoxrateURL.$this->isUserExistURL;
		$this->webshop = new xt_commerce_3($this->lang,$this->config_path);

		//Check and load configuration
	if(file_exists('foxrate_config.php')){
		include('foxrate_config.php');
		$this->fox_setup = FOX_SETUP;
		$this->fox_user = FOX_USER;
		$this->fox_pass = FOX_PASS;	
		$this->fox_shop_id = FOX_SHOP_ID;
	}
	
	//If this is a connection test display api data and exit.
	if(isset($_GET['connection_test'])){
		header("Content-type: text/html; charset=utf-8");
		$array['foxrate_auth_login'] = $this->fox_user;
		echo json_encode($array);
		exit();
	}
	//If this is a reset...
	if(isset($_GET['reset'])) $this->reset_foxrate();
	
			if($this->fox_setup == 0){
				//Not yet configured. Do Setup method
				$this->do_setup();
			}else{
				if($this->isUserExist() != 'true') exit($language[$this->lang]['api_error']);
				//Seems to be configured with foxrate ok.
				
				//Connect to shop
				if($this->fox_shop_id == 0){

					$setup = $this->setShopModuleUrl();
	
					if($setup->error == 'true'){
						echo $language[$this->lang]['api_connect_error'].': '.curPageUrl().' Error message: '.$setup->error_msg.'<pre>';
						print_r($setup);
						exit();
					}else{
			$this->save_setup_file($this->fox_user, $this->fox_pass,$setup->shop_id);
					}
					
				}
			if(count($_GET) == 0) 		print_template($language[$this->lang]['setup_title'], $language[$this->lang]['step_configured'], $language[$this->lang]['api_connect_success'].' '.$this->webshop->system_name.'.', false, false, false, false, 4, $this->lang);
				
			
			}	
		}
		

		
		
	function reset_foxrate(){
		global $language;
		if($this->fox_setup == 0){
			//Shop is not setup, delete any configs and redirect.
			if(file_exists('foxrate_config.php')) unlink('foxrate_config.php');
			if(file_exists('foxrate_db.php')) unlink('foxrate_db.php');
			if(file_exists('foxrate_shop.php')) unlink('foxrate_shop.php');
			header('location: '.str_replace('?reset','',curPageURL()));
			exit();
		}else{
			//Shop is already setup, authenticate first.
			if(isset($_POST['fox_user']) && isset($_POST['fox_pass']) && $this->fox_pass == $_POST['fox_pass'] && $this->fox_user == $_POST['fox_user']){
				if(file_exists('foxrate_config.php')) unlink('foxrate_config.php');
				if(file_exists('foxrate_db.php')) unlink('foxrate_db.php');
				if(file_exists('foxrate_shop.php')) unlink('foxrate_shop.php');
				header('location: '.str_replace('?reset','',curPageURL()));
				exit();
				
			}

		if($error!==false)$errors[] = $error;
		$fields[] = array('label'=> $language[$this->lang]['api_username'], 'html' => '<input type="text" value="" name="fox_user">');
		$fields[] = array('label'=> $language[$this->lang]['api_password'], 'html' => '<input type="text" value="" name="fox_pass">');
		print_template($language[$this->lang]['setup_title'], $language[$this->lang]['setup_title'], $language[$this->lang]['reset_intro'], $errors, $fields,$language[$this->lang]['reset_save'], false, 4,$this->lang);
			
		}
		
	}
	
 function check_environment(){
	
	global $language;
	$errors = false;
	$failure = false;
	//Is folder writable
	if(!is_writable(getcwd())  && !chmod(getcwd(),0777)){
		$errors[] = $language[$this->lang]['writable_error'];
		$failure = true;
	}
	//Is curl installed?
	if(!function_exists('curl_version')){
		$errors[] = $language[$this->lang]['curl_error'];
		$failure = true;
	}
	//Is there a shop here?
	$config_path[] = '../includes/configure.php';
	$config_path[] = '../../includes/configure.php';
	$config_path[] = '../../../includes/configure.php';
	foreach($config_path as $path){
		if(file_exists($path)){
		$this->config_path = $path;
		break;
		}	
	} 
	if($this->config_path === false){
		$errors[] = $language[$this->lang]['config_error'];
		$failure = true;
	}
	if($failure) $failure = $language[$this->lang]['environment_failure'];
	
	if($errors !== false){
 print_template($language[$this->lang]['setup_title'],$language[$this->lang]['step_environment'], '', $errors, false, false, $failure,0,$this->lang);
			}
}
	
	//Configure shop and shakehands with foxrate
	 function do_setup(){
global $language;
		//Has the form been posted?
		if(isset($_POST['fox_user'])){
			$this->fox_user = $_POST['fox_user'];
			$this->fox_pass = $_POST['fox_pass'];
			//Try the handshake
			$shake = $this->isUserExist();
			if($shake == 'true'){
				//Handshake was successfull, store is authenticated. Write and save user data to pass and mark as setup.
				//submit shop url
				$this->save_setup_file($_POST['fox_user'], $_POST['fox_pass']);
				//			
			}else{
				//Hand shake unsuccessful
				$this->output_setup_form($language[$this->lang]['api_error']);
			}	
		}else{
		$this->output_setup_form();	
		}
	}
	
	
	//Output the setup form.
	 function output_setup_form($error=false){
		global $language;
		if($error!==false)$errors[] = $error;
		$fields[] = array('label'=> $language[$this->lang]['api_username'], 'html' => '<input type="text" value="'.$this->fox_user.'" name="fox_user">');
		$fields[] = array('label'=> $language[$this->lang]['api_password'], 'html' => '<input type="text" value="'.$this->fox_pass.'" name="fox_pass">');
		print_template($language[$this->lang]['setup_title'], $language[$this->lang]['step_foxrate'], $language[$this->lang]['shop_setup_intro'], $errors, $fields,$language[$this->lang]['foxrate_save'], false, 3,$this->lang);
	}
	

	
	//Save the foxrate setup file.
	 function save_setup_file($user,$pass,$shop_id=0){
	if(file_exists('foxrate_config.php') && !chmod('foxrate_config.php',0777)) die('Cannot write config files.');
	$str = '<?php'.PHP_EOL;
	$str .= 'define("FOX_USER","'.$user.'");'.PHP_EOL;
	$str .= 'define("FOX_PASS","'.$pass.'");'.PHP_EOL;
	$str .= 'define("FOX_SETUP","1");'.PHP_EOL;	
	$str .= 'define("FOX_SHOP_ID","'.$shop_id.'");'.PHP_EOL;			
	$str .= '?>';	
	$fh = fopen('foxrate_config.php','w+');
	fwrite($fh, $str);
	fclose($fh);
	chmod('foxrate_config.php',0644);
		header('location: '.curPageURL());
		exit();
	}
	
	
	//Main foxrate call to get orders.
	 function do_orders(){
	if(!isset($_GET['check']) || 
			($_GET['check'] != md5(md5($this->fox_user.$this->fox_pass)) &&
			$_GET['check'] != md5(md5($this->fox_user.$this->fox_pass).$this->secretKey))
			) exit('Authetication Failed');
	$data = $this->webshop->get_order_data();
	header("Content-type: text/html; charset=utf-8");
	if(empty($data)){
		$data = array('foxrate_auth_id' => 1,
    	'error' => 'no_data_order'
				);
	}
   if (!function_exists('mysql_set_charset')) $data = mb_convert_encoding_array($data);
	echo json_encode($data);
	exit();
	}
	
	//Create the authentication headers.
	 function createHeaders($type_responce, $type_request = null){
		$headers = array();
		 
		$headers[] = "FoxrateAuthLogin: ".$this->fox_user;
		$headers[] = "FoxrateAuthPassword: ".$this->fox_pass;
		 
	    if(in_array($type_responce, $this->types_response)) 
		    $headers[] = "FoxrateResponceType: ".$type_responce;

	    if(!is_null($type_request) && in_array($type_request, $this->types_request)) 
		    $headers[] = "FoxrateRequestType: ".$type_request;
	
		return $headers;
	}

	//Check this account with foxrate
	 function isUserExist($type_response = 'JSON'){
		
		$headers = $this->createHeaders($type_response);
		$request =  json_decode($this->makeRequest($this->isUserExistURL, $headers));

		if($request->error != 'false') return false;
		return $request->user_exist;
	}
	 
	//Inform foxrate of the foxrate export script.
	 function setShopModuleUrl($type_response = 'JSON', $type_request = 'POST'){
	if($this->fox_shop_id != 0)	$params['shop_id'] = $this->fox_shop_id;
		$params['shop_module_url'] = curPageURL();
		$params['shop_system'] = strtolower($this->webshop->system_name);
		$params['shop_system_version'] = $this->webshop->system_version;
		$params['plugin_version'] = strtolower($this->webshop->plugin_version);
		$headers = $this->createHeaders($type_response, $type_request);
		return json_decode($this->makeRequest($this->setShopmoduleUrlURL, $headers, $params));
	}
	
	//Send the request via cUrl
	 function makeRequest($url, $headers, $params = null){
		$ch = curl_init();

		$opts[CURLOPT_CONNECTTIMEOUT] = 10;
		$opts[CURLOPT_RETURNTRANSFER] = true;
		$opts[CURLOPT_TIMEOUT] = 60;
		$opts[CURLOPT_HTTPHEADER] = $headers;
		$opts[CURLOPT_URL] = $url;
		if(!is_null($params)){
			$opts[CURLOPT_POSTFIELDS] = $params;
		}
		 
		        foreach($opts as $key => $value){
          curl_setopt($ch, $key, $value);
        }
		$result = curl_exec($ch);
		$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		if ($result === false || $code != 200) {
			
			$en = curl_errno($ch);
			$e = curl_error($ch);
			curl_close($ch);
			return 'HTTP Code: '.$code.', cURL errno: '.$en.', cURL error: '.$e;
		}
		curl_close($ch);
		return $result;
	}
	

	

}


//Data specifc to XT:commerce3 and XTC-modified
class xt_commerce_3{

	var $db_host;
	var $db_pass;
	var $db_user;
	var $db_database;
	var $db_prefix = '';
	var $connection = false;
	var $system_name = 'XTCommerce';
	var $system_version = '3';	
	var $plugin_version = 'xtcommerce_1';	
	var $seo_type='default';
	var $image_path='';	
	// private $image_path='images/';//Zencart	
	var $shop_url='';
	var $lang = 'en';

	function xt_commerce_3($lang,$config_path){
		//Look for the foxrate db overide file
		$this->lang = $lang;
		$this->config_path = $config_path;
		if(file_exists('foxrate_db.php')){
			include('foxrate_db.php');
			$this->db_host = FOX_DB_SERVER;
			$this->db_pass = FOX_DB_SERVER_PASSWORD;
			$this->db_user = FOX_DB_SERVER_USERNAME;
			$this->db_database = FOX_DB_DATABASE;
			$this->db_prefix = FOX_DB_PREFIX;
		}else{
			//Can we load the original config file?
			if(file_exists($config_path)){
			include($config_path);
			$this->db_host = DB_SERVER;
			$this->db_pass = DB_SERVER_PASSWORD;
			$this->db_user = DB_SERVER_USERNAME;
			$this->db_database = DB_DATABASE;	
			}
			//Read the db details from the config file
			
		}
		//Try and connect to the db.
		$connected = $this->db_connect();
		if(true !== $connected) $this->db_override($connected);
	
		
		if(!file_exists('foxrate_shop.php')){

			if(file_exists($this->config_path)) include($this->config_path);
			$this->image_path = DIR_WS_IMAGES;
			if(defined('DIR_WS_INFO_IMAGES')) $this->image_path = DIR_WS_INFO_IMAGES;
			//Setup the shop url.
			$this->shop_url = "http://" . $_SERVER['HTTP_HOST']."/";			
		$this->shop_setup();			
		}else{
			include('foxrate_shop.php');
			$this->seo_type = SHOP_SEO_TYPE;
			$this->image_path = SHOP_IMAGE_PATH;
			$this->shop_url = SHOP_URL;	
		}
	
	}
	
	
	//Setup assistant for shop config (url location, url type, location)
	//Save if posted
	 function shop_setup($error=false){
		global $language;
		if(isset($_POST['image_path'])){
			
			$this->save_shop_setup_file($_POST['image_path'],'',$_POST['shop_url']);
		}	
//Select a random product.
		$prod_sql = "SELECT p.products_image, d.products_name FROM ".$this->db_prefix."products p 
		LEFT JOIN ".$this->db_prefix."products_description d 
		ON (p.products_id = d.products_id AND d.language_id=1)
		 WHERE p.products_image != '' AND p.products_image NOT LIKE 'http://%'  AND p.products_image NOT LIKE 'https://%' 
		ORDER BY RAND() LIMIT 0,1";
		$prod_result = mysql_query($prod_sql,$this->connection)or die('Select Random Product: '.mysql_error());;
		while($prod = mysql_fetch_assoc($prod_result)){	
$image = $prod['products_image'];
$image_folder = str_replace('includes/configure.php','',$this->config_path);
$image_path_try[] = $this->image_path.$image;	
$image_path_try[] = 'images/'.$image;
$image_path_try[] = 'images/products/'.$image;
$image_path_try[] = 'images/thumbs/'.$image;
$image_path_try[] = 'images/medium/'.$image;
		}

		foreach($image_path_try as $image_path){
			if(file_exists($image_folder.$image_path) && checkRemoteFile($this->shop_url.'/'.$image_path)){
				$this->image_path = str_replace($image,'',$image_path);
				$correct_image_path = true;
				$correct_url = true;
				break;
			}
		}

		
		

if(isset($correct_image_path) && $correct_image_path === true){
	$fields[] = array('label'=> $language[$this->lang]['image_path'], 'html' => '<input class="correct" type="text" value="'.$this->image_path.'" name="image_path"><span class="pupsipups">'.$language[$this->lang]['checked'].'</span>');
}else{
	$fields[] = array('label'=> $language[$this->lang]['image_path'], 'html' => '<input type="text" value="'.$this->image_path.'" name="image_path">');
}

if(isset($correct_url) && $correct_url === true){
	$fields[] = array('label'=> $language[$this->lang]['shop_url'], 'html' => '<input class="correct" type="text" value="'.$this->shop_url.'" name="shop_url"><span class="pupsipups">'.$language[$this->lang]['checked'].'</span>');
}else{
	$fields[] = array('label'=> $language[$this->lang]['shop_url'], 'html' => '<input type="text" value="'.$this->shop_url.'" name="shop_url">');
}

		
				
		print_template($language[$this->lang]['setup_title'], $language[$this->lang]['step_shop'], $language[$this->lang]['shop_setup_intro'], $errors, $fields,$language[$this->lang]['shop_save'], false, 2,$this->lang);

	}	
	
	//Save the config items for the shop.
	 function save_shop_setup_file($image_path,$seo_type,$shop_url){
		$str = '<?php'.PHP_EOL;
		$str .= 'define("SHOP_IMAGE_PATH","'.$image_path.'");'.PHP_EOL;
		$str .= 'define("SHOP_SEO_TYPE","'.$seo_type.'");'.PHP_EOL;
		$str .= 'define("SHOP_URL","'.$shop_url.'");'.PHP_EOL;
		$str .= '?>';
		$fh = fopen('foxrate_shop.php','w+');
		fwrite($fh, $str);
		fclose($fh);
		header('location: '.curPageURL());
		exit();
	}
	
	//If we cannot connect with the data in the config file, create form for manual entry.
	//If submitted test and save.
	 function db_override($error=false){
		global $language;

		//Check if form is submitted
		if(isset($_POST['db_host'])){
			$this->db_host = $_POST['db_host'];
			$this->db_pass = $_POST['db_pass'];
			$this->db_user = $_POST['db_user'];
			$this->db_database = $_POST['db_database'];
			$this->db_prefix = $_POST['db_prefix'];
			//Check if we can now connect.
			$connected = $this->db_connect();
			if(true === $connected){
				$this->save_db_override();
				return true;
			}else{
				$error = $connected;
			}
		}
			if($error!==false)$errors[] = $language[$this->lang][$error];		
		
$class = 'correct';
if($error== 'db_cannot_connect') $class = '';
$fields[] = array('label'=> $language[$this->lang]['db_host'], 'html' => '<input class="'.$class.'" type="text" value="'.$this->db_host.'" name="db_host">');
$fields[] = array('label'=> $language[$this->lang]['db_user'], 'html' => '<input class="'.$class.'" type="text" value="'.$this->db_user.'" name="db_user">');
$fields[] = array('label'=> $language[$this->lang]['db_pass'], 'html' => '<input class="'.$class.'" type="text" value="'.$this->db_pass.'" name="db_pass">');
if($error== 'db_cannot_find_db') $class = '';
$fields[] = array('label'=> $language[$this->lang]['db_name'], 'html' => '<input class="'.$class.'" type="text" value="'.$this->db_database.'" name="db_database">');
if($error== 'db_cannot_find_shop') $class = '';
$fields[] = array('label'=> $language[$this->lang]['db_prefix'], 'html' => '<input class="'.$class.'" type="text" value="'.$this->db_prefix.'" name="db_prefix">');
		print_template($language[$this->lang]['setup_title'], $language[$this->lang]['step_database'], $language[$this->lang]['db_setup_intro'], $errors, $fields, $language[$this->lang]['database_save'], false, 1,$this->lang);

	}
	
	//Connect to the database using given settings or return failure.
	 function db_connect(){
		global $language;
		$this->connection = mysql_connect($this->db_host,$this->db_user,$this->db_pass); 	
		if($this->connection == false) return 'db_cannot_connect';
		mysql_select_db($this->db_database, $this->connection);
		if(mysql_error()) return 'db_cannot_find_db';
		//Check orders table exists
		$sql= 'DESC '.$this->db_prefix.'orders;';
		mysql_query($sql);
		if (mysql_errno()==1146) return  'db_cannot_find_shop';
		//Check products table exists
		$sql= 'DESC '.$this->db_prefix.'products;';
		mysql_query($sql);
		if (mysql_errno()==1146) return  'db_cannot_find_shop';		
		//Check customers table exists
		$sql= 'DESC '.$this->db_prefix.'customers;';
		mysql_query($sql);
		if (mysql_errno()==1146) return  'db_cannot_find_shop';		
		//Check categories table exists
		$sql= 'DESC '.$this->db_prefix.'orders;';
		mysql_query($sql);
		if (mysql_errno()==1146) return  'db_cannot_find_shop';		
		//Check products_to_categories table exists
		$sql= 'DESC '.$this->db_prefix.'products_to_categories;';
		mysql_query($sql);
		if (mysql_errno()==1146) return  'db_cannot_find_shop';	
		//Check order_products table exists
		$sql= 'DESC '.$this->db_prefix.'orders_products;';
		mysql_query($sql);
		if (mysql_errno()==1146) return  'db_cannot_find_shop';		
		//Check languages table exists
		$sql= 'DESC '.$this->db_prefix.'languages;';
		mysql_query($sql);
		if (mysql_errno()==1146) return  'db_cannot_find_shop';			
		//Check categories_description table exists
		$sql= 'DESC '.$this->db_prefix.'categories_description;';
		mysql_query($sql);
		if (mysql_errno()==1146) return  'db_cannot_find_shop';		
		if (function_exists('mysql_set_charset')) 	mysql_set_charset('utf8',$this->connection);
		return true;
	}
	
	//Save the manually enteres database settings to a file.
	 function save_db_override(){
		global $language;
		$str = '<?php'.PHP_EOL;
		$str .= 'define("FOX_DB_SERVER","'.$this->db_host.'");'.PHP_EOL;
		$str .= 'define("FOX_DB_SERVER_PASSWORD","'.$this->db_pass.'");'.PHP_EOL;
		$str .= 'define("FOX_DB_SERVER_USERNAME","'.$this->db_user.'");'.PHP_EOL;
		$str .= 'define("FOX_DB_DATABASE","'.$this->db_database.'");'.PHP_EOL;
		$str .= 'define("FOX_DB_PREFIX","'.$this->db_prefix.'");'.PHP_EOL;
		$str .= '?>';
		$fh = fopen('foxrate_db.php','w+');
		fwrite($fh, $str);
		fclose($fh);
	}
	
	
	//Get data from the database as array
	 function get_order_data($days=30){
	   if(isset($_GET['days'])) $days = (int) $_GET['days'];
		$start_date = strtotime("-".$days." day 00:00:00");
		$result = mysql_query("SHOW COLUMNS FROM ".$this->db_prefix."orders LIKE 'language'",$this->connection);
		//Select all orders from last x days
		$mysql_startdate = date( 'Y-m-d H:i:s', $start_date );
		if(mysql_num_rows($result) != 0){
			
			//XT:commerce		
			$sql = "SELECT
			o.date_purchased as purchase_date,
			o.orders_id,
			o.customers_firstname,
			o.customers_lastname,
			o.customers_postcode,
			o.customers_state,
			o.customers_city,
			o.customers_id,
			o.customers_country,
			o.customers_telephone,
			o.customers_email_address,
			o.currency,
			l.code as order_lang,
			c.customers_gender,
			l.languages_id,
			c.customers_dob
			FROM ".$this->db_prefix."orders o
			LEFT JOIN ".$this->db_prefix."customers c
			ON (o.customers_id = c.customers_id)
			LEFT JOIN ".$this->db_prefix."languages l
			ON (o.language = l.directory)
			WHERE date_purchased >= '$mysql_startdate'";
		}else{
			//Zencart/OSCommerce
			
			$sql = "SELECT
			o.date_purchased as purchase_date,
			o.orders_id,
			o.customers_name,
			o.customers_postcode,
			o.customers_state,
			o.customers_city,
			o.customers_id,
			o.customers_country,
			o.customers_telephone,
			o.customers_email_address,
			o.currency,
			c.customers_gender,
			l.languages_id,
			l.code as order_lang,
			c.customers_dob
			FROM ".$this->db_prefix."orders o
			LEFT JOIN ".$this->db_prefix."customers c
			ON (o.customers_id = c.customers_id)
			LEFT JOIN ".$this->db_prefix."languages l
			ON (1 = l.languages_id)
			WHERE date_purchased >= '$mysql_startdate'";
		}

		$array= array();

		$result = mysql_query($sql,$this->connection)or die('Get Orders: '.mysql_error());;
		while($row = mysql_fetch_assoc($result)){
		$customer = array();
		$item = array();
		$order = array();
		$products= array();
		$language_id = $row['languages_id'];
		//Build array for customer
		$customer = array(
				'customers_id' => $row['customers_id'],
				'customers_city' => $row['customers_city'],
				'customers_postcode' => $row['customers_postcode'],
				'customers_state' => $row['customers_state'],
				'customers_country' => $row['customers_country'],
				'customers_telephone' => $row['customers_telephone'],
				'customers_email_address' => $row['customers_email_address'],
				'customers_gender' => $row['customers_gender'],
				);
		if(isset($row['customers_name'])){
			$name_array = explode(' ', $row['customers_name']);
			$customer['customers_firstname'] = $name_array[0];
			$customer['customers_lastname'] = $name_array[count($name_array)-1];
		}else{
			$customer['customers_firstname'] = $row['customers_firstname'];
			$customer['customers_lastname'] = $row['customers_lastname'];
		}
		if($row['customers_dob'] != '0000-00-00 00:00:00') $customer['customers_dob'] = strtotime($row['customers_dob']);
		//Build array for order
		$order = array('orders_id' => $row['orders_id'],
				'order_date' => strtotime($row['purchase_date']),
				'order_currency' => $row['currency'],
				'order_language' => $row['order_lang']
		);
//XTmodified, XT Commerce has products_ean
$ean = '';
if(strpos(strtolower($this->system_name),'xt') !== false) $ean = " p.products_ean, ";
		//Select products for this order
		$prod_sql = "SELECT 
					o.final_price,
					o.products_model,
					o.products_name,
					o.products_id,".$ean."
					p.products_image
					FROM ".$this->db_prefix."orders_products o 
					LEFT JOIN ".$this->db_prefix."products p 
					ON (o.products_id = p.products_id) WHERE o.orders_id = '".$row['orders_id']."'";
		$prod_result = mysql_query($prod_sql,$this->connection)or die('Get Products: '.mysql_error());;
		while($prod = mysql_fetch_assoc($prod_result)){
			$product = array();
			$category = '';
			//Build product array
			$product = array(
					'products_id' => $prod['products_id'],
					'products_model' => $prod['products_model'],
					'products_name' => $prod['products_name'],
					'final_price' => $prod['final_price'],
					'products_currency' => $order['order_currency']
			);
			$category = $this->get_prod_categories($prod['products_id'],$language_id);
			$product['category_name'] = $category;		
			if(isset($prod['products_ean']))$product['products_ean'] = $prod['products_ean'];		
			$product['products_image'] = $this->product_image($prod['products_image']);
			$product['products_url'] = '';			
			$products[] = $product;			
		}
		//Add order details to array.
		$item['customer'] = $customer;
		$item['order']= $order;
		$item['products'] = $products;
		$array[] = $item;
		}
//	print '<pre>';
//	print_r($array);	
	
	return $array;	
	}
	
	//Get product Category ID, and return the category tree
	 function get_prod_categories($product_id,$language_id){
		$sql = "SELECT categories_id 
				FROM ".$this->db_prefix."products_to_categories
				 WHERE products_id = '$product_id' LIMIT 0,1";
		$result = mysql_query($sql,$this->connection)or die('Get Product Catgeories: '.mysql_error());;
		while($row = mysql_fetch_assoc($result)){
		$category_id = $row['categories_id'];	
		}
	$categories = $this->recursive_categories($category_id,$language_id);
	//Reverse the array.
	$categories = explode('|',$categories);
	$categories = array_reverse($categories);
	$categories = implode('|',$categories);
	return $categories;
	}
	
	//Recursivly trawl categories to build category tree.
	 function recursive_categories($category_id,$language_id){
		$string='';
		$sql = "SELECT 
		c.parent_id,
		 d.categories_name
		 FROM ".$this->db_prefix."categories c
		LEFT JOIN ".$this->db_prefix."categories_description d 
		ON (c.categories_id = d.categories_id AND d.language_id = '$language_id')
		 WHERE c.categories_id = '$category_id' LIMIT 0,1";
		
		$result = mysql_query($sql,$this->connection)or die('Recurse Categories: '.mysql_error());;
		while($row = mysql_fetch_assoc($result)){
			$parent_id = $row['parent_id'];
			$string.= $row['categories_name'];
			if($parent_id != 0) $string.= '|'.$this->recursive_categories($parent_id,$language_id);
		}	
		return $string;
	}
	
	

	
	
	//Build the full url of the product image
	 function product_image($products_image){
		if($products_image == NULL || $products_image == '' || strtolower($products_image) == 'null') return '';
		if(strpos($products_image, 'http://') !== false || strpos($products_image, 'https://') !== false) return $products_image;
		$image= $this->shop_url.$this->image_path.$products_image;
	return $image;	
	}
	
	

	

}



//Output the data in a template.
function print_template($title = 'FOXRATE', $h3 = false, $page_intro = false, $errors= false, $fields = false, $submit = false, $failure= false, $step= 0, $lang = 'en'){
global $language;
$steps[] = $language[$lang]['step_environment'];	
$steps[] = $language[$lang]['step_database'];
$steps[] = $language[$lang]['step_shop'];	
$steps[] = $language[$lang]['step_foxrate'];
for($i = 0; $i < count($steps); $i++){

	$complete = '';
	$active = '';
	$last = '';	
	if($i < $step) $complete = 'fertigvoll';
	if($i == $step-1) $complete = 'fertig';	
	if($i == $step) $active = 'aktiv';	
	if($i == count($steps)-1) $last = 'last';	
$step_html .= '<div class="'.$active.' '.$complete.' fleft '.$last.'"><span>'.$steps[$i].'</span></div>';
}

	ob_start(); //Turn on output buffering
	include('template.php');
	$pagecontent=ob_get_contents();
	ob_end_clean();
	echo $pagecontent;
	exit();
}

//Get the current page url.
function curPageURL() {
	$pageURL = 'http';
	if (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] == "on") {
		$pageURL .= "s";
	}
	$pageURL .= "://";
	if ($_SERVER["SERVER_PORT"] != "80") {
		$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
	} else {
		$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
	}
	return $pageURL;
}

function checkRemoteFile($url)
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL,$url);
	// don't download content
	curl_setopt($ch, CURLOPT_NOBODY, 1);
	curl_setopt($ch, CURLOPT_FAILONERROR, 1);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	if(curl_exec($ch)!==FALSE)
	{
		return true;
	}
	else
	{
		return false;
	}
}

function mb_convert_encoding_array($arr) {

$newArr = array();
if (!empty($arr)) {
foreach($arr AS $key => $value) {
$newArr[$key] = (is_array($value) ? mb_convert_encoding_array($value) : mb_convert_encoding($value,'UTF-8',"auto")  );
}
}
return $newArr;
}


?>