<?php
/*-----------------------------------------------------------------
* 	ID:						orders.php
* 	Letzter Stand:			v2.2 R365
* 	zuletzt geaendert von:	akausch
* 	Datum:					2012/07/03
*
* 	Copyright (c) since 2010 commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
* 	Released under the GNU General Public License
* ---------------------------------------------------------------*/

require ('includes/application_top.php');
require_once (DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once (DIR_FS_INC.'xtc_php_mail.inc.php');
require_once (DIR_FS_INC.'xtc_add_tax.inc.php');
require_once (DIR_FS_INC.'changedataout.inc.php');
require_once (DIR_FS_INC.'xtc_validate_vatid_status.inc.php');
require_once (DIR_FS_INC.'xtc_get_attributes_model.inc.php');
require_once(DIR_FS_INC.'cseo_get_pdf_nr.inc.php');

/* magnalister v1.0.1 */
if (function_exists('magnaExecute')) magnaExecute('magnaSubmitOrderStatus', array(), array('order_details.php'));
/* END magnalister */

// initiate template engine for mail
$smarty = new Smarty;
require (DIR_WS_CLASSES.'currencies.php');
$currencies = new currencies();

if ((($_GET['action'] == 'edit') || ($_GET['action'] == 'update_order') || ($_GET['action'] == 'update_box')) && ($_GET['oID'])) {
	$oID = xtc_db_prepare_input($_GET['oID']);

	$orders_query = xtc_db_query("select orders_id from ".TABLE_ORDERS." where orders_id = '".xtc_db_input($oID)."'");
	$order_exists = true;
	if (!xtc_db_num_rows($orders_query)) {
		$order_exists = false;
		$messageStack->add(sprintf(ERROR_ORDER_DOES_NOT_EXIST, $oID), 'error');
	}
}

if (($action == 'edit') && isset($_GET['eID'])) {
	$eID = xtc_db_prepare_input($_GET['eID']);

	$orders_query = xtc_db_query("select orders_id from " . TABLE_ORDERS . " where edebit_transaction_id = '" . $eID . "'");
	$order_exists = true;
	if (!xtc_db_num_rows($orders_query)) {
		$order_exists = false;
		$messageStack->add(sprintf(ERROR_ORDER_DOES_NOT_EXIST, $eID), 'error');
	} else {
		$orders = xtc_db_fetch_array($orders_query);
		$oID = $orders['orders_id'];
		$HTTP_GET_VARS['oID'] = $oID;
	}
}

if (($action == 'edit') && isset($_GET['guTID'])) {
    $eID = xtc_db_prepare_input($_GET['guTID']);
    $orders_query = xtc_db_query("select orders_id from " . TABLE_ORDERS . " where edebit_gutid = '" . $guTID . "'");
    $order_exists = true;
    if (!xtc_db_num_rows($orders_query)) {
		$order_exists = false;
		$messageStack->add(sprintf(ERROR_ORDER_DOES_NOT_EXIST, $guTID), 'error');
    } else {
		$orders = xtc_db_fetch_array($orders_query);
		$oID = $orders['orders_id'];
		$HTTP_GET_VARS['oID'] = $oID;
	}
}

require(DIR_WS_CLASSES.'order.php');
if ((($_GET['action'] == 'edit') || ($_GET['action'] == 'update_order') || ($_GET['action'] == 'update_box')) && ($order_exists)) {
	$order = new order($_GET['oID']);

	require_once(DIR_FS_INC.'cseo_get_pdf.inc.php');
	if(isset($_GET['pdf']) && $_GET['pdf'] == 'print_order') {
		if(isset($_POST['what_to_do']) && $_POST['what_to_do'] == 'pdf_rechnung_loeschen') {
			$pdf_pfad = cseo_get_pdf($_POST['oID'], false, false, false, true);
			if(file_exists($pdf_pfad)) {
				unlink($pdf_pfad);
				xtc_db_query("DELETE FROM orders_pdf WHERE order_id = '".$_POST['oID']."'");
				$_SESSION['msg']['dl'] = '<div class="success_msg">'.PDF_DELETE_SUCCESS.'</div>';
				if($_POST['pdf_rechnung_senden'] !='1')
					xtc_redirect(FILENAME_ORDERS.'?page='.$_POST['page'].'&oID='.$_POST['oID'].'&action=edit#pdf');
			}
		} elseif(isset($_POST['what_to_do']) && ($_POST['what_to_do'] == 'bill' || $_POST['what_to_do'] == 'delivery')) {
			if($_POST['what_to_do'] == 'delivery') {
				define('PDF_LIEFERSCHEIN', true);
				$type = 'lieferschein';
			} else {
				define('PDF_LIEFERSCHEIN', false);
			}
			include_once('create_pdf.php');
		}
	}

    if($_POST['pdf_rechnung_senden']=='1' ) {
		    $check_status_query = xtc_db_query("SELECT
		    										o.customers_name, o.customers_email_address, o.orders_status, o.date_purchased, op.bill_name
		    									FROM
		    										orders o, orders_pdf op
		    									WHERE
		    										o.orders_id = '".xtc_db_input($oID)."'
		    									AND
		    										op.order_id = '".xtc_db_input($oID)."'");
  	    $check_status = xtc_db_fetch_array($check_status_query);

      	$smarty->assign('language', $_SESSION['language']);
	    $smarty->caching = false;

	    $smarty->assign('tpl_path', 'templates/'.CURRENT_TEMPLATE.'/');
	    $smarty->assign('logo_path', HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');

	    $smarty->assign('NAME', $check_status['customers_name']);
	    $smarty->assign('ORDER_NR', cseo_get_pdf_nr($oID, true));
	    $smarty->assign('ORDER_LINK', xtc_catalog_href_link(FILENAME_CATALOG_ACCOUNT_HISTORY_INFO, 'order_id='.$oID, 'SSL'));
	    $smarty->assign('ORDER_DATE', xtc_date_long($check_status['date_purchased']));
	    $smarty->assign('NOTIFY_COMMENTS', $notify_comments);
	    $smarty->assign('ORDER_STATUS', $orders_status_array[$status]);

		$smarty->caching = false;
		require_once(DIR_FS_INC.'cseo_get_mail_body.inc.php');
		$html_mail = $smarty->fetch('html:pdf_mail');
		$html_mail .= $signatur_html;
		$txt_mail = $smarty->fetch('txt:pdf_mail');
		$txt_mail .= $signatur_text;
		require_once(DIR_FS_INC.'cseo_get_mail_data.inc.php');
		$mail_data = cseo_get_mail_data('pdf_mail');

        $email_pdf_bill_subject = str_replace('{$date}', xtc_date_long($check_status['date_purchased']), $mail_data['EMAIL_SUBJECT']);
        $email_pdf_bill_subject = str_replace('{$renr}', $_POST['oID'], $email_pdf_bill_subject);
		$email_pdf_bill_name = str_replace('{$store_name}', STORE_NAME, $mail_data['EMAIL_ADDRESS_NAME']);

		$pdf_pfad = cseo_get_pdf($_POST['oID'], false, false, false, true);
		$pdf_name = cseo_get_pdf($_POST['oID'], false, false, true);

		xtc_php_mail( $mail_data['EMAIL_ADDRESS'],                           //  $from_email_address,
             $email_pdf_bill_name,                                     //  $from_email_name,
             $check_status['customers_email_address'],               //  $to_email_address,
             $check_status['customers_name'],                        //  $to_name,
             '',                                                     //  $forwarding_to,
             $mail_data['EMAIL_REPLAY_ADDRESS'],
			 $mail_data['EMAIL_REPLAY_ADDRESS_NAME'],                       //  $reply_address_name,
             $pdf_pfad,                                               //  $path_to_attachement,
             $pdf_name,                                 			//  $name_of_attachment,
             $email_pdf_bill_subject,                                  //  $email_subject,
             $html_mail,                                             //  $message_body_html,
             $txt_mail );                                            //  $message_body_plain

		xtc_db_query("UPDATE orders_pdf SET notified_date = NOW(), customer_notified = '1' WHERE order_id = '".$_POST['oID']."'");
      	$_SESSION['msg']['sm'] = '<div class="success_msg">Die PDF Rechnung wurde als Email verschickt.</div>';
      	if($_GET['action'] == 'update_box') {
      		unset($_GET['pdf_email']);
      		unset($_GET['update_box']);
      		xtc_redirect(FILENAME_ORDERS.'?page='.$_GET['page'].'&oID='.$_GET['oID']);
      	} else {
      		xtc_redirect(xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array ('pdf_email'))).'#pdf');
      	}
	}
}

$lang_query = xtc_db_query("select languages_id from " . TABLE_LANGUAGES . " where directory = '" . $order->info['language'] . "'");
$lang = xtc_db_fetch_array($lang_query);
$lang = $lang['languages_id'];

if(!isset($lang))
	$lang = $_SESSION['languages_id'];
$orders_statuses = array ();
$orders_status_array = array ();
$orders_status_query = xtc_db_query("select orders_status_id, orders_status_name from ".TABLE_ORDERS_STATUS." where language_id = '".$lang."'");
while ($orders_status = xtc_db_fetch_array($orders_status_query)) {
	$orders_statuses[] = array ('id' => $orders_status['orders_status_id'], 'text' => $orders_status['orders_status_name']);
	$orders_status_array[$orders_status['orders_status_id']] = $orders_status['orders_status_name'];
}
switch($_GET['action']) {

		
	case 'multistatus' :
	require_once('create_pdf_multi.php');
	require_once('pdf/PDFMerger.php');
	require_once(DIR_FS_INC.'cseo_get_pdf.inc.php');
	
	//Hier die per multistatus angehakten felder auswerten
	$process_genpdfmail = 0;
	$process_genpdf = 0;
	$process_downloadpdfmerge = 0;

	if($_POST['pdf_rechnung_senden']=="on") 	$process_genpdfmail = 1;
	if($_POST['multistatus_genpdf']=="on") 		$process_genpdf = 1;
	if($_POST['multistatus_mergepdf']=="on") 	$process_downloadpdfmerge = 1;
	
	$box=$_POST['multistatus_ids'];
	
	$mypdffiles = array();
	$myerrorlog;
	$mysuccesslog;
	$tmpids = "";

		while (list ($key,$val) = @each ($box)) {

			$tmpids .= $val.'-';
		
			//PDF Rechnung generieren
			if ($process_genpdf) {
				//generate pdf for this specific order
				$testd = cseo_get_pdf($val, false, false, true);
				
				if (empty($testd) || PDF_RECHNUNG_OID == 'true') {
					//Rechnungen generieren
					$renrnext = cseo_get_pdf_nr($val, false, true);

					custom_multistatusGenPDF($val,"rechnung",$renrnext);
					$mysuccesslog = $mysuccesslog. "Rechnung für Bestellung " . $val . " wurde erzeugt.";

						if($process_genpdfmail) {
						//Wenn E-Mail angehakt
							$oID = $val;
							// echo $oID.'<br />';
							if (PDF_RECHNUNG_OID == 'true') {
								$pdf_re_id = $oID;
							} else {
								$pdf_re_id = $renrnext;
							}
							$check_status = xtc_db_fetch_array(xtc_db_query("SELECT
																	o.customers_name, o.customers_email_address, o.orders_status, o.date_purchased
																FROM
																	orders o, orders_pdf op
																WHERE
																	o.orders_id = '".(int)$oID."'"));

							$smarty->assign('language', $_SESSION['language']);
							$smarty->caching = false;

							$smarty->assign('tpl_path', 'templates/'.CURRENT_TEMPLATE.'/');
							$smarty->assign('logo_path', HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');

							$smarty->assign('NAME', $check_status['customers_name']);
							$smarty->assign('ORDER_NR', cseo_get_pdf_nr($oID, true));
							$smarty->assign('ORDER_LINK', xtc_catalog_href_link(FILENAME_CATALOG_ACCOUNT_HISTORY_INFO, 'order_id='.$oID, 'SSL'));
							$smarty->assign('ORDER_DATE', xtc_date_long($check_status['date_purchased']));
							$smarty->assign('NOTIFY_COMMENTS', $notify_comments);
							$smarty->assign('ORDER_STATUS', $orders_status_array[$status]);

							$smarty->caching = false;
							require_once(DIR_FS_INC.'cseo_get_mail_body.inc.php');
							$html_mail = $smarty->fetch('html:pdf_mail');
							$html_mail .= $signatur_html;
							$txt_mail = $smarty->fetch('txt:pdf_mail');
							$txt_mail .= $signatur_text;
							require_once(DIR_FS_INC.'cseo_get_mail_data.inc.php');
							$mail_data = cseo_get_mail_data('pdf_mail');

							$email_pdf_bill_subject = str_replace('{$date}', xtc_date_long($check_status['date_purchased']), $mail_data['EMAIL_SUBJECT']);
							$email_pdf_bill_subject = str_replace('{$renr}', $pdf_re_id, $email_pdf_bill_subject);
							$email_pdf_bill_name = str_replace('{$store_name}', STORE_NAME, $mail_data['EMAIL_ADDRESS_NAME']);

							$pdf_pfad = cseo_get_pdf($oID, false, false, false, true);
							$pdf_name = cseo_get_pdf($oID, false, false, true);

							xtc_php_mail( $mail_data['EMAIL_ADDRESS'],
								 $email_pdf_bill_name,
								 $check_status['customers_email_address'],
								 $check_status['customers_name'],
								 '',
								 $mail_data['EMAIL_REPLAY_ADDRESS'],
								 $mail_data['EMAIL_REPLAY_ADDRESS_NAME'],
								 $pdf_pfad,
								 $pdf_name,
								 $email_pdf_bill_subject,
								 $html_mail,
								 $txt_mail);

							xtc_db_query("UPDATE orders_pdf SET notified_date = NOW(), customer_notified = '1' WHERE order_id = '".$oID."'");
							// $_SESSION['msg']['sm'] = '<div class="success_msg">Die PDF Rechnung wurde als Email verschickt.</div>';
							$mysuccesslog = $mysuccesslog . ' / E-Mail für Bestellung ' . $val . ' wurde erzeugt.';
						}
						$mysuccesslog .= '<br />';
					} else {
						$myerrorlog = $myerrorlog . 'Rechnung für Bestellung ' . $val . ' nicht erzeugt da schon vorhanden<br/>';
					}
				
				}
			
		//PDF gesammelt als Download
			if ($process_downloadpdfmerge) {
				//download the pdf files for the marked orders
				$myre = 'pdf_rechnungen/'.cseo_get_pdf($val, false, false, true);
				array_push($mypdffiles, $myre);
				
				//$mypdffiles
			}
		}

	if ($process_downloadpdfmerge==0) {
		unset($_GET['action']);
	} else {
	
	$pdfmerger = new PDFMerger;
	foreach($mypdffiles as $curpdf) {
  		$pdfmerger->addPDF($curpdf,'all');
	}
		$pdfmerger->merge('download', 'outputmerge.pdf');
	}	
	
	break;



	case 'change_status':
		include('includes/modules/order_change_status.php');

		xtc_redirect(xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array( 'change_status_oID', 'do_status_change', 'oID', 'action', 'delete1', 'delete2', 'delete3'))));
	break;

	case 'send' :
		include('includes/modules/order_send.php');

		xtc_redirect(xtc_href_link(FILENAME_ORDERS, 'oID='.$_GET['oID']));

	case 'update_order' :
		if(isset($_GET['del_id']) && $_GET['del_id'] !='') {
			xtc_db_query("DELETE FROM orders_status_history WHERE orders_status_history_id = '".intval($_GET['del_id'])."' ");
			$messageStack->add_session(SUCCESS_HISTORY_DELETE, 'success');
		} else
			include('includes/modules/order_update_order.php');

		xtc_redirect(xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array ('action','del_id')).'action=edit#comment'));
		break;

	case 'deleteconfirm' :
		include('includes/modules/order_deleteconfirm.php');

		xtc_redirect(xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array ('oID', 'action'))));
		break;

	case 'afterbuy_send' :
		$oID = xtc_db_prepare_input($_GET['oID']);
		require_once (DIR_FS_CATALOG.'includes/classes/afterbuy.php');
		$aBUY = new xtc_afterbuy_functions($oID);
		if ($aBUY->order_send())
			$aBUY->process_order();

		break;
}

require (DIR_WS_INCLUDES.'header.php');

$order = new order($_GET['oID']);

?>
<script type="text/javascript">
	function checkall() {
	var field = document.multistatusform.multistatus_ids;
	for (i = 0; i < field.length; i++)
		field[i].checked = true ;
	}
</script>

<table class="outerTable" cellspacing="0" cellpadding="0">
  <tr>
    <td  class="boxCenter" width="100%" valign="top">
	<table border="0" width="100%" cellspacing="0" cellpadding="2">
<?php
if (($_GET['action'] == 'edit') && ($order_exists)) {
?>
      <tr>
      <td width="100%">
		<table class="table_pageHeading" border="0" width="100%" cellspacing="0" cellpadding="0">
		  <tr>
		    <td class="pageHeading"><?php echo HEADING_TITLE . ' Nr : ' . $oID . ' - ' . $order->info['date_purchased'] ; ?></td>
		  </tr>
		</table>
		 <?php echo '<a class="button" href="' . xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array('action'))) . '">' . BUTTON_BACK . '</a>'; ?>
		   <a class="button" href="<?php echo xtc_href_link(FILENAME_ORDERS_EDIT, 'oID='.$_GET['oID'].'&cID=' . $order->customer['ID']);?>"><?php echo BUTTON_EDIT ?></a>
 	  </td>
   	  </tr>
      <tr>
      	<td>
        	<div class="left">
            	<table class="subTable" cellspacing="0" cellpadding="4">
					<tr>
						<th colspan="2" class="subTable_head"><?php echo TEXT_ORDER .' '. $oID; ?></th>
					</tr>
					<tr>
						<td><?php echo ENTRY_DATE_PURCHASED; ?></td>
						<td><?php echo $order->info['date_purchased']; ?></td>
					</tr>
					<tr>
						<td><?php echo TEXT_SATUS; ?></td>
						<td>
							<?php
								$last_status = xtc_db_fetch_array(xtc_db_query("SELECT orders_status_id, date_added FROM ".TABLE_ORDERS_STATUS_HISTORY." WHERE orders_id = '".xtc_db_input($oID)."' ORDER BY date_added DESC LIMIT 1"));
								echo $orders_status_array[$last_status['orders_status_id']];
							?>
						</td>
					</tr>
				</table>
            </div>

            <div class="right">
            	<table class="subTable" cellspacing="0" cellpadding="4" width="100%">
                    <tr>
                        <th colspan="2" class="subTable_head">
                            <?php echo TEXT_CUSTOMERS_INFO; ?> <?php if($order->customer['cID']!='') echo ' - '.$order->customer['cID']; ?>
                        </th>
                    </tr>
                    <tr>
                        <td><?php echo TEXT_CUSTOMERS_NAME; ?></td>
                        <td><a href="<?php echo xtc_href_link('customers.php?page=1&cID='.$order->customer[ID].'&action=edit'); ?>"><?php echo $order->customer['name']; ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo ENTRY_EMAIL_ADDRESS; ?></td>
                        <td><a href="mailto:<?php echo $order->customer['email_address']; ?>"><?php echo $order->customer['email_address']; ?></a></td>
                    </tr>
                    <tr>
                    	<td><?php echo ENTRY_TELEPHONE; ?></td>
                		<td><?php echo $order->customer['telephone']; ?></td>
                    </tr>
                    <?php if($order->customer['vat_id'] !='') { ?>
                    <tr>
                    	<td class="main"><?php echo ENTRY_CUSTOMERS_VAT_ID; ?></td>
                		<td class="main"><?php echo $order->customer['vat_id']; ?></td>
                    </tr>
                    <?php } ?>
                    <tr>
                    	<td><?php echo TEXT_CUSTOMERS_STATUS; ?></td>
                        <td><?php echo $order->info['status_name']; ?></td>
                    </tr>
                    <tr>
                    	<td><?php echo TEXT_ORDER_IP; ?></td>
                        <td><?php echo $order->customer['cIP']; ?></td>
                    </tr>
					<tr>
						<td>
							<?php echo CUSTOMERS_MEMO; ?>
						</td>
						<td>
							<?php
					            $memo_count = xtc_db_fetch_array(xtc_db_query("SELECT count(*) as count FROM ".TABLE_CUSTOMERS_MEMO." where customers_id='".$order->customer['ID']."'"));
					        	echo $memo_count['count']; ?>  <a style="cursor:pointer" onclick="javascript:window.open('<?php echo xtc_href_link(FILENAME_POPUP_MEMO,'ID='.$order->customer['ID']); ?>', 'popup', 'scrollbars=yes, width=500, height=500')">(<?php echo DISPLAY_MEMOS; ?>)
						</td>
					</tr>
                </table>
            </div>
        	<br style="clear:both" />
        </td>
      </tr>

      <tr>
      	<td>
        	<div class="left">
            	<table class="subTable" cellspacing="0" cellpadding="4">
	            	<tr>
	                	<th class="subTable_head"><?php echo ENTRY_BILLING_ADDRESS; ?></th>
	                </tr>
	                <tr>
	                	<td><?php echo xtc_address_format($order->billing['format_id'], $order->billing, 1, '', '<br />'); ?></td>
	                </tr>
	            </table>
            </div>

            <div class="right">
            	<table class="subTable" cellspacing="0" cellpadding="4">
                    <tr>
                        <th class="subTable_head"><?php echo ENTRY_SHIPPING_ADDRESS; ?></th>
                    </tr>

                    <tr>
                        <td><?php echo xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br />'); ?></td>
                    </tr>
                </table>
            </div>
        	<br style="clear:both" />
        </td>
      </tr>

      <tr>
      	<td>
        	<div class="left">
            	<table class="subTable" cellspacing="0" cellpadding="4">
	            	<tr>
	                	<th class="subTable_head" colspan="2"><?php echo ENTRY_PAYMENT_METHOD; ?></th>
	                </tr>
	                <tr>
	                	<td>
                        	<?php
							include(DIR_FS_LANGUAGES.$_SESSION['language'].'/modules/payment/'.$order->info['payment_method'].'.php');
							echo constant(strtoupper('MODULE_PAYMENT_'.$order->info['payment_method'].'_TEXT_TITLE'));
							?><br />
                        </td>
	                </tr>
                    <?php
						  $easydebit_query = xtc_db_query("select edebit_transaction_id, edebit_gutid from orders where orders_id = '" . (int)$oID . "'");
						  $easydebit = xtc_db_fetch_array($easydebit_query);
						  if ($easydebit['edebit_transaction_id'] != '') {
							?>
							<tr>
							<td><b><?php echo 'EasyDebit Transaction ID: ' ?></b></td>
							<td><?php echo $easydebit['edebit_transaction_id']; ?></td>
						  </tr>
						  <tr>
							<td><b><?php echo 'EasyDebit GuTID: '; ?></b></td>
							<td><?php echo $easydebit['edebit_gutid']; ?></td>
						  </tr>
				<?php }
					if ((($order->info['cc_type']) || ($order->info['cc_owner']) || ($order->info['cc_number']))) {
				?>
						  <tr>
							<td colspan="2"><?php echo xtc_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
						  </tr>
						  <tr>
							<td><?php echo ENTRY_CREDIT_CARD_TYPE; ?></td>
							<td><?php echo $order->info['cc_type']; ?></td>
						  </tr>
						  <tr>
							<td><?php echo ENTRY_CREDIT_CARD_OWNER; ?></td>
							<td><?php echo $order->info['cc_owner']; ?></td>
						  </tr>
						<?php
							if ($order->info['cc_number'] != '0000000000000000') {
								if (strtolower(CC_ENC) == 'true') {
									$cipher_data = $order->info['cc_number'];
									$order->info['cc_number'] = changedataout($cipher_data, CC_KEYCHAIN);
								}
							}
						?>
						  <tr>
							<td><?php echo ENTRY_CREDIT_CARD_NUMBER; ?></td>
							<td><?php echo $order->info['cc_number']; ?></td>
						  </tr>
						  <tr>
						  <td><?php echo ENTRY_CREDIT_CARD_CVV; ?></td>
						  <td><?php echo $order->info['cc_cvv']; ?></td>
						  </tr>
						  <tr>
							<td><?php echo ENTRY_CREDIT_CARD_EXPIRES; ?></td>
							<td><?php echo $order->info['cc_expires']; ?></td>
						  </tr>
				<?php

					}

					if (MODULE_PAYMENT_SOFORTUEBERWEISUNG_DIRECT_STATUS == 'True' ) {
					  $sofortueberweisung_check_query = xtc_db_query("select sofortueberweisung_transaktions_details from " . TABLE_ORDERS . " where orders_id = '" . xtc_db_input($_GET['oID']). "'");
					  if ($sofortueberweisung_check = xtc_db_fetch_array($sofortueberweisung_check_query)) {
						if (!empty($sofortueberweisung_check['sofortueberweisung_transaktions_details'])) {
						  $hidden_trigger_post_vars = unserialize($sofortueberweisung_check['sofortueberweisung_transaktions_details']);
				?>
					  <tr>
						<td valign="top"><table border="0" cellspacing="0" cellpadding="2">
						  <tr>
							<td><table width="100%" border="0" cellspacing="0" cellpadding="2">
							  <tr>
								<td valign="top">TranscactionID:</td>
								<td valign="top"><?php echo (!empty($hidden_trigger_post_vars['post']['transaction']) ? $hidden_trigger_post_vars['post']['transaction'] : $hidden_trigger_post_vars['get']['transaction']); ?></td>
							  </tr>
							  <tr>
								<td valign="top">Betrag:</td>
								<td valign="top"><?php echo (!empty($hidden_trigger_post_vars['post']['amount']) ? $hidden_trigger_post_vars['post']['amount'] . ' ' . $hidden_trigger_post_vars['post']['currency_id'] : $hidden_trigger_post_vars['get']['amount'] . ' ' . $hidden_trigger_post_vars['get']['currency_id']); ?></td>
							  </tr>
							  <tr>
								<td valign="top">Verwendungszweck 1:</td>
								<td valign="top"><?php echo $hidden_trigger_post_vars['post']['reason_1'] ; ?></td>
							  </tr>
							  <tr>
								<td valign="top">Verwendungszweck 2:</td>
								<td valign="top"><?php echo $hidden_trigger_post_vars['post']['reason_2'] ; ?></td>
							  </tr>
							  <tr>
								<td valign="top">Sicherheits-Kriterien erfР вЂњРЎВllt:</td>
								<td valign="top"><?php echo  ($hidden_trigger_post_vars['post']['security_criteria'] == 1 ? 'Ja' : 'Nein') ; ?></td>
							  </tr>
							</table></td>
						  </tr>
							  <tr>
								<td><table border="0" cellspacing="0" cellpadding="2">
								  <tr>
									<td colspan="2" valign="top"><b>Absender der Р вЂњРЎС™berweisung:</b></td>
								  </tr>
								  <tr>
									<td valign="top">Inhaber:</td>
									<td><?php echo $hidden_trigger_post_vars['post']['sender_holder'] ; ?></td>
								  </tr>
								  <tr>
									<td valign="top">Konto:</td>
									<td><?php echo $hidden_trigger_post_vars['post']['sender_account_number'] ; ?></td>
								  </tr>
								  <tr>
									<td valign="top">BLZ:</td>
									<td><?php echo $hidden_trigger_post_vars['post']['sender_bank_code'] ; ?></td>
								  </tr>
								  <tr>
									<td valign="top">Bank:</td>
									<td><?php echo $hidden_trigger_post_vars['post']['sender_bank_name'] ; ?></td>
								  </tr>
								  <tr>
									<td valign="top">BIC:</td>
									<td><?php echo $hidden_trigger_post_vars['post']['sender_bank_bic'] ; ?></td>
								  </tr>
								  <tr>
									<td valign="top">IBAN:</td>
									<td><?php echo $hidden_trigger_post_vars['post']['sender_iban'] ; ?></td>
								  </tr>
								  <tr>
									<td valign="top">Land:</td>
									<td><?php echo $hidden_trigger_post_vars['post']['sender_country_id'] ; ?></td>
								  </tr>
								</table></td>
								<td>&nbsp;&nbsp;&nbsp;</td>
								<td><table border="0" cellspacing="0" cellpadding="2">
									<tr>
									  <td colspan="2" valign="top"><b>Empf&auml;nger der &Uuml;berweisung:</b></td>
									</tr>
									<tr>
									  <td valign="top">Inhaber:</td>
									  <td><?php echo $hidden_trigger_post_vars['post']['recipient_holder'] ; ?></td>
									</tr>
									<tr>
									  <td valign="top">Konto:</td>
									  <td><?php echo $hidden_trigger_post_vars['post']['recipient_account_number'] ; ?></td>
									</tr>
									<tr>
									  <td valign="top">BLZ:</td>
									  <td><?php echo $hidden_trigger_post_vars['post']['recipient_bank_code'] ; ?></td>
									</tr>
									<tr>
									  <td valign="top">Bank:</td>
									  <td><?php echo $hidden_trigger_post_vars['post']['recipient_bank_name'] ; ?></td>
									</tr>
									<tr>
									  <td valign="top">BIC:</td>
									  <td><?php echo $hidden_trigger_post_vars['post']['recipient_bank_bic'] ; ?></td>
									</tr>
									<tr>
									  <td valign="top">IBAN:</td>
									  <td><?php echo $hidden_trigger_post_vars['post']['recipient_iban'] ; ?></td>
									</tr>
									<tr>
									  <td valign="top">Land:</td>
									  <td><?php echo $hidden_trigger_post_vars['post']['recipient_country_id'] ; ?></td>
									</tr>
								</table></td>
							  </tr>

							</table></td>
						  </tr>

				<?php
						}
					  }
					}

					if ($order->info['payment_method']=='paypal_ipn' or $order->info['payment_method']=='paypal_directpayment' or $order->info['payment_method']=='paypal' or $order->info['payment_method']=='paypalexpress') {
						require('../includes/classes/paypal_checkout.php');
						require('includes/classes/class.paypal.php');
						$paypal = new paypal_admin();
						$paypal->admin_notification((int)$_GET['oID']);
					}

					// begin modification for banktransfer
					$banktransfer_query = xtc_db_query("select banktransfer_prz, banktransfer_status, banktransfer_owner, banktransfer_number, banktransfer_bankname, banktransfer_blz, banktransfer_fax from banktransfer where orders_id = '".xtc_db_input($_GET['oID'])."'");
					$banktransfer = xtc_db_fetch_array($banktransfer_query);
					if (($banktransfer['banktransfer_bankname']) || ($banktransfer['banktransfer_blz']) || ($banktransfer['banktransfer_number'])) {
				?>
						  <tr>
							<td colspan="2"><?php echo xtc_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
						  </tr>
						  <tr>
							<td><?php echo TEXT_BANK_NAME; ?></td>
							<td><?php echo $banktransfer['banktransfer_bankname']; ?></td>
						  </tr>
						  <tr>
							<td><?php echo TEXT_BANK_BLZ; ?></td>
							<td><?php echo $banktransfer['banktransfer_blz']; ?></td>
						  </tr>
						  <tr>
							<td><?php echo TEXT_BANK_NUMBER; ?></td>
							<td><?php echo $banktransfer['banktransfer_number']; ?></td>
						  </tr>
						  <tr>
							<td><?php echo TEXT_BANK_OWNER; ?></td>
							<td><?php echo $banktransfer['banktransfer_owner']; ?></td>
						  </tr>
						<?php

						if ($banktransfer['banktransfer_status'] == 0) {
						?>
						  <tr>
							<td><?php echo TEXT_BANK_STATUS; ?></td>
							<td><?php echo "OK"; ?></td>
						  </tr>
						<?php

						} else {
						?>
						  <tr>
							<td><?php echo TEXT_BANK_STATUS; ?></td>
							<td><?php echo $banktransfer['banktransfer_status']; ?></td>
						  </tr>
						<?php

							switch ($banktransfer['banktransfer_status']) {
								case 1 :
									$error_val = TEXT_BANK_ERROR_1;
									break;
								case 2 :
									$error_val = TEXT_BANK_ERROR_2;
									break;
								case 3 :
									$error_val = TEXT_BANK_ERROR_3;
									break;
								case 4 :
									$error_val = TEXT_BANK_ERROR_4;
									break;
								case 5 :
									$error_val = TEXT_BANK_ERROR_5;
									break;
								case 8 :
									$error_val = TEXT_BANK_ERROR_8;
									break;
								case 9 :
									$error_val = TEXT_BANK_ERROR_9;
									break;
							}
						?>
						  <tr>
							<td><?php echo TEXT_BANK_ERRORCODE; ?></td>
							<td><?php echo $error_val; ?></td>
						  </tr>
						  <tr>
							<td><?php echo TEXT_BANK_PRZ; ?></td>
							<td><?php echo $banktransfer['banktransfer_prz']; ?></td>
						  </tr>
						<?php

								}
							}
							if ($banktransfer['banktransfer_fax']) {
						?>
								  <tr>
									<td><?php echo TEXT_BANK_FAX; ?></td>
									<td><?php echo $banktransfer['banktransfer_fax']; ?></td>
								  </tr>
						<?php
							}
						?>
					<tr>
						<td class="main"><b><?php echo ENTRY_LANGUAGE; ?></b>&nbsp;<?php echo $order->info['language']; ?></td>
					</tr>
				</table>
            </div>

            <div class="right">
            	<table class="subTable" cellspacing="0" cellpadding="4">
                    <tr>
                        <th class="subTable_head"><?php echo ENTRY_SHIPPING_INFO; ?></th>
                    </tr>
                    <tr>
                        <td>
							<?php
								if($order->info['shipping_method'] !='') {
									echo $order->info['shipping_method']; ?> = <b><?php echo $order->info['shipping_cost'] .' ' . $order->info['currency'] ?></b>
							<?php } else {
								echo '<em>Es liegen keine Versandinformationen vor.</em>';
							}?>
						</td>
                    </tr>
                </table>
            </div>
        	<br style="clear:both" />
			<?php
				$download_query = xtc_db_query("SELECT orders_products_filename, download_maxdays, download_count, download_ip, download_time, orders_products_download_id FROM orders_products_download WHERE orders_id = '". $oID ."' ");
				if(xtc_db_num_rows($download_query)) {

					function formatBytes($bytes, $precision = 2) {
					    $units = array('B', 'KB', 'MB', 'GB', 'TB');
					    $bytes = max($bytes, 0);
					    $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
					    $pow = min($pow, count($units) - 1);
					    $bytes /= pow(1024, $pow);
					    return round($bytes, $precision) . ' ' . $units[$pow];
					}
			?>
			<tr>
				<td>
					<table class="subTable" cellspacing="0" cellpadding="4" width="100%">
						<tr>
							<th class="subTable_head" width="100%">
								Downloads
							</th>
						</tr>
						<tr>
							<td>
								<?php echo xtc_draw_form('downloads', FILENAME_ORDERS, xtc_get_all_get_params(array('action')) . 'action=update_order&download','post'); ?>
								<table border="0" width="100%" cellspacing="0" cellpadding="2" class="dataTable">
									<tr class="dataTableHeadingRow">
										<td class="dataTableHeadingContent"><?php echo NAME_OF_FILE; ?></td>
										<td class="dataTableHeadingContent"><?php echo VALID_THROUGH; ?></td>
										<td class="dataTableHeadingContent" align="center"><?php echo OPEN_DOWNLOADS; ?></td>
										<td class="dataTableHeadingContent"><?php echo LAST_DOWNLOAD; ?></td>
										<td class="dataTableHeadingContent"><?php echo DOWNLOAD_IP; ?></td>
										<td class="dataTableHeadingContent"><?php echo REACTIVATE; ?></td>
									</tr>
									<?php
									while($download = xtc_db_fetch_array($download_query, true)) {
									?>
									<tr>
										<td>
											<?php
												echo $download['orders_products_filename'];
												$size = filesize(DIR_FS_CATALOG . 'download/' . $download['orders_products_filename']);
												echo ' | ' . formatBytes($size);
											?>
										</td>
										<td>
											<?php
												$dt = $order->info['date_purchased'];
												$date = date("d.m.Y", mktime(substr($dt,11,2),substr($dt,14,2),0,substr($dt,5,2),substr($dt,8,2)+$download['download_maxdays'],substr($dt,0,4)));
												echo $date;
											?>
										</td>
										<td align="center">
											<?php echo $download['download_count'];	?>
										</td>
										<td>
											<?php echo ($download['download_time'] != '0000-00-00 00:00:00')?$download['download_time']:OPEN_DOWNLOAD;?>
										</td>
										<td align="center">
											<?php echo ($download['download_ip']!='')?$download['download_ip']:'-';?>
										</td>
										<td>
											<?php
											 	if($download['download_count'] <= 0)
												echo xtc_draw_input_field('download['.$download['orders_products_download_id'].']', '0', 'size=3') . ' <input type="image" src="images/icons/update.gif" style="position:relative;top:4px" />'; ?>
										</td>
									</tr>
									<?php } ?>
								</table>
								</form>
							</td>
						</tr>
					</table>
				</td>
			</tr>
	<?php } ?>
      <tr>
      <td>
      	<table class="subTable" cellspacing="0" cellpadding="4" width="100%">
	        <tr>
	            <th class="subTable_head" width="100%">
	                <?php echo PRODUCTS; ?>
	            </th>
	        </tr>
	        <tr>
	            <td>
	                <table border="0" width="100%" cellspacing="0" cellpadding="2" class="dataTable">
	                  <tr class="dataTableHeadingRow">
	                    <td class="dataTableHeadingContent" colspan="2"><?php echo TABLE_HEADING_PRODUCTS; ?></td>
	                    <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_PRODUCTS_MODEL; ?></td>
	                    <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_PRICE_EXCLUDING_TAX; ?></td>
							<?php
	                            if ($order->products[0]['allow_tax'] == 1) {
	                        ?>
	                    <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_TAX; ?></td>
	                    <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_PRICE_INCLUDING_TAX; ?></td>
						<?php
	                        }
	                    ?>
	                    <td class="dataTableHeadingContent" align="right"><?php
							echo TABLE_HEADING_TOTAL_INCLUDING_TAX;
							if ($order->products[$i]['allow_tax'] == 1) {
								echo ' (exkl.)';
							}
						?></td>
	                  </tr>
	                    <?php
	                        for ($i = 0, $n = sizeof($order->products); $i < $n; $i ++) {
	                            echo '<tr class="'.(($i%2==0)?'dataTableRow':'').'">'."\n".'
	                                    <td valign="top" align="right">'.$order->products[$i]['qty'].'&nbsp;x&nbsp;</td>'."\n".'
	                                    <td valign="top"><b>'.$order->products[$i]['name'].'</b>';
	                            if (sizeof($order->products[$i]['attributes']) > 0) {
	                                for ($j = 0, $k = sizeof($order->products[$i]['attributes']); $j < $k; $j ++) {
	                                    echo '<br /><nobr>&nbsp;<i> - '.$order->products[$i]['attributes'][$j]['option'].': '.$order->products[$i]['attributes'][$j]['value'];
	                                }
	                                echo '</i></nobr>';
	                            }
	                            echo '</td>'."\n".'<td valign="middle">';

	                            if ($order->products[$i]['model'] != '') {
	                                echo $order->products[$i]['model'];
	                            } else {
	                                echo '<br />';
	                            }

	                            // attribute models
	                            if (sizeof($order->products[$i]['attributes']) > 0) {
	                                for ($j = 0, $k = sizeof($order->products[$i]['attributes']); $j < $k; $j ++) {

	                                    $model = xtc_get_attributes_model($order->products[$i]['id'], $order->products[$i]['attributes'][$j]['value'],$order->products[$i]['attributes'][$j]['option']);
	                                    if ($model != '') {
	                                        echo $model.'<br />';
	                                    } else {
	                                        echo '<br />';
	                                    }
	                                }
	                            }

	                            echo '&nbsp;</td>'."\n".'
	                                <td align="right" valign="top">'.format_price($order->products[$i]['final_price'] / $order->products[$i]['qty'], 1, $order->info['currency'], $order->products[$i]['allow_tax'], $order->products[$i]['tax']).'</td>'."\n";

	                            if ($order->products[$i]['allow_tax'] == 1) {
	                                echo '<td align="right" valign="top">';
	                                echo xtc_display_tax_value($order->products[$i]['tax']).'%';
	                                echo '</td>'."\n";
	                                echo '<td align="right" valign="top"><b>';

	                                echo format_price($order->products[$i]['final_price'] / $order->products[$i]['qty'], 1, $order->info['currency'], 0, 0);

	                                echo '</b></td>'."\n";
	                            }
	                            echo '<td align="right" valign="top"><b>'.format_price(($order->products[$i]['final_price']), 1, $order->info['currency'], 0, 0).'</b></td>'."\n";
	                            echo '</tr>'."\n";
	                        }
	                    ?>
	                </table>
	            </td>
	        </tr>
	    </table>
    </td>
      </tr>

      <tr>
      	<td>
			<div class="left">
				<?php echo xtc_draw_form('status', FILENAME_ORDERS, xtc_get_all_get_params(array('action')) . 'action=update_order'); ?>
        		<table class="subTable" cellspacing="0" cellpadding="4">
                <tr>
                    <th class="subTable_head" colspan="2">
                        <?php echo TABLE_HEADING_COMMENTS; ?><a name="comment" id="comment">&nbsp;</a>
                    </th>
                </tr>
                <tr>
                    <td colspan="2">
                		<?php echo ENTRY_STATUS; ?> <?php echo xtc_draw_pull_down_menu('status', $orders_statuses, $order->info['orders_status']); ?>

                    </td>
				</tr>
					<?php
					/* magnalister v2.0.0 */
					if (function_exists('magnaExecute')) magnaExecute('magnaRenderOrderStatusSync', array(), array('order_details.php'));
					/* END magnalister */
					?>
				<tr>
                	<td colspan="2">
                    	<?php echo xtc_draw_textarea_field('comments', 'soft', '60', '5', '', 'style="width:99.5%"'); ?>
                    </td>
                </tr>
                <tr>
                	<td>
                    	<label for="notify"><?php echo ENTRY_NOTIFY_CUSTOMER; ?> </label>
                    	<input type="checkbox" name="notify" value="on" id="notify" />
                    </td>
                	<td>
                    	<label for="notify_comments"><?php echo ENTRY_NOTIFY_COMMENTS; ?></label>
                    	<input type="checkbox" name="notify_comments" value="on" id="notify_comments" />
                    </td>
                </tr>
                <tr>
                	<td align="left" colspan="2">
                    	<?php include('amazon_storno.php'); ?>
                    </td>
                </tr>

                <tr>
                	<td align="right" colspan="2">
                    	<input type="submit" class="button" value="<?php echo BUTTON_SEND; ?>">
                    </td>
                </tr>

                <tr>
                	<td colspan="2">
                		<table width="100%">
                    	<?php
							$orders_history_query = xtc_db_query("SELECT
																	orders_status_history_id, orders_status_id, date_added, customer_notified, comments
																FROM
																	".TABLE_ORDERS_STATUS_HISTORY."
																WHERE
																	orders_id = '".xtc_db_input($oID)."'
																ORDER BY
																	date_added");
							if (xtc_db_num_rows($orders_history_query)) {
								$i = 1;
								while ($orders_history = xtc_db_fetch_array($orders_history_query)) {
									echo '<tr><td style="position:relative">';
									echo '<span class="history_del_link">
											<a href="'.xtc_href_link(FILENAME_ORDERS, 'action=update_order&del_id='.$orders_history['orders_status_history_id'].'&oID='.$oID).'">
												'.xtc_image('images/icons/document--minus.png', 'Eintrag l&ouml;schen','', '', 'style="position:relative; top:4px; margin-right:3px"').'
											</a>
										  </span>';
									echo xtc_image('images/icons/document.png', '','', '', 'style="position:relative; top:4px; margin-right:3px"');
									echo '<small>'.xtc_datetime_short($orders_history['date_added'], DATE_TIME_FORMATED) . '</small> | ';
									echo  ($orders_history['orders_status_id']!='0') ? '<b>'.$orders_status_array[$orders_history['orders_status_id']].'</b> | ' : '';
									if($orders_history['customer_notified'] == '1') {
										echo '<small>'.CUSTOMER_NOTIFIED.'</small> ' . xtc_image('images/tick.gif', ICON_TICK,'', '', 'style="position:relative; top:4px"').'<br />';
									} else {
										echo '<small'.CUSTOMER_NOT_NOTIFIED.'</small> '.xtc_image('images/icons/minus-circle.png', ICON_TICK,'', '', 'style="position:relative; top:4px"').'<br />';
									}
									echo '</td></tr><tr class="bb"><td>';
									echo($orders_history['comments'] !='') ? '<div class="order_comment">'.nl2br(strip_tags(xtc_db_output($orders_history['comments']))).'</div>' : '';
									echo '</td></tr>';
								$i++;
								}
							} else {
								echo TEXT_NO_ORDER_HISTORY;
							}
						?>
						</table>
                    </td>
                </tr>
            </table></form>
	<!-- Click & Buy -->
				<?php if ($oInfo->payment_method == 'clickandbuy') { ?>
				<h4><?php echo HEADING_CLICKANDBUY_EMS; ?></h4>
				<?php
				
					$qr = xtc_db_query(sprintf("SELECT oce.* FROM orders_clickandbuy oc LEFT JOIN orders_clickandbuy_ems oce ON oc.f_transactionID = oce.`BDRID` WHERE oc.orders_id = %d ORDER BY oce.`datetime` DESC, oce.`action` DESC", $_GET['oID']));
					$ems_events = array();
					while ($qa = xtc_db_fetch_array($qr)) {
					  $ems_events[] = $qa;
					}
				?>
				<?php if ($ems_events): ?>
						  <table border="1" cellspacing="0" cellpadding="5">
							<tr>
							  <td class="smallText" align="center"><b><?php echo TABLE_HEADING_CLICKANDBUY_EMS_TIMESTAMP; ?></b></td>
							  <td class="smallText" align="center"><b><?php echo TABLE_HEADING_CLICKANDBUY_EMS_TYPE; ?></b></td>
							  <td class="smallText" align="center"><b><?php echo TABLE_HEADING_CLICKANDBUY_EMS_ACTION; ?></b></td>
							</tr>
				<?php foreach ($ems_events as $e): ?>
							<tr>
							  <td class="smallText" align="center"><?php echo $e['datetime']; ?></td>
							  <td class="smallText" align="center"><?php echo $e['type']; ?></td>
							  <td class="smallText" align="center"><?php echo $e['action']; ?></td>
							</tr>
				<?php endforeach; ?>
						  </table>
				<?php else: ?>
						  <p><?php echo TEXT_CLICKANDBUY_EMS_NO_EVENTS; ?></p>
				<?php endif; }?>
	<!-- Click & Buy -->			
				<?php
	/* magnalister v1.0.0 */
				if (function_exists('magnaExecute')) echo magnaExecute('magnaRenderOrderDetails', array('oID' => $oID), array('order_details.php'));
	/* END magnalister */
				?>
			</div>
			<div class="right">
				<table class="subTable" cellspacing="0" cellpadding="4" width="100%">
			        <tr>
			            <th class="subTable_head" width="100%">
			                <?php echo TOTAL; ?>
			            </th>
			        </tr>
			        <tr>
			            <td>
			                <table border="0" cellspacing="0" cellpadding="2" width="100%" style="background:#FCF5DD">
								<?php
									for ($i = 0, $n = sizeof($order->totals); $i < $n; $i ++) {
										echo '<tr>'."\n".'
												<td align="right" class="smallText">'.$order->totals[$i]['title'].'</td>'."\n".'
												<td align="right" class="smallText" width="1" nowrap="nowrap">'.$order->totals[$i]['text'].'</td>'."\n".'
											</tr>'."\n";
									}
								?>
					        </table>
			            </td>
			        </tr>
			    </table>
				<?php include('includes/modules/pdf_rechnung.php'); ?>

			</div>
			<br style="clear:both" />
		</td>
      </tr>
      <tr>
        <td colspan="2" align="right">
			<a class="button" href="javascript:void()" onclick="window.open('<?php echo xtc_href_link(FILENAME_PRINT_ORDER,'oID='.$_GET['oID']); ?>', 'popup', 'toolbar=0, width=640, height=600, scrollbars=yes')"><?php echo BUTTON_INVOICE; ?></a> 
			<a class="button" href="javascript:void()" onclick="window.open('<?php echo xtc_href_link(FILENAME_PRINT_PACKINGSLIP,'oID='.$_GET['oID']); ?>', 'popup', 'toolbar=0, width=640, height=600, scrollbars=yes')"><?php echo BUTTON_PACKINGSLIP; ?></a>
			<?php
				if (ACTIVATE_GIFT_SYSTEM == 'true')
					echo '<a class="button" href="'.xtc_href_link(FILENAME_GV_MAIL, xtc_get_all_get_params(array ('cID', 'action')).'cID='.$order->customer['ID']).'">'.BUTTON_SEND_COUPON.'</a>';
			?>
			<?php echo '<a class="button" href="' .xtc_href_link(FILENAME_ORDERS, 'page='.$_GET['page'].'&oID='.$_GET['oID']).'">'.BUTTON_BACK.'</a>';?>
       </td>
      </tr>
	<?php
	} elseif ($_GET['action'] == 'custom_action') {
		include ('orders_actions.php');
	} else {
	
	//only output debug if no other options are selected 	
		if ($process_genpdf) {
			
			if (!empty($mysuccesslog)) {		
			echo('<div class="mysuccesslog"');
					echo("<h1>PDF Rechnungen erfolgreich generiert</h1><br/>");
					echo($mysuccesslog);
					echo("</div>");
			}
					
			if (!empty($myerrorlog)) {
				echo('<div class="myerrorlog"');
				echo("<h1>PDF Rechnungen NICHT erfolgreich generiert</h1><br/>");
				echo ($myerrorlog);
				echo("</div>");
				
			}		
				
		}
	
		include('includes/modules/order_overview.php');
	}
	?>
    </table></td>
  </tr>
</table>
<?php 
require (DIR_WS_INCLUDES.'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
