<?php
/*
#####################################################################################################

Description:	mobile.php Mobile Admin
Version: 			xt:Commerce v3.04 SP2.1
Author: 			Mark Gebur - http://www.untersatz.com

Copyright (c) 2011 Mark Gebur

#####################################################################################################
*/
require_once('includes/configure.php');
require('includes/application_top.php');

require(DIR_FS_INC. 'xtc_get_products.inc.php');
require_once(DIR_FS_INC .'xtc_get_order_data.inc.php');
require_once(DIR_FS_INC .'xtc_get_attributes_model.inc.php');
require_once(DIR_FS_INC .'xtc_not_null.inc.php');
require_once (DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once (DIR_FS_INC.'xtc_php_mail.inc.php');
require_once (DIR_FS_INC.'xtc_add_tax.inc.php');
require_once (DIR_FS_INC.'changedataout.inc.php');
require_once (DIR_FS_INC.'xtc_validate_vatid_status.inc.php');
require (DIR_WS_CLASSES.'order.php');


if ((($_GET['action'] == 'edit') || ($_GET['action'] == 'update_order')) && ($order_exists)) {
	$order = new order($oID);
}

  $lang_query = xtc_db_query("select languages_id from " . TABLE_LANGUAGES . " where directory = '" . $order->info['language'] . "'");
  $lang = xtc_db_fetch_array($lang_query);  
  $lang=$lang['languages_id'];

if (!isset($lang)) $lang=$_SESSION['languages_id'];

	$orders_statuses = array ();
	$orders_status_array = array ();
	$orders_status_query = xtc_db_query("select orders_status_id, orders_status_name from ".TABLE_ORDERS_STATUS." where language_id = '".$lang."'");
while ($orders_status = xtc_db_fetch_array($orders_status_query)) {
	$orders_statuses[] = array ('id' => $orders_status['orders_status_id'], 'text' => $orders_status['orders_status_name']);
	$orders_status_array[$orders_status['orders_status_id']] = $orders_status['orders_status_name'];
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head> 
	<title>Admin</title> 
	<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
	<meta name="viewport" content="width=device-width, minimum-scale=1, maximum-scale=1">

	<link rel="stylesheet" href="http://code.jquery.com/mobile/1.0a4.1/jquery.mobile-1.0a4.1.min.css" />
	<script type="text/javascript" src="http://code.jquery.com/jquery-1.5.2.min.js"></script>
	<script type="text/javascript" src="http://code.jquery.com/mobile/1.0a4.1/jquery.mobile-1.0a4.1.min.js"></script>
</head> 
<body> 

<div data-role="page" data-theme="b">
	<div data-role="header">
		<h1>Shop-Admin</h1>
	</div><!-- /header -->
<?php
if(!isset($_GET['ord']) && $_GET['ord'] == '') {
?>
	<div data-role="content">	
		<div data-role="controlgroup">
		<a href="mobile.php?ord=orders" data-role="button" data-ajax="false">Bestellungen</a>
		<a href="mobile.php?ord=customers" data-role="button" data-ajax="false">Kunden</a>
		<a href="mobile.php?ord=sales" data-role="button" data-ajax="false">Umsatzstatistik</a>
		<a href="mobile.php?ord=whosonline" data-role="button" data-ajax="false">Wer ist Online?</a>
		<a href="../logoff.php" data-role="button" data-ajax="false">Abmelden</a>
		</div>
<?php
} else {
?>
		<div class="ui-bar ui-bar-c">
			<div data-role="controlgroup" data-type="horizontal">
				<a href="mobile.php" data-icon="home" data-role="button" data-inline="true" data-ajax="false">&nbsp;</a>
				<a href="mobile.php?ord=orders" data-icon="grid" data-role="button" data-inline="true" data-ajax="false">Bestellungen</a>
				<a href="mobile.php?ord=customers" data-icon="search" data-role="button" data-inline="true" data-ajax="false">Kunden</a>
				<a href="mobile.php?ord=sales" data-icon="star" data-role="button" data-inline="true" data-ajax="false">Statistik</a>
				<a href="mobile.php?ord=whosonline" data-icon="gear" data-role="button" data-inline="true" data-ajax="false">Online?</a>
				<a href="../logoff.php" data-icon="gear" data-role="button" data-inline="true" data-ajax="false">Abmelden</a>
			</div>
		</div>
<?php
}

if(isset($_GET['ord']) && $_GET['ord'] == 'whosonline') {
	  $xx_mins_ago = (time() - 900);
?>
<div data-role="content">
		<h2>Wer ist Online?</h2>
		<ul data-role="listview" data-inset="true">
					<?php
					  $whos_online_query = xtc_db_query("select customer_id, full_name, ip_address, time_entry, time_last_click, last_page_url, session_id from " . TABLE_WHOS_ONLINE ." order by time_last_click desc");
					  while ($whos_online = xtc_db_fetch_array($whos_online_query)) {
					  		$time_online = (time() - $whos_online['time_entry']);
					?>
								<li>
									<h3><?php echo $whos_online['full_name']; ?></h3>
									<p><strong>ID: <?php echo $whos_online['customer_id']; ?> - IP: <?php echo $whos_online['ip_address']; ?></strong></p>
					
									<p>URL: <?php if (eregi('^(.*)' . xtc_session_name() . '=[a-f,0-9]+[&]*(.*)', $whos_online['last_page_url'], $array)) { echo $array[1] . $array[2]; } else { echo $whos_online['last_page_url']; } ?></p>
									<p class="ui-li-aside"><strong>Online: <?php echo gmdate('H:i:s', $time_online); ?></strong></p>
								</li>
					<?php
					  }
					?>
		</ul>
	</div>
<?php
}

if(isset($_GET['ord']) && $_GET['ord'] == 'orders' && $_GET['oID'] == '') {
?>
	<div data-role="content">	
		<ul data-role="listview" data-split-icon="gear" data-inset="true">
<?php
	if ($_GET['cID']) {
		$cID = xtc_db_prepare_input($_GET['cID']);
		$orders_query_raw = "select o.refferers_id, o.orders_id, o.afterbuy_success, o.afterbuy_id, o.customers_name, o.customers_id, o.payment_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, o.orders_status, s.orders_status_name, ot.text as order_total from ".TABLE_ORDERS." o left join ".TABLE_ORDERS_TOTAL." ot on (o.orders_id = ot.orders_id), ".TABLE_ORDERS_STATUS." s where o.customers_id = '".xtc_db_input($cID)."' and (o.orders_status = s.orders_status_id and s.language_id = '".$_SESSION['languages_id']."' and ot.class = 'ot_total') or (o.orders_status = '0' and ot.class = 'ot_total' and  s.orders_status_id = '1' and s.language_id = '".$_SESSION['languages_id']."') order by date_purchased DESC";
	}
	elseif ($_GET['status']=='0') {
			$orders_query_raw = "select o.refferers_id, o.orders_id, o.afterbuy_success, o.afterbuy_id, o.customers_name, o.payment_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, o.orders_status, ot.text as order_total, o.delivery_postcode from ".TABLE_ORDERS." o left join ".TABLE_ORDERS_TOTAL." ot on (o.orders_id = ot.orders_id) where o.orders_status = '0' and ot.class = 'ot_total' order by o.date_purchased DESC";
	}
	elseif ($_GET['status']) {
			$status = xtc_db_prepare_input($_GET['status']);
			$orders_query_raw = "select o.refferers_id, o.orders_id, o.afterbuy_success, o.afterbuy_id, o.customers_name, o.payment_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, s.orders_status_name, ot.text as order_total, o.delivery_postcode from ".TABLE_ORDERS." o left join ".TABLE_ORDERS_TOTAL." ot on (o.orders_id = ot.orders_id), ".TABLE_ORDERS_STATUS." s where o.orders_status = s.orders_status_id and s.language_id = '".$_SESSION['languages_id']."' and s.orders_status_id = '".xtc_db_input($status)."' and ot.class = 'ot_total' order by o.date_purchased DESC";
	} else {
		$orders_query_raw = "select o.refferers_id, o.orders_id, o.orders_status, o.afterbuy_success, o.afterbuy_id, o.customers_name, o.payment_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, s.orders_status_name, ot.text as order_total, o.delivery_postcode from ".TABLE_ORDERS." o left join ".TABLE_ORDERS_TOTAL." ot on (o.orders_id = ot.orders_id), ".TABLE_ORDERS_STATUS." s where (o.orders_status = s.orders_status_id and s.language_id = '".$_SESSION['languages_id']."' and ot.class = 'ot_total') or (o.orders_status = '0' and ot.class = 'ot_total' and  s.orders_status_id = '1' and s.language_id = '".$_SESSION['languages_id']."') order by o.date_purchased DESC";
	}
	$orders_split = new splitPageResults($_GET['page'], '40', $orders_query_raw, $orders_query_numrows);
	$orders_query = xtc_db_query($orders_query_raw);
	while ($orders = xtc_db_fetch_array($orders_query)) {
		if (((!$_GET['oID']) || ($_GET['oID'] == $orders['orders_id'])) && (!$oInfo)) {
			$oInfo = new objectInfo($orders);
		}
?>
			<li<?php
			if ($orders['orders_status'] == 2) { echo ' data-theme="b"'; }
			elseif ($orders['orders_status'] == 4) { echo ' data-theme="d"'; }
			elseif ($orders['orders_status'] == 3) { echo ' data-theme="e"'; }
			else { echo ' data-theme="a"'; }
			?>><?php echo '<a href="' . xtc_href_link('mobile.php', xtc_get_all_get_params(array('oID', 'action', 'ord')) . 'oID=' . $orders['orders_id'] . '&action=edit&ord=orders') . '" data-ajax="false">'; ?>
				<h3><?php echo $orders['customers_name']; ?></h3>
				<p><strong><?php echo xtc_datetime_short($orders['date_purchased']); ?></strong></p>
				<p><?php 
						if($orders['payment_method'] == 'paypal') { echo "Paypal"; }
						elseif($orders['payment_method'] == 'cod') { echo "Nachnahme "; }
						elseif($orders['payment_method'] == 'moneyorder') { echo "Vorkasse"; }
						elseif($orders['payment_method'] == 'invoice') { echo "Rechnung "; }
						else { echo $orders['payment_method']; }
				 ?> | <?php echo $orders['orders_status_name']; ?></p>
				<p class="ui-li-aside"><strong><?php echo $orders['orders_id']; ?></strong></p>
				<span class="ui-li-count"><?php echo strip_tags($orders['order_total']); ?></span>
				</a>
			</li>
<?php
	}
?>
		</ul>
		<div data-role="fieldcontain">
<?php
	echo $orders_split->display_links($orders_query_numrows, '40', MAX_DISPLAY_PAGE_LINKS, $_GET['page'], 'ord=orders');
?>
		</div>
	</div>
<?php
}

if(isset($_GET['ord']) && $_GET['ord'] == 'orders' && $_GET['oID'] != '') {
	// initiate template engine for mail
$smarty = new Smarty;
	require (DIR_WS_CLASSES.'currencies.php');
$currencies = new currencies();

if ((($_GET['action'] == 'edit') || ($_GET['action'] == 'update_order')) && ($_GET['oID'])) {
	$oID = xtc_db_prepare_input($_GET['oID']);
	$orders_query = xtc_db_query("select orders_id from ".TABLE_ORDERS." where orders_id = '".xtc_db_input($oID)."'");
	$order_exists = true;
	if (!xtc_db_num_rows($orders_query)) {
		$order_exists = false;
		$messageStack->add(sprintf(ERROR_ORDER_DOES_NOT_EXIST, $oID), 'error');
	}
}

if ((($_GET['action'] == 'edit') || ($_GET['action'] == 'update_order')) && ($order_exists)) {
	$order = new order($oID);
}

  $lang_query = xtc_db_query("select languages_id from " . TABLE_LANGUAGES . " where directory = '" . $order->info['language'] . "'");
  $lang = xtc_db_fetch_array($lang_query);  
  $lang=$lang['languages_id'];

if (!isset($lang)) $lang=$_SESSION['languages_id'];
	$orders_statuses = array ();
	$orders_status_array = array ();
	$orders_status_query = xtc_db_query("select orders_status_id, orders_status_name from ".TABLE_ORDERS_STATUS." where language_id = '".$lang."'");
while ($orders_status = xtc_db_fetch_array($orders_status_query)) {
	$orders_statuses[] = array ('id' => $orders_status['orders_status_id'], 'text' => $orders_status['orders_status_name']);
	$orders_status_array[$orders_status['orders_status_id']] = $orders_status['orders_status_name'];
}
switch ($_GET['action']) {
	case 'update_order' :
		$oID = xtc_db_prepare_input($_GET['oID']);
		$status = xtc_db_prepare_input($_POST['status']);
		$comments = xtc_db_prepare_input($_POST['comments']);

	//	$order = new order($oID);
	$order_updated = false;
	$check_status_query = xtc_db_query("select customers_name, customers_email_address, orders_status, date_purchased, delivery_postcode from ".TABLE_ORDERS." where orders_id = '".xtc_db_input($oID)."'");
	$check_status = xtc_db_fetch_array($check_status_query);
	if ($check_status['orders_status'] != $status || $comments != '') {
		xtc_db_query("update ".TABLE_ORDERS." set orders_status = '".xtc_db_input($status)."', last_modified = now() where orders_id = '".xtc_db_input($oID)."'");

			$customer_notified = '0';
			if ($_POST['notify'] == 'on') {
				$notify_comments = '';
				if ($_POST['notify_comments'] == 'on') {
					//$notify_comments = sprintf(EMAIL_TEXT_COMMENTS_UPDATE, $comments)."\n\n";
					$notify_comments = $comments;
				} else {
					$notify_comments = '';
				}

				// assign language to template for caching
				$smarty->assign('language', $_SESSION['language']);
				$smarty->caching = false;

				// set dirs manual
				$smarty->template_dir = DIR_FS_CATALOG.'templates';
				$smarty->compile_dir = DIR_FS_CATALOG.'templates_c';
				$smarty->config_dir = DIR_FS_CATALOG.'lang';
				$smarty->assign('tpl_path', 'templates/'.CURRENT_TEMPLATE.'/');
				$smarty->assign('logo_path', HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
				$smarty->assign('NAME', $check_status['customers_name']);
				$smarty->assign('ZIPCODE', $check_status['delivery_postcode']);
				$smarty->assign('ORDER_NR', $oID);
				$smarty->assign('ORDER_ID', $oID);
				$smarty->assign('ORDER_LINK', xtc_catalog_href_link(FILENAME_CATALOG_ACCOUNT_HISTORY_INFO, 'order_id='.$oID, 'SSL'));
				$smarty->assign('ORDER_DATE', xtc_date_long($check_status['date_purchased']));
				$smarty->assign('NOTIFY_COMMENTS', $notify_comments);
				$smarty->assign('ORDER_STATUS', $orders_status_array[$status]);
				$html_mail = $smarty->fetch(CURRENT_TEMPLATE.'/admin/mail/'.$order->info['language'].'/change_order_mail.html');
				$txt_mail = $smarty->fetch(CURRENT_TEMPLATE.'/admin/mail/'.$order->info['language'].'/change_order_mail.txt');

				xtc_php_mail(EMAIL_BILLING_ADDRESS, EMAIL_BILLING_NAME, $check_status['customers_email_address'], $check_status['customers_name'], '', EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, '', '', EMAIL_BILLING_SUBJECT, $html_mail, $txt_mail);
				$customer_notified = '1';
			}

			xtc_db_query("insert into ".TABLE_ORDERS_STATUS_HISTORY." (orders_id, orders_status_id, date_added, customer_notified, comments) values ('".xtc_db_input($oID)."', '".xtc_db_input($status)."', now(), '".$customer_notified."', '".xtc_db_input($comments)."')");

			$order_updated = true;
		}

		if ($order_updated) {
			$messageStack->add_session(SUCCESS_ORDER_UPDATED, 'success');
		} else {
			$messageStack->add_session(WARNING_ORDER_NOT_UPDATED, 'warning');
		}

		xtc_redirect(xtc_href_link('mobile.php', xtc_get_all_get_params(array ('action')).'action=edit&ord=orders'));
		break;
}

	if (($_GET['action'] == 'edit') && ($order_exists)) {
		
		require_once(DIR_FS_INC .'xtc_format_price_order.inc.php');
?>

<div data-role="content" class="ui-body">
		<ul data-role="listview" data-inset="true" data-theme="d" data-divider-theme="e" data-count-theme="b">
			<li data-role="list-divider" data-inset="true"><?php echo 'Bestell Nr : ' . $oID . ' - ' . xtc_datetime_short($order->info['date_purchased']); ?></li>
			<li><h3>Kunde</h3><p><a href="mobile.php?ord=customers&cID=<?php echo $order->customer['ID']; ?>&action=edit" data-ajax="false"><?php echo xtc_address_format($order->customer['format_id'], $order->customer, 1, '', ','); ?></a></p></li>
		</ul>
	
		<div data-role="collapsible" data-collapsed="true" data-inset="true">
			<h3>Versand- und Rechnungsadresse</h3>
			<ul data-role="listview" data-inset="true" data-theme="d" data-divider-theme="e" data-count-theme="b">
				<li><h3>Versandadresse</h3><p><?php echo xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', ','); ?></p></li>
				<li><h3>Rechnungsadresse</h3><p><?php echo xtc_address_format($order->billing['format_id'], $order->billing, 1, '', ','); ?></p></li>
			</ul>
		</div>

		<div data-role="collapsible" data-collapsed="true" data-inset="true">
			<h3>Kundendaten</h3>
			<ul data-role="listview" data-inset="true">
				<li>Telefon: <span class="ui-li-count"><?php echo '<a href="tel:' . $order->customer['telephone'] . '"><u>' . $order->customer['telephone'] . '</u></a>'; ?></span></li>
				<li>E-Mail: <span class="ui-li-count"><?php echo '<a href="mailto:' . $order->customer['email_address'] . '"><u>' . $order->customer['email_address'] . '</u></a>'; ?></span></li>
				<?php if(isset($order->customer['vat_id']) && $order->customer['vat_id'] != ''){ ?>
				<li>USt-ID: <span class="ui-li-count"><?php echo $order->customer['vat_id']; ?></span></li>
				<?php } ?>
				<li>Bestell IP: <span class="ui-li-count"><?php echo $order->customer['cIP']; ?></span></li>
				<li>Sprache: <span class="ui-li-count"><?php echo $order->info['language']; ?></span></li>
				<li>Zahlungsweise: <span class="ui-li-count"><?php echo $order->info['payment_method']; ?></span></li>
				<li>Referer: <span class="ui-li-count"><?php echo $order->info['refferers_id']; ?></span></li>
			</ul>
		</div>

	<ul data-role="listview" data-inset="true" data-theme="d" data-divider-theme="e" data-count-theme="e">
			<li data-role="list-divider" data-inset="true">Warenkorb</li>
			<?php
				for ($i = 0, $n = sizeof($order->products); $i < $n; $i ++) {
			?>
				<li><h3><?php echo $order->products[$i]['qty']; ?> x <?php 
							if ($order->products[$i]['model'] != '') {
								echo $order->products[$i]['model'];
							} else {
								echo '';
							}
					
							// attribute models
							if (sizeof($order->products[$i]['attributes']) > 0) {
								for ($j = 0, $k = sizeof($order->products[$i]['attributes']); $j < $k; $j ++) {
									$model = xtc_get_attributes_model($order->products[$i]['id'], $order->products[$i]['attributes'][$j]['value'],$order->products[$i]['attributes'][$j]['option']);
									if ($model != '') {
										echo '/'.$model.'';
									}
					
								}
							}
					?></h3>
				<p><?php echo $order->products[$i]['qty']; ?> x <?php echo $order->products[$i]['name']; 
							if (sizeof($order->products[$i]['attributes']) > 0) {
								for ($j = 0, $k = sizeof($order->products[$i]['attributes']); $j < $k; $j ++) {
									echo '<br /><nobr><small>&nbsp;<i> - '.$order->products[$i]['attributes'][$j]['option'].': '.$order->products[$i]['attributes'][$j]['value'].': ';
					
									$model = xtc_get_attributes_model($order->products[$i]['id'], $order->products[$i]['attributes'][$j]['value'],$order->products[$i]['attributes'][$j]['option']);
									if ($model != '') {
										echo $model.'<br />';
									}					
								}
								echo '</i></small></nobr>';
							}
					?>
				</p>
				<span class="ui-li-count"><?php echo format_price(($order->products[$i]['final_price']), 1, $order->info['currency'], 0, 0); ?></span>
				</li>
				
			<?php
			}
			?>

			<?php
			for ($i = 0, $n = sizeof($order->totals); $i < $n; $i ++) {
				echo '<li>'.$order->totals[$i]['title'].'<span class="ui-li-count">'.$order->totals[$i]['text'].'</span></li>';
			}
			?>
		</ul>
		<div data-role="collapsible" data-collapsed="true" data-inset="true">
		<h3>Statushistory</h3>
		<ul data-role="listview" data-inset="true" data-theme="d" data-divider-theme="e" data-count-theme="e">

			<?php
			
				$orders_history_query = xtc_db_query("select orders_status_id, date_added, customer_notified, comments from ".TABLE_ORDERS_STATUS_HISTORY." where orders_id = '".xtc_db_input($oID)."' order by date_added");
				if (xtc_db_num_rows($orders_history_query)) {
					while ($orders_history = xtc_db_fetch_array($orders_history_query)) {
						echo '<li data-inset="true">';
						echo '<h3>';
						if($orders_history['orders_status_id']!='0') {
							echo $orders_status_array[$orders_history['orders_status_id']];
						}else{
							echo '<font color="#FF0000">'.TEXT_VALIDATING.'</font>';
						}
						echo '</h3><p>';
						
						if($orders_history['comments'] != '') { echo nl2br(xtc_db_output($orders_history['comments'])).'<br />'; };
						if ($orders_history['customer_notified'] == '1') {
							echo '<strong>benachrichtigt</strong>';
						} else {
							echo '<strong>nicht benachrichtigt</strong>';
						}
						echo '</p><span class="ui-li-count">'.xtc_datetime_short($orders_history['date_added']).'</span></li>';
					}
				} else {
					echo '<li><h3>'.TEXT_NO_ORDER_HISTORY.'</h3></li>';
				}
			?>			
		</ul>
	</div>

	<form name="status" action="mobile.php?page=<?php echo $_GET['page']; ?>&oID=<?php echo $oID; ?>&ord=orders&action=update_order" method="post" data-ajax="false">
		<ul data-role="listview" data-inset="true" data-theme="d" data-divider-theme="e" data-count-theme="e">
			<li data-role="fieldcontain">
				<label for="comments">Kommentar:</label>
				<?php echo xtc_draw_textarea_field('comments', 'soft', '60', '5', $order->info['comments']); ?>
			</li>
			<li data-role="fieldcontain">
				<label for="status" class="select">Status:</label>
				<?php echo xtc_draw_pull_down_menu('status', $orders_statuses, $order->info['orders_status'], 'id=status'); ?>
			</li>
			<li data-role="fieldcontain">
					<fieldset data-role="controlgroup">
					<legend>Nachricht:</legend>
					<input type="checkbox" name="notify" class="custom" id="notify">
					<label for="notify">benachrichtigen</label>
					<input type="checkbox" name="notify_comments" class="custom" id="notify_comments">
					<label for="notify_comments">Kommentar senden</label>
					</fieldset>
			</li>
			<li class="ui-body ui-body-b">
				<fieldset class="ui-grid-a">
						<div class="ui-block-b"><button type="submit" data-theme="a">Aktualisieren</button></div>
			  </fieldset>
			</li>
		</ul>
	</form>
</div>

<?php
	}
}
?>

<?php
if(isset($_GET['ord']) && $_GET['ord'] == 'customers') {

require_once (DIR_FS_INC.'xtc_validate_vatid_status.inc.php');
require_once (DIR_FS_INC.'xtc_get_geo_zone_code.inc.php');
require_once (DIR_FS_INC.'xtc_encrypt_password.inc.php');
require_once (DIR_FS_INC.'xtc_js_lang.php');


if(isset($_GET['cID']) && $_GET['action']==edit){
	$customers_query = xtc_db_query("select c.payment_unallowed, c.shipping_unallowed, c.customers_gender, c.customers_vat_id, c.customers_status, c.member_flag, c.customers_firstname,c.customers_cid, c.customers_lastname, c.customers_dob, c.customers_email_address, a.entry_company, a.entry_street_address, a.entry_suburb, a.entry_postcode, a.entry_city, a.entry_state, a.entry_zone_id, a.entry_country_id, c.customers_telephone, c.customers_fax, c.customers_newsletter, c.customers_default_address_id from ".TABLE_CUSTOMERS." c left join ".TABLE_ADDRESS_BOOK." a on c.customers_default_address_id = a.address_book_id where a.customers_id = c.customers_id and c.customers_id = '".$_GET['cID']."'");
	$customers = xtc_db_fetch_array($customers_query);
	$cInfo = new objectInfo($customers);
	$newsletter_array = array (array ('id' => '1', 'text' => ENTRY_NEWSLETTER_YES), array ('id' => '0', 'text' => ENTRY_NEWSLETTER_NO));
?>
<div data-role="content">
<div data-inset="true">
	<h3>Kundendaten</h3>
		<ul data-role="listview" data-inset="true">
			<li>Anrede: <span class="ui-li-count"><?php echo ($cInfo->customers_gender == 'm') ? 'Herr' : 'Frau'; ?></span></li>
			<li>Name: <span class="ui-li-count"><?php echo $cInfo->customers_lastname.' '.$cInfo->customers_firstname; ?></span></li>
			<li>E-Mail: <span class="ui-li-count"><?php echo '<a href="mailto:' . $cInfo->customers_email_address . '"><u>' . $cInfo->customers_email_address . '</u></a>'; ?></span></li>
			<?php if(isset($cInfo->vat_id) && $cInfo->vat_id != ''){ ?>
			<li>Firmenname: <span class="ui-li-count"><?php echo $cInfo->entry_company; ?></span></li>
			<li>USt-ID: <span class="ui-li-count"><?php echo $cInfo->vat_id; ?></span></li>
			<?php } ?>
			<li>Strasse: <span class="ui-li-count"><?php echo $cInfo->entry_street_address; ?></span></li>
			<li>Postleitzahl: <span class="ui-li-count"><?php echo $cInfo->entry_postcode; ?></span></li>
			<li>Stadt: <span class="ui-li-count"><?php echo $cInfo->entry_city; ?></span></li>
			<li>Land: <span class="ui-li-count"><?php
				echo xtc_get_zone_name($cInfo->entry_country_id, $cInfo->entry_zone_id, $cInfo->entry_state);
			?></span></li>
			<li>Telefonnummer: <span class="ui-li-count"><?php echo '<a href="tel:' . $cInfo->customers_telephone . '"><u>' . $cInfo->customers_telephone . '</u></a>'; ?></span></li>
		</ul>
</div>
<div data-inline="true">
	<a href="mobile.php?ord=orders&cID=<?php echo $_GET['cID'];?>" data-role="button" data-ajax="false">Bestellungen von <?php echo $cInfo->customers_lastname.' '.$cInfo->customers_firstname; ?></a>
</div>
</div>

<?php

	} else {
	
		$search = '';
	if (($_GET['search']) && (xtc_not_null($_GET['search']))) {
		$keywords = xtc_db_input(xtc_db_prepare_input($_GET['search']));
		$search = "and (c.customers_lastname like '%".$keywords."%' or c.customers_firstname like '%".$keywords."%' or c.customers_email_address like '%".$keywords."%' or c.customers_id='".$keywords."')";
	}

	if ($_GET['status'] && $_GET['status'] != '100' or $_GET['status'] == '0') {
		$status = xtc_db_prepare_input($_GET['status']);
		//  echo $status;
		$search = "and c.customers_status = '".$status."'";
	}

	if ($_GET['sorting']) {
		switch ($_GET['sorting']) {

			case 'customers_firstname' :
				$sort = 'order by c.customers_firstname';
				break;

			case 'customers_firstname-desc' :
				$sort = 'order by c.customers_firstname DESC';
				break;

			case 'customers_lastname' :
				$sort = 'order by c.customers_lastname';
				break;

			case 'customers_lastname-desc' :
				$sort = 'order by c.customers_lastname DESC';
				break;

			case 'date_account_created' :
				$sort = 'order by ci.customers_info_date_account_created';
				break;

			case 'date_account_created-desc' :
				$sort = 'order by ci.customers_info_date_account_created DESC';
				break;
		}
	}
	$customers_statuses_array = xtc_get_customers_statuses();
	$customers_query_raw = "select
	                                c.account_type,
	                                c.customers_id,
	                                c.customers_vat_id,
	                                c.customers_vat_id_status,
	                                c.customers_lastname,
	                                c.customers_firstname,
	                                c.customers_email_address,
	                                a.entry_country_id,
	                                c.customers_status,
	                                c.member_flag,
	                                ci.customers_info_date_account_created
	                                from
	                                ".TABLE_CUSTOMERS." c ,
	                                ".TABLE_ADDRESS_BOOK." a,
	                                ".TABLE_CUSTOMERS_INFO." ci
	                                Where
	                                c.customers_id = a.customers_id
	                                and c.customers_default_address_id = a.address_book_id
	                                and ci.customers_info_id = c.customers_id
	                                ".$search."
	                                group by c.customers_id
	                                ".$sort;

	$customers_query = xtc_db_query($customers_query_raw);

?>
	<div data-role="content">
			<ul data-role="listview" data-filter="true" data-inset="true">
<?php
	while ($customers = xtc_db_fetch_array($customers_query)) {
		$info_query = xtc_db_query("select customers_info_date_account_created as date_account_created, customers_info_date_account_last_modified as date_account_last_modified, customers_info_date_of_last_logon as date_last_logon, customers_info_number_of_logons as number_of_logons from ".TABLE_CUSTOMERS_INFO." where customers_info_id = '".$customers['customers_id']."'");
		$info = xtc_db_fetch_array($info_query);

		if (((!$_GET['cID']) || (@ $_GET['cID'] == $customers['customers_id'])) && (!$cInfo)) {
			$country_query = xtc_db_query("select countries_name from ".TABLE_COUNTRIES." where countries_id = '".$customers['entry_country_id']."'");
			$country = xtc_db_fetch_array($country_query);

			$reviews_query = xtc_db_query("select count(*) as number_of_reviews from ".TABLE_REVIEWS." where customers_id = '".$customers['customers_id']."'");
			$reviews = xtc_db_fetch_array($reviews_query);

			$customer_info = xtc_array_merge($country, $info, $reviews);

			$cInfo_array = xtc_array_merge($customers, $customer_info);
			$cInfo = new objectInfo($cInfo_array);
		}
?>
  				<li><a href="mobile.php?ord=customers&cID=<?php echo $customers['customers_id']?>&action=edit" data-ajax="false">
  					<?php echo $customers['customers_lastname']; ?> <?php echo $customers['customers_firstname']; ?> <p>(<?php echo $customers_statuses_array[$customers['customers_status']]['text']; ?>)</p><span class="ui-li-count"><?php echo xtc_date_short($info['date_account_created']); ?></span></a></li>
<?php
	}
?>
			</ul>
	</div>
<?php
	}
}

if(isset($_GET['ord']) && $_GET['ord'] == 'sales') {

  require(DIR_WS_CLASSES . 'currencies.php');
  require_once(DIR_FS_DOCUMENT_ROOT . 'lang/german/admin/stats_sales_report.php');
  $currencies = new currencies();

  // default detail no detail
  $srDefaultDetail = 0;
  // default view (daily)
  $srDefaultView = 2;
  // default export
  $srDefaultExp = 0;
  // default sort
  $srDefaultSort = 4;
  
  // report views (1: yearly 2: monthly 3: weekly 4: daily)
  if ( ($_GET['report']) && (xtc_not_null($_GET['report'])) )
{    $srView = $_GET['report'];
  }
  if ($srView < 1 || $srView > 4) {
    $srView = $srDefaultView;
  }

  // detail
  if ( ($_GET['detail']) && (xtc_not_null($_GET['detail'])) )
{    $srDetail = $_GET['detail'];
  }
  if ($srDetail < 0 || $srDetail > 2) {
    $srDetail = $srDefaultDetail;
  }
  
  // report views (1: yearly 2: monthly 3: weekly 4: daily)
  if ( ($_GET['export']) && (xtc_not_null($_GET['export'])) )
{    $srExp = $_GET['export'];
  }
  if ($srExp < 0 || $srExp > 2) {
    $srExp = $srDefaultExp;
  }
  
  // item_level
  if ( ($_GET['max']) && (xtc_not_null($_GET['max'])) ) {
    $srMax = $_GET['max'];
  }
  if (!is_numeric($srMax)) {
    $srMax = 0;
  }
      
  // order status
  if ( ($_GET['status']) && (xtc_not_null($_GET['status'])) )
{    $srStatus = $_GET['status'];
  }
  if (!is_numeric($srStatus)) {
    $srStatus = 0;
  }
  
   // paymenttype
  if ( isset($_GET['payment']) && $_GET['payment'] != '' )
{    $srPayment = $_GET['payment'];
  } else {
 		$srPayment = 0;
  }
  
  // sort
  if ( ($_GET['sort']) && (xtc_not_null($_GET['sort'])) ) {
    $srSort = $_GET['sort'];
  }
  if ($srSort < 1 || $srSort > 6) {
    $srSort = $srDefaultSort;
  }
    
  // check start and end Date
  $startDate = "";
  $startDateG = 0;
  if ( ($_GET['startD']) && (xtc_not_null($_GET['startD'])) )
{    $sDay = $_GET['startD'];
    $startDateG = 1;
  } else {
    $sDay = 1;
  }
  if ( ($_GET['startM']) && (xtc_not_null($_GET['startM'])) )
{    $sMon = $_GET['startM'];
    $startDateG = 1;
  } else {
    $sMon = 1;
  }
  if ( ($_GET['startY']) && (xtc_not_null($_GET['startY'])) )
{    $sYear = $_GET['startY'];
    $startDateG = 1;
  } else {
    $sYear = date("Y");
  }
  if ($startDateG) {
    $startDate = mktime(0, 0, 0, $sMon, $sDay, $sYear);
  } else {
    $startDate = mktime(0, 0, 0, date("m"), 1, date("Y"));
  }
    
  $endDate = "";
  $endDateG = 0;
  if ( ($_GET['endD']) && (xtc_not_null($_GET['endD'])) ) {
    $eDay = $_GET['endD'];
    $endDateG = 1;
  } else {
    $eDay = 1;
  }
  if ( ($_GET['endM']) && (xtc_not_null($_GET['endM'])) ) {
    $eMon = $_GET['endM'];
    $endDateG = 1;
  } else {
    $eMon = 1;
  }
  if ( ($_GET['endY']) && (xtc_not_null($_GET['endY'])) ) {
    $eYear = $_GET['endY'];
    $endDateG = 1;
  } else {
    $eYear = date("Y");
  }
  if ($endDateG) {
    $endDate = mktime(0, 0, 0, $eMon, $eDay + 1, $eYear);
  } else {
    $endDate = mktime(0, 0, 0, date("m"), date("d") + 1, date("Y"));
  }
  
  require(DIR_WS_CLASSES . 'sales_report.php');
  $sr = new sales_report($srView, $startDate, $endDate, $srSort, $srStatus, $srFilter,$srPayment);  
  $startDate = $sr->startDate;
  $endDate = $sr->endDate;  

  if ($srExp < 2) {

    if ($srExp < 1) {
?>

    <form action="mobile.php" method="get" data-ajax="false">
    	<input type="hidden" name="ord" value="sales">

			<div data-role="fieldcontain">
			    <fieldset data-role="controlgroup">
			     	<legend>&nbsp;</legend>
                    <input type="radio" name="report" id="report1" value="1" <?php if ($srView == 1) echo "checked"; ?>>
                    <label for="report1"><?php echo REPORT_TYPE_YEARLY; ?></label>
                    <input type="radio" name="report" id="report2" value="2" <?php if ($srView == 2) echo "checked"; ?>>
                    <label for="report2"><?php echo REPORT_TYPE_MONTHLY; ?></label>
                    <input type="radio" name="report" id="report3" value="3" <?php if ($srView == 3) echo "checked"; ?>>
                    <label for="report3"><?php echo REPORT_TYPE_WEEKLY; ?></label>
                    <input type="radio" name="report" id="report4" value="4" <?php if ($srView == 4) echo "checked"; ?>>
                    <label for="report4"><?php echo REPORT_TYPE_DAILY; ?></label>
			    </fieldset>
			</div>


			<div data-role="fieldcontain">
				<label for="select-choice-a" class="select"><?php echo REPORT_START_DATE; ?>:</label>
        <select name="startD" id="select-choice-a">
<?php
      if ($startDate) {
        $j = date("j", $startDate);
      } else {
        $j = 1;
      }
      for ($i = 1; $i < 32; $i++) {
?>
					<option<?php if ($j == $i) echo " selected"; ?>><?php echo $i; ?></option>
<?php
      }
?>
      	</select>
				<label for="select-choice-b" class="select">&nbsp;</label>
        <select name="startM" id="select-choice-b">
<?php
      if ($startDate) {
        $m = date("n", $startDate);
      } else {
        $m = 1;
      }
      for ($i = 1; $i < 13; $i++) {
?>
       		<option<?php if ($m == $i) echo " selected"; ?> value="<?php echo $i; ?>"><?php echo strftime("%B", mktime(0, 0, 0, $i, 1)); ?></option>
<?php
      }
?>
        </select>
        <label for="select-choice-c" class="select">&nbsp;</label>
        <select name="startY" id="select-choice-c">
<?php
      if ($startDate) {
        $y = date("Y") - date("Y", $startDate);
      } else {
        $y = 0;
      }
      for ($i = 10; $i >= 0; $i--) {
?>
       	<option<?php if ($y == $i) echo " selected"; ?>><?php echo date("Y") - $i; ?></option>
<?php
    }
?>
                    </select>
		</div> 
		
		
		<div data-role="fieldcontain">
				<label for="select-choice-d" class="select"><?php echo REPORT_END_DATE; ?>:</label>
        <select name="endD" id="select-choice-d">
<?php
    if ($endDate) {
      $j = date("j", $endDate - 60* 60 * 24);
    } else {
      $j = date("j");
    }
    for ($i = 1; $i < 32; $i++) {
?>
                      <option<?php if ($j == $i) echo " selected"; ?>><?php echo $i; ?></option>
<?php
    }
?>
                    </select>
                    <label for="select-choice-d" class="select">&nbsp;</label>
                    <select name="endM" id="select-choice-d">
<?php
    if ($endDate) {
      $m = date("n", $endDate - 60* 60 * 24);
    } else {
      $m = date("n");
    }
    for ($i = 1; $i < 13; $i++) {
?>
                      <option<?php if ($m == $i) echo " selected"; ?> value="<?php echo $i; ?>"><?php echo strftime("%B", mktime(0, 0, 0, $i, 1)); ?></option>
<?php
    }
?>
                    </select>
                    <label for="select-choice-e" class="select">&nbsp;</label>
                    <select name="endY" id="select-choice-e">
<?php
    if ($endDate) {
      $y = date("Y") - date("Y", $endDate - 60* 60 * 24);
    } else {
      $y = 0;
    }
    for ($i = 10; $i >= 0; $i--) {
?>
                      <option<?php if ($y == $i) echo " selected"; ?>><?php echo
date("Y") - $i; ?></option><?php
    }
?>
                    </select>
		</div>

		<div data-role="fieldcontain">
				<label for="select-choice-f" class="select"><?php echo REPORT_DETAIL; ?>:</label>
        <select name="detail" id="select-choice-f">
          <option value="0"<?php if ($srDetail == 0) echo "selected"; ?>><?php echo DET_HEAD_ONLY; ?></option>
          <option value="1"<?php if ($srDetail == 1) echo " selected"; ?>><?php echo DET_DETAIL; ?></option>
          <option value="2"<?php if ($srDetail == 2) echo " selected"; ?>><?php echo DET_DETAIL_ONLY; ?></option>
        </select>
    </div>
    
		<div data-role="fieldcontain">
				<label for="select-choice-g" class="select"><?php echo REPORT_MAX; ?>:</label>
        <select name="max" id="select-choice-g">
          <option value="0"><?php echo REPORT_ALL; ?></option>
          <option<?php if ($srMax == 1) echo " selected"; ?>>1</option>
          <option<?php if ($srMax == 3) echo " selected"; ?>>3</option>
          <option<?php if ($srMax == 5) echo " selected"; ?>>5</option>
          <option<?php if ($srMax == 10) echo " selected"; ?>>10</option>
          <option<?php if ($srMax == 25) echo " selected"; ?>>25</option>
          <option<?php if ($srMax == 50) echo " selected"; ?>>50</option>
        </select>
    </div>

		<div data-role="fieldcontain">
				<label for="select-choice-h" class="select"><?php echo REPORT_STATUS_FILTER; ?>:</label>
        <select name="status" id="select-choice-h">
          <option value="0"><?php echo REPORT_ALL; ?></option>
<?php
            foreach ($sr->status as $value) {
?>
          <option value="<?php echo $value["orders_status_id"]?>"<?php if ($srStatus == $value["orders_status_id"]) echo " selected"; ?>><?php echo $value["orders_status_name"] ; ?></option>
<?php
             }
?>
        </select>
    </div>

		<div data-role="fieldcontain">
				<label for="select-choice-i" class="select"><?php echo REPORT_PAYMENT_FILTER; ?>:</label>
        <select name="payment" id="select-choice-i">
				<option value="0"><?php echo REPORT_ALL; ?></option>
				<?php
				
				$payments = split(';', MODULE_PAYMENT_INSTALLED);
				for ($i=0; $i<count($payments); $i++){
				
				require(DIR_FS_LANGUAGES . $_SESSION['language'] . '/modules/payment/' . $payments[$i]);	
				
				$payment = substr($payments[$i], 0, strrpos($payments[$i], '.'));	
				$payment_text = constant(MODULE_PAYMENT_.strtoupper($payment)._TEXT_TITLE);
				   
				?>                           
				<option value="<?php echo $payment; ?>"<?php if($srPayment == $payment) { echo " selected"; } ?>><?php echo $payment_text ; ?></option>
				     
				<?php                         
				}
				 
				?>
				</select>
    </div>
    
		<div data-role="fieldcontain">
				<label for="select-choice-j" class="select"><?php echo REPORT_EXP; ?>:</label>
        <select name="export" id="select-choice-j">
          <option value="0" selected><?php echo EXP_NORMAL; ?></option>
          <option value="1"><?php echo EXP_HTML; ?></option>
          <option value="2"><?php echo EXP_CSV; ?></option>
        </select>
    </div>

		<div data-role="fieldcontain">
				<label for="select-choice-k" class="select"><?php echo REPORT_SORT; ?>:</label>
        <select name="sort" id="select-choice-k">
          <option value="0"<?php if ($srSort == 0) echo " selected"; ?>><?php echo SORT_VAL0; ?></option>
          <option value="1"<?php if ($srSort == 1) echo " selected"; ?>><?php echo SORT_VAL1; ?></option>
          <option value="2"<?php if ($srSort == 2) echo " selected"; ?>><?php echo SORT_VAL2; ?></option>
          <option value="3"<?php if ($srSort == 3) echo " selected"; ?>><?php echo SORT_VAL3; ?></option>
          <option value="4"<?php if ($srSort == 4) echo " selected"; ?>><?php echo SORT_VAL4; ?></option>
          <option value="5"<?php if ($srSort == 5) echo " selected"; ?>><?php echo SORT_VAL5; ?></option>
          <option value="6"<?php if ($srSort == 6) echo " selected"; ?>><?php echo SORT_VAL6; ?></option>
        </select>
    </div>
                    
		<div class="ui-body ui-body-b">
			<fieldset class="ui-grid-a">
					<div class="ui-block-b"><button type="submit" data-theme="a" onClick="this.blur();"><?php echo BUTTON_UPDATE; ?></button></div>
	    </fieldset>
		</div>


<?php
  } // end of ($srExp < 1)
?>
		<table>
		  <thead>
		    <tr>
		      <th scope="col" align="left">Datum</th>  
		      <th scope="col" align="center">Bestellungen</th>  
		      <th scope="col" align="center">Artikel</th>  
		      <th scope="col" align="right">Umsatz</th>
		    </tr>
		  </thead>
		  <tbody>
<?php
} // end of if $srExp < 2 csv export
$sum = 0;
while ($sr->actDate < $sr->endDate) {
  $info = $sr->getNext();
  $last = sizeof($info) - 1;
  if ($srExp < 2) {
?>
        <tr>
<?php
    switch ($srView) {
      case '3':
?>
                      <td align="left"><?php echo xtc_date_long(date("Y-m-d\ H:i:s", $sr->showDate)) . "<br /> - " . xtc_date_short(date("Y-m-d\ H:i:s", $sr->showDateEnd)); ?></td>
<?php
        break;
      case '4':
?>
                      <td align="left"><?php echo xtc_date_long(date("Y-m-d\ H:i:s", $sr->showDate)); ?></td>
<?php
        break;
      default;
?>
                      <td align="left"><?php echo xtc_date_short(date("Y-m-d\ H:i:s", $sr->showDate)) . "<br /> - " . xtc_date_short(date("Y-m-d\ H:i:s", $sr->showDateEnd)); ?></td>
<?php
    }
?>
                      <td align="center"><?php echo $info[0]['order']; ?></td>
                      <td align="center"><?php echo $info[$last - 1]['totitem']; ?></td>
                      <td align="right"><?php echo $currencies->format($info[$last - 1]['totsum']);?></td>
                    </tr>
<?php
  } else {
    // csv export
    echo date(DATE_FORMAT, $sr->showDate) . SR_SEPARATOR1 . date(DATE_FORMAT, $sr->showDateEnd) . SR_SEPARATOR1;
    echo $info[0]['order'] . SR_SEPARATOR1;
    echo $info[$last - 1]['totitem'] . SR_SEPARATOR1;
    echo $currencies->format($info[$last - 1]['totsum']) . SR_SEPARATOR1;
    echo $currencies->format($info[0]['shipping']) . SR_NEWLINE;
  }
  if ($srDetail) {
    for ($i = 0; $i < $last; $i++) {
      if ($srMax == 0 or $i < $srMax) {
        if ($srExp < 2) {
?>
                    <tr>
                    <td align="left"><a href="<?php echo xtc_catalog_href_link("product_info.php?products_id=" . $info[$i]['pid']) ?>" target="_blank"><?php echo $info[$i]['pmodel'].' : '.$info[$i]['pname']; ?></a>
<?php
  if (is_array($info[$i]['attr'])) {
    $attr_info = $info[$i]['attr'];
    foreach ($attr_info as $attr) {
      echo '<div style="font-style:italic;">&nbsp;' . $attr['quant'] . 'x ' ;
      //  $attr['options'] . ': '
      $flag = 0;
      foreach ($attr['options_values'] as $value) {
        if ($flag > 0) {
          echo "," . $value;
        } else {
          echo $value;
          $flag = 1;
        }
      }
      $price = 0;
      foreach ($attr['price'] as $value) {
        $price += $value;
      }
      if ($price != 0) {
        echo ' (';
        if ($price > 0) {
          echo "+";
        }
        echo $currencies->format($price). ')';
      }
      echo '</div>';
    }
  }
?>                    </td>
                    <td align="center"><?php echo $info[$i]['pquant']; ?></td>
<?php
          if ($srDetail == 2) {?>
                    <td align="right"><?php echo $currencies->format($info[$i]['psum']); ?></td>
<?php
          } else { ?>
                    <td>&nbsp;</td>
<?php
          }
?>
          </tr>
<?php
        } else {
        // csv export
          if (is_array($info[$i]['attr'])) {
            $attr_info = $info[$i]['attr'];
            foreach ($attr_info as $attr) {
              echo $info[$i]['pname'] . "(";
              $flag = 0;
              foreach ($attr['options_values'] as $value) {
                if ($flag > 0) {
                  echo ", " . $value;
                } else {
                  echo $value;
                  $flag = 1;
                }
              }
              $price = 0;
              foreach ($attr['price'] as $value) {
                $price += $value;
              }
              if ($price != 0) {
                echo ' (';
                if ($price > 0) {
                  echo "+";
                } else {
                  echo " ";
                }
                echo $currencies->format($price). ')';
              }
              echo ")" . SR_SEPARATOR2;
              if ($srDetail == 2) {
                echo $attr['quant'] . SR_SEPARATOR2;
                echo $currencies->format( $attr['quant'] * ($info[$i]['price'] + $price)) . SR_NEWLINE;
              } else {
                echo $attr['quant'] . SR_NEWLINE;
              }
              $info[$i]['pquant'] = $info[$i]['pquant'] - $attr['quant'];
            }
          }
          if ($info[$i]['pquant'] > 0) {
            echo $info[$i]['pmodel'].SR_SEPARATOR2.$info[$i]['pname'] . SR_SEPARATOR2;
            if ($srDetail == 2) {
              echo $info[$i]['pquant'] . SR_SEPARATOR2;
              echo $currencies->format($info[$i]['pquant'] * $info[$i]['price']) . SR_NEWLINE;
            } else {
              echo $info[$i]['pquant'] . SR_NEWLINE;
            }
          }
        }
      }
    }
  }
}
?>
		  </tbody>
		</table>
<?php
	}
?>
</div>

<div data-role="footer">
		<a href="http://www.untersatz.com/">&copy; Mark Gebur</a>
</div>

</body>
</html>
