<?php
/*-----------------------------------------------------------------
* 	ID:						categories.php
* 	Letzter Stand:			v2.2 R365
* 	zuletzt geaendert von:	akausch
* 	Datum:					2012/07/03
*
* 	Copyright (c) since 2010 commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
* 	Released under the GNU General Public License
* ---------------------------------------------------------------*/


require_once ('includes/application_top.php');
require_once ('includes/classes/'.FILENAME_IMAGEMANIPULATOR);

/* magnalister v1.0.1 */
if (function_exists('magnaExecute')) magnaExecute('magnaInventoryUpdate', array('action' => 'inventoryUpdate'), array('inventoryUpdate.php'));
/* END magnalister */

require_once ('includes/classes/categories.php');
require_once (DIR_FS_INC.'xtc_get_tax_rate.inc.php');
require_once (DIR_FS_INC.'xtc_get_products_mo_images.inc.php');
require_once (DIR_WS_CLASSES.'currencies.php');
require_once (DIR_FS_INC.'xtc_wysiwyg.inc.php');

if(MODULE_COMMERCE_SEO_INDEX_STATUS == 'True') {
	require_once (DIR_FS_INC.'commerce_seo.inc.php');
	!$commerceSeo ? $commerceSeo = new CommerceSeo() : false;
}

$currencies = new currencies();
$catfunc = new categories();

if ($_GET['function']) {
	switch ($_GET['function']) {
		case 'delete' :
			xtc_db_query("DELETE FROM personal_offers_by_customers_status_".(int) $_GET['statusID']."
						                     WHERE products_id = '".(int) $_GET['pID']."'
						                     AND quantity    = '".(int) $_GET['quantity']."'");
			break;
	}
	xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath='.$_GET['cPath'].'&action=new_product&pID='.(int) $_GET['pID']));
}


if (isset ($_POST['multi_status_on'])) {
	//set multi_categories status=on
	if (is_array($_POST['multi_categories'])) {
		foreach ($_POST['multi_categories'] AS $category_id) {
			$catfunc->set_category_recursive($category_id, '1');
		}
	}
	//set multi_products status=on
	if (is_array($_POST['multi_products'])) {
		foreach ($_POST['multi_products'] AS $product_id) {
			$catfunc->set_product_status($product_id, '1');
		}
	}
	xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath='.$_GET['cPath'].'&'.xtc_get_all_get_params(array ('cPath', 'action', 'pID', 'cID'))));
}

if (isset ($_POST['multi_status_off'])) {
	//set multi_categories status=off
	if (is_array($_POST['multi_categories'])) {
		foreach ($_POST['multi_categories'] AS $category_id) {
			$catfunc->set_category_recursive($category_id, "0");
		}
	}
	//set multi_products status=off
	if (is_array($_POST['multi_products'])) {
		foreach ($_POST['multi_products'] AS $product_id) {
			$catfunc->set_product_status($product_id, "0");
		}
	}
	xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath='.$_GET['cPath'].'&'.xtc_get_all_get_params(array ('cPath', 'action', 'pID', 'cID'))));
}

if($_GET['action']) {
	switch ($_GET['action']) {

		case 'setcflag' :
			if (($_GET['flag'] == '0') || ($_GET['flag'] == '1')) {
				if ($_GET['cID']) {
					$catfunc->set_category_recursive($_GET['cID'], $_GET['flag']);
				}
			}
			xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath='.$_GET['cPath'].'&cID='.$_GET['cID']));
			break;
		
		case 'setcpflag' :
				if (($_GET['flag'] == '0') || ($_GET['flag'] == '1')) {
					if ($_GET['cID']) {
						$catfunc->set_category_product_recursive($_GET['cID'], $_GET['flag']);
					}
				}
				xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath='.$_GET['cPath'].'&cID='.$_GET['cID']));
				break;

		case 'setpflag' :
			if (($_GET['flag'] == '0') || ($_GET['flag'] == '1')) {
				if ($_GET['pID']) {
					$catfunc->set_product_status($_GET['pID'], $_GET['flag']);
				}
			}
			if ($_GET['pID']) {
				xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath='.$_GET['cPath'].'&pID='.$_GET['pID']));
			} else {
				xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath='.$_GET['cPath'].'&cID='.$_GET['cID']));
			}
			break;
			//EOB setpflag

		case 'setsflag' :
			if (($_GET['flag'] == '0') || ($_GET['flag'] == '1')) {
				if ($_GET['pID']) {
					$catfunc->set_product_startpage($_GET['pID'], $_GET['flag']);
					if ($_GET['flag'] == '1') $catfunc->link_product($_GET['pID'], 0);
					$catfunc->set_product_remove_startpage_sql($_GET['pID'], $_GET['flag']);
					if ($_GET['flag'] == '0') xtc_redirect(xtc_href_link(FILENAME_CATEGORIES));
				}
			}
			if ($_GET['pID']) {
				xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath='.$_GET['cPath'].'&pID='.$_GET['pID']));
			} else {
				xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath='.$_GET['cPath'].'&cID='.$_GET['cID']));
			}
			break;
			//EOB setsflag
		
		case 'unlink_startpage' :
			if(!empty($_GET['products_id'])) {
				xtc_db_query("DELETE FROM ".TABLE_PRODUCTS_TO_CATEGORIES." WHERE products_id = '".(int)$_GET['products_id']."' AND categories_id = '0' ");
				xtc_db_query("UPDATE products SET products_startpage = '0', products_startpage_sort = '0' WHERE products_id = '".(int)$_GET['products_id']."' ");
				xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath=0'));
			}
			xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath=0'));
			break;
		
		case 'update_category' :
			$catfunc->insert_category($_POST, '', 'update');
			if(MODULE_COMMERCE_SEO_INDEX_STATUS == 'True' && CSEO_URL_ADMIN_ON == 'true')
				$commerceSeo->updateSeoDBTable('category','update', $_POST['categories_id']);
			break;

		case 'insert_category' :
			$catfunc->insert_category($_POST, $current_category_id);
			if(MODULE_COMMERCE_SEO_INDEX_STATUS == 'True' && CSEO_URL_ADMIN_ON == 'true')
				$commerceSeo->insertSeoDBTable('category');
			break;

		case 'update_product' :
			$catfunc->insert_product($_POST, '', 'update');
			if(MODULE_COMMERCE_SEO_INDEX_STATUS == 'True' && CSEO_URL_ADMIN_ON == 'true')
				$commerceSeo->updateSeoDBTable('product','update', $_POST['products_id']);
			break;

		case 'insert_product' :
			$catfunc->insert_product($_POST, $current_category_id);
			if(MODULE_COMMERCE_SEO_INDEX_STATUS == 'True' && CSEO_URL_ADMIN_ON == 'true')
				$commerceSeo->insertSeoDBTable('product');
			break;

		case 'edit_crossselling' :
			$catfunc->edit_cross_sell($_GET);
			break;
			
		case 'multi_action_confirm' :

			// --- MULTI DELETE ---
			if (isset ($_POST['multi_delete_confirm'])) {
				//delete multi_categories
				if (is_array($_POST['multi_categories'])) {
					foreach ($_POST['multi_categories'] AS $category_id) {
						$catfunc->remove_categories($category_id);
					}
				}
				//delete multi_products
				if (is_array($_POST['multi_products']) && is_array($_POST['multi_products_categories'])) {
					foreach ($_POST['multi_products'] AS $product_id) {
						$catfunc->delete_product($product_id, $_POST['multi_products_categories'][$product_id]);
					}
				}
				if(MODULE_COMMERCE_SEO_INDEX_STATUS == 'True' && CSEO_URL_ADMIN_ON == 'true')
					$commerceSeo->createSeoDBTable();
			}
			// --- MULTI DELETE ENDS ---

			// --- MULTI MOVE ---
			if (isset ($_POST['multi_move_confirm'])) {
				//move multi_categories
				if (is_array($_POST['multi_categories']) && xtc_not_null($_POST['move_to_category_id'])) {
					foreach ($_POST['multi_categories'] AS $category_id) {
						$dest_category_id = xtc_db_prepare_input($_POST['move_to_category_id']);
						if ($category_id != $dest_category_id) {
							$catfunc->move_category($category_id, $dest_category_id);
						}
						
					}
					if(MODULE_COMMERCE_SEO_INDEX_STATUS == 'True' && CSEO_URL_ADMIN_ON == 'true')
						$commerceSeo->createSeoDBTable();
				}
				//move multi_products
				if (is_array($_POST['multi_products']) && xtc_not_null($_POST['move_to_category_id']) && xtc_not_null($_POST['src_category_id'])) {
					foreach ($_POST['multi_products'] AS $product_id) {
						$product_id = xtc_db_prepare_input($product_id);
						$src_category_id = xtc_db_prepare_input($_POST['src_category_id']);
						$dest_category_id = xtc_db_prepare_input($_POST['move_to_category_id']);
						$catfunc->move_product($product_id, $src_category_id, $dest_category_id);
					}
					if(MODULE_COMMERCE_SEO_INDEX_STATUS == 'True' && CSEO_URL_ADMIN_ON == 'true')
						$commerceSeo->createSeoDBTable();
				}
				xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath='.$dest_category_id.'&'.xtc_get_all_get_params(array ('cPath', 'action', 'pID', 'cID'))));
			}
			// --- MULTI MOVE ENDS ---

			// --- MULTI COPY ---
			if (isset ($_POST['multi_copy_confirm'])) {
				//copy multi_categories
				if (is_array($_POST['multi_categories']) && (is_array($_POST['dest_cat_ids']) || xtc_not_null($_POST['dest_category_id']))) {
					$_SESSION['copied'] = array ();
					foreach ($_POST['multi_categories'] AS $category_id) {
						if (is_array($_POST['dest_cat_ids'])) {
							foreach ($_POST['dest_cat_ids'] AS $dest_category_id) {
								if ($_POST['copy_as'] == 'link') {
									$catfunc->copy_category($category_id, $dest_category_id, 'link');
								}
								elseif ($_POST['copy_as'] == 'duplicate') {
									$catfunc->copy_category($category_id, $dest_category_id, 'duplicate');
								} else {
									$messageStack->add_session('Copy type not specified.', 'error');
								}
							}
						}
						elseif (xtc_not_null($_POST['dest_category_id'])) {
							if ($_POST['copy_as'] == 'link') {
								$catfunc->copy_category($category_id, $dest_category_id, 'link');
							}
							elseif ($_POST['copy_as'] == 'duplicate') {
								$catfunc->copy_category($category_id, $dest_category_id, 'duplicate');
							} else {
								$messageStack->add_session('Copy type not specified.', 'error');
							}
						}
					}
					unset ($_SESSION['copied']);
				}
				//copy multi_products
				if (is_array($_POST['multi_products']) && (is_array($_POST['dest_cat_ids']) || xtc_not_null($_POST['dest_category_id']))) {
					foreach ($_POST['multi_products'] AS $product_id) {
						$product_id = xtc_db_prepare_input($product_id);
						if (is_array($_POST['dest_cat_ids'])) {
							foreach ($_POST['dest_cat_ids'] AS $dest_category_id) {
								$dest_category_id = xtc_db_prepare_input($dest_category_id);
								if ($_POST['copy_as'] == 'link') {
									$catfunc->link_product($product_id, $dest_category_id);
								}
								elseif ($_POST['copy_as'] == 'duplicate') {
									$catfunc->duplicate_product($product_id, $dest_category_id);
								} else {
									$messageStack->add_session('Copy type not specified.', 'error');
								}
							}
						}
						elseif (xtc_not_null($_POST['dest_category_id'])) {
							$dest_category_id = xtc_db_prepare_input($_POST['dest_category_id']);
							if ($_POST['copy_as'] == 'link') {
								$catfunc->link_product($product_id, $dest_category_id);
							}
							elseif ($_POST['copy_as'] == 'duplicate') {
								$catfunc->duplicate_product($product_id, $dest_category_id);
							} else {
								$messageStack->add_session('Copy type not specified.', 'error');
							}
						}
					}
				}
				if(MODULE_COMMERCE_SEO_INDEX_STATUS == 'True' && CSEO_URL_ADMIN_ON == 'true')
					$commerceSeo->createSeoDBTable();
				xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath='.$dest_category_id.'&'.xtc_get_all_get_params(array ('cPath', 'action', 'pID', 'cID'))));
			}
			// --- MULTI COPY ENDS ---

			xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath='.$_GET['cPath'].'&'.xtc_get_all_get_params(array ('cPath', 'action', 'pID', 'cID'))));
			break;
			#EOB multi_action_confirm

	}
}

// check if the catalog image directory exists
if (is_dir(DIR_FS_CATALOG_IMAGES)) {
	if (!is_writeable(DIR_FS_CATALOG_IMAGES)) {
		$messageStack->add(ERROR_CATALOG_IMAGE_DIRECTORY_NOT_WRITEABLE, 'error');
	}
} else {
	$messageStack->add(ERROR_CATALOG_IMAGE_DIRECTORY_DOES_NOT_EXIST, 'error');
}

if ($_GET['action'] == 'new_product') {
	require_once('../'.DIR_WS_INCLUDES.'/xajax/xajax_core/xajax_admin.inc.php');
	$xajax = new xajax();
	require(DIR_FS_ADMIN.DIR_WS_INCLUDES.'javascript/xajaxfunctions.php');
	$xajax->processRequest();
	$xajax->printJavascript();
}
require(DIR_WS_INCLUDES.'header.php');
?>

<script type="text/javascript" src="includes/javascript/categories.js"></script>
<script type="text/javascript" src="includes/javascript/tooltip.js"></script>

<div id="spiffycalendar" class="text"></div>
	<table width="100%" cellspacing="0" cellpadding="0">
		<?php
			if ($_GET['action'] == 'new_category' || $_GET['action'] == 'edit_category') {
				include (DIR_WS_MODULES.'new_category.php');
			} elseif ($_GET['action'] == 'new_product') {
				include (DIR_WS_MODULES.'new_product.php');
			} elseif ($_GET['action'] == 'edit_crossselling') {
				include (DIR_WS_MODULES.'cross_selling.php');
			} else {
				if (!$cPath) {
					$cPath = '0'; 
				} 
				include (DIR_WS_MODULES.'categories_view.php'); 
			}
		?>
	</table>
<?php 
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');