<?php
/*-----------------------------------------------------------------
* 	ID:						xajax.cseofunctions.php
* 	Letzter Stand:			v2.2 R365
* 	zuletzt geaendert von:	akausch
* 	Datum:					2012/07/03
*
* 	Copyright (c) since 2010 commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
* 	Released under the GNU General Public License
* ---------------------------------------------------------------*/


require_once (DIR_FS_INC.'xtc_parse_search_string.inc.php');

function zeichen_ersetzen($string) {
	$string = str_replace('%E4', "&auml;", $string);
	$string = str_replace('%FC', "&uuml;", $string);
	$string = str_replace('%F6', "&ouml;", $string);
	$string = str_replace('%DF', "&szlig;", $string);
	return $string;
}
function kerimsuche($suchtext) {
	$suchtext = urldecode(zeichen_ersetzen($suchtext));
	if (strlen($suchtext) > 0) {
		if (!xtc_parse_search_string(stripslashes($suchtext), $search_keywords)) {
			$errorno += 10000000;
			$error = 1;
			$keyerror = 1;
		}
	}
	// define additional filters //
	//fsk18 lock
	if ($_SESSION['customers_status']['customers_fsk18_display'] == '0') {
		$fsk_lock = " AND p.products_fsk18 != '1' ";
	} else {
		unset ($fsk_lock);
	}
	//group check
	if (GROUP_CHECK == 'true') {
		$group_check = " AND p.group_permission_".$_SESSION['customers_status']['customers_status_id']."=1 ";
	} else {
		unset ($group_check);
	}
	//build query
	$select_str = "SELECT distinct
					p.products_id,
					p.products_model,
					p.products_fsk18,
					p.products_image,
					p.products_slave_in_list,
					p.products_master,
					pd.products_name,
					pd.products_description ";
	
	$from_str  = "FROM ".TABLE_PRODUCTS." AS p LEFT JOIN ".TABLE_PRODUCTS_DESCRIPTION." AS pd ON (p.products_id = pd.products_id) ";
	if (SEARCH_IN_ATTR == 'true') { 
		$from_str .= " LEFT OUTER JOIN ".TABLE_PRODUCTS_ATTRIBUTES." AS pa ON (p.products_id = pa.products_id) LEFT OUTER JOIN ".TABLE_PRODUCTS_OPTIONS_VALUES." AS pov ON (pa.options_values_id = pov.products_options_values_id) "; 
	}

	//where-string
	$where_str = " WHERE 
						p.products_status = '1' 
					AND 
						(p.products_slave_in_list = '1' OR p.products_master = '1' OR ((p.products_slave_in_list = '0' OR p.products_slave_in_list = '') AND (p.products_master_article = '' OR p.products_master_article = '0')))						
					AND 
						pd.language_id = '".(int) $_SESSION['languages_id']."'".
					$fsk_lock.$group_check;

	//go for keywords... this is the main search process
	if (isset ($suchtext) && xtc_not_null($suchtext)) {
		if (xtc_parse_search_string(stripslashes($suchtext), $search_keywords)) {
			$where_str .= " AND ( ";
			for ($i = 0, $n = sizeof($search_keywords); $i < $n; $i ++) {
				switch ($search_keywords[$i]) {
					case '(' :
					case ')' :
					case 'and' :
					case 'or' :
						$where_str .= " ".$search_keywords[$i]." ";
						break;
					default :
						$where_str .= " ( ";
						$where_str .= "pd.products_keywords LIKE ('%".utf8_encode(html_entity_decode(addslashes($search_keywords[$i])))."%') ";
						$where_str .= "OR pd.products_name LIKE ('%".utf8_encode(html_entity_decode(addslashes($search_keywords[$i])))."%') ";
						$where_str .= "OR p.products_model LIKE ('%".utf8_encode(html_entity_decode(addslashes($search_keywords[$i])))."%') ";
						if (SEARCH_IN_DESC == 'true') {
						   $where_str .= "OR pd.products_description LIKE ('%".utf8_encode(html_entity_decode(addslashes($search_keywords[$i])))."%') ";
						}						
						
						if (SEARCH_IN_ATTR == 'true') {
						   $where_str .= "OR (pov.products_options_values_name LIKE ('%".utf8_encode(html_entity_decode(addslashes($search_keywords[$i])))."%') ";
						   $where_str .= "AND pov.language_id = '".(int) $_SESSION['languages_id']."')";
						}
						$where_str .= " ) ";
						break;
				}
			}
			$where_str .= " ) ORDER BY pd.products_name";
		}
	}
	//glue together
	$sql = $select_str.$from_str.$where_str;
	require_once(DIR_WS_CLASSES.'class.xtcprice.php');
	$xtPrice = new xtcPrice($_SESSION['currency'], $_SESSION['customers_status']['customers_status_id']);
	$result = "";
	$objResponse = new xajaxResponse();
	if (strlen($suchtext)>3) {
		$result .= "<div class='suggest_intro'>" . AUTOSUGGEST_INTRO . "</div>";
		$product_query = xtc_db_query($sql);
		$counter = 0;
		$more_result = 'false';
		while($product_array = xtc_db_fetch_array($product_query)) {
			$counter++;
			if ($counter <= 10) {
				$image = '';
				if ($product_array['products_image'] == '')
					$product_array['products_image'] = 'no_img.jpg';
				if ($product_array['products_image'] != '' && file_exists(DIR_WS_MINI_IMAGES.$product_array['products_image'])) {
					$image = DIR_WS_MINI_IMAGES.$product_array['products_image'];
					$image = '<div id="suggest_image"><img src="'.$image.'" /></div>';
				}
				$result .= '<div class="suggest_link">';
	            $result .= '<div>
								<div class="suggest_image">
									' . $image . '
								</div>
								<div class="suggest_productsname" id="suggestlink">
									<a href="'.xtc_href_link(FILENAME_PRODUCT_INFO, xtc_product_link($product_array['products_id'], $product_array['products_name'])).'">' . htmlentities(utf8_decode($product_array['products_name'])) . '</a>
								</div>
							</div>';
	            $result .= '</div>';
			} else {
				$more_result = 'true';
			}
        }
		if ($counter == 0) {
			$result = '<div class="suggest_no_products">' . AUTOSUGGEST_NO_PRODUCTS . '</div>';
			$objResponse->addAssign("search_suggest", "style.height", '65px');
		} else {			
			if ($counter < 12) {
				$objResponse->addAssign("search_suggest", "style.height", (($counter*36)+195).'px');
			} else {
				$objResponse->addAssign("search_suggest", "style.height", '590px');
			}
		}
		$result .= '<div class="suggest_close"><a onclick="suggestClose(this);return false" class="suggestclose_link">'.AUTOSUGGEST_CLOSE.'</a></div>';
		if($more_result == 'true') {
			$result .= '<div class="suggest_more"><a';
			$result .= " onclick='javascript:more_result(\"".$suchtext."\");'  id='suggestmore_link'>";
			$result .= ''.MORE_RESULTS.'</a></div>';
		}
		$objResponse->addAssign("search_suggest", "style.display", 'block');
        $objResponse->addAssign("search_suggest", "innerHTML", $result);
	} else {
        $objResponse->addAssign("search_suggest", "style.display", 'none');
    }
	return $objResponse;
}

#########################################################
# Filter XAJAX
#########################################################

	function getFilterItems($aFormValues) {
	#region Globale Variable
		$objResponse = new xajaxResponse();
		$fItems = array();
		$in = "";
	#endregion
		
		if(is_array($aFormValues)) {
			$post_array = $aFormValues;
			$filter_items = $post_array['filter'];
			// $filter_items = $post_array['filter_items'];

		} else {
			$zeichenkette = $aFormValues;

			// BOF filter_items raussuchen
			$suchmuster = '/\[(.*?)\]/i';

			preg_match($suchmuster, $zeichenkette, $treffer);

			$new_clean = str_replace('"', '', $treffer[1]);

			$new_explode = explode('&', $new_clean);

			$filter_items = $new_explode;
			// EOF

			// String zu Array umwandlen
			$zeichenkette = str_replace('"', '', $zeichenkette);
			$zeichenkette = str_replace('{', '', $zeichenkette);
			$zeichenkette = str_replace('}', '', $zeichenkette);

			$exploded = explode('&', $zeichenkette);
			
	#region muss überarbeitet werden:
			for($i=0; sizeof($exploded) > $i; $i++) {
				$trennen = explode('=', $exploded[$i]);
				if($trennen[0] != '' && $trennen[1] !='' && !strstr($trennen[1], '[') && !strstr($trennen[1], ']'))
					$post_array[$trennen[0]] = $trennen[1];
			}
	#endregion
			
			$tmp = array();
			$k = 0;
			for($i = 0; sizeof($exploded) > $i; $i++) {
				if(strpos($exploded[$i], 'filter') !== false)
				{
					$tmp[$i] = explode('=', $exploded[$i]);
					$fItems[$k] = $tmp[$i][1];
					$k++;	//$fItems benötigt 2. Zählvariable, damit sie von null an indiziert wird!
				}
				else
					continue;					
			}
		}
		
		for($i = 0; $i < sizeof($fItems); $i++) {
			if($i == 0)
				$in .= (int)$fItems[$i];	//ohne char-markierung (')!
			else
				$in .= ",".(int)$fItems[$i];
	#region auskommentiert:
			#$objResponse->alert('Ein neues Array'."\n".print_r($fItems, true));
			#$objResponse->alert('in: '."\n".$in);
	#endregion
		}

		$having = '';
		if($post_array['verbinder'] == 'true' && $in !='')
			$having = "HAVING CHAR_LENGTH(filter) > ".(strlen(str_replace('\'', '', $in)) - 1);
		
		#$objResponse->alert('Having'."\n".print_r($having, true));
		
		if($in !='') {
			$data_query = xtDBquery("SELECT
											GROUP_CONCAT(p2f.filter_id) AS filter,
											p2f.products_id
										FROM
											products_to_filter p2f,
											product_filter_items fi
										WHERE
											p2f.filter_id IN(".$in.")
										AND
											fi.id = p2f.filter_id
										GROUP BY
											p2f.products_id ".$having);

			while($data = xtc_db_fetch_array($data_query)){
				if($products_ids != '')
					$products_ids .= ",'".$data['products_id']."'";
				else
				$products_ids = "'".$data['products_id']."'";
			}

			if($products_ids =='')
				$products_ids = "''";

			if ($_SESSION['customers_status']['customers_fsk18_display'] == '0')
				$fsk_lock = " AND p.products_fsk18 != '1' ";
			else
				unset($fsk_lock);

			if (GROUP_CHECK == 'true')
				$group_check = " AND p.group_permission_".$_SESSION['customers_status']['customers_status_id']."=1 ";
			else
				unset($group_check);

			//build query
			$select_str = "SELECT
							  p.products_id,
							  p.products_price,
							  p.products_model,
							  p.products_quantity,
							  p.products_shippingtime,
							  p.products_fsk18,
							  p.products_image,
							  p.products_weight,
							  p.products_tax_class_id,
							  pd.products_name,
							  pd.products_short_description ";

			$from_str = "FROM ".TABLE_PRODUCTS." AS p LEFT JOIN ".TABLE_PRODUCTS_DESCRIPTION." AS pd ON (p.products_id = pd.products_id) ";

			if($post_array['per_site'] == 'all')
				$limit = '';
			elseif(!empty($post_array['per_site']))
				$limit = ' LIMIT '.$post_array['per_site'];

			$where_str = " WHERE
								p.products_id
							IN
								(".$products_ids.")
							AND
								p.products_status = '1'
							AND
								pd.language_id = '".(int)$_SESSION['languages_id']."'".$fsk_lock.$group_check.$limit;
			unset($_SESSION['filters']);
			foreach ($_SESSION['filter_id'] AS $id) {
				$name = xtc_db_fetch_array(xtDBquery("SELECT id, title
																FROM ".TABLE_PRODUCT_FILTER_ITEMS."
																WHERE id = '".$id."'
																AND language_id = '".$_SESSION['languages_id']."'"));
				if($namen != '')
					$namen .= ', '.$name['title'];
				else
					$namen = $name['title'];
				$_SESSION['filters'][] = $name;

			}
			$smarty = new Smarty;
			$smarty->caching = 0;
			$smarty->assign('language', $_SESSION['language']);
			$listing_sql = $select_str.$from_str.$where_str;
			require_once(DIR_WS_MODULES.'product_filter_listing_ajax.php');
		}
		$objResponse->assign('filter_result', 'innerHTML', $output);
		$objResponse->script('jQuery("#loadingMessage").hide();jQuery("#results").show();jQuery("#filter_result").show();');
		return $objResponse;
	}

#########################################################
# Filter XAJAX
#########################################################


##############################################################
# XAJAX Price
##############################################################
// if (PRODUCT_ID > 0 && strpos($PHP_SELF, FILENAME_SHOPPING_CART) === false) {
	function getNewPrice($values) {

		$has_attr_price = false;
		$has_staffel_price = false;
		$has_special_price = false;
		$has_discount_price = false;

		$objResponse = new xajaxResponse();
		$get = urldecode($values);
		$post = explode('&', $get);

		foreach($post as $posts) {
			list($key, $value) = explode('=', $posts);

			if(strstr($key, 'id['))
				$id[str_replace('id[','',str_replace(']','',$key))] = $value;

			if($key == 'products_qty')
				$qty = $value;

			if($key == 'products_update_id')
				$pid = $value;
		}
		if($qty > 0) {
			$product = new product($pid);
			$price = new xtcPrice($_SESSION['currency'], $_SESSION['customers_status']['customers_status_id']);
			
			$main_price = $price->xtcGetPrice($pid, false, $qty, $product->data['products_tax_class_id']);
			
			// Staffelpreise vorhanden?
			$check_staffel = $price->xtcGetGraduatedPrice($pid, $qty);
			// $objResponse->alert('val: '."\n".$$main_price);
			
			if($check_staffel && $_SESSION['customers_status']['customers_status_graduated_prices'] == 1) {
				$staffel = ' <span class="product_staffel_price">('.SINGLE_PRICE.' '.$price->xtcFormat($check_staffel, true, $product->data['products_tax_class_id']).')</span>';
				$has_staffel_price = true;
			}
			
			// $attribut_check = $price->checkAttributes($pid);
			// if ($attribut_check) {
				// $has_attr_price = true;
			// }
			
			$special_price = $price->xtcCheckSpecial($pid);
			if ($special_price) {
				// $objResponse->alert('val: '."\n".$special_price);
				$has_special_price = true;
			}
			
			if(is_array($id)) {
				foreach($id AS $skey => $sval) {
					$attr_price = xtc_db_fetch_array(xtDBquery("SELECT
														pd.products_discount_allowed,
														pd.products_tax_class_id,
														p.options_values_price,
														p.price_prefix,
														p.options_values_weight,
														p.weight_prefix
													FROM
														".TABLE_PRODUCTS_ATTRIBUTES." p,
														".TABLE_PRODUCTS." pd
													WHERE
														p.products_id = '".$pid."'
													AND
														p.options_id = '".$skey."'
													AND
														pd.products_id = p.products_id
													AND
														p.options_values_id = '".$sval."'"));
					
					if($attr_price['options_values_price'] > '0.0000') {
						$has_attr_price = true;
					}

					$val_price = $price->xtcFormat($attr_price['options_values_price'], false, $attr_price['products_tax_class_id']);

					if($price->cStatus['customers_status_discount_attributes'] == 1 && $price->cStatus['customers_status_discount'] != 0.00) {
						$discount = $price->cStatus['customers_status_discount'];
						if($attr_price['products_discount_allowed'] < $price->cStatus['customers_status_discount']) {
							$discount = $attr_price['products_discount_allowed'];
						}

						$has_discount_price = true;

					} elseif ($price->cStatus['customers_status_discount_attributes'] != 1 && $price->cStatus['customers_status_discount'] != 0.00) {
						$discount = $price->cStatus['customers_status_discount'];
						if($attr_price['products_discount_allowed'] < $price->cStatus['customers_status_discount']) {
							$discount = $attr_price['products_discount_allowed'];
						}
						
						$has_discount_price = true;
					} else {
						$has_discount_price = false;
					}
					
					
					// $val_price = $val_price;
					// $val_price = ($val_price - $val_price / 100 * $discount) * $qty;
					// $objResponse->alert('val: '."\n".$price->cStatus['customers_status_discount']);
					
					if ($attr_price['price_prefix'] == '+') {
						$main_price += ($val_price - $val_price / 100 * $discount);
						$attribute_price += $val_price;
					} else {
						// Normalerweise hier auch Rabatt, aber da bei Attributen auch nicht, dann ebend nicht
						$main_price -= $val_price;
						$attribute_price -= $val_price;
					}
				}
			}	
			
			$old_price = '<div class="product_ajax_price">('.trim($price->xtcGetPrice($pid, true, 1, $product->data['products_tax_class_id'])).')</div>';
			
			// $objResponse->alert('val: '."\n".$main_price);
			if ($main_price <> ($main_price+$attribute_price)) {
				//Preis mit Attributen und Aufpreis
				$main_price = $price->xtcFormat($main_price*$qty, true).$old_price;
				
			} elseif (!is_array($id) && !$has_attr_price && !$has_staffel_price && !$has_special_price && $qty > 1) {
				//Preis alleine
				$main_price = $price->xtcFormat($main_price, true).'<div class="product_ajax_price">('.FROM.trim($price->xtcGetPrice($pid, true, 1, $product->data['products_tax_class_id'])).')</div>';
				
				 //$objResponse->alert('val: '."\n".$qty);
			} elseif ($has_attr_price) {
			
				// $objResponse->alert('val: '."\n".$qty);
				// $objResponse->alert('val: '."\n".$main_price);
				// $objResponse->alert('val: '."\n".$attribute_price);
				$main_price = $price->xtcFormat($main_price*$qty, true).$old_price;
			} elseif ($has_staffel_price) {
				$min_price = xtc_db_fetch_array(xtDBquery("SELECT 
												MIN(personal_offer) as min_price 
											FROM 
												".TABLE_PERSONAL_OFFERS_BY.$price->actualGroup." 
											WHERE 
												products_id = '".$pid."' "));
				
				$possible_qty = xtc_db_fetch_array(xtDBquery("SELECT 
													MAX(quantity) AS qty 
												FROM 
													".TABLE_PERSONAL_OFFERS_BY.$price->actualGroup." 
												WHERE 
													products_id = '".$pid."' 
												AND 
													quantity <= '".$qty."'"));
				
				$max_qty = xtc_db_fetch_array(xtDBquery("SELECT 
													MAX(quantity) AS qty 
												FROM 
													".TABLE_PERSONAL_OFFERS_BY.$price->actualGroup." 
												WHERE 
													products_id = '".$pid."'"));
				
				$staffel_preis = xtc_db_fetch_array(xtDBquery("SELECT 
													personal_offer 
												FROM 
													".TABLE_PERSONAL_OFFERS_BY.$price->actualGroup." 
												WHERE 
													products_id = '".$pid."' 
												AND 
													quantity = '".$possible_qty['qty']."'"));
															
				$final_price = $price->xtcAddTax($check_staffel*$qty, $price->TAX[$product->data['products_tax_class_id']]);
				$main_price = $price->xtcFormat($final_price, true).'<div class="product_ajax_price">('.SINGLE_PRICE.($qty<$max_qty['qty']?'bei '.$qty:FROM.$max_qty['qty']).' Stk. = '.$price->xtcFormat($price->xtcAddTax($staffel_preis['personal_offer'], $price->TAX[$product->data['products_tax_class_id']]), true).')</div>';
			} elseif ($has_special_price) {
				//Sonderpreis
				$main_price = $price->xtcFormatSpecial($pID, $price->xtcAddTax(($special_price*$qty), $price->TAX[$product->data['products_tax_class_id']]), $price->xtcAddTax($price->getPprice($pid), $price->TAX[$product->data['products_tax_class_id']]), true, 0, $qty);
			} elseif ($qty > 1) {
				//Normalpreis Menge >1
				$main_price = $price->xtcFormat($main_price*$qty, true).' <div class="product_ajax_price">('.SINGLE_PRICE.trim($price->xtcGetPrice($pid, true, 1, $product->data['products_tax_class_id'])).')</div>';
			} elseif ($has_discount_price) {
				// Produkt Rabatt
				$main_price = '<div class="product_ajax_price">'.trim($price->xtcGetPrice($pid, true, 1, $product->data['products_tax_class_id'])).'</div>';
				
			} else {
				$main_price = $price->xtcFormat($main_price, true);
				
			}

			$objResponse->assign('product_info_price', 'innerHTML', $main_price);
		}
		return $objResponse;
	}
// }

##############################################################
# XAJAX Price
##############################################################


##############################################################
# XAJAX Filter
##############################################################
if ($_SESSION['fb_attributes'] != '') {
	//needet Fuctions
	function convertToVars($query_string) {
		$vars = array();
		if (!is_array($query_string)) {
			$arr_vars = explode('&',$query_string);
			foreach ($arr_vars as $value) {
				$arr_vars2 = explode('=',$value);
				$vars[$arr_vars2[0]] = urldecode($arr_vars2[1]);
			}
		} else {
			reset($query_string);
			while (list($key, $value) = each ($query_string)) {
				$vars[$key] = $value;
			}
		}
		return $vars;
	}

	$ids = '';
	$cached_cats = array();
	function xtc_get_subcategory_ids($parent_id = '0') {
		global $ids;
		global $cached_cats;
		
		$first_query = xtDBquery("SELECT DISTINCT categories_id FROM ".TABLE_CATEGORIES." WHERE parent_id = '".$parent_id."' AND categories_status > 0");
		if (xtc_db_num_rows($first_query) > 0) {
			while ($row = xtc_db_fetch_array($first_query)) {
				$ids .= ','.$row['categories_id'];
				xtc_get_subcategory_ids($row['categories_id']);
			}
		}
		
		$cached_cats[$parent_id] = substr($ids, 1);
		$parent_id_pos = strpos($cached_cats[$parent_id], ','.$parent_id);
		if ($parent_id_pos !== false) {
			$cached_cats[$parent_id] = substr(substr($cached_cats[$parent_id], $parent_id_pos), 1);
		}
		return $ids;
	}

	$subsubs = array();
	$spacer = ' &nbsp; &nbsp;';
	function xtc_get_subcategory_names($parent_id = '0', $first = false) {
		global $subsubs;
		global $spacer;
		if ($first) $subsubs = array();
		
		$first_query = xtDBquery("SELECT cd.categories_name, cd.categories_id FROM ".TABLE_CATEGORIES." c, ".TABLE_CATEGORIES_DESCRIPTION." cd WHERE c.parent_id = '".$parent_id."' AND cd.categories_id = c.categories_id AND c.categories_status > 0 AND cd.language_id = '".$_SESSION['languages_id']."'");
		if (xtc_db_num_rows($first_query) > 0) {
			while ($row = xtc_db_fetch_array($first_query)) {
				$has_relevant_subs = false;
				
				$check_subsubs = xtDBquery("SELECT p.products_id FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_TO_CATEGORIES." tc WHERE p.products_id = tc.products_id AND p.products_status > 0 AND p.products_quantity > 0 AND p.manufacturers_id = '".$_SESSION['fb_manufacturer_id']."' AND tc.categories_id IN (".$_SESSION['fb_cat_cached'][$row['categories_id']].")");
				$ids = '';
				
				if (xtc_db_num_rows($check_subsubs) > 0) $has_relevant_subs = true;
				
				if ($has_relevant_subs) {		
					$subsubs[] = array('id' => $row['categories_id'], 'text' => $spacer.'&rarr; '.$row['categories_name']);
					$old_spacer = $spacer;
					$spacer .= $spacer;			
					xtc_get_subcategory_names($row['categories_id']);
					$spacer = $old_spacer;
				}
			}
		}
	}

	//End Functions


	if (!is_array($_SESSION['fb_cat_cached'])) {
		xtc_get_subcategory_ids();
		$_SESSION['fb_cat_cached'] = $cached_cats;
	}

	function getSubCategories($manufacturer_id) {
		unset($_SESSION['fb_attributes']);
		$_SESSION['fb_manufacturer_id'] = $manufacturer_id;
		$objResponse = new xajaxResponse();
		$subcategory = array();
		$category_query = xtDBquery("SELECT categories_id FROM ".TABLE_CATEGORIES." WHERE parent_id = '0' AND categories_status > 0"); 
		
		while ($row1 = xtc_db_fetch_array($category_query)) {
			
			$subcategory[$row1['categories_id']] = array();
			$subcategory[$row1['categories_id']][] = array('id' => '_def_', 'text' => '-- '.PULL_DOWN_DEFAULT.' --');
			
			$subcategory_query = xtDBquery("SELECT cd.categories_name, cd.categories_id FROM ".TABLE_CATEGORIES." c, ".TABLE_CATEGORIES_DESCRIPTION." cd WHERE c.parent_id = '".$row1['categories_id']."' AND c.categories_status > 0 AND cd.categories_id = c.categories_id AND cd.language_id = '".$_SESSION['languages_id']."'");
			if (xtc_db_num_rows($subcategory_query) > 0) {		
				while ($row2 = xtc_db_fetch_array($subcategory_query)) {
					$has_relevant_subs = false;
					
					$check_subsubs = xtDBquery("SELECT p.products_id FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_TO_CATEGORIES." tc WHERE p.products_id = tc.products_id AND p.products_status > 0 AND p.products_quantity > 0 AND p.manufacturers_id = '".$_SESSION['fb_manufacturer_id']."' AND tc.categories_id IN (".($_SESSION['fb_cat_cached'][$row2['categories_id']] ? $_SESSION['fb_cat_cached'][$row2['categories_id']] : $row2['categories_id']).")");
					$ids = '';
					
					if (xtc_db_num_rows($check_subsubs) > 0) $has_relevant_subs = true;
								
					if ($has_relevant_subs) {
						// yes, relevant!
						$subcategory[$row1['categories_id']][] = array('id' => $row2['categories_id'], 'text' => $row2['categories_name']);
						global $subsubs;
						$subsubs = array();
						xtc_get_subcategory_names($row2['categories_id'], true);
						$subcategory[$row1['categories_id']] = array_merge($subcategory[$row1['categories_id']], $subsubs);
					}
				}
			
			
				$objResponse->assign('c_select_subcategory_'.$row1['categories_id'], 'style.display', 'block');
				$objResponse->assign('select_subcategory_'.$row1['categories_id'], 'innerHTML', xtc_draw_pull_down_menu('sel_subcategories_'.$row1['categories_id'], $subcategory[$row1['categories_id']], '_def_', 'style="width:100%;" onchange="if (this.value!=\'\') { document.getElementById(\'fb_loader\').style.display = \'inline\'; xajax_getOptions(this.value, this.name.substring(18)); }"'));
				
				if (sizeof($subcategory[$row1['categories_id']]) > 1) {
					$objResponse->assign('c_select_category_'.$row1['categories_id'], 'style.display', 'block');
				} else {
					$objResponse->assign('c_select_category_'.$row1['categories_id'], 'style.display', 'none');
				}
			} else {
				$check_subsubs = xtDBquery("SELECT p.products_id FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_TO_CATEGORIES." tc WHERE p.products_id = tc.products_id AND p.products_status > 0 AND p.products_quantity > 0 AND p.manufacturers_id = '".$_SESSION['fb_manufacturer_id']."' AND tc.categories_id = '".$row1['categories_id']."'");
				$objResponse->assign('c_select_subcategory_'.$row1['categories_id'], 'style.display', 'none');
				if (xtc_db_num_rows($check_subsubs) > 0) {
					$objResponse->assign('c_select_category_'.$row1['categories_id'], 'style.display', 'block');
					$objResponse->script('xajax_getOptions("'.$row1['categories_id'].'", "'.$row1['categories_id'].'");');
					$still_ajax = true;
				} else {
					$objResponse->assign('c_select_category_'.$row1['categories_id'], 'style.display', 'none');
				}
			}
			$objResponse->assign('c_select_options_'.$row1['categories_id'], 'style.display', 'none');
			$objResponse->assign('c_select_options_'.$row1['categories_id'], 'innerHTML', '');
			
		}

		if (!$still_ajax) $objResponse->assign('fb_loader', 'style.display', 'none');
		return $objResponse;
	}

	function getOptions($category_id, $parent_id) { 
		$objResponse = new xajaxResponse();
		$_SESSION['fb_subcategory_id'] = $category_id;
		$_SESSION['fb_category_id'] = $parent_id;
		
		// get options
		$options_query = xtDBquery("SELECT DISTINCT pa.options_id, po.products_options_name FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_TO_CATEGORIES." tc, ".TABLE_PRODUCTS_ATTRIBUTES." pa, ".TABLE_PRODUCTS_OPTIONS." po WHERE tc.products_id = p.products_id AND pa.products_id = p.products_id AND po.products_options_id = pa.options_id AND tc.categories_id = '".$category_id."' AND p.products_status > 0 AND p.products_quantity > 0 AND p.manufacturers_id = '".$_SESSION['fb_manufacturer_id']."' AND po.language_id = '".$_SESSION['languages_id']."'".(ATTRIBUTE_STOCK_CHECK == 'true' ? ' AND pa.attributes_stock > 0' : ''));
		$html = '';
		
		while ($row1 = xtc_db_fetch_array($options_query)) {
			$select = array();
			$select[] = array('id' => '_all_', 'text' => '-- '.PULL_DOWN_DEFAULT.' --');
			
			$attributes_query = xtDBquery("SELECT * FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_ATTRIBUTES." pa, ".TABLE_PRODUCTS_OPTIONS_VALUES." pov, ".TABLE_PRODUCTS_TO_CATEGORIES." tc WHERE tc.products_id = p.products_id AND tc.categories_id = '".$category_id."' AND p.products_id = pa.products_id AND p.products_status > 0 AND p.products_quantity > 0 AND p.manufacturers_id = '".$_SESSION['fb_manufacturer_id']."' AND pov.products_options_values_id = pa.options_values_id AND pov.language_id = '".$_SESSION['languages_id']."' AND pa.options_id = '".$row1['options_id']."'".(ATTRIBUTE_STOCK_CHECK == 'true' ? ' AND pa.attributes_stock > 0' : '')." GROUP BY pa.options_values_id");
			
			while ($row2 = xtc_db_fetch_array($attributes_query)) {
				$select[] = array('id' => $row2['options_values_id'], 'text' => $row2['products_options_values_name']);
			}
			
			$html .= '<div class="fb_att_identifier"><br /><span class="select_line">'.$row1['products_options_name'].'</span><br />';
			$html .= '<span id="select_option_'.$parent_id.'_'.$row1['options_id'].'">'.xtc_draw_pull_down_menu('sel_options_'.$parent_id.'_'.$row1['options_id'], $select, '', 'style="width:100%;" onchange="if (this.value!=\'\') { document.getElementById(\'fb_loader\').style.display = \'inline\'; xajax_updateAttributes(xajax.getFormValues(\'form_filter_box\'), this.name); }"').'</span><br /></div>';
		}
		$objResponse->assign('c_select_options_'.$parent_id, 'style.display', 'block');
		$objResponse->assign('c_select_options_'.$parent_id, 'innerHTML', $html);
		$objResponse->assign('button_'.$parent_id, 'style.display', 'block');
		$objResponse->assign('fb_loader', 'style.display', 'none');
		return $objResponse;
	}

	function updateAttributes($form, $sel_name) {
		$objResponse = new xajaxResponse();
		
		list(,,,$curr_oid) = explode('_', $sel_name);
		
		// convert into vars
		$form = convertToVars($form);
		
		$att_ids = array();
		$option_ids = array();
		$complex_where = '';
		
		// sort start
		foreach ($form as $key=>$value) {
			if (strpos($key, 'sel_options_'.$_SESSION['fb_category_id']) !== false && $value != '_all_' && !empty($value)) {
				$att_ids[] = $value;
				$_SESSION['fb_attributes'][$key] = $value;
				
				$complex_where .= "pa.products_id IN (SELECT products_id FROM ".TABLE_PRODUCTS_ATTRIBUTES." WHERE options_values_id = '".$value."'".(ATTRIBUTE_STOCK_CHECK == 'true' ? ' AND attributes_stock > 0' : '').") AND ";

			} else {
				unset($_SESSION['fb_attributes'][$key]);
			}
			$sep = explode('_', $key);
			if (!empty($sep[3])) $option_ids[] = $sep[3];
			

		}
		// sort end
		
		// choose products where option_values_id and manufacturers_id
		$products_query = xtDBquery("SELECT DISTINCT pa.products_id FROM ".TABLE_PRODUCTS_ATTRIBUTES." pa, ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_TO_CATEGORIES." tc WHERE p.products_id = pa.products_id AND tc.products_id = pa.products_id AND tc.categories_id = '".$_SESSION['fb_subcategory_id']."' AND p.manufacturers_id = '".$_SESSION['fb_manufacturer_id']."' AND p.products_status > 0 AND p.products_quantity > 0 AND ".(ATTRIBUTE_STOCK_CHECK == 'true' ? ' pa.attributes_stock > 0 AND ' : '').($complex_where).' 1=1');
		$where = " WHERE po.products_options_id = pa.options_id AND po.language_id = '".$_SESSION['languages_id']."' AND ("; 
		while ($row1 = xtc_db_fetch_array($products_query)) {
			$where .= "pa.products_id = '".$row1['products_id']."' OR ";
		}
		$where .= "1=2)";
		// end
		
		
		
		// get options
		$option_query = xtDBquery("SELECT DISTINCT pa.options_id, po.products_options_name FROM ".TABLE_PRODUCTS_ATTRIBUTES." pa, ".TABLE_PRODUCTS_OPTIONS." po".$where);
		// end
		
		
		// build array
		$html = array();
		while ($row2 = xtc_db_fetch_array($option_query)) {
				$select = array();
				$select[] = array('id' => '_all_', 'text' => '-- '.PULL_DOWN_DEFAULT.' --');
				$attributes_query = xtDBquery("SELECT * FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_ATTRIBUTES." pa, ".TABLE_PRODUCTS_OPTIONS_VALUES." pov, ".TABLE_PRODUCTS_TO_CATEGORIES." tc WHERE tc.products_id = p.products_id AND tc.categories_id = '".$_SESSION['fb_subcategory_id']."' AND p.products_id = pa.products_id AND p.products_status > 0 AND p.products_quantity > 0 AND p.manufacturers_id = '".$_SESSION['fb_manufacturer_id']."' AND pov.products_options_values_id = pa.options_values_id AND pov.language_id = '".$_SESSION['languages_id']."' AND pa.options_id = '".$row2['options_id']."' AND ".(ATTRIBUTE_STOCK_CHECK == 'true' ? 'pa.attributes_stock > 0 AND ' : '').($curr_oid != $row2['options_id'] ? $complex_where : '')." 1=1 GROUP BY pa.options_values_id");
				while ($row3 = xtc_db_fetch_array($attributes_query)) {
					$select[] = array('id' => $row3['options_values_id'], 'text' => $row3['products_options_values_name']);
				}
				$html[$row2['options_id']] = '<div class="fb_att_identifier"><br /><span class="select_line">'.$row2['products_options_name'].'</span><br />';
				$html[$row2['options_id']] .= '<span id="select_option_'.$_SESSION['fb_category_id'].'_'.$row2['options_id'].'">'.xtc_draw_pull_down_menu('sel_options_'.$_SESSION['fb_category_id'].'_'.$row2['options_id'], $select, $_SESSION['fb_attributes']['sel_options_'.$_SESSION['fb_category_id'].'_'.$row2['options_id']], 'style="width:100%;" onchange="if (this.value!=\'\') { document.getElementById(\'fb_loader\').style.display = \'inline\'; xajax_updateAttributes(xajax.getFormValues(\'form_filter_box\'), this.name); }"').'</span></div>';
		}
		// end
		
		
		// build html with sort
		$html_out = '';
		foreach ($option_ids as $key=>$value) {
			if (!empty($html[$value])) {
				$html_out .= $html[$value];
				unset($html[$value]);
			}
		}
		foreach ($html as $key=>$value) {
			$html_out .= $value;
		}
		if ($html_out == '') {
			$objResponse->script('document.getElementById("form_filter_box").sel_subcategories_'.$_SESSION['fb_category_id'].'.options[0].selected = true;');
		}
		
		// output
		$objResponse->assign('c_select_options_'.$_SESSION['fb_category_id'], 'innerHTML', $html_out);
		$objResponse->assign('fb_loader', 'style.display', 'none');
		return $objResponse;
	}

	function getOptions_fb2($manufacturer_id) { 
		$objResponse = new xajaxResponse();
		$_SESSION['fb2_manufacturer_id'] = $manufacturer_id;
		
		// get options
		$options_query = xtDBquery("SELECT DISTINCT pa.options_id, po.products_options_name FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_TO_CATEGORIES." tc, ".TABLE_PRODUCTS_ATTRIBUTES." pa, ".TABLE_PRODUCTS_OPTIONS." po WHERE tc.products_id = p.products_id AND pa.products_id = p.products_id AND po.products_options_id = pa.options_id AND tc.categories_id = '".$_SESSION['fb2_subcategory_id']."' AND p.products_status > 0 AND p.products_quantity > 0 AND p.manufacturers_id = '".$_SESSION['fb2_manufacturer_id']."' AND po.language_id = '".$_SESSION['languages_id']."'".(ATTRIBUTE_STOCK_CHECK == 'true' ? ' AND pa.attributes_stock > 0' : ''));
		$html = '';
		
		while ($row1 = xtc_db_fetch_array($options_query)) {
			$select = array();
			$select[] = array('id' => '_all_', 'text' => '-- '.PULL_DOWN_DEFAULT.' --');
			
			$attributes_query = xtDBquery("SELECT * FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_ATTRIBUTES." pa, ".TABLE_PRODUCTS_OPTIONS_VALUES." pov, ".TABLE_PRODUCTS_TO_CATEGORIES." tc WHERE tc.products_id = p.products_id AND tc.categories_id = '".$_SESSION['fb2_subcategory_id']."' AND p.products_id = pa.products_id AND p.products_status > 0 AND p.products_quantity > 0 AND p.manufacturers_id = '".$_SESSION['fb2_manufacturer_id']."' AND pov.products_options_values_id = pa.options_values_id AND pov.language_id = '".$_SESSION['languages_id']."' AND pa.options_id = '".$row1['options_id']."'".(ATTRIBUTE_STOCK_CHECK == 'true' ? ' AND pa.attributes_stock > 0' : '')." GROUP BY pa.options_values_id");
			
			while ($row2 = xtc_db_fetch_array($attributes_query)) {
				$select[] = array('id' => $row2['options_values_id'], 'text' => $row2['products_options_values_name']);
			}
			
			$html .= '<div style="float:left; margin-left:6px;">'.$row1['products_options_name'].'<br />';
			$html .= xtc_draw_pull_down_menu('sel_options_'.$row1['options_id'], $select, '', ' onchange="if (this.value!=\'\') { document.getElementById(\'fb2_loader\').style.display = \'inline\'; xajax_updateAttributes_fb2(xajax.getFormValues(\'form_filter_box_fb2\'), this.name); }"').'</div>';
		}
		$objResponse->assign('c_options_fb2', 'innerHTML', $html);
		//$objResponse->assign('button_'.$parent_id, 'style.display', 'block');
		$objResponse->assign('fb2_loader', 'style.display', 'none');
		return $objResponse;
	}

	function updateAttributes_fb2($form, $sel_name) {
	$objResponse = new xajaxResponse();
	
	list(,,,$curr_oid) = explode('_', $sel_name);
	
	// convert into vars
	$form = convertToVars($form);
	
	$att_ids = array();
	$option_ids = array();
	$complex_where = '';
	
	// sort start
	foreach ($form as $key=>$value) {
		if (strpos($key, 'sel_options_') !== false && $value != '_all_' && !empty($value)) {
			$att_ids[] = $value;
			$_SESSION['fb2_attributes'][$key] = $value;
			
			$complex_where .= "pa.products_id IN (SELECT products_id FROM ".TABLE_PRODUCTS_ATTRIBUTES." WHERE options_values_id = '".$value."'".(ATTRIBUTE_STOCK_CHECK == 'true' ? ' AND attributes_stock > 0' : '').") AND ";

		} else {
			unset($_SESSION['fb2_attributes'][$key]);
		}
		$sep = explode('_', $key);
		if (!empty($sep[3])) $option_ids[] = $sep[3];
		

	}
	// sort end
	
	// choose products where option_values_id and manufacturers_id
	$products_query = xtDBquery("SELECT DISTINCT pa.products_id FROM ".TABLE_PRODUCTS_ATTRIBUTES." pa, ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_TO_CATEGORIES." tc WHERE p.products_id = pa.products_id AND tc.products_id = pa.products_id AND tc.categories_id = '".$_SESSION['fb2_subcategory_id']."' AND p.manufacturers_id = '".$_SESSION['fb2_manufacturer_id']."' AND p.products_status > 0 AND p.products_quantity > 0 AND ".(ATTRIBUTE_STOCK_CHECK == 'true' ? ' pa.attributes_stock > 0 AND ' : '').($complex_where).' 1=1');
	$where = " WHERE po.products_options_id = pa.options_id AND po.language_id = '".$_SESSION['languages_id']."' AND ("; 
	while ($row1 = xtc_db_fetch_array($products_query)) {
		$where .= "pa.products_id = '".$row1['products_id']."' OR ";
	}
	$where .= "1=2)";
	// end
	
	
	
	// get options
	$option_query = xtDBquery("SELECT DISTINCT pa.options_id, po.products_options_name FROM ".TABLE_PRODUCTS_ATTRIBUTES." pa, ".TABLE_PRODUCTS_OPTIONS." po".$where);
	// end
	
	
	// build array
	$html = array();
	while ($row2 = xtc_db_fetch_array($option_query)) {
			$select = array();
			$select[] = array('id' => '_all_', 'text' => '-- '.PULL_DOWN_DEFAULT.' --');
			$attributes_query = xtDBquery("SELECT * FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_ATTRIBUTES." pa, ".TABLE_PRODUCTS_OPTIONS_VALUES." pov, ".TABLE_PRODUCTS_TO_CATEGORIES." tc WHERE tc.products_id = p.products_id AND tc.categories_id = '".$_SESSION['fb2_subcategory_id']."' AND p.products_id = pa.products_id AND p.products_status > 0 AND p.products_quantity > 0 AND p.manufacturers_id = '".$_SESSION['fb2_manufacturer_id']."' AND pov.products_options_values_id = pa.options_values_id AND pov.language_id = '".$_SESSION['languages_id']."' AND pa.options_id = '".$row2['options_id']."' AND ".(ATTRIBUTE_STOCK_CHECK == 'true' ? 'pa.attributes_stock > 0 AND ' : '').($curr_oid != $row2['options_id'] ? $complex_where : '')." 1=1 GROUP BY pa.options_values_id");
			while ($row3 = xtc_db_fetch_array($attributes_query)) {
				$select[] = array('id' => $row3['options_values_id'], 'text' => $row3['products_options_values_name']);
			}
			$html[$row2['options_id']] = '<div style="float:left; margin-left:6px;">'.$row2['products_options_name'].'<br />';
			$html[$row2['options_id']] .= xtc_draw_pull_down_menu('sel_options_'.$row2['options_id'], $select, $_SESSION['fb2_attributes']['sel_options_'.$row2['options_id']], 'style="width:100%;" onchange="if (this.value!=\'\') { document.getElementById(\'fb2_loader\').style.display = \'inline\'; xajax_updateAttributes_fb2(xajax.getFormValues(\'form_filter_box_fb2\'), this.name); }"').'</div>';
	}
	// end
	
	
	// build html with sort
	$html_out = '';
	foreach ($option_ids as $key=>$value) {
		if (!empty($html[$value])) {
			$html_out .= $html[$value];
			unset($html[$value]);
		}
	}
	foreach ($html as $key=>$value) {
		$html_out .= $value;
	}
	if ($html_out == '') {
		$objResponse->script('document.getElementById("form_filter_box_fb2").manufacturers_fb2.options[0].selected = true;');
	}
	
	// output
	$objResponse->assign('c_options_fb2', 'innerHTML', $html_out);
	$objResponse->assign('fb2_loader', 'style.display', 'none');
	return $objResponse;
}
}
##############################################################
# XAJAX Filter
##############################################################

require (DIR_WS_INCLUDES.'xajax/xajax_core/xajax.inc.php');


$xajax = new xajax();
$xajax->setCharEncoding('UTF-8');
// $xajax->setFlag("decodeUTF8Input",true);
// $xajax->setRequestURI(xtc_href_link(basename($_SERVER['SCRIPT_NAME']), '', 'SSL'));
// $xajax->setRequestURI($_SERVER['REQUEST_URI']);
$xajax->setRequestURI($_SERVER['PHP_SELF']);

// xajax Search
$xajax->registerFunction("kerimsuche");

// xajax Filter

$xajax->registerFunction("getFilterItems");

// xajax Price Update
// if (PRODUCT_ID > 0 && strpos($PHP_SELF, FILENAME_SHOPPING_CART) === false) {
	$xajax->registerFunction("getNewPrice");
// }

if ($_SESSION['fb_attributes'] != '') {
	$xajax->registerFunction("getSubCategories", XAJAX_GET);
	$xajax->registerFunction("getOptions", XAJAX_GET);
	$xajax->registerFunction("updateAttributes", XAJAX_GET);
	$xajax->registerFunction("getOptions_fb2", XAJAX_GET);
	$xajax->registerFunction("updateAttributes_fb2", XAJAX_GET);
}

$xajax->processRequests();
$xajax->printJavascript();