<?php
/* --------------------------------------------------------------
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2011 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/
require('includes/init.inc.php');

$target_db_host 	= DB_SERVER;
$target_db_user 	= DB_SERVER_USERNAME;
$target_db_password = DB_SERVER_PASSWORD;
$target_db_database = DB_DATABASE;

$_POST = $_SESSION['POST_ARRAY'];

$source_db = new DatabaseConnection($_SESSION['source_db_host'], $_SESSION['source_db_user'], $_SESSION['source_db_password'], $_SESSION['source_db_database']);
$target_db = new DatabaseConnection($target_db_host, $target_db_user, $target_db_password, $target_db_database);

$coo_sql_update = new SQLUpdateBuilder();
$coo_sql_export = new SQLExport();
?>

<div style="background-color: white">

<script type="text/javascript" src="http://code.jquery.com/jquery-1.6.2.js"></script>
<script type="text/javascript">
	  var wait_timeout;
      var scroll_interval;
      scroll_interval = setInterval(update_view, 100);

      $(document).mouseenter(function()
      {
        clearInterval(scroll_interval);
        if(wait_timeout)
        {
          clearTimeout(wait_timeout);
        }
      });

      $(document).mouseleave(function()
      {
        clearInterval(scroll_interval);
        wait_timeout = setTimeout(function()
        {
          scroll_interval = setInterval(update_view, 100);
        }, 1000);
      });

      function update_view()
      {
        $(document).scrollTop($(document).height());
      }
</script>

<?php
if(valid_login_new($target_db, $_POST['email'], $_POST['password']) == false)
{
	echo '<b><font color=red>Fehler: Login Zugangsdaten ung&uuml;ltig.</font></b><br />';
}
else
{
	echo '<div id="messages">';
	echo '<b>Bitte unterbrechen Sie diesen Vorgang auf keinen Fall, es kann ein paar Minuten dauern, je nach Größe der Datenbank!</b>';

	$esHelper_source = new EntityStructHelper($source_db);
	$esHelper_target = new EntityStructHelper($target_db);

	$coo_sql_export->start_export();

	if(isset($_POST['import_customers_status'])) {
		echo '<b>Exportiere Kundengruppen...</b><br />';
		flush();
		language_struct_transfer('customers_status', 'customers_status_id');
		adopt_customers_status_statics();
	}
	echo 'Import Kundenstatus komplett';
	if(isset($_POST['import_categories'])) {
		echo '<b>Exportiere Kategorien...</b><br />';
		flush();
		single_struct_transfer('categories', 'categories_id');
		language_struct_transfer('categories_description', 'categories_id');
	}
	echo 'Import Kategorien komplett';
	if(isset($_POST['reset_categories_template'])) {
		echo '<b>Kategorielisting auf Standard...</b><br />';
		flush();
		$target_db->query('UPDATE categories SET categories_template = default');
	}
	if(isset($_POST['reset_listing_template'])) {
		echo '<b>Artikellisting auf Standard...</b><br />';
		flush();
		$target_db->query('UPDATE categories SET listing_template = default');
	}
	if(isset($_POST['import_products'])) {
		echo '<b>Exportiere Artikel...</b><br />';
		flush();
		packaged_products_transfer();
		single_struct_transfer('products_images', 'image_id');
		# product reviews
		single_struct_transfer('reviews', 'reviews_id');
		language_struct_transfer('reviews_description', 'reviews_id', 'languages_id');
	}
	echo 'Import Produkte komplett';
	if(isset($_POST['reset_product_template'])) {
		echo '<b>Artikelvorlage auf Standard...</b><br />';
		flush();
		$target_db->query('UPDATE products SET product_template = default');
	}
	if(isset($_POST['reset_options_template'])) {
		echo '<b>Optionenvorlage auf Standard...</b><br />';
		flush();
		$target_db->query('UPDATE products SET options_template = default');
	}
	if(isset($_POST['import_products_options'])) {
		echo '<b>Exportiere Artikel-Optionen...</b><br />';
		flush();
		packaged_products_options_transfer();
	}
	echo 'Import Optionen komplett';
	if(isset($_POST['import_specials'])) {
		echo '<b>Exportiere Sonderangebote...</b><br />';
		flush();
		single_struct_transfer('specials', 'specials_id');
	}
	echo 'Import Specials komplett';
	if(isset($_POST['import_manufacturers'])) {
		echo '<b>Exportiere Hersteller...</b><br />';
		flush();
		single_struct_transfer('manufacturers', 'manufacturers_id');
		language_struct_transfer('manufacturers_info', 'manufacturers_id', 'languages_id');
	}
	if(isset($_POST['import_xsell'])) {
		echo '<b>Exportiere Cross-Selling...</b><br />';
		flush();
		single_struct_transfer('products_xsell', 'ID');
		language_struct_transfer('products_xsell_grp_name', 'products_xsell_grp_name_id');
	}
	echo 'Import Cross-Selling komplett';
	if(isset($_POST['import_customers'])) {
		echo '<b>Exportiere Kunden...</b><br />';
		flush();
		packaged_customers_transfer();
		single_struct_transfer('admin_access', 'customers_id');
	}
	if(isset($_POST['import_personal_offers'])) {
		echo '<b>Exportiere Kundengruppen- und Staffelpreise...</b><br />';
		flush();
		for($i=0; $i<20; $i++) {
			single_struct_transfer('personal_offers_by_customers_status_'.$i, 'price_id');
		}
	}
	echo 'Import Staffel komplett';
	if(isset($_POST['import_orders'])) {
		echo '<b>Exportiere Bestellungen...</b><br />';
		flush();
		packaged_orders_transfer();
		single_struct_transfer('banktransfer', 'orders_id');
		single_struct_transfer('orders_recalculate', 'orders_recalculate_id');
	}
	if(isset($_POST['import_orders_status'])) {
		echo '<b>Exportiere Bestellstatus...</b><br />';
		flush();
		language_struct_transfer('orders_status', 'orders_status_id');
	}
	echo 'Import Order Status komplett';
	if(isset($_POST['import_gv'])) {
		echo '<b>Exportiere Kupons und Gutscheine...</b><br />';
		flush();
		single_struct_transfer('coupon_email_track', 'unique_id');
		single_struct_transfer('coupon_gv_customer', 'customer_id');
		single_struct_transfer('coupon_email_track', 'unique_id');
		single_struct_transfer('coupon_redeem_track', 'unique_id');
	}
	if(isset($_POST['import_basket'])) {
		echo '<b>Exportiere Warenkörbe...</b><br />';
		flush();
		single_struct_transfer('customers_basket', 'customers_basket_id');
		single_struct_transfer('customers_basket_attribute', 'customers_basket_attributes_id');
	}
	echo 'Import Warenkörbe komplett';
	if(isset($_POST['import_content_manager'])) {
		echo '<b>Exportiere Content-Seiten...</b><br />';
		flush();
		single_struct_transfer('content_manager', 'content_id');
	}



	$coo_sql_export->stop_export();
	?>

	<b>Export abgeschlossen.</b>

	<p id="b_continue">
		&Uuml;bertragung fortsetzen: <a href="run_import.php">Import starten</a>
	</p>

	<?php
	echo '</div>';
}
?>

</div>

