<?php
/* --------------------------------------------------------------
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2011 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class SQLExport
{
	var $v_separator = '';
	var $v_file_handler = false;
	var $v_file_path = '';


	function SQLExport()
	{
		$this->v_separator = '-- '. $_SESSION['RANDOM_HASH'];
		$this->v_file_path = DIR_FS_DOCUMENT_ROOT.'cache/update_export-'.$_SESSION['RANDOM_HASH'].'.sql';
	}

	function write($p_sql)
	{
		$t_output  = $this->v_separator ."\n";
		$t_output .= $p_sql ."\n";
		
		fwrite($this->v_file_handler, $t_output);
	}

	function start_export()
	{
		$this->v_file_handler = fopen($this->v_file_path, 'w');
	}
	
	function stop_export()
	{
		fclose($this->v_file_handler);
	}

	function start_import($p_target_db, $p_query_start=0)
	{
		$t_read_buffer_size = 131072; # 128 KB
		$t_query_count_limit = 1000;

		$t_bytes_total = filesize($this->v_file_path);
		$t_bytes_done = 0;
		$t_query_count = 0;

		$t_handle = fopen($this->v_file_path, 'r');
		if($t_handle)
		{
			$t_buffer = '';
			$t_query_array = array();

			while(feof($t_handle) == false)
			{
				$t_buffer .= fread($t_handle, $t_read_buffer_size);
				$t_query_array = explode($this->v_separator, $t_buffer);

				for($i=0; $i<sizeof($t_query_array) - 1; $i++) #never proceed last query
				{
					if($t_query_array[$i] != '')
					{
						//echo '<span style="color:red; font-size:10px">'.$t_query_array[$i] .'</span><br>';
						if($t_query_count >= $p_query_start)
						{
							$p_target_db->query($t_query_array[$i]);
						}
						$t_query_count++;

						if($t_query_count >= ($p_query_start + $t_query_count_limit))
						{
							echo '<script>location.href="run_import.php?query_start='.$t_query_count.'"</script>';
							die();
						}
					}
				}


				$t_buffer_tail = $t_query_array[sizeof($t_query_array) - 1];

				$t_bytes_done += strlen($t_buffer) - strlen($t_buffer_tail);
				if($t_bytes_total > 0)
				{
					$t_status = (int)(100 / $t_bytes_total * $t_bytes_done) .'% importiert<br/>';
					echo '<span style="color:#808080; font-size:10px">'.$t_status.'</span>';
					$t_buffer = $t_buffer_tail;
					flush();
				}
			}
			if($t_buffer != '') $p_target_db->query($t_buffer);
			if($t_status != 100) echo '100% importiert<br/>';
			fclose($t_handle);
		}
	}

}
?>