<?php
/* --------------------------------------------------------------
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2011 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class ProductsStructGenerator
{
	var $centralDB = false;
	
	var $source_products_id	= 0;
	var $source_language_id = 0;
	
	var $include_products_attributes 	= true;
	var $include_products_description 	= true;
	var $include_products_to_categories	= true;
	var $include_products_content		= true;
	
	//v2 Zubehör, Filter
	var $include_products_accessories		= true;
	var $include_products_accessories_products		= true;
	
	var $include_products_parameters		= true;
	var $include_products_parameters_description		= true;
	var $include_products_parameters_groups		= true;
	var $include_products_parameters_groups_description		= true;
	var $include_products_to_filter		= true;
	var $include_product_filter_categories		= true;
	var $include_product_filter_items		= true;
	var $include_tag_to_product		= true;
	//V2 Blog
	var $include_blog_categories		= true;
	var $include_blog_comment		= true;
	var $include_blog_items		= true;
	var $include_commerce_seo_url_personal_links		= true;
	
	var $esHelper = false;
	
	
	function ProductsStructGenerator($centralDB)
	{
		$this->centralDB	= $centralDB;
		$this->esHelper 	= new EntityStructHelper($this->centralDB);
	}
	
	
	function get_full_struct($source_products_id, $source_language_id=0)
	{
		$this->source_products_id = $source_products_id;
		$this->source_language_id = $source_language_id;
		
		$struct_product = $this->esHelper->create_entity_struct('products', 
																'products_id', 
																$this->source_products_id);
		//DESCRIPTION
		if($this->include_products_description) {
			$pack = $this->get_pack_products_description($this->source_products_id);
			$struct_product->add_struct_pack($pack);
		}
		//ACCES
		// if($this->include_products_accessories) {
			// $pack = $this->get_pack_products_accessories($this->source_products_id);
			// $struct_product->add_struct_pack($pack);
		// }
		
		//ATTRIBUTES
		if($this->include_products_attributes) {
			$pack = $this->get_pack_products_attributes($this->source_products_id);
			$struct_product->add_struct_pack($pack);
		}
		
		//CONTENT
		if($this->include_products_content) {
			$pack = $this->get_pack_products_content($this->source_products_id);
			$struct_product->add_struct_pack($pack);
		}

		//P2C
		if($this->include_products_to_categories) {
			$pack = $this->get_pack_products_to_categories($this->source_products_id);
			$struct_product->add_struct_pack($pack);
		}
		
		return $struct_product;
	}
	
	
	// function get_pack_products_accessories($products_id)
	// {
		// $output_pack = array();
		
		// $sec_key_name  = '';
		// $sec_key_value = '';
		
		// $sql = '
			// SELECT 
				// head_product_id
			// FROM 	accessories
			// WHERE head_product_id = "'.$products_id.'"
		// ';
		
		// $result 	= $this->centralDB->query($sql);
		// while(($row = mysql_fetch_array($result) ))
		// {
			// $output_pack[] = $this->esHelper->create_entity_struct('id', 
																	// $row['products_id']);
		// }
		// return $output_pack;
	// }
		
	function get_pack_products_description($products_id)
	{
		$output_pack = array();
		
		$sec_key_name  = '';
		$sec_key_value = '';
		
		$sql = '
			SELECT 
				products_id,
				language_id
			FROM 	products_description
			WHERE products_id = "'.$products_id.'"
		';
		if($this->source_language_id > 0) {
			$sql 					.= ' AND language_id = "'.$this->source_language_id.'" ';
			$sec_key_name  = 'language_id';
			$sec_key_value = $this->source_language_id;
		}
		//echo 'ccc:'. $sql;
		
		$result 	= $this->centralDB->query($sql);
		while(($row = mysql_fetch_array($result) ))
		{
			$output_pack[] = $this->esHelper->create_entity_struct('products_description', 
																 	'products_id', 
																	$row['products_id'],
																	$sec_key_name,
																	$sec_key_value);
		}
		return $output_pack;
	}
	
	
	function get_pack_products_attributes($products_id) 
	{
		$output_pack = array();
		
		$result = $this->centralDB->query('
			SELECT products_attributes_id
			FROM 	products_attributes
			WHERE products_id = "'.$products_id.'"
		');
		while(($row = mysql_fetch_array($result) ))
		{
			$output_pack[] = $this->esHelper->create_entity_struct('products_attributes', 
																	'products_attributes_id', 
																	$row['products_attributes_id']);
		}
		return $output_pack;
	}

	function get_pack_products_to_categories($products_id) 
	{
		$output_pack = array();
		
		$sec_key_name  = '';
		$sec_key_value = '';
		
		$sql = '
			SELECT 
				products_id,
				categories_id
			FROM 	products_to_categories
			WHERE products_id = "'.$products_id.'"
		';
		//echo 'ccc:'. $sql;
		
		$result 	= $this->centralDB->query($sql);
		while(($row = mysql_fetch_array($result) ))
		{
			$output_pack[] = $this->esHelper->create_entity_struct('products_to_categories', 
																 	'products_id', 
																	$row['products_id'],
																	'categories_id',
																	$row['categories_id']);
		}
		return $output_pack;
	}
	
	function get_pack_products_content($products_id)
	{
		$output_pack = array();
		$sql = '
			SELECT 
				content_id
			FROM products_content
			WHERE products_id = "'.$products_id.'"
		';
		//echo 'ccc:'. $sql;
		
		$result 	= $this->centralDB->query($sql);
		while(($row = mysql_fetch_array($result) ))
		{
			$output_pack[] = $this->esHelper->create_entity_struct('products_content', 
																	 'content_id', 
																	 $row['content_id']);
		}
		return $output_pack;
	}
	
}
?>