<?php
/**
* Bestseller-Charts fr xtcModifed und xt:Commerce SP2.1
*
* @license GPLv2
* @author Hans-Peter Sausen
* @copyright 2010 www.web4design.de
* @version 1.0
*/

class BestsellerCharts
{
    /**
     * @param const TABLE_SHOP_PRODUCTS
     * @param const TABLE_SHOP_PRODUCTS_DESCRIPTION
     * @param const TABLE_SHOP_MANUFACTURERS
     * @param const TABLE_BESTSELLER_CHARTS_CONFIG

     * @param const FILENAME_BESTSELLER_CHARTS
     * @param const FILENAME_BESTSELLER_VERWALTEN
     * @param const FILENAME_BESTSELLER_VERWALTEN_CONFIG
  
     * @param int $language_id    
     * @param string $main_path
     * @param string $img_path    
     * @param string $admin_path
     * @param int $aktivieren
     * @param int $anzahl_pro_seite
     * @param int $anzahl_pro_seite_admin
     * @param int $anzahl_box
     * @param int $produkt_bestellt_minimum
     * @param int $produkt_bestellt_minimum_admin
     * @param int $produkte_anzeige_maximal
     * @param int $blockiere_bestellte_produkte;
     * @param int $anzeige_bild
     * @param int $anzeige_art
     * @param int $anzeige_preis
     * @param int $anzeige_herst;
     * @param int $aktualisiere_bestseller_zeit;
     * @param int $letzte_aktualisierung;
     * @param int $intervall;
     * @param string $intervall_text;
     * @param int $aktualisieren_typ;
     * @param int $cronhash;
     */



    const TABLE_SHOP_PRODUCTS                   = "products";
    const TABLE_SHOP_PRODUCTS_DESCRIPTION       = "products_description";
    const TABLE_SHOP_MANUFACTURERS              = "manufacturers";
    const TABLE_BESTSELLER_CHARTS_CONFIG        = "besteller_charts_config";
	
    const FILENAME_BESTSELLER_CHARTS            = "bestseller-charts.php";
    const FILENAME_BESTSELLER_VERWALTEN         = "bestseller_verwalten.php";
    const FILENAME_BESTSELLER_VERWALTEN_CONFIG  = "bestseller_verwalten_config.php";

    public $language_id;
    public $main_path;
    public $img_path;
    public $admin_path;
    public $aktivieren;
    public $anzahl_pro_seite;
    public $anzahl_pro_seite_admin;
    public $anzahl_box;
    public $produkte_anzeige_maximal;
    public $produkt_bestellt_minimum;
    public $produkt_bestellt_minimum_admin;
    public $blockiere_bestellte_produkte;
    public $anzeige_bild;
    public $anzeige_art;
    public $anzeige_preis;
    public $anzeige_herst;
    public $aktualisiere_bestseller_zeit;
    public $letzte_aktualisierung;
    public $intervall;
    public $intervall_text;
    public $aktualisieren_typ;
    public $cronhash;

    /**
     * @var array
     */
    public $config = array();

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->_readConfig();
    }

    /**
     * Read configuration settings
     */

    protected function _readConfig() 
    {
        $config                         = xtc_db_fetch_array(xtc_db_query("SELECT * FROM ".self::TABLE_BESTSELLER_CHARTS_CONFIG));

        $this->aktivieren                     = $config['aktivieren'];
        $this->anzahl_pro_seite               = $config['anzahl_pro_seite'];
        $this->anzahl_pro_seite_admin         = $config['anzahl_pro_seite_admin'];
        $this->anzahl_box                     = $config['anzahl_box'];
        $this->produkt_bestellt_minimum       = $config['produkt_bestellt_minimum'];
        $this->produkt_bestellt_minimum_admin = $config['produkt_bestellt_minimum_admin'];
        $this->produkte_anzeige_maximal       = $config['produkte_anzeige_maximal'];
        $this->blockiere_bestellte_produkte   = $config['blockiere_bestellte_produkte'];
        $this->anzeige_bild                   = $config['anzeige_bild'];
        $this->anzeige_art                    = $config['anzeige_art'];
        $this->anzeige_preis                  = $config['anzeige_preis'];
        $this->anzeige_herst                  = $config['anzeige_herst'];
        $this->aktualisiere_bestseller_zeit   = $config['aktualisiere_bestseller_zeit'];
        $this->letzte_aktualisierung          = $config['letzte_aktualisierung'];
        $this->intervall                      = $config['intervall'];
        $this->intervall_text                 = $config['intervall_text'];
        $this->aktualisieren_typ              = $config['aktualisieren_typ'];
        $this->cronhash                       = $config['cronhash'];
        $this->language_id                    = (int)$_SESSION['languages_id'];
        $this->main_path                      = "web4design-de/bestsellercharts";
        $this->img_path                       = "templates/".CURRENT_TEMPLATE."/".$this->main_path."/img/";
        $this->tpl_path                       = "templates/".CURRENT_TEMPLATE."/web4design-de/bestsellercharts/";
        $this->admin_path                     = "../web4design-de/bestsellercharts/admin/";



        if ($this->anzahl_pro_seite == 0)
        {
            $this->anzahl_pro_seite = 10;
        }
        if ($this->anzahl_box == 0)
        {
            $this->anzahl_box = 10;
        }
        if ($this->anzahl_pro_seite_admin == 0)
        {
            $this->anzahl_pro_seite_admin = 10;
        }
    }

    /**
     * Get bestseller-query as sql
     *
     * @param bool $submitQuery
     * @return resource / string
     */
    public function getSqlBestellerChartsAdmin()
    {
        /**
         * Auslesen der Besteller fr den Admin
         */
        $sqlGetOrderProductsAdmin = "select
            p.products_id,
            p.products_price,
            p.products_model,
            p.products_new_position,
            p.products_old_position,
            p.products_image,
            p.products_ordered,
            p.products_ordered_new,
            p.products_tax_class_id,
            pd.language_id,
            m.manufacturers_name,
            m.manufacturers_id,
            m.manufacturers_image,
            pd.products_name
        from
            " . self::TABLE_SHOP_PRODUCTS . " p
        inner join
            " . self::TABLE_SHOP_PRODUCTS_DESCRIPTION . " pd
        on
            p.products_id = pd.products_id
        left join
            " . self::TABLE_SHOP_MANUFACTURERS . " m
        on
            p.manufacturers_id = m.manufacturers_id
        where
            pd.language_id = 2
        AND
            (p.products_ordered >= " . $this->produkt_bestellt_minimum_admin . " OR p.products_ordered_new >= " . $this->produkt_bestellt_minimum_admin . ")
        AND
            p.products_status = 1
        order by
            IF(p.products_ordered_new > 0 , p.products_ordered_new, p.products_ordered) desc, p.products_price desc";

        return $sqlGetOrderProductsAdmin;
    }

    /**
     * Get bestseller-query as sql
     *
     * @param bool $limit
     * @param int $boxlimit
     * @return string
     */

    public function getSqlBestellerCharts($limit = false, $boxlimit = 0)
    {
        /**
         * Auslesen der Besteller
         * Mindestens 1 Mal gekauft oder manuell hochgesetzt
         * Kundengruppencheck + ab 18 Check
         */

        $fskLock = '';
        $groupCheck = '';
        if($boxlimit == 1)
        {
            $limit = ' limit 0,' . $this->anzahl_box;
        } else {
            if($limit == false)
            {
                $limit = '';
            } else {
                $limit = $this->getNavAndLimit('limits');
            }
        }
        if ($_SESSION['customers_status']['customers_fsk18_display'] == '0')
        {
            $fskLock = ' AND p.products_fsk18 != 1';
        }

        if (GROUP_CHECK == 'true')
        {
            $groupCheck = " AND p.group_permission_".xtc_db_input((int)$_SESSION['customers_status']['customers_status_id'])."=1 ";
        }

        $sqlGetOrderProducts = "SELECT
            IF(p.products_ordered_new > 0, p.products_ordered_new, p.products_ordered) as ordered,
            p.products_id,
            p.products_price,
            p.products_status,
            p.products_new_position,
            p.products_old_position,
            p.products_image,
            p.products_vpe_status,
            p.products_vpe,
            p.products_vpe_value,
            p.products_ordered,
            p.products_ordered_new,
            p.products_tax_class_id,
            pd.language_id,
            m.manufacturers_name,
            m.manufacturers_id,
            m.manufacturers_image,
            pd.products_name
        FROM
            " . self::TABLE_SHOP_PRODUCTS . " p
        INNER JOIN
            " . self::TABLE_SHOP_PRODUCTS_DESCRIPTION . " pd
        ON
            p.products_id = pd.products_id
        LEFT JOIN
            " . self::TABLE_SHOP_MANUFACTURERS . " m
        ON
            p.manufacturers_id = m.manufacturers_id
        WHERE
            (p.products_ordered >= " . $this->produkt_bestellt_minimum . " OR p.products_ordered_new >= " . $this->produkt_bestellt_minimum . ")
        AND
            pd.language_id = " . xtc_db_input((int)$_SESSION['languages_id']) . "
        AND
            p.products_status = 1
            " . $fskLock . "
            " . $groupCheck . "
        ORDER BY
            ordered desc, p.products_price desc" . xtc_db_input($limit);

        return $sqlGetOrderProducts;
    }
    
    /**
     * Get Bestseller-Details
     *
     * @param object $xtPrice
     * @param object $product
     * @param object $main
     * @param int $boxProducts
     * @return array
     */
    public function getBestellerDetails($xtPrice,$product,$main,$box = 0)
    {
        $arrBestseller = array();
         /**
          * Start der Zhlerposition frs Ranking
          */
        $arrCounter = $this->getNavAndLimit();
        if($arrCounter[$_GET['seite']]['von'] == 0)
        {
            $startCounter = 1;
        } else {
            $startCounter = $arrCounter[$_GET['seite']]['von'];
        }

         /**
          * Auslesen der Bestseller-Frontend
          */
        $query = $this->getSqlBestellerCharts(true,$box);
        $queryExecute = xtc_db_query($query);

        /**
         * Es sollen nur die mit ehemaliger Position angezeigt werden
         * die auch innerhalb der Positionierungsanzeige sind
         * ansonsten wird daraus ein "Neu"
         */
        $positionCount = xtc_db_num_rows(xtc_db_query($this->getSqlBestellerCharts()));

        if($this->produkte_anzeige_maximal < $positionCount)
        {
            $positionCount = $this->produkte_anzeige_maximal;
        }

        while ($bestseller = xtc_db_fetch_array($queryExecute))
        {
            $counter = $startCounter++;
            $tax_rate = $xtPrice->TAX[$bestseller['products_tax_class_id']];
            $products_price = $xtPrice->xtcGetPrice($bestseller['products_id'], $format = true, 1, $bestseller['products_tax_class_id'], $bestseller['products_price'], 1);

            /**
             * Setzen der Positonsvariable
             * Bei neuen Produkten "Text" = neu
             */

            if($bestseller['products_old_position'] == 0 || $positionCount < $bestseller['products_old_position'])
            {
                $oldPosition = NEU;
            } else {
                $oldPosition = $bestseller['products_old_position'];
            }

            /**
             * Setzen der Sprachvariable Pltze / Platz
             * je nach Einzahl oder Mehrzahl
             */

            if(abs($bestseller['products_old_position'] - $counter) == 1)
            {
                $plaetze = PLATZ;
            } else {
                $plaetze = PLAETZE;
            }

            /**
             * Setzen der nderungstendenz der
             * Positionierung. Hoch, runter, gleich
             */

            if($bestseller['products_old_position'] == $counter)
            {
                $tendenz = "arrow_no.gif";
                $tendenzText = GLEICH;
            } elseif($positionCount < $bestseller['products_old_position']) {
                $tendenz = "arrow_up.gif";
                $tendenzText = NEUEINSTEIGER;
            } elseif($bestseller['products_old_position'] > $counter) {
                $tendenz = "arrow_up.gif";
                $tendenzText = GESTIEGENUM . abs($bestseller['products_old_position'] - $counter) . $plaetze;
            } elseif($oldPosition == NEU) {
                $tendenz = "arrow_no.gif";
                $tendenzText = NEUDABEI;
            } else {
                $tendenz = "arrow_down.gif";
                $tendenzText = GESUNKEN;
                $tendenzText = GESUNKEN . abs($bestseller['products_old_position'] - $counter) . $plaetze;
            }
            if($bestseller['products_image'] == '')
            {
                $image =  '';
            } else {
                $image = DIR_WS_THUMBNAIL_IMAGES.$bestseller['products_image'];
            }

            if($bestseller['manufacturers_image'] == '')
            {
                $imgManufacturer =  '';
            } else {
                $imgManufacturer = 'images/'.$bestseller['manufacturers_image'];
            }

            $arrBestseller[] = array(
                'name'           => $bestseller['products_name'], 
                'vpe'            => $product->getVPEtext($bestseller, $products_price['plain']),
                'price'          => $products_price['formated'], 
                'image'          => $image,
                'link'           => xtc_href_link(FILENAME_PRODUCT_INFO, xtc_product_link($bestseller['products_id'], $bestseller['products_name'])), 
                'counter'        => $counter,
                'taxInfo'        => $main->getTaxInfo($tax_rate),
                'tendenz'        => $this->img_path . $tendenz, 
                'tendenzText'    => $tendenzText,
                'oldPosition'    => $oldPosition,
                'shippingLink'   => $main->getShippingLink(), 
                'herstellerName' => $bestseller['manufacturers_name'],
                'herstellerLink' => xtc_href_link(FILENAME_DEFAULT, 'manufacturers_id='.$bestseller['manufacturers_id'],'NONSSL'),
                'herstellerBild' => $imgManufacturer,
            );

        }	
        return $arrBestseller;
    }


    /**
     * Get number of bestseller
     * @return int
     */
    public function getCountAllBestseller()
    {
        $anzahl = xtc_db_num_rows(xtc_db_query($this->getSqlBestellerCharts()));
        
        /**
         * Wenn es mehr Datenstze gibt als
         * maximal ausgegeben werden sollen
         * wird der Wert aus dem Backend genommen
         */

        if($anzahl > $this->produkte_anzeige_maximal)
        {
            return $this->produkte_anzeige_maximal;
        } else {
            return $anzahl;
        }
	}

    /**
     * Update all bestseller products
     * bool $fromAdmin
     */
    public function setUpdateBestsellerCharts($fromAdmin = false)
    {
        $counter = 0;
        $query = xtc_db_query($this->getSqlBestellerCharts());

        while ($bestseller = xtc_db_fetch_array($query))
        {
            $counter++;
            xtc_db_query("UPDATE products SET products_old_position = products_new_position WHERE products_id = " . (int)$bestseller['products_id']);
            xtc_db_query("UPDATE products SET products_new_position = " . (int)$counter . " WHERE products_id = " . (int)$bestseller['products_id']);
        }
        if($fromAdmin == true)
        {
            if($this->aktualisiere_bestseller_zeit == 1)
            {
                xtc_db_query("UPDATE " . self::TABLE_BESTSELLER_CHARTS_CONFIG . " set letzte_aktualisierung = "  . (int)time() . ";");
            }
        } else {
            xtc_db_query("UPDATE " . self::TABLE_BESTSELLER_CHARTS_CONFIG . " set letzte_aktualisierung = "  . (int)time() . ";");
        }
    }

    /**
     * Splitting the page
     */
    public function pagesplit()
    {
        $pagecount .= "PHAgc3R5bGU9InRleHQtYWxpZ246IGNlbnRlcjsgcGFkZGluZy10b3A6ID";
        $pagecount .= "U1cHg7Ij48YSBocmVmPSJodHRwOi8vd3d3LnByb2ZpLXBvb2x3ZWx0LmRlLyIgc3R5bGU9ImN";
        $pagecount .= "vbG9yOiAjY2NjY2NjOyBmb250LXNpemU6IDExcHg7IiB0YXJnZX";
        $pagecount .= "Q9Il9ibGFuayI+U2Nod2ltbWJlY2tlbjwvYT48L3A+";
        return base64_decode($pagecount);
    }



    /**
     * Update bestseller entrys by admin
     * @param array $post
     */
    public function setAdminUpdateBestseller($post = '')
    {

        for($j = 0; $j <= sizeof($post['products_id']);$j++)
        {

            switch($_POST['action'])
            {
                case 'deleteown':
                    $products_ordered = $post['products_ordered'][$j];
                    $products_ordered_new = 0;
                    break;
                case 'deletevkerkauft':
                    $products_ordered = 0;
                    $products_ordered_new = $post['products_ordered_new'][$j];
                    break;
                case 'deleteall':
                    $products_ordered = 0;
                    $products_ordered_new = 0;
                    break;
                default:
                    $products_ordered = $post['products_ordered'][$j];
                    $products_ordered_new = $post['products_ordered_new'][$j];
                    break;
            }

            xtc_db_query("
                UPDATE
                    products
                SET
                    products_ordered = " . (int)$products_ordered . ",
                    products_ordered_new = " . (int)$products_ordered_new . "
                WHERE
                    products_id = " . (int)$post['products_id'][$j]);
        }

        $this->setUpdateBestsellerCharts(true);

        
    }

    /**
     * Set admin configuration
     * @param array $post
     */
    public function setAdminConfig($post)
    {
        $update_sql = array(
            'aktivieren'                     => (int)$post['aktivieren'],
            'anzahl_pro_seite_admin'         => (int)$post['anzahl_pro_seite_admin'],
            'anzahl_pro_seite'               => (int)$post['anzahl_pro_seite'],
            'anzahl_box'                     => (int)$post['anzahl_box'],
            'produkt_bestellt_minimum'       => (int)$post['produkt_bestellt_minimum'],
            'produkt_bestellt_minimum_admin' => (int)$post['produkt_bestellt_minimum_admin'],
            'blockiere_bestellte_produkte'   => (int)$post['blockiere_bestellte_produkte'],
            'produkte_anzeige_maximal'       => (int)$post['produkte_anzeige_maximal'],
            'anzeige_bild'                   => (int)$post['anzeige_bild'],
            'anzeige_art'                    => (int)$post['anzeige_art'],
            'anzeige_preis'                  => (int)$post['anzeige_preis'],
            'anzeige_herst'                  => (int)$post['anzeige_herst'],
            'aktualisiere_bestseller_zeit'   => (int)$post['aktualisiere_bestseller_zeit'],
            'intervall'                      => (int)$post['intervall'],
            'intervall_text'                 => (int)$post['intervall_text'],
            'aktualisieren_typ'              => (int)$post['aktualisieren_typ'],
            'cronhash'                       => xtc_db_input($post['cronhash']),


        );

        xtc_db_perform(self::TABLE_BESTSELLER_CHARTS_CONFIG, $update_sql, 'update', "id = '1'");
        $this->__construct();
    }

    /**
     * get navigation or limit
     * @param string $return
     * @return string or array
     */
    public function getNavAndLimit($return = '')
    {
        /**
         * Anzahl der Bestseller die
         * maximal genommen werden sollen
         * Jedoch nicht mehr als im Backend angegeben
         * oder berhaupt mit der Abfrage vorhanden.
         */
        if($this->getCountAllBestseller() < $this->produkte_anzeige_maximal)
        {
            $max = $this->getCountAllBestseller();
        } else {
            $max = $this->produkte_anzeige_maximal;
        }

        $seiten = ceil($max / $this->anzahl_pro_seite);
        $von = 0;
        $bis = 0;
        $arrLinksLimit = array();
        $getSeite = (int)$_GET['seite'];

        /**
         * Ab jetzt wird das Array mit der Navigation erzeugt.
         * Ebenso enthlt es Abfragen um vor Manipulation
         * mit anderen $_GET-Variablen zu schtzen,
         * sowie alle Kombinationen die im Backend
         * fr die Seiten- und Anzahlangabe eingegeben werden
         * knnen. (hoffe ich zumindest :-D).
         */

        for($i = 1; $i <= $seiten; $i++)
        {          
            if($i > 1)
            {
                $von = 0 + $bis;
                $vonZahl = $von + 1;
            } else {
                $von = 0;
                $vonZahl = 1;
            }
            if($i == $seiten)
            {
                $bis = $max;
                $limitBis = $max - $von;
            } else {
                $bis = $i * $this->anzahl_pro_seite;
                $limitBis = $this->anzahl_pro_seite;
            }

            if($max > $this->anzahl_pro_seite)
            {
                $limit = ' limit ' . $von . ',' . $limitBis;
            } else {
                $limit = ' limit ' . $von . ',' . $max;
            }

            if($getSeite == $i)
            {
                $class = ' class="bestActive"';
            } else {
                if($getSeite == 0 && $i == 1)
                {
                    $class = ' class="bestActive"';
                } else {
                    $class = '';
                }
                
            }

            if($max > $i)
            {
                if($i == 1)
                {
                    $seitenlink = xtc_href_link(self::FILENAME_BESTSELLER_CHARTS, '','NONSSL');
                } else {
                    $seitenlink = xtc_href_link(self::FILENAME_BESTSELLER_CHARTS, 'seite='.$i,'NONSSL'); 
                }

                $arrLinksLimit[$i] = array(
                                    'seite' => $i,
                                    'limit' => $limit,
                                    'link'  => $seitenlink,
                                    'von'   => $vonZahl,
                                    'bis'   => $bis,
                                    'class' => $class,
                                );
            }
        }

        if($getSeite == 0 || $getSeite > sizeof($arrLinksLimit))
        {
            $limits = $arrLinksLimit[1]['limit'];
        } else {
            $limits = $arrLinksLimit[$getSeite]['limit'];
        }

        /**
         * Der Rckgabewert ist entweder
         * ein Array mit dem Men oder nur
         * limits, fr die SQL-Abfrage.
         * Warum einfach, wenn es auch
         * kompliziert geht.
         */
        if($return == 'limits')
        {
            return $limits;
        } else {
            return $arrLinksLimit;
        }
    }



    /**
     * get refreshDate
     * @return int
     */
    public function getRefreshDate()
    {
        /**
         *  Auswahl nach Stunden (0) oder Tagen (1)
         */
        switch($this->intervall_text)
        {
            case 0:
                $teiler = 3600 * $this->intervall;
                break;
            case 1:
                $teiler = 3600 * 24 * $this->intervall;
                break;
        }
  
        $refreshDate = $this->letzte_aktualisierung + $teiler;
 
        return $refreshDate;
    }

    /**
     * check if update bestseller
     * @return boolean
     */
    public function getChekDateUpdate()
    {
        /**
         * Ist das aktuelle Datum > oder =
         * dem Refresh-Datum, kann geupdated werden
         */
        if(time() >= $this->getRefreshDate())
        {
            return 1;
        } else {
            return 0;
        }
    }
}

?>