<?php
/**
 * Bestseller-Charts fr xtcModifed und xt:Commerce SP2.1
 *
 * @license GPLv2
 * @author Hans-Peter Sausen
 * @copyright 2010 www.web4design.de
 * @version 1.0
 */

require ('includes/application_top.php');
require_once 'includes/modules/carp/carp.php';
require_once ("../web4design-de/bestsellercharts/lang/".$_SESSION['language']."/admin_bestellercharts.php");
require (DIR_FS_CATALOG.DIR_WS_CLASSES.'xtcPrice.php');
$xtPrice = new xtcPrice(DEFAULT_CURRENCY, $_SESSION['customers_status']['customers_status_id']);

function __autoload($class_name)
{
    $file = '../web4design-de/bestsellercharts/class/' . $class_name . '.php';
    if (!file_exists($file)) return false;
    require $file;
}

$charts  = new BestsellerCharts;

if(!empty($_POST['action']))
{
    $charts->setAdminUpdateBestseller($_POST);
}


?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $_SESSION['language_charset']; ?>"> 
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<link rel="stylesheet" type="text/css" href="<?php echo $charts->admin_path; ?>/styles/bestseller.css">
<script src="<?php echo $charts->admin_path; ?>js/checkall.js" type="text/javascript"></script>
</head>
<body>
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<table border="0" width="100%" cellspacing="2" cellpadding="2">
    <tr>
        <td class="columnLeft2" width="<?php echo BOX_WIDTH; ?>" valign="top">
            <table border="0" width="<?php echo BOX_WIDTH; ?>" cellspacing="1" cellpadding="1" class="columnLeft">
                <?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
            </table>
        </td>
        <td class="boxCenter" width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="0">
    <tr>
        <td>
            <table border="0" width="100%" cellspacing="0" cellpadding="0">
                <tr>
                    <td width="80" rowspan="2"><img src="../web4design-de/bestsellercharts/admin/images/adminicon.jpg" alt="<?php echo BESTCOPY; ?>" title="<?php echo BESTCOPY; ?>" /></td>
                    <td class="pageHeading"><?php echo TITLE_BEWERTUNGEN; ?></td>
                </tr>
                <tr>
                    <td class="main" valign="top"><?php echo SUB_TITLE_BEWERTUNGEN; ?></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td style="vertical-align: top;">
            <div style="text-align: right; width: 860px;"><a href="http://www.speed4project.de/xtc_module_anleitung/bestseller/index.html" style="color: #ff0000; font-size: 14px; font-weight: bold;" target="_blank">Anleitung &raquo;</a></div>
            <div class="bestsellerbox">
                                <div id="topmenu">
                    <?php include ($charts->admin_path.'topmenu.php'); ?>
                </div>

                 <form action="<?php echo xtc_href_link(BestsellerCharts::FILENAME_BESTSELLER_VERWALTEN, 'page='.$_GET['page']); ?>" method="post">
                <div class="topbox">
                   
                                <select name="action" size="1">
                                    <option value="aktualisieren"><?php echo AKTUALISIEREN; ?></option>
                                    <option value="">&nbsp;</option>
                                    <option value="">&nbsp;</option>
                                    <option value="deleteown"><?php echo DELETE_ALL_OWN; ?></option>
                                    <?php
                                    $blocked = ' readonly="readonly" class="inputreadonly" ';

                                    if($charts->blockiere_bestellte_produkte == 0)
                                    {
                                        $blocked = '';
                                    ?>
                                    <option value="">&nbsp;</option>
                                    <option value="">&nbsp;</option>
                                    <option value="deletevkerkauft"><?php echo DELETE_ALL_BOUGHT; ?></option>
                                    <option value="deleteall"><?php echo DELETE_ALL; ?></option>
                                    <?php } ?>
                                </select>
                                <input type="hidden" name="page" value="<?php echo $_GET['page']; ?>">
                                <input type="submit" name="" value="<?php echo AUSFUEHREN; ?>" />
                </div>
                
                <div class="borderbox">
                        <table width="850" cellpadding="4" cellspacing="0" class="maintab">
                            <tr>
                                <th width="70"><?php echo POSITION; ?></th>
                                <th width="50"><?php echo BILD; ?></th>
                                <th width="510"><?php echo NAME; ?></th>
                                <th width="110"><?php echo GEKAUFT; ?></th>
                                <th width="110"><?php echo SELBST_GEKAUFT; ?></th>
                            </tr> 
<?php
                                $bestsellerQuery = $charts->getSqlBestellerChartsAdmin();
                                $chartsSplit = new splitPageResults($_GET['page'], $charts->anzahl_pro_seite_admin, $bestsellerQuery, $bestseller_query_numrows);
                                $bestsellerQueryExecute = xtc_db_query($bestsellerQuery);
                               // 
                               //   $i = 1 * ($_GET['page'] + $charts->anzahl_pro_seite_admin);
                                $i = 1 + (($_GET['page'] - 1) * $charts->anzahl_pro_seite_admin);

                                while ($bestseller = xtc_db_fetch_array($bestsellerQueryExecute))
                                {
?>
                            <tr<?php if ($i == 1){echo ' class="cyclecolor"';}?>>
                                <td class="position" style="vertical-align: middle;"><?php echo $i++;
                                echo '<input type="hidden" name="products_id[]" value="'.$bestseller['products_id'].'" />';
                                
                                ?></td>
                                <td><?php
                                if($charts->anzeige_bild == 1)
                                {
                                    echo '<img src="' . DIR_WS_CATALOG_THUMBNAIL_IMAGES.$bestseller['products_image'] . '" height="40" />';
                                }
                                ?>&nbsp;</td>
                                <td class="tdp"><?php
                                echo '<p>' . $bestseller['products_name']. '</p>';
                                if($charts->anzeige_art == 1)
                                {
                                    echo '<p class="light"><strong>' . MODEL . '</strong> ' . $bestseller['products_model'].'</p>';
                                }
                                if($charts->anzeige_preis == 1)
                                {
                                    echo '<p class="light"><strong>' . PREIS . '</strong> ';
                                    $price = $xtPrice->xtcGetPrice($bestseller['products_id'], $format = true, 1, $bestseller['products_tax_class_id'], $$bestseller['products_price'], 1);
                                    echo $price['formated'];
                                    echo '</p>';
                                }
                                if($charts->anzeige_herst == 1)
                                {
                                    echo '<p class="light"><strong>' . HERSTELLER . '</strong> ' .$bestseller['manufacturers_name'] . '</p>';
                                }
                                
                                ?></td>
                                <td><input type="text" name="products_ordered[]" value="<?php echo $bestseller['products_ordered'];?>"<?php echo $blocked; ?>size="13"></td>
                                <td><input type="text" name="products_ordered_new[]" value="<?php echo $bestseller['products_ordered_new'];?>" size="13"></td>
                            </tr>
<?php } ?>

                    </table>
                    <p class="clr">&nbsp;</p>
                        <div class="leftupdatebox">
                            &nbsp;
                            </div>
                    </form> 
                        <div class="rightpagebox">
                            <?php echo $chartsSplit->display_count($bestseller_query_numrows, $charts->anzahl_pro_seite_admin, $_GET['page'], ANZAHL_VON_BIS); ?>&nbsp;&nbsp;
                            <?php echo $chartsSplit->display_links($bestseller_query_numrows, $charts->anzahl_pro_seite_admin, MAX_DISPLAY_PAGE_LINKS, $_GET['page']); ?>
                        </div>
                        <p class="clr">&nbsp;</p>
                </td>
            </table>
        </td>
    </tr>
</table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>