<?php
/* -----------------------------------------------------------------
* 	ID:						$Id: tagcloud.php 2 2011-02-17 13:35:25Z akausch $
* 	Letzter Stand:			$Revision: 2 $
* 	zuletzt geändert von: 	$Author: akausch $
* 	Datum:					$Date: 2011-02-17 14:35:25 +0100 (Do, 17. Feb 2011) $
*
* 	commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
*
* 	Copyright (c) since 2010 commerce:SEO
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
*
* 	Released under the GNU General Public License
* --------------------------------------------------------------- */

$box_smarty = new smarty;

if(!CacheCheck())
	$box_smarty->caching = 0;
else {
	$box_smarty->caching = 1;
	$box_smarty->cache_lifetime=CACHE_LIFETIME;
	$box_smarty->cache_modified_check=CACHE_CHECK;
	$cache_id = $_SESSION['language'].$_SESSION['tag_box'];
}

if(!$box_smarty->is_cached(CURRENT_TEMPLATE.'/boxes/box_tagcloud.html', $cache_id) || !$cache){
	function kshuffle(&$array) {
	    if(!is_array($array) || empty($array))
	        return false;
	    $tmp = array();
	    foreach($array as $key => $value)
	        $tmp[] = array('k' => $key, 'v' => $value);

	    shuffle($tmp);
	    $array = array();
	    foreach($tmp as $entry)
	        $array[$entry['k']] = $entry['v'];
	    return true;
	}

	function printTagCloud($tags) {

		kshuffle($tags); // Zufällige Anzeige

	    $max_size = MAX_DISPLAY_TAGS_FONT; // max font size in pixels
	    $min_size = MIN_DISPLAY_TAGS_FONT; // min font size in pixels

	    $max_qty = max(array_values($tags));
	    $min_qty = min(array_values($tags));

	    $spread = $max_qty - $min_qty;
	    if($spread == 0)
	        $spread = 1;

	    $step = ($max_size - $min_size) / ($spread);

	    foreach ($tags as $key => $value) {
			$size = round($min_size + (($value - $min_qty) * $step));
			$cloud .= '<a href="'.xtc_href_link('tag/'.urlencode($key)).'/" style="font-size:'.$size.'px;" title="' . $value . ' Produkte wurden mit ' . $key . ' getagged">' . $key . '</a> ';
	    }
	    return $cloud;
	}

	$data_query = xtc_db_query("SELECT
									tag, count(tag) AS tag_anzahl
								FROM
									tag_to_product
								WHERE
									lID = '".$_SESSION['languages_id']."'
								GROUP BY
									tag
								ORDER BY
									rand()
								LIMIT ".MAX_DISPLAY_TAGS_RESULTS."");

	if(xtc_db_num_rows($data_query)) {
		$tag_array = array();
		while($data = xtc_db_fetch_array($data_query)) {
			if(!empty($data))
				$tag_array[$data['tag']] = $data['tag_anzahl'];
		}
	}
	if(is_array($tag_array))
		$tag_cloud = printTagCloud($tag_array);

	$box_smarty->assign('BOX_CONTENT', $tag_cloud);
}

if(!$cache)
	$box_content = $box_smarty->fetch(CURRENT_TEMPLATE.'/boxes/box_tagcloud.html');
else
	$box_content = $box_smarty->fetch(CURRENT_TEMPLATE.'/boxes/box_tagcloud.html', $cache_id);
?>