# -----------------------------------------------------------------
# 	ID:						$Id: commerce_seo.sql 2 2011-02-17 13:35:25Z akausch $
# 	Letzter Stand:			$Revision: 2 $
# 	zuletzt geändert von: 	$Author: akausch $
# 	Datum:					$Date: 2011-02-17 14:35:25 +0100 (Do, 17. Feb 2011) $
#
# 	commerce:SEO by Webdesign Erfurt
# 	http://www.commerce-seo.de
#
# 	Copyright (c) since 2010 commerce:SEO
# ------------------------------------------------------------------
# 	based on:
# 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
# 	(c) 2002-2003 osCommerce - www.oscommerce.com
# 	(c) 2003     nextcommerce - www.nextcommerce.org
# 	(c) 2005     xt:Commerce - www.xt-commerce.com
#
# 	Released under the GNU General Public License
# --------------------------------------------------------------- 

DROP TABLE IF EXISTS address_book;
CREATE TABLE address_book (
  address_book_id INT NOT NULL auto_increment,
  customers_id INT NOT NULL,
  entry_gender char(1) NOT NULL,
  entry_company VARCHAR(32),
  entry_firstname VARCHAR(32) NOT NULL,
  entry_lastname VARCHAR(32) NOT NULL,
  entry_street_address VARCHAR(64) NOT NULL,
  entry_suburb VARCHAR(32),
  entry_postcode VARCHAR(10) NOT NULL,
  entry_city VARCHAR(32) NOT NULL,
  entry_state VARCHAR(32),
  entry_country_id INT DEFAULT '0' NOT NULL,
  entry_zone_id INT DEFAULT '0' NOT NULL,
  address_date_added datetime DEFAULT '0000-00-00 00:00:00',
  address_last_modified datetime DEFAULT '0000-00-00 00:00:00',
  address_class VARCHAR( 32 ) NOT NULL,
  PRIMARY KEY (address_book_id),
  KEY idx_address_book_customers_id (customers_id),
  KEY entry_country_id (entry_country_id),
  KEY entry_zone_id (entry_zone_id)
);

DROP TABLE IF EXISTS boxes;
CREATE TABLE IF NOT EXISTS boxes (
  id INT(11) NOT NULL auto_increment,
  box_name VARCHAR(32) NOT NULL,
  position VARCHAR(16) NOT NULL,
  sort_id INT(4) NOT NULL,
  status INT(1) NOT NULL DEFAULT '1',
  box_type VARCHAR(16) NOT NULL,
  file_flag INT(2) NOT NULL,
  PRIMARY KEY (id)
);

DROP TABLE IF EXISTS boxes_names;
CREATE TABLE IF NOT EXISTS boxes_names (
  id INT(11) NOT NULL auto_increment,
  box_name VARCHAR(32) NOT NULL,
  box_title VARCHAR(32) NOT NULL,
  box_desc text NOT NULL,
  language_id INT(2) NOT NULL,
  status INT(1) NOT NULL DEFAULT '1',
  PRIMARY KEY  (id)
);

DROP TABLE IF EXISTS boxes_positions;
CREATE TABLE IF NOT EXISTS boxes_positions (
  id INT(11) NOT NULL auto_increment,
  position_name VARCHAR(16) NOT NULL,
  PRIMARY KEY (id)
);

DROP TABLE IF EXISTS boxes_styles;
CREATE TABLE IF NOT EXISTS boxes_styles (
  id INT(11) NOT NULL auto_increment,
  box_name VARCHAR(32) NOT NULL,
  border_color VARCHAR(6) NOT NULL,
  background_content VARCHAR(32) NOT NULL,
  color_content VARCHAR(6) NOT NULL,
  background_head VARCHAR(32) NOT NULL,
  color_head VARCHAR(6) NOT NULL,
  PRIMARY KEY (id)
);

DROP TABLE IF EXISTS customers_memo;
CREATE TABLE customers_memo (
  memo_id INT(11) NOT NULL auto_increment,
  customers_id INT(11) NOT NULL DEFAULT '0',
  memo_date date NOT NULL DEFAULT '0000-00-00',
  memo_title text NOT NULL,
  memo_text text NOT NULL,
  poster_id INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (memo_id)
);

DROP TABLE IF EXISTS products_xsell;
CREATE TABLE products_xsell (
  ID INT(10) NOT NULL auto_increment,
  products_id INT(10) NOT NULL DEFAULT '1',
  products_xsell_grp_name_id INT(10) NOT NULL DEFAULT '1',
  xsell_id INT(10) NOT NULL DEFAULT '1',
  sort_order INT(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (ID)
);

DROP TABLE IF EXISTS products_xsell_grp_name;
CREATE TABLE products_xsell_grp_name (
  products_xsell_grp_name_id INT(10) NOT NULL,
  xsell_sort_order INT(10) NOT NULL DEFAULT '0',
  language_id smallint(6) NOT NULL DEFAULT '0',
  groupname VARCHAR(255) NOT NULL DEFAULT ''
);

DROP TABLE IF EXISTS campaigns;
CREATE TABLE campaigns (
  campaigns_id INT(11) NOT NULL auto_increment,
  campaigns_name VARCHAR(32) NOT NULL DEFAULT '',
  campaigns_refID VARCHAR(64) DEFAULT NULL,
  campaigns_leads INT(11) NOT NULL DEFAULT '0',
  date_added datetime DEFAULT NULL,
  last_modified datetime DEFAULT NULL,
  PRIMARY KEY  (campaigns_id),
  KEY IDX_CAMPAIGNS_NAME (campaigns_name)
);

DROP TABLE IF EXISTS campaigns_ip;
CREATE TABLE  campaigns_ip (
 user_ip VARCHAR( 15 ) NOT NULL ,
 time DATETIME NOT NULL ,
 campaign VARCHAR( 32 ) NOT NULL
);

DROP TABLE IF EXISTS address_format;
CREATE TABLE address_format (
  address_format_id INT NOT NULL auto_increment,
  address_format VARCHAR(128) NOT NULL,
  address_summary VARCHAR(48) NOT NULL,
  PRIMARY KEY (address_format_id)
);

DROP TABLE IF EXISTS database_version;
CREATE TABLE database_version (
  version VARCHAR(32) NOT NULL
);

DROP TABLE IF EXISTS admin_access;
CREATE TABLE admin_access (
  customers_id VARCHAR(32) NOT NULL DEFAULT '0',
  configuration INT(1) NOT NULL DEFAULT '0',
  modules INT(1) NOT NULL DEFAULT '0',
  countries INT(1) NOT NULL DEFAULT '0',
  currencies INT(1) NOT NULL DEFAULT '0',
  zones INT(1) NOT NULL DEFAULT '0',
  geo_zones INT(1) NOT NULL DEFAULT '0',
  tax_classes INT(1) NOT NULL DEFAULT '0',
  tax_rates INT(1) NOT NULL DEFAULT '0',
  accounting INT(1) NOT NULL DEFAULT '0',
  backup INT(1) NOT NULL DEFAULT '0',
  cache INT(1) NOT NULL DEFAULT '0',
  server_info INT(1) NOT NULL DEFAULT '0',
  whos_online INT(1) NOT NULL DEFAULT '0',
  languages INT(1) NOT NULL DEFAULT '0',
  define_language INT(1) NOT NULL DEFAULT '0',
  orders_status INT(1) NOT NULL DEFAULT '0',
  shipping_status INT(1) NOT NULL DEFAULT '0',
  module_export INT(1) NOT NULL DEFAULT '0',
  filemanager INT(1) NOT NULL DEFAULT '0',
  database_manager INT(1) NOT NULL DEFAULT '0',
  customers INT(1) NOT NULL DEFAULT '0',
  create_account INT(1) NOT NULL DEFAULT '0',
  customers_status INT(1) NOT NULL DEFAULT '0',
  orders INT(1) NOT NULL DEFAULT '0',
  campaigns INT(1) NOT NULL DEFAULT '0',
  print_packingslip INT(1) NOT NULL DEFAULT '0',
  print_order INT(1) NOT NULL DEFAULT '0',
  popup_memo INT(1) NOT NULL DEFAULT '0',
  coupon_admin INT(1) NOT NULL DEFAULT '0',
  listcategories INT(1) NOT NULL DEFAULT '0',
  listproducts INT(1) NOT NULL DEFAULT '0',
  gv_queue INT(1) NOT NULL DEFAULT '0',
  gv_mail INT(1) NOT NULL DEFAULT '0',
  gv_sent INT(1) NOT NULL DEFAULT '0',
  validproducts INT(1) NOT NULL DEFAULT '0',
  validcategories INT(1) NOT NULL DEFAULT '0',
  mail INT(1) NOT NULL DEFAULT '0',
  emails INT(1) NOT NULL DEFAULT '0',
  categories INT(1) NOT NULL DEFAULT '0',
  new_attributes INT(1) NOT NULL DEFAULT '0',
  janolaw INT(1) NOT NULL DEFAULT '0',
  delete_cache INT(1) NOT NULL DEFAULT '0',
  products_attributes INT(1) NOT NULL DEFAULT '0',
  price_change INT(1) NOT NULL DEFAULT '0',
  manufacturers INT(1) NOT NULL DEFAULT '0',
  reviews INT(1) NOT NULL DEFAULT '0',
  specials INT(1) NOT NULL DEFAULT '0',
  stats_products_expected INT(1) NOT NULL DEFAULT '0',
  stats_products_viewed INT(1) NOT NULL DEFAULT '0',
  stats_products_purchased INT(1) NOT NULL DEFAULT '0',
  stats_customers INT(1) NOT NULL DEFAULT '0',
  stats_sales_report INT(1) NOT NULL DEFAULT '0',
  stats_stock_warning INT(1) NOT NULL DEFAULT '0',
  stats_stock_warning_print INT(1) NOT NULL DEFAULT '0',
  stats_campaigns INT(1) NOT NULL DEFAULT '0',
  stats_keywords_all INT(1) NOT NULL DEFAULT '0',
  stats_keywords_all_print INT(1) NOT NULL DEFAULT '0',
  banner_manager INT(1) NOT NULL DEFAULT '0',
  banner_statistics INT(1) NOT NULL DEFAULT '0',
  module_newsletter INT(1) NOT NULL DEFAULT '0',
  start INT(1) NOT NULL DEFAULT '0',
  box_manager INT(1) NOT NULL DEFAULT '0',
  content_manager INT(1) NOT NULL DEFAULT '0',
  content_preview INT(1) NOT NULL DEFAULT '0',
  credits INT(1) NOT NULL DEFAULT '0',
  blacklist INT(1) NOT NULL DEFAULT '0',
  news_ticker INT(1) NOT NULL DEFAULT '0',
  orders_edit INT(1) NOT NULL DEFAULT '0',
  popup_image INT(1) NOT NULL DEFAULT '0',
  csv_backend INT(1) NOT NULL DEFAULT '0',
  products_vpe INT(1) NOT NULL DEFAULT '0',
  products_parameters INT(1) NOT NULL DEFAULT '0',
  products_parameters_edit INT(1) NOT NULL DEFAULT '0',
  cross_sell_groups INT(1) NOT NULL DEFAULT '0',
  fck_wrapper INT(1) NOT NULL DEFAULT '0',
  paypal INT( 1 ) NOT NULL DEFAULT '0',
  customers_sik INT( 1 ) NOT NULL DEFAULT '0',
  novalnet INT( 1 ) NOT NULL DEFAULT '0',
  group_prices INT( 1 ) NOT NULL DEFAULT '0',
  customers_aquise INT( 1 ) NOT NULL DEFAULT '0',
  customers_aquise_request INT( 1 ) NOT NULL DEFAULT '0',
  orders_overview INT( 1 ) NOT NULL DEFAULT '0',
  orders_overview_print INT( 1 ) NOT NULL DEFAULT '0',
  recover_cart_sales INT( 1 ) NOT NULL DEFAULT '0',
  stats_recover_cart_sales INT( 1 ) NOT NULL DEFAULT '0',
  module_newsletter_products INT( 1 ) NOT NULL DEFAULT '0',
  close_cart_new_order INT( 1 ) NOT NULL DEFAULT '0',
  product_listings INT( 1 ) NOT NULL DEFAULT '0',
  css_styler INT( 1 ) NOT NULL DEFAULT '0',
  slimstat INT( 1 ) NOT NULL DEFAULT '0',
  orders_pdf_profiler INT(1) NOT NULL DEFAULT '0',
  create_pdf INT(1) NOT NULL DEFAULT '0',
  create_pdf_download INT(1) NOT NULL DEFAULT '0',
  personal_links INT(1) NOT NULL DEFAULT '0',
  blog INT(1) NOT NULL DEFAULT '0',
  google_sitemap INT(1) NOT NULL DEFAULT '0',
  product_filter INT(1) NOT NULL DEFAULT '0',
  module_order_products INT(1) NOT NULL DEFAULT '0',
  mobile INT(1) NOT NULL DEFAULT '0',
  module_install INT(1) NOT NULL DEFAULT '0',
  module_system INT(1) NOT NULL DEFAULT '0',
  accessories INT(1) NOT NULL DEFAULT '0',
  global_products_price INT(1) NOT NULL DEFAULT '0',
  attribute_manager INT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY  (customers_id)
);

DROP TABLE IF EXISTS customers_sik;
CREATE TABLE customers_sik (
  customers_id INT(11) NOT NULL auto_increment,
  customers_cid VARCHAR(32) DEFAULT NULL,
  customers_vat_id VARCHAR(20) DEFAULT NULL,
  customers_vat_id_status INT(2) NOT NULL DEFAULT '0',
  customers_warning VARCHAR(32) DEFAULT NULL,
  customers_status INT(5) NOT NULL DEFAULT '1',
  customers_gender char(1) NOT NULL,
  customers_firstname VARCHAR(32) NOT NULL,
  customers_lastname VARCHAR(32) NOT NULL,
  customers_dob datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  customers_email_address VARCHAR(96) NOT NULL,
  customers_DEFAULT_address_id INT(11) NOT NULL,
  customers_telephone VARCHAR(32) NOT NULL,
  customers_fax VARCHAR(32) DEFAULT NULL,
  customers_password VARCHAR(40) NOT NULL,
  customers_newsletter char(1) DEFAULT NULL,
  customers_newsletter_mode char(1) NOT NULL DEFAULT '0',
  member_flag char(1) NOT NULL DEFAULT '0',
  delete_user char(1) NOT NULL DEFAULT '1',
  account_type INT(1) NOT NULL DEFAULT '0',
  password_request_key VARCHAR(32) NOT NULL,
  payment_unallowed VARCHAR(255) NOT NULL,
  shipping_unallowed VARCHAR(255) NOT NULL,
  refferers_id INT(5) NOT NULL DEFAULT '0',
  customers_date_added datetime DEFAULT '0000-00-00 00:00:00',
  customers_last_modified datetime DEFAULT '0000-00-00 00:00:00',
  datensg datetime DEFAULT NULL,
  login_tries VARCHAR( 2 ) NOT NULL DEFAULT '0',
  login_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY  (customers_id)
);

DROP TABLE IF EXISTS customers_wishlist;
CREATE TABLE customers_wishlist (
  customers_basket_id INT(11) NOT NULL auto_increment,
  customers_id INT(11) NOT NULL DEFAULT '0',
  products_id tinytext collate latin1_general_ci NOT NULL,
  customers_basket_quantity INT(2) NOT NULL DEFAULT '0',
  final_price decimal(15,4) NOT NULL DEFAULT '0.0000',
  customers_basket_date_added VARCHAR(8) DEFAULT NULL,
  PRIMARY KEY  (customers_basket_id)
);

DROP TABLE IF EXISTS customers_wishlist_attributes;
CREATE TABLE customers_wishlist_attributes (
  customers_basket_attributes_id INT(11) NOT NULL auto_increment,
  customers_id INT(11) NOT NULL DEFAULT '0',
  products_id tinytext collate latin1_general_ci NOT NULL,
  products_options_id INT(11) NOT NULL DEFAULT '0',
  products_options_value_id INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY  (customers_basket_attributes_id)
);

DROP TABLE IF EXISTS banktransfer;
CREATE TABLE banktransfer (
  orders_id INT(11) NOT NULL DEFAULT '0',
  banktransfer_owner VARCHAR(64) DEFAULT NULL,
  banktransfer_number VARCHAR(24) DEFAULT NULL,
  banktransfer_bankname VARCHAR(255) DEFAULT NULL,
  banktransfer_blz VARCHAR(8) DEFAULT NULL,
  banktransfer_status INT(11) DEFAULT NULL,
  banktransfer_prz char(2) DEFAULT NULL,
  banktransfer_fax char(2) DEFAULT NULL,
  KEY orders_id(orders_id)
);

DROP TABLE IF EXISTS news_ticker;
CREATE TABLE news_ticker (
  id INT(11) NOT NULL auto_increment,
  ticker_text text NOT NULL,
  language_id INT(2) NOT NULL,
  status INT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY  (id)
);

DROP TABLE IF EXISTS banners;
CREATE TABLE banners (
  banners_id INT NOT NULL auto_increment,
  banners_title VARCHAR(64) NOT NULL,
  banners_url VARCHAR(255) NOT NULL,
  banners_image VARCHAR(64) NOT NULL,
  banners_group VARCHAR(10) NOT NULL,
  banners_html_text text,
  expires_impressions INT(7) DEFAULT '0',
  expires_date datetime DEFAULT NULL,
  date_scheduled datetime DEFAULT NULL,
  date_added datetime NOT NULL,
  date_status_change datetime DEFAULT NULL,
  status INT(1) DEFAULT '1' NOT NULL,
  PRIMARY KEY (banners_id),
  KEY status (status,banners_group)
);

DROP TABLE IF EXISTS banners_history;
CREATE TABLE banners_history (
  banners_history_id INT NOT NULL auto_increment,
  banners_id INT NOT NULL,
  banners_shown INT(5) NOT NULL DEFAULT '0',
  banners_clicked INT(5) NOT NULL DEFAULT '0',
  banners_history_date datetime NOT NULL,
  PRIMARY KEY  (banners_history_id)
);

DROP TABLE IF EXISTS commerce_seo_url;
CREATE TABLE IF NOT EXISTS commerce_seo_url (
  url_md5 VARCHAR(32) NOT NULL DEFAULT '',
  url_text VARCHAR(255) NOT NULL DEFAULT '',
  products_id INT(11) DEFAULT NULL,
  categories_id INT(11) DEFAULT NULL,
  blog_id INT(11) DEFAULT NULL,
  blog_cat INT(11) DEFAULT NULL,
  content_group INT(11) DEFAULT NULL,
  language_id INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (url_md5),
  KEY url_text (url_text,products_id)
);

DROP TABLE IF EXISTS categories;
CREATE TABLE categories (
  categories_id INT NOT NULL auto_increment,
  categories_image VARCHAR(64),
  parent_id INT DEFAULT '0' NOT NULL,
  section INT DEFAULT '0' NOT NULL,
  categories_status TINYint (1)  UNSIGNED DEFAULT "1" NOT NULL,
  categories_template VARCHAR(64),
  group_permission_0 TINYINT(1) NOT NULL,
  group_permission_1 TINYINT(1) NOT NULL,
  group_permission_2 TINYINT(1) NOT NULL,
  group_permission_3 TINYINT(1) NOT NULL,
  listing_template VARCHAR(64),
  sort_order INT(3) DEFAULT '0' NOT NULL,
  products_sorting VARCHAR(32),
  products_sorting2 VARCHAR(32),
  date_added datetime,
  last_modified datetime,
  categories_col_top TINYINT(1) NOT NULL DEFAULT 1,
  categories_col_left TINYINT(1) NOT NULL DEFAULT 1,
  categories_col_right TINYINT(1) NOT NULL DEFAULT 1,
  categories_col_bottom TINYINT(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (categories_id),
  KEY idx_categories_parent_id (parent_id),
  KEY categories_id (categories_id,parent_id,categories_status,sort_order),
  KEY parent_id (parent_id,categories_status,sort_order),
  KEY categories_status (categories_status)
);

DROP TABLE IF EXISTS categories_description;
CREATE TABLE categories_description (
  categories_id INT DEFAULT '0' NOT NULL,
  language_id INT DEFAULT '1' NOT NULL,
  categories_name VARCHAR(32) NOT NULL,
  categories_heading_title VARCHAR(255) NOT NULL,
  categories_description TEXT NOT NULL,
  categories_description_footer TEXT NULL,
  categories_pic_alt VARCHAR(64) NOT NULL,
  categories_meta_title VARCHAR(100) NOT NULL,
  categories_meta_description VARCHAR(255) NOT NULL,
  categories_meta_keywords VARCHAR(255) NOT NULL,
  categories_url_alias VARCHAR(64) NULL,
  categories_google_taxonomie  TEXT NULL,
  PRIMARY KEY (categories_id, language_id),
  KEY idx_categories_name (categories_name)
);

DROP TABLE IF EXISTS configuration;
CREATE TABLE configuration (
  configuration_id INT NOT NULL auto_increment,
  configuration_key VARCHAR(64) NOT NULL,
  configuration_value VARCHAR(255) NOT NULL,
  configuration_group_id INT NOT NULL,
  sort_order INT(5) NULL,
  last_modified datetime NULL,
  date_added datetime NOT NULL,
  use_function VARCHAR(255) NULL,
  set_function VARCHAR(255) NULL,
  PRIMARY KEY (configuration_id),
  KEY idx_configuration_group_id (configuration_group_id)
);

DROP TABLE IF EXISTS configuration_group;
CREATE TABLE configuration_group (
  configuration_group_id INT NOT NULL auto_increment,
  configuration_group_title VARCHAR(64) NOT NULL,
  configuration_group_description VARCHAR(255) NOT NULL,
  sort_order INT(5) NULL,
  visible INT(1) DEFAULT '1' NULL,
  PRIMARY KEY (configuration_group_id)
);

DROP TABLE IF EXISTS counter;
CREATE TABLE counter (
  startdate char(8),
  counter INT(12)
);

DROP TABLE IF EXISTS counter_history;
CREATE TABLE counter_history (
  month char(8),
  counter INT(12)
);

DROP TABLE IF EXISTS countries;
CREATE TABLE countries (
  countries_id INT NOT NULL auto_increment,
  countries_name VARCHAR(64) NOT NULL,
  countries_iso_code_2 char(2) NOT NULL,
  countries_iso_code_3 char(3) NOT NULL,
  address_format_id INT NOT NULL,
  status INT(1) DEFAULT '1' NULL,
  PRIMARY KEY (countries_id),
  KEY IDX_COUNTRIES_NAME (countries_name)
);

DROP TABLE IF EXISTS currencies;
CREATE TABLE currencies (
  currencies_id INT NOT NULL auto_increment,
  title VARCHAR(32) NOT NULL,
  code char(3) NOT NULL,
  symbol_left VARCHAR(12),
  symbol_right VARCHAR(12),
  decimal_point char(1),
  thousands_point char(1),
  decimal_places char(1),
  value float(13,8),
  last_updated datetime NULL,
  PRIMARY KEY (currencies_id)
);

DROP TABLE IF EXISTS customers;
CREATE TABLE customers (
  customers_id INT NOT NULL auto_increment,
  customers_cid VARCHAR(32),
  customers_vat_id VARCHAR (20),
  customers_vat_id_status INT(2) DEFAULT '0' NOT NULL,
  customers_warning VARCHAR(32),
  customers_status INT(5) DEFAULT '1' NOT NULL,
  customers_gender char(1) NOT NULL,
  customers_firstname VARCHAR(32) NOT NULL,
  customers_lastname VARCHAR(32) NOT NULL,
  customers_dob datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  customers_email_address VARCHAR(96) NOT NULL,
  customers_default_address_id INT NOT NULL,
  customers_telephone VARCHAR(32) NOT NULL,
  customers_fax VARCHAR(32),
  customers_password VARCHAR(40) NOT NULL,
  customers_newsletter char(1),
  customers_newsletter_mode char( 1 ) DEFAULT '0' NOT NULL,
  member_flag char(1) DEFAULT '0' NOT NULL,
  delete_user char(1) DEFAULT '1' NOT NULL,
  account_type INT(1) NOT NULL DEFAULT '0',
  password_request_key VARCHAR(32) NOT NULL,
  payment_unallowed VARCHAR(255) NOT NULL,
  shipping_unallowed VARCHAR(255) NOT NULL,
  refferers_id VARCHAR(32) DEFAULT '0' NOT NULL,
  customers_date_added datetime DEFAULT '0000-00-00 00:00:00',
  customers_last_modified datetime DEFAULT '0000-00-00 00:00:00',
  datensg DATETIME NULL,
  login_tries VARCHAR( 2 ) NOT NULL DEFAULT '0',
  login_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (customers_id)
);

DROP TABLE IF EXISTS customers_basket;
CREATE TABLE customers_basket (
  customers_basket_id INT NOT NULL auto_increment,
  customers_id INT NOT NULL,
  products_id tinytext NOT NULL,
  customers_basket_quantity INT(2) NOT NULL,
  final_price decimal(15,4) NOT NULL,
  customers_basket_date_added char(8),
  checkout_site enum('cart','shipping','payment','confirm') NOT NULL DEFAULT 'cart',
  language VARCHAR(32) DEFAULT NULL,
  PRIMARY KEY (customers_basket_id)
);

DROP TABLE IF EXISTS customers_basket_attributes;
CREATE TABLE customers_basket_attributes (
  customers_basket_attributes_id INT NOT NULL auto_increment,
  customers_id INT NOT NULL,
  products_id tinytext NOT NULL,
  products_options_id INT NOT NULL,
  products_options_value_id INT NOT NULL,
  PRIMARY KEY (customers_basket_attributes_id)
);

DROP TABLE IF EXISTS customers_info;
CREATE TABLE customers_info (
  customers_info_id INT NOT NULL,
  customers_info_date_of_last_logon datetime,
  customers_info_number_of_logons INT(5),
  customers_info_date_account_created datetime,
  customers_info_date_account_last_modified datetime,
  global_product_notifications INT(1) DEFAULT '0',
  PRIMARY KEY (customers_info_id)
);

DROP TABLE IF EXISTS customers_ip;
CREATE TABLE customers_ip (
  customers_ip_id INT(11) NOT NULL auto_increment,
  customers_id INT(11) NOT NULL DEFAULT '0',
  customers_ip VARCHAR(15) NOT NULL DEFAULT '',
  customers_ip_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  customers_host VARCHAR(255) NOT NULL DEFAULT '',
  customers_advertiser VARCHAR(30) DEFAULT NULL,
  customers_referer_url VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY  (customers_ip_id),
  KEY customers_id (customers_id)
);

DROP TABLE IF EXISTS customers_status;
CREATE TABLE customers_status (
  customers_status_id INT(11) NOT NULL DEFAULT '0',
  language_id INT(11) NOT NULL DEFAULT '1',
  customers_status_name VARCHAR(32) NOT NULL DEFAULT '',
  customers_status_public INT(1) NOT NULL DEFAULT '1',
  customers_status_min_order INT(7) DEFAULT NULL,
  customers_status_max_order INT(7) DEFAULT NULL,
  customers_status_image VARCHAR(64) DEFAULT NULL,
  customers_status_discount decimal(4,2) DEFAULT '0',
  customers_status_ot_discount_flag char(1) NOT NULL DEFAULT '0',
  customers_status_ot_discount decimal(4,2) DEFAULT '0',
  customers_status_graduated_prices VARCHAR(1) NOT NULL DEFAULT '0',
  customers_status_show_price INT(1) NOT NULL DEFAULT '1',
  customers_status_show_price_tax INT(1) NOT NULL DEFAULT '1',
  customers_status_add_tax_ot  INT(1) NOT NULL DEFAULT '0',
  customers_status_payment_unallowed VARCHAR(255) NOT NULL,
  customers_status_shipping_unallowed VARCHAR(255) NOT NULL,
  customers_status_discount_attributes  INT(1) NOT NULL DEFAULT '0',
  customers_fsk18 INT(1) NOT NULL DEFAULT '1',
  customers_fsk18_display INT(1) NOT NULL DEFAULT '1',
  customers_status_write_reviews INT(1) NOT NULL DEFAULT '1',
  customers_status_read_reviews INT(1) NOT NULL DEFAULT '1',
  PRIMARY KEY  (customers_status_id,language_id),
  KEY idx_orders_status_name (customers_status_name)
);

DROP TABLE IF EXISTS customers_status_history;
CREATE TABLE customers_status_history (
  customers_status_history_id INT(11) NOT NULL auto_increment,
  customers_id INT(11) NOT NULL DEFAULT '0',
  new_value INT(5) NOT NULL DEFAULT '0',
  old_value INT(5) DEFAULT NULL,
  date_added datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  customer_notified INT(1) DEFAULT '0',
  PRIMARY KEY  (customers_status_history_id)
);

DROP TABLE IF EXISTS languages;
CREATE TABLE languages (
  languages_id INT NOT NULL auto_increment,
  name VARCHAR(32)  NOT NULL,
  code char(2) NOT NULL,
  image VARCHAR(64),
  directory VARCHAR(32),
  sort_order INT(3),
  language_charset TEXT NOT NULL,
  status INT(1) NOT NULL DEFAULT '0',
  status_admin INT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (languages_id),
  KEY IDX_LANGUAGES_NAME (name)
);

DROP TABLE IF EXISTS manufacturers;
CREATE TABLE manufacturers (
  manufacturers_id INT NOT NULL auto_increment,
  manufacturers_name VARCHAR(32) NOT NULL,
  manufacturers_image VARCHAR(64),
  date_added datetime NULL,
  last_modified datetime NULL,
  PRIMARY KEY (manufacturers_id),
  KEY IDX_MANUFACTURERS_NAME (manufacturers_name),
  KEY manufacturers_id (manufacturers_id,manufacturers_name)
);

DROP TABLE IF EXISTS manufacturers_info;
CREATE TABLE manufacturers_info (
  manufacturers_id INT NOT NULL,
  languages_id INT NOT NULL,
  manufacturers_description TEXT NOT NULL,
  manufacturers_meta_title VARCHAR(100) NOT NULL,
  manufacturers_meta_description VARCHAR(255) NOT NULL,
  manufacturers_meta_keywords VARCHAR(255) NOT NULL,
  manufacturers_url VARCHAR(255) NOT NULL,
  url_clicked INT(5) NOT NULL DEFAULT '0',
  date_last_click datetime NULL
);

DROP TABLE IF EXISTS newsletters;
CREATE TABLE newsletters (
  newsletters_id INT NOT NULL auto_increment,
  title VARCHAR(255) NOT NULL,
  content text NOT NULL,
  module VARCHAR(255) NOT NULL,
  date_added datetime NOT NULL,
  date_sent datetime,
  status INT(1),
  locked INT(1) DEFAULT '0',
  PRIMARY KEY (newsletters_id)
);

DROP TABLE IF EXISTS newsletter_recipients;
CREATE TABLE newsletter_recipients (
  mail_id INT(11) NOT NULL auto_increment,
  customers_email_address VARCHAR(96) NOT NULL DEFAULT '',
  customers_id INT(11) NOT NULL DEFAULT '0',
  customers_status INT(5) NOT NULL DEFAULT '0',
  customers_firstname VARCHAR(32) NOT NULL DEFAULT '',
  customers_lastname VARCHAR(32) NOT NULL DEFAULT '',
  mail_status INT(1) NOT NULL DEFAULT '0',
  mail_key VARCHAR(32) NOT NULL DEFAULT '',
  date_added datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (mail_id)
);

DROP TABLE IF EXISTS newsletters_history;
CREATE TABLE newsletters_history (
  news_hist_id INT(11) NOT NULL DEFAULT '0',
  news_hist_cs INT(11) NOT NULL DEFAULT '0',
  news_hist_cs_date_sent date DEFAULT NULL,
  PRIMARY KEY (news_hist_id)
);

DROP TABLE IF EXISTS orders;
CREATE TABLE orders (
  orders_id INT NOT NULL auto_increment,
  customers_id INT NOT NULL,
  customers_cid VARCHAR(32),
  customers_vat_id VARCHAR (20),
  customers_status INT(11),
  customers_status_name VARCHAR(32) NOT NULL,
  customers_status_image VARCHAR (64),
  customers_status_discount decimal (4,2),
  customers_name VARCHAR(64) NOT NULL,
  customers_firstname VARCHAR(64) NOT NULL,
  customers_lastname VARCHAR(64) NOT NULL,
  customers_company VARCHAR(32),
  customers_street_address VARCHAR(64) NOT NULL,
  customers_suburb VARCHAR(32),
  customers_city VARCHAR(32) NOT NULL,
  customers_postcode VARCHAR(10) NOT NULL,
  customers_state VARCHAR(32),
  customers_country VARCHAR(32) NOT NULL,
  customers_telephone VARCHAR(32) NOT NULL,
  customers_email_address VARCHAR(96) NOT NULL,
  customers_address_format_id INT(5) NOT NULL,
  delivery_name VARCHAR(64) NOT NULL,
  delivery_firstname VARCHAR(64) NOT NULL,
  delivery_lastname VARCHAR(64) NOT NULL,
  delivery_company VARCHAR(32),
  delivery_street_address VARCHAR(64) NOT NULL,
  delivery_suburb VARCHAR(32),
  delivery_city VARCHAR(32) NOT NULL,
  delivery_postcode VARCHAR(10) NOT NULL,
  delivery_state VARCHAR(32),
  delivery_country VARCHAR(32) NOT NULL,
  delivery_country_iso_code_2 char(2) NOT NULL,
  delivery_address_format_id INT(5) NOT NULL,
  billing_name VARCHAR(64) NOT NULL,
  billing_firstname VARCHAR(64) NOT NULL,
  billing_lastname VARCHAR(64) NOT NULL,
  billing_company VARCHAR(32),
  billing_street_address VARCHAR(64) NOT NULL,
  billing_suburb VARCHAR(32),
  billing_city VARCHAR(32) NOT NULL,
  billing_postcode VARCHAR(10) NOT NULL,
  billing_state VARCHAR(32),
  billing_country VARCHAR(32) NOT NULL,
  billing_country_iso_code_2 char(2) NOT NULL,
  billing_address_format_id INT(5) NOT NULL,
  payment_method VARCHAR(32) NOT NULL,
  cc_type VARCHAR(20),
  cc_owner VARCHAR(64),
  cc_number VARCHAR(64),
  cc_expires VARCHAR(4),
  cc_start VARCHAR(4) DEFAULT NULL,
  cc_issue VARCHAR(3) DEFAULT NULL,
  cc_cvv VARCHAR(4) DEFAULT NULL,
  comments VARCHAR (255),
  last_modified datetime,
  date_purchased datetime,
  orders_status INT(5) NOT NULL,
  orders_date_finished datetime,
  currency char(3),
  currency_value decimal(14,6),
  account_type INT(1) DEFAULT '0' NOT NULL,
  payment_class VARCHAR(32) NOT NULL,
  shipping_method VARCHAR(128) NOT NULL,
  shipping_class VARCHAR(32) NOT NULL,
  shipping_cost VARCHAR(5) NOT NULL,
  customers_ip VARCHAR(32) NOT NULL,
  language VARCHAR(32) NOT NULL,
  afterbuy_success INT(1) DEFAULT'0' NOT NULL,
  afterbuy_id INT(32) DEFAULT '0' NOT NULL,
  refferers_id VARCHAR(32) NOT NULL,
  conversion_type INT(1) DEFAULT '0' NOT NULL,
  orders_ident_key VARCHAR(128),
  edebit_transaction_id VARCHAR(32),
  edebit_gutid VARCHAR(32),
  ibn_billnr INT NOT NULL,
  ibn_billdate DATE NOT NULL,
  ibn_pdfnotifydate DATE NOT NULL,
  PRIMARY KEY (orders_id),
  KEY customers_status (customers_status)
);

DROP TABLE IF EXISTS card_blacklist;
CREATE TABLE card_blacklist (
  blacklist_id INT(5) NOT NULL auto_increment,
  blacklist_card_number VARCHAR(20) NOT NULL DEFAULT '',
  date_added datetime DEFAULT NULL,
  last_modified datetime DEFAULT NULL,
  KEY blacklist_id (blacklist_id)
);

DROP TABLE IF EXISTS orders_products;
CREATE TABLE orders_products (
  orders_products_id INT NOT NULL auto_increment,
  orders_id INT NOT NULL,
  products_id INT NOT NULL,
  products_model VARCHAR(64),
  products_name VARCHAR(64) NOT NULL,
  products_price decimal(15,4) NOT NULL,
  products_discount_made decimal(4,2) DEFAULT NULL,
  products_shipping_time VARCHAR(255) DEFAULT NULL,
  final_price decimal(15,4) NOT NULL,
  products_tax decimal(7,4) NOT NULL,
  products_quantity INT(2) NOT NULL,
  allow_tax INT(1) NOT NULL,
  PRIMARY KEY (orders_products_id)
);

DROP TABLE IF EXISTS orders_status;
CREATE TABLE orders_status (
  orders_status_id INT DEFAULT '0' NOT NULL,
  language_id INT DEFAULT '1' NOT NULL,
  orders_status_name VARCHAR(32) NOT NULL,
  PRIMARY KEY (orders_status_id, language_id),
  KEY idx_orders_status_name (orders_status_name)
);

DROP TABLE IF EXISTS shipping_status;
CREATE TABLE shipping_status (
  shipping_status_id INT DEFAULT '0' NOT NULL,
  language_id INT DEFAULT '1' NOT NULL,
  shipping_status_name VARCHAR(32) NOT NULL,
  shipping_status_image VARCHAR(32) NOT NULL,
  PRIMARY KEY (shipping_status_id, language_id),
  KEY idx_shipping_status_name (shipping_status_name),
  KEY language_id (language_id)
);

DROP TABLE IF EXISTS search_queries_all;
CREATE TABLE search_queries_all (
  search_id INT(11) NOT NULL auto_increment,
  search_text tinytext ,
  search_result VARCHAR(255) NOT NULL,
  PRIMARY KEY (search_id)
);

DROP TABLE IF EXISTS search_queries_sorted;
CREATE TABLE search_queries_sorted (
  search_id smallint(6) not null auto_increment,
  search_text tinytext not null ,
  search_count INT(11) default '0' NOT NULL,
  search_result VARCHAR(255) NOT NULL,
  PRIMARY KEY (search_id)
);

DROP TABLE IF EXISTS orders_status_history;
CREATE TABLE orders_status_history (
  orders_status_history_id INT NOT NULL auto_increment,
  orders_id INT NOT NULL,
  orders_status_id INT(5) NOT NULL,
  date_added datetime NOT NULL,
  customer_notified INT(1) DEFAULT '0',
  comments TEXT,
  PRIMARY KEY (orders_status_history_id)
);

DROP TABLE IF EXISTS orders_products_attributes;
CREATE TABLE orders_products_attributes (
  orders_products_attributes_id INT NOT NULL auto_increment,
  orders_id INT NOT NULL,
  orders_products_id INT NOT NULL,
  products_options VARCHAR(32) NOT NULL,
  products_options_values VARCHAR(64) NOT NULL,
  options_values_price decimal(15,4) NOT NULL,
  price_prefix CHAR(1) NOT NULL,
  PRIMARY KEY (orders_products_attributes_id)
);

DROP TABLE IF EXISTS orders_products_download;
CREATE TABLE orders_products_download (
  orders_products_download_id INT NOT NULL auto_increment,
  orders_id INT NOT NULL DEFAULT '0',
  orders_products_id INT NOT NULL DEFAULT '0',
  orders_products_filename VARCHAR(255) NOT NULL DEFAULT '',
  download_maxdays INT(2) NOT NULL DEFAULT '0',
  download_count INT(2) NOT NULL DEFAULT '0',
  download_ip VARCHAR(15) NOT NULL DEFAULT '0',
  download_time DATETIME NOT NULL,
  PRIMARY KEY  (orders_products_download_id)
);

DROP TABLE IF EXISTS orders_total;
CREATE TABLE orders_total (
  orders_total_id INT NOT NULL auto_increment,
  orders_id INT NOT NULL,
  title VARCHAR(255) NOT NULL,
  text VARCHAR(255) NOT NULL,
  value decimal(15,4) NOT NULL,
  class VARCHAR(32) NOT NULL,
  sort_order INT NOT NULL,
  PRIMARY KEY (orders_total_id),
  KEY idx_orders_total_orders_id (orders_id)
);

DROP TABLE IF EXISTS paypal;
CREATE TABLE paypal (
 paypal_ipn_id int(11) NOT NULL auto_increment,
 xtc_order_id int(11) NOT NULL default '0',
 txn_type varchar(32) NOT NULL default '',
 reason_code varchar(15) default NULL,
 payment_type varchar(7) NOT NULL default '',
 payment_status varchar(17) NOT NULL default '',
 pending_reason varchar(14) default NULL,
 invoice varchar(64) default NULL,
 mc_currency char(3) NOT NULL default '',
 first_name varchar(32) NOT NULL default '',
 last_name varchar(32) NOT NULL default '',
 payer_business_name varchar(64) default NULL,
 address_name varchar(32) default NULL,
 address_street varchar(64) default NULL,
 address_city varchar(32) default NULL,
 address_state varchar(32) default NULL,
 address_zip varchar(10) default NULL,
 address_country varchar(64) default NULL,
 address_status varchar(11) default NULL,
 payer_email varchar(96) NOT NULL default '',
 payer_id varchar(32) NOT NULL default '',
 payer_status varchar(10) NOT NULL default '',
 payment_date datetime NOT NULL default '0001-01-01 00:00:00',
 business varchar(96) NOT NULL default '',
 receiver_email varchar(96) NOT NULL default '',
 receiver_id varchar(32) NOT NULL default '',
 txn_id varchar(40) NOT NULL default '',
 parent_txn_id varchar(17) default NULL,
 num_cart_items tinyint(4) NOT NULL default '1',
 mc_gross decimal(7,2) NOT NULL default '0.00',
 mc_fee decimal(7,2) NOT NULL default '0.00',
 mc_shipping decimal(7,2) NOT NULL default '0.00',
 payment_gross decimal(7,2) default NULL,
 payment_fee decimal(7,2) default NULL,
 settle_amount decimal(7,2) default NULL,
 settle_currency char(3) default NULL,
 exchange_rate decimal(4,2) default NULL,
 notify_version decimal(2,1) NOT NULL default '0.0',
 verify_sign varchar(128) NOT NULL default '',
 last_modified datetime NOT NULL default '0001-01-01 00:00:00',
 date_added datetime NOT NULL default '0001-01-01 00:00:00',
 memo text,
 mc_authorization decimal(7,2) NOT NULL,
 mc_captured decimal(7,2) NOT NULL,
 PRIMARY KEY (paypal_ipn_id,txn_id),
 KEY xtc_order_id (xtc_order_id)
);

DROP TABLE if EXISTS paypal_status_history;
CREATE TABLE paypal_status_history (
 payment_status_history_id int(11) NOT NULL auto_increment,
 paypal_ipn_id int(11) NOT NULL default '0',
 txn_id varchar(64) NOT NULL default '',
 parent_txn_id varchar(64) NOT NULL default '',
 payment_status varchar(17) NOT NULL default '',
 pending_reason varchar(64) default NULL,
 mc_amount decimal(7,2) NOT NULL,
 date_added datetime NOT NULL default '0001-01-01 00:00:00',
 PRIMARY KEY (payment_status_history_id),
 KEY paypal_ipn_id (paypal_ipn_id)
);

DROP TABLE IF EXISTS orders_recalculate;
CREATE TABLE orders_recalculate (
  orders_recalculate_id INT(11) NOT NULL auto_increment,
  orders_id INT(11) NOT NULL DEFAULT '0',
  n_price decimal(15,4) NOT NULL DEFAULT '0.0000',
  b_price decimal(15,4) NOT NULL DEFAULT '0.0000',
  tax decimal(15,4) NOT NULL DEFAULT '0.0000',
  tax_rate decimal(7,4) NOT NULL DEFAULT '0.0000',
  class VARCHAR(32) NOT NULL DEFAULT '',
  PRIMARY KEY  (orders_recalculate_id)
);

DROP TABLE IF EXISTS products;
CREATE TABLE products (
  products_id INT NOT NULL auto_increment,
  products_ean VARCHAR(128),
  products_quantity INT(4) NOT NULL,
  products_shippingtime INT(4) NOT NULL,
  products_model VARCHAR(64),
  products_manufacturers_model VARCHAR(64),
  group_permission_0 TINYINT(1) NOT NULL,
  group_permission_1 TINYINT(1) NOT NULL,
  group_permission_2 TINYINT(1) NOT NULL,
  group_permission_3 TINYINT(1) NOT NULL,
  products_sort INT(4) NOT NULL DEFAULT '0',
  products_image VARCHAR(254),
  products_price decimal(15,4) NOT NULL,
  products_discount_allowed decimal(5,2) DEFAULT '0.00' NOT NULL,
  products_date_added datetime NOT NULL,
  products_last_modified datetime,
  products_date_available datetime,
  products_weight decimal(10,2) DEFAULT '0.00' NOT NULL,
  products_status TINYINT(1) NOT NULL,
  products_tax_class_id INT NOT NULL,
  product_template VARCHAR (64),
  options_template VARCHAR (64),
  manufacturers_id INT NULL,
  products_ordered INT NOT NULL DEFAULT '0',
  products_fsk18 INT(1) NOT NULL DEFAULT '0',
  products_vpe INT(11) NOT NULL,
  products_vpe_status INT(1) NOT NULL DEFAULT '0',
  products_vpe_value decimal(15,4) NOT NULL,
  products_startpage INT(1) NOT NULL DEFAULT '0',
  products_startpage_sort INT(4) NOT NULL DEFAULT '0',
  products_zustand VARCHAR(10) NOT NULL DEFAULT 'neu',
  products_movie_embeded_code TEXT NULL,
  products_movie_height INT(4) NULL,
  products_movie_width INT(4) NULL,
  products_movie_youtube_id VARCHAR(32) NOT NULL DEFAULT '',
  products_movie_on_server VARCHAR(255) NOT NULL DEFAULT '',
  products_col_top TINYINT(1) NOT NULL DEFAULT 1,
  products_col_left TINYINT(1) NOT NULL DEFAULT 1,
  products_col_right TINYINT(1) NOT NULL DEFAULT 1,
  products_col_bottom TINYINT(1) NOT NULL DEFAULT 1,
  products_cartspecial INT(1) NOT NULL DEFAULT 0,
  products_shipping_costs VARCHAR(64) NOT NULL,
  products_forbidden_payment TEXT,
  PRIMARY KEY (products_id),
  KEY idx_products_date_added (products_date_added),
  KEY products_id (products_id,products_status,products_date_added),
  KEY products_status (products_status,products_id,products_date_added),
  KEY products_status_2 (products_status,products_id,products_price),
  KEY products_status_3 (products_status,products_ordered,products_id),
  KEY products_status_4 (products_status,products_model,products_id),
  KEY products_id_2 (products_id,products_startpage,products_status,products_startpage_sort),
  KEY products_date_available (products_date_available,products_id),
  KEY products_quantity (products_quantity),
  KEY products_sort (products_sort),
  KEY products_tax_class_id (products_tax_class_id),
  KEY manufacturers_id (manufacturers_id)
);

DROP TABLE IF EXISTS products_attributes;
CREATE TABLE products_attributes (
  products_attributes_id INT NOT NULL auto_increment,
  products_id INT NOT NULL,
  options_id INT NOT NULL,
  options_values_id INT NOT NULL,
  options_values_price decimal(15,4) NOT NULL,
  price_prefix char(1) NOT NULL,
  attributes_model VARCHAR(64) NULL,
  attributes_stock INT(4) NULL,
  options_values_weight decimal(15,4) NOT NULL,
  weight_prefix char(1) NOT NULL,
  sortorder INT(11) NULL,
  PRIMARY KEY (products_attributes_id),
  KEY products_id (products_id,options_id,options_values_id,sortorder),
  KEY options_values_id (options_values_id),
  KEY sortorder (sortorder)
);

DROP TABLE IF EXISTS products_attributes_download;
CREATE TABLE products_attributes_download (
  products_attributes_id INT NOT NULL,
  products_attributes_filename VARCHAR(255) NOT NULL DEFAULT '',
  products_attributes_maxdays INT(2) DEFAULT '0',
  products_attributes_maxcount INT(2) DEFAULT '0',
  PRIMARY KEY (products_attributes_id)
);

DROP TABLE IF EXISTS products_description;
CREATE TABLE products_description (
  products_id INT NOT NULL auto_increment,
  language_id INT NOT NULL DEFAULT '1',
  products_name VARCHAR(64) NOT NULL DEFAULT '',
  products_description TEXT NULL,
  products_short_description TEXT NULL,
  products_zusatz_description TEXT NULL,
  products_google_taxonomie TEXT NULL,
  products_taxonomie TEXT,
  products_img_alt VARCHAR(64) NULL,
  products_keywords VARCHAR(255) DEFAULT NULL,
  products_meta_title TEXT NOT NULL,
  products_meta_description TEXT NOT NULL,
  products_meta_keywords TEXT NOT NULL,
  products_url VARCHAR(255) DEFAULT NULL,
  products_viewed INT(5) DEFAULT '0',
  products_tag_cloud VARCHAR(32) NULL,
  products_url_alias VARCHAR(64) NULL,
  PRIMARY KEY (products_id,language_id),
  KEY products_name (products_name),
  KEY language_id (language_id,products_keywords),
  KEY language_id_2 (language_id,products_name)
);

DROP TABLE IF EXISTS products_images;
CREATE TABLE IF NOT EXISTS products_images (
  image_id INT NOT NULL auto_increment,
  products_id INT NOT NULL,
  image_nr SMALLINT NOT NULL,
  image_name VARCHAR(254) NOT NULL,
  alt_langID_1 VARCHAR(64) NOT NULL,
  PRIMARY KEY (image_id),
  KEY products_images (products_id)
);

DROP TABLE IF EXISTS products_listings;
CREATE TABLE IF NOT EXISTS products_listings (
  list_name VARCHAR(32) NOT NULL,
  col INT(2) NOT NULL DEFAULT '3',
  p_img INT(1) NOT NULL DEFAULT '1',
  p_name INT(1) NOT NULL DEFAULT '1',
  p_price INT(1) NOT NULL DEFAULT '1',
  b_details INT(1) NOT NULL DEFAULT '1',
  b_order INT(1) NOT NULL DEFAULT '1',
  b_wishlist INT(1) NOT NULL DEFAULT '0',
  p_reviews INT(1) NOT NULL DEFAULT '0',
  p_stockimg INT(1) NOT NULL DEFAULT '0',
  p_vpe INT(1) NOT NULL DEFAULT '0',
  p_model INT(1) NOT NULL DEFAULT '0',
  p_manu_img INT(1) NOT NULL DEFAULT '0',
  p_manu_name INT(1) NOT NULL DEFAULT '0',
  p_short_desc INT(1) NOT NULL DEFAULT '1',
  p_short_desc_lenght INT(1) NOT NULL DEFAULT '75',
  p_long_desc INT(1) NOT NULL DEFAULT '0',
  p_long_desc_lenght INT(1) NOT NULL DEFAULT '200',
  list_type VARCHAR(10) NOT NULL DEFAULT 'list',
  list_head VARCHAR(32) NOT NULL,
  PRIMARY KEY (list_name),
  KEY products_listings (list_name)
);

DROP TABLE IF EXISTS products_notifications;
CREATE TABLE IF NOT EXISTS products_notifications (
  products_id INT NOT NULL,
  customers_id INT NOT NULL,
  date_added datetime NOT NULL,
  PRIMARY KEY (products_id, customers_id)
);

DROP TABLE IF EXISTS products_parameters;
CREATE TABLE products_parameters (
  parameters_id INT(11) NOT NULL auto_increment,
  group_id INT(11) NOT NULL default '0',
  products_id INT(11) NOT NULL default '0',
  sort_order INT(3) NOT NULL default '0',
  PRIMARY KEY  (parameters_id)
);

DROP TABLE IF EXISTS products_parameters_description;
CREATE TABLE products_parameters_description (
  parameters_id INT(11) NOT NULL,
  language_id INT(11) NOT NULL,
  parameters_name TEXT NOT NULL,
  parameters_value TEXT NOT NULL,
  PRIMARY KEY  (parameters_id,language_id)
);

DROP TABLE IF EXISTS products_parameters_groups;
CREATE TABLE products_parameters_groups (
  group_id INT(11) NOT NULL auto_increment,
  sort_order INT(3) NOT NULL,
  PRIMARY KEY  (group_id)
);

DROP TABLE IF EXISTS products_parameters_groups_description;
CREATE TABLE products_parameters_groups_description (
  group_id INT(11) NOT NULL,
  language_id INT(11) NOT NULL,
  group_name VARCHAR(64) NOT NULL,
  PRIMARY KEY  (group_id,language_id)
);

DROP TABLE IF EXISTS products_options;
CREATE TABLE IF NOT EXISTS products_options (
  products_options_id INT NOT NULL DEFAULT '0',
  language_id INT NOT NULL DEFAULT '1',
  products_options_name VARCHAR(32) NOT NULL DEFAULT '',
  PRIMARY KEY  (products_options_id,language_id)
);

DROP TABLE IF EXISTS products_options_values;
CREATE TABLE IF NOT EXISTS products_options_values (
  products_options_values_id INT NOT NULL DEFAULT '0',
  language_id INT NOT NULL DEFAULT '1',
  products_options_values_name VARCHAR(64) NOT NULL DEFAULT '',
  products_options_values_desc TEXT NOT NULL DEFAULT '',
  products_options_values_image VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY  (products_options_values_id,language_id),
  KEY products_options_values_name (products_options_values_name,language_id)
);

DROP TABLE IF EXISTS products_options_values_to_products_options;
CREATE TABLE IF NOT EXISTS products_options_values_to_products_options (
  products_options_values_to_products_options_id INT NOT NULL auto_increment,
  products_options_id INT NOT NULL,
  products_options_values_id INT NOT NULL,
  PRIMARY KEY (products_options_values_to_products_options_id),
  KEY products_options_id (products_options_id),
  KEY products_options_values_id (products_options_values_id)
);

DROP TABLE IF EXISTS products_graduated_prices;
CREATE TABLE IF NOT EXISTS products_graduated_prices (
  products_id INT(11) NOT NULL DEFAULT '0',
  quantity INT(11) NOT NULL DEFAULT '0',
  unitprice decimal(15,4) NOT NULL DEFAULT '0.0000',
  KEY products_id (products_id)
);

DROP TABLE IF EXISTS products_to_categories;
CREATE TABLE IF NOT EXISTS products_to_categories (
  products_id INT NOT NULL,
  categories_id INT NOT NULL,
  PRIMARY KEY (products_id,categories_id),
  KEY categories_id (categories_id,products_id)
);

DROP TABLE IF EXISTS products_vpe;
CREATE TABLE IF NOT EXISTS products_vpe (
  products_vpe_id INT(11) NOT NULL DEFAULT '0',
  language_id INT(11) NOT NULL DEFAULT '0',
  products_vpe_name VARCHAR(32) NOT NULL DEFAULT ''
);

DROP TABLE IF EXISTS reviews;
CREATE TABLE IF NOT EXISTS reviews (
  reviews_id INT NOT NULL auto_increment,
  products_id INT NOT NULL,
  customers_id int,
  customers_name VARCHAR(64) NOT NULL,
  reviews_rating INT(1),
  date_added datetime,
  last_modified datetime,
  reviews_read INT(5) NOT NULL DEFAULT '0',
  reviews_status INT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (reviews_id)
);

DROP TABLE IF EXISTS reviews_description;
CREATE TABLE IF NOT EXISTS reviews_description (
  reviews_id INT NOT NULL,
  languages_id INT NOT NULL,
  reviews_text text NOT NULL,
  PRIMARY KEY (reviews_id, languages_id)
);

DROP TABLE IF EXISTS sessions;
CREATE TABLE IF NOT EXISTS sessions (
  sesskey VARCHAR(32) NOT NULL,
  expiry INT(11) NOT NULL,
  value text NOT NULL,
  PRIMARY KEY (sesskey),
  KEY sesskey (sesskey,expiry)
);

DROP TABLE IF EXISTS specials;
CREATE TABLE IF NOT EXISTS specials (
  specials_id INT NOT NULL auto_increment,
  products_id INT NOT NULL,
  specials_quantity INT(4) NOT NULL,
  specials_new_products_price decimal(15,4) NOT NULL,
  specials_date_added datetime,
  specials_last_modified datetime,
  expires_date datetime,
  date_status_change datetime,
  status INT(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (specials_id),
  KEY products_id (products_id,status,specials_date_added),
  KEY status (status,expires_date)
);

DROP TABLE IF EXISTS tax_class;
CREATE TABLE IF NOT EXISTS tax_class (
  tax_class_id INT NOT NULL auto_increment,
  tax_class_title VARCHAR(128) NOT NULL,
  tax_class_description VARCHAR(255) NOT NULL,
  last_modified datetime NULL,
  date_added datetime NOT NULL,
  PRIMARY KEY (tax_class_id)
);

DROP TABLE IF EXISTS tax_rates;
CREATE TABLE IF NOT EXISTS tax_rates (
  tax_rates_id INT NOT NULL auto_increment,
  tax_zone_id INT NOT NULL,
  tax_class_id INT NOT NULL,
  tax_priority INT(5) DEFAULT 1,
  tax_rate decimal(7,4) NOT NULL,
  tax_description VARCHAR(255) NOT NULL,
  last_modified datetime NULL,
  date_added datetime NOT NULL,
  PRIMARY KEY (tax_rates_id),
  KEY tax_zone_id (tax_zone_id),
  KEY tax_class_id (tax_class_id,tax_priority)
);

DROP TABLE IF EXISTS geo_zones;
CREATE TABLE IF NOT EXISTS geo_zones (
  geo_zone_id INT NOT NULL auto_increment,
  geo_zone_name VARCHAR(32) NOT NULL,
  geo_zone_description VARCHAR(255) NOT NULL,
  last_modified datetime NULL,
  date_added datetime NOT NULL,
  PRIMARY KEY (geo_zone_id)
);

DROP TABLE IF EXISTS whos_online;
CREATE TABLE IF NOT EXISTS whos_online (
  customer_id int,
  full_name VARCHAR(64) NOT NULL,
  session_id VARCHAR(128) NOT NULL,
  ip_address VARCHAR(15) NOT NULL,
  time_entry VARCHAR(14) NOT NULL,
  time_last_click VARCHAR(14) NOT NULL,
  last_page_url VARCHAR(255) NOT NULL,
  http_referer VARCHAR(255) NOT NULL,
  user_agent VARCHAR(255) NOT NULL,
  KEY customer_id (customer_id),
  KEY session_id (session_id),
  KEY time_last_click (time_last_click)
);

DROP TABLE IF EXISTS whos_online_year;
CREATE TABLE whos_online_year (
  whos_online_id int(11) NOT NULL auto_increment,
  year int(4) NOT NULL default '0',
  month int(2) NOT NULL default '0',
  referer_url varchar(250) default NULL,
  count int(11) NOT NULL default '0',
  PRIMARY KEY  (whos_online_id)
); 

DROP TABLE IF EXISTS whos_online_month;
CREATE TABLE whos_online_month (
  whos_online_id int(11) NOT NULL auto_increment,
  day smallint(2) NOT NULL default '0',
  referer_url varchar(250) default NULL,
  count int(11) NOT NULL default '0',
  PRIMARY KEY  (whos_online_id)
);

DROP TABLE IF EXISTS zones;
CREATE TABLE IF NOT EXISTS zones (
  zone_id INT NOT NULL auto_increment,
  zone_country_id INT NOT NULL,
  zone_code VARCHAR(32) NOT NULL,
  zone_name VARCHAR(32) NOT NULL,
  PRIMARY KEY (zone_id)
);

DROP TABLE IF EXISTS zones_to_geo_zones;
CREATE TABLE IF NOT EXISTS zones_to_geo_zones (
   association_id INT NOT NULL auto_increment,
   zone_country_id INT NOT NULL,
   zone_id INT NULL,
   geo_zone_id INT NULL,
   last_modified datetime NULL,
   date_added datetime NOT NULL,
   PRIMARY KEY (association_id),
  KEY zone_id (zone_id),
  KEY geo_zone_id (geo_zone_id),
  KEY zone_country_id (zone_country_id,zone_id)
);

DROP TABLE IF EXISTS content_manager;
CREATE TABLE IF NOT EXISTS content_manager (
  content_id INT(11) NOT NULL auto_increment,
  categories_id INT(11) NOT NULL DEFAULT '0',
  parent_id INT(11) NOT NULL DEFAULT '0',
  group_ids TEXT,
  languages_id INT(11) NOT NULL DEFAULT '0',
  content_title text NOT NULL,
  content_heading text NOT NULL,
  content_text text NOT NULL,
  sort_order INT(4) NOT NULL DEFAULT '0',
  file_flag INT(1) NOT NULL DEFAULT '0',
  content_file VARCHAR(64) NOT NULL DEFAULT '',
  content_status INT(1) NOT NULL DEFAULT '0',
  content_group INT(11) NOT NULL,
  content_delete INT(1) NOT NULL DEFAULT '1',
  content_meta_title text,
  content_meta_description text,
  content_meta_keywords text,
  content_url_alias VARCHAR(64) NULL,
  content_out_link TEXT NULL,
  content_link_target VARCHAR(6) NULL,
  content_link_type VARCHAR(8) NULL,
  content_col_top TINYINT(1) NOT NULL DEFAULT 1,
  content_col_left TINYINT(1) NOT NULL DEFAULT 1,
  content_col_right TINYINT(1) NOT NULL DEFAULT 1,
  content_col_bottom TINYINT(1) NOT NULL DEFAULT 1,
  PRIMARY KEY  (content_id),
  KEY languages_id (languages_id,file_flag,content_status,sort_order),
  KEY content_id (content_id,languages_id),
  KEY content_group (content_group,languages_id)
);

DROP TABLE IF EXISTS media_content;
CREATE TABLE IF NOT EXISTS media_content (
  file_id INT(11) NOT NULL auto_increment,
  old_filename text NOT NULL,
  new_filename text NOT NULL,
  file_comment text NOT NULL,
  PRIMARY KEY  (file_id)
);

DROP TABLE IF EXISTS products_content;
CREATE TABLE IF NOT EXISTS products_content (
  content_id INT(11) NOT NULL auto_increment,
  products_id INT(11) NOT NULL DEFAULT '0',
  group_ids TEXT,
  content_name VARCHAR(32) NOT NULL DEFAULT '',
  content_file VARCHAR(64) NOT NULL,
  content_link text NOT NULL,
  languages_id INT(11) NOT NULL DEFAULT '0',
  content_read INT(11) NOT NULL DEFAULT '0',
  file_comment text NOT NULL,
  PRIMARY KEY  (content_id)
);

DROP TABLE IF EXISTS module_newsletter;
CREATE TABLE IF NOT EXISTS module_newsletter (
  newsletter_id INT(11) NOT NULL auto_increment,
  title text NOT NULL,
  bc text NOT NULL,
  cc text NOT NULL,
  date datetime DEFAULT NULL,
  status INT(1) NOT NULL DEFAULT '0',
  body text NOT NULL,
  personalize char(3) NOT NULL DEFAULT '0',
  greeting INT(1) NOT NULL DEFAULT '0',
  gift char(3) NOT NULL DEFAULT '0',
  ammount VARCHAR(10) NOT NULL DEFAULT '0',
  product_list INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (newsletter_id)
);

DROP TABLE IF EXISTS newsletter_product_list;
CREATE TABLE IF NOT EXISTS newsletter_product_list (
  id INT(11) NOT NULL auto_increment,
  list_name char(64) NOT NULL DEFAULT '',
  PRIMARY KEY (id)
);

DROP TABLE IF EXISTS newsletter_products;
CREATE TABLE IF NOT EXISTS newsletter_products (
  id INT(11) NOT NULL auto_increment,
  accessories_id INT(11) NOT NULL DEFAULT '0',
  product_id INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (id)
);

DROP TABLE if exists cm_file_flags;
CREATE TABLE IF NOT EXISTS cm_file_flags (
  file_flag INT(11) NOT NULL,
  file_flag_name VARCHAR(32) NOT NULL,
  PRIMARY KEY (file_flag)
);

DROP TABLE if EXISTS payment_moneybookers_currencies;
CREATE TABLE IF NOT EXISTS payment_moneybookers_currencies (
  mb_currID char(3) NOT NULL DEFAULT '',
  mb_currName VARCHAR(255) NOT NULL DEFAULT '',
  PRIMARY KEY (mb_currID)
);

DROP TABLE if EXISTS payment_moneybookers;
CREATE TABLE IF NOT EXISTS payment_moneybookers (
  mb_TRID VARCHAR(255) NOT NULL DEFAULT '',
  mb_ERRNO smallint(3) NOT NULL DEFAULT '0',
  mb_ERRTXT VARCHAR(255) NOT NULL DEFAULT '',
  mb_DATE datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  mb_MBTID bigint(18) NOT NULL DEFAULT '0',
  mb_STATUS TINYINT(1) NOT NULL DEFAULT '0',
  mb_ORDERID INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (mb_TRID)
);

DROP TABLE if EXISTS payment_moneybookers_countries;
CREATE TABLE IF NOT EXISTS payment_moneybookers_countries (
  osc_cID INT(11) NOT NULL DEFAULT '0',
  mb_cID char(3) NOT NULL DEFAULT '',
  PRIMARY KEY  (osc_cID)
);

DROP TABLE if EXISTS coupon_email_track;
CREATE TABLE IF NOT EXISTS coupon_email_track (
  unique_id INT(11) NOT NULL auto_increment,
  coupon_id INT(11) NOT NULL DEFAULT '0',
  customer_id_sent INT(11) NOT NULL DEFAULT '0',
  sent_firstname VARCHAR(32) DEFAULT NULL,
  sent_lastname VARCHAR(32) DEFAULT NULL,
  emailed_to VARCHAR(32) DEFAULT NULL,
  date_sent datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY  (unique_id)
);

DROP TABLE if EXISTS coupon_gv_customer;
CREATE TABLE IF NOT EXISTS coupon_gv_customer (
  customer_id INT(5) NOT NULL DEFAULT '0',
  amount decimal(8,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY  (customer_id),
  KEY customer_id (customer_id)
);

DROP TABLE if EXISTS coupon_gv_queue;
CREATE TABLE IF NOT EXISTS coupon_gv_queue (
  unique_id INT(5) NOT NULL auto_increment,
  customer_id INT(5) NOT NULL DEFAULT '0',
  order_id INT(5) NOT NULL DEFAULT '0',
  amount decimal(8,4) NOT NULL DEFAULT '0.0000',
  date_created datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  ipaddr VARCHAR(32) NOT NULL DEFAULT '',
  release_flag char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY  (unique_id),
  KEY uid (unique_id,customer_id,order_id)
);

DROP TABLE if EXISTS coupon_redeem_track;
CREATE TABLE IF NOT EXISTS coupon_redeem_track (
  unique_id INT(11) NOT NULL auto_increment,
  coupon_id INT(11) NOT NULL DEFAULT '0',
  customer_id INT(11) NOT NULL DEFAULT '0',
  redeem_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  redeem_ip VARCHAR(32) NOT NULL DEFAULT '',
  order_id INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY  (unique_id)
);

DROP TABLE if EXISTS coupons;
CREATE TABLE IF NOT EXISTS coupons (
  coupon_id INT(11) NOT NULL auto_increment,
  coupon_type char(1) NOT NULL DEFAULT 'F',
  coupon_code VARCHAR(32) NOT NULL DEFAULT '',
  coupon_amount decimal(8,4) NOT NULL DEFAULT '0.0000',
  coupon_minimum_order decimal(8,4) NOT NULL DEFAULT '0.0000',
  coupon_start_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  coupon_expire_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  uses_per_coupon INT(5) NOT NULL DEFAULT '1',
  uses_per_user INT(5) NOT NULL DEFAULT '0',
  restrict_to_products VARCHAR(255) DEFAULT NULL,
  restrict_to_categories VARCHAR(255) DEFAULT NULL,
  restrict_to_customers text,
  coupon_active char(1) NOT NULL DEFAULT 'Y',
  date_created datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  date_modified datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY  (coupon_id)
);

DROP TABLE IF EXISTS coupons_description;
CREATE TABLE IF NOT EXISTS coupons_description (
  coupon_id INT(11) NOT NULL DEFAULT '0',
  language_id INT(11) NOT NULL DEFAULT '0',
  coupon_name VARCHAR(32) NOT NULL DEFAULT '',
  coupon_description text,
  KEY coupon_id (coupon_id)
);

DROP TABLE IF EXISTS payment_qenta;
CREATE TABLE IF NOT EXISTS payment_qenta (
  q_TRID VARCHAR(255) NOT NULL DEFAULT '',
  q_DATE datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  q_QTID bigint(18) NOT NULL DEFAULT '0',
  q_ORDERDESC VARCHAR(255) NOT NULL DEFAULT '',
  q_STATUS TINYINT(1) NOT NULL DEFAULT '0',
  q_ORDERID INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY  (q_TRID)
);

DROP TABLE IF EXISTS personal_offers_by_customers_status_0;
DROP TABLE IF EXISTS personal_offers_by_customers_status_1;
DROP TABLE IF EXISTS personal_offers_by_customers_status_2;
DROP TABLE IF EXISTS personal_offers_by_customers_status_3;

DROP TABLE IF EXISTS scart;
CREATE TABLE IF NOT EXISTS scart (
   scartid INT( 11 ) NOT NULL AUTO_INCREMENT,
   customers_id INT( 11 ) NOT NULL UNIQUE,
   dateadded VARCHAR( 8 ) NOT NULL,
   datemodified VARCHAR( 8 ) NOT NULL,
   PRIMARY KEY ( scartid )
);

DROP TABLE IF EXISTS staffel_to_templates;
CREATE TABLE IF NOT EXISTS staffel_to_templates (
   template_id INT(5) NOT NULL,
   quantity INT(5) DEFAULT NULL,
   personal_offer decimal(15,4) DEFAULT NULL,
   PRIMARY KEY ( template_id )
);

DROP TABLE if EXISTS staffel_templates;
CREATE TABLE IF NOT EXISTS staffel_templates (
   template_id INT(5) NOT NULL auto_increment,
   template_name VARCHAR(255) NOT NULL,
   PRIMARY KEY ( template_id )
);


DROP TABLE if EXISTS tag_to_product;
CREATE TABLE IF NOT EXISTS tag_to_product (
  id INT(11) NOT NULL auto_increment,
  pID INT(10) NOT NULL DEFAULT '0',
  lID INT(2) NOT NULL DEFAULT '0',
  tag VARCHAR(64) NOT NULL DEFAULT '0',
  PRIMARY KEY  (id)
);

DROP TABLE IF EXISTS countries;
CREATE TABLE IF NOT EXISTS countries (
  countries_id INT NOT NULL auto_increment,
  countries_name VARCHAR(64) NOT NULL,
  countries_iso_code_2 char(2) NOT NULL,
  countries_iso_code_3 char(3) NOT NULL,
  address_format_id INT NOT NULL,
  status INT(1) DEFAULT '1' NULL,
  PRIMARY KEY (countries_id),
  KEY IDX_COUNTRIES_NAME (countries_name)
);

DROP TABLE IF EXISTS emails;
CREATE TABLE IF NOT EXISTS emails (
  id int(2) NOT NULL AUTO_INCREMENT,
  email_name varchar(64) NOT NULL,
  languages_id int(2) NOT NULL,
  email_address varchar(64) NOT NULL,
  email_address_name varchar(64) NOT NULL,
  email_replay_address varchar(64) NOT NULL,
  email_replay_address_name varchar(64) NOT NULL,
  email_subject varchar(64) NOT NULL,
  email_forward varchar(64) NOT NULL,
  email_content_html text NOT NULL,
  email_content_text text NOT NULL,
  email_backup_html text NOT NULL,
  email_backup_text text NOT NULL,
  email_timestamp int(10) NOT NULL,
  PRIMARY KEY (id)
);

DROP TABLE IF EXISTS emails_order_products_list;
CREATE TABLE IF NOT EXISTS emails_order_products_list (
  id INT(11) NOT NULL auto_increment,
  list_name char(64) NOT NULL DEFAULT '',
  PRIMARY KEY (id)
);

DROP TABLE IF EXISTS emails_order_products;
CREATE TABLE IF NOT EXISTS emails_order_products (
  id INT(11) NOT NULL auto_increment,
  accessories_id INT(11) NOT NULL DEFAULT '0',
  product_id INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (id)
);

DROP TABLE IF EXISTS blog_categories;
CREATE TABLE blog_categories (
  id INT(11) NOT NULL AUTO_INCREMENT,
  categories_id INT(5) NOT NULL,
  language_id INT(11) NOT NULL DEFAULT '0',
  titel VARCHAR(150) NOT NULL DEFAULT '',
  status INT(1) NOT NULL DEFAULT '0',
  position INT(11) NOT NULL DEFAULT '0',
  date VARCHAR(10) NOT NULL,
  update_date VARCHAR(10) NOT NULL,
  meta_title text,
  meta_desc text,
  meta_key text,
  PRIMARY KEY  (id,language_id)
);


DROP TABLE IF EXISTS blog_comment;
CREATE TABLE blog_comment (
  id INT(3) NOT NULL AUTO_INCREMENT,
  blog_id INT(11) NOT NULL,
  name VARCHAR(150) NOT NULL DEFAULT '',
  text text,
  date VARCHAR(10) NOT NULL,
  PRIMARY KEY  (id)
);

DROP TABLE IF EXISTS blog_items;
CREATE TABLE blog_items (
  id INT(11) NOT NULL AUTO_INCREMENT,
  item_id INT(5) NOT NULL,
  language_id INT(11) NOT NULL DEFAULT '0',
  categories_id INT(11) NOT NULL DEFAULT '0',
  title VARCHAR(150) NOT NULL DEFAULT '',
  name VARCHAR(200) NOT NULL DEFAULT '',
  description text NOT NULL,
  status INT(1) NOT NULL DEFAULT '0',
  position INT(11) NOT NULL DEFAULT '0',
  date VARCHAR(10) NOT NULL,
  date_update VARCHAR(10) NOT NULL,
  meta_title text,
  meta_keywords text,
  meta_description text,
  lenght INT(5) DEFAULT NULL,
  PRIMARY KEY  (id,language_id)
);

DROP TABLE IF EXISTS blog_settings;
CREATE TABLE blog_settings (
  id INT(11) NOT NULL auto_increment,
  blog_key VARCHAR(20) DEFAULT NULL,
  wert VARCHAR(20) DEFAULT NULL,
  PRIMARY KEY  (id)
);

DROP TABLE IF EXISTS blog_start;
CREATE TABLE blog_start (
id INT(1) NOT NULL DEFAULT '0',
language_id INT(11) NOT NULL DEFAULT '0',
description TEXT NOT NULL,
date DATETIME NOT NULL,
PRIMARY KEY (id,language_id)
);

DROP TABLE IF EXISTS blog_vote;
CREATE TABLE blog_vote (
  id INT(4) NOT NULL auto_increment,
  blog_id INT(8) NOT NULL,
  vote_nr INT(8) NOT NULL,
  img_nr VARCHAR(100) DEFAULT NULL,
  PRIMARY KEY  (id)
);


DROP TABLE IF EXISTS orders_pdf_profile;
CREATE TABLE orders_pdf_profile (
  id int(11) unsigned NOT NULL AUTO_INCREMENT,
  languages_id int(2) NOT NULL,
  pdf_key varchar(64) NOT NULL,
  pdf_value varchar(255) NOT NULL,
  type varchar(32) NOT NULL,
  PRIMARY KEY (id)
);

DROP TABLE IF EXISTS orders_pdf;
CREATE TABLE orders_pdf (
	id int(11) unsigned NOT NULL AUTO_INCREMENT,
	order_id int(6) NOT NULL,
	pdf_bill_nr int(5) NOT NULL,
	bill_name varchar(128) NOT NULL,
	customer_notified int(1) NOT NULL,
	notified_date date NOT NULL,
	pdf_generate_date date NOT NULL,
	PRIMARY KEY (id)
);

DROP TABLE IF EXISTS commerce_seo_url_names;
CREATE TABLE IF NOT EXISTS commerce_seo_url_names (
  id INT(4) NOT NULL auto_increment,
  file_name VARCHAR(64) NOT NULL,
  file_name_php VARCHAR(32) NOT NULL,
  PRIMARY KEY (id)
);

DROP TABLE IF EXISTS commerce_seo_url_personal_links;
CREATE TABLE IF NOT EXISTS commerce_seo_url_personal_links (
  link_id INT(4) NOT NULL auto_increment,
  url_text VARCHAR(128) NOT NULL,
  file_name VARCHAR(64) NOT NULL,
  language_id INT(2) NOT NULL,
  PRIMARY KEY (link_id)
);

DROP TABLE IF EXISTS products_to_filter;
CREATE TABLE products_to_filter (
  products_id int(11) NOT NULL,
  filter_id int(11) NOT NULL,
  PRIMARY KEY  (products_id,filter_id)
);

DROP TABLE IF EXISTS product_filter_categories;
CREATE TABLE product_filter_categories (
  id int(11) NOT NULL default '0',
  language_id int(11) NOT NULL default '0',
  titel varchar(150) NOT NULL default '',
  status int(1) NOT NULL default '0',
  position int(11) NOT NULL default '0',
  categories_ids varchar(64) NOT NULL default '',
  PRIMARY KEY (id,language_id)
);

DROP TABLE IF EXISTS product_filter_items;
CREATE TABLE product_filter_items (
  id int(11) NOT NULL default '0',
  language_id int(11) NOT NULL default '0',
  filter_categories_id int(11) NOT NULL default '0',
  title varchar(150) NOT NULL default '',
  name varchar(200) NOT NULL default '',
  description text NOT NULL,
  status int(1) NOT NULL default '0',
  position int(11) NOT NULL default '0',
  PRIMARY KEY  (id,language_id)
);

DROP TABLE IF EXISTS accessories;
CREATE TABLE IF NOT EXISTS accessories (
  id int(11) NOT NULL auto_increment,
  head_product_id int(11) NOT NULL,
  PRIMARY KEY  (id)
);

DROP TABLE IF EXISTS accessories_products;
CREATE TABLE IF NOT EXISTS accessories_products (
  id int(11) NOT NULL auto_increment,
  accessories_id int(11) NOT NULL,
  product_id int(11) NOT NULL,
  sort_order int(11) NOT NULL,
  PRIMARY KEY  (id)
);

DROP TABLE IF EXISTS am_config;
CREATE TABLE IF NOT EXISTS am_config (
  am_config_id int(11) NOT NULL auto_increment,
  am_type varchar(10) NOT NULL,
  am_class varchar(2) NOT NULL,
  am_title varchar(30) NOT NULL,
  am_db_field varchar(30) NOT NULL,
  PRIMARY KEY (am_config_id)
);

DROP TABLE IF EXISTS attr_profile;
CREATE TABLE IF NOT EXISTS attr_profile (
  attr_profile_item_id int(11) NOT NULL auto_increment,
  products_id varchar(64) default NULL,
  options_id int(11) NOT NULL,
  options_values_id int(11) NOT NULL,
  options_values_price decimal(15,4) NOT NULL,
  price_prefix char(1) NOT NULL,
  attributes_model varchar(64) default NULL,
  attributes_stock int(4) default NULL,
  options_values_weight decimal(15,4) NOT NULL,
  weight_prefix char(1) NOT NULL,
  sortorder int(11) default NULL,
  PRIMARY KEY  (attr_profile_item_id)
);

#database Version
INSERT INTO database_version VALUES ('commerce:SEO 2.1.2.6 Plus');

INSERT INTO cm_file_flags VALUES ('0', 'information');
INSERT INTO cm_file_flags VALUES ('1', 'content');

INSERT INTO shipping_status VALUES (1, 1, '3-4 Tage', ''), (2, 1, '1 Woche', ''), (3, 1, '2 Wochen', '');

INSERT INTO boxes VALUES ('', 'categories', 'links', 1, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'categories_1', 'links', 1, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'categories_2', 'links', 1, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'categories_3', 'links', 1, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'categories_4', 'links', 1, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'categories_5', 'links', 1, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'categories_6', 'links', 1, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'categories_7', 'links', 1, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'categories_8', 'links', 1, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'categories_9', 'links', 1, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'categories_10', 'links', 1, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'categories_11', 'links', 1, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'admin', 'links', 1, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'search', 'links', 2, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'add_a_quickie', 'links', 3, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'blog', 'links', 4, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'blog_archiv', 'links', 5, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'giftcode', 'links', 6, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'reviews', 'links', 7, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'twitterbox', 'links', 8, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'whats_new', 'links', 9, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'last_viewed', 'rechts', 8, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'loginbox', 'rechts', 1, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'shopping_cart', 'rechts', 2, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'trusted_shop', 'rechts', 3, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'best_sellers', 'rechts', 4, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'manufacturers', 'rechts', 5, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'manufacturers_info', 'rechts', 5, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'infobox', 'rechts', 6, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'newsletter', 'rechts', 7, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'order_history', 'rechts', 8, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'specials', 'rechts', 9, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'sofortueberweisung', 'rechts', 10, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'currencies', 'rechts', 12, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'languages', 'rechts', 13, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'news_ticker', 'oben', 1, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'rss', 'syndicate', 1, 1, 'database', 0);
INSERT INTO boxes VALUES ('', 'content', 'unten', 1, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'information', 'unten', 2, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'tagcloud', 'unten', 3, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'social_bookmarks', 'unten', 4, 0, 'file', 0);
INSERT INTO boxes VALUES ('', 'searchhead', 'nav_search', 1, 1, 'file', 0);
INSERT INTO boxes VALUES ('', 'carthead', 'carthead', 1, 1, 'file', 0);
INSERT INTO boxes VALUES ('' , 'product_filter', 'rechts', 5, 1, 'file', 0);

INSERT INTO boxes_names VALUES ('', 'categories', 'Kategorien', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'categories_1', 'Kategorie1', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'categories_2', 'Kategorie2', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'categories_3', 'Kategorie3', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'categories_4', 'Kategorie4', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'categories_5', 'Kategorie5', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'categories_6', 'Kategorie6', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'categories_7', 'Kategorie7', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'categories_8', 'Kategorie8', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'categories_9', 'Kategorie9', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'categories_10', 'Kategorie10', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'categories_11', 'Kategorie11', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'search', 'Suche', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'add_a_quickie', 'Schnellkauf', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'admin', 'Adminbox', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'best_sellers', 'Bestseller', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'shopping_cart', 'Warenkorb', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'content', 'Mehr über...', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'currencies', 'Währungen', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'newsletter', 'Newsletter', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'information', 'Informationen', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'last_viewed', 'Zuletzt angesehen', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'languages', 'andere Sprachen', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'loginbox', 'Login', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'manufacturers', 'Hersteller', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'manufacturers_info', 'Infos zum Hersteller', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'order_history', 'Bestellübersicht', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'reviews', 'Bewertungen', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'specials', 'Angebote', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'twitterbox', 'Wir bei Twitter', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'whats_new', 'Neue Artikel', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'tagcloud', 'Wortwolke', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'news_ticker', 'News Ticker', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'infobox', 'Kundengruppe', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'sofortueberweisung', 'Sofortüberweisung', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'social_bookmarks', 'Social Bookmarks', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'trusted_shop', 'Trusted Shops', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'rss', 'RSS', '<p><a href="rss_news.php"><img alt="RSS Link" src="images/rss.gif" /></a></p>', 1, 0);
INSERT INTO boxes_names VALUES ('', 'blog', 'Shop-Blog', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'blog_archiv', 'Blog-Archiv', '', 1, 1);
INSERT INTO boxes_names VALUES ('', 'giftcode', 'Gutschein', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'searchhead', 'Header Suche', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'carthead', 'Warenkorb Header', '', 1, 0);
INSERT INTO boxes_names VALUES ('', 'product_filter', 'Produkt Filter', '', 1, 1);

INSERT INTO boxes_positions VALUES ('', 'links');
INSERT INTO boxes_positions VALUES ('', 'unten');
INSERT INTO boxes_positions VALUES ('', 'oben');
INSERT INTO boxes_positions VALUES ('', 'syndicate');
INSERT INTO boxes_positions VALUES ('', 'footer');
INSERT INTO boxes_positions VALUES ('', 'kopf');
INSERT INTO boxes_positions VALUES ('', 'rechts');
INSERT INTO boxes_positions VALUES ('', 'pos1');
INSERT INTO boxes_positions VALUES ('', 'nav_search');
INSERT INTO boxes_positions VALUES ('', 'carthead');

INSERT INTO categories VALUES ('1', NULL, '0', '0', '1', '', '0', '0', '0', '0', '', '0', 'p.products_price', 'ASC', NOW(), NULL, '1', '1', '1', '1');

INSERT INTO categories_description VALUES
('1', '1', 'Erste Kategorie', 'Überschrift der ersten Kategorie', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Praesent ut dolor. Donec neque velit, hendrerit quis, pulvinar sed, sagittis nec, mauris. Suspendisse lobortis, lacus nec aliquet egestas, elit eros sodales mauris, vel aliquet est elit non neque.', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Praesent ut dolor. Donec neque velit, hendrerit quis, pulvinar sed, sagittis nec, mauris. Suspendisse lobortis, lacus nec aliquet egestas, elit eros sodales mauris, vel aliquet est elit non neque.', '', '', '', '', '', '');

INSERT INTO products VALUES
('', '', '500', '1', '001', 'MANFM001', '0', '0', '0', '0', '0', '1_0.jpg', '840.3361', '0.00', NOW(), NULL, NULL, '0.00', '1', '1', '', '', '', '0', '0', '', '0', '0', '0.0000', '0', 'neu', '', '', '', '', '', '1', '1', '1', '1','0', '', '');

INSERT INTO products_description VALUES
(1, 1, 'DEMO Produkt 1', '<p>\r\n	Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Praesent ut dolor. Donec neque velit, hendrerit quis, pulvinar sed, sagittis nec, mauris. Suspendisse lobortis, lacus nec aliquet egestas, elit eros sodales mauris, vel aliquet est elit non neque.</p>', '<p>\r\n	Lorem ipsum dolor sit amet, consectetuer adipiscing elit.</p>', '', '', '', '', '', '', '', '', 'http://www.dell.de', 2, '', 'URL-Alias-Produkt-1');

INSERT INTO products_to_categories VALUES
('1', '1');

# Daten für Tabelle 'products_listings'
INSERT INTO products_listings VALUES
('product_listing_list', 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', ''),
('product_listing_grid', 3, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', ''),
('product_filter_list', 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', ''),
('product_filter_grid', 3, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', ''),
('advanced_search_result_list', 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', ''),
('advanced_search_result_grid', 3, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', ''),
('also_purchased', 3, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', 'ALSO_PURCHASED'),
('cross_selling', 3, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', 'CROSS_SELLING'),
('reverse_cross_selling', 3, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', 'REVERSE_CROSS_SELLING'),
('new_products_default', 3, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', 'NEW_PRODUCTS_DEFAULT'),
('new_products', 3, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', 'NEW_PRODUCTS'),
('new_products_overview', 3, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', 'NEW_PRODUCTS_OVERVIEW'),
('history_product', 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', 'HISTORY_PRODUCT'),
('upcoming_product', 2, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', 'UPCOMING_PRODUCT'),
('specials', 3, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, '75', 0, '200', 'list', 'SPECIALS'),
('tagcloud', 3, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', 'TAGCLOUD'),
('random_products', 3, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, '75', 0, '200', 'list', 'RANDOM_PRODUCTS'),
('fuzzy_search', 3, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, '75', 0, '200', 'list', 'FUZZY_SEARCH'),
('best_sellers', 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, '75', 0, '200', 'box', ''),
('specials_box', 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '75', 0, '200', 'box', ''),
('random_products_box', 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '75', 0, '200', 'box', ''),
('whats_new', 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '75', 0, '200', 'box', ''),
('cart_special', 3, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '75', 0, '200', 'list', 'CART_SPECIAL'),
('last_viewed', 3, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '75', 0, '200', 'box', '');

# Daten für Content Manager
INSERT INTO content_manager VALUES 
('', 0, 0, '', 1, 'Liefer- und Versandkosten', 'Liefer- und Versandkosten', 'Fügen Sie hier Ihre Informationen über Liefer- und Versandkosten ein.', 0, 1, '', 1, 1, 0, '', '', '', '', '', '', '', '1', '1', '1', '1'),
('', 0, 0, '', 1, 'Privatsphäre und Datenschutz', 'Privatsphäre und Datenschutz', 'Fügen Sie hier Ihre Informationen über Privatsphäre und Datenschutz ein.', 0, 1, '', 1, 2, 0, '', '', '', '', '', '', '', '1', '1', '1', '1'),
('', 0, 0, '', 1, 'Unsere AGB', 'Allgemeine Geschäftsbedingungen', '<strong>Allgemeine Geschäftsbedingungen<br /></strong><br />Fügen Sie hier Ihre allgemeinen Geschäftsbedingungen ein.<br /><br /><ol><li>Geltungsbereich</li><li>Vertragspartner</li><li>Angebot und Vertragsschluss</li><li>Widerrufsrecht, Widerrufsbelehrung, Widerrufsfolgen</li><li>Preise und Versandkosten</li><li>Lieferung</li><li>Zahlung</li><li>Eigentumsvorbehalt</li><li>Gewährleistung</li></ol>Weitere Informationen', 0, 1, '', 1, 3, 0, '', '', '', '', '', '', '', '1', '1', '1', '1'),
('', 0, 0, '', 1, 'Impressum', 'Impressum', 'Fügen Sie hier Ihr Impressum ein.<br /><br />DemoShop GmbH<br />Inhaber: Max Muster und Fritz Beispiel<br /><br />Max Muster Stra&szlig;e 21-23<br />D-0815 Musterhausen<br />E-Mail: max.muster@muster.de<br /><br />HRB 123456<br />Amtsgericht Musterhausen<br />UStid-Nr. DE 000 111 222', 0, 1, '', 1, 4, 0, 'Impressum', 'Impressum', 'Impressum', '', '', '', '', '1', '1', '1', '1'),
('', 0, 0, '', 1, 'Index', 'Willkommen', '{$greeting}<br /><br />Dies ist die Standardinstallation von commerce:SEO. Alle dargestellten Produkte dienen zur Demonstration der Funktionsweise. Wenn Sie Produkte bestellen, so werden diese weder ausgeliefert, noch in Rechnung gestellt. Alle Informationen zu den verschiedenen Produkten sind erfunden und daher kann kein Anspruch daraus abgeleitet werden.<br /><br />Sollten Sie daran interessiert sein das Programm, welches die Grundlage für diesen Shop bildet, einzusetzen, so besuchen Sie bitte die Seite von commerce:SEO. Dieser Shop basiert auf der commerce:SEO<br /><br />Der hier dargestellte Text kann im AdminInterface unter dem Punkt <b>Content Manager</b> - Eintrag Index bearbeitet werden.', 0, 1, '', 0, 5, 0, '', '', '', '', '', '', '', '1', '1', '1', '1'),
('', 0, 0, '', 1, 'Gutscheine', 'Gutscheine - Fragen und Antworten', '<h2>\r\n	Gutscheine kaufen</h2>\r\n<p>\r\n	Gutscheine k&ouml;nnen, falls sie im Shop angeboten werden, wie normale Artikel gekauft werden. Sobald Sie einen Gutschein gekauft haben und dieser nach erfolgreicher Zahlung freigeschaltet wurde, erscheint der Betrag unter Ihrem Warenkorb. Nun k&ouml;nnen Sie &uuml;ber den Link &quot; Gutschein versenden &quot; den gew&uuml;nschten Betrag per E-Mail versenden.</p>\r\n<h2>\r\n	Wie man Gutscheine versendet</h2>\r\n<p>\r\n	Um einen Gutschein zu versenden, klicken Sie bitte auf den Link &quot;Gutschein versenden&quot; in Ihrem Einkaufskorb. Um einen Gutschein zu versenden, ben&ouml;tigen wir folgende Angaben von Ihnen: Vor- und Nachname des Empf&auml;ngers. Eine g&uuml;ltige E-Mail Adresse des Empf&auml;ngers. Den gew&uuml;nschten Betrag (Sie k&ouml;nnen auch Teilbetr&auml;ge Ihres Guthabens versenden). Eine kurze Nachricht an den Empf&auml;nger. Bitte &uuml;berpr&uuml;fen Sie Ihre Angaben noch einmal vor dem Versenden. Sie haben vor dem Versenden jederzeit die M&ouml;glichkeit Ihre Angaben zu korrigieren.</p>\r\n<h2>\r\n	Mit Gutscheinen Einkaufen.</h2>\r\n<p>\r\n	Sobald Sie &uuml;ber ein Guthaben verf&uuml;gen, k&ouml;nnen Sie dieses zum Bezahlen Ihrer Bestellung verwenden. W&auml;hrend des Bestellvorganges haben Sie die M&ouml;glichkeit Ihr Guthaben einzul&ouml;sen. Falls das Guthaben unter dem Warenwert liegt m&uuml;ssen Sie Ihre bevorzugte Zahlungsweise f&uuml;r den Differenzbetrag w&auml;hlen. &uuml;bersteigt Ihr Guthaben den Warenwert, steht Ihnen das Restguthaben selbstverst&auml;ndlich f&uuml;r Ihre n&auml;chste Bestellung zur Verf&uuml;gung.</p>\r\n<h2>\r\n	Gutscheine verbuchen.</h2>\r\n<p>\r\n	Wenn Sie einen Gutschein per E-Mail erhalten haben, k&ouml;nnen Sie den Betrag wie folgt verbuchen:.<br />\r\n	1. Klicken Sie auf den in der E-Mail angegebenen Link. Falls Sie noch nicht &uuml;ber ein pers&ouml;nliches Kundenkonto verf&uuml;gen, haben Sie die M&ouml;glichkeit ein Konto zu er&ouml;ffnen.<br />\r\n	2. Nachdem Sie ein Produkt in den Warenkorb gelegt haben, k&ouml;nnen Sie dort Ihren Gutscheincode eingeben.</p>\r\n<h2>\r\n	Falls es zu Problemen kommen sollte:</h2>\r\n<p>\r\n	Falls es wider Erwarten zu Problemen mit einem Gutschein kommen sollte, kontaktieren Sie uns bitte per E-Mail : you@yourdomain.com. Bitte beschreiben Sie m&ouml;glichst genau das Problem, wichtige Angaben sind unter anderem: Ihre Kundennummer, der Gutscheincode, Fehlermeldungen des Systems sowie der von Ihnen benutzte Browser.</p>', 0, 1, '', 0, 6, 1, '', '', '', '', '', '', '', '1', '1', '1', '1'),
('', 0, 0, '', 1, 'Kontakt', 'Kontakt', '<p>Ihre Kontaktinformationen</p>', 0, 1, '', 1, 7, 0, '', '', '', '', '', '', '', '1', '1', '1', '1'),
('', 0, 0, '', 1, 'Sitemap', '', '', 0, 0, 'sitemap.php', 1, 8, 0, '', '', '', '', '', '', '', '1', '1', '1', '1'),
('', 0, 0, '', 1, 'Widerrufsrecht', 'Widerrufsrecht', 'Widerrufsrecht bitte hier einfügen', 0, 1, '', 1, 10, 1, '', '', '', '', '', '', '', '1', '1', '1', '1'),
('', 0, 0, '', 1, 'Header 404', 'Die von Ihnen angeforderte Seite wurde nicht gefunden.', '<p>Bitte überprüfen Sie die korrekte schreibweise der URL, oder nutzen Sie die Suchfunktion.</p>', 0, 0, '', 0, 11, 0, '', '', '', '', '', '', '', '1', '1', '1', '1'),
('', 0, 0, '', 1, 'Wartungsmodus', 'Dieser Shop befindet sich im Wartungsmodus', 'Wir führen Wartungsarbeiten durch, werden aber in kürze wieder für Sie da sein.', 0, 0, '', 0, 12, 0, '', '', '','', '', '', '', '1', '1', '1', '1');

# 1 - Default, 2 - USA, 3 - Spanien, 4 - Singapore, 5 - Deutschland
INSERT INTO address_format VALUES (1, '$firstname $lastname$cr$streets$cr$city, $postcode$cr$statecomma$country','$city / $country'),
(2, '$firstname $lastname$cr$streets$cr$city, $state    $postcode$cr$country','$city, $state / $country'),
(3, '$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country','$state / $country'),
(4, '$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country', '$postcode / $country'),
(5, '$firstname $lastname$cr$streets$cr$postcode $city$cr$country','$city / $country');

INSERT INTO admin_access VALUES (1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO admin_access VALUES ('groups', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 2, 4, 2, 2, 2, 2, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);

INSERT INTO emails VALUES (NULL, 'contact', 1, '', 'Email vom Kontaktformular', '', '', 'Kontaktanfrage von mail-adresse.de', '', '', '', '', '', 1263483589);
INSERT INTO emails VALUES (NULL, 'order_mail', 1, '', 'Bestätigung von {$shop_besitzer}', '', 'Bestätigung von {$shop_name}', 'Bestellbestätigung - Nr: {$nr} vom {$date}', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600;}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Bestellbestätigung\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td align="left">\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n            <tr>\r\n                <td width="60%">{$address_label_customer}</td>\r\n                <td>\r\n                  <strong>Bestellung Nr:</strong> {$oID}<br /><br />\r\n                  {if $csID}\r\n              <strong>Kundennummer:</strong> {$csID}<br />\r\n            {/if}\r\n                  {if $PAYMENT_METHOD}\r\n                    <strong>Zahlungsmethode:</strong> {$PAYMENT_METHOD}<br />\r\n                  {/if}\r\n                  <strong>Bestelldatum:</strong> {$DATE}<br />\r\n                  <strong>Telefon:</strong> {$PHONE}<br />\r\n                </td>\r\n            </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellspacing="6" cellpadding="3" class="outerTable">\r\n            <tr bgcolor="#f1f1f1">\r\n              {if $address_label_payment == $address_label_shipping}\r\n                <td width="100%">\r\n                  <strong>Rechnungsadresse</strong>                </td>\r\n          {else}\r\n            <td width="50%">\r\n                  <strong>Lieferadresse</strong>                </td>\r\n            <td>\r\n                <strong>Rechnungsadresse</strong>            </td>\r\n          {/if}            </tr>\r\n            <tr>\r\n          {if $address_label_payment == $address_label_shipping}\r\n              <td>\r\n                {$address_label_shipping}              </td>\r\n          {else}\r\n            <td>{$address_label_shipping}</td>\r\n                  <td>{$address_label_payment}</td>\r\n                {/if}            </tr>\r\n            <tr>\r\n              <td> </td>\r\n              <td> </td>\r\n              <td> </td>\r\n            </tr>\r\n          </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellspacing="0">\r\n        <tr>\r\n          <td><br />\r\n            Hallo {if $GENDER==''f''}Frau{else}Herr{/if} {$NNAME},<br /><br />\r\n            Vielen Dank für Ihre Bestellung.<br /><br />\r\n            {$PAYMENT_INFO_HTML}\r\n            <br />\r\n            {if $COMMENTS}<br />\r\n              <strong>Ihre Anmerkungen:</strong><br />\r\n              {$COMMENTS}<br /><br />\r\n            {/if}\r\n            {if $NEW_PASSWORD}\r\n              <br /><br />\r\n              <strong>Ihr Account Passwort:</strong><br />\r\n              {$NEW_PASSWORD}<br /><br />\r\n            {/if}\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="5" cellspacing="0" bgcolor="f1f1f1" class="outerTable">\r\n        <tr class="ProductsTable">\r\n          <td align="left" class="bb br">\r\n            <strong>Artikel</strong>          </td>\r\n          <td align="center" class="bb br">\r\n            <strong>Einzelpreis</strong>          </td>\r\n          <td align="center" class="bb br">\r\n            <strong>Anzahl</strong>          </td>\r\n          <td align="right" class="bb">\r\n            <strong>Summe</strong>          </td>\r\n        </tr>\r\n        {foreach name=aussen item=order_values from=$order_data}\r\n        <tr>\r\n          <td valign="top" class="bb br ProductsName">\r\n            <strong>{$order_values.PRODUCTS_NAME}</strong> <span class="fs85">(Art-Nr:{$order_values.PRODUCTS_MODEL})</span>\r\n            {if $order_values.PRODUCTS_SHIPPING_TIME neq ''''}<br />\r\n              <em>Lieferzeit: {$order_values.PRODUCTS_SHIPPING_TIME}</em>\r\n            {/if}         \r\n            {if $order_values.PRODUCTS_ATTRIBUTES !=''''}<br /><em>{$order_values.PRODUCTS_ATTRIBUTES}</em>\r\n            {if $order_values.PRODUCTS_ATTRIBUTES_MODEL} <em>(Art-Nr: {$order_values.PRODUCTS_ATTRIBUTES_MODEL})</em> {/if} {/if}</td>\r\n          <td valign="top" class="bb br ProductsName" align="center"><strong>{$order_values.PRODUCTS_SINGLE_PRICE}</strong><br /></td>\r\n          <td valign="top" class="bb br ProductsName" align="center"><strong>{$order_values.PRODUCTS_QTY}</strong></td>\r\n          <td align="right" valign="top" nowrap="nowrap" class="bb"><strong>{$order_values.PRODUCTS_PRICE}</strong><br /></td>\r\n        </tr>\r\n        {/foreach}\r\n        <tr><td colspan="4" class="ProductsName bb"> </td></tr>\r\n        {foreach name=aussen item=order_total_values from=$order_total}\r\n          <tr>\r\n            <td colspan="3" width="98" align="right"><nobr>{$order_total_values.TITLE}</nobr></td>\r\n            <td width="2%" align="right" nowrap="nowrap"><nobr>{$order_total_values.TEXT}</nobr></td>\r\n          </tr>\r\n        {/foreach}\r\n      </table>\r\n    </td>\r\n  </tr>\r\n</table>\r\n\r\n{if $WIDERRUF_TEXT !=''''}<br />\r\n  <table width="90%" border="0" cellpadding="10" cellspacing="0" align="center">\r\n    <tr>\r\n      <td><strong>{$WIDERRUF_HEAD}</strong></td>\r\n    </tr>\r\n    <tr>\r\n      <td>{$WIDERRUF_TEXT}</td>\r\n    </tr>\r\n  </table>\r\n{/if}', '{$address_label_customer}\r\n\r\n{if $PAYMENT_METHOD}Zahlungsmethode: {$PAYMENT_METHOD}{/if}\r\nBestellnummer: {$oID}\r\nDatum: {$DATE}\r\n{if $csID}Kundennummer :{$csID}{/if}\r\n----------------------------------------------------------------------\r\n\r\n\r\nHallo {$NAME},\r\n\r\n{if $NEW_PASSWORD}\r\n    Ihr Account Passwort: {$NEW_PASSWORD}\r\n{/if}   \r\n\r\n{$PAYMENT_INFO_TXT}\r\n\r\n{if $COMMENTS}\r\nIhre Anmerkungen:\r\n{$COMMENTS}\r\n{/if}\r\n\r\nIhre Bestellten Produkte zur Kontrollle\r\n----------------------------------------------------------------------\r\n{foreach name=aussen item=order_values from=$order_data} \r\n{$order_values.PRODUCTS_QTY} x {$order_values.PRODUCTS_NAME} {$order_values.PRODUCTS_PRICE}\r\n{if $order_values.PRODUCTS_SHIPPING_TIME neq ''''}Lieferzeit: {$order_values.PRODUCTS_SHIPPING_TIME}{/if}\r\n{if $order_values.PRODUCTS_ATTRIBUTES !=''''}{$order_values.PRODUCTS_ATTRIBUTES}{/if}\r\n\r\n{/foreach}\r\n\r\n{foreach name=aussen item=order_total_values from=$order_total}\r\n{$order_total_values.TITLE}{$order_total_values.TEXT}\r\n{/foreach}\r\n\r\n\r\n{if $address_label_payment}\r\nRechnungsadresse\r\n----------------------------------------------------------------------\r\n{$address_label_payment}\r\n{/if}\r\nVersandadresse \r\n----------------------------------------------------------------------\r\n{$address_label_shipping}', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600;}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Bestellbestätigung\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td align="left">\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n            <tr>\r\n                <td width="60%">{$address_label_customer}</td>\r\n                <td>\r\n                  <strong>Bestellung Nr:</strong> {$oID}<br /><br />\r\n                  {if $csID}\r\n              <strong>Kundennummer:</strong> {$csID}<br />\r\n            {/if}\r\n                  {if $PAYMENT_METHOD}\r\n                    <strong>Zahlungsmethode:</strong> {$PAYMENT_METHOD}<br />\r\n                  {/if}\r\n                  <strong>Bestelldatum:</strong> {$DATE}<br />\r\n                  <strong>Telefon:</strong> {$PHONE}<br />\r\n                </td>\r\n            </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellspacing="6" cellpadding="3" class="outerTable">\r\n            <tr bgcolor="#f1f1f1">\r\n              {if $address_label_payment == $address_label_shipping}\r\n                <td width="100%">\r\n                  <strong>Rechnungsadresse</strong>                </td>\r\n          {else}\r\n            <td width="50%">\r\n                  <strong>Lieferadresse</strong>                </td>\r\n            <td>\r\n                <strong>Rechnungsadresse</strong>            </td>\r\n          {/if}            </tr>\r\n            <tr>\r\n          {if $address_label_payment == $address_label_shipping}\r\n              <td>\r\n                {$address_label_shipping}              </td>\r\n          {else}\r\n            <td>{$address_label_shipping}</td>\r\n                  <td>{$address_label_payment}</td>\r\n                {/if}            </tr>\r\n            <tr>\r\n              <td> </td>\r\n              <td> </td>\r\n              <td> </td>\r\n            </tr>\r\n          </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellspacing="0">\r\n        <tr>\r\n          <td><br />\r\n            Hallo {if $GENDER==''f''}Frau{else}Herr{/if} {$NNAME},<br /><br />\r\n            Vielen Dank für Ihre Bestellung.<br /><br />\r\n            {$PAYMENT_INFO_HTML}\r\n            <br />\r\n            {if $COMMENTS}<br />\r\n              <strong>Ihre Anmerkungen:</strong><br />\r\n              {$COMMENTS}<br /><br />\r\n            {/if}\r\n            {if $NEW_PASSWORD}\r\n              <br /><br />\r\n              <strong>Ihr Account Passwort:</strong><br />\r\n              {$NEW_PASSWORD}<br /><br />\r\n            {/if}\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="5" cellspacing="0" bgcolor="f1f1f1" class="outerTable">\r\n        <tr class="ProductsTable">\r\n          <td align="left" class="bb br">\r\n            <strong>Artikel</strong>          </td>\r\n          <td align="center" class="bb br">\r\n            <strong>Einzelpreis</strong>          </td>\r\n          <td align="center" class="bb br">\r\n            <strong>Anzahl</strong>          </td>\r\n          <td align="right" class="bb">\r\n            <strong>Summe</strong>          </td>\r\n        </tr>\r\n        {foreach name=aussen item=order_values from=$order_data}\r\n        <tr>\r\n          <td valign="top" class="bb br ProductsName">\r\n            <strong>{$order_values.PRODUCTS_NAME}</strong> <span class="fs85">(Art-Nr:{$order_values.PRODUCTS_MODEL})</span>\r\n            {if $order_values.PRODUCTS_SHIPPING_TIME neq ''''}<br />\r\n              <em>Lieferzeit: {$order_values.PRODUCTS_SHIPPING_TIME}</em>\r\n            {/if}         \r\n            {if $order_values.PRODUCTS_ATTRIBUTES !=''''}<br /><em>{$order_values.PRODUCTS_ATTRIBUTES}</em>\r\n            {if $order_values.PRODUCTS_ATTRIBUTES_MODEL} <em>(Art-Nr: {$order_values.PRODUCTS_ATTRIBUTES_MODEL})</em> {/if} {/if}</td>\r\n          <td valign="top" class="bb br ProductsName" align="center"><strong>{$order_values.PRODUCTS_SINGLE_PRICE}</strong><br /></td>\r\n          <td valign="top" class="bb br ProductsName" align="center"><strong>{$order_values.PRODUCTS_QTY}</strong></td>\r\n          <td align="right" valign="top" nowrap="nowrap" class="bb"><strong>{$order_values.PRODUCTS_PRICE}</strong><br /></td>\r\n        </tr>\r\n        {/foreach}\r\n        <tr><td colspan="4" class="ProductsName bb"> </td></tr>\r\n        {foreach name=aussen item=order_total_values from=$order_total}\r\n          <tr>\r\n            <td colspan="3" width="98" align="right"><nobr>{$order_total_values.TITLE}</nobr></td>\r\n            <td width="2%" align="right" nowrap="nowrap"><nobr>{$order_total_values.TEXT}</nobr></td>\r\n          </tr>\r\n        {/foreach}\r\n      </table>\r\n    </td>\r\n  </tr>\r\n</table>\r\n\r\n{if $WIDERRUF_TEXT !=''''}<br />\r\n  <table width="90%" border="0" cellpadding="10" cellspacing="0" align="center">\r\n    <tr>\r\n      <td><strong>{$WIDERRUF_HEAD}</strong></td>\r\n    </tr>\r\n    <tr>\r\n      <td>{$WIDERRUF_TEXT}</td>\r\n    </tr>\r\n  </table>\r\n{/if}', '{$address_label_customer}\r\n\r\n{if $PAYMENT_METHOD}Zahlungsmethode: {$PAYMENT_METHOD}{/if}\r\nBestellnummer: {$oID}\r\nDatum: {$DATE}\r\n{if $csID}Kundennummer :{$csID}{/if}\r\n----------------------------------------------------------------------\r\n\r\nHallo {$NAME},\r\n\r\n{if $NEW_PASSWORD}\r\n        Ihr Account Passwort: {$NEW_PASSWORD}\r\n{/if}   \r\n\r\n{$PAYMENT_INFO_TXT}\r\n\r\n{if $COMMENTS}\r\nIhre Anmerkungen:\r\n{$COMMENTS}\r\n{/if}\r\n\r\nIhre Bestellten Produkte zur Kontrollle\r\n----------------------------------------------------------------------\r\n{foreach name=aussen item=order_values from=$order_data} \r\n{$order_values.PRODUCTS_QTY} x {$order_values.PRODUCTS_NAME} {$order_values.PRODUCTS_PRICE}\r\n{if $order_values.PRODUCTS_SHIPPING_TIME neq ''''}Lieferzeit: {$order_values.PRODUCTS_SHIPPING_TIME}{/if}\r\n{if $order_values.PRODUCTS_ATTRIBUTES !=''''}{$order_values.PRODUCTS_ATTRIBUTES}{/if}\r\n\r\n{/foreach}\r\n\r\n{foreach name=aussen item=order_total_values from=$order_total}\r\n{$order_total_values.TITLE}{$order_total_values.TEXT}\r\n{/foreach}\r\n\r\n\r\n{if $address_label_payment}\r\nRechnungsadresse\r\n----------------------------------------------------------------------\r\n{$address_label_payment}\r\n{/if}\r\nVersandadresse \r\n----------------------------------------------------------------------\r\n{$address_label_shipping}', 1263483589);
INSERT INTO emails VALUES (NULL, 'pdf_mail', 1,'{$shop_name}','PDF Rechnung von {$store_name} für Ihre Bestellung','{$shop_name}','','Ihre PDF-Rechnung vom {$date}','','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\" dir=\"ltr\" xml:lang=\"de\" lang=\"de\">\r\n<head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />\r\n<title>PDF-Rechnung</title>\r\n{literal}\r\n<style type=\"text/css\"> \r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.lightBackground td {color:#6d88b1;background: #f1f1f1}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width=\"90%\" border=\"0\" cellpadding=\"10\" cellspacing=\"0\" align=\"center\" class=\"outerTable\">\r\n  <tr>\r\n    <td>\r\n      <table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n        <tr>\r\n          <td width=\"50%\">\r\n            <img src=\"{$logo_path}logo.gif\" alt=\"\" />\r\n          </td>\r\n          <td width=\"50%\" class=\"TopRightDesc\" align=\"right\">\r\n            PDF-Rechnung\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>\r\n      <table width=\"100%\" border=\"0\" cellspacing=\"6\" cellpadding=\"3\" class=\"outerTable\">\r\n         <tr>\r\n           <td colspan=\"2\">\r\n                <p><strong>Sehr geehrter Kunde, </strong></p>\r\n             <p>im Anhang dieser E-Mail übermitteln wir Ihnen die Rechnung Ihrer Bestellung vom {$ORDER_DATE}.<br /><br />               Bei Fragen zu Ihrer Bestellung antworten Sie bitte auf diese eMail.</p>\r\n              </td>\r\n          </tr>\r\n        <tr class=\"lightBackground\">\r\n          <td>\r\n            Den Status Ihrer Bestellung können Sie einsehen  unter:\r\n          </td>\r\n          <td>\r\n            <a href=\"{$ORDER_LINK}\">{$ORDER_LINK}</a>\r\n          </td>\r\n        </tr>\r\n       </table>\r\n    </td>\r\n  </tr>\r\n</table>','Sehr geehrter Kunde,\r\n\r\nim Anhang dieser E-Mail übermitteln wir Ihnen die Rechnung Ihrer Bestellung vom {$ORDER_DATE}.\r\n\r\nBei Fragen zu Ihrer Bestellung antworten Sie bitte auf diese eMail, den Status Ihrer Bestellung können \r\nSie einsehen unter: {$ORDER_LINK}.','Sehr geehrter Kunde, \r\n      \r\n\r\nim Anhang dieser E-Mail übermitteln wir Ihnen die Rechnung Ihrer Bestellung vom {$ORDER_DATE}.            \r\n                                                                                                          \r\nBei Fragen zu Ihrer Bestellung antworten Sie bitte auf diese eMail. Den Status Ihrer Bestellung können     \r\nSie einsehen unter: {$ORDER_LINK}.','Sehr geehrter Kunde,\r\n\r\nim Anhang dieser E-Mail übermitteln wir Ihnen die Rechnung Ihrer Bestellung vom {$ORDER_DATE}.\r\n\r\nBei Fragen zu Ihrer Bestellung antworten Sie bitte auf diese eMail, den Status Ihrer Bestellung können \r\nSie einsehen unter: {$ORDER_LINK}.',1263483589);
INSERT INTO emails VALUES (NULL, 'newsletter_aktivierung', 1, '{$shop_name}', '{$shop_name}', '{$shop_name}', '{$shop_name}', 'Newsletteraktivierung für {$shop_name}', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />\r\n<title>Newsletteranmeldung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.lightBackground td, div.lightBackground {color:#6d88b1;background: #f1f1f1}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Newsletteraktivierung\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td><br />\r\n      <strong>Vielen Dank für die Anmeldung.</strong><br /><br />\r\n    Sie erhalten diese Mail weil Sie unseren Newsletter empfangen möchten. Bitte klicken Sie auf den Aktivierungslink damit Ihre Mailadresse für den Newsletterempfang freigeschalten wird.<br /><br />\r\n    <table width="100%" border="0" cellpadding="6" cellspacing="0">\r\n      <tr class="lightBackground">\r\n        <td width="1"><nobr>Ihr Aktivierungslink:</nobr></td>\r\n        <td><a href="{$LINK}">{$LINK}</a></td>\r\n      </tr>\r\n    </table>\r\n    <br /><br />Sollten Sie sich nicht in unseren Newsletter eingetragen haben bzw. den Empfang des Newsletters nicht wünschen bitten wir Sie garnichts zu tun. Ihre Adresse wird dann bei der nächsten Aktualisierung der Datenbank automatisch gelöscht.\r\n    </td>\r\n  </tr>\r\n</table>', 'Vielen Dank für die Anmeldung.\r\nSie erhalten diese Mail weil Sie unseren Newsletter empfangen möchten.\r\nBitte klicken Sie auf den Aktivierungslink damit Ihre Mailadresse für den Newsletterempfang freigeschalten wird.\r\nSollten Sie sich nicht in unserern Newsletter eingetragen haben bzw. den Empfang des Newsletters nicht wünschen bitten wir Sie garnichts zu tun.\r\nIhre Adresse wird dann bei der nächsten Aktualisierung der Datenbank automatisch gelöscht.\r\n      \r\n    \r\nIhr Aktivierungslink: {$LINK}', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />\r\n<title>Newsletteranmeldung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.lightBackground td, div.lightBackground {color:#6d88b1;background: #f1f1f1}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Newsletteraktivierung\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td><br />\r\n      <strong>Vielen Dank für die Anmeldung.</strong><br /><br />\r\n    Sie erhalten diese Mail weil Sie unseren Newsletter empfangen möchten. Bitte klicken Sie auf den Aktivierungslink damit Ihre Mailadresse für den Newsletterempfang freigeschalten wird.<br /><br />\r\n    <table width="100%" border="0" cellpadding="6" cellspacing="0">\r\n      <tr class="lightBackground">\r\n        <td width="1"><nobr>Ihr Aktivierungslink:</nobr></td>\r\n        <td><a href="{$LINK}">{$LINK}</a></td>\r\n      </tr>\r\n    </table>\r\n    <br /><br />Sollten Sie sich nicht in unseren Newsletter eingetragen haben bzw. den Empfang des Newsletters nicht wünschen bitten wir Sie garnichts zu tun. Ihre Adresse wird dann bei der nächsten Aktualisierung der Datenbank automatisch gelöscht.\r\n    </td>\r\n  </tr>\r\n</table>', 'Vielen Dank für die Anmeldung.\r\nSie erhalten diese Mail weil Sie unseren Newsletter empfangen möchten.\r\nBitte klicken Sie auf den Aktivierungslink damit Ihre Mailadresse für den Newsletterempfang freigeschalten wird.\r\nSollten Sie sich nicht in unserern Newsletter eingetragen haben bzw. den Empfang des Newsletters nicht wünschen bitten wir Sie garnichts zu tun.\r\nIhre Adresse wird dann bei der nächsten Aktualisierung der Datenbank automatisch gelöscht.\r\n      \r\n    \r\nIhr Aktivierungslink:{$LINK}', 1263483589);
INSERT INTO emails VALUES (NULL, 'newsletter', 1, '', '{$shop_name}', '', '{$shop_name}', '', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Newsletter</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {\r\n  font-size:11.5px;\r\n  font-family:Helvetica, sans-serif;\r\n  color:#444\r\n}\r\ntable.outerTable {\r\n  border: 1px solid #ccc\r\n}\r\ntd.TopRightDesc {\r\n  letter-spacing: 1px;\r\n  font-weight: 600\r\n}\r\n.ProductsTable td {\r\n  color:#6d88b1;\r\n  background: #f1f1f1\r\n}\r\n.ProductsAttributes td, .ProductsName {\r\n  background: #ffffff\r\n}\r\n.bt {\r\n  border-top:1px solid #ccc\r\n}\r\n.bb {\r\n  border-bottom:1px solid #ccc\r\n}\r\n.bl {\r\n  border-left:1px solid #ccc\r\n}\r\n.br {\r\n  border-right:1px solid #ccc\r\n}\r\n.fs85 {\r\n  font-size:85%\r\n}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n    <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n      <tr>\r\n        <td width="50%"><img src="{$logo_path}logo.gif" alt="" /> </td>\r\n        <td width="50%" class="TopRightDesc" align="right"> Newsletter </td>\r\n      </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>\r\n    <div style="width:95%; background-color:#fff; padding:10px;">\r\n      <h2 style="border-bottom:2px solid #6a0101; padding-bottom:10px; color:#333;">{$SHOP_NAME} Newsletter</h2>\r\n      <p><strong> {if $personalize == ''yes'' && $greeting_type == ''0''} {if $customers_gender == ''f''} Sehr geehrte Frau {$customers_name}, {else} Sehr geehrter Herr {$customers_name}, {/if} {/if} {if $personalize == ''yes'' && $greeting_type == ''1''} Hallo {$customers_name}, {/if} {if $personalize == ''''} Sehr geehrter Kunde, {/if} </strong></p>\r\n      <p>{$body}</p>\r\n      {if $gift_id}\r\n      {if $greeting_type == ''1''}\r\n      <table width="100%" style="border:1px #CCC; padding:10px; margin-bottom:15px; background-color:#ffeded;">\r\n        <tr>\r\n        <td><p style="padding-bottom:7px; margin:0 0 10px 0;"><strong style="font-family: Georgia, Times New Roman, Times, serif; font-size:12px;">Gutschein:</strong></p>\r\n          Als kleines Pr&auml;sent &uuml;bersenden wir Dir einen Gutschein in H&ouml;he von <b>{$gift_ammount}</b>. <br />\r\n          Geb einfach bei der Bestellung deinen pers&ouml;nlichen Gutscheincode an: <b>{$gift_id}</b></td>\r\n        </tr>\r\n      </table>\r\n      {else}\r\n      <table width="100%" style="border:1px #CCC; padding:10px; margin-bottom:15px; background-color:#ffeded;">\r\n        <tr>\r\n        <td><p style="padding-bottom:7px; margin:0 0 10px 0;"><strong style="font-family: Georgia, Times New Roman, Times, serif; font-size:12px;">Gutschein:</strong></p>\r\n          Als kleines Pr&auml;sent &uuml;bersenden wir Ihnen einen Gutschein in H&ouml;he von <b>{$gift_ammount}</b>. <br />\r\n          Geben Sie einfach bei der Bestellung Ihren pers&ouml;nlichen Gutscheincode an: <b>{$gift_id}</b></td>\r\n        </tr>\r\n      </table>\r\n      {/if}\r\n      {/if}\r\n      <div style="background:#fff;">\r\n        <table width="100%" cellpadding="0" cellspacing="0" border="0">\r\n        <tr> {foreach name=aussen item=module_data from=$module_content}\r\n          {php} $col++; \r\n          {/php}\r\n          <td><table width="100%" border="0" cellpadding="10" cellspacing="0" style="border-bottom:1px solid #999;">\r\n            <tr>\r\n            <td width="20%" rowspan="2" valign="top" style="border-right:1px solid #999;"><a href="{$module_data.PRODUCTS_LINK}"> <img src="{$module_data.PRODUCTS_IMAGE}" alt="{$module_data.PRODUCTS_NAME}" border="0" class"productImageBorder" /> </a> </td>\r\n            <td width="80%" valign="top"><a href="{$module_data.PRODUCTS_LINK}" style="text-decoration:none;">\r\n              <h1 style="font-size:12px; color:#6a0101;">{$module_data.PRODUCTS_NAME}</h1>\r\n              </a>{$module_data.PRODUCTS_SHORT_DESCRIPTION} \r\n              </td>\r\n            </tr>\r\n            <tr>\r\n            <td valign="bottom">\r\n              <div style="text-align:right; border-top:1px solid #000; padding-top:5px; margin-top:10px;"> \r\n                <a href="{$module_data.PRODUCTS_LINK}" style="color:#6a0101; text-decoration:underline;"><b>Kaufen Sie jetzt hier!</b></a> | <strong>{$module_data.PRODUCTS_PRICE}</strong> \r\n              </div>\r\n            </td>\r\n            </tr>\r\n          </table></td>\r\n          {php} \r\n          if ($col>=1) {\r\n          $col=0;\r\n          echo ''</tr>\r\n        <tr>'';\r\n          }\r\n          {/php}\r\n          {/foreach} </tr>\r\n        </table>\r\n        <div style="text-align:right; font-size:10px; margin-top:10px;">{$remove_link}</div>\r\n      </div>\r\n      </div>\r\n    </td>\r\n  </tr>\r\n</table>', 'Shopname Newsletter\r\n\r\n{if $personalize == ''yes'' && $greeting_type == ''0''} {if $customers_gender == ''f''} Sehr geehrte Frau {$customers_name}, {else} Sehr geehrter Herr {$customers_name}, {/if} {/if} {if $personalize == ''yes'' && $greeting_type == ''1''} Hallo {$customers_name}, {/if} {if $personalize == ''''} Sehr geehrter Kunde, {/if} \r\n\r\n{$body}\r\n\r\n{if $gift_id} {if $greeting_type == ''1''} Gutschein:\r\n\r\nAls kleines Präsent übersenden wir Dir einen Gutschein in Höhe von {$gift_ammount}. Geb einfach bei der Bestellung deinen persönlichen Gutscheincode an: {$gift_id}\r\n\r\n{else} Gutschein:\r\n\r\nAls kleines Präsent übersenden wir Ihnen einen Gutschein in Höhe von {$gift_ammount}. Geben Sie einfach bei der Bestellung Ihren persönlichen Gutscheincode an: {$gift_id}\r\n\r\n{/if} {/if} {foreach name=aussen item=module_data from=$module_content} {php} $col++; {/php} \r\n\r\n{$module_data.PRODUCTS_NAME}\r\n\r\n{$module_data.PRODUCTS_SHORT_DESCRIPTION} \r\n\r\nKaufen Sie jetzt! | {$module_data.PRODUCTS_PRICE} EUR	\r\n\r\n\r\n\r\n\r\n\r\n{php} if ($col>=1) { $col=0; echo ''''; } {/php} {/foreach} {$remove_link}\r\n\r\n\r\n\r\n', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Newsletter</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {\r\n  font-size:11.5px;\r\n  font-family:Helvetica, sans-serif;\r\n  color:#444\r\n}\r\ntable.outerTable {\r\n  border: 1px solid #ccc\r\n}\r\ntd.TopRightDesc {\r\n  letter-spacing: 1px;\r\n  font-weight: 600\r\n}\r\n.ProductsTable td {\r\n  color:#6d88b1;\r\n  background: #f1f1f1\r\n}\r\n.ProductsAttributes td, .ProductsName {\r\n  background: #ffffff\r\n}\r\n.bt {\r\n  border-top:1px solid #ccc\r\n}\r\n.bb {\r\n  border-bottom:1px solid #ccc\r\n}\r\n.bl {\r\n  border-left:1px solid #ccc\r\n}\r\n.br {\r\n  border-right:1px solid #ccc\r\n}\r\n.fs85 {\r\n  font-size:85%\r\n}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n    <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n      <tr>\r\n        <td width="50%"><img src="{$logo_path}logo.gif" alt="" /> </td>\r\n        <td width="50%" class="TopRightDesc" align="right"> Newsletter </td>\r\n      </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>\r\n    <div style="width:95%; background-color:#fff; padding:10px;">\r\n      <h2 style="border-bottom:2px solid #6a0101; padding-bottom:10px; color:#333;">{$SHOP_NAME} Newsletter</h2>\r\n      <p><strong> {if $personalize == ''yes'' && $greeting_type == ''0''} {if $customers_gender == ''f''} Sehr geehrte Frau {$customers_name}, {else} Sehr geehrter Herr {$customers_name}, {/if} {/if} {if $personalize == ''yes'' && $greeting_type == ''1''} Hallo {$customers_name}, {/if} {if $personalize == ''''} Sehr geehrter Kunde, {/if} </strong></p>\r\n      <p>{$body}</p>\r\n      {if $gift_id}\r\n      {if $greeting_type == ''1''}\r\n      <table width="100%" style="border:1px #CCC; padding:10px; margin-bottom:15px; background-color:#ffeded;">\r\n        <tr>\r\n        <td><p style="padding-bottom:7px; margin:0 0 10px 0;"><strong style="font-family: Georgia, Times New Roman, Times, serif; font-size:12px;">Gutschein:</strong></p>\r\n          Als kleines Pr&auml;sent &uuml;bersenden wir Dir einen Gutschein in H&ouml;he von <b>{$gift_ammount}</b>. <br />\r\n          Geb einfach bei der Bestellung deinen pers&ouml;nlichen Gutscheincode an: <b>{$gift_id}</b></td>\r\n        </tr>\r\n      </table>\r\n      {else}\r\n      <table width="100%" style="border:1px #CCC; padding:10px; margin-bottom:15px; background-color:#ffeded;">\r\n        <tr>\r\n        <td><p style="padding-bottom:7px; margin:0 0 10px 0;"><strong style="font-family: Georgia, Times New Roman, Times, serif; font-size:12px;">Gutschein:</strong></p>\r\n          Als kleines Pr&auml;sent &uuml;bersenden wir Ihnen einen Gutschein in H&ouml;he von <b>{$gift_ammount}</b>. <br />\r\n          Geben Sie einfach bei der Bestellung Ihren pers&ouml;nlichen Gutscheincode an: <b>{$gift_id}</b></td>\r\n        </tr>\r\n      </table>\r\n      {/if}\r\n      {/if}\r\n      <div style="background:#fff;">\r\n        <table width="100%" cellpadding="0" cellspacing="0" border="0">\r\n        <tr> {foreach name=aussen item=module_data from=$module_content}\r\n          {php} $col++; \r\n          {/php}\r\n          <td><table width="100%" border="0" cellpadding="10" cellspacing="0" style="border-bottom:1px solid #999;">\r\n            <tr>\r\n            <td width="20%" rowspan="2" valign="top" style="border-right:1px solid #999;"><a href="{$module_data.PRODUCTS_LINK}"> <img src="{$module_data.PRODUCTS_IMAGE}" alt="{$module_data.PRODUCTS_NAME}" border="0" class"productImageBorder" /> </a> </td>\r\n            <td width="80%" valign="top"><a href="{$module_data.PRODUCTS_LINK}" style="text-decoration:none;">\r\n              <h1 style="font-size:12px; color:#6a0101;">{$module_data.PRODUCTS_NAME}</h1>\r\n              </a>{$module_data.PRODUCTS_SHORT_DESCRIPTION} \r\n              </td>\r\n            </tr>\r\n            <tr>\r\n            <td valign="bottom">\r\n              <div style="text-align:right; border-top:1px solid #000; padding-top:5px; margin-top:10px;"> \r\n                <a href="{$module_data.PRODUCTS_LINK}" style="color:#6a0101; text-decoration:underline;"><b>Kaufen Sie jetzt hier!</b></a> | <strong>{$module_data.PRODUCTS_PRICE}</strong> \r\n              </div>\r\n            </td>\r\n            </tr>\r\n          </table></td>\r\n          {php} \r\n          if ($col>=1) {\r\n          $col=0;\r\n          echo ''</tr>\r\n        <tr>'';\r\n          }\r\n          {/php}\r\n          {/foreach} </tr>\r\n        </table>\r\n        <div style="text-align:right; font-size:10px; margin-top:10px;">{$remove_link}</div>\r\n      </div>\r\n      </div>\r\n    </td>\r\n  </tr>\r\n</table>', 'Shopname Newsletter\r\n\r\n{if $personalize == ''yes'' && $greeting_type == ''0''} {if $customers_gender == ''f''} Sehr geehrte Frau {$customers_name}, {else} Sehr geehrter Herr {$customers_name}, {/if} {/if} {if $personalize == ''yes'' && $greeting_type == ''1''} Hallo {$customers_name}, {/if} {if $personalize == ''''} Sehr geehrter Kunde, {/if} \r\n\r\n{$body}\r\n\r\n{if $gift_id} {if $greeting_type == ''1''} Gutschein:\r\n\r\nAls kleines Präsent übersenden wir Dir einen Gutschein in Höhe von {$gift_ammount}. Geb einfach bei der Bestellung deinen persönlichen Gutscheincode an: {$gift_id}\r\n\r\n{else} Gutschein:\r\n\r\nAls kleines Präsent übersenden wir Ihnen einen Gutschein in Höhe von {$gift_ammount}. Geben Sie einfach bei der Bestellung Ihren persönlichen Gutscheincode an: {$gift_id}\r\n\r\n{/if} {/if} {foreach name=aussen item=module_data from=$module_content} {php} $col++; {/php} \r\n\r\n{$module_data.PRODUCTS_NAME}\r\n\r\n{$module_data.PRODUCTS_SHORT_DESCRIPTION} \r\n\r\nKaufen Sie jetzt! | {$module_data.PRODUCTS_PRICE} EUR	\r\n\r\n\r\n\r\n\r\n\r\n{php} if ($col>=1) { $col=0; echo ''''; } {/php} {/foreach} {$remove_link}\r\n\r\n\r\n\r\n', 0);
INSERT INTO emails VALUES (NULL, 'signatur', 1, '', '', '', '', '', '', '{literal}<style type="text/css"> \r\n  table.signatur {color:#666;border-top:1px solid #ccc}\r\n</style>\r\n{/literal}\r\n<br />\r\n<table width="90%" border="0" cellpadding="4" cellspacing="0" align="center" class="signatur">\r\n  <tr>\r\n    <td colspan="2">\r\n      <strong>Impressum:</strong>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td width="1">Firma:</td>\r\n    <td><nobr>{$SHOP_NAME}</nobr></td>\r\n  </tr>\r\n  <tr>\r\n    <td>Inhaber:</td>\r\n    <td><nobr>{$SHOP_BESITZER}</nobr></td>\r\n  </tr>\r\n  <tr>\r\n    <td valign="top">Adresse:</td>\r\n    <td>\r\n      <nobr>{$SHOP_ADRESSE_VNAME} {$SHOP_ADRESSE_NNAME}</nobr><br />\r\n      <nobr>{$SHOP_ADRESSE_STRASSE}</nobr><br />\r\n      <nobr>{$SHOP_ADRESSE_PLZ} {$SHOP_ADRESSE_ORT}</nobr>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>Shop URL:</td>\r\n    <td><nobr><a href="{$SHOP_URL}">{$SHOP_URL}</a></nobr></td>\r\n  </tr>\r\n  <tr>\r\n    <td>E-Mail:</td>\r\n    <td><nobr><a href="mailto:{$SHOP_EMAIL}">{$SHOP_EMAIL}</a></nobr></td>\r\n  </tr>\r\n  {if $SHOP_USTID}\r\n  <tr>\r\n    <td>UST-ID:</td>\r\n    <td><nobr>{$SHOP_USTID}</nobr></td>\r\n  </tr>\r\n  {/if}\r\n  <tr>\r\n    <td>Inhaber:</td>\r\n    <td><nobr>{$SHOP_ADRESSE_VNAME} {$SHOP_ADRESSE_NNAME}</nobr></td>\r\n  </tr>\r\n</table>\r\n</body>\r\n</html>', '\r\n\r\nFirma: {$SHOP_NAME}\r\n\r\nInhaber: {$SHOP_BESITZER}\r\n\r\nAdresse: {$SHOP_ADRESSE_VNAME} {$SHOP_ADRESSE_NNAME}\r\n		 {$SHOP_ADRESSE_STRASSE}\r\nOrt:	 {$SHOP_ADRESSE_PLZ} {$SHOP_ADRESSE_ORT}\r\n\r\nShop URL: {$SHOP_URL}\r\nE-Mail: ihre@mail-adresse.de\r\n\r\nUST-ID: {$SHOP_USTID}\r\nInhaber/in: {$SHOP_BESITZER}', '{literal}\r\n \r\n	table.signatur {color:#666;border-top:1px solid #ccc}\r\n\r\n{/literal}\r\n\r\n\r\n	\r\n		\r\n			Impressum:\r\n		\r\n	\r\n	\r\n		Firma:\r\n		{$SHOP_NAME}\r\n	\r\n	\r\n		Inhaber:\r\n		{$SHOP_BESITZER}\r\n	\r\n	\r\n		Adresse:\r\n		\r\n			{$SHOP_ADRESSE_VNAME} {$SHOP_ADRESSE_NNAME}\r\n			{$SHOP_ADRESSE_STRASSE}\r\n			{$SHOP_ADRESSE_PLZ} {$SHOP_ADRESSE_ORT}\r\n		\r\n	\r\n	\r\n		Shop URL:\r\n		{$SHOP_URL}\r\n	\r\n	\r\n		E-Mail:\r\n		{$SHOP_EMAIL}\r\n	\r\n	{if $SHOP_USTID}\r\n	\r\n		UST-ID:\r\n		{$SHOP_USTID}\r\n	\r\n	{/if}\r\n	\r\n		Inhaber:\r\n		{$SHOP_ADRESSE_VNAME} {$SHOP_ADRESSE_NNAME}', '\r\n\r\nFirma: {$SHOP_NAME}\r\n\r\nInhaber: {$SHOP_BESITZER}\r\n\r\nAdresse: {$SHOP_ADRESSE_VNAME} {$SHOP_ADRESSE_NNAME}\r\n		 {$SHOP_ADRESSE_STRASSE}\r\nOrt:	 {$SHOP_ADRESSE_PLZ} {$SHOP_ADRESSE_ORT}\r\n\r\nShop URL: {$SHOP_URL}\r\nE-Mail: ihre@mail-adresse.de\r\n\r\nUST-ID: {$SHOP_USTID}\r\nInhaber/in: {$SHOP_BESITZER}', 1263483589);
INSERT INTO emails VALUES (NULL, 'change_password', 1, '', 'Geändertes Passwort', '', '', 'Änderung ihres Passwortes', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>neues Passwort</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.lightBackground td {color:#6d88b1;background: #f1f1f1}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr> \r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            neues Passwort\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr> \r\n    <td>\r\n      <p><strong>Sehr geehrter Kunde,</strong></p>\r\n      <p>Ihr Passwort wurde erfolgreich geändert.<br /><br />\r\n        Ihre neuen Logindaten:</p>\r\n    </td>\r\n  </tr> \r\n  <tr class="lightBackground">\r\n    <td width="1">\r\n      <nobr><strong>Ihre Email:</strong></nobr>\r\n    </td>\r\n    <td>\r\n        {$EMAIL}\r\n    </td>\r\n  </tr>\r\n  <tr class="lightBackground">\r\n     <td width="1">\r\n        <nobr><strong>Ihr neues Passwort:</strong></nobr>\r\n      </td>\r\n      <td>\r\n        {$PASSWORD}\r\n     </td>\r\n  </tr>\r\n</table>', 'Sehr geehrter Kunde,\r\n\r\nIhr Passwort wurde erfolgreich geändert.\r\n\r\nIhre neuen Logindaten:\r\n      \r\nIhre Mail: {$EMAIL}\r\nIhr Passwort: {$PASSWORD}', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr> \r\n    <td style="border-bottom: 1px solid;border-color: #cccccc;"><div align="right"><img src="{$logo_path}logo.gif"></div></td>\r\n  </tr>\r\n  <tr> \r\n    <td><p><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><strong>Sehr geehrter Kunde,</strong></font> </p>\r\n      <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Ihr Passwort wurde erfolgreich geändert.<br>\r\n        <br>\r\n  Ihre neuen Logindaten:</font><font size="1" face="Verdana, Arial, Helvetica, sans-serif">\r\n      </font>  </p>      \r\n      <table width="100%"  border="0" bgcolor="f1f1f1">\r\n    <tr>\r\n      <td> <font size="1" face="Verdana, Arial, Helvetica, sans-serif"><strong>Ihre email:</strong>        \r\n            {$EMAIL}\r\n            <br>\r\n            <strong>Ihr neues Passwort:</strong>            {$PASSWORD}\r\n        </font> </td>\r\n    </tr>\r\n  </table></td>\r\n  </tr>\r\n</table>', 'Sehr geehrter Kunde,\r\n\r\nIhr Passwort wurde erfolgreich geändert.\r\n\r\nIhre neuen Logindaten:\r\n      \r\nIhre Mail: {$EMAIL}\r\nIhr Passwort: {$PASSWORD}', 1263483589);
INSERT INTO emails VALUES (NULL, 'create_account', 1, '', 'mail-adresse.de', '', 'mail-adresse.de', 'Bestätigung Kundenkonto', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />\r\n<title>Kontoeröffnung</title>\r\n{literal}\r\n<style type="text/css"> \r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.lightBackground td {color:#6d88b1;background: #f1f1f1}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr> \r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Kontoeröffnung\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr> \r\n    <td><br />\r\n      <strong>Sehr {if $GENDER ==''f''}geehrte Frau {$NNAME}{elseif $GENDER == ''m''}geehrter Herr {$NNAME}{else} geehrter Kunde{/if},</strong><br /><br />\r\n      Sie haben soeben Ihr Kundenkonto mit folgendem Zugang erfolgreich erstellt:<br /><br />\r\n      <table width="100%" border="0" cellpadding="10" cellspacing="5" align="center" class="outerTable ">\r\n        <tr class="lightBackground">\r\n          <td width="1"><nobr>Ihre Mailaddresse für die Shopanmeldung:</nobr></td>\r\n          <td>{$USERNAME4MAIL}</td>\r\n        </tr>\r\n        <tr class="lightBackground">\r\n          <td width="1"><nobr>Das dazugehörige Passwort:</nobr></td>\r\n          <td>{$PASSWORT4MAIL}</td>\r\n        </tr>\r\n      </table><br /><br />\r\n      Als registrierter Kunde haben sie folgende Vorteile in unserem Shop.<br /><br />\r\n      <b>- Kundenwarenkorb</b> - Jeder Artikel bleibt registriert bis Sie zur Kasse gehen, oder die Produkte aus dem Warenkorb entfernen.<br />\r\n      <b>- Adressbuch</b> - Wir können jetzt die Produkte zu der von Ihnen ausgesuchten Adresse senden. Der perfekte Weg ein Geburtstagsgeschenk zu versenden.<br />\r\n      <b>- Vorherige Bestellungen</b> - Sie können jederzeit Ihre vorherigen Bestellungen überprüfen.<br />\r\n      <b>- Meinungen über Produkte</b> - Teilen Sie Ihre Meinung zu unseren Produkten mit anderen Kunden.<br /><br />\r\n      \r\n      {if $SEND_GIFT==true}\r\n        Als kleines Willkommensgeschenk senden wir Ihnen einen Gutschein über: <b>{$GIFT_AMMOUNT}</b><br /><br />\r\n        Ihr persönlicher Gutscheincode lautet <b>{$GIFT_CODE}</b>. Sie können diese Gutschrift an der Kasse während des Bestellvorganges verbuchen.<br /><br />\r\n        Um den Gutschein einzulösen klichen Sie bitte auf <a href="{$GIFT_LINK}">[Gutschein Einlösen]</a>.<br /><br />\r\n      {/if}\r\n      {if $SEND_COUPON==true}\r\n        Als kleines Willkommensgeschenk senden wir Ihnen einen Coupon.<br />\r\n        Kuponbeschreibung: <b>{$COUPON_DESC}</b><br />\r\n        Geben Sie einfach Ihren persönlichen Code {$COUPON_CODE} während des Bezahlvorganges ein<br /><br />\r\n      {/if}\r\n      <br />\r\n      <em>Falls Sie Fragen zu unserem Kunden-Service haben, wenden Sie sich bitte an: \r\n      <a href="mailto:{$MAIL_REPLY_ADDRESS}">{$MAIL_REPLY_ADDRESS}</a>.<br /><br />\r\n      Achtung: Diese eMail-Adresse wurde uns von einem Kunden bekannt gegeben. Falls Sie sich nicht angemeldet haben, senden Sie bitte eine eMail an \r\n      <a href="mailto:{$MAIL_REPLY_ADDRESS}">{$MAIL_REPLY_ADDRESS}</a>.</em><br /><br />\r\n    </td>\r\n  </tr>\r\n</table>', 'Sehr geehrter Kunde,\r\n\r\nSie haben soeben Ihr Kundenkonto erfolgreich erstellt, als registrierter Kunde haben sie folgende Vorteile in unserem Shop. \r\n\r\n-Kundenwarenkorb - Jeder Artikel bleibt registriert bis Sie zur Kasse gehen, oder die Produkte aus dem Warenkorb entfernen.\r\n-Adressbuch - Wir können jetzt die Produkte zu der von Ihnen ausgesuchten Adresse senden. Der perfekte Weg ein Geburtstagsgeschenk zu versenden.\r\n-Vorherige Bestellungen - Sie können jederzeit Ihre vorherigen Bestellungen überprüfen.\r\n-Meinungen über Produkte - Teilen Sie Ihre Meinung zu unseren Produkten mit anderen Kunden.      \r\n\r\nFalls Sie Fragen zu unserem Kunden-Service haben, wenden Sie sich bitte an: {#support_mail_address#}\r\n\r\n\r\nAchtung: Diese eMail-Adresse wurde uns von einem Kunden bekannt gegeben. Falls Sie sich nicht angemeldet haben, senden Sie bitte eine eMail an: {#support_mail_address#}\r\n    \r\n{if $SEND_GIFT==true}\r\nAls kleines Willkommensgeschenk senden wir Ihnen einen Gutschein über:	{$GIFT_AMMOUNT}\r\n\r\nIhr persönlicher Gutscheincode lautet {$GIFT_CODE}. \r\nSie können diese Gutschrift an der Kasse während des Bestellvorganges verbuchen.\r\n\r\nUm den Gutschein einzulösen verwenden Sie bitte den folgenden link {$GIFT_LINK}.\r\n{/if}\r\n\r\n{if $SEND_COUPON==true}\r\n Als kleines Willkommensgeschenk senden wir Ihnen einen Kupon.\r\n Kuponbeschreibung: {$COUPON_DESC}\r\n \r\nGeben Sie einfach Ihren persönlichen Code {$COUPON_CODE} während des Bezahlvorganges ein\r\n\r\n{/if}', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />\r\n<title>Kontoeröffnung</title>\r\n{literal}\r\n<style type="text/css"> \r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.lightBackground td {color:#6d88b1;background: #f1f1f1}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr> \r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Kontoeröffnung\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr> \r\n    <td><br />\r\n      <strong>Sehr {if $GENDER ==''f''}geehrte Frau {$NNAME}{elseif $GENDER == ''m''}geehrter Herr {$NNAME}{else} geehrter Kunde{/if},</strong><br /><br />\r\n      Sie haben soeben Ihr Kundenkonto mit folgendem Zugang erfolgreich erstellt:<br /><br />\r\n      <table width="100%" border="0" cellpadding="10" cellspacing="5" align="center" class="outerTable ">\r\n        <tr class="lightBackground">\r\n          <td width="1"><nobr>Ihre Mailaddresse für die Shopanmeldung:</nobr></td>\r\n          <td>{$USERNAME4MAIL}</td>\r\n        </tr>\r\n        <tr class="lightBackground">\r\n          <td width="1"><nobr>Das dazugehörige Passwort:</nobr></td>\r\n          <td>{$PASSWORT4MAIL}</td>\r\n        </tr>\r\n      </table><br /><br />\r\n      Als registrierter Kunde haben sie folgende Vorteile in unserem Shop.<br /><br />\r\n      <b>- Kundenwarenkorb</b> - Jeder Artikel bleibt registriert bis Sie zur Kasse gehen, oder die Produkte aus dem Warenkorb entfernen.<br />\r\n      <b>- Adressbuch</b> - Wir können jetzt die Produkte zu der von Ihnen ausgesuchten Adresse senden. Der perfekte Weg ein Geburtstagsgeschenk zu versenden.<br />\r\n      <b>- Vorherige Bestellungen</b> - Sie können jederzeit Ihre vorherigen Bestellungen überprüfen.<br />\r\n      <b>- Meinungen über Produkte</b> - Teilen Sie Ihre Meinung zu unseren Produkten mit anderen Kunden.<br /><br />\r\n      \r\n      {if $SEND_GIFT==true}\r\n        Als kleines Willkommensgeschenk senden wir Ihnen einen Gutschein über: <b>{$GIFT_AMMOUNT}</b><br /><br />\r\n        Ihr persönlicher Gutscheincode lautet <b>{$GIFT_CODE}</b>. Sie können diese Gutschrift an der Kasse während des Bestellvorganges verbuchen.<br /><br />\r\n        Um den Gutschein einzulösen klichen Sie bitte auf <a href="{$GIFT_LINK}">[Gutschein Einlösen]</a>.<br /><br />\r\n      {/if}\r\n      {if $SEND_COUPON==true}\r\n        Als kleines Willkommensgeschenk senden wir Ihnen einen Coupon.<br />\r\n        Kuponbeschreibung: <b>{$COUPON_DESC}</b><br />\r\n        Geben Sie einfach Ihren persönlichen Code {$COUPON_CODE} während des Bezahlvorganges ein<br /><br />\r\n      {/if}\r\n      <br />\r\n      <em>Falls Sie Fragen zu unserem Kunden-Service haben, wenden Sie sich bitte an: \r\n      <a href="mailto:{$MAIL_REPLY_ADDRESS}">{$MAIL_REPLY_ADDRESS}</a>.<br /><br />\r\n      Achtung: Diese eMail-Adresse wurde uns von einem Kunden bekannt gegeben. Falls Sie sich nicht angemeldet haben, senden Sie bitte eine eMail an \r\n      <a href="mailto:{$MAIL_REPLY_ADDRESS}">{$MAIL_REPLY_ADDRESS}</a>.</em><br /><br />\r\n    </td>\r\n  </tr>\r\n</table>', 'Sehr geehrter Kunde,\r\n\r\nSie haben soeben Ihr Kundenkonto erfolgreich erstellt, als registrierter Kunde haben sie folgende Vorteile in unserem Shop. \r\n\r\n-Kundenwarenkorb - Jeder Artikel bleibt registriert bis Sie zur Kasse gehen, oder die Produkte aus dem Warenkorb entfernen.\r\n-Adressbuch - Wir können jetzt die Produkte zu der von Ihnen ausgesuchten Adresse senden. Der perfekte Weg ein Geburtstagsgeschenk zu versenden.\r\n-Vorherige Bestellungen - Sie können jederzeit Ihre vorherigen Bestellungen überprüfen.\r\n-Meinungen über Produkte - Teilen Sie Ihre Meinung zu unseren Produkten mit anderen Kunden.      \r\n\r\nFalls Sie Fragen zu unserem Kunden-Service haben, wenden Sie sich bitte an: {#support_mail_address#}\r\n\r\n\r\nAchtung: Diese eMail-Adresse wurde uns von einem Kunden bekannt gegeben. Falls Sie sich nicht angemeldet haben, senden Sie bitte eine eMail an: {#support_mail_address#}\r\n    \r\n{if $SEND_GIFT==true}\r\nAls kleines Willkommensgeschenk senden wir Ihnen einen Gutschein über:	{$GIFT_AMMOUNT}\r\n\r\nIhr persönlicher Gutscheincode lautet {$GIFT_CODE}. \r\nSie können diese Gutschrift an der Kasse während des Bestellvorganges verbuchen.\r\n\r\nUm den Gutschein einzulösen verwenden Sie bitte den folgenden link {$GIFT_LINK}.\r\n{/if}\r\n\r\n{if $SEND_COUPON==true}\r\n Als kleines Willkommensgeschenk senden wir Ihnen einen Kupon.\r\n Kuponbeschreibung: {$COUPON_DESC}\r\n \r\nGeben Sie einfach Ihren persönlichen Code {$COUPON_CODE} während des Bezahlvorganges ein\r\n\r\n{/if}', 1263483589);
INSERT INTO emails VALUES (NULL, 'new_password', 1, '', 'Kundenservice', '', 'Kundenservice', 'Ihr neues Passwort', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Neues Passwort</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.lightBackground td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Neues Passwort\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr> \r\n    <td><p><b>Passwort geändert!</b></p>\r\n      Sie erhalten diese Mail, weil Sie ein neues Passwort angefordert und eingerichtet haben.<br />\r\n      Bitte loggen Sie sich mit folgendem Passwort und Ihrer E-mail Adresse bei uns ein und ändern Sie Ihr Passwort in Ihrem Account wie Sie es wünschen.\r\n      <br />\r\n    </td>\r\n  </tr>\r\n  <tr class="lightBackground">\r\n       <td><b>Ihr neues Passwort:<br>\r\n            </b>{$NEW_PASSWORD}\r\n      </td>\r\n  </tr>\r\n  <tr>\r\n    <td>\r\n      <p>Wir wünschen Ihnen weiterhin viel Spaß mit unserem Angebot!</p>\r\n    </td>\r\n  </tr>\r\n</table>', 'Passwort geändert!\r\n\r\nSie erhalten diese Mail, weil Sie ein neues Passwort angefordert und eingerichtet haben.\r\nBitte loggen Sie sich mit folgendem Passwort und Ihrer E-mail Adresse bei uns ein und ändern Sie Ihr Passwort in Ihrem Account wie Sie es wünschen.\r\n\r\nIhr neues Passwort: {$NEW_PASSWORD}\r\n\r\nWir wünschen Ihnen weiterhin viel Spaß mit unserem Angebot!', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.lightBackground td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n	<tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            neues Passwort\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr> \r\n    <td><p><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>Passwort geändert!</b></p>\r\n      Sie erhalten diese Mail, weil Sie ein neues Passwort angefordert und eingerichtet haben.<br />\r\n      Bitte loggen Sie sich mit folgendem Passwort und Ihrer E-mail Adresse bei uns ein und ändern Sie Ihr Passwort in Ihrem Account wie Sie es wünschen.\r\n      </p><br />\r\n  </tr>\r\n  <tr class="lightBackground">\r\n       <td><b>Ihr neues Passwort:<br>\r\n            </b>{$NEW_PASSWORD}\r\n      </td>\r\n    </tr>\r\n    <tr>\r\n    	<td>\r\n    	<p>Wir wünschen Ihnen weiterhin viel Spaß mit unserem Angebot!</p>\r\n    	</td>\r\n    </tr>\r\n</table>', 'Passwort geändert!\r\n\r\nSie erhalten diese Mail, weil Sie ein neues Passwort angefordert und eingerichtet haben.\r\nBitte loggen Sie sich mit folgendem Passwort und Ihrer E-mail Adresse bei uns ein und ändern Sie Ihr Passwort in Ihrem Account wie Sie es wünschen.\r\n\r\nIhr neues Passwort: {$NEW_PASSWORD}\r\n\r\nWir wünschen Ihnen weiterhin viel Spaß mit unserem Angebot!', 12345612);
INSERT INTO emails VALUES (NULL, 'password_verification', 1, '', 'Kundenservice', '', 'Kundenservice', 'Bestätigung der Passwortänderung', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Passwort Bestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.lightBackground td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Passwort Bestätigung\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr> \r\n    <td>\r\n      <p><b>Bitte bestätigen Sie Ihre Paßwortanfrage!</b></p>\r\n      <p>Bitte bestätigen Sie, daß Sie selber ein neues Paßwort angefordert haben. <br>\r\n        Aus diesem Grund haben wir Ihnen diese E-mail mit einem persönlichen Bestätigungslink geschickt. Wenn Sie den Link bestätigen, indem Sie ihn anklicken, wird Ihnen umgehend ein neues Paßwort in einer weiteren Email zur Verfügung gestellt.\r\n      </p><br />\r\n    </td>\r\n  </tr>\r\n  <tr class="lightBackground">\r\n    <td width="1">\r\n      <nobr><b>Ihr Bestätigungslink:</b></nobr>\r\n    </td>\r\n    <td>\r\n        <a href="{$LINK}">{$LINK}</a>\r\n    </td>\r\n   </tr>\r\n</table>', 'Bitte bestätigen Sie Ihre Paßwortanfrage!\r\n\r\nBitte bestätigen Sie, daß Sie selber ein neues Paßwort angefordert haben. \r\nAus diesem Grund haben wir Ihnen diese E-mail mit einem persönlichen \r\nBestätigungslink geschickt. Wenn Sie den Link bestätigen, indem Sie ihn \r\nanklicken, wird Ihnen umgehend ein neues Paßwort in einer weiteren E-mail \r\nzur Verfügung gestellt\r\n      \r\nIhr Bestätigungslink:\r\n{$LINK}', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.lightBackground td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n	<tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Passwort vergessen\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr> \r\n    <td><p><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>Bitte bestätigen Sie Ihre Paßwortanfrage!</b></p>\r\n      <p>Bitte bestätigen Sie, daß Sie selber ein neues Paßwort angefordert haben. <br>\r\n        Aus diesem Grund haben wir Ihnen diese E-mail mit einem persönlichen Bestätigungslink geschickt. Wenn Sie den Link bestätigen, indem Sie ihn anklicken, wird Ihnen umgehend ein neues Paßwort in einer weiteren Email zur Verfügung gestellt. <br /><br />\r\n      <table width="100%"  border="0" bgcolor="f1f1f1">\r\n    <tr class="lightBackground">\r\n          <td><b>Ihr Bestätigungslink:<br>\r\n            </b><a href="{$LINK}">{$LINK}</a>\r\n      </td>\r\n    </tr>\r\n  </table>\r\n    </td>\r\n  </tr>\r\n</table>', 'Bitte bestätigen Sie Ihre Paßwortanfrage!\r\n\r\nBitte bestätigen Sie, daß Sie selber ein neues Paßwort angefordert haben. \r\nAus diesem Grund haben wir Ihnen diese E-mail mit einem persönlichen \r\nBestätigungslink geschickt. Wenn Sie den Link bestätigen, indem Sie ihn \r\nanklicken, wird Ihnen umgehend ein neues Paßwort in einer weiteren E-mail \r\nzur Verfügung gestellt\r\n      \r\nIhr Bestätigungslink:\r\n{$LINK}', 1263483589);
INSERT INTO emails VALUES (NULL, 'send_gift_to_friend', 1, '', 'Kundenservice', '', '', 'Gutschein von mail-adresse.de', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Gutschein</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td style="border-bottom: 1px solid;border-color: #cccccc;">\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Gutschein\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>\r\n      Herzlichen Glückwunsch, Sie haben einen Gutschein über <b>{$AMMOUNT} </b>erhalten ! <br /><br />\r\n      Dieser Gutschein wurde Ihnen übermittelt von {$FROM_NAME},<br />\r\n      Mit der Nachricht:<br />\r\n      <em>{$MESSAGE}</em><br /><br />\r\n      Ihr persönlicher Gutscheincode lautet <strong>{$GIFT_CODE}</strong>.<br />Sie können diese Gutschrift entweder während dem Bestellvorgang verbuchen.<br /><br />\r\n      Um den Gutschein einzulösen klichen Sie bitte auf <a href="{$GIFT_LINK}">{$GIFT_LINK}</a> <br /><br />\r\n      Falls es mit dem obigen Link Probleme beim Einlösen kommen sollte, können Sie den Betrag während des Bestellvorganges verbuchen.\r\n    </td>\r\n  </tr>\r\n</table>', '----------------------------------------------------------------------------------------\r\n  Herzlichen Glückwunsch, Sie haben einen Gutschein über {$AMMOUNT} erhalten !\r\n----------------------------------------------------------------------------------------\r\n\r\nDieser Gutschein wurde Ihnen übermittelt von {$FROM_NAME},\r\nMit der Nachricht:\r\n\r\n{$MESSAGE}\r\n\r\nIhr persönlicher Gutscheincode lautet {$GIFT_CODE}. Sie können diese Gutschrift entweder während dem Bestellvorgang verbuchen.\r\n\r\nUm den Gutschein einzulösen klichen Sie bitte auf {$GIFT_LINK}\r\n\r\nFalls es mit dem obigen Link Probleme beim Einlösen kommen sollte,\r\nkönnen Sie den Betrag während des Bestellvorganges verbuchen.', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td style="border-bottom: 1px solid;border-color: #cccccc;"><div align="right"><img src="{$logo_path}logo.gif"></div></td>\r\n  </tr>\r\n  <tr>\r\n    <td> <font size="2" face="Verdana, Arial, Helvetica, sans-serif"><br>\r\n  Herzlichen Glückwunsch, Sie haben einen Gutschein über <b>{$AMMOUNT} </b>erhalten ! <br>\r\n<br> \r\n<br>\r\nDieser Gutschein wurde Ihnen übermittelt von {$FROM_NAME},<br>\r\nMit der Nachricht:<br>\r\n<br>\r\n{$MESSAGE}<br>\r\n<br>\r\nIhr persönlicher Gutscheincode lautet <strong>{$GIFT_CODE}</strong>. Sie können diese Gutschrift entweder während dem Bestellvorgang verbuchen.<br>\r\n<br>\r\nUm den Gutschein einzulösen klichen Sie bitte auf <a href="{$GIFT_LINK}">{$GIFT_LINK}</a> <br>\r\n<br>\r\nFalls es mit dem obigen Link Probleme beim Einlösen kommen sollte, <br>\r\nkönnen Sie den Betrag während des Bestellvorganges verbuchen. </font></td>\r\n  </tr>\r\n</table>', '----------------------------------------------------------------------------------------\r\n  Herzlichen Glückwunsch, Sie haben einen Gutschein über {$AMMOUNT} erhalten !\r\n----------------------------------------------------------------------------------------\r\n\r\nDieser Gutschein wurde Ihnen übermittelt von {$FROM_NAME},\r\nMit der Nachricht:\r\n\r\n{$MESSAGE}\r\n\r\nIhr persönlicher Gutscheincode lautet {$GIFT_CODE}. Sie können diese Gutschrift entweder während dem Bestellvorgang verbuchen.\r\n\r\nUm den Gutschein einzulösen klichen Sie bitte auf {$GIFT_LINK}\r\n\r\nFalls es mit dem obigen Link Probleme beim Einlösen kommen sollte,\r\nkönnen Sie den Betrag während des Bestellvorganges verbuchen.', 1263483589);
INSERT INTO emails VALUES (NULL, 'cart_mail', 1, '', 'Kundenservice', '', '', 'Bestellung abschliessen', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Gutschein</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td style="border-bottom: 1px solid;border-color: #cccccc;">\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Gutschein\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>\r\n      {if $GENDER}\r\n        Sehr geehrte{if $GENDER eq ''m''}r Herr\r\n        {elseif $GENDER eq ''f''} Frau\r\n        {else}(r) {$FIRSTNAME}\r\n        {/if} {$LASTNAME},\r\n      {else}\r\n        Hallo,\r\n      {/if}\r\n      \r\n      <p>{if $NEW == true}vielen Dank für Ihren Besuch bei {$STORE_NAME} und Ihr uns entgegen gebrachtes Vertrauen.\r\n      {else}vielen Dank für Ihren erneuten Besuch bei {$STORE_NAME} und Ihr wiederholtes uns entgegen gebrachtes Vertrauen.{/if}</p>\r\n      \r\n      <p>Wir haben gesehen, daß Sie bei Ihrem Besuch in unserem Onlineshop den Warenkorb mit folgenden Artikeln gefüllt haben, aber den Einkauf nicht vollständig durchgeführt haben.</p>\r\n      \r\n      <p>Inhalt Ihres Warenkorbes:</p>\r\n      <table width="100%" border="0" cellpadding="5" cellspacing="0" bgcolor="f1f1f1" class="outerTable">\r\n        <tr class="ProductsTable">\r\n              <td align="left" class="bb br">\r\n                &nbsp;\r\n              </td>\r\n              <td align="center" class="bb br">\r\n                <strong>Anzahl</strong>\r\n              </td>\r\n              <td align="right" class="bb">\r\n                <strong>Artikel</strong>\r\n              </td>\r\n            </tr>\r\n        {foreach name=outer item=product from=$products_data}\r\n          <tr>\r\n              <td valign="top" class="bb br ProductsName">\r\n                <img src="{$product.IMAGE}" alt="{$product.NAME}" />\r\n              </td>\r\n              <td valign="top" class="bb br ProductsName" align="center"><strong>{$product.QUANTITY}x</strong></td>\r\n              <td valign="top" class="bb" align="right">\r\n                <strong>{$product.NAME}</strong><br />\r\n                <em><a href="{$product.LINK}">{$product.LINK}</a></em>\r\n              </td>\r\n            </tr>\r\n        {/foreach}\r\n      </table><br />\r\n      <p>Wir sind immer bemüht, unseren Service im Interesse unserer Kunden zu verbessern.\r\n      Aus diesem Grund interessiert es uns natürlich, was die Ursachen dafür waren, Ihren Einkauf dieses Mal nicht bei {$STORE_NAME} zu tätigen.\r\n      Wir sind Ihnen daher sehr dankbar, wenn Sie uns mitteilen, ob Sie bei Ihrem Besuch in unserem Onlineshop Probleme oder Bedenken hatten, den Einkauf erfolgreich abzuschließen.\r\n      Unser Ziel ist es, Ihnen und  anderen Kunden, den Einkauf bei {$STORE_NAME} leichter und besser zu gestalten.</p><br />\r\n      \r\n      Um Ihren Einkauf nun abzuschließen, melden sie sich bitte hier an: <a href="{$LOGIN}">{$LOGIN}</a><br />\r\n      \r\n      <p>Nochmals vielen Dank für Ihre Zeit und Ihre Hilfe, den Onlineshop von {$STORE_NAME} zu verbessern.</p>\r\n      \r\n      <p>Mit freundlichen Grüßen</p>\r\n      \r\n      <p>Ihr Team von <a href="{$STORE_LINK}">{$STORE_NAME}</a></p>\r\n      {if $MESSAGE}\r\n      <p>{$MESSAGE}</p>\r\n      {/if}\r\n    </td>\r\n  </tr>\r\n</table>', 'Melden sie sich hier an: {$LOGIN}\r\n------------------------------------------------------\r\n{if $GENDER}Sehr geehrte{if $GENDER eq ''m''}r Herr{elseif $GENDER eq ''f''} Frau{else}(r) {$FIRSTNAME}{/if} {$LASTNAME},\r\n{else}Hallo,{/if}\r\n\r\n{if $NEW == true}vielen Dank für Ihren Besuch bei {$STORE_NAME} und Ihr uns entgegen gebrachtes Vertrauen.\r\n{else}vielen Dank für Ihren erneuten Besuch bei {$STORE_NAME} und Ihr wiederholtes uns entgegen gebrachtes Vertrauen.{/if}\r\n\r\nWir haben gesehen, daß Sie bei Ihrem Besuch in unserem Onlineshop den Warenkorb mit folgenden Artikeln gefüllt haben, aber den Einkauf nicht vollständig durchgeführt haben.\r\n\r\nInhalt Ihres Warenkorbes:\r\n\r\n{foreach name=outer item=product from=$products_data}\r\n{$product.QUANTITY} x {$product.NAME}\r\n    {$product.LINK}\r\n{/foreach}\r\n\r\nWir sind immer bemüht, unseren Service im Interesse unserer Kunden zu verbessern.\r\nAus diesem Grund interessiert es uns natürlich, was die Ursachen dafür waren, Ihren Einkauf dieses Mal nicht bei  {$STORE_NAME} zu tätigen.\r\nWir sind Ihnen daher sehr dankbar, wenn Sie uns mitteilen, ob Sie bei Ihrem Besuch in unserem Onlineshop Probleme oder Bedenken hatten, den Einkauf erfolgreich abzuschließen.\r\nUnser Ziel ist es, Ihnen und anderen Kunden, den Einkauf bei {$STORE_NAME} leichter und besser zu gestalten.\r\n\r\nNochmals vielen Dank für Ihre Zeit und Ihre Hilfe, den Onlineshop von {$STORE_NAME} zu verbessern.\r\n\r\nMit freundlichen Grüßen\r\n\r\nIhr Team von {$STORE_NAME}\r\n{if $MESSAGE}\r\n\r\n{$MESSAGE}\r\n{/if}', '{if $GENDER}Sehr geehrte{if $GENDER eq ''m''}r Herr{elseif $GENDER eq ''f''} Frau{else}(r) {$FIRSTNAME}{/if} {$LASTNAME},\r\n{else}Hallo,{/if}\r\n\r\n<p>{if $NEW == true}vielen Dank f&uuml;r Ihren Besuch bei {$STORE_NAME} und Ihr uns entgegen gebrachtes Vertrauen.\r\n{else}vielen Dank f&uuml;r Ihren erneuten Besuch bei {$STORE_NAME} und Ihr wiederholtes uns entgegen gebrachtes Vertrauen.{/if}</p>\r\n\r\n<p>Wir haben gesehen, da&szlig; Sie bei Ihrem Besuch in unserem Onlineshop den Warenkorb mit folgenden Artikeln gef&uuml;llt haben, aber den Einkauf nicht vollst&auml;ndig durchgef&uuml;hrt haben.</p>\r\n\r\n<p>Inhalt Ihres Warenkorbes:</p>\r\n<table border="0" cellpadding="0" cellspacing="3">\r\n{foreach name=outer item=product from=$products_data}\r\n<tr>\r\n    <td rowspan="2"><img src="{$product.IMAGE}" alt="{$product.NAME}" /></td>\r\n    <td rowspan="2" valign="top">{$product.QUANTITY} x </td>\r\n    <td valign="top">{$product.NAME}<br /><a href="{$product.LINK}">{$product.LINK}</a></td>\r\n</tr>\r\n{/foreach}\r\n</table>\r\n<p>Wir sind immer bem&uuml;ht, unseren Service im Interesse unserer Kunden zu verbessern.\r\nAus diesem Grund interessiert es uns nat&uuml;rlich, was die Ursachen daf&uuml;r waren, Ihren Einkauf dieses Mal nicht bei {$STORE_NAME} zu t&auml;tigen.\r\nWir sind Ihnen daher sehr dankbar, wenn Sie uns mitteilen, ob Sie bei Ihrem Besuch in unserem Onlineshop Probleme oder Bedenken hatten, den Einkauf erfolgreich abzuschlie&szlig;en.\r\nUnser Ziel ist es, Ihnen und  anderen Kunden, den Einkauf bei {$STORE_NAME} leichter und besser zu gestalten.</p>\r\n<hr />\r\n\r\nUm Ihren Einkauf nun abzuschlie&szlig;en, melden sie sich bitte hier an: <a href="{$LOGIN}">{$LOGIN}</a><br />\r\n\r\n<p>Nochmals vielen Dank f&uuml;r Ihre Zeit und Ihre Hilfe, den Onlineshop von {$STORE_NAME} zu verbessern.</p>\r\n\r\n<p>Mit freundlichen Gr&uuml;&szlig;en</p>\r\n\r\n<p>Ihr Team von <a href="{$STORE_LINK}">{$STORE_NAME}</a></p>\r\n{if $MESSAGE}\r\n<p>{$MESSAGE}</p>\r\n{/if}', 'Melden sie sich hier an: {$LOGIN}\r\n------------------------------------------------------\r\n{if $GENDER}Sehr geehrte{if $GENDER eq ''m''}r Herr{elseif $GENDER eq ''f''} Frau{else}(r) {$FIRSTNAME}{/if} {$LASTNAME},\r\n{else}Hallo,{/if}\r\n\r\n{if $NEW == true}vielen Dank für Ihren Besuch bei {$STORE_NAME} und Ihr uns entgegen gebrachtes Vertrauen.\r\n{else}vielen Dank für Ihren erneuten Besuch bei {$STORE_NAME} und Ihr wiederholtes uns entgegen gebrachtes Vertrauen.{/if}\r\n\r\nWir haben gesehen, daß Sie bei Ihrem Besuch in unserem Onlineshop den Warenkorb mit folgenden Artikeln gefüllt haben, aber den Einkauf nicht vollständig durchgeführt haben.\r\n\r\nInhalt Ihres Warenkorbes:\r\n\r\n{foreach name=outer item=product from=$products_data}\r\n{$product.QUANTITY} x {$product.NAME}\r\n    {$product.LINK}\r\n{/foreach}\r\n\r\nWir sind immer bemüht, unseren Service im Interesse unserer Kunden zu verbessern.\r\nAus diesem Grund interessiert es uns natürlich, was die Ursachen dafür waren, Ihren Einkauf dieses Mal nicht bei  {$STORE_NAME} zu tätigen.\r\nWir sind Ihnen daher sehr dankbar, wenn Sie uns mitteilen, ob Sie bei Ihrem Besuch in unserem Onlineshop Probleme oder Bedenken hatten, den Einkauf erfolgreich abzuschließen.\r\nUnser Ziel ist es, Ihnen und anderen Kunden, den Einkauf bei {$STORE_NAME} leichter und besser zu gestalten.\r\n\r\nNochmals vielen Dank für Ihre Zeit und Ihre Hilfe, den Onlineshop von {$STORE_NAME} zu verbessern.\r\n\r\nMit freundlichen Grüßen\r\n\r\nIhr Team von {$STORE_NAME}\r\n{if $MESSAGE}\r\n\r\n{$MESSAGE}\r\n{/if}', 1263483589);
INSERT INTO emails VALUES (NULL, 'change_order', 1, '', 'Kundenservice mail-adresse.de', '', '', 'Statusänderung Ihrer Bestellung Nr: {$nr} vom {$date}', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Bestellstatusänderung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr> \r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Bestellstatusänderung\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr> \r\n    <td><strong>Sehr geehrter Kunde, </strong><br>\r\n      <br>\r\n      Der Status Ihrer Bestellung Nr:{$ORDER_NR} vom {$ORDER_DATE} wurde geändert.<br /> \r\n      {if $NOTIFY_COMMENTS}<br />\r\n         Anmerkungen und Kommentare zu Ihrer Bestellung:<br />\r\n        {$NOTIFY_COMMENTS}<br />\r\n      {/if}\r\n      <br />\r\n      Neuer Status: <b>{$ORDER_STATUS}</b><br />\r\n      Hier gelangen Sie zu der Übersicht Ihrer Bestellung:<br />\r\n      <a href="{$ORDER_LINK}">{$ORDER_LINK}</a><br /><br />\r\n      Bei Fragen zu Ihrer Bestellung antworten Sie bitte auf diese eMail.</td>\r\n  </tr>\r\n</table>', 'Sehr geehrter Kunde,\r\n\r\nDer Status Ihrer Bestellung wurde geändert.\r\n\r\n{if $NOTIFY_COMMENTS}Anmerkungen und Kommentare zu Ihrer Bestellung:{$NOTIFY_COMMENTS}{/if}\r\n\r\nNeuer Status: {$ORDER_STATUS}\r\n\r\nBei Fragen zu Ihrer Bestellung antworten Sie bitte auf diese eMail.', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr> \r\n    <td style="border-bottom: 1px solid;border-color: #cccccc;"><div align="right"><img src="{$logo_path}logo.gif" alt="" /></div></td>\r\n  </tr>\r\n  <tr> \r\n    <td><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><strong>Sehr geehrter Kunde, </strong><br>\r\n      <br>\r\n      Der Status Ihrer Bestellung Nr:{$ORDER_NR} vom {$ORDER_DATE} wurde geändert.<br> \r\n      {if $NOTIFY_COMMENTS}<br>\r\nAnmerkungen und Kommentare zu Ihrer Bestellung: \r\n{$NOTIFY_COMMENTS}\r\n<br>{/if}\r\n<br>\r\nNeuer Status: \r\n<b>{$ORDER_STATUS}</b>\r\n<br />\r\nHier gelangen Sie zu der Übersicht Ihrer Bestellung:<br />\r\n<a href="{$ORDER_LINK}">{$ORDER_LINK}</a>\r\n<br /><br />\r\nBei Fragen zu Ihrer Bestellung antworten Sie bitte auf diese eMail. </font></td>\r\n  </tr>\r\n</table>', 'Sehr geehrter Kunde,\r\n\r\nDer Status Ihrer Bestellung wurde geändert.\r\n\r\n{if $NOTIFY_COMMENTS}Anmerkungen und Kommentare zu Ihrer Bestellung:{$NOTIFY_COMMENTS}{/if}\r\n\r\nNeuer Status: {$ORDER_STATUS}\r\n\r\nBei Fragen zu Ihrer Bestellung antworten Sie bitte auf diese eMail.', 1263483589);
INSERT INTO emails VALUES (NULL, 'gift_accepted', 1, '', '', '', '', '', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td style="border-bottom: 1px solid;border-color: #cccccc;"><div align="right"><img src="{$logo_path}logo.gif"></div></td>\r\n  </tr>\r\n  <tr>\r\n    <td><strong>Sehr geehrter Kunde,</strong><br /><br />\r\n      Sie haben kürzlich in unserem Online-Shop einen Gutschein bestellt, welcher aus Sicherheitsgründen nicht sofort freigeschaltet wurde.<br />\r\n      Dieses Guthaben steht Ihnen nun zur Verfügung. Sie können Ihren Gutschein verbuchen und per E-Mail versenden Der von Ihnen bestellte Gutschein hat einen Wert von <strong>{$AMMOUNT}</strong>.\r\n      </td>\r\n  </tr>\r\n</table>', 'Sehr geehrter Kunde,\r\n\r\nSie haben kürzlich in unserem Online-Shop einen Gutschein bestellt,\r\nwelcher aus Sicherheitsgründen nicht sofort freigeschaltet wurde.\r\nDieses Guthaben steht Ihnen nun zur Verfügung.\r\nSie können Ihren Gutschein verbuchen und per E-Mail versenden Der von Ihnen bestellte Gutschein hat einen Wert von {$AMMOUNT}', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td style="border-bottom: 1px solid;border-color: #cccccc;"><div align="right"><img src="{$logo_path}logo.gif"></div></td>\r\n  </tr>\r\n  <tr>\r\n    <td><font size="1" face="Verdana, Arial, Helvetica, sans-serif">  </font><font size="2" face="Verdana, Arial, Helvetica, sans-serif">\r\n      <strong>Sehr geehrter Kunde,</strong></font> <br>\r\n      <br>\r\n      <font size="2" face="Verdana, Arial, Helvetica, sans-serif">Sie haben kürzlich in unserem Online-Shop einen Gutschein bestellt, welcher aus Sicherheitsgründen nicht sofort freigeschaltet wurde. Dieses Guthaben steht Ihnen nun zur Verfügung. Sie können Ihren Gutschein verbuchen und per E-Mail versenden Der von Ihnen bestellte Gutschein hat einen Wert von\r\n      {$AMMOUNT}\r\n      </font></td>\r\n  </tr>\r\n</table>', 'Sehr geehrter Kunde,\r\n\r\nSie haben kürzlich in unserem Online-Shop einen Gutschein bestellt,\r\nwelcher aus Sicherheitsgründen nicht sofort freigeschaltet wurde.\r\nDieses Guthaben steht Ihnen nun zur Verfügung.\r\nSie können Ihren Gutschein verbuchen und per E-Mail versenden Der von Ihnen bestellte Gutschein hat einen Wert von {$AMMOUNT}', 1263483589);
INSERT INTO emails VALUES (NULL, 'send_cupon', 1, '', '', '', '', '', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td style="border-bottom: 1px solid;border-color: #cccccc;"><div align="right"><img src="{$logo_path}logo.gif"></div></td>\r\n  </tr>\r\n  <tr>\r\n    <td><font size="1" face="Verdana, Arial, Helvetica, sans-serif"> \r\n      </font><font size="2" face="Verdana, Arial, Helvetica, sans-serif">\r\n      {$MESSAGE}\r\n      <br>\r\n      <br>\r\nSie können den Gutschein bei Ihrer Bestellung einlösen. Geben Sie dafür Ihren Gutschein-Nummer in das Feld Gutscheine ein. <br>\r\n<br>\r\nIhr Gutschein-Nummer lautet: <strong>\r\n{$COUPON_ID}\r\n</strong><br>\r\n<br>\r\nHeben Sie Ihre Gutschein-Nummer gut auf, nur so können Sie von diesem Angebot profitieren <br>\r\n<br>\r\nwenn Sie uns das nächste mal unter\r\n<a href="{$WEBSITE}">{$WEBSITE}</a>\r\nbesuchen. </font></td>\r\n  </tr>\r\n</table>', '{$MESSAGE}\r\n\r\nSie können den Gutschein bei Ihrer Bestellung einlösen. Geben Sie dafür Ihren Gutschein-Nummer in das Feld Gutscheine ein.\r\n\r\nIhr Gutschein-Nummer lautet: {$COUPON_ID}\r\n\r\nHeben Sie Ihre Gutschein-Nummer gut auf, nur so können Sie von diesem Angebot profitieren\r\nwenn Sie uns das nächste mal unter {$WEBSITE} besuchen.', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td style="border-bottom: 1px solid;border-color: #cccccc;"><div align="right"><img src="{$logo_path}logo.gif"></div></td>\r\n  </tr>\r\n  <tr>\r\n    <td><font size="1" face="Verdana, Arial, Helvetica, sans-serif"> \r\n      </font><font size="2" face="Verdana, Arial, Helvetica, sans-serif">\r\n      {$MESSAGE}\r\n      <br>\r\n      <br>\r\nSie können den Gutschein bei Ihrer Bestellung einlösen. Geben Sie dafür Ihren Gutschein-Nummer in das Feld Gutscheine ein. <br>\r\n<br>\r\nIhr Gutschein-Nummer lautet: <strong>\r\n{$COUPON_ID}\r\n</strong><br>\r\n<br>\r\nHeben Sie Ihre Gutschein-Nummer gut auf, nur so können Sie von diesem Angebot profitieren <br>\r\n<br>\r\nwenn Sie uns das nächste mal unter\r\n<a href="{$WEBSITE}">{$WEBSITE}</a>\r\nbesuchen. </font></td>\r\n  </tr>\r\n</table>', '{$MESSAGE}\r\n\r\nSie können den Gutschein bei Ihrer Bestellung einlösen. Geben Sie dafür Ihren Gutschein-Nummer in das Feld Gutscheine ein.\r\n\r\nIhr Gutschein-Nummer lautet: {$COUPON_ID}\r\n\r\nHeben Sie Ihre Gutschein-Nummer gut auf, nur so können Sie von diesem Angebot profitieren\r\nwenn Sie uns das nächste mal unter {$WEBSITE} besuchen.', 1263483589);
INSERT INTO emails VALUES (NULL, 'send_gift', 1, '', '', '', '', '', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td style="border-bottom: 1px solid;border-color: #cccccc;"><div align="right"><img src="{$logo_path}logo.gif"></div></td>\r\n  </tr>\r\n  <tr>\r\n    <td><font size="1" face="Verdana, Arial, Helvetica, sans-serif">  </font><font size="2" face="Verdana, Arial, Helvetica, sans-serif"> \r\n      </font>\r\n      <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif">\r\n        {$MESSAGE}\r\n      </font></p>\r\n      <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Gutscheinwert\r\n            {$AMMOUNT}\r\n      </font></p>\r\n      <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Um Ihren Gutschein zu verbuchen, klicken Sie auf den unten stehenden Link. Bitte notieren Sie sich zur Sicherheit Ihren persönlichen Gutschein-Code.Ihr Gutscheincode lautet:\r\n            {$GIFT_ID}\r\n      </font></p>\r\n      <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif"> <a href="{$GIFT_LINK}">\r\n        {$GIFT_LINK}\r\n      </a> </font></p>\r\n      <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Falls es wider Erwarten zu Problemen beim verbuchen kommen sollte.<br>\r\n        </font><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Besuchen Sie unsere Webseite\r\n        <a href="{$WEBSITE}">{$WEBSITE}</a>\r\n  und geben den Gutschein-Code bitte manuell ein </font></p></td>\r\n  </tr>\r\n</table>', '{$MESSAGE}\r\n  \r\nGutscheinwert {$AMMOUNT}\r\n    \r\nUm Ihren Gutschein zu verbuchen, klicken Sie auf den unten stehenden Link.\r\nBitte notieren Sie sich zur Sicherheit Ihren persönlichen Gutschein-Code.Ihr Gutscheincode lautet: {$GIFT_ID} \r\n\r\n{$GIFT_LINK}\r\n\r\nFalls es wider Erwarten zu Problemen beim verbuchen kommen sollte.        \r\nBesuchen Sie unsere Webseite {$WEBSITE} und geben den Gutschein-Code bitte manuell ein', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Bestellbestätigung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td style="border-bottom: 1px solid;border-color: #cccccc;"><div align="right"><img src="{$logo_path}logo.gif"></div></td>\r\n  </tr>\r\n  <tr>\r\n    <td><font size="1" face="Verdana, Arial, Helvetica, sans-serif">  </font><font size="2" face="Verdana, Arial, Helvetica, sans-serif"> \r\n      </font>\r\n      <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif">\r\n        {$MESSAGE}\r\n      </font></p>\r\n      <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Gutscheinwert\r\n            {$AMMOUNT}\r\n      </font></p>\r\n      <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Um Ihren Gutschein zu verbuchen, klicken Sie auf den unten stehenden Link. Bitte notieren Sie sich zur Sicherheit Ihren persönlichen Gutschein-Code.Ihr Gutscheincode lautet:\r\n            {$GIFT_ID}\r\n      </font></p>\r\n      <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif"> <a href="{$GIFT_LINK}">\r\n        {$GIFT_LINK}\r\n      </a> </font></p>\r\n      <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Falls es wider Erwarten zu Problemen beim verbuchen kommen sollte.<br>\r\n        </font><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Besuchen Sie unsere Webseite\r\n        <a href="{$WEBSITE}">{$WEBSITE}</a>\r\n  und geben den Gutschein-Code bitte manuell ein </font></p></td>\r\n  </tr>\r\n</table>', '{$MESSAGE}\r\n  \r\nGutscheinwert {$AMMOUNT}\r\n    \r\nUm Ihren Gutschein zu verbuchen, klicken Sie auf den unten stehenden Link.\r\nBitte notieren Sie sich zur Sicherheit Ihren persönlichen Gutschein-Code.Ihr Gutscheincode lautet: {$GIFT_ID} \r\n\r\n{$GIFT_LINK}\r\n\r\nFalls es wider Erwarten zu Problemen beim verbuchen kommen sollte.        \r\nBesuchen Sie unsere Webseite {$WEBSITE} und geben den Gutschein-Code bitte manuell ein', 1263483589);
INSERT INTO emails VALUES (NULL, 'create_account_admin', 1, '', 'Kundenservice', '', 'Kundenservice', 'Ihr neues Kundenkonto', '', '<!DOCTYPE html>\r\n<html dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>neues Konto erstellt</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Ihr neues Kundenkonto\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td><br />\r\n    <strong>Sehr {if $GENDER ==''f''}geehrte Frau {$NNAME}{elseif $GENDER == ''m''}geehrter Herr {$NNAME}{else} geehrter Kunde{/if},</strong><br /><br />Wir haben gerade einen Account für Sie eingerichtet, Sie können sich mit folgenden Daten in Unseren Shop einloggen. <br /><br />\r\n          {if $COMMENTS} Anmerkungen: {$COMMENTS} <br /><br />{/if}\r\n        Ihre Logindaten für unseren Shop:<br>\r\n        <table width="100%" border="0" cellpadding="10" cellspacing="5" align="center" class="outerTable ">\r\n        <tr class="lightBackground">\r\n          <td width="1"><nobr>Ihre Mailaddresse für die Shopanmeldung:</nobr></td>\r\n          <td>{$USERNAME4MAIL}</td>\r\n        </tr>\r\n        <tr class="lightBackground">\r\n          <td width="1"><nobr>Das dazugehörige Passwort:</nobr></td>\r\n          <td>{$PASSWORT4MAIL}</td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n</table>','Sehr {if $GENDER ==''f''}geehrte Frau {$NNAME}{elseif $GENDER == ''m''}geehrter Herr {$NNAME}{else} geehrter Kunde{/if},\r\n\r\nWir haben gerade einen Account für Sie eingerichtet, Sie können sich mit folgenden Daten in Unseren Shop einloggen. \r\n\r\nIhre Logindaten für unseren Shop:\r\n\r\nIhre Mailaddresse für die Shopanmeldung: {$USERNAME4MAIL}\r\n\r\nDas dazugehörige Passwort: {$PASSWORT4MAIL}\r\n\r\n{if $COMMENTS}Anmerkungen: {$COMMENTS}{/if}','<!DOCTYPE html>\r\n<html dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>neues Konto erstellt</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Ihr neues Kundenkonto\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td><br />\r\n    <strong>Sehr {if $GENDER ==''f''}geehrte Frau {$NNAME}{elseif $GENDER == ''m''}geehrter Herr {$NNAME}{else} geehrter Kunde{/if},</strong><br /><br />Wir haben gerade einen Account für Sie eingerichtet, Sie können sich mit folgenden Daten in Unseren Shop einloggen. <br /><br />\r\n          {if $COMMENTS} Anmerkungen: {$COMMENTS} <br /><br />{/if}\r\n        Ihre Logindaten für unseren Shop:<br>\r\n        <table width="100%" border="0" cellpadding="10" cellspacing="5" align="center" class="outerTable ">\r\n        <tr class="lightBackground">\r\n          <td width="1"><nobr>Ihre Mailaddresse für die Shopanmeldung:</nobr></td>\r\n          <td>{$USERNAME4MAIL}</td>\r\n        </tr>\r\n        <tr class="lightBackground">\r\n          <td width="1"><nobr>Das dazugehörige Passwort:</nobr></td>\r\n          <td>{$PASSWORT4MAIL}</td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n</table>','Sehr {if $GENDER ==''f''}geehrte Frau {$NNAME}{elseif $GENDER == ''m''}geehrter Herr {$NNAME}{else} geehrter Kunde{/if},\r\n\r\nWir haben gerade einen Account für Sie eingerichtet, Sie können sich mit folgenden Daten in Unseren Shop einloggen. \r\n\r\nIhre Logindaten für unseren Shop:\r\n\r\nIhre Mailaddresse für die Shopanmeldung: {$USERNAME4MAIL}\r\n\r\nDas dazugehörige Passwort: {$PASSWORT4MAIL}\r\n\r\n{if $COMMENTS}Anmerkungen: {$COMMENTS}{/if}', 12345612);
INSERT INTO emails VALUES (NULL, 'send_mail_from_admin', 1, '', '', '', '', 'wird vom System gefüllt', '', '<!DOCTYPE html>\r\n<html dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Email</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Email\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>Hallo {if $GENDER==''f''}Frau{else}Herr{/if} {$NNAME},<br /><br />\r\n    {$CONTENT}\r\n    </td>\r\n  </tr>\r\n</table>', 'Hallo {if $GENDER==''f''}Frau{else}Herr{/if} {$NNAME},\r\n\r\n{$CONTENT}', '<!DOCTYPE html>\r\n<html dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Email</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Email\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>Hallo {if $GENDER==''f''}Frau{else}Herr{/if} {$NNAME},<br /><br />\r\n    {$CONTENT}\r\n    </td>\r\n  </tr>\r\n</table>', 'Hallo {if $GENDER==''f''}Frau{else}Herr{/if} {$NNAME},\r\n\r\n{$CONTENT}', 1297445522);
INSERT INTO emails VALUES (NULL, 'recover_cart_sales', 1, '', '', '', '', 'Ihr Besuch auf unserem Shop', '', '<!DOCTYPE html>\r\n<html dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Email</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Offener Warenkorb\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>{if $GENDER}Sehr geehrte{if $GENDER eq ''m''}r Herr{elseif $GENDER eq ''f''} Frau{else}(r) {$FIRSTNAME}{/if} {$LASTNAME},\r\n{else}Hallo,{/if}\r\n      <p>{if $NEW == true}vielen Dank f&uuml;r Ihren Besuch bei {$STORE_NAME} und Ihr uns entgegen gebrachtes Vertrauen.\r\n        {else}vielen Dank f&uuml;r Ihren erneuten Besuch bei {$STORE_NAME} und Ihr wiederholtes uns entgegen gebrachtes Vertrauen.{/if}</p>\r\n      <p>Wir haben gesehen, da&szlig; Sie bei Ihrem Besuch in unserem Onlineshop den Warenkorb mit folgenden Artikeln gef&uuml;llt haben, aber den Einkauf nicht vollst&auml;ndig durchgef&uuml;hrt haben.</p>\r\n    <p>Inhalt Ihres Warenkorbes:</p>\r\n    <table width="100%" border="0" cellpadding="0" cellspacing="3">\r\n      {foreach name=outer item=product from=$products_data}\r\n      <tr>\r\n      <td width="150"><img src="{$product.IMAGE}" alt="{$product.NAME}" /></td>\r\n        <td width="10" valign="top">{$product.QUANTITY} x </td>\r\n        <td valign="top">{$product.NAME}<br />\r\n          <a href="{$product.LINK}">{$product.LINK}</a></td>\r\n      </tr>\r\n      {/foreach}\r\n    </table>\r\n    <p>Wir sind immer bem&uuml;ht, unseren Service im Interesse unserer Kunden zu verbessern.\r\n      Aus diesem Grund interessiert es uns nat&uuml;rlich, was die Ursachen daf&uuml;r waren, Ihren Einkauf dieses Mal nicht bei {$STORE_NAME} zu t&auml;tigen.\r\n      Wir sind Ihnen daher sehr dankbar, wenn Sie uns mitteilen, ob Sie bei Ihrem Besuch in unserem Onlineshop Probleme oder Bedenken hatten, den Einkauf erfolgreich abzuschlie&szlig;en.\r\n      Unser Ziel ist es, Ihnen und  anderen Kunden, den Einkauf bei {$STORE_NAME} leichter und besser zu gestalten.</p>\r\n    Um Ihren Einkauf nun abzuschlie&szlig;en, melden sie sich bitte hier an: <a href="{$LOGIN}">{$LOGIN}</a><br />\r\n    <p>Nochmals vielen Dank f&uuml;r Ihre Zeit und Ihre Hilfe, den Onlineshop von {$STORE_NAME} zu verbessern.</p>\r\n    <p>Mit freundlichen Gr&uuml;&szlig;en</p>\r\n    <p>Ihr Team von <a href="{$STORE_LINK}">{$STORE_NAME}</a></p>\r\n    {if $MESSAGE}\r\n    <p>{$MESSAGE}</p>\r\n    {/if}\r\n    <p>&nbsp;</p></td>\r\n  </tr>\r\n</table>', 'Melden sie sich hier an: {$LOGIN}\r\n------------------------------------------------------\r\n{if $GENDER}Sehr geehrte{if $GENDER eq ''m''}r Herr{elseif $GENDER eq ''f''} Frau{else}(r) {$FIRSTNAME}{/if} {$LASTNAME},\r\n{else}Hallo,{/if}\r\n\r\n{if $NEW == true}vielen Dank für Ihren Besuch bei {$STORE_NAME} und Ihr uns entgegen gebrachtes Vertrauen.\r\n{else}vielen Dank für Ihren erneuten Besuch bei {$STORE_NAME} und Ihr wiederholtes uns entgegen gebrachtes Vertrauen.{/if}\r\n\r\nWir haben gesehen, daß Sie bei Ihrem Besuch in unserem Onlineshop den Warenkorb mit folgenden Artikeln gefüllt haben, aber den Einkauf nicht vollständig durchgeführt haben.\r\n\r\nInhalt Ihres Warenkorbes:\r\n\r\n{foreach name=outer item=product from=$products_data}\r\n{$product.QUANTITY} x {$product.NAME}\r\n    {$product.LINK}\r\n{/foreach}\r\n\r\nWir sind immer bemüht, unseren Service im Interesse unserer Kunden zu verbessern.\r\nAus diesem Grund interessiert es uns natürlich, was die Ursachen dafür waren, Ihren Einkauf dieses Mal nicht bei  {$STORE_NAME} zu tätigen.\r\nWir sind Ihnen daher sehr dankbar, wenn Sie uns mitteilen, ob Sie bei Ihrem Besuch in unserem Onlineshop Probleme oder Bedenken hatten, den Einkauf erfolgreich abzuschließen.\r\nUnser Ziel ist es, Ihnen und anderen Kunden, den Einkauf bei {$STORE_NAME} leichter und besser zu gestalten.\r\n\r\nNochmals vielen Dank für Ihre Zeit und Ihre Hilfe, den Onlineshop von {$STORE_NAME} zu verbessern.\r\n\r\nMit freundlichen Grüßen\r\n\r\nIhr Team von {$STORE_NAME}\r\n{if $MESSAGE}\r\n\r\n{$MESSAGE}\r\n{/if}', '<!DOCTYPE html>\r\n<html dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\r\n<title>Email</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.ProductsTable td {color:#6d88b1;background: #f1f1f1}\r\n.ProductsAttributes td, .ProductsName {background: #ffffff}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Offener Warenkorb\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td>{if $GENDER}Sehr geehrte{if $GENDER eq ''m''}r Herr{elseif $GENDER eq ''f''} Frau{else}(r) {$FIRSTNAME}{/if} {$LASTNAME},\r\n{else}Hallo,{/if}\r\n      <p>{if $NEW == true}vielen Dank f&uuml;r Ihren Besuch bei {$STORE_NAME} und Ihr uns entgegen gebrachtes Vertrauen.\r\n        {else}vielen Dank f&uuml;r Ihren erneuten Besuch bei {$STORE_NAME} und Ihr wiederholtes uns entgegen gebrachtes Vertrauen.{/if}</p>\r\n      <p>Wir haben gesehen, da&szlig; Sie bei Ihrem Besuch in unserem Onlineshop den Warenkorb mit folgenden Artikeln gef&uuml;llt haben, aber den Einkauf nicht vollst&auml;ndig durchgef&uuml;hrt haben.</p>\r\n    <p>Inhalt Ihres Warenkorbes:</p>\r\n    <table width="100%" border="0" cellpadding="0" cellspacing="3">\r\n      {foreach name=outer item=product from=$products_data}\r\n      <tr>\r\n      <td width="150"><img src="{$product.IMAGE}" alt="{$product.NAME}" /></td>\r\n        <td width="10" valign="top">{$product.QUANTITY} x </td>\r\n        <td valign="top">{$product.NAME}<br />\r\n          <a href="{$product.LINK}">{$product.LINK}</a></td>\r\n      </tr>\r\n      {/foreach}\r\n    </table>\r\n    <p>Wir sind immer bem&uuml;ht, unseren Service im Interesse unserer Kunden zu verbessern.\r\n      Aus diesem Grund interessiert es uns nat&uuml;rlich, was die Ursachen daf&uuml;r waren, Ihren Einkauf dieses Mal nicht bei {$STORE_NAME} zu t&auml;tigen.\r\n      Wir sind Ihnen daher sehr dankbar, wenn Sie uns mitteilen, ob Sie bei Ihrem Besuch in unserem Onlineshop Probleme oder Bedenken hatten, den Einkauf erfolgreich abzuschlie&szlig;en.\r\n      Unser Ziel ist es, Ihnen und  anderen Kunden, den Einkauf bei {$STORE_NAME} leichter und besser zu gestalten.</p>\r\n    Um Ihren Einkauf nun abzuschlie&szlig;en, melden sie sich bitte hier an: <a href="{$LOGIN}">{$LOGIN}</a><br />\r\n    <p>Nochmals vielen Dank f&uuml;r Ihre Zeit und Ihre Hilfe, den Onlineshop von {$STORE_NAME} zu verbessern.</p>\r\n    <p>Mit freundlichen Gr&uuml;&szlig;en</p>\r\n    <p>Ihr Team von <a href="{$STORE_LINK}">{$STORE_NAME}</a></p>\r\n    {if $MESSAGE}\r\n    <p>{$MESSAGE}</p>\r\n    {/if}\r\n    <p>&nbsp;</p></td>\r\n  </tr>\r\n</table>', 'Melden sie sich hier an: {$LOGIN}\r\n------------------------------------------------------\r\n{if $GENDER}Sehr geehrte{if $GENDER eq ''m''}r Herr{elseif $GENDER eq ''f''} Frau{else}(r) {$FIRSTNAME}{/if} {$LASTNAME},\r\n{else}Hallo,{/if}\r\n\r\n{if $NEW == true}vielen Dank für Ihren Besuch bei {$STORE_NAME} und Ihr uns entgegen gebrachtes Vertrauen.\r\n{else}vielen Dank für Ihren erneuten Besuch bei {$STORE_NAME} und Ihr wiederholtes uns entgegen gebrachtes Vertrauen.{/if}\r\n\r\nWir haben gesehen, daß Sie bei Ihrem Besuch in unserem Onlineshop den Warenkorb mit folgenden Artikeln gefüllt haben, aber den Einkauf nicht vollständig durchgeführt haben.\r\n\r\nInhalt Ihres Warenkorbes:\r\n\r\n{foreach name=outer item=product from=$products_data}\r\n{$product.QUANTITY} x {$product.NAME}\r\n    {$product.LINK}\r\n{/foreach}\r\n\r\nWir sind immer bemüht, unseren Service im Interesse unserer Kunden zu verbessern.\r\nAus diesem Grund interessiert es uns natürlich, was die Ursachen dafür waren, Ihren Einkauf dieses Mal nicht bei  {$STORE_NAME} zu tätigen.\r\nWir sind Ihnen daher sehr dankbar, wenn Sie uns mitteilen, ob Sie bei Ihrem Besuch in unserem Onlineshop Probleme oder Bedenken hatten, den Einkauf erfolgreich abzuschließen.\r\nUnser Ziel ist es, Ihnen und anderen Kunden, den Einkauf bei {$STORE_NAME} leichter und besser zu gestalten.\r\n\r\nNochmals vielen Dank für Ihre Zeit und Ihre Hilfe, den Onlineshop von {$STORE_NAME} zu verbessern.\r\n\r\nMit freundlichen Grüßen\r\n\r\nIhr Team von {$STORE_NAME}\r\n{if $MESSAGE}\r\n\r\n{$MESSAGE}\r\n{/if}', 1297445522);
INSERT INTO emails VALUES (NULL, 'askaquestion', 1, '', '', '', '', 'Frage zum Produkt', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />\r\n<title>Kontoeröffnung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.lightBackground td {color:#6d88b1;background: #f1f1f1}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Frage zum Produkt\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td><br />\r\n      <table width="100%" border="0" cellpadding="10" cellspacing="5" align="center" class="outerTable ">\r\n        <tr class="lightBackground">\r\n          <td width="1"><nobr>Produktname:</nobr></td>\r\n          <td> {$PRODUCT_NAME}</td>\r\n        </tr>\r\n        <tr class="lightBackground">\r\n          <td width="1"><nobr> von:</nobr></td>\r\n          <td> {$FROM_EMAIL_ADDRESS}</td>\r\n        </tr>\r\n        <tr class="lightBackground">\r\n          <td> Name:</td>\r\n          <td> {$TEXT_NAME}</td>\r\n        </tr>\r\n        <tr class="lightBackground">\r\n          <td>Produkt:</td>\r\n          <td><a href="{$PRODUCT_LINK}">{$PRODUCT_LINK}</a></td>\r\n        </tr>\r\n        <tr class="lightBackground">\r\n          <td> Nachricht:</td>\r\n          <td> {$MESSAGE}</td>\r\n        </tr>\r\n      </table>\r\n      <br /><br />\r\n    </td>\r\n  </tr>\r\n</table>', 'Frage zu Artikel:\r\n\r\n{$PRODUCT_NAME}\r\n\r\nvon: {$FROM_EMAIL_ADDRESS}\r\nName: {$TEXT_NAME}\r\nProdukt: {$PRODUCT_LINK}\r\n\r\nNachricht:\r\n{$MESSAGE}\r\n', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r\n<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="de" lang="de">\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />\r\n<title>Kontoeröffnung</title>\r\n{literal}\r\n<style type="text/css">\r\nbody, table {font-size:11.5px; font-family:Helvetica, sans-serif;color:#444}\r\ntable.outerTable {border: 1px solid #ccc}\r\ntd.TopRightDesc {letter-spacing: 1px; font-weight: 600}\r\n.lightBackground td {color:#6d88b1;background: #f1f1f1}\r\n.bt {border-top:1px solid #ccc}\r\n.bb {border-bottom:1px solid #ccc}\r\n.bl {border-left:1px solid #ccc}\r\n.br {border-right:1px solid #ccc}\r\n.fs85 {font-size:85%}\r\n</style>\r\n{/literal}\r\n</head>\r\n<body>\r\n<table width="90%" border="0" cellpadding="10" cellspacing="0" align="center" class="outerTable">\r\n  <tr>\r\n    <td>\r\n      <table width="100%" border="0" cellpadding="0" cellspacing="0">\r\n        <tr>\r\n          <td width="50%">\r\n            <img src="{$logo_path}logo.gif" alt="" />\r\n          </td>\r\n          <td width="50%" class="TopRightDesc" align="right">\r\n            Frage zum Produkt\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td><br />\r\n      <table width="100%" border="0" cellpadding="10" cellspacing="5" align="center" class="outerTable ">\r\n        <tr class="lightBackground">\r\n          <td width="1"><nobr>Produktname:</nobr></td>\r\n          <td> {$PRODUCT_NAME}</td>\r\n        </tr>\r\n        <tr class="lightBackground">\r\n          <td width="1"><nobr> von:</nobr></td>\r\n          <td> {$FROM_EMAIL_ADDRESS}</td>\r\n        </tr>\r\n        <tr class="lightBackground">\r\n          <td> Name:</td>\r\n          <td> {$TEXT_NAME}</td>\r\n        </tr>\r\n        <tr class="lightBackground">\r\n          <td>Produkt:</td>\r\n          <td><a href="{$PRODUCT_LINK}">{$PRODUCT_LINK}</a></td>\r\n        </tr>\r\n        <tr class="lightBackground">\r\n          <td> Nachricht:</td>\r\n          <td> {$MESSAGE}</td>\r\n        </tr>\r\n      </table>\r\n      <br /><br />\r\n    </td>\r\n  </tr>\r\n</table>', 'Frage zu Artikel:\r\n\r\n{$PRODUCT_NAME}\r\n\r\nvon: {$FROM_EMAIL_ADDRESS}\r\nName: {$TEXT_NAME}\r\nProdukt: {$PRODUCT_LINK}\r\n\r\nNachricht:\r\n{$MESSAGE}\r\n', 12345612);


# configuration_group_id 1
INSERT INTO configuration VALUES 
(NULL, 'STORE_NAME', 'Commerce:SEO',  1, 1, NULL, NOW(), NULL, NULL),
(NULL, 'STORE_OWNER', 'Commerce:SEO', 1, 2, NULL, NOW(), NULL, NULL),
(NULL, 'STORE_OWNER_EMAIL_ADDRESS', 'email@ihr-shop.de', 1, 3, NULL, NOW(), NULL, NULL),
(NULL, 'EMAIL_FROM', 'Commerce:SEO email@ihr-shop.de',  1, 4, NULL, NOW(), NULL, NULL),
(NULL, 'STORE_COUNTRY', '81',  1, 6, NULL, NOW(), 'xtc_get_country_name', 'xtc_cfg_pull_down_country_list('),
(NULL, 'STORE_ZONE', '', 1, 7, NULL, NOW(), 'xtc_cfg_get_zone_name', 'xtc_cfg_pull_down_zone_list('),
(NULL, 'EXPECTED_PRODUCTS_SORT', 'desc',  1, 8, NULL, NOW(), NULL, 'xtc_cfg_select_option(array(\'asc\', \'desc\'),'),
(NULL, 'EXPECTED_PRODUCTS_FIELD', 'date_expected',  1, 9, NULL, NOW(), NULL, 'xtc_cfg_select_option(array(\'products_name\', \'date_expected\'),'),
(NULL, 'USE_DEFAULT_LANGUAGE_CURRENCY', 'false', 1, 10, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'DISPLAY_CART', 'true',  1, 13, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ADVANCED_SEARCH_DEFAULT_OPERATOR', 'and', 1, 15, NULL, NOW(), NULL, 'xtc_cfg_select_option(array(\'and\', \'or\'),'),
(NULL, 'STORE_NAME_ADDRESS', 'Shop Name\nAdresse\nLand\nTelefon\nFax',  1, 16, NULL, NOW(), NULL, 'xtc_cfg_textarea('),
(NULL, 'SHOW_COUNTS', 'false',  1, 17, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'DEFAULT_CUSTOMERS_STATUS_ID_ADMIN', '0',  1, 20, NULL, NOW(), 'xtc_get_customers_status_name', 'xtc_cfg_pull_down_customers_status_list('),
(NULL, 'DEFAULT_CUSTOMERS_STATUS_ID_GUEST', '1',  1, 21, NULL, NOW(), 'xtc_get_customers_status_name', 'xtc_cfg_pull_down_customers_status_list('),
(NULL, 'DEFAULT_CUSTOMERS_STATUS_ID', '2',  1, 23, NULL, NOW(), 'xtc_get_customers_status_name', 'xtc_cfg_pull_down_customers_status_list('),
(NULL, 'ALLOW_ADD_TO_CART', 'true',  1, 24, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'CURRENT_TEMPLATE', 'cseo-css-v2', 1, 26, NULL, NOW(), NULL, 'xtc_cfg_pull_down_template_sets('),
(NULL, 'CURRENT_MOBILE_TEMPLATE', 'cseo-css-v2-m', 1, 27, NULL, NOW(), NULL, 'xtc_cfg_pull_down_mobile_template_sets('),
(NULL, 'PRICE_IS_BRUTTO', 'true', 1, 28, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRICE_PRECISION', '4', 1, 29, NULL, NOW(), NULL, ''),
(NULL, 'TAX_DECIMAL_PLACES', '2', 1, 31, NULL, NOW(), NULL, NULL);

# configuration_group_id 2
INSERT INTO configuration VALUES 
(NULL, 'ENTRY_FIRST_NAME_MIN_LENGTH', '2',  2, 1, NULL, NOW(), NULL, NULL),
(NULL, 'ENTRY_LAST_NAME_MIN_LENGTH', '2',  2, 2, NULL, NOW(), NULL, NULL),
(NULL, 'ENTRY_DOB_MIN_LENGTH', '10',  2, 3, NULL, NOW(), NULL, NULL),
(NULL, 'ENTRY_EMAIL_ADDRESS_MIN_LENGTH', '6',  2, 4, NULL, NOW(), NULL, NULL),
(NULL, 'ENTRY_STREET_ADDRESS_MIN_LENGTH', '5',  2, 5, NULL, NOW(), NULL, NULL),
(NULL, 'ENTRY_COMPANY_MIN_LENGTH', '2',  2, 6, NULL, NOW(), NULL, NULL),
(NULL, 'ENTRY_POSTCODE_MIN_LENGTH', '4',  2, 7, NULL, NOW(), NULL, NULL),
(NULL, 'ENTRY_CITY_MIN_LENGTH', '3',  2, 8, NULL, NOW(), NULL, NULL),
(NULL, 'ENTRY_STATE_MIN_LENGTH', '2', 2, 9, NULL, NOW(), NULL, NULL),
(NULL, 'ENTRY_TELEPHONE_MIN_LENGTH', '3',  2, 10, NULL, NOW(), NULL, NULL),
(NULL, 'ENTRY_PASSWORD_MIN_LENGTH', '5',  2, 11, NULL, NOW(), NULL, NULL),
(NULL, 'CC_OWNER_MIN_LENGTH', '3',  2, 12, NULL, NOW(), NULL, NULL),
(NULL, 'CC_NUMBER_MIN_LENGTH', '10',  2, 13, NULL, NOW(), NULL, NULL),
(NULL, 'REVIEW_TEXT_MIN_LENGTH', '50',  2, 14, NULL, NOW(), NULL, NULL),
(NULL, 'MIN_DISPLAY_BESTSELLERS', '1',  2, 15, NULL, NOW(), NULL, NULL),
(NULL, 'MIN_DISPLAY_ALSO_PURCHASED', '1', 2, 16, NULL, NOW(), NULL, NULL);

# configuration_group_id 3
INSERT INTO configuration VALUES 
(NULL, 'MAX_ADDRESS_BOOK_ENTRIES', '5',  3, 1, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_SEARCH_RESULTS', '20',  3, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_PAGE_LINKS', '5',  3, 3, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_SPECIAL_PRODUCTS', '9', 3, 4, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_NEW_PRODUCTS', '9',  3, 5, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_UPCOMING_PRODUCTS', '10',  3, 6, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_MANUFACTURERS_IN_A_LIST', '0', 3, 7, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_MANUFACTURERS_LIST', '1',  3, 7, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_MANUFACTURER_NAME_LEN', '15',  3, 8, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_NEW_REVIEWS', '6', 3, 9, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_RANDOM_SELECT_REVIEWS', '10',  3, 10, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_RANDOM_SELECT_NEW', '10',  3, 11, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_RANDOM_SELECT_SPECIALS', '10',  3, 12, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_CATEGORIES_PER_ROW', '3',  3, 13, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_PRODUCTS_NEW', '10',  3, 14, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_BESTSELLERS', '10',  3, 15, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_ALSO_PURCHASED', '6',  3, 16, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX', '6',  3, 17, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_ORDER_HISTORY', '10',  3, 18, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_REVIEWS_VIEW', '5',  3, 19, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_PRODUCTS_QTY', '1000', 3, 21, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_NEW_PRODUCTS_DAYS', '30', 3, 22, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_CART_SPECIALS', '3', 3, 23, NULL, NOW(), NULL, NULL);

# configuration_group_id 4
INSERT INTO configuration VALUES 
(NULL, 'CONFIG_CALCULATE_IMAGE_SIZE', 'true', 4, 1, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'IMAGE_QUALITY', '80', 4, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MO_PICS', '3', '4', 3, 3, NOW(), NULL , NULL),
(NULL, 'IMAGE_MANIPULATOR', 'image_manipulator_GD2.php', 4, 4, NULL, NOW(), NULL , 'xtc_cfg_select_option(array(\'image_manipulator_GD2.php\', \'image_manipulator_GD1.php\'),'),

(NULL, 'PRODUCT_IMAGE_MINI_WIDTH', '45', 4, 5, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_MINI_HEIGHT', '45', 4, 6, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_THUMBNAIL_WIDTH', '120', 4, 7, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_THUMBNAIL_HEIGHT', '80', 4, 8, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_INFO_WIDTH', '200', 4, 9, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_INFO_HEIGHT', '160', 4, 10, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_POPUP_WIDTH', '850', 4, 11, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_POPUP_HEIGHT', '800', 4, 12, NULL, NOW(), NULL, NULL),
(NULL, 'CATEGORY_IMAGE_WIDTH', '160', 4, 13, NULL, NOW(), NULL, ''),
(NULL, 'CATEGORY_IMAGE_HEIGHT', '160', 4, 14, NULL, NOW(), NULL, ''),

(NULL, 'PRODUCT_IMAGE_MINI_BEVEL', '', 4, 15, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_MINI_GREYSCALE', '', 4, 16, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_MINI_ELLIPSE', '', 4, 17, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_MINI_ROUND_EDGES', '', 4, 18, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_MINI_MERGE', '', 4, 19, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_MINI_FRAME', '', 4, 20, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_MINI_DROP_SHADDOW', '', 4, 21, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_MINI_MOTION_BLUR', '', 4, 22, NULL, NOW(), NULL, NULL),

(NULL, 'PRODUCT_IMAGE_THUMBNAIL_BEVEL', '', 4, 23, NULL, NOW(), '', ''),
(NULL, 'PRODUCT_IMAGE_THUMBNAIL_GREYSCALE', '', 4, 24, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_THUMBNAIL_ELLIPSE', '', 4, 25, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_THUMBNAIL_ROUND_EDGES', '', 4, 26, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_THUMBNAIL_MERGE', '', 4, 27, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_THUMBNAIL_FRAME', '', 4, 28, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_THUMBNAIL_DROP_SHADDOW', '', 4, 29, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_THUMBNAIL_MOTION_BLUR', '', 4, 30, NULL, NOW(), NULL, NULL),

(NULL, 'PRODUCT_IMAGE_INFO_BEVEL', '', 4, 31, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_INFO_GREYSCALE', '', 4, 32, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_INFO_ELLIPSE', '', 4, 33, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_INFO_ROUND_EDGES', '', 4, 34, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_INFO_MERGE', '', 4, 35, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_INFO_FRAME', '', 4, 36, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_INFO_DROP_SHADDOW', '', 4, 37, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_INFO_MOTION_BLUR', '', 4, 38, NULL, NOW(), NULL, NULL),

(NULL, 'PRODUCT_IMAGE_POPUP_BEVEL', '', 4, 39, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_POPUP_GREYSCALE', '', 4, 40, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_POPUP_ELLIPSE', '', 4, 41, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_POPUP_ROUND_EDGES', '', 4, 42, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_POPUP_MERGE', '', 4, 43, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_POPUP_FRAME', '', 4, 44, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_POPUP_DROP_SHADDOW', '', 4, 45, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_IMAGE_POPUP_MOTION_BLUR', '', 4, 46, NULL, NOW(), NULL, NULL),

(NULL, 'CATEGORY_IMAGE_BEVEL', '', 4, 47, NULL, NOW(), NULL, ''),
(NULL, 'CATEGORY_IMAGE_GREYSCALE', '', 4, 48, NULL, NOW(), NULL, ''),
(NULL, 'CATEGORY_IMAGE_ELLIPSE', '', 4, 49, NULL, NOW(), NULL, ''),
(NULL, 'CATEGORY_IMAGE_ROUND_EDGES', '', 4, 50, NULL, NOW(), NULL, ''),
(NULL, 'CATEGORY_IMAGE_MERGE', '', 4, 51, NULL, NOW(), NULL, ''),
(NULL, 'CATEGORY_IMAGE_FRAME', '', 4, 52, NULL, NOW(), NULL, ''),
(NULL, 'CATEGORY_IMAGE_DROP_SHADDOW', '', 4, 53, NULL, NOW(), NULL, ''),
(NULL, 'CATEGORY_IMAGE_MOTION_BLUR', '', 4, 54, NULL, NOW(), NULL, '');

# configuration_group_id 5
INSERT INTO configuration VALUES (NULL, 'ACCOUNT_GENDER', 'true',  5, 1, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ACCOUNT_DOB', 'true',  5, 2, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ACCOUNT_COMPANY', 'true',  5, 3, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ACCOUNT_SUBURB', 'true', 5, 4, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ACCOUNT_STATE', 'true',  5, 5, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ACCOUNT_OPTIONS', 'account',  5, 6, NULL, '', NULL, 'xtc_cfg_select_option(array(\'account\', \'guest\', \'both\'),'),
(NULL, 'DELETE_GUEST_ACCOUNT', 'true',  5, 7, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), ");

# configuration_group_id 6
INSERT INTO configuration VALUES (NULL, 'MODULE_PAYMENT_INSTALLED', '', 6, 0, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_ORDER_TOTAL_INSTALLED', 'ot_subtotal.php;ot_shipping.php;ot_tax.php;ot_total.php', 6, 0, '2003-07-18 03:31:55', '', NULL, NULL),
(NULL, 'MODULE_SHIPPING_INSTALLED', '',  6, 0, NULL, NOW(), NULL, NULL),
(NULL, 'DEFAULT_CURRENCY', 'EUR',  6, 0, NULL, NOW(), NULL, NULL),
(NULL, 'DEFAULT_LANGUAGE', 'de',  6, 0, NULL, NOW(), NULL, NULL),
(NULL, 'DEFAULT_ORDERS_STATUS_ID', '1',  6, 0, NULL, NOW(), NULL, NULL),
(NULL, 'DEFAULT_PRODUCTS_VPE_ID', '',  6, 0, NULL, NOW(), NULL, NULL),
(NULL, 'DEFAULT_SHIPPING_STATUS_ID', '1',  6, 0, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'true',  6, 1, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '30',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'false', 6, 3, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', '50',  6, 4, NULL, '', 'currencies->format', NULL),
(NULL, 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'national', 6, 5, NULL, '', NULL, 'xtc_cfg_select_option(array(\'national\', \'international\', \'both\'),'),
(NULL, 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'true',  6, 1, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '10',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_ORDER_TOTAL_TAX_STATUS', 'true',  6, 1, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'MODULE_ORDER_TOTAL_TAX_SORT_ORDER', '50',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_ORDER_TOTAL_TOTAL_STATUS', 'true',  6, 1, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '99',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_ORDER_TOTAL_DISCOUNT_STATUS', 'true',  6, 1, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'MODULE_ORDER_TOTAL_DISCOUNT_SORT_ORDER', '20', 6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_ORDER_TOTAL_TOTAL_NETTO_STATUS', 'true', 6, 1,NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'MODULE_ORDER_TOTAL_TOTAL_NETTO_SORT_ORDER', '45', 6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_STATUS', 'true',  6, 1, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_SORT_ORDER','40',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_ACCESSORIES_STATUS','true',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_ACCESSORIES_SORT_ORDER','1',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_ACCESSORIES','true',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_FP2_UPDATE_STATUS','true',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_FP2_UPDATE_SORT_ORDER','2126',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_QF7_UPDATE_STATUS','true',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_QF7_UPDATE_SORT_ORDER','2127',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_ATTRIBUT_MANAGER','true',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_MULTICAT_STATUS','true',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_MULTICAT_SORT_ORDER','1',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_MULTICAT','true',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_GLOBAL_PRODUCTS_PRICE_STATUS','true',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_GLOBAL_PRODUCTS_PRICE_SORT_ORDER','1',  6, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MODULE_CSEO_GLOBAL_PRODUCTS_PRICE','true',  6, 2, NULL, NOW(), NULL, NULL);

# configuration_group_id 7
INSERT INTO configuration VALUES (NULL, 'SHIPPING_ORIGIN_COUNTRY', '81',  7, 1, NULL, '', 'xtc_get_country_name', 'xtc_cfg_pull_down_country_list('),
(NULL, 'SHIPPING_ORIGIN_ZIP', '',  7, 2, NULL, NOW(), NULL, NULL),
(NULL, 'SHIPPING_MAX_WEIGHT', '50',  7, 3, NULL, NOW(), NULL, NULL),
(NULL, 'SHIPPING_BOX_WEIGHT', '3',  7, 4, NULL, NOW(), NULL, NULL),
(NULL, 'SHIPPING_BOX_PADDING', '10',  7, 5, NULL, NOW(), NULL, NULL),
(NULL, 'SHOW_SHIPPING', 'true',  7, 6, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'SHIPPING_INFOS', '1',  7, 5, NULL, NOW(), NULL, NULL);

# configuration_group_id 8
INSERT INTO configuration VALUES (NULL, 'PRODUCT_LIST_FILTER', '1', 8, 1, NULL, NOW(), NULL, NULL);
INSERT INTO configuration VALUES (NULL, 'MAX_ROW_LISTS_OPTIONS', '10', 8, 1, NULL, NOW(), NULL, NULL);

# configuration_group_id 9
INSERT INTO configuration VALUES 
(NULL, 'STOCK_CHECK', 'true',  9, 1, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ATTRIBUTE_STOCK_CHECK', 'true',  9, 2, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'STOCK_LIMITED', 'true', 9, 3, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'STOCK_ALLOW_CHECKOUT', 'true',  9, 4, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'STOCK_ALLOW_CHECKOUT_DEACTIVATE', 'false',  9, 4, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'STOCK_MARK_PRODUCT_OUT_OF_STOCK', '***',  9, 5, NULL, NOW(), NULL, NULL),
(NULL, 'STOCK_REORDER_LEVEL', '5',  9, 6, NULL, NOW(), NULL, NULL),
(NULL, 'STOCK_WARNING_GREEN', '5',  9, 7, NULL, NOW(), NULL, NULL),
(NULL, 'STOCK_WARNING_YELLOW', '3',  9, 8, NULL, NOW(), NULL, NULL),
(NULL, 'STOCK_WARNING_RED', '1',  9, 9, NULL, NOW(), NULL, NULL);

# configuration_group_id 10
INSERT INTO configuration VALUES 
(NULL, 'STORE_PAGE_PARSE_TIME', 'false',  10, 1, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'STORE_PAGE_PARSE_TIME_LOG', '/var/log/www/tep/page_parse_time.log',  10, 2, NULL, NOW(), NULL, NULL),
(NULL, 'STORE_PARSE_DATE_TIME_FORMAT', '%d/%m/%Y %H:%M:%S', 10, 3, NULL, NOW(), NULL, NULL),
(NULL, 'DISPLAY_PAGE_PARSE_TIME', 'false',  10, 4, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'STORE_DB_TRANSACTIONS', 'false',  10, 5, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'LOG_SEARCH_RESULTS', 'false',  10, 5, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), ");

# configuration_group_id 11
INSERT INTO configuration VALUES 
(NULL, 'USE_CACHE', 'false',  11, 1, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'DIR_FS_CACHE', 'cache',  11, 2, NULL, NOW(), NULL, NULL),(NULL, 'CACHE_LIFETIME', '5',  11, 3, NULL, NOW(), NULL, NULL),
(NULL, 'CACHE_CHECK', 'true',  11, 4, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'DB_CACHE', 'false',  11, 5, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'DB_CACHE_EXPIRE', '3600',  11, 6, NULL, NOW(), NULL, NULL);

# configuration_group_id 12
INSERT INTO configuration VALUES 
(NULL, 'EMAIL_TRANSPORT', 'mail',  12, 1, NULL, '', NULL, 'xtc_cfg_select_option(array(\'sendmail\', \'smtp\', \'mail\'),'),
(NULL, 'SENDMAIL_PATH', '/usr/sbin/sendmail', 12, 2, NULL, NOW(), NULL, NULL),
(NULL, 'SMTP_MAIN_SERVER', 'localhost', 12, 3, NULL, NOW(), NULL, NULL),
(NULL, 'SMTP_Backup_Server', 'localhost', 12, 4, NULL, NOW(), NULL, NULL),
(NULL, 'SMTP_PORT', '25', 12, 5, NULL, NOW(), NULL, NULL),
(NULL, 'SMTP_USERNAME', 'Please Enter', 12, 6, NULL, NOW(), NULL, NULL),
(NULL, 'SMTP_PASSWORD', 'Please Enter', 12, 7, NULL, NOW(), NULL, NULL),
(NULL, 'SMTP_AUTH', 'false', 12, 8, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'EMAIL_LINEFEED', 'LF',  12, 9, NULL, '', NULL, 'xtc_cfg_select_option(array(\'LF\', \'CRLF\'),'),
(NULL, 'EMAIL_USE_HTML', 'true',  12, 10, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ENTRY_EMAIL_ADDRESS_CHECK', 'false',  12, 11, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'SEND_EMAILS', 'true',  12, 12, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), ");

# configuration_group_id 24
INSERT INTO configuration VALUES 
(NULL, 'JANOLAW_USERID', '',  24, 1, NULL, NOW(), NULL, NULL),
(NULL, 'JANOLAW_SHOPID', '',  24, 2, NULL, NOW(), NULL, NULL),
(NULL, 'JANOLAW_CACHEPATH', '/tmp',  24, 3, NULL, NOW(), NULL, NULL),
(NULL, 'JANOLAW_BASEURL', 'http://www.janolaw.de/agb-service/shops',  24, 4, NULL, NOW(), NULL, NULL),
(NULL, 'JANOLAW_CACHETIME', '7200',  24, 5, NULL, NOW(), NULL, NULL);

# configuration_group_id 13
INSERT INTO configuration VALUES 
(NULL, 'DOWNLOAD_ENABLED', 'false',  13, 1, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'DOWNLOAD_BY_REDIRECT', 'false',  13, 2, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'DOWNLOAD_UNALLOWED_PAYMENT', '{banktransfer,cod,invoice,moneyorder}',  13, 5, NULL, NOW(), NULL, NULL),
(NULL, 'DOWNLOAD_MIN_ORDERS_STATUS', '1',  13, 5, NULL, NOW(), NULL, NULL);

# configuration_group_id 14
INSERT INTO configuration VALUES 
(NULL, 'GZIP_COMPRESSION', 'false',  14, 1, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'GZIP_LEVEL', '5',  14, 2, NULL, NOW(), NULL, NULL);

# configuration_group_id 15
INSERT INTO configuration VALUES 
(NULL, 'SESSION_WRITE_DIRECTORY', '/tmp',  15, 1, NULL, NOW(), NULL, NULL),
(NULL, 'SESSION_FORCE_COOKIE_USE', 'false',  15, 2, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'SESSION_CHECK_SSL_SESSION_ID', 'false',  15, 3, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'SESSION_CHECK_USER_AGENT', 'false',  15, 4, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'SESSION_CHECK_IP_ADDRESS', 'false',  15, 5, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'SESSION_RECREATE', 'false',  15, 7, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), ");

# configuration_group_id 16
INSERT INTO configuration VALUES 
(NULL, 'META_MAX_KEYWORD_LENGTH', '12', 16, 1, NULL, NOW(), NULL, NULL),
(NULL, 'META_MIN_KEYWORD_LENGTH', '3', 16, 2, NULL, NOW(), NULL, NULL),
(NULL, 'META_MAX_DESCRIPTION_LENGTH', '160', 16, 3, NULL, NOW(), NULL, NULL),
(NULL, 'META_KEYWORDS_NUMBER', '5',  16, 4, NULL, NOW(), NULL, NULL),
(NULL, 'META_AUTHOR', '',  16, 5, NULL, NOW(), NULL, NULL),
(NULL, 'META_PUBLISHER', '',  16, 6, NULL, NOW(), NULL, NULL),
(NULL, 'META_COMPANY', '',  16, 7, NULL, NOW(), NULL, NULL),
(NULL, 'META_TOPIC', 'shopping',  16, 8, NULL, NOW(), NULL, NULL),
(NULL, 'META_REPLY_TO', 'xx@xx.com',  16, 9, NULL, NOW(), NULL, NULL),
(NULL, 'META_REVISIT_AFTER', '14',  16, 10, NULL, NOW(), NULL, NULL),
(NULL, 'META_ROBOTS', 'index,follow,noodp',  16, 11, NULL, NOW(), NULL, NULL),
(NULL, 'META_DESCRIPTION', '',  16, 12, NULL, NOW(), NULL, NULL),
(NULL, 'META_KEYWORDS', '',  16, 13, NULL, NOW(), NULL, NULL),
(NULL, 'SEARCH_ENGINE_FRIENDLY_URLS', 'false',  16, 14, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'CHECK_CLIENT_AGENT', 'true',16, 15, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'GOOGLE_VERIFY', '', 16, 16, NULL, NOW(), NULL, NULL);

# configuration_group_id 17
INSERT INTO configuration VALUES 
(NULL, 'USE_WYSIWYG', 'true', 17, 1, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ACTIVATE_GIFT_SYSTEM', 'false', 17, 2, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'SECURITY_CODE_LENGTH', '10', 17, 3, NULL, '2009-12-05 05:01:41', NULL, NULL),
(NULL, 'NEW_SIGNUP_GIFT_VOUCHER_AMOUNT', '0', 17, 4, NULL, '2009-12-05 05:01:41', NULL, NULL),
(NULL, 'NEW_SIGNUP_DISCOUNT_COUPON', '', 17, 5, NULL, '2009-12-05 05:01:41', NULL, NULL),
(NULL, 'ACTIVATE_SHIPPING_STATUS', 'true', 17, 6, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'DISPLAY_CONDITIONS_ON_CHECKOUT', 'true',17, 7, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'SHOW_IP_LOG', 'false',17, 8, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'GROUP_CHECK', 'false',  17, 9, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ACTIVATE_NAVIGATOR', 'false',  17, 10, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'QUICKLINK_ACTIVATED', 'true',  17, 11, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ACTIVATE_REVERSE_CROSS_SELLING', 'true', 17, 12, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'DISPLAY_REVOCATION_ON_CHECKOUT', 'true', 17, 13, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'REVOCATION_ID', '10', 17, 14, NULL, '2009-12-05 05:01:41', NULL, NULL),
(NULL, 'DISPLAY_DATENSCHUTZ_ON_CHECKOUT', 'true', 17, 15, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'DISPLAY_WIDERRUFSRECHT_ON_CHECKOUT', 'true', 17, 16, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'SLIMSTAT', 'false', 17, 17, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), ");

#configuration_group_id 18
INSERT INTO configuration VALUES 
(NULL, 'ACCOUNT_COMPANY_VAT_CHECK', 'true', 18, 4, '', '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'STORE_OWNER_VAT_ID', '', 18, 3, '', '', NULL, NULL),
(NULL, 'DEFAULT_CUSTOMERS_VAT_STATUS_ID', '2', 18, 23, '', '', 'xtc_get_customers_status_name', 'xtc_cfg_pull_down_customers_status_list('),
(NULL, 'ACCOUNT_COMPANY_VAT_LIVE_CHECK', 'true', 18, 4, '', '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ACCOUNT_COMPANY_VAT_GROUP', 'false', 18, 4, '', '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ACCOUNT_VAT_BLOCK_ERROR', 'true', 18, 4, '', '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'DEFAULT_CUSTOMERS_VAT_STATUS_ID_LOCAL', '2', '18', '24', NULL , '', 'xtc_get_customers_status_name', 'xtc_cfg_pull_down_customers_status_list(');

#configuration_group_id 19
INSERT INTO configuration VALUES 
(NULL, 'GOOGLE_CONVERSION_ID', '', '19', '2', NULL , NOW(), NULL , NULL),
(NULL, 'GOOGLE_LANG', 'de', '19', '3', NULL , NOW(), NULL , NULL),
(NULL, 'GOOGLE_CONVERSION', 'false', '19', '0', NULL , NOW(), NULL , "xtc_cfg_select_option(array('true', 'false'), ");

#configuration_group_id 20
INSERT INTO configuration VALUES 
(NULL, 'CSV_TEXTSIGN', '', '20', '1', NULL , NOW(), NULL , NULL),
(NULL, 'CSV_SEPERATOR', ';', '20', '2', NULL , NOW(), NULL , NULL),
(NULL, 'COMPRESS_EXPORT', 'false', '20', '3', NULL , NOW(), NULL , "xtc_cfg_select_option(array('true', 'false'), ");

#configuration_group_id 21, Afterbuy
INSERT INTO configuration VALUES 
(NULL, 'AFTERBUY_PARTNERID', '', '21', '2', NULL , NOW(), NULL , NULL),
(NULL, 'AFTERBUY_PARTNERPASS', '', '21', '3', NULL , NOW(), NULL , NULL),
(NULL, 'AFTERBUY_USERID', '', '21', '4', NULL , NOW(), NULL , NULL),
(NULL, 'AFTERBUY_ORDERSTATUS', '1', '21', '5', NULL , NOW(), 'xtc_get_order_status_name' , 'xtc_cfg_pull_down_order_statuses('),
(NULL, 'AFTERBUY_ACTIVATED', 'false', '21', '6', NULL , NOW(), NULL , "xtc_cfg_select_option(array('true', 'false'), ");

#configuration_group_id 22, Search Options
INSERT INTO configuration VALUES 
(NULL, 'SEARCH_IN_DESC', 'true', 22, 1, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'SEARCH_IN_CATDESC', 'false', 22, 2, NULL, '2011-09-22 10:47:19', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'SEARCH_IN_ATTR', 'true', 22, 3, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'SEARCH_ACTIVATE_SUGGEST', 'true', 22, 7, NULL, NOW(), NULL, 'xtc_cfg_select_option(array(''true'', ''false''),'),
(NULL, 'SEARCH_PRODUCT_KEYWORDS', 'false', 22, 8, NULL, NOW(), NULL, 'xtc_cfg_select_option(array(''true'', ''false''),'),
(NULL, 'SEARCH_PRODUCT_DESCRIPTION', 'false', 22, 9, NULL, NOW(), NULL, 'xtc_cfg_select_option(array(''true'', ''false''),'),
(NULL, 'SEARCH_PROXIMITY_TRIGGER', '70', 22, 10, NULL, NOW(), NULL, NULL),
(NULL, 'SEARCH_WEIGHT_LEVENSHTEIN', '0', 22, 11, NULL, NOW(), NULL, NULL),
(NULL, 'SEARCH_WEIGHT_SIMILAR_TEXT', '100', 22, 12, NULL, NOW(), NULL, NULL),
(NULL, 'SEARCH_WEIGHT_METAPHONE', '0', 22, 13, NULL, NOW(), NULL, NULL),
(NULL, 'SEARCH_SPLIT_MINIMUM_LENGTH', '3', 22, 14, NULL, NOW(), NULL, NULL),
(NULL, 'SEARCH_SPLIT_PRODUCT_NAMES', 'true', 22, 15, NULL, NOW(), NULL, 'xtc_cfg_select_option(array(''true'', ''false''),'),
(NULL, 'SEARCH_SPLIT_PRODUCT_CHARS', '[ ,.]', 22, 16, NULL, NOW(), NULL, NULL),
(NULL, 'SEARCH_MAX_KEXWORD_SUGGESTS', '6', 22, 17, NULL, NOW(), NULL, NULL),
(NULL, 'SEARCH_COUNT_PRODUCTS', 'true', 22, 18, NULL, NOW(), NULL, 'xtc_cfg_select_option(array(''true'', ''false''),'),
(NULL, 'SEARCH_ENABLE_PROXIMITY_COLOR', 'true', 22, 19, NULL, NOW(), NULL, 'xtc_cfg_select_option(array(''true'', ''false''),'),
(NULL, 'SEARCH_PROXIMITY_COLORS', '#9f6;#cf6;#ff6;#fc9;#f99', 22, 20, NULL, NOW(), NULL, NULL),
(NULL, 'SEARCH_ENABLE_PRODUCTS_SUGGEST', 'true', 22, 21, NULL, NOW(), NULL, 'xtc_cfg_select_option(array(''true'', ''false''),'),
(NULL, 'SEARCH_MAX_PRODUCTS_SUGGEST', '15', 22, 22, NULL, NOW(), NULL, NULL),
(NULL, 'SEARCH_SHOW_PARSETIME', 'false', 22, 23, NULL, NOW(), NULL, 'xtc_cfg_select_option(array(''true'', ''false''),');

#configuration_group_id 23, CSS Styler
INSERT INTO configuration VALUES
(NULL, 'CSS_BUTTON_ACTIVE', 'true',  23, 1, NULL, '', NOW(), "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'CSS_BUTTON_BACKGROUND', 'f1f1f1',  23, 2, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_BACKGROUND_PIC', 'hellblau_dunkelblau.gif', 23, 3, NULL, '', NOW(), 'xtc_cfg_pull_down_css_bg_pic_sets('),
(NULL, 'CSS_BUTTON_BORDER_STYLE', 'none',  23, 4, NULL, '', NOW(), "xtc_cfg_select_option(array('none', 'solid', 'dotted','dashed'), "),
(NULL, 'CSS_BUTTON_BORDER_WIDTH', '1px',  23, 5, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_BORDER_COLOR', 'cccccc',  23, 6, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_BORDER_RADIUS', '5px',  23, 7, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_FONT_FAMILY', 'Verdana',  23, 8, NULL, '', NOW(), "xtc_cfg_select_option(array('Verdana', 'Arial','Helvetica','Times','Georgia','Comic Sans MS'), "),
(NULL, 'CSS_BUTTON_FONT_SIZE', '',  23, 9, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_FONT_ITALIC', 'false',  23, 10, NULL, '', NOW(), "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'CSS_BUTTON_FONT_UNDERLINE', 'false',  23, 11, NULL, '', NOW(), "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'CSS_BUTTON_FONT_COLOR', 'ffffff',  23, 12, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_FONT_COLOR_HOVER', 'ffffff',  23, 13, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_FONT_SHADOW', '#333333 0 1px 1px',  23, 14, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_BACKGROUND_HOVER', '000000',  23, 15, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_BACKGROUND_PIC_HOVER', 'dunkelgrau_schwarz.gif',  23, 16, NULL, '', NOW(), 'xtc_cfg_pull_down_css_bg_pic_hover_sets('),
(NULL, 'CSS_BUTTON_BORDER_COLOR_HOVER', '000000',  23, 17, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_MISC', '',  23, 18, NULL, '', NOW(), 'xtc_cfg_textarea('),
(NULL, 'CSS_BUTTON_BACKGROUND_1', 'd1d1d1',  23, 19, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_BACKGROUND_2', '777777',  23, 20, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_HOVER_BACKGROUND_1', 'd1d1d1',  23, 21, NULL, '', NOW(), NULL),
(NULL, 'CSS_BUTTON_HOVER_BACKGROUND_2', '777777',  23, 22, NULL, '', NOW(), NULL);
# Boxen
INSERT INTO configuration VALUES 
(NULL, 'CSS_BOX_BACKGROUND_1', 'd1d1d1',  23, 100, NULL, '', NOW(), NULL),
(NULL, 'CSS_BOX_BACKGROUND_2', '777777',  23, 101, NULL, '', NOW(), NULL);

#configuration_group_id 333, Ajax Checkout
INSERT INTO configuration VALUES
(NULL, 'BOXLESS_CHECKOUT', 'true', 333, 1, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_AJAX_STAT', 'true', 333, 2, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_AJAX_PRODUCTS', 'false', 333, 3, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_VIEW', 'true', 333, 4, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_SHOW_SHIPPING_MODULES', 'true', 333, 5, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_SHOW_SHIPPING_ADDRESS', 'true', 333, 6, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_SHOW_PAYMENT_MODULES', 'true', 333, 7, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_SHOW_PAYMENT_ADDRESS', 'true', 333, 8, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_SHOW_COMMENTS', 'false', 333, 9, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_SHOW_PRODUCTS', 'true', 333, 10, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_SHOW_AGB', 'true', 333, 11, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_CHECKBOX_AGB', 'true', 333, 12, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_SHOW_REVOCATION', 'true', 333, 13, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_CHECKBOX_REVOCATION', 'true', 333, 14, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_CHECKBOX_DSG', 'true', 333, 16, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CHECKOUT_SHOW_DSG', 'true', 333, 15, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),");

#Login Safe since 1.0.7
INSERT INTO configuration VALUES
(NULL, 'LOGIN_SAFE', 'false', '363', '2', NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'LOGIN_NUM', '2', '363', '3', NULL, NOW(), NULL, NULL),
(NULL, 'LOGIN_TIME', '300',  '363', '4', NULL, NOW(), NULL, NULL);


#Changes since 1.1.1
INSERT INTO configuration VALUES
(NULL, 'MAX_RANDOM_PRODUCTS', '3', 3, 23, NULL , NOW(), NULL , NULL),
(NULL, 'RCS_BASE_DAYS', '30', 33, 10, NULL, NOW(), '', ''),
(NULL, 'RCS_REPORT_DAYS', '90', 33, 15, NULL, NOW(), '', ''),
(NULL, 'RCS_EMAIL_TTL', '90', 33, 20, NULL, NOW(), '', ''),
(NULL, 'RCS_EMAIL_FRIENDLY', 'true', 33, 30, NULL, NOW(), '', "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'RCS_EMAIL_COPIES_TO', '', 33, 35, NULL, NOW(), '', ''),
(NULL, 'RCS_SHOW_ATTRIBUTES', 'false',  33, 40, NULL, NOW(), '', "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'RCS_CHECK_SESSIONS', 'false', 33, 40, NULL, NOW(), '', "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'RCS_CURCUST_COLOR', '0000FF', 33, 50, NULL, NOW(), '', ''),
(NULL, 'RCS_UNCONTACTED_COLOR', '9FFF9F', 33, 60, NULL, NOW(), '', ''),
(NULL, 'RCS_CONTACTED_COLOR', 'FF9F9F', 33, 70, NULL, NOW(), '', ''),
(NULL, 'RCS_MATCHED_ORDER_COLOR', '9FFFFF', 33, 72, NULL, NOW(), '', ''),
(NULL, 'RCS_SKIP_MATCHED_CARTS', 'true', 33, 80, NULL, NOW(), '', "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'RCS_AUTO_CHECK', 'true', 33, 82, NULL, NOW(), '', "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'RCS_CARTS_MATCH_ALL_DATES', 'true', 33, 84, NULL, NOW(), '', "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'RCS_PENDING_SALE_STATUS', '1', 33, 85, NULL, NOW(), 'xtc_get_order_status_name', 'xtc_cfg_pull_down_order_statuses('),
(NULL, 'RCS_REPORT_EVEN_STYLE', 'dataTableRow', 33, 90, NULL, NOW(), '', ''),
(NULL, 'RCS_REPORT_ODD_STYLE', '', 33, 92, NULL, NOW(), '', ''),
(NULL, 'RCS_SHOW_BRUTTO_PRICE', 'true', 33, 94, NULL, NOW(), '', "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'DEFAULT_RCS_SHIPPING', '', 33, 95, NULL, NOW(), '', ''),(NULL, 'DEFAULT_RCS_PAYMENT', '', 33, 96, NULL, NOW(), '', ''),
(NULL, 'RCS_DELETE_COMPLETED_ORDERS', 'true', 33, 97, NULL, NOW(), '', "xtc_cfg_select_option(array('true', 'false'),");

#configuration_group_id 155, cSEO Config
INSERT INTO configuration VALUES 
(NULL, 'PRODUCT_LISTING_MANU_NAME', 'false', 155, 1, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'PRODUCT_LISTING_MANU_IMG', 'false', 155, 2, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'PRODUCT_LISTING_VPE', 'false', 155, 3, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'PRODUCT_LISTING_MODEL', 'false', 155, 4, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'PDF_IN_ODERMAIL', 'false', 155, 5, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'PDF_IN_ORDERMAIL_COID', '3', 155, 6, NULL, NOW(), NULL, ''),
(NULL, 'DOWN_FOR_MAINTENANCE', 'false', 155, 7, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'IMAGE_NAME_CATEGORIE', 'c_name', 155, 8, NULL, NOW(), NULL, "xtc_cfg_select_option(array('c_id', 'c_name', 'c_image'),"),
(NULL, 'IMAGE_NAME_PRODUCT', 'p_name', 155, 9, NULL, NOW(), NULL, "xtc_cfg_select_option(array('p_id', 'p_name', 'p_image'),"),
(NULL, 'SHIPPING_LINK', 'overlay', 155, 10, NULL, now(), NULL, "xtc_cfg_select_option(array('popup', 'blank', 'overlay'),"),
(NULL, 'SITE_OVERLAYS', 'true', 155, 12, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'PRICE_AS_IMAGE', 'false', 155, 13, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'PRODUCT_LIST_FILTER_SORT', 'true', 155, 14, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CATEGORY_LISTING_START', 'false', 155, 15, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CATEGORY_LISTING_START_HEAD', 'true', 155, 16, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CATEGORY_LISTING_START_PICTURE', 'true', 155, 17, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'CATEGORY_LISTING_START_DESCR', 'true', 155, 18, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'),");

#configuration_group_id 156, Trusted Shops
INSERT INTO configuration VALUES 
(NULL, 'TRUSTED_SHOP_STATUS', 'false', 156, 1, NULL, NOW(), NULL,"xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'TRUSTED_SHOP_NR', '0', 156, 2, NULL, NOW(), NULL,''),
(NULL, 'TRUSTED_SHOP_CREATE_ACCOUNT_DS', 'true', 156, 3, NULL, NOW(), NULL,"xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'TRUSTED_SHOP_PASSWORD_EMAIL', 'true', 156, 4, NULL, NOW(), NULL,"xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'TRUSTED_SHOP_IP_LOG', 'true', 156, 5, NULL, NOW(), NULL,"xtc_cfg_select_option(array('true', 'false'),"),
(NULL, 'TRUSTED_SHOP_TEMPLATE', 'logo_text_vertikal_weiss.html', 156, 10, NULL, NOW(), NULL,"xtc_cfg_pull_down_trusted_shop_template(");

#configuration_group_id 361, Google Analytics
INSERT INTO configuration VALUES 
(NULL, 'GOOGLE_ANAL_ON', 'false', '361', '1', NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'GOOGLE_ANONYM_ON', 'false', '361', '2', NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'GOOGLE_ANAL_CODE', '', '361', '3', NULL, NOW(), NULL, NULL);

#configuration_group_id 1000, CSEO ab 2.1
INSERT INTO configuration VALUES 
(NULL, 'MAX_DISPLAY_TAGS_RESULTS', '40', 1000, 1, NULL, NOW(), NULL, NULL),
(NULL, 'MIN_DISPLAY_TAGS_FONT', '12', 1000, 2, NULL, NOW(), NULL, NULL),
(NULL, 'MAX_DISPLAY_TAGS_FONT', '32', 1000, 3, NULL, NOW(), NULL, NULL),
(NULL, 'DISPLAY_RAND_PRODUCTS_SLIDE', 'false',  1000, 5, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'CAT_NAV_AJAX', 'false',  1000, 6, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'ADMIN_AFTER_LOGIN', 'false',  1000, 7, NULL, '', NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'DISPLAY_NEW_PRODUCTS_SLIDE', 'false', 1000, 4, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), ");


#configuration_group_id 1001, Twitterbox ab 2.1
INSERT INTO configuration VALUES 
(NULL, 'TWITTERBOX_STATUS', 'false', 1001, 5, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'TWITTER_ACCOUNT', 'commerce_SEO', 1001, 6, NULL, NOW(), NULL, NULL),
(NULL, 'TWITTER_SCROLLBAR', 'false', 1001, 7, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'TWITTER_LOOP', 'true', 1001, 8, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'TWITTER_LIVE', 'true', 1001, 9, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'TWITTER_HASHTAGS', 'true', 1001, 10, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'TWITTER_TIMESTAMP', 'true', 1001, 11, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'TWITTER_AVATARS', 'false', 1001, 12, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'TWITTER_BEHAVIOR', 'all', 1001, 13, NULL, NOW(), NULL, NULL),
(NULL, 'TWITTER_SHELL_BACKGROUND', '#b8b8b8', 1001, 14, NULL, NOW(), NULL, NULL),
(NULL, 'TWITTER_SHELL_COLOR', '#ffffff', 1001, 15, NULL, NOW(), NULL, NULL),
(NULL, 'TWITTER_TWEETS_BACKGROUND', '#ffffff', 1001, 16, NULL, NOW(), NULL, NULL),
(NULL, 'TWITTER_TWEETS_COLOR', '#141414', 1001, 17, NULL, NOW(), NULL, NULL),
(NULL, 'TWITTER_TWEETS_LINKS', '#0f07eb', 1001, 18, NULL, NOW(), NULL, NULL),
(NULL, 'TWITTER_BOX_WIDTH', 'auto', 1001, 19, NULL, NOW(), NULL, NULL),
(NULL, 'TWITTER_BOX_HEIGHT', '190', 1001, 20, NULL, NOW(), NULL, NULL),
(NULL, 'TWITTER_BOX_INTERVAL', '6000', 1001, 21, NULL, NOW(), NULL, NULL);

#configuration_group_id 1002, Produktdetails ab 2.1
INSERT INTO configuration VALUES 
(NULL, 'PRODUCT_DETAILS_MODELLNR', 'true', 1002, 1, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_MANUFACTURERS_MODELLNR', 'false', 1002, 2, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_SHIPPINGTIME', 'true', 1002, 3, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_STOCK', 'true', 1002, 4, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_EAN', 'true', 1002, 5, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_VPE', 'true', 1002, 6, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_WEIGHT', 'true', 1002, 7, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_PRINT', 'true', 1002, 8, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_WISHLIST', 'true', 1002, 9, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_ASKQUESTION', 'true', 1002, 10, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_TAB_DESCRIPTION', 'true', 1002, 11, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_TAB_ACCESSORIES', 'true', 1002, 12, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_TAB_PARAMETERS', 'true', 1002, 13, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_TAB_REVIEWS', 'true', 1002, 14, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_TAB_CROSS_SELLING', 'true', 1002, 15, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_TAB_MEDIA', 'true', 1002, 16, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_TAB_ALSO_PURCHASED', 'true', 1002, 17, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_TAB_REVERSE_CROSS_SELLING', 'true', 1002, 18, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_TAB_ADD', 'true', 1002, 19, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_TAB_ADD_CONTENT_GROUP_ID', '', 1002, 20, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_DETAILS_TAB_PRODUCT', 'true', 1002, 21, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_TAB_MANUFACTURERS', 'false', 1002, 22, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_TAGS', 'true', 1002, 23, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_SOCIAL', 'true', 1002, 24, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_DETAILS_RELATED_CAT', 'true', 1002, 25, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_INFO_GALLERY', 'dark_rounded', 1002, 26, NULL, NOW(), NULL, NULL),
(NULL, 'PRODUCT_INFO_GALLERY_SLIDE', 'false', 1002, 27, NULL, NOW(), NULL, "xtc_cfg_select_option(array('true', 'false'), "),
(NULL, 'PRODUCT_GOOGLE_STANDARD_TAXONOMIE', '', 1002, 28, NULL, NOW(), NULL, NULL);

#configuration_group_id 1003, Treepodia ab 2.1
INSERT INTO configuration VALUES 
(NULL, 'TREEPODIA_PARTNER_UUID', '', 1003, 1, NULL, NOW(), NULL, NULL),
(NULL, 'TREEPODIA_PARTNER_CATCH_PHRASE_GLOBAL', '', 1003, 2, NULL, NOW(), NULL, NULL);



INSERT INTO configuration_group VALUES 
('1', 'Mein Shop', 'Generelle Einstellungen für den Shop', '1', '1'),
('2', 'Minimum Werte', 'The minimum VALUES for functions / data', '2', '1'),
('3', 'Maximum Werte', 'The maximum VALUES for functions / data', '3', '1'),
('4', 'Bilder', 'Image parameters', '4', '1'),
('5', 'Kunden Details', 'Customer account configuration', '5', '1'),
('6', 'Modul Optionen', 'Hidden from configuration', '6', '0'),
('7', 'Verpackung/Versand', 'Shipping options available at my store', '7', '1'),
('8', 'Product Listing', 'Product Listing    configuration options', '8', '1'),
('9', 'Lagerverwaltung', 'Stock configuration options', '9', '1'),
('10', 'Logging', 'Logging configuration options', '10', '1'),
('11', 'Cache', 'Caching configuration options', '11', '1'),
('12', 'Email Optionen', 'General setting for E-Mail transport and HTML E-Mails', '12', '1'),
('13', 'Download', 'Downloadable products options', '13', '1'),
('14', 'GZip Compression', 'GZip compression options', '14', '1'),
('15', 'Sessions', 'Session options', '15', '1'),
('16', 'Meta-Tags/Suchmaschinen', 'Meta-tags/Search engines', '16', '1'),
('18', 'Ust ID', 'Vat ID', '18', '1'),
('19', 'Google Conversion', 'Google Conversion-Tracking', '19', '1'),
('20', 'Import/Export', 'Import/Export', '20', '1'),
('21', 'Afterbuy', 'Afterbuy.de', '21', '1'),
('22', 'Suchoptionen', 'Additional Options for search function', '22', '1'),
('23', 'CSS Buttons', 'Einstellungen für die CSS Buttons', '23', '1'),
('33', 'Recover Cart Sales', 'Recover Cart Sales (RCS) Configuration Values', '33', '1'),
('25', 'PayPal', 'PayPal', '25', '1');


#NEW 2.0
INSERT INTO configuration_group VALUES 
('156', 'Trusted Shop Box', 'Einstellungen für die Template Box + ShopID', '156', '1'),
('155', 'commerce:SEO', 'Einstellungen für das Template', '155', '1'),
('360', 'Mail Anhänge', 'Mail Anhang Optionen', '360', '1'),
('361', 'Google Analytics', 'Google Analytics Options', '361', '1'),
('363', 'Login Safe', 'Login Safe', '363', '1'),
('1000', 'CSEO Config', 'CSEO Config', '1000', '1'),
('1001', 'Twitter Config', 'Twitter Config', '1001', '1');

INSERT INTO countries VALUES (1,'Afghanistan','AF','AFG','1','1'),(2,'Albania','AL','ALB','1','1'),
(3,'Algeria','DZ','DZA','1','1'),(4,'American Samoa','AS','ASM','1','1'),
(5,'Andorra','AD','AND','1','1'),(6,'Angola','AO','AGO','1','1'),
(7,'Anguilla','AI','AIA','1','1'),(8,'Antarctica','AQ','ATA','1','1'),
(9,'Antigua and Barbuda','AG','ATG','1','1'),(10,'Argentina','AR','ARG','1','1'),
(11,'Armenia','AM','ARM','1','1'),(12,'Aruba','AW','ABW','1','1'),
(13,'Australia','AU','AUS','1','1'),(14,'Austria','AT','AUT','5','1'),
(15,'Azerbaijan','AZ','AZE','1','1'),(16,'Bahamas','BS','BHS','1','1'),
(17,'Bahrain','BH','BHR','1','1'),(18,'Bangladesh','BD','BGD','1','1'),
(19,'Barbados','BB','BRB','1','1'),(20,'Belarus','BY','BLR','1','1'),(21,'Belgium','BE','BEL','1','1'),
(22,'Belize','BZ','BLZ','1','1'),(23,'Benin','BJ','BEN','1','1'),
(24,'Bermuda','BM','BMU','1','1'),(25,'Bhutan','BT','BTN','1','1'),
(26,'Bolivia','BO','BOL','1','1'),(27,'Bosnia and Herzegowina','BA','BIH','1','1'),
(28,'Botswana','BW','BWA','1','1'),(29,'Bouvet Island','BV','BVT','1','1'),
(30,'Brazil','BR','BRA','1','1'),(31,'British Indian Ocean Territory','IO','IOT','1','1'),
(32,'Brunei Darussalam','BN','BRN','1','1'),(33,'Bulgaria','BG','BGR','1','1'),
(34,'Burkina Faso','BF','BFA','1','1'),(35,'Burundi','BI','BDI','1','1'),
(36,'Cambodia','KH','KHM','1','1'),(37,'Cameroon','CM','CMR','1','1'),
(38,'Canada','CA','CAN','1','1'),(39,'Cape Verde','CV','CPV','1','1'),
(40,'Cayman Islands','KY','CYM','1','1'),(41,'Central African Republic','CF','CAF','1','1'),
(42,'Chad','TD','TCD','1','1'),(43,'Chile','CL','CHL','1','1'),
(44,'China','CN','CHN','1','1'),(45,'Christmas Island','CX','CXR','1','1'),
(46,'Cocos (Keeling) Islands','CC','CCK','1','1'),(47,'Colombia','CO','COL','1','1'),
(48,'Comoros','KM','COM','1','1'),(49,'Congo','CG','COG','1','1'),
(50,'Cook Islands','CK','COK','1','1'),(51,'Costa Rica','CR','CRI','1','1'),
(52,'Cote D\'Ivoire','CI','CIV','1','1'),(53,'Croatia','HR','HRV','1','1'),
(54,'Cuba','CU','CUB','1','1'),(55,'Cyprus','CY','CYP','1','1'),
(56,'Czech Republic','CZ','CZE','1','1'),(57,'Denmark','DK','DNK','1','1'),
(58,'Djibouti','DJ','DJI','1','1'),(59,'Dominica','DM','DMA','1','1'),
(60,'Dominican Republic','DO','DOM','1','1'),(61,'East Timor','TP','TMP','1','1'),
(62,'Ecuador','EC','ECU','1','1'),(63,'Egypt','EG','EGY','1','1'),
(64,'El Salvador','SV','SLV','1','1'),(65,'Equatorial Guinea','GQ','GNQ','1','1'),
(66,'Eritrea','ER','ERI','1','1'),(67,'Estonia','EE','EST','1','1'),
(68,'Ethiopia','ET','ETH','1','1'),(69,'Falkland Islands (Malvinas)','FK','FLK','1','1'),
(70,'Faroe Islands','FO','FRO','1','1'),(71,'Fiji','FJ','FJI','1','1'),
(72,'Finland','FI','FIN','1','1'),(73,'France','FR','FRA','1','1'),
(74,'France, Metropolitan','FX','FXX','1','1'),(75,'French Guiana','GF','GUF','1','1'),
(76,'French Polynesia','PF','PYF','1','1'),(77,'French Southern Territories','TF','ATF','1','1'),
(78,'Gabon','GA','GAB','1','1'),(79,'Gambia','GM','GMB','1','1'),
(80,'Georgia','GE','GEO','1','1'),(81,'Germany','DE','DEU','5','1'),
(82,'Ghana','GH','GHA','1','1'),(83,'Gibraltar','GI','GIB','1','1'),
(84,'Greece','GR','GRC','1','1'),(85,'Greenland','GL','GRL','1','1'),
(86,'Grenada','GD','GRD','1','1'),(87,'Guadeloupe','GP','GLP','1','1'),
(88,'Guam','GU','GUM','1','1'),(89,'Guatemala','GT','GTM','1','1'),
(90,'Guinea','GN','GIN','1','1'),(91,'Guinea-bissau','GW','GNB','1','1'),
(92,'Guyana','GY','GUY','1','1'),(93,'Haiti','HT','HTI','1','1'),
(94,'Heard and Mc Donald Islands','HM','HMD','1','1'),(95,'Honduras','HN','HND','1','1'),
(96,'Hong Kong','HK','HKG','1','1'),(97,'Hungary','HU','HUN','1','1'),
(98,'Iceland','IS','ISL','1','1'),(99,'India','IN','IND','1','1'),
(100,'Indonesia','ID','IDN','1','1'),(101,'Iran (Islamic Republic of)','IR','IRN','1','1'),
(102,'Iraq','IQ','IRQ','1','1'),(103,'Ireland','IE','IRL','1','1'),
(104,'Israel','IL','ISR','1','1'),(105,'Italy','IT','ITA','1','1'),
(106,'Jamaica','JM','JAM','1','1'),(107,'Japan','JP','JPN','1','1'),
(108,'Jordan','JO','JOR','1','1'),(109,'Kazakhstan','KZ','KAZ','1','1'),
(110,'Kenya','KE','KEN','1','1'),(111,'Kiribati','KI','KIR','1','1'),
(112,'Korea, Democratic People\'s Republic of','KP','PRK','1','1'),
(113,'Korea, Republic of','KR','KOR','1','1'),(114,'Kuwait','KW','KWT','1','1'),
(115,'Kyrgyzstan','KG','KGZ','1','1'),(116,'Lao People\'s Democratic Republic','LA','LAO','1','1'),
(117,'Latvia','LV','LVA','1','1'),(118,'Lebanon','LB','LBN','1','1'),
(119,'Lesotho','LS','LSO','1','1'),(120,'Liberia','LR','LBR','1','1'),
(121,'Libyan Arab Jamahiriya','LY','LBY','1','1'),(122,'Liechtenstein','LI','LIE','1','1'),
(123,'Lithuania','LT','LTU','1','1'),(124,'Luxembourg','LU','LUX','1','1'),
(125,'Macau','MO','MAC','1','1'),(126,'Macedonia, The Former Yugoslav Republic of','MK','MKD','1','1'),
(127,'Madagascar','MG','MDG','1','1'),(128,'Malawi','MW','MWI','1','1'),
(129,'Malaysia','MY','MYS','1','1'),(130,'Maldives','MV','MDV','1','1'),
(131,'Mali','ML','MLI','1','1'),(132,'Malta','MT','MLT','1','1'),
(133,'Marshall Islands','MH','MHL','1','1'),(134,'Martinique','MQ','MTQ','1','1'),
(135,'Mauritania','MR','MRT','1','1'),(136,'Mauritius','MU','MUS','1','1'),
(137,'Mayotte','YT','MYT','1','1'),(138,'Mexico','MX','MEX','1','1'),
(139,'Micronesia, Federated States of','FM','FSM','1','1'),(140,'Moldova, Republic of','MD','MDA','1','1'),
(141,'Monaco','MC','MCO','1','1'),(142,'Mongolia','MN','MNG','1','1'),
(143,'Montserrat','MS','MSR','1','1'),(144,'Morocco','MA','MAR','1','1'),
(145,'Mozambique','MZ','MOZ','1','1'),(146,'Myanmar','MM','MMR','1','1'),
(147,'Namibia','NA','NAM','1','1'),(148,'Nauru','NR','NRU','1','1'),
(149,'Nepal','NP','NPL','1','1'),(150,'Netherlands','NL','NLD','1','1'),
(151,'Netherlands Antilles','AN','ANT','1','1'),(152,'New Caledonia','NC','NCL','1','1'),
(153,'New Zealand','NZ','NZL','1','1'),(154,'Nicaragua','NI','NIC','1','1'),
(155,'Niger','NE','NER','1','1'),(156,'Nigeria','NG','NGA','1','1'),
(157,'Niue','NU','NIU','1','1'),(158,'Norfolk Island','NF','NFK','1','1'),
(159,'Northern Mariana Islands','MP','MNP','1','1'),(160,'Norway','NO','NOR','1','1'),
(161,'Oman','OM','OMN','1','1'),(162,'Pakistan','PK','PAK','1','1'),
(163,'Palau','PW','PLW','1','1'),(164,'Panama','PA','PAN','1','1'),
(165,'Papua New Guinea','PG','PNG','1','1'),(166,'Paraguay','PY','PRY','1','1'),
(167,'Peru','PE','PER','1','1'),(168,'Philippines','PH','PHL','1','1'),
(169,'Pitcairn','PN','PCN','1','1'),(170,'Poland','PL','POL','1','1'),
(171,'Portugal','PT','PRT','1','1'),(172,'Puerto Rico','PR','PRI','1','1'),
(173,'Qatar','QA','QAT','1','1'),(174,'Reunion','RE','REU','1','1'),
(175,'Romania','RO','ROM','1','1'),(176,'Russian Federation','RU','RUS','1','1'),
(177,'Rwanda','RW','RWA','1','1'),(178,'Saint Kitts and Nevis','KN','KNA','1','1'),
(179,'Saint Lucia','LC','LCA','1','1'),(180,'Saint Vincent and the Grenadines','VC','VCT','1','1'),
(181,'Samoa','WS','WSM','1','1'),(182,'San Marino','SM','SMR','1','1'),
(183,'Sao Tome and Principe','ST','STP','1','1'),(184,'Saudi Arabia','SA','SAU','1','1'),
(185,'Senegal','SN','SEN','1','1'),(186,'Seychelles','SC','SYC','1','1'),
(187,'Sierra Leone','SL','SLE','1','1'),(188,'Singapore','SG','SGP', '4','1'),
(189,'Slovakia (Slovak Republic)','SK','SVK','1','1'),(190,'Slovenia','SI','SVN','1','1'),
(191,'Solomon Islands','SB','SLB','1','1'),(192,'Somalia','SO','SOM','1','1'),
(193,'South Africa','ZA','ZAF','1','1'),(194,'South Georgia and the South Sandwich Islands','GS','SGS','1','1'),
(195,'Spain','ES','ESP','3','1'),(196,'Sri Lanka','LK','LKA','1','1'),
(197,'St. Helena','SH','SHN','1','1'),(198,'St. Pierre and Miquelon','PM','SPM','1','1'),
(199,'Sudan','SD','SDN','1','1'),(200,'Suriname','SR','SUR','1','1'),
(201,'Svalbard and Jan Mayen Islands','SJ','SJM','1','1'),(202,'Swaziland','SZ','SWZ','1','1'),
(203,'Sweden','SE','SWE','1','1'),(204,'Switzerland','CH','CHE','1','1'),
(205,'Syrian Arab Republic','SY','SYR','1','1'),(206,'Taiwan','TW','TWN','1','1'),
(207,'Tajikistan','TJ','TJK','1','1'),(208,'Tanzania, United Republic of','TZ','TZA','1','1'),
(209,'Thailand','TH','THA','1','1'),(210,'Togo','TG','TGO','1','1'),
(211,'Tokelau','TK','TKL','1','1'),(212,'Tonga','TO','TON','1','1'),
(213,'Trinidad and Tobago','TT','TTO','1','1'),(214,'Tunisia','TN','TUN','1','1'),
(215,'Turkey','TR','TUR','1','1'),(216,'Turkmenistan','TM','TKM','1','1'),
(217,'Turks and Caicos Islands','TC','TCA','1','1'),(218,'Tuvalu','TV','TUV','1','1'),
(219,'Uganda','UG','UGA','1','1'),(220,'Ukraine','UA','UKR','1','1'),
(221,'United Arab Emirates','AE','ARE','1','1'),(222,'United Kingdom','GB','GBR','1','1'),
(223,'United States','US','USA', '2','1'),(224,'United States Minor Outlying Islands','UM','UMI','1','1'),
(225,'Uruguay','UY','URY','1','1'),(226,'Uzbekistan','UZ','UZB','1','1'),
(227,'Vanuatu','VU','VUT','1','1'),(228,'Vatican City State (Holy See)','VA','VAT','1','1'),
(229,'Venezuela','VE','VEN','1','1'),(230,'Viet Nam','VN','VNM','1','1'),
(231,'Virgin Islands (British)','VG','VGB','1','1'),(232,'Virgin Islands (U.S.)','VI','VIR','1','1'),
(233,'Wallis and Futuna Islands','WF','WLF','1','1'),(234,'Western Sahara','EH','ESH','1','1'),
(235,'Yemen','YE','YEM','1','1'),(236,'Yugoslavia','YU','YUG','1','1'),(237,'Zaire','ZR','ZAR','1','1'),
(238,'Zambia','ZM','ZMB','1','1'),(239,'Zimbabwe','ZW','ZWE','1','1');

INSERT INTO currencies VALUES (1,'Euro','EUR','','EUR',',','.','2','1.0000', now());

INSERT INTO languages VALUES (1,'Deutsch','de','icon.gif', 'german', 1, 'utf-8', '1', '1');

INSERT INTO orders_status VALUES ( '1', '1', 'Offen'), ( '2', '1', 'In Bearbeitung'), ( '3', '1', 'Versendet');

# USA
INSERT INTO zones VALUES (1,223,'AL','Alabama'),
(2,223,'AK','Alaska'),
(3,223,'AS','American Samoa'),
(4,223,'AZ','Arizona'),
(5,223,'AR','Arkansas'),
(6,223,'AF','Armed Forces Africa'),
(7,223,'AA','Armed Forces Americas'),
(8,223,'AC','Armed Forces Canada'),
(9,223,'AE','Armed Forces Europe'),
(10,223,'AM','Armed Forces Middle East'),
(11,223,'AP','Armed Forces Pacific'),
(12,223,'CA','California'),
(13,223,'CO','Colorado'),
(14,223,'CT','Connecticut'),
(15,223,'DE','Delaware'),
(16,223,'DC','District of Columbia'),
(17,223,'FM','Federated States Of Micronesia'),
(18,223,'FL','Florida'),
(19,223,'GA','Georgia'),
(20,223,'GU','Guam'),
(21,223,'HI','Hawaii'),
(22,223,'ID','Idaho'),
(23,223,'IL','Illinois'),
(24,223,'IN','Indiana'),
(25,223,'IA','Iowa'),
(26,223,'KS','Kansas'),
(27,223,'KY','Kentucky'),
(28,223,'LA','Louisiana'),
(29,223,'ME','Maine'),
(30,223,'MH','Marshall Islands'),
(31,223,'MD','Maryland'),
(32,223,'MA','Massachusetts'),
(33,223,'MI','Michigan'),
(34,223,'MN','Minnesota'),
(35,223,'MS','Mississippi'),
(36,223,'MO','Missouri'),
(37,223,'MT','Montana'),
(38,223,'NE','Nebraska'),
(39,223,'NV','Nevada'),
(40,223,'NH','New Hampshire'),
(41,223,'NJ','New Jersey'),
(42,223,'NM','New Mexico'),
(43,223,'NY','New York'),
(44,223,'NC','North Carolina'),
(45,223,'ND','North Dakota'),
(46,223,'MP','Northern Mariana Islands'),
(47,223,'OH','Ohio'),
(48,223,'OK','Oklahoma'),
(49,223,'OR','Oregon'),
(50,223,'PW','Palau'),
(51,223,'PA','Pennsylvania'),
(52,223,'PR','Puerto Rico'),
(53,223,'RI','Rhode Island'),
(54,223,'SC','South Carolina'),
(55,223,'SD','South Dakota'),
(56,223,'TN','Tennessee'),
(57,223,'TX','Texas'),
(58,223,'UT','Utah'),
(59,223,'VT','Vermont'),
(60,223,'VI','Virgin Islands'),
(61,223,'VA','Virginia'),
(62,223,'WA','Washington'),
(63,223,'WV','West Virginia'),
(64,223,'WI','Wisconsin'),
(65,223,'WY','Wyoming');

# Canada
INSERT INTO zones VALUES (66,38,'AB','Alberta'),
(67,38,'BC','British Columbia'),
(68,38,'MB','Manitoba'),
(69,38,'NF','Newfoundland'),
(70,38,'NB','New Brunswick'),
(71,38,'NS','Nova Scotia'),
(72,38,'NT','Northwest Territories'),
(73,38,'NU','Nunavut'),
(74,38,'ON','Ontario'),
(75,38,'PE','Prince Edward Island'),
(76,38,'QC','Quebec'),
(77,38,'SK','Saskatchewan'),
(78,38,'YT','Yukon Territory');

# Germany
INSERT INTO zones VALUES (79,81,'NDS','Niedersachsen'),
(80,81,'BAW','Baden-Württemberg'),
(81,81,'BAY','Bayern'),
(82,81,'BER','Berlin'),
(83,81,'BRG','Brandenburg'),
(84,81,'BRE','Bremen'),
(85,81,'HAM','Hamburg'),
(86,81,'HES','Hessen'),
(87,81,'MEC','Mecklenburg-Vorpommern'),
(88,81,'NRW','Nordrhein-Westfalen'),
(89,81,'RHE','Rheinland-Pfalz'),
(90,81,'SAR','Saarland'),
(91,81,'SAS','Sachsen'),
(92,81,'SAC','Sachsen-Anhalt'),
(93,81,'SCN','Schleswig-Holstein'),
(94,81,'THE','Thüringen');

# Austria
INSERT INTO zones VALUES (95,14,'WI','Wien'),
(96,14,'NO','Niederösterreich'),
(97,14,'OO','Oberösterreich'),
(98,14,'SB','Salzburg'),
(99,14,'KN','Kärnten'),
(100,14,'ST','Steiermark'),
(101,14,'TI','Tirol'),
(102,14,'BL','Burgenland'),
(103,14,'VB','Voralberg');

# Swizterland
INSERT INTO zones VALUES (104,204,'AG','Aargau'),
(105,204,'AI','Appenzell Innerrhoden'),
(106,204,'AR','Appenzell Ausserrhoden'),
(107,204,'BE','Bern'),
(108,204,'BL','Basel-Landschaft'),
(109,204,'BS','Basel-Stadt'),
(110,204,'FR','Freiburg'),
(111,204,'GE','Genf'),
(112,204,'GL','Glarus'),
(113,204,'JU','Graubünden'),
(114,204,'JU','Jura'),
(115,204,'LU','Luzern'),
(116,204,'NE','Neuenburg'),
(117,204,'NW','Nidwalden'),
(118,204,'OW','Obwalden'),
(119,204,'SG','St. Gallen'),
(120,204,'SH','Schaffhausen'),
(121,204,'SO','Solothurn'),
(122,204,'SZ','Schwyz'),
(123,204,'TG','Thurgau'),
(124,204,'TI','Tessin'),
(125,204,'UR','Uri'),
(126,204,'VD','Waadt'),
(127,204,'VS','Wallis'),
(128,204,'ZG','Zug'),
(129,204,'ZH','Zürich');

# Spain
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'A Coru&ntilde;a','A Coru&ntilde;a'),
(195,'Alava','Alava'),
(195,'Albacete','Albacete'),
(195,'Alicante','Alicante'),
(195,'Almeria','Almeria'),
(195,'Asturias','Asturias'),
(195,'Avila','Avila'),
(195,'Badajoz','Badajoz'),
(195,'Baleares','Baleares'),
(195,'Barcelona','Barcelona'),
(195,'Burgos','Burgos'),
(195,'Caceres','Caceres'),
(195,'Cadiz','Cadiz'),
(195,'Cantabria','Cantabria'),
(195,'Castellon','Castellon'),
(195,'Ceuta','Ceuta'),
(195,'Ciudad Real','Ciudad Real'),
(195,'Cordoba','Cordoba'),
(195,'Cuenca','Cuenca'),
(195,'Girona','Girona'),
(195,'Granada','Granada'),
(195,'Guadalajara','Guadalajara'),
(195,'Guipuzcoa','Guipuzcoa'),
(195,'Huelva','Huelva'),
(195,'Huesca','Huesca'),
(195,'Jaen','Jaen'),
(195,'La Rioja','La Rioja'),
(195,'Las Palmas','Las Palmas'),
(195,'Leon','Leon'),
(195,'Lleida','Lleida'),
(195,'Lugo','Lugo'),
(195,'Madrid','Madrid'),
(195,'Malaga','Malaga'),
(195,'Melilla','Melilla'),
(195,'Murcia','Murcia'),
(195,'Navarra','Navarra'),
(195,'Ourense','Ourense'),
(195,'Palencia','Palencia'),
(195,'Pontevedra','Pontevedra'),
(195,'Salamanca','Salamanca'),
(195,'Santa Cruz de Tenerife','Santa Cruz de Tenerife'),
(195,'Segovia','Segovia'),
(195,'Sevilla','Sevilla'),
(195,'Soria','Soria'),
(195,'Tarragona','Tarragona'),
(195,'Teruel','Teruel'),
(195,'Toledo','Toledo'),
(195,'Valencia','Valencia'),
(195,'Valladolid','Valladolid'),
(195,'Vizcaya','Vizcaya'),
(195,'Zamora','Zamora'),
(195,'Zaragoza','Zaragoza');

#Australia
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (13,'NSW','New South Wales'),
(13,'VIC','Victoria'),
(13,'QLD','Queensland'),
(13,'NT','Northern Territory'),
(13,'WA','Western Australia'),
(13,'SA','South Australia'),
(13,'TAS','Tasmania'),
(13,'ACT','Australian Capital Territory');

#New Zealand
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (153,'Northland','Northland'),
(153,'Auckland','Auckland'),
(153,'Waikato','Waikato'),
(153,'Bay of Plenty','Bay of Plenty'),
(153,'Gisborne','Gisborne'),
(153,'Hawkes Bay','Hawkes Bay'),
(153,'Taranaki','Taranaki'),
(153,'Manawatu-Wanganui','Manawatu-Wanganui'),
(153,'Wellington','Wellington'),
(153,'West Coast','West Coast'),
(153,'Canterbury','Canterbury'),
(153,'Otago','Otago'),
(153,'Southland','Southland'),
(153,'Tasman','Tasman'),
(153,'Nelson','Nelson'),
(153,'Marlborough','Marlborough');

#Brazil
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (30, 'SP', 'S&atilde;o Paulo'),
(30, 'RJ', 'Rio de Janeiro'),
(30, 'PE', 'Pernanbuco'),
(30, 'BA', 'Bahia'),
(30, 'AM', 'Amazonas'),
(30, 'MG', 'Minas Gerais'),
(30, 'ES', 'Espirito Santo'),
(30, 'RS', 'Rio Grande do Sul'),
(30, 'PR', 'Paran&aacute;'),
(30, 'SC', 'Santa Catarina'),
(30, 'RG', 'Rio Grande do Norte'),
(30, 'MS', 'Mato Grosso do Sul'),
(30, 'MT', 'Mato Grosso'),
(30, 'GO', 'Goias'),
(30, 'TO', 'Tocantins'),
(30, 'DF', 'Distrito Federal'),
(30, 'RO', 'Rondonia'),
(30, 'AC', 'Acre'),
(30, 'AP', 'Amapa'),
(30, 'RO', 'Roraima'),
(30, 'AL', 'Alagoas'),
(30, 'CE', 'Cear&aacute;'),
(30, 'MA', 'Maranh&atilde;o'),
(30, 'PA', 'Par&aacute;'),
(30, 'PB', 'Para&iacute;ba'),
(30, 'PI', 'Piau&iacute;'),
(30, 'SE', 'Sergipe');

#Chile
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (43, 'I', 'I Regi&oacute;n de Tarapac&aacute;'),
(43, 'II', 'II Regi&oacute;n de Antofagasta'),
(43, 'III', 'III Regi&oacute;n de Atacama'),
(43, 'IV', 'IV Regi&oacute;n de Coquimbo'),
(43, 'V', 'V Regi&oacute;n de Valapara&iacute;so'),
(43, 'RM', 'Regi&oacute;n Metropolitana'),
(43, 'VI', 'VI Regi&oacute;n de L. B. O´higgins'),
(43, 'VII', 'VII Regi&oacute;n del Maule'),
(43, 'VIII', 'VIII Regi&oacute;n del B&iacute;o B&iacute;o'),
(43, 'IX', 'IX Regi&oacute;n de la Araucan&iacute;a'),
(43, 'X', 'X Regi&oacute;n de los Lagos'),
(43, 'XI', 'XI Regi&oacute;n de Ays&eacute;n'),
(43, 'XII', 'XII Regi&oacute;n de Magallanes');

#Columbia
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (47,'AMA','Amazonas'),
(47,'ANT','Antioquia'),
(47,'ARA','Arauca'),
(47,'ATL','Atlantico'),
(47,'BOL','Bolivar'),
(47,'BOY','Boyaca'),
(47,'CAL','Caldas'),
(47,'CAQ','Caqueta'),
(47,'CAS','Casanare'),
(47,'CAU','Cauca'),
(47,'CES','Cesar'),
(47,'CHO','Choco'),
(47,'COR','Cordoba'),
(47,'CUN','Cundinamarca'),
(47,'HUI','Huila'),
(47,'GUA','Guainia'),
(47,'GUA','Guajira'),
(47,'GUV','Guaviare'),
(47,'MAG','Magdalena'),
(47,'MET','Meta'),
(47,'NAR','Narino'),
(47,'NDS','Norte de Santander'),
(47,'PUT','Putumayo'),
(47,'QUI','Quindio'),
(47,'RIS','Risaralda'),
(47,'SAI','San Andres Islas'),
(47,'SAN','Santander'),
(47,'SUC','Sucre'),
(47,'TOL','Tolima'),
(47,'VAL','Valle'),
(47,'VAU','Vaupes'),
(47,'VIC','Vichada');

#France
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (73,'Et','Etranger'),
(73,'01','Ain'),
(73,'02','Aisne'),
(73,'03','Allier'),
(73,'04','Alpes de Haute Provence'),
(73,'05','Hautes-Alpes'),
(73,'06','Alpes Maritimes'),
(73,'07','Ard&egrave;che'),
(73,'08','Ardennes'),
(73,'09','Ari&egrave;ge'),
(73,'10','Aube'),
(73,'11','Aude'),
(73,'12','Aveyron'),
(73,'13','Bouches-du-Rh&ocirc;ne'),
(73,'14','Calvados'),
(73,'15','Cantal'),
(73,'16','Charente'),
(73,'17','Charente Maritime'),
(73,'18','Cher'),
(73,'19','Corr&egrave;ze'),
(73,'2A','Corse du Sud'),
(73,'2B','Haute Corse'),
(73,'21','C&ocirc;te-d\'Or'),
(73,'22','C&ocirc;tes-d\'Armor'),
(73,'23','Creuse'),
(73,'24','Dordogne'),
(73,'25','Doubs'),
(73,'26','Dr&ocirc;me'),
(73,'27','Eure'),
(73,'28','Eure et Loir'),
(73,'29','Finist&egrave;re'),
(73,'30','Gard'),
(73,'31','Haute Garonne'),
(73,'32','Gers'),
(73,'33','Gironde'),
(73,'34','H&eacute;rault'),
(73,'35','Ille et Vilaine'),
(73,'36','Indre'),
(73,'37','Indre et Loire'),
(73,'38','Is&egrave;re'),
(73,'39','Jura'),
(73,'40','Landes'),
(73,'41','Loir et Cher'),
(73,'42','Loire'),
(73,'43','Haute Loire'),
(73,'44','Loire Atlantique'),
(73,'45','Loiret'),
(73,'46','Lot'),
(73,'47','Lot et Garonne'),
(73,'48','Loz&egrave;re'),
(73,'49','Maine et Loire'),
(73,'50','Manche'),
(73,'51','Marne'),
(73,'52','Haute Marne'),
(73,'53','Mayenne'),
(73,'54','Meurthe et Moselle'),
(73,'55','Meuse'),
(73,'56','Morbihan'),
(73,'57','Moselle'),
(73,'58','Ni&egrave;vre'),
(73,'59','Nord'),
(73,'60','Oise'),
(73,'61','Orne'),
(73,'62','Pas de Calais'),
(73,'63','Puy-de-D&ocirc;me'),
(73,'64','Pyr&eacute;n&eacute;es-Atlantiques'),
(73,'65','Hautes-Pyr&eacute;n&eacute;es'),
(73,'66','Pyr&eacute;n&eacute;es-Orientales'),
(73,'67','Bas Rhin'),
(73,'68','Haut Rhin'),
(73,'69','Rh&ocirc;ne'),
(73,'70','Haute-Sa&ocirc;ne'),
(73,'71','Sa&ocirc;ne-et-Loire'),
(73,'72','Sarthe'),
(73,'73','Savoie'),
(73,'74','Haute Savoie'),
(73,'75','Paris'),
(73,'76','Seine Maritime'),
(73,'77','Seine et Marne'),
(73,'78','Yvelines'),
(73,'79','Deux-S&egrave;vres'),
(73,'80','Somme'),
(73,'81','Tarn'),
(73,'82','Tarn et Garonne'),
(73,'83','Var'),
(73,'84','Vaucluse'),
(73,'85','Vend&eacute;e'),
(73,'86','Vienne'),
(73,'87','Haute Vienne'),
(73,'88','Vosges'),
(73,'89','Yonne'),
(73,'90','Territoire de Belfort'),
(73,'91','Essonne'),
(73,'92','Hauts de Seine'),
(73,'93','Seine St-Denis'),
(73,'94','Val de Marne'),
(73,'95','Val d\'Oise'),
(73,'971 (DOM)','Guadeloupe'),
(73,'972 (DOM)','Martinique'),
(73,'973 (DOM)','Franz&oum;sisch-Guayana'),
(73,'974 (DOM)','R&eacute;union');

#India
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (99, 'DL', 'Delhi'),
(99, 'MH', 'Maharashtra'),
(99, 'TN', 'Tamil Nadu'),
(99, 'KL', 'Kerala'),
(99, 'AP', 'Andhra Pradesh'),
(99, 'KA', 'Karnataka'),
(99, 'GA', 'Goa'),
(99, 'MP', 'Madhya Pradesh'),
(99, 'PY', 'Pondicherry'),
(99, 'GJ', 'Gujarat'),
(99, 'OR', 'Orrisa'),
(99, 'CA', 'Chhatisgarh'),
(99, 'JH', 'Jharkhand'),
(99, 'BR', 'Bihar'),
(99, 'WB', 'West Bengal'),
(99, 'UP', 'Uttar Pradesh'),
(99, 'RJ', 'Rajasthan'),
(99, 'PB', 'Punjab'),
(99, 'HR', 'Haryana'),
(99, 'CH', 'Chandigarh'),
(99, 'JK', 'Jammu & Kashmir'),
(99, 'HP', 'Himachal Pradesh'),
(99, 'UA', 'Uttaranchal'),
(99, 'LK', 'Lakshadweep'),
(99, 'AN', 'Andaman & Nicobar'),
(99, 'MG', 'Meghalaya'),
(99, 'AS', 'Assam'),
(99, 'DR', 'Dadra & Nagar Haveli'),
(99, 'DN', 'Daman & Diu'),
(99, 'SK', 'Sikkim'),
(99, 'TR', 'Tripura'),
(99, 'MZ', 'Mizoram'),
(99, 'MN', 'Manipur'),
(99, 'NL', 'Nagaland'),
(99, 'AR', 'Arunachal Pradesh');

#Italy
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (105,'AG','Agrigento'),
(105,'AL','Alessandria'),
(105,'AN','Ancona'),
(105,'AO','Aosta'),
(105,'AR','Arezzo'),
(105,'AP','Ascoli Piceno'),
(105,'AT','Asti'),
(105,'AV','Avellino'),
(105,'BA','Bari'),
(105,'BL','Belluno'),
(105,'BN','Benevento'),
(105,'BG','Bergamo'),
(105,'BI','Biella'),
(105,'BO','Bologna'),
(105,'BZ','Bolzano'),
(105,'BS','Brescia'),
(105,'BR','Brindisi'),
(105,'CA','Cagliari'),
(105,'CL','Caltanissetta'),
(105,'CB','Campobasso'),
(105,'CE','Caserta'),
(105,'CT','Catania'),
(105,'CZ','Catanzaro'),
(105,'CH','Chieti'),
(105,'CO','Como'),
(105,'CS','Cosenza'),
(105,'CR','Cremona'),
(105,'KR','Crotone'),
(105,'CN','Cuneo'),
(105,'EN','Enna'),
(105,'FE','Ferrara'),
(105,'FI','Firenze'),
(105,'FG','Foggia'),
(105,'FO','Forlì'),
(105,'FR','Frosinone'),
(105,'GE','Genova'),
(105,'GO','Gorizia'),
(105,'GR','Grosseto'),
(105,'IM','Imperia'),
(105,'IS','Isernia'),
(105,'AQ','Aquila'),
(105,'SP','La Spezia'),
(105,'LT','Latina'),
(105,'LE','Lecce'),
(105,'LC','Lecco'),
(105,'LI','Livorno'),
(105,'LO','Lodi'),
(105,'LU','Lucca'),
(105,'MC','Macerata'),
(105,'MN','Mantova'),
(105,'MS','Massa-Carrara'),
(105,'MT','Matera'),
(105,'ME','Messina'),
(105,'MI','Milano'),
(105,'MO','Modena'),
(105,'NA','Napoli'),
(105,'NO','Novara'),
(105,'NU','Nuoro'),
(105,'OR','Oristano'),
(105,'PD','Padova'),
(105,'PA','Palermo'),
(105,'PR','Parma'),
(105,'PG','Perugia'),
(105,'PV','Pavia'),
(105,'PS','Pesaro e Urbino'),
(105,'PE','Pescara'),
(105,'PC','Piacenza'),
(105,'PI','Pisa'),
(105,'PT','Pistoia'),
(105,'PN','Pordenone'),
(105,'PZ','Potenza'),
(105,'PO','Prato'),
(105,'RG','Ragusa'),
(105,'RA','Ravenna'),
(105,'RC','Reggio di Calabria'),
(105,'RE','Reggio Emilia'),
(105,'RI','Rieti'),
(105,'RN','Rimini'),
(105,'RM','Roma'),
(105,'RO','Rovigo'),
(105,'SA','Salerno'),
(105,'SS','Sassari'),
(105,'SV','Savona'),
(105,'SI','Siena'),
(105,'SR','Siracusa'),
(105,'SO','Sondrio'),
(105,'TA','Taranto'),
(105,'TE','Teramo'),
(105,'TR','Terni'),
(105,'TO','Torino'),
(105,'TP','Trapani'),
(105,'TN','Trento'),
(105,'TV','Treviso'),
(105,'TS','Trieste'),
(105,'UD','Udine'),
(105,'VA','Varese'),
(105,'VE','Venezia'),
(105,'VB','Verbania'),
(105,'VC','Vercelli'),
(105,'VR','Verona'),
(105,'VV','Vibo Valentia'),
(105,'VI','Vicenza'),
(105,'VT','Viterbo');

#Japan
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107, 'Niigata', 'Niigata'),
(107, 'Toyama', 'Toyama'),
(107, 'Ishikawa', 'Ishikawa'),
(107, 'Fukui', 'Fukui'),
(107, 'Yamanashi', 'Yamanashi'),
(107, 'Nagano', 'Nagano'),
(107, 'Gifu', 'Gifu'),
(107, 'Shizuoka', 'Shizuoka'),
(107, 'Aichi', 'Aichi'),
(107, 'Mie', 'Mie'),
(107, 'Shiga', 'Shiga'),
(107, 'Kyoto', 'Kyoto'),
(107, 'Osaka', 'Osaka'),
(107, 'Hyogo', 'Hyogo'),
(107, 'Nara', 'Nara'),
(107, 'Wakayama', 'Wakayama'),
(107, 'Tottori', 'Tottori'),
(107, 'Shimane', 'Shimane'),
(107, 'Okayama', 'Okayama'),
(107, 'Hiroshima', 'Hiroshima'),
(107, 'Yamaguchi', 'Yamaguchi'),
(107, 'Tokushima', 'Tokushima'),
(107, 'Kagawa', 'Kagawa'),
(107, 'Ehime', 'Ehime'),
(107, 'Kochi', 'Kochi'),
(107, 'Fukuoka', 'Fukuoka'),
(107, 'Saga', 'Saga'),
(107, 'Nagasaki', 'Nagasaki'),
(107, 'Kumamoto', 'Kumamoto'),
(107, 'Oita', 'Oita'),
(107, 'Miyazaki', 'Miyazaki'),
(107, 'Kagoshima', 'Kagoshima');

#Malaysia
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (129,'JOH','Johor'),
(129,'KDH','Kedah'),
(129,'KEL','Kelantan'),
(129,'KL','Kuala Lumpur'),
(129,'MEL','Melaka'),
(129,'NS','Negeri Sembilan'),
(129,'PAH','Pahang'),
(129,'PRK','Perak'),
(129,'PER','Perlis'),
(129,'PP','Pulau Pinang'),
(129,'SAB','Sabah'),
(129,'SWK','Sarawak'),
(129,'SEL','Selangor'),
(129,'TER','Terengganu'),
(129,'LAB','W.P.Labuan');

#Mexico
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (138, 'AGS', 'Aguascalientes'),
(138, 'BC', 'Baja California'),
(138, 'BCS', 'Baja California Sur'),
(138, 'CAM', 'Campeche'),
(138, 'COA', 'Coahuila'),
(138, 'COL', 'Colima'),
(138, 'CHI', 'Chiapas'),
(138, 'CHIH', 'Chihuahua'),
(138, 'DF', 'Distrito Federal'),
(138, 'DGO', 'Durango'),
(138, 'MEX', 'Estado de Mexico'),
(138, 'GTO', 'Guanajuato'),
(138, 'GRO', 'Guerrero'),
(138, 'HGO', 'Hidalgo'),
(138, 'JAL', 'Jalisco'),
(138, 'MCH', 'Michoacan'),
(138, 'MOR', 'Morelos'),
(138, 'NAY', 'Nayarit'),
(138, 'NL', 'Nuevo Leon'),
(138, 'OAX', 'Oaxaca'),
(138, 'PUE', 'Puebla'),
(138, 'QRO', 'Queretaro'),
(138, 'QR', 'Quintana Roo'),
(138, 'SLP', 'San Luis Potosi'),
(138, 'SIN', 'Sinaloa'),
(138, 'SON', 'Sonora'),
(138, 'TAB', 'Tabasco'),
(138, 'TMPS', 'Tamaulipas'),
(138, 'TLAX', 'Tlaxcala'),
(138, 'VER', 'Veracruz'),
(138, 'YUC', 'Yucatan'),
(138, 'ZAC', 'Zacatecas');

#Norway
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (160,'OSL','Oslo'),
(160,'AKE','Akershus'),
(160,'AUA','Aust-Agder'),
(160,'BUS','Buskerud'),
(160,'FIN','Finnmark'),
(160,'HED','Hedmark'),
(160,'HOR','Hordaland'),
(160,'MOR','M&oslash;re og Romsdal'),
(160,'NOR','Nordland'),
(160,'NTR','Nord-Tr&oslash;ndelag'),
(160,'OPP','Oppland'),
(160,'ROG','Rogaland'),
(160,'SOF','Sogn og Fjordane'),
(160,'STR','S&oslash;r-Tr&oslash;ndelag'),
(160,'TEL','Telemark'),
(160,'TRO','Troms'),
(160,'VEA','Vest-Agder'),
(160,'OST','&oslash;stfold'),
(160,'SVA','Svalbard');

#Pakistan
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (99, 'KHI', 'Karachi'),
(99, 'LH', 'Lahore'),
(99, 'ISB', 'Islamabad'),
(99, 'QUE', 'Quetta'),
(99, 'PSH', 'Peshawar'),
(99, 'GUJ', 'Gujrat'),
(99, 'SAH', 'Sahiwal'),
(99, 'FSB', 'Faisalabad'),
(99, 'RIP', 'Rawal Pindi');

#Romania
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (175,'AB','Alba'),
(175,'AR','Arad'),
(175,'AG','Arges'),
(175,'BC','Bacau'),
(175,'BH','Bihor'),
(175,'BN','Bistrita-Nasaud'),
(175,'BT','Botosani'),
(175,'BV','Brasov'),
(175,'BR','Braila'),
(175,'B','Bucuresti'),
(175,'BZ','Buzau'),
(175,'CS','Caras-Severin'),
(175,'CL','Calarasi'),
(175,'CJ','Cluj'),
(175,'CT','Constanta'),
(175,'CV','Covasna'),
(175,'DB','Dimbovita'),
(175,'DJ','Dolj'),
(175,'GL','Galati'),
(175,'GR','Giurgiu'),
(175,'GJ','Gorj'),
(175,'HR','Harghita'),
(175,'HD','Hunedoara'),
(175,'IL','Ialomita'),
(175,'IS','Iasi'),
(175,'IF','Ilfov'),
(175,'MM','Maramures'),
(175,'MH','Mehedint'),
(175,'MS','Mures'),
(175,'NT','Neamt'),
(175,'OT','Olt'),
(175,'PH','Prahova'),
(175,'SM','Satu-Mare'),
(175,'SJ','Salaj'),
(175,'SB','Sibiu'),
(175,'SV','Suceava'),
(175,'TR','Teleorman'),
(175,'TM','Timis'),
(175,'TL','Tulcea'),
(175,'VS','Vaslui'),
(175,'VL','Valcea'),
(175,'VN','Vrancea');

#South Africa
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (193, 'WP', 'Western Cape'),
(193, 'GP', 'Gauteng'),
(193, 'KZN', 'Kwazulu-Natal'),
(193, 'NC', 'Northern-Cape'),
(193, 'EC', 'Eastern-Cape'),
(193, 'MP', 'Mpumalanga'),
(193, 'NW', 'North-West'),
(193, 'FS', 'Free State'),
(193, 'NP', 'Northern Province');

#Turkey
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (215, 'ADANA','ADANA'),
(215, 'ADIYAMAN','ADIYAMAN'),
(215, 'AFYON','AFYON'),
(215, 'AGRI','AGRI'),
(215, 'AMASYA','AMASYA'),
(215, 'ANKARA','ANKARA'),
(215, 'ANTALYA','ANTALYA'),
(215, 'ARTVIN','ARTVIN'),
(215, 'AYDIN','AYDIN'),
(215, 'BALIKESIR','BALIKESIR'),
(215, 'BILECIK','BILECIK'),
(215, 'BINGÖL','Bingöl'),
(215, 'BITLIS','BITLIS'),
(215, 'BOLU','BOLU'),
(215, 'BURDUR','BURDUR'),
(215, 'BURSA','BURSA'),
(215, '&Ccedil;ANAKKALE','&Ccedil;ANAKKALE'),
(215, '&Ccedil;ANKIRI','&Ccedil;ANKIRI'),
(215, '&Ccedil;ORUM','&Ccedil;ORUM'),
(215, 'DENIZLI','DENIZLI'),
(215, 'DIYARBAKIR','DIYARBAKIR'),
(215, 'EDIRNE','EDIRNE'),
(215, 'ELAZIG','ELAZIG'),
(215, 'ERZINCAN','ERZINCAN'),
(215, 'ERZURUM','ERZURUM'),
(215, 'ESKISEHIR','ESKISEHIR'),
(215, 'GAZIANTEP','GAZIANTEP'),
(215, 'GIRESUN','GIRESUN'),
(215, 'GÜMÜSHANE','GÜMÜSHANE'),
(215, 'HAKKARI','HAKKARI'),
(215, 'HATAY','HATAY'),
(215, 'ISPARTA','ISPARTA'),
(215, 'I&Ccedil;EL','I&Ccedil;EL'),
(215, 'ISTANBUL','ISTANBUL'),
(215, 'IZMIR','IZMIR'),
(215, 'KARS','KARS'),
(215, 'KASTAMONU','KASTAMONU'),
(215, 'KAYSERI','KAYSERI'),
(215, 'KIRKLARELI','KIRKLARELI'),
(215, 'KIRSEHIR','KIRSEHIR'),
(215, 'KOCAELI','KOCAELI'),
(215, 'KONYA','KONYA'),
(215, 'KÜTAHYA','KÜTAHYA'),
(215, 'MALATYA','MALATYA'),
(215, 'MANISA','MANISA'),
(215, 'KAHRAMANMARAS','KAHRAMANMARAS'),
(215, 'MARDIN','MARDIN'),
(215, 'MUGLA','MUGLA'),
(215, 'MUS','MUS'),
(215, 'NEVSEHIR','NEVSEHIR'),
(215, 'NIGDE','NIGDE'),
(215, 'ORDU','ORDU'),
(215, 'RIZE','RIZE'),
(215, 'SAKARYA','SAKARYA'),
(215, 'SAMSUN','SAMSUN'),
(215, 'SIIRT','SIIRT'),
(215, 'SINOP','SINOP'),
(215, 'SIVAS','SIVAS'),
(215, 'TEKIRDAG','TEKIRDAG'),
(215, 'TOKAT','TOKAT'),
(215, 'TRABZON','TRABZON'),
(215, 'TUNCELI','TUNCELI'),
(215, 'SANLIURFA','SANLIURFA'),
(215, 'USAK','USAK'),
(215, 'VAN','VAN'),
(215, 'YOZGAT','YOZGAT'),
(215, 'ZONGULDAK','ZONGULDAK'),
(215, 'AKSARAY','AKSARAY'),
(215, 'BAYBURT','BAYBURT'),
(215, 'KARAMAN','KARAMAN'),
(215, 'KIRIKKALE','KIRIKKALE'),
(215, 'BATMAN','BATMAN'),
(215, 'SIRNAK','SIRNAK'),
(215, 'BARTIN','BARTIN'),
(215, 'ARDAHAN','ARDAHAN'),
(215, 'IGDIR','IGDIR'),
(215, 'YALOVA','YALOVA'),
(215, 'KARABÜK','KARABÜK'),
(215, 'KILIS','KILIS'),
(215, 'OSMANIYE','OSMANIYE'),
(215, 'DÜZCE','DÜZCE');

#Venezuela
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (229, 'AM', 'Amazonas'),
(229, 'AN', 'Anzo&aacute;tegui'),
(229, 'AR', 'Aragua'),
(229, 'AP', 'Apure'),
(229, 'BA', 'Barinas'),
(229, 'BO', 'Bol&iacute;var'),
(229, 'CA', 'Carabobo'),
(229, 'CO', 'Cojedes'),
(229, 'DA', 'Delta Amacuro'),
(229, 'DC', 'Distrito Capital'),
(229, 'FA', 'Falc&oacute;n'),
(229, 'GA', 'Gu&aacute;rico'),
(229, 'GU', 'Guayana'),
(229, 'LA', 'Lara'),
(229, 'ME', 'M&eacute;rida'),
(229, 'MI', 'Miranda'),
(229, 'MO', 'Monagas'),
(229, 'NE', 'Nueva Esparta'),
(229, 'PO', 'Portuguesa'),
(229, 'SU', 'Sucre'),
(229, 'TA', 'T&aacute;chira'),
(229, 'TU', 'Trujillo'),
(229, 'VA', 'Vargas'),
(229, 'YA', 'Yaracuy'),
(229, 'ZU', 'Zulia');

#UK
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (222,'AVON','Avon'),
(222,'BEDS','Bedfordshire'),
(222,'BERK','Berkshire'),
(222,'BIRM','Birmingham'),
(222,'BORD','Borders'),
(222,'BUCK','Buckinghamshire'),
(222,'CAMB','Cambridgeshire'),
(222,'CENT','Central'),
(222,'CHES','Cheshire'),
(222,'CLEV','Cleveland'),
(222,'CLWY','Clwyd'),
(222,'CORN','Cornwall'),
(222,'CUMB','Cumbria'),
(222,'DERB','Derbyshire'),
(222,'DEVO','Devon'),
(222,'DORS','Dorset'),
(222,'DUMF','Dumfries & Galloway'),
(222,'DURH','Durham'),
(222,'DYFE','Dyfed'),
(222,'ESUS','East Sussex'),
(222,'ESSE','Essex'),
(222,'FIFE','Fife'),
(222,'GLAM','Glamorgan'),
(222,'GLOU','Gloucestershire'),
(222,'GRAM','Grampian'),
(222,'GWEN','Gwent'),
(222,'GWYN','Gwynedd'),
(222,'HAMP','Hampshire'),
(222,'HERE','Hereford & Worcester'),
(222,'HERT','Hertfordshire'),
(222,'HUMB','Humberside'),
(222,'KENT','Kent'),
(222,'LANC','Lancashire'),
(222,'LEIC','Leicestershire'),
(222,'LINC','Lincolnshire'),
(222,'LOND','London'),
(222,'LOTH','Lothian'),
(222,'MANC','Manchester'),
(222,'MERS','Merseyside'),
(222,'NORF','Norfolk'),
(222,'NYOR','North Yorkshire'),
(222,'NWHI','North west Highlands'),
(222,'NHAM','Northamptonshire'),
(222,'NUMB','Northumberland'),
(222,'NOTT','Nottinghamshire'),
(222,'OXFO','Oxfordshire'),
(222,'POWY','Powys'),
(222,'SHRO','Shropshire'),
(222,'SOME','Somerset'),
(222,'SYOR','South Yorkshire'),
(222,'STAF','Staffordshire'),
(222,'STRA','Strathclyde'),
(222,'SUFF','Suffolk'),
(222,'SURR','Surrey'),
(222,'WSUS','West Sussex'),
(222,'TAYS','Tayside'),
(222,'TYWE','Tyne & Wear'),
(222,'WARW','Warwickshire'),
(222,'WISL','West Isles'),
(222,'WYOR','West Yorkshire'),
(222,'WILT','Wiltshire');

# Dumping data for table  payment_moneybookers_countries
INSERT INTO payment_moneybookers_countries VALUES (2, 'ALB'),
(3, 'ALG'), (4, 'AME'), (5, 'AND'), (6, 'AGL'), (7, 'ANG'),
(9, 'ANT'), (10, 'ARG'), (11, 'ARM'), (12, 'ARU'), (13, 'AUS'),
(14, 'AUT'), (15, 'AZE'), (16, 'BMS'), (17, 'BAH'), (18, 'BAN'),
(19, 'BAR'), (20, 'BLR'), (21, 'BGM'), (22, 'BEL'), (23, 'BEN'),
(24, 'BER'), (26, 'BOL'), (27, 'BOS'), (28, 'BOT'), (30, 'BRA'),
(32, 'BRU'), (33, 'BUL'), (34, 'BKF'), (35, 'BUR'), (36, 'CAM'),
(37, 'CMR'), (38, 'CAN'), (39, 'CAP'), (40, 'CAY'), (41, 'CEN'),
(42, 'CHA'), (43, 'CHL'), (44, 'CHN'), (47, 'COL'), (49, 'CON'),
(51, 'COS'), (52, 'COT'), (53, 'CRO'), (54, 'CUB'), (55, 'CYP'),
(56, 'CZE'), (57, 'DEN'), (58, 'DJI'), (59, 'DOM'), (60, 'DRP'),
(62, 'ECU'), (64, 'EL_'), (65, 'EQU'), (66, 'ERI'), (67, 'EST'),
(68, 'ETH'), (70, 'FAR'), (71, 'FIJ'), (72, 'FIN'), (73, 'FRA'),
(75, 'FRE'), (78, 'GAB'), (79, 'GAM'), (80, 'GEO'), (81, 'GER'),
(82, 'GHA'), (83, 'GIB'), (84, 'GRC'), (85, 'GRL'), (87, 'GDL'),
(88, 'GUM'), (89, 'GUA'), (90, 'GUI'), (91, 'GBS'), (92, 'GUY'),
(93, 'HAI'), (95, 'HON'), (96, 'HKG'), (97, 'HUN'), (98, 'ICE'),
(99, 'IND'), (101, 'IRN'), (102, 'IRA'), (103, 'IRE'), (104, 'ISR'),
(105, 'ITA'), (106, 'JAM'), (107, 'JAP'), (108, 'JOR'), (109, 'KAZ'),
(110, 'KEN'), (112, 'SKO'), (113, 'KOR'), (114, 'KUW'), (115, 'KYR'),
(116, 'LAO'), (117, 'LAT'), (141, 'MCO'), (119, 'LES'), (120, 'LIB'),
(121, 'LBY'), (122, 'LIE'), (123, 'LIT'), (124, 'LUX'), (125, 'MAC'),
(126, 'F.Y'), (127, 'MAD'), (128, 'MLW'), (129, 'MLS'), (130, 'MAL'),
(131, 'MLI'), (132, 'MLT'), (134, 'MAR'), (135, 'MRT'), (136, 'MAU'),
(138, 'MEX'), (140, 'MOL'), (142, 'MON'), (143, 'MTT'), (144, 'MOR'),
(145, 'MOZ'), (76, 'PYF'), (147, 'NAM'), (149, 'NEP'), (150, 'NED'),
(151, 'NET'), (152, 'CDN'), (153, 'NEW'), (154, 'NIC'), (155, 'NIG'),
(69, 'FLK'), (160, 'NWY'), (161, 'OMA'), (162, 'PAK'), (164, 'PAN'),
(165, 'PAP'), (166, 'PAR'), (167, 'PER'), (168, 'PHI'), (170, 'POL'),
(171, 'POR'), (172, 'PUE'), (173, 'QAT'), (175, 'ROM'), (176, 'RUS'),
(177, 'RWA'), (178, 'SKN'), (179, 'SLU'), (180, 'ST.'), (181, 'WES'),
(182, 'SAN'), (183, 'SAO'), (184, 'SAU'), (185, 'SEN'), (186, 'SEY'),
(187, 'SIE'), (188, 'SIN'), (189, 'SLO'), (190, 'SLV'), (191, 'SOL'),
(192, 'SOM'), (193, 'SOU'), (195, 'SPA'), (196, 'SRI'), (199, 'SUD'),
(200, 'SUR'), (202, 'SWA'), (203, 'SWE'), (204, 'SWI'), (205, 'SYR'),
(206, 'TWN'), (207, 'TAJ'), (208, 'TAN'), (209, 'THA'), (210, 'TOG'),
(212, 'TON'), (213, 'TRI'), (214, 'TUN'), (215, 'TUR'), (216, 'TKM'),
(217, 'TCI'), (219, 'UGA'), (231, 'BRI'), (221, 'UAE'), (222, 'GBR'),
(223, 'UNI'), (225, 'URU'), (226, 'UZB'), (227, 'VAN'), (229, 'VEN'),
(230, 'VIE'), (232, 'US_'), (235, 'YEM'), (236, 'YUG'), (238, 'ZAM'),
(239, 'ZIM');

# Dumping data for table  payment_moneybookers_currencies
INSERT INTO payment_moneybookers_currencies VALUES ('AUD', 'Australian Dollar'),
('BGN', 'Bulgarian Lev'), ('CAD', 'Canadian Dollar'), ('CHF', 'Swiss Franc'),
('CZK', 'Czech Koruna'), ('DKK', 'Danish Krone'), ('EEK', 'Estonian Koruna'),
('EUR', 'Euro'), ('GBP', 'Pound Sterling'), ('HKD', 'Hong Kong Dollar'),
('HUF', 'Forint'), ('ILS', 'Shekel'), ('ISK', 'Iceland Krona'),
('JPY', 'Yen'), ('KRW', 'South-Korean Won'), ('LVL', 'Latvian Lat'),
('MYR', 'Malaysian Ringgit'), ('NOK', 'Norwegian Krone'), ('NZD', 'New Zealand Dollar'),
('PLN', 'Zloty'), ('SEK', 'Swedish Krona'), ('SGD', 'Singapore Dollar'),
('SKK', 'Slovak Koruna'), ('THB', 'Baht'), ('TWD', 'New Taiwan Dollar'),
('USD', 'US Dollar'), ('ZAR', 'South-African Rand');

INSERT INTO commerce_seo_url_names VALUES
('', 'FILENAME_ACCOUNT', 'account.php'),
('', 'FILENAME_CHECKOUT_SHIPPING', 'checkout_shipping.php'),
('', 'FILENAME_CHECKOUT', 'checkout.php'),
('', 'FILENAME_SHOPPING_CART', 'shopping_cart.php'),
('', 'FILENAME_SPECIALS', 'specials.php'),
('', 'FILENAME_PRODUCTS_NEW', 'products_new.php'),
('', 'FILENAME_ADVANCED_SEARCH', 'advanced_search.php'),
('', 'FILENAME_LOGIN', 'login.php'),
('', 'FILENAME_LOGOFF', 'logoff.php'),
('', 'FILENAME_PASSWORD_DOUBLE_OPT', 'password_double_opt.php'),
('', 'FILENAME_WISH_LIST', 'wish_list.php'),
('', 'FILENAME_NEWSLETTER', 'newsletter.php'),
('', 'FILENAME_ACCOUNT_EDIT', 'account_edit.php'),
('', 'FILENAME_ADDRESS_BOOK', 'address_book.php'),
('', 'FILENAME_CHECKOUT_CONFIRMATION', 'checkout_confirmation.php'),
('', 'FILENAME_CHECKOUT_PAYMENT', 'checkout_payment.php'),
('', 'FILENAME_CHECKOUT_PAYMENT_ADDRESS', 'checkout_payment_address.php'),
('', 'FILENAME_CHECKOUT_SHIPPING_ADDRESS', 'checkout_shipping_address.php'),
('', 'FILENAME_CHECKOUT_SUCCESS', 'checkout_success.php'),
('', 'FILENAME_CREATE_ACCOUNT', 'create_account.php'),
('', 'FILENAME_DOWNLOAD', 'download.php'),
('', 'FILENAME_PRINT_PDF', 'print_pdf.php'),
('', 'FILENAME_POPUP_CONTENT', 'popup_content.php'),
('', 'FILENAME_REVIEWS', 'reviews.php'),
('', 'FILENAME_POPUP_SEARCH_HELP', 'popup_search_help.php'),
('', 'FILENAME_PRODUCT_REVIEWS', 'product_reviews.php'),
('', 'FILENAME_PRODUCT_REVIEWS_INFO', 'product_reviews_info.php'),
('', 'FILENAME_PRODUCT_REVIEWS_WRITE', 'product_reviews_write.php'),
('', 'FILENAME_ACCOUNT_HISTORY', 'account_history.php'),
('', 'FILENAME_PRINT_PRODUCT_INFO', 'print_product_info.php');

INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('1','1','TEXT_PDF_HEADER','Shopname und kurzer Slogan','input');
INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('2','1','TEXT_PDF_ANSCHRIFT','Anschrift:\r\nMax Mustermann\r\nStrasse 12\r\n12345 Stadt\r\nDeutschland','textarea');
INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('3','1','TEXT_PDF_KONTAKT','Kontakt:\r\ninfo@AdresseDesShops.de','textarea');
INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('4','1','TEXT_PDF_BANK','Bankverbindung:\r\nInhaber: Max Mustermann\r\nKonto: 123456789  BLZ: 250 501 10\r\nBank: Deutsche Bank  BIC/Swift: XXXXXXX\r\nIBAN: XXXXXXX','textarea');
INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('5','1','TEXT_PDF_GESCHAEFT','Inhaber:\r\nMax Mustermann\r\nUSt.IdNr.: DE12356789','textarea');
INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('6','1','TEXT_PDF_SHOPADRESSEKLEIN','AdresseDesShops.de - Max Mustermann - Strasse 12, 12345 Stadt','input');
INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('7','1','TEXT_PDF_DANKE_MANN','Sehr geehrter Herr %s,\r\nwir freuen uns, dass Sie bei XXXX bestellt haben.','textarea');
INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('8','1','TEXT_PDF_DANKE_FRAU','Sehr geehrte Frau %s,\r\nwir freuen uns, dass Sie bei XXXX bestellt haben.','textarea');
INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('9','1','TEXT_PDF_DANKE_UNISEX','Sehr geehrter Kunde / sehr geehrte Kundin,\r\nwir freuen uns, dass Sie bei XXXX bestellt haben.','textarea');
INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('10','1','TEXT_PDF_SCHLUSSTEXT','Vielen Dank für Ihren Auftrag!\r\n\r\nBesuchen Sie uns wieder unter XXXX!\r\n\r\n\r\nLeistungsdatum entspricht Rechnungsdatum.\r\nEs gelten unsere Allgemeine Geschäfts- und Lieferbedingungen.','textarea');
INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('11','1','TEXT_PDF_FILE_NAME','Rechnung_Nr#rn#','input');
INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('12','1','TEXT_PDF_DELIVERY_SCHLUSSTEXT','Vielen Dank für Ihren Auftrag. Ihre Ware wurde mit #vm# versendet.','textarea');
INSERT INTO orders_pdf_profile (id,languages_id,pdf_key,pdf_value,type) VALUES ('13','1','TEXT_PDF_DELIVERY_FILE_NAME','Lieferschein_#bn#_#vn#_#nn#_#d#','input');


INSERT INTO blog_settings VALUES (NULL, 'social', 'ja');
INSERT INTO blog_settings VALUES (NULL, 'comments', 'ja');
INSERT INTO blog_settings VALUES (NULL, 'rate', 'nein');
INSERT INTO blog_settings VALUES (NULL, 'register_user', 'ja');
INSERT INTO blog_settings VALUES (NULL, 'session_rate', 'ja');
INSERT INTO blog_settings VALUES (NULL, 'blog_nav_ajax', 'nein');
INSERT INTO blog_settings VALUES (NULL, 'blog_captcha', 'nein');

INSERT INTO configuration (configuration_id,  configuration_key, configuration_value, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES   ('', '_PAYMENT_MONEYBOOKERS_EMAILID', '',  31, 1, NULL, '', NULL, NULL);
INSERT INTO configuration (configuration_id,  configuration_key, configuration_value, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES   ('', '_PAYMENT_MONEYBOOKERS_PWD','',  31, 2, NULL, '', NULL, NULL);
INSERT INTO configuration (configuration_id,  configuration_key, configuration_value, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES   ('', '_PAYMENT_MONEYBOOKERS_MERCHANTID','',  31, 3, NULL, '', NULL, NULL);
INSERT INTO configuration (configuration_id,  configuration_key, configuration_value, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES   ('', '_PAYMENT_MONEYBOOKERS_TMP_STATUS_ID','0',  31, 4, NULL, '', 'xtc_get_order_status_name' , 'xtc_cfg_pull_down_order_statuses(');
INSERT INTO configuration (configuration_id,  configuration_key, configuration_value, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES   ('', '_PAYMENT_MONEYBOOKERS_PROCESSED_STATUS_ID','0',  31, 5, NULL, '','xtc_get_order_status_name' , 'xtc_cfg_pull_down_order_statuses(');
INSERT INTO configuration (configuration_id,  configuration_key, configuration_value, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES   ('', '_PAYMENT_MONEYBOOKERS_PENDING_STATUS_ID','0',  31, 6, NULL, '', 'xtc_get_order_status_name' , 'xtc_cfg_pull_down_order_statuses(');
INSERT INTO configuration (configuration_id,  configuration_key, configuration_value, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES   ('', '_PAYMENT_MONEYBOOKERS_CANCELED_STATUS_ID','0',  31, 7, NULL, '', 'xtc_get_order_status_name' , 'xtc_cfg_pull_down_order_statuses(');


