<?php
/* -----------------------------------------------------------------
* 	ID:						$Id: orders_edit.php 59 2011-02-24 18:44:52Z siekiera $
* 	Letzter Stand:			$Revision: 59 $
* 	zuletzt geändert von: 	$Author: siekiera $
* 	Datum:					$Date: 2011-02-24 19:44:52 +0100 (Do, 24. Feb 2011) $
*
* 	commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
*
* 	Copyright (c) since 2010 commerce:SEO
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
*
* 	Released under the GNU General Public License
* --------------------------------------------------------------- */

require('includes/application_top.php');

require(DIR_WS_CLASSES.'order.php');
if(!$_GET['oID'])
	$_GET['oID'] = $_POST['oID'];

$order = new order($_GET['oID']);

require (DIR_FS_CATALOG.DIR_WS_CLASSES.'xtcPrice.php');
$xtPrice = new xtcPrice($order->info['currency'], $order->info['status']);

require_once (DIR_FS_INC.'xtc_get_tax_class_id.inc.php');
require_once (DIR_FS_INC.'xtc_get_tax_rate.inc.php');

require_once (DIR_FS_INC.'xtc_oe_get_options_name.inc.php');
require_once (DIR_FS_INC.'xtc_oe_get_options_values_name.inc.php');
require_once (DIR_FS_INC.'xtc_oe_customer_infos.inc.php');

switch ($_GET['action']) {
	case 'address_edit' : // Adressbearbeitung
		$lang_query = xtc_db_query("select languages_id from ".TABLE_LANGUAGES." where directory = '".$order->info['language']."'");
		$lang = xtc_db_fetch_array($lang_query);

		$status_query = xtc_db_query("select customers_status_name from ".TABLE_CUSTOMERS_STATUS." where customers_status_id = '".$_POST['customers_status']."' and language_id = '".$lang['languages_id']."' ");
		$status = xtc_db_fetch_array($status_query);

		$sql_data_array = array('customers_vat_id' => xtc_db_prepare_input($_POST['customers_vat_id']),
								'customers_status' => xtc_db_prepare_input($_POST['customers_status']),
								'customers_status_name' => xtc_db_prepare_input($status['customers_status_name']),
								'customers_company' => xtc_db_prepare_input($_POST['customers_company']),
								'customers_name' => xtc_db_prepare_input($_POST['customers_name']),
								'customers_street_address' => xtc_db_prepare_input($_POST['customers_street_address']),
								'customers_suburb' => xtc_db_prepare_input($_POST['customers_suburb']),
								'customers_city' => xtc_db_prepare_input($_POST['customers_city']),
								'customers_postcode' => xtc_db_prepare_input($_POST['customers_postcode']),
								'customers_country' => xtc_db_prepare_input($_POST['customers_country']),
								'customers_telephone' => xtc_db_prepare_input($_POST['customers_telephone']),
								'customers_email_address' => xtc_db_prepare_input($_POST['customers_email_address']),
								'delivery_company' => xtc_db_prepare_input($_POST['delivery_company']),
								'delivery_name' => xtc_db_prepare_input($_POST['delivery_name']),
								'delivery_street_address' => xtc_db_prepare_input($_POST['delivery_street_address']),
								'delivery_suburb' => xtc_db_prepare_input($_POST['delivery_suburb']),
								'delivery_city' => xtc_db_prepare_input($_POST['delivery_city']),
								'delivery_postcode' => xtc_db_prepare_input($_POST['delivery_postcode']),
								'delivery_country' => xtc_db_prepare_input($_POST['delivery_country']),
								'billing_company' => xtc_db_prepare_input($_POST['billing_company']),
								'billing_name' => xtc_db_prepare_input($_POST['billing_name']),
								'billing_street_address' => xtc_db_prepare_input($_POST['billing_street_address']),
								'billing_suburb' => xtc_db_prepare_input($_POST['billing_suburb']),
								'billing_city' => xtc_db_prepare_input($_POST['billing_city']),
								'billing_postcode' => xtc_db_prepare_input($_POST['billing_postcode']),
								'billing_country' => xtc_db_prepare_input($_POST['billing_country']));

		$update_sql_data = array ('last_modified' => 'now()');
		$sql_data_array = xtc_array_merge($sql_data_array, $update_sql_data);
		xtc_db_perform(TABLE_ORDERS, $sql_data_array, 'update', 'orders_id = \''.xtc_db_input($_POST['oID']).'\'');

		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=address&oID='.$_POST['oID']));
		break;

	case 'product_edit' : // Artikel bearbeiten
		$status = xtc_db_fetch_array(xtc_db_query("select customers_status_show_price_tax from ".TABLE_CUSTOMERS_STATUS." where customers_status_id = '".$order->info['status']."'"));

		if(STOCK_LIMITED == 'true') {
		    $old_quantity = xtc_db_fetch_array(xtc_db_query('SELECT products_quantity FROM ' . TABLE_ORDERS_PRODUCTS . ' WHERE orders_products_id=' . (int)xtc_db_input($_POST['opID']))); // 4

		    if(STOCK_ALLOW_CHECKOUT == 'false') {
		        $current_stock = xtc_db_fetch_array(xtc_db_query('SELECT products_quantity FROM ' . TABLE_PRODUCTS . ' WHERE products_id=' . (int)xtc_db_prepare_input($_POST['products_id'])));

		        if(($current_stock['products_quantity'] + $old_quantity['products_quantity']) < $_POST['products_quantity'])
		            $_POST['products_quantity'] = $current_stock['products_quantity'] + $old_quantity['products_quantity'];

		    }

		    $new_quantity = $_POST['products_quantity'] - $old_quantity['products_quantity'];
		    xtc_db_query('UPDATE ' . TABLE_PRODUCTS . ' SET products_quantity=products_quantity-' . $new_quantity . ' WHERE products_id=' . (int)xtc_db_prepare_input($_POST['products_id']));

		    if (($current_stock['products_quantity'] - $new_quantity) <= 0 && STOCK_ALLOW_CHECKOUT == 'false')
		        xtc_db_query("update ".TABLE_PRODUCTS." set products_status = 0 where products_id = " . (int)xtc_db_prepare_input($_POST['products_id']));

		    elseif (($current_stock['products_quantity'] - $new_quantity) > 0 && STOCK_ALLOW_CHECKOUT == 'false')
		        xtc_db_query("update ".TABLE_PRODUCTS." set products_status = 1 where products_id = " . (int)xtc_db_prepare_input($_POST['products_id']));
		}


		$final_price = $_POST['products_price'] * $_POST['products_quantity'];

		$sql_data_array = array('orders_id' => xtc_db_prepare_input($_POST['oID']),
								'products_id' => xtc_db_prepare_input($_POST['products_id']),
								'products_name' => xtc_db_prepare_input($_POST['products_name']),
								'products_price' => xtc_db_prepare_input($_POST['products_price']),
								'products_discount_made' => '',
								'final_price' => xtc_db_prepare_input($final_price),
								'products_tax' => xtc_db_prepare_input($_POST['products_tax']),
								'products_quantity' => xtc_db_prepare_input($_POST['products_quantity']),
								'allow_tax' => xtc_db_prepare_input($status['customers_status_show_price_tax']));

		$update_sql_data = array ('products_model' => xtc_db_prepare_input($_POST['products_model']));
		$sql_data_array = xtc_array_merge($sql_data_array, $update_sql_data);
		xtc_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array, 'update', 'orders_products_id = \''.xtc_db_input($_POST['opID']).'\'');

		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=products&oID='.$_POST['oID']));
		break;

	case 'product_ins' : // Artikel einfügen

		$status = xtc_db_fetch_array(xtc_db_query("select customers_status_show_price_tax from ".TABLE_CUSTOMERS_STATUS." where customers_status_id = '".$order->info['status']."'"));

		if(STOCK_LIMITED == 'true') {
		    if(STOCK_ALLOW_CHECKOUT == 'false') {
		        $current_stock = xtc_db_fetch_array(xtc_db_query("SELECT products_quantity FROM " . TABLE_PRODUCTS . " WHERE products_id='" . (int)xtc_db_prepare_input($_POST['products_id'])."'"));

		        if($current_stock['products_quantity'] < $_POST['products_quantity'])
		            $_POST['products_quantity'] = $current_stock['products_quantity'];
		    }
		    $new_quantity = $_POST['products_quantity'];
		    xtc_db_query("UPDATE " . TABLE_PRODUCTS . " SET products_quantity=products_quantity-" . $_POST['products_quantity'] . " WHERE products_id='" . (int)xtc_db_prepare_input($_POST['products_id'])."'");

		    if($current_stock['products_quantity'] == $new_quantity && STOCK_ALLOW_CHECKOUT == 'false')
		        xtc_db_query("UPDATE ".TABLE_PRODUCTS." SET products_status = 0 WHERE products_id = '" . (int)xtc_db_prepare_input($_POST['products_id'])."'");
		}


		$product = xtc_db_fetch_array(xtc_db_query("SELECT
														p.products_model,
														p.products_tax_class_id,
														p.products_quantity,
														pd.products_name
													FROM
														".TABLE_PRODUCTS." p,
														".TABLE_PRODUCTS_DESCRIPTION." pd
													WHERE
														p.products_id = '".$_POST['products_id']."'
													AND
														pd.products_id = p.products_id
													AND
														pd.language_id = '".$_SESSION['languages_id']."'"));


		$c_info = xtc_oe_customer_infos($order->customer['ID']);
		$tax_rate = xtc_get_tax_rate($product['products_tax_class_id'], $c_info['country_id'], $c_info['zone_id']);

		$price = $xtPrice->xtcGetPrice($_POST['products_id'], false, $_POST['products_quantity'], $product['products_tax_class_id'], '', '', $order->customer['ID']);

		$final_price = $price * $_POST['products_quantity'];

		$sql_data_array = array('orders_id' => xtc_db_prepare_input($_POST['oID']),
								'products_id' => xtc_db_prepare_input($_POST['products_id']),
								'products_name' => xtc_db_prepare_input($product['products_name']),
								'products_price' => xtc_db_prepare_input($price),
								'products_discount_made' => '',
								'final_price' => xtc_db_prepare_input($final_price),
								'products_tax' => xtc_db_prepare_input($tax_rate),
								'products_quantity' => $_POST['products_quantity'],
								'allow_tax' => xtc_db_prepare_input($status['customers_status_show_price_tax']));

		$insert_sql_data = array ('products_model' => xtc_db_prepare_input($product['products_model']));
		$sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
		xtc_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array);




		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=products&oID='.$_POST['oID']));
		break;

	case 'save_order' :
		// Errechne neue Zwischensumme für Artikel Anfang
		$products = xtc_db_fetch_array(xtc_db_query("SELECT
														SUM(final_price) AS subtotal_final
													FROM
														".TABLE_ORDERS_PRODUCTS."
													WHERE
														orders_id = '".$_POST['oID']."' "));
		$subtotal_text = $xtPrice->xtcFormat($products['subtotal_final'], true);
		$subtotal_text = str_replace("'", "",$subtotal_text);

		xtc_db_query("UPDATE
							".TABLE_ORDERS_TOTAL."
						SET
							text = '".$subtotal_text."',
							value = '".$products['subtotal_final']."'
						WHERE
							orders_id = '".$_POST['oID']."'
						AND
							class = 'ot_subtotal' ");
		// Errechne neue Zwischensumme für Artikel Ende

		// Errechne neue Netto Zwischensumme für Artikel Anfang
		$check_no_tax_value = xtc_db_fetch_array(xtc_db_query("SELECT 
																	COUNT(*) AS count 
																FROM 
																	".TABLE_ORDERS_TOTAL." 
																WHERE 
																	orders_id = '".$_POST['oID']."' 
																AND 
																	class = 'ot_subtotal_no_tax'"));

		if ($check_no_tax_value['count'] != '0') {
			$subtotal_no_tax_value = xtc_db_fetch_array(xtc_db_query("SELECT
																		SUM(value) AS subtotal_no_tax_value
																	FROM
																		".TABLE_ORDERS_TOTAL."
																	WHERE
																		orders_id = '".$_POST['oID']."'
																	AND
																		class != 'ot_tax'
																	AND
																		class != 'ot_total'
																	AND
																		class != 'ot_subtotal_no_tax'
																	AND
																		class != 'ot_total_netto'
																	AND
																		class != 'ot_coupon'
																	AND
																		class != 'ot_gv'"));
			$subtotal_no_tax_text = $xtPrice->xtcFormat($subtotal_no_tax_value['subtotal_no_tax_value'], true);
			xtc_db_query("UPDATE
								".TABLE_ORDERS_TOTAL."
							SET
								text = '".$subtotal_no_tax_text."',
								value = '".$subtotal_no_tax_value['subtotal_no_tax_value']."'
							WHERE
								orders_id = '".$_POST['oID']."'
							AND
								class = 'ot_subtotal_no_tax' ");
		}  
		// Errechne neue Netto Zwischensumme für Artikel Anfang



		// Errechne neue MwSt. für die Bestellung Anfang
		// Produkte
		$products_query = xtc_db_query("SELECT
											final_price,
											products_tax,
											allow_tax
										FROM
											".TABLE_ORDERS_PRODUCTS."
										WHERE
											orders_id = '".$_POST['oID']."' ");

		while($products = xtc_db_fetch_array($products_query)) {

			$tax_rate = $products['products_tax'];
			$multi = (($products['products_tax'] / 100) + 1);

			if ($products['allow_tax'] == '1') {
				$bprice = $products['final_price'];
				$nprice = $xtPrice->xtcRemoveTax($bprice, $tax_rate);
				$tax = $xtPrice->calcTax($nprice, $tax_rate);
			} else {
				$nprice = $products['final_price'];
				$bprice = $xtPrice->xtcAddTax($nprice, $tax_rate);
				$tax = $xtPrice->calcTax($nprice, $tax_rate);
			}

			$sql_data_array = array('orders_id' => xtc_db_prepare_input($_POST['oID']),
									'n_price' => xtc_db_prepare_input($nprice),
									'b_price' => xtc_db_prepare_input($bprice),
									'tax' => xtc_db_prepare_input($tax),
									'tax_rate' => xtc_db_prepare_input($products['products_tax']));

			$insert_sql_data = array ('class' => 'products');
			$sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
			xtc_db_perform(TABLE_ORDERS_RECALCULATE, $sql_data_array);
		}
		// Produkte Ende


		
		// Module Anfang
	   $status = xtc_db_fetch_array(xtc_db_query("SELECT
					   									customers_status_show_price_tax,
					   									customers_status_add_tax_ot
					   								FROM
					   									".TABLE_CUSTOMERS_STATUS."
					   								WHERE
					   									customers_status_id = '".$order->info['status']."'"));

		$module_query = xtc_db_query("SELECT
											value, class
										FROM
											".TABLE_ORDERS_TOTAL."
										WHERE
											orders_id = '".$_POST['oID']."'
										AND
											class!='ot_total'
										AND
											class!='ot_subtotal_no_tax'
										AND
											class!='ot_tax'
										AND
											class!='ot_subtotal'");

		while ($module_value = xtc_db_fetch_array($module_query)) {
			$module_name = str_replace('ot_', '', $module_value['class']);

			if ($module_name != 'discount') {
				if ($module_name != 'shipping') {
					$module_tax_class = constant(MODULE_ORDER_TOTAL_.strtoupper($module_name)._TAX_CLASS);
				} else {
					$module_tmp_name = explode('_', $order->info['shipping_class']);
					$module_tmp_name = $module_tmp_name[0];
					if ($module_tmp_name != 'selfpickup' && $module_tmp_name != 'free') {
						$module_tax_class = constant(MODULE_SHIPPING_.strtoupper($module_tmp_name)._TAX_CLASS);
					} else {
						$module_tax_class = '0';
					}
				}
			} else {
				$module_tax_class = '0';
			}

			$cinfo = xtc_oe_customer_infos($order->customer['ID']);
			$module_tax_rate = xtc_get_tax_rate($module_tax_class, $cinfo['country_id'], $cinfo['zone_id']);

			if ($status['customers_status_show_price_tax'] == 1) {
				$module_b_price = $module_value['value'];
	            if ($module_tax_class == '0') {
					$module_n_price = $module_value['value'];
				} else {
					$module_n_price = $xtPrice->xtcRemoveTax($module_b_price, $module_tax_rate);
				}
				$module_tax = $xtPrice->calcTax($module_n_price, $module_tax_rate);
			} elseif ($status['customers_status_add_tax_ot'] == 1) {
				$module_b_price = $module_value['value'];
	            if ($module_tax_class == '1') {
					$module_n_price = $module_value['value'];
				} else {
					$module_n_price = $xtPrice->xtcRemoveTax($module_b_price, $module_tax_rate);
				}
				$module_tax = $xtPrice->calcTax($module_n_price, $module_tax_rate);	
			} else {
				$module_n_price = $module_value['value'];
				$module_b_price = $xtPrice->xtcAddTax($module_n_price, $module_tax_rate);
				$module_tax = $xtPrice->calcTax($module_n_price, $module_tax_rate);
			}

			$sql_data_array = array('orders_id' => xtc_db_prepare_input($_POST['oID']),
									'n_price' => xtc_db_prepare_input($module_n_price),
									'b_price' => xtc_db_prepare_input($module_b_price),
									'tax' => xtc_db_prepare_input($module_tax),
									'tax_rate' => xtc_db_prepare_input($module_tax_rate));

			$insert_sql_data = array ('class' => $module_value['class']);
			$sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
			xtc_db_perform(TABLE_ORDERS_RECALCULATE, $sql_data_array);
		}

		xtc_db_query("DELETE FROM ".TABLE_ORDERS_TOTAL." WHERE orders_id = '".xtc_db_input($_POST['oID'])."' AND class = 'ot_tax'");

		// Neue Mwst. zusammenrechnen Anfang
	    $ust_query = xtc_db_query("SELECT
	    								tax_rate,
	    								SUM(tax) AS tax_value_new
	    							FROM
	    								".TABLE_ORDERS_RECALCULATE."
	    							WHERE
	    								orders_id = '".$_POST['oID']."'
	    							AND
	    								tax !='0'
	    							GROUP BY
	    								tax_rate ");

		while($ust = xtc_db_fetch_array($ust_query)) {
			$ust_desc = xtc_db_fetch_array(xtc_db_query("SELECT
															tax_description
														FROM
															".TABLE_TAX_RATES."
														WHERE
															tax_rate = '".$ust['tax_rate']."'"));

			$title = $ust_desc['tax_description'];

			if ($ust['tax_value_new']) {
				$text = $xtPrice->xtcFormat($ust['tax_value_new'], true);

				$sql_data_array = array('orders_id' => xtc_db_prepare_input($_POST['oID']),
										'title' => xtc_db_prepare_input($title),
										'text' => xtc_db_prepare_input($text),
										'value' => xtc_db_prepare_input($ust['tax_value_new']),
										'class' => 'ot_tax',
							            'sort_order' => MODULE_ORDER_TOTAL_TAX_SORT_ORDER);

				xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);

			}
		}
		

		// Errechne neue Zwischensumme für Artikel Anfang
		   $status = xtc_db_fetch_array(xtc_db_query("SELECT
														customers_status_show_price_tax,
														customers_status_add_tax_ot
													FROM
														".TABLE_CUSTOMERS_STATUS."
													WHERE
														customers_status_id = '".$order->info['status']."'"));			
		if ($status['customers_status_add_tax_ot'] == 1) {
			
			$subtotal = xtc_db_fetch_array(xtc_db_query("SELECT
																SUM(value) AS value
															FROM
																".TABLE_ORDERS_TOTAL."
															WHERE
																orders_id = '".$_POST['oID']."'
															AND
																class != 'ot_subtotal_no_tax'
															AND
																class != 'ot_total'
															AND
																class != 'ot_total_netto'
														"));

			$subtotal_text = $xtPrice->xtcFormat($subtotal['value'], true);
			$subtotal_text = str_replace("'", "",$subtotal_text);
			#print_r ($subtotal_text);die;

			xtc_db_query("UPDATE
								".TABLE_ORDERS_TOTAL."
							SET
								text = '".$subtotal_text."',
								value = '".$subtotal['value']."'
							WHERE
								orders_id = '".$_POST['oID']."'
							AND
								class = 'ot_total'");
	
		} else {
			$subtotal = xtc_db_fetch_array(xtc_db_query("SELECT
																SUM(value) AS value
															FROM
																".TABLE_ORDERS_TOTAL."
															WHERE
																orders_id = '".$_POST['oID']."'
															AND
																class != 'ot_subtotal_no_tax'
															AND
																class != 'ot_total_netto'
															AND
																class != 'ot_tax'
															AND
																class != 'ot_total'"));

			$subtotal_text = $xtPrice->xtcFormat($subtotal['value'], true);
			$subtotal_text = str_replace("'", "",$subtotal_text);
			xtc_db_query("UPDATE
								".TABLE_ORDERS_TOTAL."
							SET
								text = '".$subtotal_text."',
								value = '".$subtotal['value']."'
							WHERE
								orders_id = '".$_POST['oID']."'
							AND
								class = 'ot_total'");
		}

		// Errechne neue Zwischensumme für Artikel Ende		
		xtc_db_query("DELETE FROM ".TABLE_ORDERS_RECALCULATE." where orders_id = '".xtc_db_input($_POST['oID'])."'");

		xtc_redirect(xtc_href_link(FILENAME_ORDERS, 'action=edit&oID='.$_POST['oID']));
		break;

	case 'product_option_edit' : // Produkt Optionen bearbeiten
		$sql_data_array = array ('products_options' => xtc_db_prepare_input($_POST['products_options']), 'products_options_values' => xtc_db_prepare_input($_POST['products_options_values']), 'options_values_price' => xtc_db_prepare_input($_POST['options_values_price']));

		$update_sql_data = array ('price_prefix' => xtc_db_prepare_input($_POST['prefix']));
		$sql_data_array = xtc_array_merge($sql_data_array, $update_sql_data);
		xtc_db_perform(TABLE_ORDERS_PRODUCTS_ATTRIBUTES, $sql_data_array, 'update', 'orders_products_attributes_id = \''.xtc_db_input($_POST['opAID']).'\'');

		$products_query = xtc_db_query("select op.products_id, op.products_quantity, p.products_tax_class_id from ".TABLE_ORDERS_PRODUCTS." op, ".TABLE_PRODUCTS." p where op.orders_products_id = '".$_POST['opID']."' and op.products_id = p.products_id");
		$products = xtc_db_fetch_array($products_query);

		$products_a_query = xtc_db_query("select options_values_price, price_prefix from ".TABLE_ORDERS_PRODUCTS_ATTRIBUTES." where orders_products_id = '".$_POST['opID']."'");
		while ($products_a = xtc_db_fetch_array($products_a_query)) {
			$ov_price += $products_a['price_prefix'].$products_a['options_values_price'];
		};

		$products_old_price = $xtPrice->xtcGetPrice($products['products_id'], $format = false, $products['products_quantity'], '', '', '', $order->customer['ID']);

		$options_values_price = ($ov_price.$_POST['prefix'].$_POST['options_values_price']);
		$products_price = ($products_old_price + $options_values_price);

		$price = $xtPrice->xtcGetPrice($products['products_id'], false, $products['products_quantity'], $products['products_tax_class_id'], $products_price, '', $order->customer['ID']);

		$final_price = $price * $products['products_quantity'];

		$sql_data_array = array ('products_price' => xtc_db_prepare_input($price));
		$update_sql_data = array ('final_price' => xtc_db_prepare_input($final_price));
		$sql_data_array = xtc_array_merge($sql_data_array, $update_sql_data);
		xtc_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array, 'update', 'orders_products_id = \''.xtc_db_input($_POST['opID']).'\'');

		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=options&oID='.$_POST['oID'].'&pID='.$products['products_id'].'&opID='.$_POST['opID']));
		break;

	case 'product_option_ins' : // Produkt Optionen einfügen
		$products_attributes_query = xtc_db_query("select options_id, options_values_id, options_values_price, price_prefix from ".TABLE_PRODUCTS_ATTRIBUTES." where products_attributes_id = '".$_POST['aID']."'");
		$products_attributes = xtc_db_fetch_array($products_attributes_query);

		$products_options_query = xtc_db_query("select products_options_name from ".TABLE_PRODUCTS_OPTIONS." where products_options_id = '".$products_attributes['options_id']."' and language_id = '".$_SESSION['languages_id']."'");
		$products_options = xtc_db_fetch_array($products_options_query);

		$products_options_values_query = xtc_db_query("select products_options_values_name from ".TABLE_PRODUCTS_OPTIONS_VALUES." where products_options_values_id = '".$products_attributes['options_values_id']."' and language_id = '".$_SESSION['languages_id']."'");
		$products_options_values = xtc_db_fetch_array($products_options_values_query);

		$sql_data_array = array ('orders_id' => xtc_db_prepare_input($_POST['oID']), 'orders_products_id' => xtc_db_prepare_input($_POST['opID']), 'products_options' => xtc_db_prepare_input($products_options['products_options_name']), 'products_options_values' => xtc_db_prepare_input($products_options_values['products_options_values_name']), 'options_values_price' => xtc_db_prepare_input($products_attributes['options_values_price']));

		$insert_sql_data = array ('price_prefix' => xtc_db_prepare_input($products_attributes['price_prefix']));
		$sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
		xtc_db_perform(TABLE_ORDERS_PRODUCTS_ATTRIBUTES, $sql_data_array);

		$products_query = xtc_db_query("select op.products_id, op.products_quantity, p.products_tax_class_id from ".TABLE_ORDERS_PRODUCTS." op, ".TABLE_PRODUCTS." p where op.orders_products_id = '".$_POST['opID']."' and op.products_id = p.products_id");
		$products = xtc_db_fetch_array($products_query);

		$products_a_query = xtc_db_query("select options_values_price, price_prefix from ".TABLE_ORDERS_PRODUCTS_ATTRIBUTES." where orders_products_id = '".$_POST['opID']."'");
		while ($products_a = xtc_db_fetch_array($products_a_query)) {
			$options_values_price += $products_a['price_prefix'].$products_a['options_values_price'];
		};

		if (DOWNLOAD_ENABLED == 'true') {
			$attributes_query = "select popt.products_options_name,
	                               poval.products_options_values_name,
	                               pa.options_values_price,
	                               pa.price_prefix,

	                               pad.products_attributes_maxdays,
	                               pad.products_attributes_maxcount,
	                               pad.products_attributes_filename
	                               from ".TABLE_PRODUCTS_OPTIONS." popt, ".TABLE_PRODUCTS_OPTIONS_VALUES." poval, ".TABLE_PRODUCTS_ATTRIBUTES." pa
	                               left join ".TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD." pad
	                                on pa.products_attributes_id=pad.products_attributes_id
	                               where pa.products_id = '".$products['products_id']."'
	                                and pa.options_id = '".$products_attributes['options_id']."'
	                                and pa.options_id = popt.products_options_id
	                                and pa.options_values_id = '".$products_attributes['options_values_id']."'
	                                and pa.options_values_id = poval.products_options_values_id
	                                and popt.language_id = '".$_SESSION['languages_id']."'
	                                and poval.language_id = '".$_SESSION['languages_id']."'";
			$attributes = xtc_db_query($attributes_query);

			$attributes_values = xtc_db_fetch_array($attributes);

			if (isset ($attributes_values['products_attributes_filename']) && xtc_not_null($attributes_values['products_attributes_filename'])) {
				$sql_data_array = array ('orders_id' => xtc_db_prepare_input($_POST['oID']), 'orders_products_id' => xtc_db_prepare_input($_POST['opID']), 'orders_products_filename' => $attributes_values['products_attributes_filename'], 'download_maxdays' => $attributes_values['products_attributes_maxdays'], 'download_count' => $attributes_values['products_attributes_maxcount']);

				xtc_db_perform(TABLE_ORDERS_PRODUCTS_DOWNLOAD, $sql_data_array);
			}

		}

		$products_old_price = $xtPrice->xtcGetPrice($products['products_id'], $format = false, $products['products_quantity'], '', '', '', $order->customer['ID']);

		$products_price = ($products_old_price + $options_values_price);

		$price = $xtPrice->xtcGetPrice($products['products_id'], $format = false, $products['products_quantity'], $products['products_tax_class_id'], $products_price, '', $order->customer['ID']);

		$final_price = $price * $products['products_quantity'];

		$sql_data_array = array ('products_price' => xtc_db_prepare_input($price));
		$update_sql_data = array ('final_price' => xtc_db_prepare_input($final_price));
		$sql_data_array = xtc_array_merge($sql_data_array, $update_sql_data);
		xtc_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array, 'update', 'orders_products_id = \''.xtc_db_input($_POST['opID']).'\'');

		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=options&oID='.$_POST['oID'].'&pID='.$products['products_id'].'&opID='.$_POST['opID']));
		break;

	case 'payment_edit' : // Zahlung Anfang
		$sql_data_array = array ('payment_method' => xtc_db_prepare_input($_POST['payment']), 'payment_class' => xtc_db_prepare_input($_POST['payment']),);
		xtc_db_perform(TABLE_ORDERS, $sql_data_array, 'update', 'orders_id = \''.xtc_db_input($_POST['oID']).'\'');

		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=other&oID='.$_POST['oID']));
		break;

	case 'shipping_edit' : // Versandkosten
		$module = $_POST['shipping'].'.php';
		require (DIR_FS_LANGUAGES.$order->info['language'].'/modules/shipping/'.$module);
		$shipping_text = constant(MODULE_SHIPPING_.strtoupper($_POST['shipping'])._TEXT_TITLE);
		$shipping_class = $_POST['shipping'].'_'.$_POST['shipping'];

		$text = $xtPrice->xtcFormat($_POST['value'], true);

		$sql_data_array = array ('orders_id' => xtc_db_prepare_input($_POST['oID']), 'title' => xtc_db_prepare_input($shipping_text), 'text' => xtc_db_prepare_input($text), 'value' => xtc_db_prepare_input($_POST['value']), 'class' => 'ot_shipping');

		$check_shipping_query = xtc_db_query("select class from ".TABLE_ORDERS_TOTAL." where orders_id = '".$_POST['oID']."' and class = 'ot_shipping'");
		if (xtc_db_num_rows($check_shipping_query)) {
			xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array, 'update', 'orders_id = \''.xtc_db_input($_POST['oID']).'\' and class="ot_shipping"');
		} else {
			xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
		}

		$sql_data_array = array ('shipping_method' => xtc_db_prepare_input($shipping_text), 'shipping_class' => xtc_db_prepare_input($shipping_class),);
		xtc_db_perform(TABLE_ORDERS, $sql_data_array, 'update', 'orders_id = \''.xtc_db_input($_POST['oID']).'\'');

		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=other&oID='.$_POST['oID']));
		break;

	case 'ot_edit' : // OT Modul
		$check_total_query = xtc_db_query("select orders_total_id from ".TABLE_ORDERS_TOTAL." where orders_id = '".$_POST['oID']."' and class = '".$_POST['class']."'");
		if (xtc_db_num_rows($check_total_query)) {

			$check_total = xtc_db_fetch_array($check_total_query);

			$text = $xtPrice->xtcFormat($_POST['value'], true);

			$sql_data_array = array ('title' => xtc_db_prepare_input($_POST['title']), 'text' => xtc_db_prepare_input($text), 'value' => xtc_db_prepare_input($_POST['value']),);
			xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array, 'update', 'orders_total_id = \''.xtc_db_input($check_total['orders_total_id']).'\'');

		} else {

			$text = $xtPrice->xtcFormat($_POST['value'], true);

			$sql_data_array = array ('orders_id' => xtc_db_prepare_input($_POST['oID']), 'title' => xtc_db_prepare_input($_POST['title']), 'text' => xtc_db_prepare_input($text), 'value' => xtc_db_prepare_input($_POST['value']), 'class' => xtc_db_prepare_input($_POST['class']), 'sort_order' => xtc_db_prepare_input($_POST['sort_order']),);

			xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
		}

		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=other&oID='.$_POST['oID']));
		break;

	case 'lang_edit' : // Sprachupdate
		$lang_query = xtc_db_query("select languages_id, name, directory from ".TABLE_LANGUAGES." where languages_id = '".$_POST['lang']."'");
		$lang = xtc_db_fetch_array($lang_query);

		$order_products_query = xtc_db_query("select orders_products_id , products_id from ".TABLE_ORDERS_PRODUCTS." where orders_id = '".$_POST['oID']."'");
		while ($order_products = xtc_db_fetch_array($order_products_query)) {

			$products_query = xtc_db_query("select products_name from ".TABLE_PRODUCTS_DESCRIPTION." where products_id = '".$order_products['products_id']."' and language_id = '".$_POST['lang']."' ");
			$products = xtc_db_fetch_array($products_query);

			$sql_data_array = array ('products_name' => xtc_db_prepare_input($products['products_name']));
			xtc_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array, 'update', 'orders_products_id  = \''.xtc_db_input($order_products['orders_products_id']).'\'');
		};

		$order_total_query = xtc_db_query("select orders_total_id, title, class from ".TABLE_ORDERS_TOTAL." where orders_id = '".$_POST['oID']."'");
		while ($order_total = xtc_db_fetch_array($order_total_query)) {

			require (DIR_FS_LANGUAGES.$lang['directory'].'/modules/order_total/'.$order_total['class'].'.php');
			$name = str_replace('ot_', '', $order_total['class']);
			$text = constant(MODULE_ORDER_TOTAL_.strtoupper($name)._TITLE);

			$sql_data_array = array ('title' => xtc_db_prepare_input($text));
			xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array, 'update', 'orders_total_id  = \''.xtc_db_input($order_total['orders_total_id']).'\'');
		}

		$sql_data_array = array ('language' => xtc_db_prepare_input($lang['directory']));
		xtc_db_perform(TABLE_ORDERS, $sql_data_array, 'update', 'orders_id  = \''.xtc_db_input($_POST['oID']).'\'');

		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=other&oID='.$_POST['oID']));
		break;

	case 'curr_edit' : // Währungswechsel
		$curr_query = xtc_db_query("select currencies_id, title, code, value from ".TABLE_CURRENCIES." where currencies_id = '".$_POST['currencies_id']."' ");
		$curr = xtc_db_fetch_array($curr_query);

		$old_curr_query = xtc_db_query("select currencies_id, title, code, value from ".TABLE_CURRENCIES." where code = '".$_POST['old_currency']."' ");
		$old_curr = xtc_db_fetch_array($old_curr_query);

		$sql_data_array = array ('currency' => xtc_db_prepare_input($curr['code']),'currency_value'=>xtc_db_prepare_input($curr['value']));
		xtc_db_perform(TABLE_ORDERS, $sql_data_array, 'update', 'orders_id  = \''.xtc_db_input($_POST['oID']).'\'');

		// Produkte
		$order_products_query = xtc_db_query("select orders_products_id , products_id, products_price, final_price from ".TABLE_ORDERS_PRODUCTS." where orders_id = '".$_POST['oID']."'");
		while ($order_products = xtc_db_fetch_array($order_products_query)) {

			if ($old_curr['code'] == DEFAULT_CURRENCY) {
				$xtPrice = new xtcPrice($curr['code'], $order->info['status']);
				$products_price = $xtPrice->xtcGetPrice($order_products['products_id'], false, '', '', $order_products['products_price'], '', $order->customer['ID']);
				$final_price = $xtPrice->xtcGetPrice($order_products['products_id'], false, '', '', $order_products['final_price'], '', $order->customer['ID']);
			} else {
				$xtPrice = new xtcPrice($old_curr['code'], $order->info['status']);
				$p_price = $xtPrice->xtcRemoveCurr($order_products['products_price']);
				$f_price = $xtPrice->xtcRemoveCurr($order_products['final_price']);
				$xtPrice = new xtcPrice($curr['code'], $order->info['status']);
				$products_price = $xtPrice->xtcGetPrice($order_products['products_id'], false, '', '', $p_price, '', $order->customer['ID']);
				$final_price = $xtPrice->xtcGetPrice($order_products['products_id'], false, '', '', $f_price, '', $order->customer['ID']);
			}
			$sql_data_array = array ('products_price' => xtc_db_prepare_input($products_price), 'final_price' => xtc_db_prepare_input($final_price));

			xtc_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array, 'update', 'orders_products_id  = \''.xtc_db_input($order_products['orders_products_id']).'\'');
		};

		$order_total_query = xtc_db_query("select orders_total_id, value from ".TABLE_ORDERS_TOTAL." where orders_id = '".$_POST['oID']."'");
		while ($order_total = xtc_db_fetch_array($order_total_query)) {

			if ($old_curr['code'] == DEFAULT_CURRENCY) {

				$xtPrice = new xtcPrice($curr['code'], $order->info['status']);

				$value = $xtPrice->xtcGetPrice('', $format = false, '', '', $order_total['value'], '', $order->customer['ID']);

			} else {

				$xtPrice = new xtcPrice($old_curr['code'], $order->info['status']);

				$nvalue = $xtPrice->xtcRemoveCurr($order_total['value']);

				$xtPrice = new xtcPrice($curr['code'], $order->info['status']);

				$value = $xtPrice->xtcGetPrice('', $format = false, '', '', $nvalue, '', $order->customer['ID']);
			}

			$text = $text = $xtPrice->xtcFormat($value, true);
			$sql_data_array = array ('text' => xtc_db_prepare_input($text), 'value' => xtc_db_prepare_input($value));
			xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array, 'update', 'orders_total_id  = \''.xtc_db_input($order_total['orders_total_id']).'\'');
		};

		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=other&oID='.$_POST['oID']));
		break;

	case 'product_delete' : // Löschen eines Artikels aus der Bestellung

		if(STOCK_LIMITED == 'true') {
		    $product_query = xtc_db_query("SELECT
		    									p.products_id,
		    									p.products_status,
		    									p.products_quantity
		    								FROM
		    									" . TABLE_ORDERS_PRODUCTS . " op,
		    									" . TABLE_PRODUCTS . " p
		    								WHERE
		    									p.products_id = op.products_id
		    								AND
		    									orders_products_id = '" . (int)$_POST['opID']."'");

		    $product = xtc_db_fetch_array($product_query);

		    $old_quantity_query = xtc_db_query("SELECT products_quantity FROM " . TABLE_ORDERS_PRODUCTS . " WHERE orders_products_id='" . (int)xtc_db_input($_POST['opID'])."'");
		    $old_quantity = xtc_db_fetch_array($old_quantity_query);

		    $new_quantity = $old_quantity['products_quantity'];
		    xtc_db_query("UPDATE " . TABLE_PRODUCTS . " SET products_quantity=products_quantity+" . $new_quantity . " WHERE products_id='" . $product['products_id']."'");

		    if(STOCK_ALLOW_CHECKOUT == 'false' && $product['products_status'] == '0' && ($product['products_quantity'] + $new_quantity) > 0)
		        xtc_db_query("update ".TABLE_PRODUCTS." set products_status = 1 where products_id = " . $product['products_id']);
		}

		xtc_db_query("DELETE FROM
							".TABLE_ORDERS_PRODUCTS_ATTRIBUTES."
						WHERE
							orders_products_id = '".xtc_db_input($_POST['opID'])."'");

		xtc_db_query("DELETE FROM
							".TABLE_ORDERS_PRODUCTS."
						WHERE
							orders_id = '".xtc_db_input($_POST['oID'])."'
						AND
							orders_products_id = '".xtc_db_input($_POST['opID'])."'");

		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=products&oID='.$_POST['oID']));
		break;

	case 'product_option_delete' : // Löschen einer Artikeloption aus der Bestellung
		xtc_db_query("delete from ".TABLE_ORDERS_PRODUCTS_ATTRIBUTES." where orders_products_attributes_id = '".xtc_db_input($_POST['opAID'])."'");

		$products_query = xtc_db_query("select op.products_id, op.products_quantity, p.products_tax_class_id from ".TABLE_ORDERS_PRODUCTS." op, ".TABLE_PRODUCTS." p where op.orders_products_id = '".$_POST['opID']."' and op.products_id = p.products_id");
		$products = xtc_db_fetch_array($products_query);

		$products_a_query = xtc_db_query("select options_values_price, price_prefix from ".TABLE_ORDERS_PRODUCTS_ATTRIBUTES." where orders_products_id = '".$_POST['opID']."'");
		while ($products_a = xtc_db_fetch_array($products_a_query)) {
			$options_values_price += $products_a['price_prefix'].$products_a['options_values_price'];
		};

		$products_old_price = $xtPrice->xtcGetPrice($products['products_id'], $format = false, $products['products_quantity'], '', '', '', $order->customer['ID']);

		$products_price = ($products_old_price + $options_values_price);

		$price = $xtPrice->xtcGetPrice($products['products_id'], $format = false, $products['products_quantity'], $products['products_tax_class_id'], $products_price, '', $order->customer['ID']);

		$final_price = $price * $products['products_quantity'];

		$sql_data_array = array ('products_price' => xtc_db_prepare_input($price));
		$update_sql_data = array ('final_price' => xtc_db_prepare_input($final_price));
		$sql_data_array = xtc_array_merge($sql_data_array, $update_sql_data);
		xtc_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array, 'update', 'orders_products_id = \''.xtc_db_input($_POST['opID']).'\'');

		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=options&oID='.$_POST['oID'].'&pID='.$products['products_id'].'&opID='.$_POST['opID']));
		break;

	case 'ot_delete' : // Löschen eines OT Moduls aus der Bestellung
		xtc_db_query("delete from ".TABLE_ORDERS_TOTAL." where orders_total_id = '".xtc_db_input($_POST['otID'])."'");
		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=other&oID='.$_POST['oID']));
		break;

}

require(DIR_WS_INCLUDES.'metatag.php');
?>
</style>
</head>
<body>
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<div id="wrapper">
	<table class="outerTable" cellspacing="0" cellpadding="0">
		<tr>
			<td width="100%" height="100%" valign="top" class="centerBox">
				<table border="0" width="100%" cellspacing="0" cellpadding="0" class="boxCenter">
					<tr>
						<td valign="top">
							<table class="table_pageHeading" border="0" width="100%" cellspacing="0" cellpadding="0">
								<tr>
									<td class="pageHeading"><?php echo TABLE_HEADING;?></td>
								</tr>
							</table>
							<?php
							if ($_GET['text'] == 'address') { ?>
								<table border="0" width="100%" cellspacing="0" cellpadding="2">
									<tr>
										<td class="main">
										<b>
											<?php
												echo TEXT_EDIT_ADDRESS_SUCCESS;
											?>
										</b>
										</td>
									</tr>
								</table>
							<?php
							}
							if ($_GET['edit_action'] == 'address') {
								include ('orders_edit_address.php');
							}
							elseif ($_GET['edit_action'] == 'products') {
								include ('orders_edit_products.php');
							}
							elseif ($_GET['edit_action'] == 'other') {
								include ('orders_edit_other.php');
							}
							elseif ($_GET['edit_action'] == 'options') {
								include ('orders_edit_options.php');
							}
							?>
					</td>
					<?php
					$order = new order($_GET['oID']);
					$heading = array ();
					$contents = array ();
					switch ($_GET['action']) {
					default :
						if(is_object($order)) {
							$heading[] = array ('text' => '<b>'.TABLE_HEADING_ORDER.$_GET['oID'].'</b>');

							$contents[] = array ('align' => 'center', 'text' => '<br />'.TEXT_EDIT_ADDRESS.'<br /><a class="button" onClick="this.blur();" href="'.xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=address&oID='.$_GET['oID']).'">'.BUTTON_EDIT.'</a><br /><br />');
							$contents[] = array ('align' => 'center', 'text' => '<br />'.TEXT_EDIT_PRODUCTS.'<br /><a class="button" onClick="this.blur();" href="'.xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=products&oID='.$_GET['oID']).'">'.BUTTON_EDIT.'</a><br /><br />');
							$contents[] = array ('align' => 'center', 'text' => '<br />'.TEXT_EDIT_OTHER.'<br /><a class="button" onClick="this.blur();" href="'.xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=other&oID='.$_GET['oID']).'">'.BUTTON_EDIT.'</a><br /><br />');

						}
						break;
					}

					if ((xtc_not_null($heading)) && (xtc_not_null($contents))) {
					echo '            <td width="20%" valign="top">'."\n";

					$box = new box;
					echo $box->infoBox($heading, $contents);

					echo '            </td>'."\n";
					}
					?>
				</tr>
			</table>
			<table border="0" width="100%" cellspacing="0">
				<tr class="dataTableRow">
					<td class="dataTableContent" align="right">
					<?php
						echo TEXT_SAVE_ORDER;
						echo xtc_draw_form('save_order', FILENAME_ORDERS_EDIT, 'action=save_order', 'post');
						echo xtc_draw_hidden_field('customers_status_id', $address[customers_status]);
						echo xtc_draw_hidden_field('oID', $_GET['oID']);
						echo xtc_draw_hidden_field('cID', $_GET[cID]);
						echo '<input type="submit" class="button" onClick="this.blur();" value="'.BUTTON_SAVE.'"/>';
						echo '</form>';
					?>
					</td>
				</tr>
			</table>
		</td>
		</tr>
	</table>
 </div>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>