<?php
require_once("includes/application_top.php");
/**
 * Prft die Captchas
 *****************************************
 * @param string:	$codeCaptcha		Gehashtes Captcha
 * @param string:	$stringCaptcha		Usereingabe
 * @param string:	$dir				Das Captcha-Verzeichnis (tmp)
 * @param integer:	$delFile			Zeit in Minuten, nachdem ein Captcha gelscht wird
 *
 * @return	bool						TRUE / FALSE			
 */
function VerifyCaptchaCode($codeCaptcha, $stringCaptcha, $dir, $delFile = 5)
{
	//check als erstes FALSE
	$captchaTrue = FALSE;
	
	// den hash-pruefen
	if(!preg_match('/^[a-f0-9]{32}$/', $codeCaptcha))
		return FALSE;
	
	// captcha-var pruefen
	if(!preg_match('/^[a-zA-Z0-9]{1,6}$/', $stringCaptcha))
		return FALSE;
	
	// das verzeichnis u. alle darin enthaltenen dateien lschen
	$fHandle = @opendir($dir);
	while (false !== ($file = readdir($fHandle))) 
	{
		if (preg_match("=^\.{1,2}$=", $file))
			continue;
    
		if (is_dir($dir.$file))
		   continue;
		else
		{
			$lastTime = ceil((time() - filemtime($dir.$file)) / 60);
			if($lastTime > $delFile)
			{
				if((strtolower($file) != "index.html") && (strtolower($file) != ".htaccess"))
					unlink($dir.$file);
			}
			else
			{
				if(strtolower($file) == strtolower($codeCaptcha.'_'.$stringCaptcha.'.png'))
					$captchaTrue = TRUE;
				if (preg_match("=^$codeCaptcha=i", $file))
					unlink($dir.$file); 
			}
		}
	}	
	@closedir($fHandle);

	if ($captchaTrue)
		return TRUE;
	else
		return FALSE;
}

// tmp-verz der captchas
$captchaDir = DIR_FS_CAPTCHA_CHECK;

// alte captcha-bilder nach n minuten lschen
$delFile = 2;

// ueberpruefung
$resultCaptcha = VerifyCaptchaCode($_POST["codeCaptcha_ask"], $_POST["stringCaptcha_ask"], $captchaDir, $delFile);

?>