<?php
/*
	Accessories for Xtcommerce 3.04SP2.1
	Copyright (c) 2006 Sergej Stroh
	www.southbridge.de
	
	v1.0	2006-11-04
*/

	$module_smarty = new Smarty;
	$module_smarty->assign('tpl_path', 'templates/'.CURRENT_TEMPLATE.'/');


	if($product->getAccessoriesCount() > 0) {
		$products_accessories_query = xtDBquery("SELECT 
				p.products_id, 
				p.products_model,
				p.products_image,
				p.products_tax_class_id,
				p.products_price,
				p.products_vpe_status,
				p.products_vpe_value,
				p.products_vpe,
				pd.products_name,
				pd.products_short_description				
					FROM ".TABLE_PRODUCTS." p, 
						".TABLE_PRODUCTS_DESCRIPTION." pd,
						".TABLE_ACCESSORIES." a, 
						".TABLE_ACCESSORIES_PRODUCTS." ap 
						where a.head_product_id = '".$product->data['products_id']."' 
						and a.id = ap.accessories_id
						AND ap.product_id = p.products_id 
						AND p.products_id = pd.products_id 
						AND pd.language_id = '".(int)$_SESSION['languages_id']."' 
							ORDER BY a.id ASC");
	
		$accessories_data = array();
		
		while($products_accessories = xtc_db_fetch_array($products_accessories_query)) {
			
			$products_price = $xtPrice->xtcGetPrice($products_accessories['products_id'], true, 1, $products_accessories['products_tax_class_id'], $products_accessories['products_price'], 1);
			if(PRICE_AS_IMAGE == 'true')
				$price = $products_price;
			else
				$price = $products_price['formated'];
			$image = '';
			if ($products_accessories['products_image'] != ''){
				$image = DIR_WS_THUMBNAIL_IMAGES.$products_accessories['products_image'];
			}
			
			if($products_accessories['products_vpe_status'] == 1 && $products_accessories['products_vpe_value'] != 0.0 && $products_price['plain'] > 0)
				$vpe = $xtPrice->xtcFormat($products_price['plain'] * (1 / $products_accessories['products_vpe_value']), true).TXT_PER.xtc_get_vpe_name($products_accessories['products_vpe']);
			
			if ($_SESSION['customers_status']['customers_status_show_price'] != 0) {
				$tax_rate = $xtPrice->TAX[$products_accessories['products_tax_class_id']];				
				$tax_info = $main->getTaxInfo($tax_rate);
			}
			
			$accessories_data[] = array(
				'PRODUCTS_NAME' 	=> $products_accessories['products_name'], 
				'PRODUCTS_ID'		=> xtc_draw_selection_field('products_id[]', 'checkbox', $products_accessories['products_id']),
				'PRODUCTS_VPE' 		=> $vpe, 
				'PRODUCTS_IMAGE' 	=> $image, 
				'PRODUCTS_LINK' 	=> xtc_href_link(FILENAME_PRODUCT_INFO, xtc_product_link($products_accessories['products_id'], $products_accessories['products_name'])), 
				'PRODUCTS_PRICE' 	=> $price, 
				'PRODUCTS_TAX_INFO' => $tax_info, 
				'PRODUCTS_SHORT_DESCRIPTION' => $products_accessories['products_short_description']);
		}


	$module_smarty->assign('language', $_SESSION['language']);
	$module_smarty->assign('accessories', $accessories_data);

	$module_smarty->caching = 0;
	$module = $module_smarty->fetch(CURRENT_TEMPLATE.'/module/accessories.html');

	$info_smarty->assign('MODULE_accessories', $module);
}
?>