<?php 
require_once('includes/application_top.php');
$err = array();	//for debugging
$codeCaptcha = $_SESSION['vvcode_ask'];
$err[0] = $codeCaptcha;	

/**
* Erstellt ein feld aus zahlen, gross- und kleinbuchstaben
*	ausgeschlossen:
* 	i, I, l, L, o, O, 1, 0
* @return array: Liefert Datenfeld aus Lettern und Zahlen
*/ 
function createCipherString()
{
	// grossbuchstaben
	for ($i = 65; $i <= 90; $i++)
	{
		if($i != 73 && $i != 76 && $i != 79)
			$abcStr[] = chr($i);
	}

	// kleinbuchstaben
	for ($i = 97; $i <= 122; $i++) {
	   if($i != 105 && $i != 108 && $i != 111)
		$abcStr[] = chr($i);
	}

	// Zahlen erzeugen
	for ($i = 48; $i <= 57; $i++) {
	if($i != 48 && $i != 49)
		$abcStr[] = chr($i);
	}

	return $abcStr;
}

/**
* Erstellt einen Auenrahmen um das Captcha-Bild
*
* @param		integer		$imgWidth			Breite des Bildes
* @param		integer		$imgHeight		Hhe des Bildes
* @param		resource  $im						Zeiger auf das Bild
* @param		array		  $color				Farbwerte im RGB-Format
*
* @return	void			
*/
function createImageBorder($imgWidth,$imgHeight,$im,$color)
{
imageline($im,0,0,$imgWidth,0,$color); 
imageline($im,0,$imgHeight-1,$imgWidth,$imgHeight-1,$color);
imageline($im,0,0,0,$imgHeight,$color);  
imageline($im,$imgWidth-1,0,$imgWidth-1,$imgHeight,$color);
}
/**
* Erstellt den Farbverlauf im Captcha-Bild
*
* @param		array			$fromRGB			Farbwerte im RGB-Format
* @param		array			$toRGB				Farbwerte im RGB-Format
* @param		integer	  $imgHeight		Bildhhe
*
* @return	array 		Gibt ein Array fr den Farbverlauf zurck			
*/
function createVerticalGradient($fromRGB,$toRGB,$imgHeight)
{
	$diffR = ($fromRGB[0]-$toRGB[0]); //38
	$diffG = ($fromRGB[1]-$toRGB[1]); //133
	$diffB = ($fromRGB[2]-$toRGB[2]); // -6

	$maxR = $diffR / $imgHeight; // 0.475
	$maxG = $diffG / $imgHeight; // 1,66
	$maxB = $diffB / $imgHeight; // 0.075

	$maxNR = $maxR;
	$maxNG = $maxG;
	$maxNB = $maxB;

	for($i=0;$i<$imgHeight;$i++)
	{
		$color['r'][$i] = abs($fromRGB[0] - $maxR);
		$color['g'][$i] = abs($fromRGB[1] - $maxG);
		$color['b'][$i] = abs($fromRGB[2] - $maxB);
		$maxR += $maxNR;
		$maxG += $maxNG;
		$maxB += $maxNB;
	}

	return $color;	
}
/**
* Rechenaufgabe
*****************************************************************
* @param resource:	$im			Zeiger auf das Bild
* @param integer:	$size		Schriftgrsse
* @param string:	$fileTTF	Pfad zur True-Type-Datei
* @param integer:	$imgHeight	Bildhhe
*
* @return string:	Gibt Rechenaufgabe fr den Namen der Datei zurueck.			
*/
function createArrithmeticalCaptcha($im, $size, $fileTTF, $imgHeight)
{
	$mathArr = range(0,9);
	shuffle($mathArr);

	$mix = range(0,120);
	shuffle($mix);

	$color =	imagecolorallocate($im,$mix[0],$mix[1],$mix[2]);

	$text = "$mathArr[0] + $mathArr[1] + $mathArr[2] + $mathArr[3] + $mathArr[4]";
	$fileName = $mathArr[0] + $mathArr[1] + $mathArr[2] + $mathArr[3] + $mathArr[4];
	$y = range($size+5,$imgHeight-10);
	shuffle($y);

	imagettftext($im, $size, 0, 5, $y[0], $color, $fileTTF,$text);
	return $fileName;	
}

/**
* Erzeugt die Buchstaben und Zahlen
*
* @param		resource 	$im					Zeiger auf das Bild
* @param		integer		$size				Schriftgrsse
* @param		string	  $fileTTF		Pfad zur True-Type-Datei
* @param		integer	  $imgHeight	Bildhhe
* @param		integer	  $imgWidth		Bildbreite
*
* @return	string 		Gibt den String fr den Dateinamen wieder			
*/
function createLetterCaptcha($im, $size, $fileTTF, $imgHeight, $imgWidth)
{	
	//Wortliste erstellen
	$abcStr = createCipherString();

	// Array des Alphabets durchwrfeln
	shuffle($abcStr); 

	$mix = range(0,255);
	shuffle($mix);

	$colors=array(
				imagecolorallocate($im,$mix[0],$mix[6],$mix[12]),
				imagecolorallocate($im,$mix[1],$mix[7],$mix[13]),
				imagecolorallocate($im,$mix[2],$mix[8],$mix[14]),
				imagecolorallocate($im,$mix[3],$mix[9],$mix[15]),
				imagecolorallocate($im,$mix[4],$mix[10],$mix[16]),
				imagecolorallocate($im,$mix[5],$mix[11],$mix[17])
				);

	// Zeichnet die Buchstaben und baut den Dateinamen auf
	for($i=0;$i<6;$i++)
	{
		$angel = rand(-25,25);
		$y = rand($size,$imgHeight-20);
		imagettftext($im, $size, $angel, $next, $y, $colors[$i], $fileTTF,$abcStr[$i]);
		$next += $size + ($imgWidth/$size);
		$fileName .= $abcStr[$i];
	}

	return $fileName;
}

// TTF-Schriften
$ttfArr = array();
if ($dir = opendir(DIR_WS_INCLUDES.'fonts/'))
{
	while  (($file = readdir($dir)) !== false)
	{
		if (is_file(DIR_WS_INCLUDES.'fonts/'.$file) and (strstr(strtoupper($file),'.TTF')))
			$ttfArr[] = DIR_FS_CATALOG.'includes/fonts/'.$file;
	}
	closedir($dir);
}
$rnd = rand(0, sizeof($ttfArr));
if(is_file($ttfArr[$rnd]))
	$fileTTF = $ttfArr[$rnd];	
else
	$fileTTF = $ttfArr[0];
	
// tmp-verzeichnis fr die captchs
$captchaDir = DIR_FS_CAPTCHA_MAKE;

$err[3] = $captchaDir;

// schriftgre
$size = 30;

// schriftgre addition
$sizeMath = 22;

//bildgroesse
$imgWidth = 220;//200
$imgHeight = 80;//80


// vertikaler gradient(rgb-Werte: start - Ende)
$fromRGB = array(67, 97, 131);//rgb(67, 97, 131)
$toRGB = array(243,242,242);

// randfarbe (rgb)
$colorBorder = array(46,46,46);

#################################### bild erzeugen ########################################

header("Content-type: image/png");

$im = @imagecreate($imgWidth, $imgHeight) or die("GD! Initialisierung fehlgeschlagen");

// Definiert die Farbe fr den Border
$colorB = imagecolorallocate($im,$colorBorder[0],$colorBorder[1],$colorBorder[2]);

// Erstellt den Farbverlauf
$colorRGB = createVerticalGradient($fromRGB,$toRGB,$imgHeight);

for($i=0; $i<$imgHeight; $i++)
{
	$r = $colorRGB['r'][$i];
	$g = $colorRGB['g'][$i];
	$b = $colorRGB['b'][$i];
	$color = imagecolorallocate($im,$r,$g,$b);
	imageline($im,0,$i,$imgWidth,$i,$color);
}

//if(bcmod(time(), 2) == 0)
if((time() % 2) == 0)
	$fileName = createLetterCaptcha($im, $size, $fileTTF, $imgHeight, $imgWidth);
else
	$fileName = createArrithmeticalCaptcha($im, $sizeMath, $fileTTF, $imgHeight);

createImageBorder($imgWidth,$imgHeight,$im,$colorB);

// hash ueberpruefen
if(!preg_match('/^[a-f0-9]{32}$/',$codeCaptcha))
	$codeCaptcha = md5(microtime());

//speichern	
imagepng($im,$captchaDir.'/'.$codeCaptcha.'_'.$fileName.'.png');

imagedestroy($im);

// und ausgeben
readfile($captchaDir.'/'.$codeCaptcha.'_'.$fileName.'.png');
//die debug-werte in die session schreiben
$_SESSION["DBG"] = $err;
?>