<?php

/* --------------------------------------------------------------
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2011 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

function valid_login_new($db, $email, $pass) {
	
    $result = $db->query('
		SELECT COUNT(customers_id) AS cnt
		FROM customers
		WHERE
			customers_email_address = "' . mysqli_real_escape_string($email) . '"  AND
			customers_password		= MD5("' . mysqli_real_escape_string($pass) . '") AND
			customers_status		= 0
	');
    if ($this->mysqli_result($result, 0, 'cnt') == 1)
        return true;

    return false;
}

function valid_login($db, $email, $pass) {
    $result = $db->query('
		SELECT COUNT(customers_id) AS cnt
		FROM customers
		WHERE
			customers_email_address = "' . mysqli_real_escape_string($email) . '"  AND
			customers_password		= MD5("' . mysqli_real_escape_string($pass) . '") AND
			customers_status		= 0
	');
    if ($this->mysqli_result($result, 0, 'cnt') == 1)
        return true;

    return false;
}

function get_source_shop_conf() {
    $filename = '../../includes/configure.php';

    if (file_exists($filename) == false)
        return false;

    $fp = fopen($filename, 'r');
    $content = fread($fp, filesize($filename));
    fclose($fp);

    $regex_path = "/.*define\('DIR_FS_CATALOG', '(.*?)'\)\;.*/s";
    $regex_host = "/.*define\('DB_SERVER', '(.*?)'\)\;.*/s";
    $regex_user = "/.*define\('DB_SERVER_USERNAME', '(.*?)'\)\;.*/s";
    $regex_pass = "/.*define\('DB_SERVER_PASSWORD', '(.*?)'\)\;.*/s";
    $regex_db = "/.*define\('DB_DATABASE', '(.*?)'\)\;.*/s";
    $regex_http = "/.*define\('HTTP_SERVER', '(.*?)'\)\;.*/s";
    $regex_https = "/.*define\('HTTPS_SERVER', '(.*?)'\)\;.*/s";
    $regex_catalog = "/.*define\('DIR_WS_CATALOG', '(.*?)'\)\;.*/s";

    $output_array = array(
        'shop_path' => preg_replace($regex_path, '$1', $content),
        'dbhost' => preg_replace($regex_host, '$1', $content),
        'dbuser' => preg_replace($regex_user, '$1', $content),
        'dbpass' => preg_replace($regex_pass, '$1', $content),
        'dbname' => preg_replace($regex_db, '$1', $content),
        'conf_http' => preg_replace($regex_http, '$1', $content),
        'conf_https' => preg_replace($regex_https, '$1', $content),
        'conf_catalog' => preg_replace($regex_catalog, '$1', $content)
    );
    return $output_array;
}

function set_target_shop_conf($config_array) {
    $filename = '../includes/configure.php';

    if (file_exists($filename) == false)
        return false;

    echo '<b>Pfade anpassen in "' . $filename . '"...</b><br />';
    flush();
    if (is_writable($filename) == false) {
        echo '<font color=red>Datei ist schreibgeschützt. Setzen Sie die Rechte auf 777.</font><br />';
        return false;
    }

    //READ
    $fp = fopen($filename, 'r');
    $content = fread($fp, filesize($filename));
    fclose($fp);

    $regex_http = "/.*define\('HTTP_SERVER', '(.*)'\)\;.*/";
    $regex_https = "/.*define\('HTTPS_SERVER', '(.*)'\)\;.*/";
    $regex_ws_catalog = "/.*define\('DIR_WS_CATALOG', '(.*)'\)\;.*/";

    $regex_doc_root = "/.*define\('DIR_FS_DOCUMENT_ROOT', '(.*)'\)\;.*/";
    $regex_fs_catalog = "/.*define\('DIR_FS_CATALOG', '(.*)'\)\;.*/";

    $content = preg_replace($regex_http, "  define('HTTP_SERVER', '" . $config_array['conf_http'] . "');", $content);
    $content = preg_replace($regex_https, "  define('HTTPS_SERVER', '" . $config_array['conf_https'] . "');", $content);
    $content = preg_replace($regex_ws_catalog, "  define('DIR_WS_CATALOG', '" . $config_array['conf_catalog'] . "');", $content);
    $content = preg_replace($regex_doc_root, "  define('DIR_FS_DOCUMENT_ROOT', '" . $config_array['shop_path'] . "');", $content);
    $content = preg_replace($regex_fs_catalog, "  define('DIR_FS_CATALOG', '" . $config_array['shop_path'] . "');", $content);

    //WRITE
    $fp = fopen($filename, 'w+');
    fwrite($fp, $content);
    fclose($fp);

    $filename = '../admin/includes/configure.php';

    if (file_exists($filename) == false)
        return false;

    echo '<b>Pfade anpassen in "' . $filename . '"...</b><br />';
    flush();
    if (is_writable($filename) == false) {
        echo '<font color=red>Datei ist schreibgeschützt. Setzen Sie die Rechte auf 777.</font><br />';
        return false;
    }

    //READ
    $fp = fopen($filename, 'r');
    $content = fread($fp, filesize($filename));
    fclose($fp);

    $regex_http = "/.*define\('HTTP_SERVER', '(.*)'\)\;.*/";
    $regex_http_catalog = "/.*define\('HTTP_CATALOG_SERVER', '(.*)'\)\;.*/";
    $regex_https = "/.*define\('HTTPS_CATALOG_SERVER', '(.*)'\)\;.*/";
    $regex_doc_root = "/.*define\('DIR_FS_DOCUMENT_ROOT', '(.*)'\)\;.*/";
    $regex_ws_admin = "/.*define\('DIR_WS_ADMIN', '(.*)'\)\;.*/";
    $regex_fs_admin = "/.*define\('DIR_FS_ADMIN', '(.*)'\)\;.*/";
    $regex_ws_catalog = "/.*define\('DIR_WS_CATALOG', '(.*)'\)\;.*/";
    $regex_fs_catalog = "/.*define\('DIR_FS_CATALOG', '(.*)'\)\;.*/";

    $content = preg_replace($regex_http, "  define('HTTP_SERVER', '" . $config_array['conf_http'] . "');", $content);
    $content = preg_replace($regex_http_catalog, "  define('HTTP_CATALOG_SERVER', '" . $config_array['conf_http'] . "');", $content);
    $content = preg_replace($regex_https, "  define('HTTPS_CATALOG_SERVER', '" . $config_array['conf_https'] . "');", $content);
    $content = preg_replace($regex_doc_root, "  define('DIR_FS_DOCUMENT_ROOT', '" . $config_array['shop_path'] . "');", $content);
    $content = preg_replace($regex_ws_admin, "  define('DIR_WS_ADMIN', '" . $config_array['conf_catalog'] . "admin/');", $content);
    $content = preg_replace($regex_fs_admin, "  define('DIR_FS_ADMIN', '" . $config_array['shop_path'] . "admin/');", $content);
    $content = preg_replace($regex_ws_catalog, "  define('DIR_WS_CATALOG', '" . $config_array['conf_catalog'] . "');", $content);
    $content = preg_replace($regex_fs_catalog, "  define('DIR_FS_CATALOG', '" . $config_array['shop_path'] . "');", $content);

    //WRITE
    $fp = fopen($filename, 'w+');
    fwrite($fp, $content);
    fclose($fp);
}

function adopt_customers_status_statics() {
    global $source_db, $target_db;
    $result = $source_db->query('SELECT customers_status_id FROM customers_status');

    while (($row = mysqli_fetch_array($result))) {
        $target_db->query("
			CREATE TABLE IF NOT EXISTS `personal_offers_by_customers_status_" . $row['customers_status_id'] . "` (
			  `price_id` 		int(11) NOT NULL auto_increment,
			  `products_id` 	int(11) NOT NULL default '0',
			  `quantity` 		int(11) default NULL,
			  `personal_offer` 	decimal(15,4) default NULL,
			  PRIMARY KEY (`price_id`)
			) 
		");
        $target_db->query("ALTER TABLE `categories` ADD `group_permission_" . $row['customers_status_id'] . "` TINYINT(1) NOT NULL");
        $target_db->query("ALTER TABLE `products`   ADD `group_permission_" . $row['customers_status_id'] . "` TINYINT(1) NOT NULL");
    }
}

function single_struct_transfer($entity_name, $entity_key) {
    global $source_db, $esHelper_source, $esHelper_target;

    $result = $source_db->query('
		SELECT ' . $entity_key . '
		FROM   ' . $entity_name . '
	');
    if ($result == false)
        return;

    while (($row = mysqli_fetch_array($result))) {
        $full_struct = $esHelper_source->create_entity_struct($entity_name, $entity_key, $row[$entity_key]);
        $esHelper_target->write_entity_struct($full_struct);
    }
}

function language_struct_transfer($entity_name, $entity_key, $lang_key_name = 'language_id') {
    global $source_db, $esHelper_source, $esHelper_target;
    $result_lang = $source_db->query('
		SELECT languages_id
		FROM languages
	');
    while (($row_lang = mysqli_fetch_array($result_lang))) {
        $result = $source_db->query('
			SELECT ' . $entity_key . '
			FROM   ' . $entity_name . '
		');
		if ($result) {
			while (($row = mysqli_fetch_array($result))) {
				$full_struct = $esHelper_source->create_entity_struct($entity_name, $entity_key, $row[$entity_key], $lang_key_name, $row_lang['languages_id']
				);
				$esHelper_target->write_entity_struct($full_struct);
			}
        }
    }
}

function mysqli_result($res, $row, $field=0) { 
	$res->data_seek($row); 
	$datarow = $res->fetch_array(); 
	return $datarow[$field]; 
} 