<?php

/* --------------------------------------------------------------
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2011 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

class OrdersStructGenerator {

    var $shopDB = false;
    var $esHelper = false;
    var $source_orders_id = 0;
    var $include_orders_products = true;
    var $include_orders_products_attributes = true;
    var $include_orders_total = true;

    function __construct($shopDB) {
        $this->shopDB = $shopDB;
        $this->esHelper = new EntityStructHelper($this->shopDB);
    }

    function get_full_struct($source_orders_id) {
        $this->source_orders_id = $source_orders_id;
        $full_struct = $this->esHelper->create_entity_struct('orders', 'orders_id', $this->source_orders_id);
        //ORDERS_PRODUCTS
        if ($this->include_orders_products) {
            $pack = $this->get_pack_orders_products($this->source_orders_id);
            $full_struct->add_struct_pack($pack);
        }
        //ORDERS_PRODUCTS_ATTRIBUTES
        if ($this->include_orders_products_attributes) {
            $pack = $this->get_pack_orders_products_attributes($this->source_orders_id);
            $full_struct->add_struct_pack($pack);
        }
        //ORDERS_TOTAL
        if ($this->include_orders_total) {
            $pack = $this->get_pack_orders_total($this->source_orders_id);
            $full_struct->add_struct_pack($pack);
        }
        return $full_struct;
    }

    function get_pack_orders_products($orders_id) {
        $output_pack = array();
        $sql = '
			SELECT 
				orders_products_id
			FROM 	orders_products
			WHERE orders_id = "' . $orders_id . '"
		';
        //echo 'ccc:'. $sql;

        $result = $this->shopDB->query($sql);
        while (($row = mysqli_fetch_array($result))) {
            $output_pack[] = $this->esHelper->create_entity_struct('orders_products', 'orders_products_id', $row['orders_products_id']);
        }
        return $output_pack;
    }

    function get_pack_orders_products_attributes($orders_id) {
        $output_pack = array();
        $sql = '
			SELECT 
				orders_products_attributes_id
			FROM 	orders_products_attributes
			WHERE orders_id = "' . $orders_id . '"
		';
        $result = $this->shopDB->query($sql);
        while (($row = mysqli_fetch_array($result))) {
            $output_pack[] = $this->esHelper->create_entity_struct('orders_products_attributes', 'orders_products_attributes_id', $row['orders_products_attributes_id']);
        }
        return $output_pack;
    }

    function get_pack_orders_total($orders_id) {
        $output_pack = array();
        $sql = '
			SELECT 
				orders_total_id
			FROM 	orders_total
			WHERE orders_id = "' . $orders_id . '"
		';
        $result = $this->shopDB->query($sql);
        while (($row = mysqli_fetch_array($result))) {
            $output_pack[] = $this->esHelper->create_entity_struct('orders_total', 'orders_total_id', $row['orders_total_id']);
        }
        return $output_pack;
    }
}
