<?php

/* --------------------------------------------------------------
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2011 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

class DatabaseConnection {

    var $db_server = '';
    var $db_username = '';
    var $db_password = '';
    var $db_database = '';
    var $db_socket = '';
    var $db_connection_id = false;
    var $last_mysql_insert_id = false;

    function __construct($server = '', $user = '', $pass = '', $db = '', $link = 'db_link') {
        $this->db_username = $user;
        $this->db_password = $pass;
        $this->db_database = $db;
		$port = isset(explode(':', $server)[1]) && is_numeric(explode(':', $server)[1]) ? (int) explode(':', $server)[1] : null;
		$socket = isset(explode(':', $server)[1]) && !is_numeric(explode(':', $server)[1]) ? explode(':', $server)[1] : null;
		$server = explode(':', $server)[0];
        $this->db_server = $server;
		// $this->db_connection_id = mysqli_connect($this->db_server, $this->db_username, $this->db_password, $this->db_database);
		$this->db_connection_id = ($GLOBALS["___mysqli_ston"] = mysqli_connect($this->db_server, $this->db_username, $this->db_password, $this->db_database, $port, $socket));


	   $success = mysqli_select_db($this->db_connection_id, $this->db_database);
        if ($success == false) {
            die('db connection error');
		}

    }

    function query($sql, $show_sql = false, $show_err = true, $die = false) {
		$result = mysqli_query($this->db_connection_id, $sql);

        if ($show_sql) {
            flush();
        }
        if ($show_err) {
            $error = mysqli_error($this->db_connection_id);
            if ($error != '') {
                // echo '<strong style="color:red">' . $this->db_connection_id . ' SQL-Query: ' . $sql . '</strong><br>';
                echo '<i style="color:red">SQL-Info:  ' . $error . '</i><br>';
                flush();
            }
        }
        if ($die) {
            die();
		}
        if (strtoupper((substr(ltrim($sql), 0, 6))) == 'INSERT') {
            $this->last_mysql_insert_id = mysqli_insert_id($this->db_connection_id);
        }
        return $result;
    }

    function last_insert_id() {
        return $this->last_mysql_insert_id;
    }

    function close() {
        mysqli_close($this->db_connection_id);
    }

}
