<?php
/* --------------------------------------------------------------
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2011 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */
require('includes/init.inc.php');
@ini_set('max_execution_time', '3600'); # 1h max runtine
@ini_set('memory_limit', '256M');       # 256 MB max ram
$target_db_host = DB_SERVER;
$target_db_user = DB_SERVER_USERNAME;
$target_db_password = DB_SERVER_PASSWORD;
$target_db_database = DB_DATABASE;

$_POST = $_SESSION['POST_ARRAY'];

$source_db = new DatabaseConnection($_SESSION['source_db_host'], $_SESSION['source_db_user'], $_SESSION['source_db_password'], $_SESSION['source_db_database']);
$target_db = new DatabaseConnection($target_db_host, $target_db_user, $target_db_password, $target_db_database);

$coo_sql_update = new SQLUpdateBuilder();
$coo_sql_export = new SQLExport();
?>
<!DOCTYPE html>
<html lang="de" class="no-js" dir="ltr">
    <head>
        <title>commerce:seo Import-Assistent v3</title>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link type="text/css" rel="stylesheet" href="../templates/base/css/bootstrap4.css" />
        <link type="text/css" rel="stylesheet" href="stylesheet.css" />
        <script src="//ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
    </head>
    <body>
	<div>
		<script>
			var wait_timeout;
			var scroll_interval;
			scroll_interval = setInterval(update_view, 100);
			$(document).mouseenter(function () {
				clearInterval(scroll_interval);
				if (wait_timeout) {
					clearTimeout(wait_timeout);
				}
			});
			$(document).mouseleave(function () {
				clearInterval(scroll_interval);
				wait_timeout = setTimeout(function () {
					scroll_interval = setInterval(update_view, 100);
				}, 1000);
			});

			function update_view() {
				$(document).scrollTop($(document).height());
			}
		</script>

		<?php
		echo '<div id="messages">';
		echo '<b>Bitte unterbrechen Sie diesen Vorgang auf keinen Fall, es kann ein paar Minuten dauern, je nach Größe der Datenbank!</b>';

		$esHelper_source = new EntityStructHelper($source_db);
		$esHelper_target = new EntityStructHelper($target_db);

		$coo_sql_export->start_export();

		if (isset($_POST['import_customers_status'])) {
			echo '<br><b>Exportiere Kundengruppen...</b><br>';
			flush();
			language_struct_transfer('customers_status', 'customers_status_id');
			adopt_customers_status_statics();
			echo 'Import Kundenstatus komplett<br>';
		}
		if (isset($_POST['import_categories'])) {
			echo '<br><b>Exportiere Kategorien...</b><br>';
			flush();
			single_struct_transfer('categories', 'categories_id');
			language_struct_transfer('categories_description', 'categories_id');
			echo 'Import Kategorien komplett<br>';
		}
		if (isset($_POST['reset_categories_template'])) {
			echo '<br><b>Kategorielisting auf Standard...</b><br>';
			flush();
			$target_db->query("UPDATE categories SET categories_template = 'default'");
			echo 'Kategorielisting auf Standard komplett<br>';
		}
		if (isset($_POST['reset_listing_template'])) {
			echo '<br><b>Artikellisting auf Standard...</b><br>';
			flush();
			$target_db->query("UPDATE categories SET listing_template = 'default'");
			echo 'Artikellisting auf Standard komplett<br>';
		}
		if (isset($_POST['import_accessories'])) {
			echo '<br><b>Exportiere Artikel...</b><br>';
			flush();
			// packaged_products_transfer();
			single_struct_transfer('accessories', 'id');
			single_struct_transfer('accessories_products', 'id');
			echo 'Import Zubehör komplett<br>';
		}
		if (isset($_POST['import_products'])) {
			echo '<br><b>Exportiere Artikel...</b><br>';
			flush();
			packaged_products_transfer();
			single_struct_transfer('products_images', 'image_id');
			single_struct_transfer('reviews', 'reviews_id');
			language_struct_transfer('reviews_description', 'reviews_id', 'languages_id');
			echo 'Import Produkte komplett<br>';
		}
		if (isset($_POST['reset_product_template'])) {
			echo '<br><b>Artikelvorlage auf Standard...</b><br>';
			flush();
			$target_db->query("UPDATE products SET product_template = 'default'");
			echo 'Artikelvorlage auf Standard komplett<br>';
		}
		if (isset($_POST['reset_options_template'])) {
			echo '<br><b>Optionenvorlage auf Standard...</b><br>';
			flush();
			$target_db->query("UPDATE products SET options_template = 'default'");
			echo 'Optionenvorlage auf Standard komplett<br>';
		}
		if (isset($_POST['import_products_options'])) {
			echo '<br><b>Exportiere Artikel-Optionen...</b><br>';
			flush();
			packaged_products_options_transfer();
			single_struct_transfer('products_attributes_download', 'products_attributes_id');
			echo 'Import Optionen komplett<br>';
		}
		if (isset($_POST['import_specials'])) {
			echo '<br><b>Exportiere Sonderangebote...</b><br>';
			flush();
			single_struct_transfer('specials', 'specials_id');
			echo 'Import Specials komplett<br>';
		}
		if (isset($_POST['import_manufacturers'])) {
			echo '<br><b>Exportiere Hersteller...</b><br>';
			flush();
			single_struct_transfer('manufacturers', 'manufacturers_id');
			language_struct_transfer('manufacturers_info', 'manufacturers_id', 'languages_id');
			echo 'Import Hersteller komplett<br>';
		}
		if (isset($_POST['import_xsell'])) {
			echo '<br><b>Exportiere Cross-Selling...</b><br>';
			flush();
			single_struct_transfer('products_xsell', 'ID');
			language_struct_transfer('products_xsell_grp_name', 'products_xsell_grp_name_id');
			echo 'Import Cross-Selling komplett<br>';
		}
		if (isset($_POST['import_customers'])) {
			echo '<br><b>Exportiere Kunden...</b><br>';
			flush();
			packaged_customers_transfer();
			single_struct_transfer('admin_access', 'customers_id');
			echo 'Import Kunden komplett<br>';
		}
		if (isset($_POST['import_personal_offers'])) {
			echo '<br><b>Exportiere Kundengruppen- und Staffelpreise...</b><br>';
			flush();
			for ($i = 0; $i < 20; $i++) {
				single_struct_transfer('personal_offers_by_customers_status_' . $i, 'price_id');
			}
			echo 'Import Staffel komplett<br>';
		}
		if (isset($_POST['import_orders'])) {
			echo '<br><b>Exportiere Bestellungen...</b><br>';
			flush();
			packaged_orders_transfer();
			single_struct_transfer('banktransfer', 'orders_id');
			single_struct_transfer('orders_recalculate', 'orders_recalculate_id');
			single_struct_transfer('orders_products_download', 'orders_products_download_id');
			echo 'Import Bestellungen komplett<br>';
		}
		if (isset($_POST['import_orders_status'])) {
			echo '<br><b>Exportiere Bestellstatus...</b><br>';
			flush();
			language_struct_transfer('orders_status', 'orders_status_id');
			single_struct_transfer('orders_status_history', 'orders_id');
			echo 'Import Order Status komplett<br>';
		}
		if (isset($_POST['import_shipping_status'])) {
			echo '<br><b>Exportiere Lieferstati...</b><br>';
			flush();
			language_struct_transfer('shipping_status', 'shipping_status_id');
			echo 'Import Lieferstati komplett<br>';
		}
		if (isset($_POST['import_vpe_status'])) {
			echo '<br><b>Exportiere Grundpreis...</b><br>';
			flush();
			language_struct_transfer('products_vpe', 'products_vpe_id');
			echo 'Import Grundpreis komplett<br>';
		}
		if (isset($_POST['import_gv'])) {
			echo '<br><b>Exportiere Kupons und Gutscheine...</b><br>';
			flush();
			single_struct_transfer('coupons', 'coupon_id');
			language_struct_transfer('coupons_description', 'coupon_id');
			single_struct_transfer('coupon_email_track', 'unique_id');
			single_struct_transfer('coupon_gv_customer', 'customer_id');
			single_struct_transfer('coupon_email_track', 'unique_id');
			single_struct_transfer('coupon_redeem_track', 'unique_id');
			echo 'Import Kupons und Gutscheine komplett<br>';
		}
		if (isset($_POST['import_basket'])) {
			echo '<br><b>Exportiere Warenkörbe...</b><br>';
			flush();
			single_struct_transfer('customers_basket', 'customers_basket_id');
			single_struct_transfer('customers_basket_attributes', 'customers_basket_attributes_id');
			echo 'Import Warenkörbe komplett<br>';
		}
		if (isset($_POST['import_content_manager'])) {
			echo '<br><b>Exportiere Content-Seiten...</b><br>';
			flush();
			single_struct_transfer('content_manager', 'content_id');
			echo 'Import Content komplett<br>';
		}

		if (isset($_POST['import_blog_content'])) {
			echo '<br><b>Exportiere Blog-Seiten...</b><br>';
			flush();
			language_struct_transfer('blog_categories', 'id', 'language_id');
			language_struct_transfer('blog_items', 'id', 'language_id');
			language_struct_transfer('blog_item_article', 'item_id', 'language_id');
			language_struct_transfer('blog_item_item', 'item_id', 'language_id');
			language_struct_transfer('blog_item_kat', 'item_id', 'language_id');
			language_struct_transfer('blog_item_text', 'item_id', 'language_id');
			language_struct_transfer('blog_start', 'id', 'language_id');
			single_struct_transfer('blog_item_images', 'item_id');
			single_struct_transfer('blog_start_images', 'id');
			echo 'Import Blog komplett<br>';
		}
		if (isset($_POST['import_tagcloud'])) {
			echo '<br><b>Exportiere Tag-Cloud...</b><br>';
			flush();
			language_struct_transfer('tag_to_product', 'id', 'lID');
			echo 'Import Tag-Cloud komplett<br>';
		}
		if (isset($_POST['import_slider'])) {
			echo '<br><b>Exportiere Slider...</b><br>';
			flush();
			language_struct_transfer('cseo_slider_gallery', 'slider_id', 'language_id');
			echo 'Import Slider komplett<br>';
		}
		if (isset($_POST['import_redirects'])) {
			echo '<br><b>Exportiere Umleitungen...</b><br>';
			flush();
			single_struct_transfer('commerce_seo_redirect', 'id');
			echo 'Import Umleitungen komplett<br>';
		}
		if (isset($_POST['newsletter_recipients'])) {
			echo '<br><b>Exportiere Newsletter Abos...</b><br>';
			flush();
			single_struct_transfer('newsletter_recipients', 'mail_id');
			echo 'Import Newsletter Abos komplett<br>';
		}
		$coo_sql_export->stop_export();
		?>
		<br><b>Export abgeschlossen.</b>
		<p id="b_continue">&Uuml;bertragung fortsetzen: <a class="btn btn-success btn-sm" href="run_import.php">Import starten</a></p>
		</div>
	</div>
    </body>
</html>
